;
;
;******************************************************************************
;
;				 MRS BOOTSTRAP
;
; The MRS Bootstrap program is used to load the MRS system in from the 
; disk.  It assumes that it has been called from a PROM bootstrap routine
; that has homed the head on drive 'A' and has initialized all I/O.
; Specifically this program reads logical sectors 2 through 26 from track
; 0, steps the head in one track and reads logical sectors 1 through 23
; from track 1.  When finished it clears register 'C' and jumps to MRS.
;
; One of the major constraining factors on this bootstrap is that it has
; to fit in 128 bytes (1 sector).
;
; This bootstrap was written for a system using a WESTERN DIGITAL 2793
; disk controller which is also software compatible with their 1793
; controller.
;
;******************************************************************************
;
;
;
STRTOS:	EQU	0E000H		;FIRST ADDRESS OCCUPIED BY MRS
T0STRT:	EQU	2		;TRACK 1 STARTING SECTOR #
T1STRT:	EQU	1		;TRACK 1 STARTING SECTOR #
MXSCT0:	EQU	27		;MAXIMUM SECTOR # + 1 TO READ FROM TRACK 0
MXSCT1:	EQU	24		;MAXIMUM SECTOR # + 1 TO READ FROM TRACK 1
MAXTRK:	EQU	1		;MAXIMUM TRACK # TO BE READ
TMDLAY:	EQU	0AH		;TIME DELAY TO WAIT FOR STATUS REGISTER VALID
;
;  DISK CONTROLLER CONSTANTS
;
STATUS:	EQU	50H		;ADDRESS OF DISK CONTROLLER STATUS REGISTER
CMDREG:	EQU	50H		;ADDRESS OF DISK CONTROLLER COMMAND REGISTER
TRKREG:	EQU	51H		;ADDRESS OF DISK CONTROLLER TRACK REGISTER
SCTREG:	EQU	52H		;ADDRESS OF DISK CONTROLLER SECTOR REGISTER
DATREG:	EQU	53H		;ADDRESS OF DISK CONTROLLER DATA REGISTER
BSYMSK:	EQU	81H		;CONTROLLER BUSY STATUS MASK
DRQMSK:	EQU	02H		;CONTROLLER DATA REQUEST STATUS MASK
SCTSIZ:	EQU	128		;SIZE OF A DISK SECTOR
RDCMD:	EQU	80H		;READ SECTOR COMMAND
STPCMD:	EQU	5CH		;STEP-IN HEAD COMMAND
;
	ORG	80H
;
;
BOOT:	LD	A,T0STRT	;STARTING SECTOR # ON TRACK 0
	LD	(SECTOR),A	;INITIALIZE THE NEXT SECTOR WORD
	LD	HL,STRTOS	;STARTING ADDRESS OF THE OPERATING SYSTEM
	LD	D,MXSCT0	;MAXIMUM SECTOR # TO BE READ FROM TRACK 0
	LD	C,DATREG	;ADDRESS OF DISK CONTROLLER DATA REGISTER
;
TRKRD:	IN	A,(STATUS)	;GET THE DISK CONTROLLER STATUS
	AND	A,BSYMSK	;MASK OFF ALL BUT BUSY AND NOT READY BITS
	JR	NZ,TRKRD	;WAIT UNTIL THE DISK CONTROLLER ISN'T BUSY
;
	LD	A,(SECTOR)	;GET THE NEXT SECTOR #
	CP	A,D		;COMPARE IT WITH THE MAXIMUM SECTOR #
	JR	Z,NXTTRK	;IF WE EXCEEDED THE MAXIMUM, GO THE NEXT TRACK
	OUT	(SCTREG),A	;GIVE THE NEXT SECTOR # TO THE DISK CONTROLLER
	INC	A		;INCREMENT THE SECTOR NUMBER
	LD	(SECTOR),A	;AND SAVE IT
	LD	B,SCTSIZ	;NUMBER OF BYTES IN A SECTOR
	LD	A,RDCMD		;READ SECTOR COMMAND BYTE
	OUT	(CMDREG),A	;GIVE THE COMMAND TO THE DISK CONTROLLER
	LD	A,TMDLAY	;TIME DELAY CONSTANT
WTSTAT:	DEC	A		;DECREMENT THE TIME DELAY COUNTER
	JR	NZ,WTSTAT	;LOOP IF THE DELAY ISN'T EXPIRED
;
WTDRQ:	IN	A,(STATUS)	;GET THE DISK CONTROLLER STATUS BYTE
	AND	A,DRQMSK	;MASK OFF ALL BUT THE DATA REQUEST BIT
	JR	Z,WTDRQ		;LOOP UNTIL DATA REQUEST IS TRUE
	INI			;INPUT THE BYTE FROM THE DISK CONTROLLER
	JR	NZ,WTDRQ	;LOOP IF THE WHOLE SECTOR ISN'T IN YET
	JR	TRKRD		;LOOP BACK TO READ NEXT SECTOR ON THE TRACK
;
NXTTRK:	IN	A,(TRKREG)	;FIND OUT WHAT TRACK WE ARE CURRENTLY ON
	CP	A,MAXTRK	;COMPARE WITH THE MAXIMUM TRACK # TO BE READ
	JR	Z,MRSTRT	;START MRS IF THE WHOLE THING IS IN MEMORY
	LD	A,STPCMD	;GET THE STEP HEAD COMMAND
	OUT	(CMDREG),A	;GIVE THE STEP COMMAND TO THE DISK CONTROLLER
	LD	A,TMDLAY	;TIME DELAY CONSTANT FOR DISK STATUS VALID
WTSTA1:	DEC	A		;DECREMENT THE TIME DELAY COUNTER
	JR	NZ,WTSTA1	;LOOP IF THE TIME DELAY ISN'T EXPIRED
	LD	A,T1STRT	;STARTING SECTOR # ON TRACK 1
	LD	(SECTOR),A	;PUT IT IN THE NEXT SECTOR BYTE
	LD	D,MXSCT1	;MAXIMUM # OF SECTORS TO READ FROM TRACK #
	JR	TRKRD		;GO READ THE TRACK INTO MEMORY
;
MRSTRT:	LD	C,0		;CLEAR THE C REGSITER
	JP	STRTOS		;JUMP TO THE BEGINNING OF MRS
;
SECTOR:	DB	0
;
	END	BOOT
