	ASEG
; * * * * *
;
;  TASK RECORD DEFINITION
;
; * * * * *
	ORG	0
TSKSTS:	DS	1		;TASK STATUS (STOP,NEW,ACTIVE)
TSKADR:	DS	2		;TASK ADDRESS (STARTING ADDRESS)
TSKSTK:	DS	2		;TASK STACK (ASSOCIATED STACK)
TSKLNK:	DS	2		;TASK LINK (LINK TO NEXT TASK)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		;TASK STATUS IS STOP
TSKNEW	EQU	1		;TASK STATUS IS NEW
TSKACT	EQU	2		;TASK STATUS IS ACTIVE
; * * * * *
;
;  TASK VARIABLES AND TASK BLOCKS
;
; * * * * *
	ORG	0080H
TSKPTR:	DS	2		;TASK POINTER
TASK1:	DS	TSKSZE		;TASK ONE
TASK2:	DS	TSKSZE		;TASK TWO
TASK3:	DS	TSKSZE		;TASK THREE
; * * * * *
;
;  USER DEFINED STACKS FOR ASSOCIATED TASKS
;
; * * * * *
	DS	59
STACK1:	DS	1		;STACK ONE
	DS	59
STACK2:	DS	1		;STACK TWO
	DS	59
STACK3:	DS	1		;STACK THREE
; * * * * *
;
;  TASK INITIALIZATION
;
; * * * * *
	ORG	8000H
	LDX	#CODE1		;CODE FOR TASK ONE
	STX	TASK1+TSKADR
	LDX	#STACK1		;STACK FOR TASK ONE
	STX	TASK1+TSKSTK
	LDA	#TSKNEW		;NEW TASK
	STA	TASK1+TSKSTS
	LDX	#TASK2
	STX	TASK1+TSKLNK	;LINK TO TASK2
;
	LDX	#CODE2		;CODE FOR TASK TWO
	STX	TASK2+TSKADR
	LDX	#STACK2		;STACK FOR TASK TWO
	STX	TASK2+TSKSTK
	LDA	#TSKNEW		;NEW TASK
	STA	TASK2+TSKSTS
	LDX	#TASK3
	STX	TASK2+TSKLNK	;LINK TO TASK3
;
	LDX	#CODE3		;CODE FOR TASK THREE
	STX	TASK3+TSKADR
	LDX	#STACK3		;STACK FOR TASK THREE
	STX	TASK3+TSKSTK
	LDA	#TSKNEW		;NEW TASK
	STA	TASK3+TSKSTS
	LDX	#TASK1
	STX	TASK3+TSKLNK	;LINK TO TASK1
;
	LDX	#TASK3
	STX	TSKPTR		;TSKPTR = ADDRESS OF TASK3
	BRA	NXTTSK		;START TASK 1
; * * * * *
;
;  SYSTEM TASK SCHEDULER
;  ENTERED VIA CALL FROM ACTIVE TASK
;
; * * * * *
SYSTEM:	ORCC	#01010000B	;DISABLE INTERRUPTS
;
	PSHS	U,Y,X,DP,B,A,CC	;SAVE TASK STATE
; * * * * *
;
;  ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
TSKINT:	LDX	TSKPTR
	STS	TSKSTK,X	;TASK STACK = SP
;
;  NEXT TASK
;
NXTTSK:	LDX	TSKLNK,X
	STX	TSKPTR		;TSKPTR = ADDRESS OF NEXT TASK
;
	LDA	TSKSTS,X
	CMPA	#TSKSTP
	BEQ	NXTTSK		;IF TASK STATUS = STOP THEN  NXTTSK
;
	LDS	TSKSTK,X	;SP = TASK STACK
;
	CMPA	#TSKNEW
	BEQ	NEWTSK		;IF TASK STATUS = NEW THEN  NEWTSK
;
;  RETURN TO ACTIVE TASK
;
	PULS	CC,A,B,DP,X,Y,U	;RESTORE TASK STATE
;
	ANDCC	#10101111B	;ENABLE INTERRUPTS
	RTS			;RETURN TO TASK
;
;  ACTIVATE NEW TASK
;
NEWTSK:	LDX	TSKPTR
	LDA	#TSKACT
	STA	TSKSTS,X	;TASK STATUS = ACTIVE
;
	ANDCC	#10101111B	;ENABLE INTERRUPTS
	JSR	[TSKADR,X]	;ACTIVATE TASK
;
;  DEACTIVATE ACTIVE TASK
;
ENDTSK:	ORCC	#01010000B	;DISABLE INTERRUPTS
;
	LDX	TSKPTR
	LDA	#TSKSTP
	STA	TSKSTS,X	;TASK STATUS = STOP
;
	STS	TSKSTK,X	;TASK STACK = SP
;
	BRA	NXTTSK		;SCHEDULE NEXT TASK
; * * * * *
;
;  USER DEFINED CODE FOR TASK ONE
;
; * * * * *
CODE1:
	LBSR	SYSTEM		;SCHEDULE OTHER TASKS
	BRA	CODE1		;DO TASK AGAIN
; * * * * *
;
;  USER DEFINED CODE FOR TASK TWO
;
; * * * * *
CODE2:
	RTS			;ASSUME TASK COMPLETE
; * * * * *
;
;  USER DEFINED CODE FOR TASK THREE
;  THIS EXAMPLE TASK INITIATES TASK 2 IF IT IS INACTIVE
;
; * * * * *
CODE3:
	LDA	TASK2+TSKSTS
	CMPA	#TSKSTP
	BNE	C3SKP		;IF TASK2 STATUS <> TSKSTP THEN SKIP
	LDA	#TSKNEW
	STA	TASK2+TSKSTS	;TASK2 STATUS = TSKNEW
C3SKP:	LBSR	SYSTEM		;SCHEDULE OTHER TASKS
	BRA	CODE3
	END
                                                                                                       