	ASEG
; * * * * *
;
;  TASK RECORD DEFINITION
;
; * * * * *
SBFLEN	EQU	70		; Space for the 68K's 16 registers + PC + SSR
;
	ORG	0
TSKSTS:	DS	2		; Task STATUS (STOP,NEW,ACTIVE)
TSKADR:	DS	4		; Task ADDRESS (starting address)
TSKSTK:	DS	4		; Task STACK Pointer (associated stack)
TSKLNK:	DS	4		; Task LINK (link to next task's TCB)
TSKSBF:	DS	SBFLEN		; Task STACK BUFFER (for register save/reload)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		; TSKSTS value for STOP
TSKNEW	EQU	1		; TSKSTS value for NEW
TSKACT	EQU	2		; TSKSTS value for ACTIVE
; * * * * *
;
;  TASK VARIABLES AND TASK CONTROL BLOCKS (TCB's)
;
; * * * * *
	ORG	1000H
TSKPTR:	DS	4	 	; Pointer to current task's TCB
TASK1:	DS	TSKSZE		; TCB for task one
TASK2:	DS	TSKSZE		; TCB for task two
TASK3:	DS	TSKSZE		; TCB for task three
; * * * * *
;
;  TCB INITIALIZATION
;
; * * * * *
	ORG	2000H
	MOVEA.L	#TASK1,A0		; Point A0 to Task One's TCB
	MOVE.W	#TSKNEW,TSKSTS(A0)	; Task status = NEW
	MOVE.L	#CODE1,TSKADR(A0)	; Starting address
	MOVEA.L	#TASK2,A1		; Addr of next task's TCB in A1
	MOVE.L	A1,TSKLNK(A0)		; Link TCB
;
	MOVEA.L	A1,A0			; Point A0 to Task Two's TCB
	MOVE.W	#TSKNEW,TSKSTS(A0)	; Task status = NEW
	MOVE.L	#CODE2,TSKADR(A0)	; Starting address
	MOVEA.L	#TASK3,A1		; Addr of next task's TCB in A1
	MOVE.L	A1,TSKLNK(A0)		; Link TCB
;
	MOVEA.L	A1,A0			; Point A0 to Task Three's TCB
	MOVE.W	#TSKNEW,TSKSTS(A0)	; Task status = NEW
	MOVE.L	#CODE3,TSKADR(A0)	; Starting address
	MOVEA.L	#TASK1,A1		; Addr of next task's TCB in A1
	MOVE.L	A1,TSKLNK(A0)		; Link TCB
;
;
	MOVE.L	#SYSTEM,084H		; Provide vectors for TRAP 1 and 2
	MOVE.L	#ENDTSK,088H
;
;
	BRA	NXTTSK			;Start first scan for a task to run
; * * * * *
;
;  SYSTEM TASK SCHEDULER
;
;   (Entered via TRAP instruction and appropriate vector)
;
; * * * * *
SYSTEM:
;
; * * * * *
;
;  ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
TSKINT:
	MOVEM.L	D0/A6,-(A7)		; Stack all user registers
	MOVE	USP,A0			; Including the USP
	MOVE.L	A0,-(A7)
	MOVEA.L	TSKPTR,A0		; Addr of this task's TCB into A0
	MOVE.L	A7,TSKSTK(A0)		; Save system SP for this task
;
;  Next task search
;
NXTTSK:
	MOVEA.L	TSKLNK(A0),A0		; Addr of next TCB in chain into A0
;
	MOVE.W	TSKSTS(A0),D1
	CMP.W	D1,#TSKSTP
;
	BEQ	NXTTSK			; J/ task is stopped
;
	MOVE.L	A0,TSKPTR		; Save addr of candidate TCB
;
	CMP.W	D1,#TSKNEW
	BEQ	NEWTSK			; J/ task is to be initiated
;
	MOVEA.L	TSKSTK(A0),A7		; System stack for this task
	MOVEA.L	(A7)+,A0		; Restore all user registers
	MOVE	A0,USP
	MOVEM	(A7)+,D0/A6
	RTE				; Re-start task
;
;  Initiate new task
;
NEWTSK:
	LEA	TSKSBF+SBFLEN(A0),A7	; Point to top of this task's system
					; stack area
	MOVE.W	#TSKACT,TSKSTS(A0)	; Indicate task is now active
	MOVE.L	TSKADR(A0),-(A7)	; Push starting address on stack
	MOVE.W	#000,-(A7)		; SSR to initiate task
	RTE				; Begin task
;
;  Deactivate an active task
;  (entered via a TRAP instruction)
;
ENDTSK:
	MOVEA.L	TSKPTR,A0		; Point to current task's TCB
	MOVE.W	#TSKSTP,TSKSTS(A0)	; Indicate task has stopped
	BRA	NXTTSK			; Look for next task
; * * * * *
;
;  User provided code for task one
;
; * * * * *
CODE1:
	TRAP	SWITCH			; TRAP to task switch
	BRA	CODE1			; Perform task again
; * * * * *
;
;  User provided code for task two
;
; * * * * *
CODE2:
	MOVEQ	#7,D3			; Do eight switches before completing
C2L01:
	TRAP	SWITCH
	DBF	D3,C2L01
;
	TRAP	COMPLET			; TRAP to end task
; * * * * *
;
;  User provided code for task three
;  (This example initiates task two every third time it is called if
;   task two is inactive)
;
; * * * * *
CODE3:
	MOVEQ	#2,D5			; Loop counter
;
C3L01:
	TRAP	SWITCH			; Relinquish CPU
	DBF	D5,C3L01		; J/ limit not reached
;
	CMPI.W	#TSKSTP,TASK2+TSKSTS
	BNE	CODE3			; J/ task 2 is not stopped
;
	MOVE.W	#TSKNEW,TASK2+TSKSTS	; Re-start task 2
	BRA	CODE3
;
	END
                           