.XLINK
.PABS
.PHEX
;
;
;I/O DRIVERS FOR CPM
;LAST UPDATE 12/15/81
;
BIAS	=	0AC00H

; cpm warm boot load & ccp entry point 

CPMB	=	3400H+BIAS		; ccp entry point
	;
BDOS	=	3C06H+BIAS		; bdos entry point
;
RTYN	=	10			; disk io retries
SEEKRT	=	1			; rate 0=3ms, 1=6ms, 2=10ms, 3=20ms
CDISK 	= 	4			; last disk selected by the ccp
BELL	=	07			; ding
MAXDSK	=	1			; largest disk number
NSECTS	=	25+19			; number of sectors to read
;
CMD	=	0CH			; fdc command & fdc status register	
TK	=	CMD+1			; fdc track register
SECMD	=	CMD+2			; fdc sector register
DAL	=	CMD+3			; fdc data port
WAIT	=	014H			; hardware wait for fdc intrq + drq
					;  & drive select - restore latch
DDCODE	=	0DDH			; double density disk code byte
DOUBLE	=	0CH			; controller double density sel. bit
;
;
BUFF	=	80H			; default dma buffer
;
.LOC	4A00H+BIAS
;
	JMP BOOT			; cold start entry point
WBOOTA:
	JMP WBOOT			; warm start entry point
	JMP CONST			; console status A=ff=ready
	JMP CONIN			; console input  data in A
	JMP CONOUT			; console output data in C
	JMP LIST			; list device    data in C
	JMP PUNCH			; punch device   none
	JMP READER  			; reader device  none
	JMP HOME			; seek home track
	JMP SELDSK			; select disk    disk in C
	JMP SETTRK			; seek track     track in BC
	JMP SETSEC			; set sector     sector in BC
	JMP SETDMA			; set dma        dma in BC
	JMP READ			; read sector
	JMP WRITE			; write sector
 	JMP	LISTST			; return list status A=FF=ready
	JMP	SECTRAN			; sector translate  sector in BC
;
;
BOOT:
	LXI	SP,100H			; load stack in default dma buff
	LXI	H,PRINTBYTE		; clear ram area
	MVI	B,VARLEN		;
CLRLP:
	MVI	M,0
	INX	H
	DJNZ	CLRLP
	LXI	H,SIGNON		; sign on message
	CALL	PMSG
	JMPR 	GOCPM

BOOTERROR:

WBOOT:
	LXI	SP,100H		 	; put stack in default dma buffer

	MVI	C,0			; go select drive 0
	MVI	E,0 			; first time select
	CALL SELDSK
	CALL	HOME			; seek track 0

	MVI	A,NSECTS		; number of sectors to read
	STA	SECCNT			; save in sector counter
	LXI	B,2			; start with sector 2
	LXI	D,0			; track 0
	LXI	H,CPMB		 	; load at cpmb

RBLK1:
	PUSH	B
	PUSH	D
	PUSH	H
	SHLD	IODMA			; set dma address
	SBCD	IOSEC			; set sector
	SDED	IOTK			; set track
	LXI	D,BOOTERROR		; return address on error <cr>
	PUSH	D
	CALL	READ	 		; go read
	POP	D			; discard error return address
	POP	H			; get dma address
	LXI	D,128	 		; bump dma pointer by 1 sectors
	DAD	D
	POP	D
	POP	B
	LDA	SECCNT
	DCR	A			; one less blockr
	STA	SECCNT			; save it
	JRZ	GOCPM			; exit when zero
	INR	C
	MVI	A,26+1
	CMP	C
	JRNZ	RBLK1
	LXI	B,1			; start with sector 1 on track 1
	LXI	D,BOOTERROR		; return addres on error
	PUSH	H
	PUSH	D
	CALL	SETTRK			; go seek
	POP	D			; discard return address
	POP	H
	LXI	D,1			; put track in de
	LXI	B,1
	JMPR	RBLK1			; go read next block
;
GOCPM:
	LXI B,BUFF
	CALL SETDMA	;SET FOR CPM
	MVI A,JMP
	STA 0		;PUT FOR WBOOT
	LXI H,WBOOTA
	SHLD 1
	STA 5		;BDOS JMP
	LXI H,BDOS
	SHLD 6
	LDA CDISK
	MOV C,A		;GIVE TO CPM
	JMP CPMB
;
;******************************************************
;
CONST:
	IN 1
	ANI 1
	MVI A,0
	RZ
	CMA
	RET
CONIN:
	IN	1
	ANI	1
	JRZ	CONIN
	IN	0
	ANI	7FH
	RET
CONOUT:
	IN	1
	ANI	4
	JRZ	CONOUT
	MOV A,C
	OUT	0
	RET
LIST:
	MVI	A,10H
	OUT	3
	IN	3
	ANI	0CH
	CPI	0CH
	JRNZ	LIST
	MOV A,C
	OUT 2
	RET

LISTST:
	MVI	A,10H
	OUT	3
	IN	3			; get status
	ANI	0CH			; printer ready ?
	CPI	0CH
	MVI	A,0FFH			; ready flag
	RZ				; yes return
	CMA		 		; get a zero - not ready
	RET				; not ready

PUNCH:
READER:
	RET
;
;***************************************************
;DISK ROUTINES
;
; errors are in the form of :
;
; DSK ERR aa bb cc dd ee ff gg hh ii jj kk ll
; 
; aa = 00 read, 01 write, 02 seek
; bb = seek status               cc = command status
; dd = dma error                 ee = operation code
; ff = current disk              gg = track low byte
; hh = track high byte           ii = sector low byte
; jj = sector high byte          kk = dma address low byte
; ll = dma address high byte
;
;****************************************************
;
;
;	FIXED DATA TABLES FOR FOUR-DRIVE STANDARD
;	IBM-COMPATIBLE 8" DISKS
;	DISK PARAMETER HEADER FOR DISK 00
DPBASE:	.WORD	TRANS,0000H
	.WORD	0000H,0000H
	.WORD	DIRBF,DPSDBK
	.WORD	CHK00,ALL00
;	DISK PARAMETER HEADER FOR DISK 01
	.WORD	TRANS,0000H
	.WORD 	0000H,0000H
	.WORD	DIRBF,DPSDBK
	.WORD	CHK01,ALL01
;
;	SINGLE DENSITY SECTOR TRANSLATE VECTOR
TRANS:	.BYTE	1,7,13,19	;SECTORS 1,2,3,4
	.BYTE	25,5,11,17	;SECTORS 5,6,7,8
	.BYTE	23,3,9,15	;SECTORS 9,10,11,12
	.BYTE	21,2,8,14	;SECTORS 13,14,15,16
	.BYTE	20,26,6,12	;SECTORS 17,18,19,20
	.BYTE	18,24,4,10	;SECTORS 21,22,23,24
	.BYTE	16,22		;SECTORS 25,26
;
;
DPSDBK:	;DISK PARAMETER BLOCK, COMMON TO ALL DISKS
	.WORD	26		;SECTORS PER TRACK
	.BYTE	3		;BLOCK SHIFT FACTOR
	.BYTE	7		;BLOCK MASK
	.BYTE	0		;NULL MASK
	.WORD	242		;DISK SIZE-1
	.WORD	63		;DIRECTORY MAX
	.BYTE	192		;ALLOC 0
	.BYTE	0		;ALLOC 1
	.WORD	16		;CHECK SIZE
	.WORD	2		;TRACK OFFSET
;
DPDDBK:		;DOUBLE DENSITY PARAMETER BLOCK
	.WORD	51		;SECTORS PER TRACK - SPT
	.BYTE	4		;BLOCK SHIFT FACTOR - BSH
	.BYTE	15		;BLOCK MASK - BLM
	.BYTE	1		;NULL MASK
	.WORD	235		;DISK SIZE IN BLOCKS - DSM
	.WORD	127		;DIRECTORY MAX ENTRIES - DLM
	.BYTE	0C0H		;DIR. ALLOC. MASK - AL0
	.BYTE	0		;DIR. ALLOC. MASK - AL1
	.WORD	32		;DIR. CHECK SIZE - CKS
	.WORD	2		;TRACK OFFSET - OFF

SETSEC:
	SBCD	IOSEC
	RET

SETDMA:
	SBCD	IODMA
	RET

SECTRAN:
	MOV	A,D 
	ORA	E
	MOV	L,C
	MOV	H,B
	INX	H
	RZ
	XCHG
	DAD	B
	MOV	L,M
	MVI	H,0
	RET

HOME:
	LXI	B,0			; track 0

SETTRK:
	SBCD	IOTK			; TRACK

	CALL	DRVSEL

	MVI	A,RTYN			; RETRY COUNT
	STA	RTYC

SEEK:
	LDA	IOTK
	CALL	DENSEL
	LDA IOTK
	MOV C,A
	IN TK			 	;GET TRACK
	SUB C
	RZ		 		;NO SEEK
	MOV A,C
	OUT DAL
	MVI A,1CH ! SEEKRT	 	;STEP
	OUT CMD	 		 	;SEEK
	IN WAIT
	ORA	A			; test intrq bit
	JM	SEEKERR			; if not set then intrq did not happed

	IN CMD		 		;GET STATUS
	STA	SEEKSTATUS
	ANI	10011001B		; only these bits
	RZ				; OK then return

SEEKERR:
	MVI	A,2
	STA	DISKSTATUS

	CALL	DISKERROR		; error return ddress for retry
	JMPR	SEEK

RESTORE:
	STA	RTYC
	IN	CMD
	ANI	00010000B
	RZ
RESTO1:
	MVI A,SEEKRT ! 0CH	;LOAD HEAD RESTORE 
	OUT CMD
TK0WAIT:	
	IN	CMD
	ANI	4			; TRACK 0 BIT
	JRZ	TK0WAIT			; wait untill head moves to track 0

	RET

DISKERROR:

	LDA	RTYC			; 
	DCR	A			; 
	JRNZ	RESTORE

	CALL	PRINTSTATUS
	CALL	CONIN
	CPI	0DH
	MVI	A,RTYN
	STA	RTYC			; 
	MVI	A,1
	RNZ				; return to retry
	POP	D			; throw away error return address
	RET				; return to caller of disk routine
	
PRINTSTATUS:
	LXI	H,ERRMSG		; 
	CALL	PMSG

	LXI	D,DISKSTATUS
	MVI	B,STATLEN		; 
PSTATUS:
	LXI	H,PRINTBYTE		; 
	LDAX	D
	INX	D
	MOV	M,A
	CALL	PHEX
	MVI	C,' '			; 
	CALL	CONOUT
	DJNZ	PSTATUS
	RET

READ:
	MVI	A,08CH			; read with head load
	JMPR	DISKIO			; do disk io

WRITE:
	MVI	A,0ACH			; write with head load

DISKIO:
	STA	OPER			; set disk operation
	CALL	DRVSEL			; select drive now
DSKIO1:
	MVI	A,RTYN
	STA	RTYC			; save in counter
IORETRY:
	LDA	OPER
	MOV	B,A
	MVI	A,0D0H
	OUT	CMD
	XTHL
	XTHL
	XTHL
	XTHL
	IN	CMD
	ANI	020H
	RRC
	RRC
	RRC
	CMA
	ANA	B	
	STA	OPER
	LXI	B,8000H+DAL		; 
	LXI	H,IODONE		; 
	PUSH	H			; 
	LHLD	IODMA			; 
	LDA	IOSEC			; get sector
	OUT	SECMD			; set sector
	LDA	OPER			; get operation
	OUT	CMD
	ANI	0A8H
	CPI	0A8H			; write command ?
	JRZ	WRITELOOP 		; yes goto write loop


READLOOP:
	IN	WAIT			; wait for drq or intrq
	ORA	A			; was it intrq ?
	RP
	INI
	JMPR	READLOOP

WRITELOOP:
	IN	WAIT
	ORA	A
	RP
	OUTI
	JMPR	WRITELOOP

IODONE:
	IN	CMD
	MOV	C,A
	SBCD	CMDSTATUS
	ORA	B			; 
	RZ				; 

	MVI	A,1
	STA	DISKSTATUS

	CALL	DISKERROR
	CALL	SEEK
	ORA	A
	JRZ	IORETRY			; retry
	RET

SELDSK:
	MOV	A,C
	CPI	MAXDSK+1
	JRC	SELOK
SELERR:
	XRA	A
	STA	CDISK
	LXI	H,0
	RET

SELOK:
	MOV A,C
	STA	NEWDSK
	MOV	A,E			; test for first time
	ANI	1
	CZ	DFMT			; define format
	JC	SELERR
SELDPH:
	LDA	NEWDSK
	MVI	H,0
	MOV	L,A
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,DPBASE
	DAD	D
	RET

; select drive and set density
DRVSEL:
	LDA	DISKN
	MOV	C,A
	LDA	NEWDSK
	CMP	C
	RZ
	STA	DISKN
	IN	TK			; get old drive track value
	LXI	H,TRKTBL
	PUSH	H
	MVI	B,0
	DAD	B
	MOV	M,A			; save value
	POP	H
	LDA	NEWDSK
	MOV	C,A
	DAD	B
	MOV	A,M			; get new drive track value
	OUT	TK
	MOV	A,C
	CALL    DENSEL
	LXI	H,8000H			; wait for new drive to settle
DELAY:
	DCX	H
	MOV	A,H
	ORA	L
	JRNZ	DELAY
	RET
; select density using table value, track in acc
DENSEL:
	LXI	H,DENSTB		; point at density table
	MVI	B,0
	ORA	A
	LDA	DISKN
	JZ	DENSLG
	MOV	C,A
	DAD	B
	MOV	A,M			; get density
	ORA	C
DENSLG:
	OUT	WAIT
	RET
; define format of disk in drive (diskn)
DFMT:
	LHLD	IODMA
	SHLD	DMATMP
	LHLD	IOSEC
	SHLD	SECTMP
	CALL	DRVSEL
	CALL	RESTO1
	CALL	HOME
	LXI	B,1
	CALL	SETSEC
	LXI	B,DIRBF
	CALL	SETDMA
	CALL	READ
	ORA	A
	STC				; set error
	RNZ				; exit on error
	LDA	DISKN
	MVI	B,0
	MOV	C,A
	LXI	H,DENSTB
	DAD	B
	LDA	DIRBF+07FH		; get density code
	CPI	DDCODE
	MVI	A,0
	LXI	B,DPSDBK
	LXI	D,TRANS
	JNZ	DSINGL
	MVI	A,DOUBLE
	LXI	B,DPDDBK
	LXI	D,0
DSINGL:
	MOV	M,A			; save in table
	LHLD	DMATMP
	SHLD	IODMA
	LHLD	SECTMP
	SHLD	IOSEC
	PUSH	D
	CALL	SELDPH			; get pointer to dph
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	LXI	D,9
	DAD	D
	MOV	M,C
	INX	H
	MOV	M,B
	XRA	A
	RET

PMSG:
	MOV	A,M
	ORA	A
	RZ
	MOV	C,A
	CALL	CONOUT
	INX	H
	JMPR	PMSG

PHEX:
	CALL	PHEX1

PHEX1:
	XRA	A
	RLD
	CPI	10
	JRC	NINE

	ADI	7

NINE:
	ADI	30H
	MOV	C,A
	JMP	CONOUT

SIGNON:
	.BYTE	0AH,0DH
	.ASCII	$SUPER NET CP/M vs 2.2 12/30/81$
	.BYTE	0

ERRMSG:
	.BYTE 0AH,0DH
	.ASCII	/DSK ERR /
	.BYTE 0

PRINTBYTE:
	.BYTE	0

DISKSTATUS:
	.BYTE	0

SEEKSTATUS:
	.BYTE	0
CMDSTATUS:
	.BYTE	0
DMAERROR:
	.BYTE	0
OPER:	
	.BYTE	0
DISKN:
	.BYTE	0

IOTK:	.WORD 0		;TRACK POINTER

IOSEC:	.WORD 0		;SECT POINTER

IODMA:	.WORD 0		;DMA POINTER

STATLEN	=	.	-	DISKSTATUS

RTYC:	.BYTE 0		;RETRY COUNT
;
SECCNT:
	.BYTE	0
NEWDSK:
	.BYTE	0
DMATMP:
	.WORD	0
SECTMP:
	.WORD	0
TRKTBL:
	.BYTE	0
	.BYTE	0
DENSTB:
	.BYTE	0
	.BYTE	0
VARLEN	= .-PRINTBYTE
;
;	SCRATCH RAM AREA FOR BDOS USE
BEGDAT	=	.	;BEGINNING OF DATA AREA
DIRBF:	.BLKB	128	;SCRATCH DIRECTORY AREA
ALL00:	.BLKB	31	;ALLOCATION VECTOR 0
ALL01:	.BLKB	31	;ALLOCATION VECTOR 1
CHK00:	.BLKB	32	;CHECK VECTOR 0
CHK01:	.BLKB	32	;CHECK VECTOR 1
;
ENDDAT	=	.	;END OF DATA AREA
DATSIZ	=	.-BEGDAT;SIZE OF DATA AREA


	.END
