.XLINK
.PABS
.PHEX
;
;
;COLD BOOT LOADER FOR CP/M 2.2
; FOR THE Z80 SBC
;LAST UPDATE 11/11/81
;
BIAS	=	0AC00H

DDCODE	=	0DDH			; double density code byte
SINGLE	=	0			; single density is other
DOUBLE	=	DDCODE


; boot loader density
;  the loader density must be set the same as the format density
;  of the diskette.
DENSITY =	DOUBLE			; set density = DOUBLE or SINGLE


; cpm warm boot load & ccp entry point 

CPMB	=	3400H+BIAS		; ccp entry point
	;
BIOS	=	4A00H+BIAS		; bios entry point
;
RTYN	=	10			; disk io retries
SEEKRT	=	1			; rate 0=3ms, 1=6ms, 2=10ms, 3=20ms
CDISK 	= 	4			; last disk selected by the ccp
BELL	=	07			; ding
MAXDSK	=	1			; largest disk number
NSECTS	=	25+26			; number of sectors to read
MONIT	=	0F033H			; monitor boot error entry point
;
CMD	=	0CH			; fdc command & fdc status register	
TK	=	CMD+1			; fdc track register
SECMD	=	CMD+2			; fdc sector register
DAL	=	CMD+3			; fdc data port
WAIT	=	014H	  		; hardware wait for fdc intrq + drq
					;  & drive select - restore latch
;
;
BUFF	=	80H			; default dma buffer

.LOC	0
;
;

WBOOT:
	MVI	A,01101111B	
	OUT	16H	
	LXI	D,NSECTS <8 +2		; start with sector 2 track 0
	LXI	H,CPMB		 	; load at cpmb
	XRA	A	
	STA	CDISK

RBLK1:

	LXI	B,8000H+DAL		; 
	MOV	A,E			; get sector
	OUT	SECMD			; set sector
	MVI	A,088H			; get operation
	OUT	CMD
	NOP

READLOOP:
	IN	WAIT			; wait for drq or intrq
	ORA	A			; was it intrq ?
	JP	IODONE
	INI
	JMPR	READLOOP

IODONE:
	IN	CMD
	MOV	C,A
	SBCD	CMDSTATUS
	ORA	B			; 
	JRNZ	BOOTERROR	

	DCR	D			; one less blockr
	JZ	BIOS	 		; exit when zero
	INR	E
	MVI	A,26+1
	CMP	E
	JRNZ	RBLK1
	MVI	A,1			; start with sector 1 on track 1
	MOV	E,A
	OUT	DAL	 		; return addres on error
	LDA	DENSFLG
	CPI	DDCODE
	JNZ	SINGL
	MVI	A,0CH			; set double density
	OUT 	WAIT
SINGL:
	MVI	A,01CH			; go seek
	OUT	CMD
	NOP
	IN	WAIT
	NOP
	IN	CMD
	STA	SEEKSTATUS
	ANI	10011101B
	JRZ	RBLK1			; go read next block

BOOTERROR:
	SDED	SECTORS
	MVI	A,01001111B
	OUT	16H
	LDA	CMDSTATUS
	JMP	MONIT

	.LOC	07FH
DENSFLG:
	.BYTE	DENSITY			; disk density flag
SEEKSTATUS	=	100H-5
CMDSTATUS	=	100H-4
SECTORS	 	=	100H-2	

	.END

