
	MVI	C,5
LOOP3:	MVI	B,0
	MVI	A,4EH
	CALL	PUT
	DCR	C
	JNZ	LOOP3
	LDA	SIDED
	ORA	A
	JZ	NOTSID1
	CALL	DSIDE1
	PUSH	D
	PUSH	H
	CALL	DMA
	POP	H
	POP	D
	IN	CMD
	ANI	0E7H
	JNZ	ERROR
	CALL	DSIDE0
	LDA	FLAG
	ORA	A
	JZ	COMPLT
	LDA	SFLAG		;doing trk 0 side 1?
	CPI	1		;if = 1 then yes.
	MVI	A,0		;reset the flag
	STA	SFLAG		;
	JZ	S1DONE		;this special side done
NOTSID1:PUSH	D
	PUSH	H
	CALL	DMA
	POP	H
	POP	D
	IN	CMD		;get	status
	ANI	0E7H
	JNZ	ERROR
	LDA	FLAG		;are we doing all the disk ?
	ORA	A		;yes if not = 0
	JZ	COMPLT		;no, just first 2 tracks if = 0
S1DONE:	INR	D
	MOV	A,D
	CPI	4CH+1		;last track?
	JZ	COMPLT
	OUT	DAL
	MVI	A,SEEK
	OUT	CMD
	CALL	NOTRDY
	LXI	H,STABLE	;reset sector pointer
	JMP	LOOP2
;
PUT:	MOV	M,A
	INX	H
	DCR	B
	JNZ	PUT
	RET
;
PUTZERO:MVI	B,12
	XRA	A
	JMP	PUT
;
ERROR:	CMA			;invert for panel lites
	OUT	PANEL		;display error code
	LXI	D,MSG3
	MVI	C,9
	CALL	BDOS
	JMP	COMPLT
;
MSG1:	DB	'Tarbell Electronics 512 x 16'
	DB	0DH,0AH,'Double Density Deblock '
	DB	0DH,0AH,'Format Program Ver 1.8',0DH,0AH
	DB	'Formats:',0DH,0AH
	DB	'Track  0      = 26 , 128 byte sectors',0DH,0AH
	DB	'Tracks 1 - 76 = 16 , 512 Byte sectors',0DH,0AH
	DB	'Sector Skew of '

	IF	ONE
	DB	'1'
	ENDIF

	IF	TWO
	DB	'2'
	ENDIF

	IF	THREE
	DB	'3'
	ENDIF

	IF	FOUR
	DB	'4'
	ENDIF

	IF	FIVE
	DB	'5'
	ENDIF

	IF	SIX
	DB	'6'
	ENDIF

	IF	SEVEN
	DB	'7'
	ENDIF

	IF	EIGHT
	DB	'8'
	ENDIF

	DB	0DH,0AH
	DB	'S-100 Siemens / Shugart Ver. of 6-30-81$'
MSG2:	DB	0DH,0AH,'Drive ? (A,B,C,D)  or Q to Quit $'
MSG2A:	DB	0DH,0AH,'Format System or All or Quit? (S,A, or Q)  $'
MSG2B:	DB	0DH,0AH,'Use DMA for formatting ? (Y or N)  $'
MSG2C:	DB	0DH,0AH,'Format double sided (Y or N)  $'
MSG4:	DB	0DH,0AH,'You must have a CPU running at 4 MHz.$'
MSG3:	DB	0DH,0AH,7,'ERROR- Check for write protected disk',0DH,0AH,'$'
;
;dma routine
;
DMA:	LDA	XFER		;check for dma format wanted
	ORA	A		;is it zero?
	JZ	DMAXFER		;yes, use dma for formatting
	LXI	H,BUFF		;nope, use dma controller
	MOV	A,H		;get hagh addr byte
	OUT	ADR0		;put it to controller
	POP	H		;restore ending address
	DCX	H		;set count -1 for length
	MOV	A,L		;get the low byte
	OUT	WCT0		;put it to controller
	MOV	A,H		;get high byte of count
	ORI	80H		;set write bit on
	ANI	0BFH		;make sure read bit off
	OUT	WCT0		;and put it to controller
	MVI	A,WTRACK	;set for write track
	OUT	CMD		;tell 1791 about it
	ENDIF
;
NOTRDY:
	IF	TARBELL
	IN	DMACHK		;check intrq
	ENDIF
;
	IF	SUPRQAD
	IN	WAIT
	ENDIF
;
	RLC			; bit 7
	JC	NOTRDY		;loop till not busy
	RET
;
NEXTSECT:
	PUSH	H
	LHLD	PTR
	INX	H		;bump pointer
	SHLD	PTR		;and get next byte
	MOV	E,M		;save sector number in reg e
	MOV	A,E		;check for end of table
	POP	H
	ORA	A		;set flags
	RET
;
WSHIFT
	IF	SUPRQAD
	PUSH	B
	PUSH	PSW
	MOV	C,A
	ANI	70H	;SAVE GOOD BITS
	RRC
	RRC
	RRC
	RRC		;SHIFT TO LSB POSITIONS
	MOV	B,A	;SAVE GOOD BITS
	MOV	A,C	;GET ORIG BYTE
	ANI	8	;SAVE BIT 3 ONLY
	ADD	B	;FILL OUT WHOLE BYTE
	OUT	WAIT
	POP	PSW	;RESTORE BYTE AND FLAGS
	POP	B	;RESTORE 'BC'
	RET
	ENDIF
;
	IF	TARBELL
	OUT	WAIT
	RET
	ENDIF
;
FLAG:	DB	0
PTR:	DW	TABLE
;
;table for 512 x 16 sectors
;
TABLE:	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	DB	0
;
STABLE:
	IF	ONE
	DB	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	ENDIF

	IF	TWO			;if skew equals 4
	DB	1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16
	ENDIF

	IF	THREE
	DB	1,4,7,10,13,16,2,5,8,11,14,3,6,9,12,15
	ENDIF

	IF	FOUR
	DB	1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16
	ENDIF

	IF	FIVE
	DB	1,6,11,16,2,7,12,3,8,13,4,9,14,5,10,15
	ENDIF

	IF	SIX
	DB	1,7,13,2,8,14,3,9,15,4,10,16,5,11,6,12
	ENDIF

	IF	SEVEN
	DB	1,8,15,2,9,16,3,10,4,11,5,12,6,13,7,14
	ENDIF

	IF	EIGHT
	DB	1,9,2,10,3,11,4,12,5,13,6,14,7,15,8,16
	ENDIF

	DB	00
CLATCH:	DB	0		;current hardware latch value
SFLAG:	DB	0		;if 1, doing trk 0 side 1 doub den
SIDED:	DB	0		;0= sing.sided, <> 0 = doub.sided
XFER:	DB	0		;type xfer flag byte
	DS	20		;stack area
STACK:	DS	1
OLDSTK:	DS	2		;cpm stack save
KEYBUF:	DS	6
BUFF:	DS	1		;format buffer
	END


	IF	SEVEN
	DB	1,8,15,2,9,16,3,10,4,11,5,12,6,13,7,14
	ENDIF

	IF	EIGHT
	DB	1,9,2,10,3,11,4,12,5,13,6,14,7,15,8,16
	ENDIF

	DB	00
CLATCH:	DB	0		;current hardware latch value
SFLAG:	DB	0		;if 1, doing trk 0 side 1 doub den
SIDED:	DB	0		;0= sing.sided, <> 0 = doub.sided
XFER:	DB	0		;type xfer flag byte
	DS	20		;stack area
STACK:	DS	1
OLDSTK:	DS	2		;cpm stack save
KEYB; 512SQGEN.ASM	2/10/83	** DJ **
;  Switch for TARBELL/SUPER QUAD installed.
;  Set to SUPER QUAD board disk ports.
;
;program to read or write a 512 x 16
;deblocked disk. this program is just like sysgen.
;
;track 0 = single density 128 bytes x 26 sectors.
;track 1 = double density 512 bytes x 16 sectors.
;
;all of track 1 is read or written with this program.
;if running double sided, track 1 now becomes
;track 0 on side 1. it is double density,
;with 16 sectors of 512 bytes.
;program uses function 10 for all console input
;
;last modification 12-04-81
;g.w.mulchin, tarbell electronics
;assemble using zasm.com (z-80 code)
;
	MACLIB	Z80BIOS
;
;system equates
;
FALSE	EQU	0		;define value of false.
TRUE	EQU	NOT FALSE	;define value of true.
;
TARBELL	EQU	FALSE		;true for TARBELL CARD
SUPRQAD	EQU	NOT TARBELL	;true for SUPER QUAD CARD
;
DMACNTL	EQU	FALSE		;true if using DMA control
;
	IF	TARBELL
DISK	EQU	0F8H		;disk port base address.
DCOM	EQU	DISK		;command port.
DSTAT	EQU	DISK		;status port.
SECT	EQU	DISK+2		;sector port.
WAIT	EQU	DISK+4		;wait port.
DCONT	EQU	DISK+4		;control port.
	ENDIF
;
	IF	DMACNTL	AND TARBELL
ADR0	EQU	0E0H		;dma address port.
WCT0	EQU	0E1H		;dma word count port.
CMND	EQU	0E8H		;dma command port.
DMACHK	EQU	DISK+5		;dma check port.
DMAW	EQU	80H		;dma write command
DMAR	EQU	40H		;dma read command
	ENDIF
;
	IF	SUPRQAD
DISK	EQU	0CH		;disk port base address.
DCOM	EQU	DISK		;command port
DSTAT	EQU	DISK			; status port
SECT	EQU	DISK+2			; sector port
WAIT	EQU	DISK+8			; wait port
DCONT	EQU	WAIT			; control port
	ENDIF
;
STPRAT	EQU	0		;0=3ms,1=6ms,2=10ms,3=15ms
SYSTEM	EQU	0900H		;start of cpm image
SDSPT	EQU	26		;26 sectors / track.
DDSPT	EQU	16		;16 sectors / track.
NSECTS	EQU	SDSPT + DDSPT	;total system sectors.
RTCNT	EQU	10		;number of retrys.

B128	EQU	128		;128 byte count
B512	EQU	512		;512 byte count
CR	EQU	0DH
LF	EQU	0AH
BEL	EQU	7		;bell code
IDBUF	EQU	97EH		;id byte location in memory
BOOT	EQU	0
BDOS	EQU	5
PRINTB	EQU	9		;print buffer function
RCB	EQU	10		;read console buffer <func 10>
;
	ORG	100H		;run area
;
BEGIN:	JMP	INIT		;jump around storage
;
MSG1:	DB	CR,LF,'Tarbell 512 x 16 Sysgen program ver 1.4 of 12-04-81.'
MSG1A:	DB	CR,LF,'Source drive or <cr to skip> $'
MSG3:	DB	CR,LF,'Source drive = $'
MSG2:	DB	CR,LF,'Destination drive or <cr to reboot> $'
MSG4:	DB	CR,LF,'Destination drive = $'
READY:	DB	' , type return when ready$'
WRITER:	DB	CR,LF,BEL,'Disk write error$'
RRERR:	DB	CR,LF,BEL,'Disk read error$'
ERROR:	DB	CR,LF,BEL,'Invalid drive select$'
MSG5:	DB	CR,LF,'Reading a Double Sided disk (Y or N) $'
MSG6:	DB	CR,LF,'Writing a Double Sided disk (Y or N) $'
NMERR:	DB	CR,LF,BEL,'Mis-match on drive ID byte.$'
KEYBUF:	DB	3,0,0,0,0
;
;subroutines
;
;input routine - get a character from keyboard
;
;enter:	none
;exit:	reg a = char from keyboard
;	stored at seld
;registers used: d,e h,l c
;
INPUT:	MVI	A,3		;reset buffer length
	LXI	H,0
	SHLD	KEYBUF+1	;clear buffer
	STA	KEYBUF
	LXI	D,KEYBUF	;point to buffer
	MVI	C,RCB		;read buffer function
	CALL	BDOS		;get character
	LDA	KEYBUF+2	;get the first char only
	CPI	'a'		;check for lower case
	RC
	CPI	'z'+1
	RNC
	ANI	5FH		;make into upper case
	RET
;
;print buffer routine
;
;enter:	d,e -> message to print
;exit:	none
;regs:	d,e c
;
PRINT:	MVI	C,PRINTB	;print buffer function
	JMP	BDOS		;use bdos to print
;
;select drive routine
;
DSELDSK:ADD	A		;shift
	ADD	A		; left
	ADD	A		;  four
	ADD	A		;   times
	CALL	WAIT1		;send the select or cpm select
	JRC	OK
	LXI	D,ERROR		;point to error message
	CALL	PRINT
	LXI	D,MSG1A
	JMPR	GDRV		;try again
;
OK:	LXI	D,MSG5		;reading double sided?
	CALL	PRINT
	CALL	INPUT		;get response
	CPI	'N'		;no?
	MVI	A,0		;0 = doing single sided disk
	JRZ	OK2		;yes, just doing single sided
	MVI	A,1		;doing double sided, set a flag
OK2:	STA	SIDED		;save the flag
	LXI	D,MSG3
	CALL	PRINT
	LXI	D,READY		;print ready message
	CALL	PRINT
OK1:	CALL	INPUT		;get cr
	ORA	A		;did we get a cr?
	JRNZ	OK1		;loop till a cr is typed
	LDA	SELD		;get drive to read
	CALL	DSELDSK
	CALL	DHOME		;home the drive
	CALL	READDSK		;read the sele