ALL	BHEX
	JMP	MAPN2Z
;
MAPN2A: CALL	TYPE
;
MAPN2Z: DCR	B
	JNZ	MAPN2
	RET
;
;Find which file group (BC) belongs to
;
GETGRP: LHLD	DRM	;MAX DIR ENTRY #
	INX	H	;MAKE 1-RELATIVE
	SHLD	FILECT
	LXI	H,DIRECT
;
GETGLP: PUSH	H	;SAVE POINTER TO NAME
	MOV	A,M	;PICK UP DN BYTE
	LXI	D,14	;NOW GET RECORD COUNT
	DAD	D	;  S2 PORTION ..
	MOV	A,M	;  IS 0 IN CP/M 1.4
	CPI	0E5H
	JZ	GETGNF
	ANI	0FH
	MOV	E,A
	INX	H
	MOV	A,M
	ORA	E
	JZ	GETGNF
	MVI	E,16	;FIRST SET FOR 8-BIT GRPS
	LDA	DSM+1
	ORA	A
	JZ	SMALGP
	MVI	E,8	;NOPE, BIG GROUPS
;
SMALGP: MOV	D,A	;SAVE GRP SIZE INDICATOR
;
GETGL2: INX	H	;POINTING INTO DM FIELD
	CALL	GRPCMP	;COMPARE BC GP # AGAINST 1 DM FLD
	JZ	GETGOT	;JUMP IF FOUND ONE
	DCR	E	;ELSE COUNT DOWN
	JNZ	GETGL2	;GO TEST SOME MORE
;
GETGNF: POP	H	;NOT THIS ONE!
	LXI	D,32	;SO GO TO NEXT
	DAD	D
	XCHG
	LHLD	FILECT	;THERE IS LIMIT TO EVERYTHING
	DCX	H
	SHLD	FILECT
	MOV	A,H
	ORA	L
	XCHG		;RE-ALIGN
	JNZ	GETGLP
;
;Group is not allocated to any file
	LXI	H,0	;SAY SO
	RET
;
;Found the file
;
GETGOT: POP	H
	RET
;
;Save the current sector
;
SAVE:	LDA	WRFLG
	ORA	A
	JZ	BADW	;NONE TO SAVE
	PUSH	H
	LXI	H,BASE+80H
	LXI	D,SAVBUF
	MVI	B,128
	CALL	MOVE
	MVI	A,1	;..SHOW
	STA	SAVEFL	;..SAVED EXISTS
	POP	H
	JMP	PROMPT
;
;Restore the current sector
;
RESTOR:	LDA	SAVEFL
	ORA	A
	JZ	NOSAVE	;NONE TO SAVE
	PUSH	H
	LXI	H,SAVBUF
	LXI	D,BASE+80H
	MVI	B,128
	CALL	MOVE
	POP	H
	JMP	PROMPT
;
NOSAVE: XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++NO "<" SAVE COMMAND ISSUED'
	DB	CR,LF,0
	JMP	PRMPTR
;
;Move (HL) to (DE) length in B
;
MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
NORITE:	XRA	A	;GET 0
	STA	WRFLG	;CAN'T WRITE NOW
	RET
;
;No match in search, try next char
;
SRNOMT:	POP	H
	CALL	CTLCS	;ABORT?
	JNZ	SEARCH	;..YES
	LXI	H,INBUF
	MVI	M,CR
	JMP	CLCGRP	;SHOW WHERE STOPPED
;
;Search for character string
;
SEARCH: PUSH	H	;SAVE STRING POINTER
;
SRCHL:	CALL	RDBYTE	;GET A BYTE
	MOV	B,A	;SAVE IT
	MOV	A,M	;CHECK NEXT MATCH CHAR.
	CPI	'<'	;WILL IT BE HEX?
	MOV	A,B	;RESTORE DISK CHAR
	JZ	SRCHL1
	ANI	7FH	;NEXT CHAR IS ASCII...STRIP BIT 7
;
SRCHL1: PUSH	PSW
	CALL	GETVAL	;GET SEARCH VALUE
	MOV	B,A
	POP	PSW
	CMP	B	;MATCH?
	JNZ	SRNOMT	;NO MATCH
	INX	H
	MOV	A,M	;DONE?
	CPI	CR
	JZ	SREQU
	CPI	';'
	JNZ	SRCHL
;
;Got match
SREQU:	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'= AT ',0
	LDA	BUFAD
	ANI	7FH
	CALL	HEX
	CALL	CRLF
	JMP	CLCGRP
;
;Get value from input buffer
;
GETVAL: MOV	A,M
	CPI	'<'	;HEX ESCAPE?
	RNZ		;NO, RETURN
;"<<" means one "<"
	INX	H
	MOV	A,M
	CPI	'<'
	RZ
;Got hex
	PUSH	D
	CALL	HEXIN	;GET VALUE
	CPI	'>'	;PROPER DELIM?
	MOV	A,E	;GET VALUE
	POP	D
	JNZ	WHAT	;ERROR
	RET
;
;Read a byte at a time
;
RDBYTE: PUSH	H
	LDA	FTSW	;FIRST READ?
	ORA	A
	JNZ	READ1
	LHLD	BUFAD
	MOV	A,L
	ORA	A	;IN BUFFER?
	JM	NORD	;YES, SKIP READ
;
;Have to read
	CALL	NXTSEC
;
READ1:	XRA	A
	STA	FTSW	;NOT FIRST READ
	LHLD	CURSEC
	XCHG
	CALL	SETSEC
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	CALL	READ
	CALL	CLCSUB
	LXI	H,BASE+80H
;
NORD:	MOV	A,M
	INX	H
	SHLD	BUFAD
	POP	H
	RET
;
;View the file in ASCII starting at
;current sector, stepping thru the disk
;
VIEW:	LDA	WRFLG
	ORA	A
	JZ	BADDMP
	CALL	HEXIN	;GET DISPL IF ANY
	PUSH	H
	MOV	A,E
	ORA	A
	JNZ	VIEWLP
	INR	E	;DFLT=1
;
VIEWLP: LXI	H,BASE+80H ;TO DATA
;
VEWCHR:	CALL	CTLCS
	JZ	VEWEND
	MOV	A,M
	CPI	1AH
	JZ	VEWEOF
	ANI	7FH
	CPI	7EH
	JNC	VIEWHX	;SHOW RUBOUT AND TILDE AS HEX
	CPI	' '
	JNC	VIEWPR
	CPI	CR
	JZ	VIEWPR
	CPI	LF
	JZ	VIEWPR
	CPI	TAB
	JZ	VIEWPR
;
VIEWHX: MOV	A,M	;NOT ASCII...PRINT AS <NN>
	CALL	BHEX
	JMP	VIEWNP
;
VIEWPR: CALL	TYPE
;
VIEWNP: INR	L
	JNZ	VEWCHR
	DCR	E
	JZ	VEWEND
	PUSH	D	;SAVE COUNT
	CALL	NXTSEC
	LHLD	CURSEC
	XCHG
	CALL	SETSEC	
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	CALL	READ
	POP	D	;RESTORE COUNT
	JMP	VIEWLP
;
VEWEOF:	CALL	ILPRT
	DB	CR,LF,TAB,'++EOF++',CR,LF,0
;
VEWEND:	POP	H
	CALL	CRLF
	JMP	CLCGRP
;
;Dump in hex or ASCII
;
DUMP:	LDA	WRFLG
	ORA	A
	JNZ	DUMPOK
;
BADDMP: XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++Can''t dump, no sector read.',CR,LF,0
;
EXPL:	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'Use G command following F,',CR,LF
	DB	'or R or S following T',CR,LF,0
	JMP	PRMPTR
;
DUMPOK: MOV	A,M
	CPI	';'
	JZ	DUMPDF	;DFLT
	CPI	CR
	JNZ	DMPNDF
;
;Use default
DUMPDF: LXI	B,BASE+80H
	LXI	D,0FFH
	JMP	DUMP1
;
DMPNDF:	CALL	DISP
	MOV	B,D
	MOV	C,E
	CPI	CR
	JZ	DUMP1
	CPI	';'
	JZ	DUMP1
	INX	H	;SKIP ','
	CALL	DISP
;
;BC = start, DE = end
;
DUMP1:	PUSH	H	;SAVE COMMAND POINTER
	MOV	H,B
	MOV	L,C
;
DUMPLP: MOV	A,L
	ANI	7FH
	CALL	HEX
	CALL	SPACE
	CALL	SPACE
	LDA	DUMTYP
	CPI	'A'
	JZ	DUMPAS
	PUSH	H	;SAVE START
;
DHEX:	MOV	A,M
	CALL	HEX
	MOV	A,L
	ANI	3
	CPI	3
	CZ	SPACE
	MOV	A,L
	ANI	7
	CPI	7
	CZ	SPACE
	MOV	A,E
	CMP	L
	JZ	DPOP
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DHEX
;
DPOP:	CALL	CTLCS
	JZ	PRMPTR
	LDA	DUMTYP
	CPI	'H'
	JZ	DNOAS	;HEX ONLY
	POP	H	;GET START ADDR
;
DUMPAS: CALL	ASTER
;
DCHR:	MOV	A,M
	ANI	7FH
	CPI	' '
	JC	DPER
	CPI	7EH
	JC	DOK
;
DPER:	MVI	A,'.'
;
DOK:	CALL	TYPE
	MOV	A,E
	CMP	L
	JZ	DEND
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DCHR
;
DEND:	CALL	ASTER
	CALL	CRLF
	PUSH	D
	CALL	CTLCS
	POP	D
	JZ	PRMPTR
	MOV	A,E
	CMP	L
	JNZ	DUMPLP
	POP	H
	JMP	PROMPT
;
DNOAS:	POP	B
	CALL	CRLF
	MOV	A,E
	CMP	L
	JNZ	DUMPLP
	POP	H
	JMP	PROMPT
;
;Position
;
POS:	PUSH	PSW
	MOV	A,M
	CPI	';'
	JZ	POSINQ
	CPI	CR
	JNZ	POSOK
;
POSINQ: POP	PSW
	JMP	INQ
;
POSOK:	POP	PSW
	CPI	'T'
	JZ	POSTKD
	CPI	'S'
	JZ	POSSCD
	CPI	'G'
	JZ	POSGPH
	JMP	WHAT
;
POSTKD	CALL	SUBDE
	XCHG
	LHLD	SPT
	CALL	MULT
	XCHG
	LHLD	CURSEC
	DCX	H
	DAD	D
	LDA	BLM
	MOV	B,A
	MOV	A,L
	ANA	B
	STA	GRPDIS
	LDA	BSH
	MOV	B,A
;
CLCLOP: CALL	ROTRHL
	DCR	B
	JNZ	CLCLOP
	SHLD	GROUP
	POP	H
	RET
;
;Position in the dorectory after a find
;(Does not work in CP/M-2.x)
;
POSDIR: PUSH	H	;SAVE INBUF
	LHLD	BSH
	XRA	A
	STA	FINDFL	;CANCEL POS REQ
	LDA	DIRPOS	;GET POSITION
	RAR
	RAR
	PUSH	PSW
	ANA	H
	STA	GRPDIS
	POP	PSW
;
POSDLP: RAR
	DCR	L
	JNZ	POSDLP
	ANI	1	;GET GROUP
	MOV	L,A	;SETUP FOR POSGP2
	MVI	H,0
	SHLD	GROUP
	XCHG
	JMP	POSGP2	;POSITION TO IT
;
POSGPH: CALL	HEXIN
;
POSGRP: PUSH	H
	LHLD	DSM
	CALL	SUBDE
	POP	H
	JC	OUTLIM
	XCHG
	SHLD	GROUP
	XCHG
	XRA	A
	STA	GRPDIS
	PUSH	H
;
POSGP2: CALL	GTKSEC
	CALL	SETTRK
	XCHG
	CALL	SETSEC
	CALL	READ
	XRA	A
	STA	NOTPOS	;NOW POSITIONED
	POP	H
	JMP	INQ
;
GTKSEC:	MOV	H,D
	MOV	L,E
	LDA	BSH
;
GLOOP:	DAD	H
	DCR	A
	JNZ	GLOOP
	LDA	GRPDIS
	ADD	L	;CAN'T CARRY
	MOV	L,A
;
;Divide by nr of sectors, quotient=track, remainder=sector
;
	XCHG
	LHLD	SPT
	CALL	NEG
	XCHG
	LXI	B,0
;
DIVLP:	INX	B
	DAD	D
	JC	DIVLP
	DCX	B
	XCHG
	LHLD	SPT
	DAD	D
	PUSH	H
	LHLD	SYSTRK
	DAD	B
	XCHG
	POP	H
	INX	H
	RET
;
POSFIL: CALL	NORITE
	MVI	A,1
	STA	FINDFL	;SO WE POSITION LATER
	LXI	D,FCB
	XRA	A	;LOGGED IN DISK
	STAX	D
	INX	D
	MVI	B,8
	CALL	MVNAME
	MVI	B,3
	CALL	MVNAME
	LXI	D,FCB
	MVI	C,SRCHF
	PUSH	H
	CALL	BDOS
	INR	A
	JNZ	FLOK
	STA	DIRPOS	;GRP 0 IF NOT FOUND
	CALL	ILPRT
	DB	'++FILE NOT FOUND',CR,LF,0
	POP	H
	JMP	PROMPT
;
FLOK:	DCR	A
	STA	DIRPOS	;SAVE POS. IN DIR
	ANI	3
	MOV	L,A
	MVI	H,0
	DAD	H	;X32 BYTES/ENTRY
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,BASE+80H
	DAD	D	;HL POINTS TO ENTRY
	LXI	D,32
	XCHG
	DAD	D
	XCHG
	MVI	A,'D'
	STA	DUMTYP
	JMP	DUMPLP	;WHICH POPS H
;
MVNAME: MOV	A,M
	CPI	'.'
	JZ	MVIPAD
	CPI	CR
	JZ	PAD
	CPI	';'
	JZ	PAD
	CALL	UPCASE
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MVNAME
	MOV	A,M
	CPI	CR
	RZ
	CPI	';'
	RZ
	INX	H
	CPI	'.'
	RZ
	JMP	WHAT
;
MVIPAD: INX	H
;
PAD:	MVI	A,' '
	STAX	D
	INX	D
	DCR	B
	JNZ	PAD
	RET
;
PLUS:	LXI	D,1	;DFLT TO 1 SECT
	MOV	A,M	;GET NEXT CHAR
	CPI	CR	;CR?
	JZ	PLUSGO	;..YES, DFLT TO 1
	CPI	';'
	JZ	PLUSGO
	CALL	HEXIN	;GET #
	MOV	A,D
	ORA	E
	JZ	WHAT
;
PLUSGO: CALL	NXTSEC
	DCX	D	;MORE TO GO?
	MOV	A,D
	ORA	E
	JNZ	PLUSGO	;..YES
;
;Ok, incremented to sector.  Setup and read
;
PLUSMI: PUSH	H
	LHLD	CURSEC
	XCHG
	CALL	SETSEC
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	POP	H
	CALL	READ
	JMP	CLCGRP
;
MINUS:	LXI	D,1	;SET DFLT
	MOV	A,M	;GET CHAR
	CPI	CR	;CR?
	JZ	MINGO	;..YES, DFLT=1
	CPI	';'
	JZ	MINGO
	CALL	HEXIN	;..NO, GET ##
	MOV	A,D
	ORA	E
	JZ	WHAT
;
MINGO:	PUSH	H
	LHLD	CURSEC
	DCX	H
	MOV	A,H
	ORA	L
	JNZ	MINOK
	LHLD	CURTRK
	MOV	A,H
	ORA	L
	JNZ	SEASH
	LHLD	MAXTRK	;WRAP TO END OF DISK
	SHLD	CURTRK
	LHLD	MAXSEC
	JMP	MINOK
;
SEASH:	DCX	H
	SHLD	CURTRK
	LHLD	SPT
;
MINOK:	SHLD	CURSEC
	POP	H
	DCX	D
	MOV	A,D
	ORA	E
	JNZ	MINGO
	JMP	PLUSMI
;
;Go to next sector
;
NXTSEC:	PUSH	H
	PUSH	D
	LHLD	CURSEC
	INX	H
	XCHG
	LHLD	SPT
	CALL	SUBDE
	XCHG
	JNC	NEXTOK
	LHLD	CURTRK
	INX	H
	XCHG
	LHLD	MAXTRK
	CALL	SUBDE
	JNC	TRASK
	LXI	D,0	;WRAP TO START OF DISK
;
TRASK:	XCHG
	SHLD	CURTRK
	LXI	H,1
;
NEXTOK: SHLD	CURSEC
	POP	D
	POP	H
	RET
;
;Tell what group, displacement, track, sector, physical sector
;
INQ:	CALL	INQSUB
	JMP	PROMPT
;
;Position inquiry subroutine
;Executed via: G S or T (with no operands)
;
INQSUB: PUSH	H
	LHLD	SYSTRK
	XCHG
	LHLD	CURTRK
	CALL	SUBDE
	JC	NOGRP
	CALL	ILPRT
	DB	'G=',0
	LHLD	GROUP
	MOV	B,H
	MOV	C,L
	CALL	HEXB
	MVI	A,':'
	CALL	TYPE
	LDA	GRPDIS
	CALL	HEX
	MVI	A,','
	CALL	TYPE
;
NOGRP:	CALL	ILPRT
	DB	' T=',0
	LHLD	CURTRK
	CALL	DEC
	CALL	ILPRT
	DB	', S=',0
	LHLD	CURSEC
	CALL	DEC
	CALL	ILPRT
	DB	', PS=',0
	LHLD	PHYSEC
	CALL	DEC
	CALL	CRLF
	POP	H
	RET
;
CHG:	MOV	A,M	;GET TYPE (HEX, ASCII)
	CALL	UPCASE
	PUSH	PSW	;SAVE "H" OR "A"
	INX	H
	CALL	DISP	;GET, VALIDATE DISP TO DE
	INX	H
	LXI	B,0	;SHOW NO 'THRU' ADDR
	CPI	'-'	;TEST DELIM FR. DISP
	JNZ	CHGNTH	;NO THRU
	PUSH	D	;SAVE FROM
	CALL	DISP	;GET THRU
	INX	H	;SKIP END DELIM
	MOV	B,D
	MOV	C,E	;BC = THRU
	POP	D	;GET FROM
	JMP	CHGAH
;
CHGNTH: CPI	','
	JNZ	WHAT
;
CHGAH:	POP	PSW
	CPI	'H'
	JZ	CHGHEX
	CPI	'A'
	JNZ	WHAT
;
;Change ASCII
CHGALP: MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	LDAX	D
	CPI	' '
	JC	CHGAHX
	CPI	7EH
	JNC	CHGAHX
	JMP	CHGA2
;
CHGAHX: CALL	BHEX
	JMP	CHGA3
;
CHGA2:	CALL	TYPE
;
CHGA3:	SHLD	BACK	;IN CASE "THRU"
	CALL	GETVAL	;ASCII OR <HEX>
	STAX	D	;UPDATE CHAR
	INX	H	;TO NEXT INPUT CHAR
;See if 'THRU' requested
	MOV	A,C
	ORA	A
	JZ	CHANTH
	CMP	E	;DONE?..
	JZ	PROMPT	;..YES
	LHLD	BACK
;
CHANTH:	INR	E
	JNZ	CHGALP
	MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	JMP	WHAT
;
;Change hex
;
CHGHCM:	INX	H
;
CHGHEX: MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	CPI	','	;DELIM?
	JZ	CHGHCM
	PUSH	D
	SHLD	HEXAD	;IN CASE 'THRU'
	CALL	HEXIN	;POSITIONS TO DELIM
	MOV	A,E	;GET VALUE
	POP	D	;..ADDR
	PUSH	PSW	;SAVE VALUE
	LDAX	D	;GET OLD
	CALL	HEX	;ECHO IN HEX
	POP	PSW	;GET NEW
	STAX	D	;SAVE NEW
	MOV	A,C	;SEE IF 'THRU'
	ORA	A
	JZ	CHHNTH	;..NO.
	CMP	E	;..YES, DONE?
	JZ	PROMPT
	LHLD	HEXAD	;..NO: MORE
;
CHHNTH:	INR	E
	JNZ	CHGHEX
	MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	JMP	WHAT
;
DOREAD: LDA	NOTPOS
	ORA	A
	JNZ	CANTRD
	CALL	READ
	JMP	PROMPT
;
CANTRD: XRA	A
	STA	QFLAG	;NOT QUIET
	CALL	ILPRT
	DB	'++Can''t read - not positioned',CR,LF
	DB	'Position by:',CR,LF
	DB	9,'Track then Sector, or',CR,LF
	DB	9,'Group',CR,LF,0
	JMP	PROMPT
;
DORITE:	CALL	WRITE
	JMP	PROMPT
;
BHEX:	PUSH	PSW
	MVI	A,'<'
	CALL	TYPE
	POP	PSW
	CALL	HEX
	MVI	A,'>'
	CALL	TYPE
	RET
;
HEXB:	LDA	DSM+1
	ORA	A
	JZ	HEXX
	MOV	A,B
	CALL	HEX
;
HEXX:	MOV	A,C
;
HEX:	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
;
NIBBL:	ANI	0FH
	CPI	10
	JC	HEXNU
	ADI	7
;
HEXNU:	ADI	'0'
	JMP	TYPE
;
;Decimal output routine
;
DEC:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	B,-10
	LXI	D,-1
;
DECOU2: DAD	B
	INX	D
	JC	DECOU2
	LXI	B,10
	DAD	B
	XCHG
	MOV	A,H
	ORA	L
	CNZ	DEC
	MOV	A,E
	ADI	'0'
	CALL	TYPE
	POP	H
	POP	D
	POP	B
	RET
;
SPACE:	MVI	A,' '
	JMP	TYPE
;
ASTER:	MVI	A,'*'
	JMP	TYPE
;
;Inline print routine
;
ILPRT:	XTHL
;
ILPLP:	CALL	CTLCS	;ABORT?
	JZ	PRMPTR
	MOV	A,M
	CPI	1	;PAUSE?
	JNZ	ILPOK
	CALL	CONIN
	CPI	3	;ABORT?
	JZ	PRMPTR
	JMP	ILPNX
;
ILPOK:	CALL	TYPE
;
ILPNX:	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL
	RET
;
;DISP calls HEXIN, and validates a sector
;displacement, then converts it to an address
;
DISP:	CALL	HEXIN
	PUSH	PSW	;SAVE DELIMITER
	MOV	A,D
	ORA	A
	JNZ	BADISP
	MOV	A,E
	ORA	A
	JM	BADISP
	ADI	80H	;TO POINT TO BUFFER AT BASE+80H
	MOV	E,A
	MVI	D,BASE/256
	POP	PSW	;GET DELIM
	RET
;
BADISP: XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++BAD DISPLACEMENT (NOT 0-7F)'
	DB	CR,LF,0
	JMP	PRMPTR
;
HEXIN:	LXI	D,0
	MOV	A,M
	CPI	'#'	;DECIMAL?
	JZ	HDIN	;MAKE DECIMAL
;
HINLP:	MOV	A,M
	CALL	UPCASE
	CPI	CR
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'-'	;'THRU'?
	RZ
	CPI	'>'
	RZ
	INX	H
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JC	HINNUM
	CPI	'A'
	JC	WHAT
	CPI	'F'+1
	JNC	WHAT
	SUI	7
;
HINNUM: SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	JMP	HINLP
;
HDIN:	INX	H	;SKIP '.'
;
DECIN:	LXI	D,0
;
DINLP:	MOV	A,M
	CALL	UPCASE
	CPI	CR
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'-'	;'THRU'?
	RZ
	INX	H
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JNC	WHAT
	SUI	'0'
	PUSH	H
	MOV	H,D
	MOV	L,E
	DAD	H	;X2
	DAD	H	;X4
	DAD	D	;X5
	DAD	H	;X10
FULL:	DCR	B
	DCX	H
	MVI	A,'*'	;SIGNAL WE'RE FULL
	CALL	TYPE
	JMP	RDBLP
;
;Got CR
;
RDCR:	MOV	M,A	;SAVE IT
	CALL	TYPE	;ECHO IT
	MVI	A,LF	;ECHO..
	CALL	TYPE	;..LF
	LXI	H,INBUF
	RET
;
;Got DELETE or BS, echo if BS
;
RDBS:	XRA	A	;AT FRONT..
	ORA	B	;..OF LINE?
	JZ	RDCTLU	;..YES, ECHO ^U
	DCX	H
	DCR	B
	MOV	A,C
	CPI	'H'-40H	;BS?
	JZ	BACKUP	;ECHO THE BS
	MOV	A,M	;ECHO..
	CALL	TYPE	;..DELETED CHAR
	JMP	RDBLP
;
BACKUP: CALL	WIPER
	JMP	RDBLP
;
RDCTLX: INR	B
;
RDCX1:	DCR	B
	JZ	RDBF1
	CALL	WIPER
	JMP	RDCX1
;
WIPER:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,BSMSG	;BACKSPACE, SPACE, BACKSPACE
	MVI	C,PRINT
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
BSMSG:	DB	BS,' ',BS,'$'
;
;Got CTL-R, retype
;
RDCTLR: MVI	M,CR
	CALL	CRLF
	LXI	H,INBUF
	MVI	B,0
;
RDCRL:	MOV	A,M
	CPI	CR
	JZ	RDBLP
	CALL	TYPE
	INR	B
	INX	H
	JMP	RDCRL
;
;Got CTL-U or backup to beginning of line.
;
RDCTLU: MVI	A,'^'
	CALL	TYPE
	MVI	A,'U'
	CALL	TYPE
	JMP	RDBUF
;
CRLF:	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
	JMP	TYPE
;
UPCASE: CPI	60H
	RC
	ANI	5FH	;MAKE UPPER CASE
	RET
;
CONST:	PUSH	B
	PUSH	D
	PUSH	H
VCONST: CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	POP	D
	POP	B
	RET
;
CONIN:	PUSH	B
	PUSH	D
	PUSH	H
VCONIN: CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	POP	D
	POP	B
	RET
;
;Console out with TAB expansion
;
TYPE:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	C,A	;FOR OUTPUT ROUTINE
	CPI	TAB
	JNZ	TYPE2
;
TYPTAB:	MVI	A,' '
	CALL	TYPE
	LDA	TABCOL
	ANI	7
	JNZ	TYPTAB
	JMP	TYPRET
;
;Filter out control characters to
;prevent garbage during view of file
;
TYPE2:	CPI	' '
	JNC	TYPEQ
	CPI	CR
	JZ	TYPEQ
	CPI	LF
	JNZ	TYPNCR
;
TYPEQ:	LDA	QFLAG
	ORA	A

VCONOT:	CZ	$-$	;ADDR FILLED IN BY 'INIT'
;
;Update column used in tab expansion
	MOV	A,C	;GET CHAR
	CPI	CR
	JNZ	TYPNCR
	MVI	A,0
	STA	TABCOL
	JMP	TYPLST
;
TYPNCR:	CPI	' '	;CTL CHAR?
	JC	TYPLST	;..NO CHANGE IN COL
	LDA	TABCOL
	INR	A
	STA	TABCOL
;
TYPLST:	LDA	PFLAG
	ANI	1
	CNZ	LIST	;FROM C REG.
;
TYPRET:	POP	H
	POP	D
	POP	B
	RET
;
LIST:	PUSH	B	;SAVED REGS
	PUSH	D
	PUSH	H
VLIST:	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	POP	D
	POP	B
	RET
;
HOME:	PUSH	H
VHOME:	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	RET
;
;Set track # in DE
;
SETTRK: PUSH	H
	LHLD	MAXTRK
	CALL	SUBDE
	POP	H
	JC	OUTLIM
	XCHG
	SHLD	CURTRK
	XCHG
	MOV	B,D
	MOV	C,E
	PUSH	H
VSETRK:	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	RET
;
SETSEC: PUSH	H
	PUSH	D
	LHLD	SYSTRK
	XCHG
	SHLD	CURSEC
	LHLD	CURTRK
	CALL	SUBDE
	POP	B
	MOV	H,B
	MOV	L,C
	JNC	NOTSYS
	LDA	FIRST0	;SEE IF FIRST SEC 0
	ORA	A
	JNZ	GSTSEC	;NO, JUMP AWAY
	DCX	H	;YES, SO DECREMENT
	JMP	GSTSEC	;  REQUESTED, THEN GO
;
NOTSYS: LHLD	SECTBL
	XCHG
	DCX	B
VSCTRN:	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	LDA	SPT+1	;IF SPT<256 (HI-ORD = 0)
	ORA	A	; THEN FORCE 8-BIT TRANSLATION
	JNZ	VSCTR1	; ELSE KEEP ALL 16 BITS
	MOV	H,A
VSCTR1:	LDA	VER2FL	;SEE IF VERSION 2.x
	ORA	A	;SET FLAGS
	JNZ	GSTSEC	;JUMP IF CP/M 2.x
	MVI	H,0	;CP/M 1.4 GOOD TO ONLY 8 BITS
	MOV	L,C	;MOST BIOS'S RETURN THE
			;  PHYSICAL SEC # IN REG C
GSTSEC:	SHLD	PHYSEC	;THIS MAY BE REDUNTANT IN
			; MOST 1.4 VERSIONS, BUT
			; SHOULD CAUSE NO PROBLEMS
	MOV	B,H
	MOV	C,L
VSTSEC:	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	RET
;
OUTLIM: XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++not within tracks 0-',0
	PUSH	H
	LHLD	MAXTRK
	CALL	DEC
	POP	H
	CALL	ILPRT
	DB	'++'
	DB	CR,LF,0
	CALL	NORITE
	JMP	PRMPTR
;
SETDMA:	JMP	$-$	;ADDR FILLED IN BY 'INIT'
;
READ:	MVI	A,1
	STA	WRFLG
	PUSH	H
VREAD:	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	ORA	A
	JZ	READOK
	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++READ failed, sector may be invalid++'
	DB	CR,LF,0
;
READOK: POP	H
	RET
;
WRITE:	LDA	WRFLG
	ORA	A
	JNZ	PWRITE
;
BADW:	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++CANNOT WRITE UNLESS READ ISSUED'
	DB	CR,LF,0
	JMP	EXPL
;
PWRITE: PUSH	H
	MVI	C,1	;FORCE WRITE TYPE 1 IN CASE 2.x DEBLOCK USED
VWRITE: CALL	$-$	;ADDR FILLED IN BY 'INIT'
	ORA	A
	JZ	WRITOK
	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++WRITE failed++',CR,LF,0
;
WRITOK:	POP	H
	RET
;
;Help
;
HELP:	CALL	ILPRT
	DB	'Operands in brackets [...] are optional'
	DB	CR,LF
	DB	'Numeric values: ''n'' are decimal, ''x'' hex'
	DB	CR,LF,CR,LF
	DB	'+[n]   step in [n] sectors;'
	DB	CR,LF
	DB	'-[n]   step out [n] sectors'
	DB	CR,LF
	DB	'#      print disk parameters for curr drive.'
	DB	CR,LF
	DB	'=xxx   search for ASCII xxx from curr sector.'
	DB	CR,LF
	DB	'       Caution: upper/lower case matters.'
	DB	CR,LF
	DB	'       Use <xx> for hex:'
	DB	CR,LF
	DB	'       To find "IN 0" use: =<db><0>     or'
	DB	CR,LF
	DB	'       "(tab)H,0(CR)(LF)" use: =<9>H,0<D><A>'
	DB	CR,LF
	DB	'<      save current sector into mem. buff.'
	DB	CR,LF
	DB	'>      restore saved sector'
	DB	CR,LF
	DB	'?      give help'
	DB	CR,LF
	DB	'A[ff,tt] ASCII dump'
	DB	CR,LF,CR,LF
	DB	'(Type any char. to continue)'
	DB	1,CR,LF,CR,LF
	DB	'C      Change:'
	DB	CR,LF
	DB	'       CHaddr,byte,byte... (hex)'
	DB	CR,LF
	DB	'  or   CAaddr,data...  (Ascii)'
	DB	CR,LF
	DB	'       <xx> Allowed for imbedded hex.'
	DB	CR,LF
	DB	'  or   CHfrom-thru,byte  e.g. ch0-7f,e5'
	DB	CR,LF
	DB	'  or   CAfrom-thru,byte'
	DB	CR,LF
	DB	'D[ff,tt] Dump (hex+ASCII)'
	DB	CR,LF
	DB	'Fn.t   Find file'
	DB	CR,LF
	DB	'Gnn    CP/M Allocation Group nn'
	DB	CR,LF
	DB	'H[ff,tt]       hex dump'
	DB	CR,LF
	DB	'L      Log in drive'
	DB	CR,LF
	DB	'Lx     Log in drive x'
	DB	CR,LF
	DB	'M[nn]  Map [from group nn]'
	DB	CR,LF,CR,LF
	DB	'(Type any char. to continue)'
	DB	1,CR,LF,CR,LF
	DB	'N      New disk'
	DB	CR,LF
	DB	'P      Toggle printer switch'
	DB	CR,LF
	DB	'Q      Quiet mode (no msgs)'
	DB	CR,LF
	DB	'R      Read current sector'
	DB	CR,LF
	DB	'Snn    Sector nn'
	DB	CR,LF
	DB	'Tnn    Track nn'
	DB	CR,LF
	DB	'Unn    Set User nn for Find command (CP/M-2 only)'
	DB	CR,LF
	DB	'V[nn]  View [nn] ASCII sectors'
	DB	CR,LF
	DB	'W      Write current sector'
	DB	CR,LF
	DB	'X      Exit program'
	DB	CR,LF
	DB	'Z[nn]  Sleep [nn tenths]'
	DB	CR,LF
	DB	'/[nn]  Repeat [nn (decimal) times]'
	DB	CR,LF,CR,LF
	DB	'(Type any char. to continue)'
	DB	1,CR,LF,CR,LF
	DB	'Cancel a function with C or Ctl-C.'
	DB	CR,LF
	DB	'Suspend output with S or Ctl-S.'
	DB	CR,LF
	DB	'Separate commands with ";".'
	DB	CR,LF
	DB	'       Example: g0'
	DB	CR,LF
	DB	'       +;d;z#20;/'
	DB	CR,LF
	DB	'       would step in, dump, sleep 2 sec, '
	DB	CR,LF
	DB	'       and repeat until control-c typed.'
	DB	CR,LF
	DB	'All "nn" usage except "/", "T", and "S" are'
	DB	CR,LF
	DB	'        HEX.  Use #nn for decimal.'
	DB	CR,LF,CR,LF
	DB	'See DU.DOC for complete examples.'
	DB	CR,LF,CR,LF,0
	JMP	PROMPT
;
;********************************
;*				*
;*    Utility Subroutines	*
;*				*
;********************************
;
GRPCMP: MOV	A,C
	INR	D
	DCR	D
	JZ	CMP8
	CMP	M
	INX	H
	RNZ
	MOV	A,B
;
CMP8:	CMP	M
	RET
;
;2's complement HL ==> HL
;
NEG:	MOV	A,L
	CMA
	MOV	L,A
	MOV	A,H
	CMA
	MOV	H,A
	INX	H
	RET
;
;HL/2 ==> HL
;
ROTRHL: ORA	A
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	RET
;
;Collect the number of '1' bits
;in A as a count in C
;
COLECT: MVI	B,8
;
COLOP:	RAL
	JNC	COSKIP
	INR	C
;
COSKIP: DCR	B
	JNZ	COLOP
	RET
;
;HL-DE ==> HL
;
SUBDE:	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RET
;
;Quick Kludge multiply
;HL=DE ==> HL
;
MULT:	PUSH	B
	PUSH	D
	XCHG
	MOV	B,D
	MOV	C,E
	MOV	A,B
	ORA	C
	JNZ	MULCON
	LXI	H,0	;FILTER SPECIAL CASE
	JMP	MLDONE	;  OF MULTIPLY BY 0
;
MULCON: DCX	B
	MOV	D,H
	MOV	E,L
;
MULTLP: MOV	A,B
	ORA	C
	JZ	MLDONE
	DAD	D
	DCX	B
	JMP	MULA,M
	INX	H
	STA	BSH
	MOV	A,M
	INX	H
	STA	BLM
	MOV	E,M
	INX	H
	XCHG
	SHLD	DSM
	XCHG
	MOV	E,M
	INX	H
	XCHG
	SHLD	AL0
	XCHG
	MOV	E,M
	XCHG
	SHLD	SYSTRK
;
LOGCAL: LXI	H,GRPDIS
	MOV	A,M
	PUSH	PSW
	LDA	BLM
	MOV	M,A
	PUSH	H
	LHLD	DSM
	XCHG
	CALL	GTKSEC
	SHLD	MAXSEC
	XCHG
	SHLD	MAXTRK
	POP	H
	POP	PSW
	MOV	M,A
	RET
;
;Temporary storage area
;
BUFAD:	DW	BASE+100H ;FORCES INITIAL READ
HEXAD:	DW	0	;TO RE-FETCH A VALUE
TOGO:	DW	0FFFFH	;REPEAT COUNT (FFFF=CONT)
TWOUP:	DB	0
PFLAG:	DB	0	;1=PRINT
GROUP:	DW	0
GRPDIS:	DB	0
SAVEFL:	DB	0
CURTRK:	DW	0
CURSEC:	DW	1
PHYSEC:	DW	1
TABCOL:	DB	0
FILECT:	DW	0
DIRPOS:	DB	0
FINDFL:	DB	0	;1=MUST POSITION AFTER FIND
FTSW:	DB	1	;SEARCH W/O INCREMENT
NOTPOS:	DB	1	;INITIALLY NOT POSITIONED
WRFLG:	DB	0	;MAY NOT WRITE UNTIL '+', '-',
;			 OR 'G' COMMAND
QFLAG:	DB	0	;QUIET? (0=NO)
FIRST0:	DB	0	;SETS TO 0 IF FIRST SEC # IS 0
DRIVE:	DB	0
MAXTRK:	DW	0
MAXSEC:	DW	0
VER2FL:	DB	0
SECTBL:	DW	0	;POINTER TO SECTOR SKEW TABLE
;
BACK:	DS	2	;TO BACK UP IN "CA0-7F,X"
DUMTYP:	DS	1
;
;--------------------------------------------------
;The disk parameter block
;is moved here from CP/M
;
DPB	EQU	$	;DISK PARAMETER BLOCK (COPY)
SPT:	DS	2
BSH:	DS	1
BLM:	DS	1
EXM:	DS	1
DSM:	DS	2
DRM:	DS	2
AL0:	DS	1
AL1:	DS	1
CKS:	DS	2
SYSTRK: DS	2
;
;End of disk parameter block
;--------------------------------------------------
;
SAVBUF: DS	128
INBUF:	DS	128
;
;Directory read in here; also search work area
;
WORK	EQU	$
DIRECT	EQU	$
;
	END
&c.
	MOV	A,C			;restore a.
	RET				;return from list.
	ENDIF
;
;punch and reader not supported
;
READER:	MVI	A,1AH		;not supported return code
PUNCH:	RET
;
;check console status
;
CONST:	IN	CSTAT		;console status
	ANI	CIMASK		;check data ready
	MVI	A,0
	RZ
	CMA
	RET
;
;read a character from the console
;
CONIN:	IN	CSTAT		;check keyboard
	ANI	CIMASK		;mask valu---
;
SAVBUF: DS	128
INBUF:	DS	128
;
;Directory read in here; also search work area
;
WORK	EQU	$
DIRECT	EQU	$
;
	END

		    DU-V74.DOC
	       by Ward Christensen
	with additional notes by Ron Fowler
		(revised 1/15/81)

	HOW TO USE DU ver 7.4 DISK UTILITY

INSTALLATION:
	The 7.0 and later versions of DU are designed to
  be installed with a minimum of trouble.  In fact, in al-
  most all cases, no changes to the source file should be
  necessary to get DU up and running. This is because DU
  uses the disk paramter block of CP/M to determine the
  characteristics of the disk environment.  (see the dis-
  claimer for certain non-standard versions of CP/M 1.4).
	The only parameter that should need to be changed
  will be the clock speed flag at 103H.  Leave this byte
  zero if you have a 2 mhz clock.  Patch it non-zero for
  4 mhz.  This is only needed for the "Z" (sleep) command.

USE:

Any valid command string may be placed as an
operand of the original DU command, i.e.:

     A>DU G0;D;G2;=OK<D><A><1A>;D

Functions supported:

	Tnn	Seek to track nn (no read)
	Snn	Position to sector nn, and read
	Gnn	Position to group nn and read.
	G	Shows current position
	V	Views the current sector.
		(assumes ASCII data)
	Vnn	Views nn sectors
	Fname	print directory for file "name",
		then positions to it's directory 
		sector. (Won't position under
		CP/M 2.x, but see = command below.)

	=string	Ascii search, starting at current
		sector. <xx> hex may be imbedded,
		or used alone:  To find "IN 0FEH":
		=<db><fe>
		Ignores bit 7 unless <xx> is used.

	L	Re-logs in the current disk. You may pull
		out a disk, put in a new, and "L" just
		to log it in.

	Lx	Logs in disk 'x', such as: LB

	Ux	Logs user 'x' for next F command.  Gives
		'?' error if not CP/M version 2.x.

	D	Dump sector, hex + ASCII
	A	Dump sector, ASCII only
	H	Dump sector, hex only

note all dump commands (D, A, H) may be optionally
	followed by a starting and ending address:
	D0,7F	is the same as just D
	D3,5
	A20,3F

	CHaddr,val,val,val... change hex in sector
	CAaddr,char string... change ASCII in sector
		NOTE that <xx> may be hex imbedded
		in the Ascii:  ca0,OK<d><a><1a>

		----> Use W to write changes to disk.
		Note that the C command echoes
		the overlaid data for verification.

	CHaddr-addr,byte
 or	CAaddr-addr,byte	repeats a change

	+	advance 1 sector (if below track 2,
		this advances to next numerical, if
		2 or >, advances based on CP/M's normal
		sector scrambling algorithm, i.e. so +
		will get the next logical sector of the file

	-	backs up 1 logical sector

		Note + and - may take an amount:
		for example, +F steps in 15 sectors.

		Note also that "-" issued at the first logical
		sector of the disk will wrap back to the last.
		Further, "+" issued at the last sector will
		wrap forward to the first.

	?	Gives command summary

	#	Prints the disk parameters

	M	Dumps a map of the group allocations
		for files.
	Mn	Shows which file is allocated to
		group "n".

	N	Resets CP/M via the BDOS.  This may
		make it possible under some implementations
		of CP/M to change the disk format (e.g., density,
		sides, etc)

	R	Reads the sector currently positioned to
		into memory.  Note R (Read) is implicit in
		the G, +, and - commands, but N-O-T in the
		S and T commands (I did it because I was
		tired of disk reading after T command before
		I had a chance to issue the S command)

	W	Write back the current sector (N-O-T-E may
		not be used after an F command, as CP/M was
		used to find the file in the directory

	X	Exit back to CP/M (Must press return).  Ctl-c
		was too easy to hit over modem lines, so I
		decided on 2-byte (X, CR) to exit.

	P	Toggle printer switch on/off

	Z	Sleep - causes the program to pause, such
		as to look at a dump.  Z is 1 sec.  Znn
		is nn tenths of a second on a 2 MHz 8080.

	<	Saves current sector in a save buffer

	>	Gets saved buffer.  < and > may be used
		to move a sector to another place.

	/	Repeats entire command.  Defaults
 or	/nn	to "forever".  NN may be 2 to 65535

multiple commands may be separated by ";"

Example: the following commands will erase the
	 b disk directory to all E5's:

	lb		log in b drive
	g0		position to dir.
	ch0-7f,e5	fill with e5
	<		save the sector
	>;w;+;/16	restore, write, next,
			repeat 16

----This could be shortened to:

	lb;g0;ch0-7f,e5;<
	>;w;+;/16

END



	/	Repeats entire command.  Defaults
 or	/nn	to "forever".  NN may be 2 to 65535

multiple commands may be separated by "tor 51
	DCR	A
	JRZ	TRK1
	IN	SECTP
	CPI	27		;track 0 limit is sector 26
	CMC
	RET
TRK1:	IN	SECTP
	CPI	52
TSTC:	CMC
	RET
;
; -read logical sector-
;bc, de unchanged
;hl is dma address
;hl returned hl + length
;
	IF	DMACNTL		;if using dma
READLS:	PUSH	B		;save bc
	PUSH	D		;save de
	MVI	A,ERCNT		;retry count
RRTRY:	STA	RTCNT		;save it
	PUSH	H		;save dma address
	LXI	B,FREAD SHL 8 OR WCT0
	LDA	DISKHF		;check if deblocking
	CPI	3		;if = 3, deblocking
	LXI	D,DMAR SHL 8 OR B512
	JRNC	RSET		;we are deblocking
	LXI	D,DMAR SHL 8 OR B128
RSET:	CALL	DMARW		;use common read/write
	ANI	9DH		;check for errors during read
	JRZ	REXIT2		;exit if none
	POP	H		;recover address, error occured
	LDA	RTCNT		;get retry count
	DCR	A		;decrement it
	JRNZ	RRTRY		;retry again

	ELSE

READLS:	PUSH	B		;save	bc, de
	PUSH	D
	LXI	B,ERCNT*256 + WAIT
RRTRY:	MVI	A,80H
	OUT	DCOM		;read a block
	CALL	HDLAY		;delay for head load
	PUSH	H
	XCHG
	LXI	H,RLOOP		;set up for fast transfer
RLOOP:	INP	A		;read ; disk formatting program
; written by dick culbertson in aug, 1977
; modified by don tarbell in sep, 1977
; modified by marc farjeon - may 24, 1979.
; modified by jerry mulchin - june 27, 1979
;   for use with new controller board
; modified 5-12-80 for multi-drive select
; and double sided select, and read test
; of the formatted track. (g.w.mulchin.)
;modified 6-4-80 for double sided code byte insert
;during formatting. code = e7h, doub sided.
; modified for persci restore command 9-23-80.
;
; this program will format either a single
; sided or a double sided disk and check
; each track for crc or rnf errors. if any
; errors of this type are found, the program
; will reformat that track again, recheck it
; again, for 5 retrys. if the retry count
; exceeds 5, then that disk is declared fatal
; and should be replaced.
;
TRUE	EQU	-1
FALSE	EQU	NOT TRUE
;
INTRP	EQU	FALSE		;true if using interrupts
DCOM	EQU	0F8H		;disk command port
DSTAT	EQU	0F8H		;disk status port
TRACK	EQU	0F9H		;disk track command
SECTP	EQU	0FAH		;disk sector port
DDATA	EQU	0FBH		;disk data port
WAIT	EQU	0FCH		;disk wait control port
ENTRY	EQU	5		;entry pt to fdos
BELL	EQU	'G'-40H		;cntl-g = bell
READC	EQU	80H		;read command
RSTOR	EQU	0		;restore command
STEP	EQU	01010000B	;step in command
HLAB	EQU	8		;0=no head load, 8=head load
STPRAT	EQU	1		;0=3ms,1=6ms,2=10ms
;
;
	ORG	0100H		;load & ex here
;
;starting message
;	
	IF	INTRP
BEGIN:	DI
	ENDIF

	LXI	H,0		;clear h,l
	DAD	SP		;get cpm stack pointer
	SHLD	OLDSTK		;save it for later
BGIN:	LXI	SP,STACK	;set up local stack
	MVI	A,0E5H
	STA	SPBYTE+1
	MVI	C,9		;get code for print.
	LXI	D,MSG		;get adr of message.
	CALL	ENTRY		;print opening.
BGIN2:	LXI	D,DRIVE		;get drive to format
	MVI	C,9
	CALL	ENTRY		;print message
	MVI	C,1		;now get the drive
	CALL	ENTRY
	CALL	CONV		;check cases
	CPI	'Q'		;quit?
	JZ	EXIT		;yes
	ANI	7		;strip ascii bits
	DCR	A		;make cpm drive
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;shift 4 places
	STA	SDRIVE		;save drive code
	OUT	WAIT		;select the drive
	LXI	D,DUBMSG
	MVI	C,9
	CALL	ENTRY		;ask about double sided drives
	MVI	C,1
	CALL	ENTRY
	CALL	CONV		;check cases
	CPI	'N'		;not using dub sided disks
	MVI	A,0
	STA	DUBSID
	JZ	BGIN1		;doing single sided
	CMA
	STA	DUBSID		;doing doub. sided
	MVI	A,0E7H		;double sided code byte
	STA	SPBYTE+1	;modify byte in spfill routine.
BGIN1:	LXI	D,CRLF
	MVI	C,9
	CALL	ENTRY
	MVI	C,9
	LXI	D,RDY		;print ready message.
	CALL	ENTRY
	MVI	C,1		;read a char from kb.
	CALL	ENTRY
	CALL	CONV		;convert lower to upper case
	CPI	'Y'		;if it's a 'y',
	JZ	START		;go ahead and do it.
EXIT:	LHLD	OLDSTK		;recover cpm stack
	SPHL			;restore it

	IF	INTRP
	EI
	ENDIF

	RET			;go back to operating system
;
;conv - convert letters from lower case
;	to upper case.
;entry:	accum = char to convert
;exit:	accum = converted char if lower case
;
CONV:	CPI	'a'		;check case
	RC			;upper case already.
	CPI	'z'+1
	RNC
	ANI	5FH		;if lower case, change it
	RET
;
; restore drive to track 00
;
START:	LXI	D,CRLF		;print cr,lf on console
	MVI	C,9
	CALL	ENTRY
	MVI	A,RSTOR+STPRAT+HLAB	;restore head to trk 0
	OUT	DCOM		;issue home cmd
	IN	WAIT		;wait for home
	MVI	C,0		;set track number to 0
	MVI	H,77		;set total tracks to 77
FORMAT:
	CALL	SIDE0
	MVI	A,5		;retrys
	STA	ERRCNT		;save it
RFORMAT:PUSH	B		;save b,c
	PUSH	D
	PUSH	H
	LXI	D,FMSG0		;format msg
	MVI	C,9
	CALL	ENTRY
	POP	H
	POP	D
	POP	B
	CALL	NXTTRK		;format the disk
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,RMSG0		;read msg
	MVI	C,9
	CALL	ENTRY
	POP	H
	POP	D
	POP	B
	CALL	READ		;test formatted track
	ORA	A		;read ok?
	JZ	SIDE		;yes,	check for side 1
	LDA	ERRCNT		;error, decrease count
	DCR	A
	STA	ERRCNT
	JNZ	RFORMAT		;reformat and check again
	LXI	D,DISKER	;point to error message
	MVI	C,9
	CALL	ENTRY
	JMP	BGIN2		;exit and return to start.
SIDE:
	LDA	DUBSID		;check if doing double sided
	ORA	A		;zero = single sided only
	JZ	NEWTRK		;do other side if <> 0
	CALL	SIDE1		;now do side 1
	MVI	A,5
	STA	ERRCNT
RFMAT:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FMSG1		;format side 1 msg
	MVI	C,9
	CALL	ENTRY
	POP	H
	POP	D
	POP	B
	CALL	NXTTRK
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,RMSG1
	MVI	C,9
	CALL	ENTRY
	POP	H
	POP	D
	POP	B
	CALL	READ		;check for disk errors
	ORA	A		;errors?
	JZ	NEWTRK		;no
	LDA	ERRCNT		;error, decrease count
	DCR	A
	STA	ERRCNT
	JNZ	RFMAT		;reformat and check again
	LXI	D,DISKER	;point to error message
	MVI	C,9
	CALL	ENTRY
	JMP	BGIN2		;exit to start
NEWTRK:	INR  C			;bump track #
	DCR  H			;trk count =count -1
	JNZ  BMPTRK 		;if not 0 then do more
	JMP  BGIN2		;go back to do routine again
;
SIDE0:	LDA	SDRIVE
	ANI	10110000B	;select side 0
	OUT	WAIT
	RET
;
SIDE1:	LDA	SDRIVE
	ORI	01000000B	;select side 1
	OUT	WAIT
	RET
;
BMPTRK:	MVI  A,STEP+HLAB+STPRAT	;load step in
	OUT  DCOM   		;step in
	IN	WAIT
	ORA	A
	IN  WAIT		;wait til done
	IN   DSTAT  		;check status
	JMP  FORMAT
;
NXTTRK:	MVI	D,1		;sector cnt to 0
	MVI	E,26		;set max # sectors -1 
	MVI	B,40		;gap 4 preindex 40 bytes of ff
	MVI	A,0F4H		;load track write command
	OUT	DCOM		;issue track write
;
; write preindex fill
;
PREIND:	IN	WAIT		;wait for drq
	ORA	A		;set flags
	JP	ERRMSG		;jmp out if error
	MVI	A,0FFH		;load preindex fill
	OUT	DDATA		;write it on disk
	DCR	B		;count = count - 1
	JNZ	PREIND		;go back till b =0
	MVI	B,6
PREIN1:	IN	WAIT
	ORA	A
	JP	ERRMSG
	XRA	A
	OUT	DDATA
	DCR	B
	JNZ	PREIN1
;
; write address mark on track
;
	IN	WAIT		;wait for drq
	ORA	A		;set flags
	JP	ERRMSG		;jmp out if error
	MVI	A,0FCH		;load address mark
	OUT	DDATA		;write it on disk
;
; post index gap
;
	MVI	B,26		;set # of bytes
POSTID:	IN	WAIT		;wait for drq
	ORA	A		;set flags
	JP	ERRMSG		;jmp out if error
	MVI	A,0FFH		;load fill data
	OUT	DDATA		;write it on disk
	DCR	B		;count = count - 1
	JNZ	POSTID		;if not 0 go back
;
; pre id section
;
ASECT:	MVI	B,6		;get # of bytes
SECTOR:	IN	WAIT		;wait for drq
	ORA	A		;set flags
	JP	ERRMSG		;jmp out if error
	XRA  A			;make a = 0
	OUT  DDATA  		;write it on track
	DCR  B			;count = count=1
	JNZ  SECTOR 		;jmp back if not done
;
; write id address mark
;
	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;if error jmp out
	MVI  A,0FEH 		;get address mark
	OUT  DDATA  		;write it on disk
;
; write track number on disk
;
	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	MOV  A,C		;get track number
	OUT  DDATA  		;write it on disk
;
; write one byte of 00
;
	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	XRA  A			;set a to 0
	OUT DDATA   		;write it on disk
;
; write sector # on disk
;
	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	MOV  A,D		;get sector #
	OUT DDATA   		;write it on disk
;
; one more byte 0
;
	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	XRA  A			;set a to 00
	OUT  DDATA  		;write it on disk
	INR  D			;bump sect. #
;
; write 2 crc's on this sector
;
	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	MVI  A,0F7H 		;get crc pattern
	OUT DDATA   		;write it on disk
;
; pre data 17 bytes ff's
;
	MVI  B,11   		;set count
PREDAT:	IN   WAIT   		;wait for drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	MVI  A,0FFH		;set a to ff
	OUT  DDATA  		;write it on disk
	DCR  B			;reduce count by 1
	JNZ  PREDAT 		;go back if not done
	MVI  B,6
PREDA1:	IN   WAIT
	ORA  A
	JP   ERRMSG
	XIN   WAIT
	ORA  A
	JP   ERRMSG
SPBYTE:	MVI  A,0E7H		;doub sided byte
	OUT  DDATA
	DCR  B
	JNZ  SPFILL
;
; write crc's
;
	IN   WAIT   		;wait till drq
	ORA  A			;set flags
	JP   ERRMSG 		;jmp out if error
	MVI  A,0F7H 		;get crc byte
	OUT  DDATA  		;write it on disk
;
; end of sector fill
;
	DCR  E			;reduce sector count
	JZ  ENDTRK		;if 0 do end of track rtn
DATGAP:	IN WAIT			;wait for drq
	ORA  A			;set flags   
	JP   ERRMSG 		;jmp out if error
	MVI  A,0FFH		;get fill character
	OUT  DDATA  		;write it on disk
	JMP  POSTID-2 		;go back for more
;
; do track & sector house keeping
;
ENDTRK:
	MVI  A,0E5H
	STA  SPBYTE+1
	IN   WAIT   		;wait for drq or intrq
	ORA  A			;set flags
	JP   DONE   		;jmp out if error
	MVI  A,0FFH		;load a with ffh
	OUT  DDATA  		;write it on disk
	JMP  ENDTRK 		;do until intrq
;
DONE:	IN	DSTAT		;check status
	ANI	0FFH
	JNZ	ERRMSG
	RET			;return to caller
;
;disk read test routine.
;checks disk for errors
;after track is formatted.
;
;entry:	none
;exit:	accum = 0 if formatted ok
;	accum = ff if more than 5 retrys
;
READ:	PUSH	B		;save formatting registers
	PUSH	D		; on stack
	PUSH	H
READ1:	MVI	C,1		;start reading at sector 1
	MVI	B,26		;read 26 sectors total
READL:	CALL	DSKSET		;set up disk command
	ORA	D		;or in read command
	OUT	DCOM
RLOOP:	IN	WAIT		;wait for intrq
	ORA	A		;set flags
	JP	RDONE		;read finished when positive
	IN	DDATA		;read a byte
	JMP	RLOOP		;accum = infinate bit bucket
RDONE:	IN	DSTAT		;check status
	ANI	0CH		;check crc and rnf bits only
	JZ	RNXT		;if = 0, read next sector
	JMP	REXIT		;return to format program
RNXT:	INR	C		;bump sector number
	DCR	B		;decrease total sectors
	JNZ	READL		;more to read.
REXIT:	POP	H
	POP	D
	POP	B		;registers restored.
	RET			;return with error code.
;
DSKSET:	MVI	A,0D0H		;force intrp command
	OUT	DCOM
	MVI	D,READC		;get read command
	MOV	A,C		;get sector number
	OUT	SECTP
	IN	DSTAT		;check head load bit
	ANI	20H
	MVI	A,0
	RZ
	MVI	A,4		;set head load bit
	RET
;
;error routine
;
ERRMSG:	LXI	D,ERROR
	MVI	C,9
	CALL	ENTRY
	LXI	SP,STACK	;reset local stack
	JMP	BGIN2		;restart program
;
ERROR:	DB	BELL,0DH
	DB	'*********************************************',0DH,0AH
	DB	'*					    *',0DH,0AH
	DB	'*       E R R O R  in formatting disk       *',0DH,0AH
	DB	'*					    *',0DH,0AH
	DB	'*********************************************',0DH,0AH
	DB	0DH,0AH,'Check for write protected disk',0DH,0AH
	DB	BELL,'$'
DISKER:	DB	BELL,0DH
	DB	'*********************************************',0DH,0AH
	DB	'*					    *',0DH,0AH
	DB	'*    Fatal disk errors, try another disk    *',0DH,0AH
	DB	'*					    *',0DH,0AH
	DB	'*********************************************',0DH,0AH
	DB	BELL,'$'
MSG:	DB	0DH,'Tarbell Electronics Single density,single sided'
	DB	0DH,0AH
	DB	'Single density,double sided format program',0DH,0AH
	DB	'Version 1.2  dated 9-23-80',0DH,0AH
	DB	'Assembled to run on Tarbell Double Density Interface',0DH,0AH
	DB	0DH,0AH,'Formats 76 tracks',0DH,0AH
	DB	'26 sectors/track with 128 bytes/sector',0DH,0AH,0DH,0AH,'$'
RDY:	DB	'Blank disk ready to FORMAT? (Y or N) $'
DRIVE:	DB	0DH,'Drive to format (A,B,C,D) or Q to quit? $'
DUBMSG:	DB	0DH,0AH,'Format a Double Sided Disk (Y or N)? $'
FMSG0:	DB	0DH,'Formatting Side 0 $'
RMSG0:	DB	0DH,'Reading    Side 0 $'
FMSG1:	DB	0DH,'Formatting Side 1 $'
RMSG1:	DB	0DH,'Reading    Side 1 $'
CRLF:	DB	0DH,0AH,'$'
;
	DS	128			;stack area
STACK:	DS	1			;internal stack
OLDSTK:	DS	2			;cpm stack saved here
SDRIVE:	DS	1			;drive select code
DUBSID:	DS	1			;0=single sided format
ERRCNT:	DS	1			;disk retrys
	END	BEGIN
Drive to format (A,B,C,D) or Q to quit? $'
DUBMSG:	DB	0DH,0AH,'Format a Double Sided Disk (Y or N)? $'
FMSG0:	DB	0DH,'Formatting Side 0 $'
RMSG0:	DB	0DH,'Reading    Side 0 $'
FMSG1:	DB	0DH,'Formatting Side 1 $'
RMSG1:	DB	0DH,'Reading    Side 1 $'
CRLF:	DB	0DH,0AH,'$'
;
	DS	128			;stack area
STACK:	DS	1			;internal stack
OLDSTK:	DS	2			;cpm stack saved here
SDRIVE:	DS	1		 		NAME	 MEMTST
                TITLE    Z80 MEMORY TEST
		;
		;Memory Diagnostic for Z-80
                ;
                ;Version 2.3  1 Sept 1980
                ;
                ;Copyright 1980 by
                ;Ray Duncan
                ;Laboratory Microsystems
                ;4147 Beethoven Street
                ;Los Angeles, CA 90066
    		;
		;Configure