
	IF KTM
CONRDY	EQU	00000010B	;CONSOLE DATA WAITING
MODRDY	EQU	CONRDY
MODOUT	EQU	00000001B	;MODEM READY FOR DATA
CONOT	EQU	MODOUT
	ENDIF
;
	ORG	100H	;CP/M TRANSIENT PROGRAM AREA
	LXI	H,0	;CLR 'HL'
	DAD	SP	;SAVE CP/M STACK
	SHLD	STACK	;
	LXI	SP,STACK	;MODEM STACK
	CALL	BEGIN	;GO TO PRINT 'ID'
	DB	'DUMB TERMINAL MODEM',CR,LF
	DB	'REVISED 5/4/80',CR,LF,'$'
;
BEGIN	POP	D	;GET ID MESSAGE
	MVI	C,PMSG
	CALL	BDOS	;TO PRINT
;
	LXI	H,BUFF	;SET BUFFER 'STORE' POINTER
	LXI	D,BUFF	;SET BUFFER 'FETCH' POINTER
;
;	COMMAND LOOP BEGINS HERE AND TESTS EACH
;	INPUT AND STATUS PORT.  JUMPS TO ACTIVE
;	ROUTINE OR RECYCLES WHEN BUSY.  NO WAITS.
;
START	IN	MODST	;TEST FOR DATA IN
	ANI	MODRDY	;WITH A  READY BIT
;
	IF IMSAI
	JNZ	KBRD	;IF NO DATA, SKIP TO NEXT
	ENDIF
;
	IF KTM
	JZ	KBRD	;IF NO DATA SKIP TO NEXT
	ENDIF
;
	IN	MODDTA	;FETCH THE DATA
	MOV	M,A	;STORE IT
	INR	L	;BUMP POINTER
;
;	TEST FOR KEYBOARD DATA INPUT, PRINTER AND
;	REBOOT TO CP/M.
;
KBRD	IN	CONST	;STATUS TEST
	ANI	CONRDY	;KEY DEPRESSED?
;
	IF IMSAI
	JNZ	SPOOL	;IF NOT, SKIP TO NEXT
	ENDIF
;
	IF KTM
	JZ	SPOOL
	ENDIF
;
	IN	MODST	;TEST MODEM STATUS
	ANI	MODOUT	;MODEM FREE?
;
	IF IMSAI
	JNZ	SPOOL	;IF NOT TRY LATER
	ENDIF
;
	IF KTM
	JZ	SPOOL
	ENDIF
;
	IN	CONDTA	;ELSE GET DATA
	ANI	7FH	;STRIP BIT 7
	CPI	CNTLP	;'CNTL P'
	JZ	CHGPFLG	;CHANGE PRINT FLAG
	CPI	DONE	;TEST FOR 'CTRL X'
	JZ	EXIT	;BACK TO CP/M
;
OUTDTA	OUT	MODDTA	;SEND VIA MODEM
;
;	TEST HERE FOR DATA WAITING IN BUFFER
;
SPOOL	MOV	A,E	;TEST BUFFER
	CMP	L	;POINTERS FOR DATA
	JZ	START	;IF EQUAL, RELOOP
;
;	SPOOLER SAVES DATA 
;
	IN	CONST	;SEE IF PRINTER
	ANI	CONOT	;STILL BUSY
;
	IF IMSAI
	JNZ	START	;IF SO, RELOOP
	ENDIF
;
	IF KTM
	JZ	START
	ENDIF
;
	LDAX	D	;FETCH CHAR FROM BUFFER
	INR	E	;BUMP POINTER
	PUSH	D	;SAVE FETCH POINTER
	PUSH	H	;SAVE STORE POINTER
	MOV	E,A	;PUT CHAR IN 'E'
;
;	TEST FOR 'PRINT' FLAG
;
	LDA	PRNTFLG	;GET FLAG BYTE
	CPI	00H	;TEST BYTE
	JZ	SCREEN	;NO PRINT
;
	PUSH	D	;SAVE CHAR FOR SCREEN
	MVI	C,PRINT	;PRINT COMMAND
	CALL	BDOS	;EXECUTE
	POP	D	;RESTORE CHAR
;
SCREEN	MVI	C,SCRN	;SCREEN COMMAND
	CALL	BDOS	;EXECUTE
	POP	H	;RESTORE STORE POINTER
	POP	D	;RESTORE FETCH POINTER
	JMP	START	;TO RE-CYCLE
;
;	CHANGE 'CNTL P' PRINT FLAG
;
CHGPFLG	LDA	PRNTFLG	;GET FLAG
	CMA		;INVERT IT
	STA	PRNTFLG	;RESAVE IT
	JMP	START	;RELOOP
;
;	RETURN TO CP/M
;
EXIT	LHLD	STACK	;GET ORIGINAL STACK
	SPHL		;RESTORE STACK POINTER
	JMP	REBOOT	;DONE SO EXIT
;
	DS	20H	;STACK AREA
STACK	DS	2	;STACK POINTER
;
PRNTFLG	DB	0	;PRINT FLAG
;
	END
;

	;RESTORE STORE POINTER
	POP	D	;RESTORE FETCH POINTER
	JMP	START	;TO RE-CYCLE
;
;	CHANGE 'CNTL P' PRINT FLAG
;
CHGPFLG	LDA	PRNTFLG	;GET FLAG
	CMA		;INVERT IT
	STA	PRNTFLG	;RESAVE IT
	JMP	START	;RELOOP
;
;	RETURN TO CP/M
;
EXIT	LHLD	STACK	;GET ORIGINAL STACK
	SPHL		;RESTORE STACK POINTER
	JMP	REBOOT	;DONE SO EXIT
;
	DS	20H	;STACK AREA
STACK	DS	2	;STACK POINTER
;
(Updated and corrected 04/03/82)

  The compiled version of PACMAN (PACMAN95.OBJ) can be easily 
patched any terminal that has the following characteristics:

1.  A CLEAR SCREEN command of 2 characters of less

2.  A CURSOR ADDRESSING command that is of the form:
     <ESC> <char> <ROW> <COLUMN>    with offset = 32

3.  A CURSOR ON and CURSOR OFF command that is of the form:
     <char> <char> <char>
    (This is not necessary however)


  The points to patch for CLEAR SCREEN are:
Address: 2FDAH ====> First character    (Currently ESC)
         2FDBH ====> Second character   (Currently ";")

  The points to patch for CURSOR ADDRESSING are:
Address: 37F3H ====> First character    (Currently ESC)
         37FCH ====> Second character   (Currently "=")

  The points to patch for CURSOR ON are:
Address: 3D9EH ====> First character    (Currently ESC)
         3D9FH ====> Second character   (Currently ".")
         3DA0H ====> Third character    (Currently "1")

  The points to patch for CURSOR OFF are:
Address: 27DCH ====> First character    (Currently ESC)
         27DDH ====> Second character   (Currently ".")
         27DEH ====> Third character    (Currently "0")

  The direction keys are located:
Address: 347BH ====> Move LEFT          (Currently "S")
         34ABH ====> Move DOWN          (Currently "X")
         3493H ====> Move UP            (Currently "E")
         3487H ====> Move RIGHT         (Currently "D")

  The QUIT character ("Q") is located at address 34E7H.

This version is set-up to work with a TeleVideo 950 terminal.
PACMAN89.OBJ is set-up to work with an H89 terminal.  Both
files are the same, except for the patching information.

          (Currently "S")
         34ABH ====> Move DOWN          (Currently "X")
         3493H ====> Move UP            (Currently "E")
         3487H ====> Move RIGHT         (Currently "D")

  The QUIT character ("Q") is located at address 34E7H.
*         K͞+GG7S'+FÎr͖
8{Ăw#w#w^#V#*~#fo^# *~#fo^#V#*n^# *n^#V#	~#fo^#& 	~#fo! +!  #! +!  #! +! +        }|z{|}|z7||7zZZ)|/g}/o#  |͉k|/g}/o#ɯ2qZZk:q|/g}/o#|/g}/o#:q<2qqDM!  xxGyO҃)v|͔`i|)Öx  ڷz/W{/_ѯzW{_=yOxGæ2qZZ͉M|}ȯ|g}o)|/g}/o#z/W{/_! 9~#fo! 
! 
!
 
! 
! 
! 
! 9~#A"s!`*"!"!Y">2>2>22! "! "!@ "! "  ʞ ! F#x± ~#±! b2r~# "2r+}|~#G:rx"2r+w# +6 #!6 #2w2x*s!>r<o& F=-  `
r'~h 6 !  +`W?_ !~7z?`:> ª@w#G.¶w w#?*>?w#> w#.7:77!a{  
	
`OE!y6$ -7rBo& ))T])))!y                 ":>""G#Ϳ,"x
..Ϳ,.ͭ'5':>?2>I#:>>2>
*<-*N*l*2>ͻ':?[#7/ͽ6:>1$:>$:?$_,:>#)#>66:?6#*?|£#2͈7#>66:?6>#6>66:	?6#*?">)#>6:?6>s6>@2>#2͈7#ͺ)#:>=2>))$>s6#́)($2:>"$2͈7#3͈7#*>">*?">:?ʒ$:>s$)f$>>6:?62͈7#2͈726 *H 6#6 *J w#w*L w#w*N w#w*8 ~#fo*R ~#fo~#fo*R ~#fo##~#foͭ`iw#w`i~#fo! 	~#fo+ҧ	!@ `i~#fo ?! ͭ`i^#Vr+si	* ! 	s#r! 	w#w! 	~#fo|~
! 	~#fo! 	~#fo) s#r! 	~#fo##6
#6 ! 	~#fo w#w! 	~#fo w#w! 	~#fo w#w! 	~#fo
 w#w!M ! 	~#fo~#fo! 	~#fo##~#foͭ! 	^#V! r+s! 	^#Vr+sþ	*: w#w*: ^#Vr+s!
 |¦
Ͱͳ*< ~#fo#|½
ò! 	w#w! 	~#fo|
! 	~#foͶ! 	^#Vr+s
*< ~#fo#|ò*R ~#fo ~#fo+|5ͳ*< ~#fo#|5ò! 	6#6 ! 	~#fo|j! 	~#foͶ! 	^#Vr+s>*< ~#fo#|~ò*@ ~#fo+|*D ~#fo|©! ì!  *D ~#fo!M
*ͪ*!< ! ͧ*D ^#Vr+s!|҄!S
!- ! ͧ*@ w#w*R ~#fo w#w*R ~#fo w#w! 	w#w! 	~#fo|҄! 	~#fo k*  6#6 ! 	^#Vr+sD͹*B ~#fo|ҡͼ*< ~#fo#|
!o
!- ! ͧ!
!- ! ͧ! Ϳ! 	^#Vr+s!
!- ! ͧ!
!- !	 ͧ! 9SCORE:  gold left =  %6d COUNTDOWN:  delay = %6d %2d%c                          YOU ARE BEING EATEN THIS TAKES ABOUT 2 SECONDS THE MONSTERS ALWAYS TRIUMPH IN THE END! 
?40/5!9DM*> ~#fo! 	s#r! 	~#fo|! 	^#Vr+s
!  
*R ~#fo~#fo! 	s#r*R ~#fo##~#fo! 	s#r! 	~#fo( k*! 	~#fo6 *R ~#fo ~#fo>> ʲ>> z>£> B>¯> M[*8 6^#6 ! 	~#fo+( k*! 	~#fon`i s#r>.> *> > *>*> *>%> *>$'> *a!  ! 	~#fo! 	~#fo
*R ~#fo##~#fo+s#rw*R ~#fo w#ww[*8 6v#6 ! 	~#fo#( k*! 	~#fon`i s#r>.¿> > > >*> >%> >$> )!  ! 	~#fo! 	~#fo
*R ~#fo##~#fo#s#r?*R ~#fo w#w?[! 	~#fo|!  ! 	~#fo! 	~#fo
*R ~#fo6&#6 `i6 #6 [*8 6<#6 ! 	~#fo( k*! 	~#fo++n`i s#r>.> > > >*> >%> >$> 4!  ! 	~#fo! 	~#fo
*R ~#fo~#fo++s#rJ*R ~#fo w#wJ[! 	~#fo|!  ! 	~#fo! 	~#fo
*R ~#fow#w`i6 #6 [*8 6>#6 ! 	~#fo( k*! 	~#fo##n`i s#r>.> > > >*> >%> >$	> B!  ! 	~#fo! 	~#fo
*R ~#fo~#fo##s#rX*R ~#fo w#wX[`i~#fo>*m> ʔ>.y> ʔ>$> ʳ>%> Ý*q^#Vr+s*B ^#Vr+sÝ*q~#fo s#rÝ!!- ! 
*@ 6#6 *D 6#6 *R ~#fo 6#6 *R ~#fo 6#6 * !
 	s#r! 	w#w! 	~#fo|Қ!
 	~#fo
 ~#fo+|{!
 	~#fo w#w!
 	~#fo w#w!
 	^#V! r+s! 	^#Vr+s4Ý* !
 	s#r! 	w#w! 	~#fo|U!
 	~#fo~#fo*R ~#fo~#fo+!
 	~#fo##~#fo*R ~#fo##~#fo+! 	~#fo
*< s#r6*< w#w!
 	^#V! r+s! 	^#Vr+sô*< ~#fo#|ʚ*8 ~#fo*R ~#fo~#fo*R ~#fo##~#fo
! 9COUNTDOWN:  ø0Í7!9DM*@ ~#fo+|* `is#r! 	w#w! 	~#fo|`i~#fo
 ~#fo|µ! 	~#fo)*6#6 !  `i~#fo~#fo`i~#fo##~#foͲ`i~#fo##6#6 `i~#fo6#6 `i~#fo w#w`i~#fo 6#6 `i~#fo
 6#6 !M ! ! Ͳ`i~#fo ! ͵##s#r`i^#V! r+s! 	^#Vr+s! 9057!9DM! 	~#fo k* ! 	s#r! 	~#fo~#fo! 	s#r! 	~#fo##~#fo! 	s#r! 	~#fo
 ~#fo+|*m~#fo !
 	s#r!
 	~#fo+|ʯ!
 	~#fo|*: ~#fo+! 	~#fo)*~#fo|! 	~#fo( k*! 	~#fon& ! 	~#fo! 	~#fo! 	~#fo ! 	~#fo! 	~#fo! 	~#fos#r! 	~#fo ~#fo>=> d>I> ʆ>U> ʨ>a> ! 	~#fo+! 	s#r! 	~#fo`is#r! 	~#fo#! 	s#r! 	~#fo`is#r! 	~#fo++`is#r! 	~#fo! 	s#r`i~#fo|`i6&#6 ! 	~#fo##`is#r! 	~#fo! 	s#r`i~#fo|`iw#w! 	~#fo( k*`i~#fon}.X X%X$X*Xö! 	~#fo`i~#fos#r! 	~#fo##! 	~#fos#r! 	~#fo*R ~#fo##~#fo`i~#fo*R ~#fo~#fo! 	~#fo*< s#r! 	~#fo)**q~#fod ͉#s#r!
 	~#fo+|U*< ~#fo#|U!
 	~#fo|³*: ~#fo! 	~#fo)*~#fo|³! 	~#fo ~#fo+|!M `i~#fo! 	~#foó*< ~#fo+|ʳ!S `i~#fo! 	~#fo!! 9bad direction Í7!9DM`iw#w!, 	~#fo( k*!* 	~#fo!" 	s#r!( 	~#fo ~#fo!  	s#rzʀ!" 	~#fon! 	 s#r!|ʀ! 	~#fo|ʀ`i^#Vr+s)! 	6#6 !  	~#fo+|!" 	~#fo( n! 	 s#r!|! 	~#fo|`i^#Vr+s)! 	6#6 !  	~#fo+++|,!" 	~#fo++n! 	 s#r!|,! 	~#fo|,`i^#Vr+s)! 	6#6 !  	~#fo++|ʁ!" 	~#fo##n! 	 s#r!|ʁ! 	~#fo|ʁ`i^#Vr+s)! 	6#6 *m~#fo+++|ʨ*m~#fo++++|8!*q~#fo8*R ~#fo ~#fo+|!  	~#fo>> >> W>> ʗ>> !" 	~#fo( n}#T!" 	~#fo( n}-T`i^#Vr+s)! 	6#6 !" 	~#fon}#ʔ!" 	~#fon}-ʔ`i^#Vr+s)! 	6#6 !" 	~#fo++n}#!" 	~#fo++n}-`i^#Vr+s)! 	6#6 !" 	~#fo##n}#!" 	~#fo##n}-`i^#Vr+s)! 	6#6 !* 	~#fo*R ~#fo~#fo! 	s#r!, 	~#fo*R ~#fo##~#fo! 	s#r! 	~#fo|x! 	6#6 Ù! 	~#fo|ґ! 	6#6 Ù! 	w#w! 	~#fo|ڶ! 	6#6 ! 	~#fo|! 	6#6 ! 	w#w! 	w#w! 	w#w! 	~#fo`i~#fo*R ~#fo ~#fo|! 	~#fo)! 	~#fo! 	~#fo[! 	~#fo)! 	~#fo! 	~#fo! 	^#Vr+s)! 	! 	~#fo)! 	~#fos#r! 	~#fo)! 	~#fo! 	~#fo! 	~#fo)! 	~#fo! 	~#fo! 	^#Vr+s)! 	! 	~#fo)! 	~#fos#r! 	^#Vr+s! 	~#fo|8! 	~#fo)! 	~#foQ`i~#fo)! 	~#foQ!$ 9u{C7=G8?4þ/	>!9DM`iw#w!  ]`*8 6@#6 *F *R s#r!'*T c!(*| c!>(* c!f(* c!(* c!(*c!(*Dc!)*lc!.)*c!V)*c!~)*c!)*c!)*4c!)*\c!**c!F**c!n**c!**c!**$c!**Lc!+*tc!6+*c!^+*c!+*c!+*c!+*<c!+*dc!&,*c!N,*c!v,*c!,*c!,*,c!,*Tc!-*|c!>-*c!f-*c!-*c!-*c!-*Dc!.*lc!..*c!V.*c!~.*c!.*c!.*4c!.*\c!/*c!F/*c!n/*c!/*c!#.## . ### . # . ########### . # . ### . # *$c!B#j## . . . . # . . . ### . . . # . . . . # *Lc!~#æ######## . ##### . ### . ##### . ####### *tc!##      # . # . . . . . . . . # . #       *c!#$      # . # . ### - - ### . # . #       *c!2$Z$####### . # . #         # . # . ####### *c!n$Ö$        . . . #         # . . .         *	c!$$####### . # . #         # . # . ####### *<	c!$%      # . # . ########### . # . #       *d	c!"%J%      # . # . . . . . . . . # . #       *	c!^%Æ%####### . # . ########### . # . ####### *	c!%%# . . . . . . . . ### . . . . . . . . # *	c!%%# % ### . ##### . ### . ##### . ### % # *
c!&:&# . . # . . . . . . . . . . . . # . . # *,
c!N&v&### . # . # . ########### . # . # . ### *T
c!&ò&# . . . . # . . . ### . . . # . . . . # *|
c!&&# . ########### . ### . ########### . # *
c!'#####       # . # . . * . . * . . # . #             # . # . ### - - ### . # . #       ####### . # . #         # . # . #######         * . * #         # * . *         ####### . # . #         # . # . #######       # . # . ########### . # . #             # . # * . . . . . . * # . #       ####### . # . ########### . # . ####### # . . . * . * . . ### . . * . * . . . # # % ### . ##### . ### . ##### . ### % # # . . # * . * . * . . * . * . * # . . # ### . # . # . ########### . # . # . ### # . * . . # . . . ### . . . # . . * . # # . ########### . ### . ########### . # # . . . . . . . * . . * . . . . . . . # ####################################### ####################################### # . . . * . . . . ### . . . . * . . . # # % ### . ##### . ### . ##### . ### % # # * . . * . * . * . . * . * . * . . * # # . ### . # . ########### . # . ### . # # . . . * # . . . ### . . . # * . . . # ####### . ##### . ### . ##### . #######       # . # . . * . . * . . # . #             # . # . ### - - ### . # . #       ####### . # . #         # . # . #######         * . * #         # * . *         ####### . # . #         # . # . #######       # . # . ########### . # . #             # . # * . . . . . . * # . #       ####### . # . ########### . # . ####### # . . . * . * . . ### . . * . * . . . # # % ### . ##### . ### . ##### . ### % # # . . # * . * . * . . * . * . * # . . # ### . # . # . ########### . # . # . ### # . * . . # . . . ### . . . # . . * . # # . ########### . ### . ########### . # # . . . . . . . * . . * . . . . . . . # ####################################### ####################################### # . . . . . . . . ### . . . . . . . . # # % ### . ##### . ### . ##### . ### % # # . . . . . . . . . . . . . . . . . . # /	><!//! /; /*=	>!  9DM! 	~#fo! 	~#fo/! 	~#fo/0*=ßC!  9DM! 	~#fo! 	~#fo0! 	n& 0S0â=/!9DM*q~#fo!0`iM0`i!4 !  P0*B ~#fo!0`iM0`i!9 ! P0!
 9%6d %6d !9DM! 	w#w! 	~#fo|ҵ1`iw#w`i~#fo|ҧ1! 	~#fo( k*T `i~#fon! 	s! 	~#fo( k*`i~#fo! 	ns! 	~#fo( k*`i~#fo! 	ns{*1! 	~#fo( k*`i~#fo6.`i^#Vr+s0! 	^#Vr+s0*B 6#6 *> ~#fo*> ~#fo
 s#r! 92F?4þ/*=;>r=!9DM!2 1!  11*m~#fo|B3! 	6#6 ! ! 	^#Vr+s1!N32! ! 	^#Vr+s1!l32! ! 	^#Vr+s1!32! ! 	^#Vr+s1!32! ! 	^#Vr+s1*m~#fo!32! ! 	^#Vr+s1!32! ! 	^#Vr+s1*q~#fo!42! ! 	~#fo1!!422! 9 ___________________________  |                           | | G A M E   O V E R         | |                           | | Game type: %1d              | |                           | | Your score: %-5u         | |___________________________| K4CC1!9DMB4|^45E4! 	s#r! 	~#fo |g}o>S4> 15>D4> H5>E4> _5>wª4> _5>X¶4> v5>x4> v5> 4> ʍ5>4> ʣ5>4> ʣ5>Q4> ʣ5>4> ʩ5>1