/********************************************************************
 *
 *	Program: 3
 *
 *	Quick Sort as described by Knuth Pg 116
 *
 *	Author: Timothy C. Leslie
 *
*********************************************************************
 *
 *	This program performs a quick sort on n records.  It is
 *	independent of the record and key.  This independence is
 *	possible because pointers to a key comparison funcion and
 *	record swaping function are passed to the sort. The function
 *	calling convention is:
 *
 *	qsort(n,comp,swap)
 *
 *	where:	n is the number of records to sort.
 *		comp is a pointer to a function which will compare
 *		  two record keys and return an integer representing
 *		  the logical relationship of the keys.
 *		  <0 key[i] <  key[j] (ascending) key[i] > key[j] (descending)
 *		  =0 key[i] == key[j]
 *		  >0 key[i] >  key[j] (ascending) key[i] < key[j] (descending)
 *		swap is a pointer to a function which will swap two
 *		  records.
 *
 *	Both comp and swap are called with two parameters which are
 *	indicies to records with the first record being 0 and the last
 *	record being n-1.
 *
*********************************************************************
 *
 *	This program illustrates the use of pointers to functions.
 *	In this program the pointers to functions are used to allow
 *	the sort algorithm to function independent of the data record.
 *	Additionally the quick sort illustrates a recursive function.
 *	Recursion is used to allow partitioning of the records into
 *	smaller sub-groups for sorting purposes.
 *
 *	It should be noted that unsigned variables are used for counters
 *	and indicies. This declaration not only allows twice the range
 *	for indicies as integer but will allow for more efficient code
 *	on most processors.  Most processors inherently do unsigned
 *	arithmetic, allowing for fast adds and subtracts, but few will
 *	do signed arithmetic thereby forcing more code to be generated
 *	in order to properly handle the sign of the number.
 *
*********************************************************************
 *
 *			Comments
 *
 *	Line 0001	Two static variables are used for storage
 *			of the pointers to functions in order to
 *			decrease the number of parameters passed
 *			to the recursive functions in quick sort.
 *
 *	Line 0002	This is the main entry point for the quick
 *			sort.  Three parameters are passed.
 *
 *	Line 0003	The number of records to be sorted is the
 *			first parameter and is an unsigned value.
 *
 *	Line 0004	The second parameter is a pointer to a function
 *			which compares all keys of two records, and
 *			returns an integer which expresses the following
 *			relationships for an ascending order sort.
 *
 *			r[i]-r[j] such that:
 *				if (r[i] > r[j])
 *					return (1);
 *				if (r[i] == r[j])
 *					return (0);
 *				if (r[i] < r[j])
 *					return (-1);
 *
 *			If fact if the two keys were integers the code
 *			can be:
 *
 *				return(r[i]-r[j]);
 *
 *			qsort() will adjust the pointers i and j so that
 *			they are relative base 0.
 *
 *	Line 0005	The third parameter is a pointer to a function
 *			which swaps two records.
 *
 *			qsort() will adjust the pointers i and j so that
 *			they are relative base 0.
 *
 *	Line 0007	The static variable _comp is set to the parameter
 *			comp.
 *
 *	Line 0008	The static variable _swap is set to the parameter
 *			swap.
 *
 *	Line 0009	The recursive static function _quick is executed
 *			with a lower bound of 0 and an upper bound of n-1.
 *
**************************************************************************/


static	(*_comp)(),(*_swap)();					/* 0001 */



qksort(n,comp,swap)						/* 0002 */

unsigned	n;						/* 0003 */
int	(*comp)();						/* 0004 */
int	(*swap)();						/* 0005 */

{								/* 0006 */
	_comp=comp;						/* 0007 */
	_swap=swap;						/* 0008 */
	_quick(0,n-1);						/* 0009 */

}								/* 0010 */

static	_quick(lb,ub)						/* 0011 */

unsigned	lb,ub;						/* 0012 */

{								/* 0013 */
	unsigned	j;					/* 0014 */
	if(lb<ub){						/* 0015 */
		if(j=_rearr(lb,ub))				/* 0016 */
			_quick(lb,j-1);				/* 0017 */
		_quick(j+1,ub);					/* 0018 */
	}							/* 0019 */
}								/* 0020 */

static	unsigned _rearr(lb,ub)					/* 0021 */

unsigned lb,ub;							/* 0022 */

{								/* 0023 */
	do{							/* 0024 */
		while(ub>lb && (*_comp)(ub,lb)>=0)		/* 0025 */
			ub--;					/* 0026 */
		if(ub!=lb){					/* 0027 */
			(*_swap)(ub,lb);			/* 0028 */
			while(lb<ub && (*_comp)(lb,ub)<=0)	/* 0029 */
				lb++;				/* 0030 */
			if(lb!=ub)				/* 0031 */
				(*_swap)(lb,ub);		/* 0032 */
		}						/* 0033 */
	}while(lb!=ub);						/* 0034 */
	return lb;						/* 0035 */
}								/* 0036 */

