	page
;	CP/M to host disk constants

HSTSIZ:	EQU	1024		;Blocking/Deblocking buffer size
CPMSIB:	EQU	1024/128	;Standard sectors in block
FPYSIB:	EQU	2048/128	;Sectors in floppy disk block
HRDSIB:	EQU	4096/128	;Sectors in hard disk block

;	CP/M disk control block equates which define the
;	disk types and maximum storage capability of each
;	disk type.

DSKS1:	EQU	0	;Single density, single sided.
DSKS2:	EQU	1	;Single density, double sided.
DSKD1:	EQU	2	;Double density, single sided.
DSKD2:	EQU	3	;Double density, double sided.
DSKD3:	EQU	4	;Double density, single sided
DSKD4:	EQU	5	;Double density, double sided
DSKD5:	EQU	6	;Double density, single sided
DSKD6:	EQU	7	;Double density, double sided
MAXFTP:	EQU	DSKD6	;Maximum floppy type
	if	gbc20
DSK8F1:	EQU	8	;Fujitsu 20 megabyte first 8 megabytes
DSK8F2:	EQU	9	;Fujitsu 20 megabyte second 8 megabytes
DSK8F3:	EQU	10	;Fujitsu 20 megabytes last 4 megabytes
	endif
	if	gbc10
DSK8M1:	EQU	8	;Fujitsu 10 megabyte first 8 megabytes
DSK8M2:	EQU	9	;Fujitsu 10 megabyte second 8 megabytes
	ENDIF
	if	gbc26
DSK4S1:	EQU	8	;Shugart 26 megabyte first 8 megabytes
DSK4S2:	EQU	9	;Shugart 26 megabyte second 8 megabytes
DSK4S3:	EQU	10	;Shugart 26 megabytes third 8 megabytes
DSK4S4:	EQU	11	;Shugart 26 megabyte last 2 megabytes
	endif


S1DSM:	EQU	((77-2)*26)/CPMSIB
S2DSM:	EQU	((77-2)*2*26)/FPYSIB
D1DSM:	EQU	((77-2)*2*26)/FPYSIB
D2DSM:	EQU	((77-2)*2*2*26)/FPYSIB
D3DSM:	EQU	((77-2)*4*15)/FPYSIB
D4DSM:	EQU	((77-2)*2*4*15)/FPYSIB
D5DSM:	EQU	((77-2)*8*8)/FPYSIB
D6DSM:	EQU	((77-2)*2*8*8)/FPYSIB
F81DSM:	EQU	(8*(94-1)*8*11)/HRDSIB
F82DSM:	EQU	(8*(93-0)*8*11)/HRDSIB
F83DSM:	EQU	(8*(57-0)*8*11)/HRDSIB
M81DSM:	EQU	(4*(123-1)*8*11)/HRDSIB
M82DSM:	EQU	(4*(121-0)*8*11)/HRDSIB
S41DSM:	EQU	(8*(57-1)*8*18)/HRDSIB		;(8*(61-1)*8*17)/HRDSIB
S42DSM:	EQU	(8*(56-0)*8*18)/HRDSIB		;(8*(60-0)*8*17)/HRDSIB
S43DSM:	EQU	(8*(56-0)*8*18)/HRDSIB		;(8*(60-0)*8*17)/HRDSIB
S44DSM:	EQU	(8*(33-0)*8*18)/HRDSIB		;(8*(21-0)*8*17)/HRDSIB


;	BDOS constants on entry to write

WRALL:	EQU	0		;write to allocated
WRDIR:	EQU	1		;write to directory
WRUAL:	EQU	2		;write to unallocated
	page
;	Macro for generating Control Blocks for disk drives
;	The format of these disk control blocks are as follows:
;	16 bits = -> translation table.
;	48 bits = Work area for CP/M.
;	16 bits = -> DIRBUF.
;	16 bits = -> Parameter block.
;	16 bits = -> check vector.
;	16 bits = -> allocation vector.

NDSK:	SET	0		;Number of disk drives
NOHRD:	SET	0		;Number of hard disk drives
NOFDD:	SET	0		;Number of floppy disk drives
ngbc10	set	0		;Number of 10 megabyte hard disks
ngbc20	set	0		;Number of 20 megabyte hard disks
ngbc26	set	0		;Number of 26 megabyte hard disks
ALVS:	SET	0		;Allocation vector size
CSVS:	SET	0		;Check vector size

DPHGEN	MACRO	TYPE,XLATE,DIRBUF,DPBADR
NDSK:	SET	NDSK+1
	DW	%2
	DW	0,0,0
	DW	%3
	DW	%4
	DW	CSV+CSVS
	DW	ALV+ALVS
.type	IF	%1 <= MAXFTP
NOFDD:	SET	NOFDD+1
CSVS:	SET	CSVS+(256/4)
ALVS:	SET	ALVS+((D6DSM+7)/8)
	else
NOHRD:	SET	NOHRD+1
CSVS:	SET	CSVS+0
	IF	GBC20
	IF	%1 = DSK8F1
ngbc20	set	ngbc20+1
ALVS:	SET	ALVS+((F81DSM+7)/8)
	ENDIF
	IF	%1 = DSK8F2
ALVS:	SET	ALVS+((F82DSM+7)/8)
	ENDIF
	IF	%1 = DSK8F3
ALVS:	SET	ALVS+((F83DSM+7)/8)
	ENDIF
	ENDIF
	IF	GBC10
	IF	%1 = DSK8M1
ngbc10	set	ngbc10+1
ALVS:	SET	ALVS+((M81DSM+7)/8)
	ENDIF
	IF	%1 = DSK8M2
ALVS:	SET	ALVS+((M82DSM+7)/8)
	ENDIF
	ENDIF
	IF	GBC26
	IF	%1 = DSK4S1
ngbc26	set	ngbc26+1
ALVS:	SET	ALVS+((S41DSM+7)/8)
	ENDIF
	IF	%1 = DSK4S2
ALVS:	SET	ALVS+((S42DSM+7)/8)
	ENDIF
	IF	%1 = DSK4S3
ALVS:	SET	ALVS+((S43DSM+7)/8)
	ENDIF
	IF	%1 = DSK4S4
ALVS:	SET	ALVS+((S44DSM+7)/8)
	ENDIF
	ENDIF
.type	ENDIF
	ENDM
	space	4,10
;	Macro for generating the Disk Parameter Blocks.
;
;	Disk type definition blocks for each particular mode.
;	The format of these areas are as follow:
;	8 bit = disk type code
;	16 bit = Sectors per track
;	8 bit  = Block shift
;	8 bit  = BS mask
;	8 bit  = Extent mask
;	16 bit = Disk size/1024 - 1.
;	16 bit = Directory size.
;	16 bit = Allocation for directory.
;	16 bit = check area size.
;	16 bit = offset to first track.

DPBGEN	MACRO	TYPE,SPT,BSH,BSM,EXM,DSM,DIRSIZ,ALVMSK,OFFSET
	DB	%1
	DW	%2
	DB	%3,%4,%5
	DW	%6-1,%7-1,REV (%8)
.hrd	IF	%1 <= MAXFTP
	DW	(%7+3)/4
	else
	DW	0
.hrd	ENDIF
	DW	%9
	ENDM

;
;	macro for generating the drive selection masks
;
maskgen	MACRO	drvcnt,logphy
	ECHO	%1
	ECHO	%2
	db	mask
	ENDM
mask	set	mask+1
	ENDM
	ENDM
	page
;	The following jump table defines the entry points
;	into the CBIOS for use by CP/M and other external
;	routines; therfore the order of these jump cannot
;	be modified.  The location of these jumps can only
;	be modified by 400h locations, which is a restriction
;	of MOVCPM.

	ORG	BIOS

	JMP	CBOOT		;Cold boot
	JMP	WBOOT		;Warm boot
J.CST	JMP	NOTHIN		;Console status (input)
J.CIN	JMP	NOTHIN		;Console input
J.COUT	JMP	NOTHIN		;Console output
J.LIST	JMP	NOTHIN		;List output
	JMP	NOTHIN		;Punch output
	JMP	NOTHIN		;Reader input
	JMP	HOME		;Set track to zero
	JMP	SELDSK		;Select disk unit
	JMP	SETTRK		;Set track
	JMP	SETSEC		;Set sector
	JMP	SETDMA		;Set Disk Memory Address
	JMP	READ		;Read from disk
	JMP	WRITE		;Write onto disk
J.LST	JMP	NOTHIN		;List status (output)
	JMP	SECTRN		;Translate sector number
	JMP	SETNUM		;Set number of sectors to read
	JMP	SETXAD		;Set extended address bank.

;	Endx	BIOS1.asm
