	page
;	S E L E C T   D I S K   D R I V E
;
;	Select the disk drive for subsequent disk transfers and
;	return the appropriate DPB address.   This routine
;	diverges from the normal CP/M implementation of just
;	saving the disk selection value until the transfer is
;	performed.  This divergence is required because floppy
;	disks are a removable media and come in more than on
;	format.  This routine determines the correct format and
;	initializes the DPH with the appropriate values for the
;	format type.
;
;	ENTRY	C = disk delection value.
;		DE and 1 = 0, must determine disk type.
;		         = 1, drive type has been determined.
;
;	EXIT	HL = 0, if drive not selectable.
;		HL = DPH address if drive is selectable.
;
;		DPH is intialized for the appropriate floppy
;		disk format.

SELDSK:	MOV	A,C
	CPI	NDSK
	JNC	SELD1		;If invalid drive
	PUSH	D		;Save drive selection mask
	MVI	B,0

	LXI	H,DSKMSK
	DAD	B
	MOV	A,M
	STA	SEKDSK		;Save selection code

	MOV	L,C		;Compute DPH address
	MOV	H,B
	DAD	H		;*2
	DAD	H		;*4
	DAD	H		;*8
	DAD	H		;*16
	LXI	D,DPBASE
	DAD	D		;HL = DPH address

	LXI	D,5*2
	XCHG
	DAD	D		;HL = DPH(DPB)
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	XCHG			;DE = DPB address
	DCX	D
	LDAX	D
	STA	SEKTYP		;Save disk type
	POP	D		;Restore Drive selction mask
	CPI	MAXFTP+1
	RNC			;If hard disk

	MOV	A,E
	ANI	1		;Mask selected bit
	RNZ			;If drive previously selected

	PUSH	H		;Save DPH address
	CALL	TREAD		;Determine disk type
	POP	H		;Restore DPH address
	JNZ	SELD1		;If disk type not determined

	STA	SEKTYP		;Save disk type
	XCHG
	MOV	L,A		;Move type
	MVI	H,0
	DAD	H		;*2
	DAD	H		;*4
	DAD	H		;*8
	DAD	H		;*16
	LXI	B,DPBS1+1
	DAD	B
	XCHG			;DE = DPB address
	PUSH	H
	LXI	B,5*2
	DAD	B		;Compute DPH DPB address
	MOV	M,E		;Set DPB address into DPH
	INX	H
	MOV	M,D
	ANI	0FEh		;Remove sided bit
	MOV	E,A
	MVI	D,0
	LXI	H,XTABLE
	DAD	D
	XCHG
	POP	H
	LDAX	D		;Set translation table
	MOV	M,A		;address into DPH
	INX	H
	INX	D
	LDAX	D
	MOV	M,A
	DCX	H
	RET

SELD1:	LXI	H,0
	MOV	A,L
	STO	A,CDISK
	RET
	page
;	H O M E
;
;	Return disk to home.  This routine sets the track number
;	to zero.  The current host disk buffer is flushed to the
;	disk.

HOME:
	CALL	FLUSH		;Flush host buffer
	XRA	A
	STA	HSTACT		;Clear host active flag
	STA	UNACNT		;Clear sector count
	STA	SEKTRK
	STA	SEKTRK+1
	RET
	space	4,10
;	S E T   T R A C K.
;
;	Set track number.  The track number is saved for later
;	use during a disk transfer operation.
;
;	ENTRY	BC = track number.

SETTRK:
	IF	Z80
	STO	BC,SEKTRK	;Set track
	ENDIF

	IF	C8080
	MOV	L,C
	MOV	H,B
	SHLD	SEKTRK
	ENDIF

	LHLD	UNATRK
	MOV	A,L
	XRA	C
	MOV	C,A
	MOV	A,H
	XRA	B
	ORA	A
	RZ			;If same track
;	JMP	CUNACT
	space	4,10
;	Clear Unallocated block count (force pre-reads).

CUNACT:	XRA	A		;A = 0
	STA	UNACNT		;Clear unallocated block count
	RET
	space	4,10
;	Set the sector for later use in the disk transfer.  No
;	actual disk operations are perfomed.
;
;	Entry	BC = sector number.

SETSEC:	MOV	A,C
	STA	SAVSEC		;sector to seek
	RET
	space	4,10
;	Set Disk memory address for subsequent disk read or
;	write routines.  This address is saved in DMAADR until
;	the disk transfer is performed.
;
;	ENTRY	BC = Disk memory address.
;
;	EXIT	DMAADR = BC.

SETDMA:
	IF	Z80
	STO	BC,DMAADR
	RET
	ENDIF

	IF	C8080
	MOV	H,B
	MOV	L,C
	SHLD	DMAADR
	RET
	ENDIF
	space	4,15
;	Translate sector number from logical to physical.
;
;	ENTRY	DE = 0, no translation required.
;		DE = translation table address.
;		BC = sector number to translate.
;
;	EXIT	HL = translated sector.

SECTRN:
	LDA	UNASEC
	CMP	C
	CNZ	CUNACT		;If sectors do not match
	MOV	A,C
	STA	LOGSEC
	MOV	L,C
	MOV	H,B
	MOV	A,D
	ORA	E
	RZ			;If no translation
	DAD	D
	MOV	L,M
	MVI	H,0
	RET
	space	4,10
;	S E T   S E C T O R   C O U N T
;
;	Set the number of continuous sectors to transfer.
;
;	ENTRY	C = Number of sectors to transfer.
;
;	EXIT	NUMSEC = C

SETNUM:
	MOV	A,C
	STA	NUMSEC
	RET
	space	4,10
;	S E T   E X T E N D E D   B A N K
;
;	Set the extended bank data tranfer address.
;
;	ENTRY	C = Extended address bank.
;
;	EXIT	DMAADE = C.

SETXAD:
	MOV	A,C
	STA	DMAADE
	RET
