	page

	if	order = 1
;
;	Bootstrap Load from Disk 2
;	Entry C = board options (0..3)

	org	100h

boot:	lxi	sp,stack	;Initialize the stack
	mov	a,c		;Get Board Options
	sta	opts		;Save Board options
	mvi	b,2		;Drive select retry
boot0	mvi	a,h.dvs		;Drive select register
	out	hdctl		;Select the drive select register
	mvi	a,10h		;Drive 0 head 0
	out	hddata		;Select drive 0 and head 0
	in	hdctl		;Get status
	ani	88h		;Test Opdone and Ready
	cpi	80h		;Test for opdone and ready*
	jz	boot1		;If drive ready
	dcr	b		;Update repeat count
	jnz	boot0		;If retry
	lxi	b,500		;Delay 500 milliseconds
	call	delay		;Delay the specified time
	jmp	boot		;Start over

boot1	mvi	a,4		;Get fault clear bit
	out	hdctl		;Clear any faults

home	in	hdctl		;Get status
	ani	1		;Test track zero bit
	jz	home3		;If at track 0
	mvi	a,4+h.sou	;Seek out pattern
	out	hdctl		;Set up direction
	if	gbc20
	mvi	b,0		;Auto step
	endif
	if	gbc10
	mvi	b,0		;Auto step
	endif
	if	gbc26
	mvi	b,1		;Step once
	endif
home1	in	hddata		;Step one track
	dcr	b		;Update repeat count
	jnz	home1		;If not all steps
home2	in	hdctl		;Get status
	ani	4		;Test seek complete
	jnz	home2		;If not homed
	if	gbc26
	jmp	home		;If more steps
	endif
home3:
	if	gbc26
	lxi	b,50		;50 millisecond head settle
	call	delay
	endif

read:	lxi	h,bios-512	;DMA address
	shld	dmaad		;Save DMA address
	xra	a		;Initial sector number
	sta	sector		;Save sector number
	call	hdxfer		;Read sector 0
	call	hdxfer		;Read sector 1
	call	hdxfer		;Read sector 2
	lxi	h,buffer	;Temporary storage buffer
	shld	dmaad		;New dma address
	call	hdxfer		;Read sector 3
	lxi	h,buffer	;Source address of move
	lxi	d,(bios-512)+3*1024 ;Destination address of move
	mvi	c,0		;Repeat count
move	mov	a,m		;Get a byte
	inx	h		;Bump destination
	stax	d		;Store at destination
	inx	d		;Bump Destination
	dcr	c		;Update repeat count
	jnz	move		;If not all bytes relocated
	jmp	bios		;Enter newly loaded bios

;
;	Read a sector
;
hdxfer	mvi	a,10		;Retry count
hdxfr1	sta	rept		;Save retry count
	mvi	a,h.dvs		;Drive slect register
	out	hdctl		;Select the drive select register
	mvi	a,10h		;Drive 0 head 0
	out	hddata		;Select drive 0 and head 0
	mvi	a,h.cyl		;Cylinder select register
	out	hdctl		;Select the cylinder register
	xra	a		;Zero A
	out	hddata		;Select cylinder zero
	mvi	a,h.hed		;Head select register
	out	hdctl		;Select the head register
	xra	a		;Zero A
	out	hddata		;Select head zero
	mvi	a,h.sec		;Sector select register
	out	hdctl		;Select the sector register
	lda	sector		;Get the sector to read
	out	hddata		;Select the cylinder
	lhld	dmaad		;Get transfer address
	in	selchan		;Ready the selector channel
	xra	a		;Zero A
	out	selchan		;MSB of DMA
	mov	a,h		;High byte of dma address
	out	selchan		;Middle byte of DMA
	mov	a,l		;Low byte of dma address
	out	selchan		;LSB of DMA
	mvi	a,80h+selbyt	;Selector channel read command
	out	selchan		;Set up the selector channel
	mvi	a,h.red		;Disk2 read command
	out	hdctl		;Read the sector
hdxfr2	in	hdctl		;Get status
	ani	80h		;Test op done
	jnz	hdxfr2		;If operation not done
	in	hdctl		;Get status
	ani	50h		;Mask timeout and overrun
	jz	hdxfr3		;If read ok
	lda	rept		;Get retry count
	dcr	a		;Update retry count
	jnz	hdxfr1		;If retry attempts
	jmp	boot		;Start all over
hdxfr3	lda	sector		;Get sector number
	inr	a		;Increment sector number
	sta	sector		;Save updated sector number
	lhld	dmaad		;Get dma address
	lxi	d,1024		;Get size of sector
	dad	d		;Update the dma address
	shld	dmaad		;Save the updated dma address
	ret

delay	mvi	a,delcnt/26
dlay1	dcx	b
	inx	b
	dcr	a
	jnz	dlay1
	dcx	b
	mov	a,c
	ora	b
	jnz	delay
	ret

rept	db	0
sector	db	0
dmaad	dw	0
	ds	10
stack	db	0
buffer	ds	1024

	endif
