	page
;	Physical data buffer address ((DMAADR) or HSTBUF)

BUFADR:	DW	0		;Lower 16 bits (least, middle)
BUFADE:	DB	0		;Extended address

;	User data buffer address

DMAADR:	DW	0		;Lower 16 bits (least, middle)
DMAADE:	DB	0		;Extended address
	space	4,10
;	BIOS blocking / deblocking flags.

HSTACT:	DB	0		;host active flag
HSTWRT:	DB	0		;host written flag
UNACNT:	DB	0		;unalloc rec CNT
UNATRK:	DW	0		;Track
UNASEC:	DB	255		;Sector
LOGSEC	DB	0		;Logical sector
	space	4,10
;	CP/M disk work space.

ALV:	DS	ALVS
CSV:	DS	CSVS
	page
;	Disk access information.
;	This area is organized into the following groups
;		sector number
;		track number
;		disk drive
;		drive type
;	Each of these groups has three cells for the
;	current disk request, ACTual disk transfer,
;	and active host disk.

SEKSEC:	DS	1		;Current request
SEKTRK:	DS	2		;Current request
SEKDSK:	DS	1		;Current request
SEKTYP:	DS	1		;Current disk's type

ACTSEC:	DS	1		;Actual transfer operation
ACTTRK:	DS	2		;Actual transfer operation
ACTDSK:	DS	1		;Actual transfer operation
ACTTYP:	DS	1		;Actual disk's type

HSTSEC:	DS	1		;Active host disk
HSTTRK:	DS	2		;Active host disk
HSTDSK:	DS	1		;Active host disk
HSTTYP:	DS	1		;Active disk's type
	space	4,10
;	Disk transfer flags and counters.

RDFLAG:	DS	1		;Read flag
ERFLAG:	DS	1		;Error reporting
WRTYPE:	DS	1		;Write operation type

SAVSEC:	DS	1		;Save sector
NUMSEC:	DS	1		;Number of sectors

CIOPL:	EQU	9
CIOPB:	DS	CIOPL		;Disk command buffer
TEMPBF:	DS	8		;Result status cells
ESPACE:


	ORG	LWAMEM-HSTSIZ-128

DIRBUF:	DS	128		;Directory buffer
HSTBUF:	DS	HSTSIZ-1		;Host buffer


	MSG	'Available exspansion = $',DIRBUF-ESPACE,' bytes.'

	TITLE	'Cross Reference Listing.'
