	TITLE	'ROM Boot for CompuPro DISK1 Controller.'
;GBCROM - Sorcim ROM Boot for CompuPro Disk Controller.
;
;	+-----------------------+
;	|			|
;	|    R O M   B O O T	|
;	|			|
;	+-----------------------+
;
;	COMPUPRO			SORCIM Corp.
;	Oakland, CA			Santa Clara, CA
;
;	Copyright 1981, Sorcim Corporation.
;
;	This product is a copyright program product
;	of Sorcim and is supplied for use with the
;	CompuPro IEEE 696 Floppy Disk Controller.
;
;	Version number:	2.2F
;	Version date:	81 March 31



ROMFWA	EQU	*o * 100h

;	Assembly Constants
FDPORT	EQU	0C0H		;Base port address for Controller
FDCS	EQU	FDPORT		;Status register
FDCD	EQU	FDPORT+1	;Data register
DMA	EQU	FDPORT+2	;Dma address (when write)
INTS	EQU	FDPORT+2	;Status Register (when read)

;	Input on port disables boot rom.
SER	EQU	FDPORT+3	;Serial port

DELCNT	=	5*1000		;5 MHz processor

;	Controller function definitions
;	Specify (00) command
NSEC	=	0		;Sect verify number
F.RTK	=	02		;Read track
F.SPEC	=	03		;Specify
F.DSTS	=	04		;Drive status
F.RDAT	=	06		;Read data
F.RECA	=	07		;recalibrate
F.RSTS	=	08		;Read status
F.SEEK	=	0Fh		;Seek

SRT	=	16-8		;= Shuggart 800s
;		16-3		;= Shuggart 850s
;		16-3		;= Remex
HUT:	=	240/16		;Head unload = 240 ms
HLT:	=	(35+1)/2	;Head load = 35 ms
ND:	=	00		;Set DMA mode


	ORG	ROMFWA
	LOC	0
START:	JMP	ROM1		;forced jump to location 3

ROM1:	LDK	BC,20		;Wait 20 MSec
	LDK	HL,ROM2		;Return from delay
	JMP	DELAY

ROM2:	LXI	D,DATA

;	Output beginning DMA address

	MVI	B,LDMA
ADDR:	LD	A,[de]
	OUT	DMA		;set DMA
	INX	D
	DCR	B
	JNZ	ADDR		;if NOT all 3 bytes


;	Load Specify Command

	MVI	B,LSPEC
SPEC1:	IN	FDCS
	OR	A
	JP	SPEC1		;if no master ready bit
	LD	A,[de]		;load command byte
	OUT 	FDCD		;to controller
	INX	D
	DCR	B
	JNZ	SPEC1		;if more bytes

;	Recalibrate drive

	MVI	B,LRECAL
RCAL1:	IN	FDCS
	OR	A
	JP	RCAL1		;if no master ready bit
	LD	A,[de]		;load command byte
	OUT 	FDCD		;to controller
	INX	D
	DCR	B
	JNZ	RCAL1		;if more bytes

RCAL2:	IN	INTS
	ORA	A
	JP	RCAL2		;If not complete

	MVI	A,F.RSTS
	OUT	FDCD

	LDK	BC,250		;Leave light on .25 seconds
	LDK	HL,RCAL3	;set return address
	JMP	DELAY

RCAL3:	IN	FDCS
	ORA	A
	JP	RCAL3
	IN	FDCD
	SUI	20h
	MOV	C,A
RCAL4:	IN	FDCS
	ORA	A
	JP	RCAL4
	IN	FDCD
	ORA	C
	JNZ	ERROR		;If error in recalibrate

;	Now set-up read command

	MVI	B,LREAD
READ1:	IN	FDCS
	OR	A
	JP	READ1		;if no master ready bit
	LD	A,[de]		;load command byte
	OUT 	FDCD		;to controller
	INX	D
	DCR	B
	JNZ	READ1		;if more bytes

READ2:	IN	INTS
	ORA	A
	JP	READ2		;If not complete

READ3:	IN	FDCS
	ORA	A
	JP	READ3
	IN	FDCD
	SUI	40h
	MOV	L,A
READ4:	IN	FDCS
	ORA	A
	JP	READ4
	IN	FDCD
	SUI	80h
	MOV	H,A

	MVI	B,7-2
READ5:	IN	FDCS
	OR	A
	JP	READ5		;if not ready
	IN	FDCD		;read status
	DEC	B
	JNZ	READ5		;wait until all done

	MOV	A,L
	ORA	H
	JZ	GOBOOT		;If no error during read
	space	4,10
;	Error during read or recalibrate.

ERROR:	LDK	BC,1000		;Wait 1 second before retry
	LDK	HL,ROM2
;	JMP	DELAY
	space	4,10
;	Delay a period of time.
;
;	ENTRY	BC = number of milliseconds to delay.
;		HL = return address.

DELAY:	LDK	A,DELCNT/26
DLAY1:	INX	B
	DCX	B
	DCR	A
	JNZ	DLAY1
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DELAY
	PCHL			;return to caller
	space	4,10
;	Function data for controller to boot
DATA	DB	0		;Extended
	DB	high BOOT
	DB	low BOOT
LDMA	EQU	*-DATA

SPEC	DB	F.SPEC
	VFD	4\SRT,4\HUT
	VFD	7\HLT,1\ND
LSPEC	=	*-SPEC

RECAL	DB	F.RECA,0
LRECAL	=	*-RECAL


READ:	DB	F.RDAT
	DB	0		;hds,ds1,ds0
	DB	0		;C = sector ID info
	DB	0		;Head
	DB	1		;Record (first sector)
	DB	0		;N
	DB	4		;EOT (last sectors)
	DB	7		;GPL
	DB	128		;DTL
LREAD	=	*-READ



;	Next instruction disables rom, shadow
;	of next instruction must be jump to
;	execute boot code just loaded at 100h
;	ORG	ROMFWA+100h-4		;Leave exact room
	DS	(100h-4) - *
GOBOOT:
	LDK	C,high ROMFWA	;pass board switch value to Boot
	IN	SER		;must preceed Boot immediately
BOOT:
	ASSERT	BOOT = 100h


	END
