;THIS IS THE CBIOS FOR THE ALPS SYSTEM WITH
;THE TALLY PRINTER
	;THIS IS CBOSA
	;SKELETAL CBIOS FOR CPM


MSIZE	EQU	32
PATCH	EQU	MSIZE*1024-2*256
CFMT	EQU	81H	;CLR FMT
THOME	EQU	0DH	;SEEK TRK 0
DATA	EQU	07H
CSTS	EQU	0F812H
CI	EQU	0F803H
CO	EQU	0F809H
LO	EQU	0F80FH
PO	EQU	0F80CH
RI	EQU	0F806H
CMD	EQU	06
WAITE	EQU	0EC1CH
CMDP	EQU	0F8DEH
STAT	EQU	06
RESET	EQU	0EC31H
DISK	EQU	0EC3BH
SCRAT	EQU	40H	;BASE
TRACK	EQU	SCRAT
SECTOR	EQU	SCRAT+1
DMAAD	EQU	SCRAT+2
DISKNO	EQU	DMAAD+4
	;
	;
ORG	PATCH
CBASE	EQU	(MSIZE-16)*1024
CPMB	EQU	CBASE+2900H
BDOS	EQU	CBASE+3106H
CPML	EQU	$-CPMB
NSECTS	EQU	CPML/128
	;
	;
	;JMP VECTORS
	;
	;
	JMP	BOOT
WBOTE:	JMP	WBOOT
	JMP	CONST
	JMP	CONIN
	JMP	CONOUT
	JMP	LIST
	JMP	PUNCH
	JMP	READR
	JMP	HOME
	JMP	SELDSK	 
	JMP	SETTRK
	JMP	SETSEC
	JMP	SETDMA
	JMP	READ
	JMP	WRITE
	;
	;
	;SUBS TO PERFORM FUNCTIONS
BOOT:	JMP	GOCPM
	;
	;
WBOOT:	MVI	B,0
	LXI	SP,080H
	CALL	RESET
	CALL	WAITE
	MVI	C,2AH
	LXI	D,1
	LXI	H,CPMB
	CALL	DISK
	JMP	WBOOT
	;
	;

	;
	;END OF LOAD, SET PARMS & GOCPM
	;
GOCPM:	MVI	A,0C3H
	STA	0
	LXI	H,WBOTE
	SHLD	1
	STA	5
	LXI	H,BDOS
	SHLD	6
	LXI	B,80H
	CALL	SETDMA
	MVI	C,0
	CALL	SELDSK
	CALL	SETTRK
	CALL	SETSEC
	EI
	MVI	C,0
	MVI	A,43H
	STA	3
	JMP	CPMB
	;
	;
	;I/O HANDLERS
	;
	;
CONST:	JMP	CSTS

CONIN:	JMP	CI

CONOUT:	JMP	CO


;	;LIST:	IN	01H	;WAIT HERE IF NOT ONLINE
;		ANI	08H	;ON LINE?
;		JNZ	LIST
;	WAIT:	IN	01H
;		ANI	08H	;DEMAND HI
;		JZ	WAIT
;		MOV	A,C	;GET DATA
;		CMA
;		OUT	00H
;		RET


PUNCH:	JMP	PO

READR:	JMP	RI
	;
	;
	;I/O FOR DISK
	;
	;
HOME:	MVI	A,CFMT
	CALL	COMAD
	MVI	A,THOME
	JMP	LOOP

COMAD:	OUT	CMD
	XRA	A
	OUT	CMD
	RET

LOOP:	CALL	COMAD	;ISSUE CMD & LOOP
LOOP1:	IN	DATA
	RRC
	JC	LOOP1
	RET

SELDSK:	MOV	A,C
	ANI	03H
	RRC
	RRC
	STA	DISKNO
	RET

SETTRK:	MOV	A,C
	STA	TRACK
	RET

SETSEC:	MOV	A,C
	STA	SECTOR
	RET

SETDMA:	 MOV	L,C
	MOV	H,B
	SHLD	DMAAD
	RET

READ:	CALL	UTRS
	MVI	C,5	;TRY COUNT
RREAD:	MVI	A,3	;READ CMD
	CALL	LOOP
	CALL	ERCHK
	JZ	GOOD
	DCR	C
	JNZ	RREAD
	MVI	A,01
	RET
GOOD:	CALL	DUBUF
	XRA	A
	RET

DUBUF:	LHLD	DMAAD
	MVI	B,128
DUBU1:	MVI	A,40H	;READ BUF CMD
	OUT	CMD
	IN	DATA
	MOV	M,A
	INX	H
	MVI	A,41H	;READ STB
	OUT	CMD
	XRA	A
	OUT	CMD
	DCR	B
	JNZ	DUBU1
	RET

ERCHK:	IN	DATA
	ANI	08	;CRC
	RZ
	MVI	A,0BH	;RST ERR FLG
	CALL	LOOP
	MVI	A,01
	RET

WRITE:	CALL	STUFF
	CALL	UTRS
	MVI	A,05	;WRT CMD
	CALL	LOOP
	MVI	A,07	;READ CRC CMD
	CALL	LOOP
	ANI	08H
	RZ
	MVI	A,01H
	RET
STUFF:	LHLD	DMAAD
	MVI	B,128
STUF1:	MOV	A,M
	INX	H
	OUT	DATA
	MVI	A,31H	;LD WRT BUF
	CALL	LOOP
	DCR	B
	JNZ	STUF1
	RET


UTRS:	LDA	DISKNO
	MOV	C,A
	LDA	SECTOR
	ORA	C
	OUT	DATA
WLOOP:	IN	07
	ANI	20H
	JNZ	WLOOP	;IF DISK IS FAILED
	MVI	A,21H	;U/S CMD
	CALL	LOOP
	LDA	TRACK
	OUT	DATA
	MVI	A,11H	;TRK CMD LD
	CALL	LOOP
	MVI	A,9H	;SEEK TRK CMD
	JMP	LOOP

;LIST:	;	PRINTER DRIVER FOR TTY MODEL 40
;;
;;
;;
;COMIN:	PUSH	H
;	LHLD	BUFPNT
;	MOV	A,C
;	CPI	20H
;	JC	CONTRL
;	MOV	M,C
;	INX	H
;	PUSH	D
;	PUSH	H
;	LXI	D,-CHRBUF
;	DAD	D
;	MVI	A,132
;	CMP	L
;	POP	H
;	POP	D
;	JZ	CALPRN
;EXIT:	SHLD	BUFPNT
;EXIT1:	POP	H
;	RET
;BUFPNT	DW	CHRBUF
;;
;;
;CONTRL:	CPI	0DH
;	JNZ	FF
;	MOV	M,C
;	JMP	OUTLIN
;FF:	CPI	0CH
;	CZ	OUTCHR
;	JMP	EXIT
;;
;;
;;
;CALPRN:	MVI	M,0DH
;	JMP	OUTLIN
;;
;;
;;
;OUTLIN:	LXI	H,CHRBUF
;	SHLD	BUFPNT
;OTLN1:	MOV	A,M
;	INX	H
;	MOV	C,A
;	CPI	0DH
;	JZ	CRLF
;	CALL	OUTCHR
;	JMP	OTLN1
;;
;;
;;
;CRLF:	CALL	OUTCHR
;	MVI	C,0AH
;	CALL	OUTCHR
;	JMP	EXIT1
;;
;;
;OUTCHR:	IN	1
;	ANI	8
;	JZ	OUTCHR
;	MOV	A,C
;	CMA
;	OUT	0
;OUT11:	IN	1
;	ANI	8
;	JNZ	OUT11
;OUT22:	IN	1
;	ANI	8
;	JZ	OUT22
;	RET
;;
;
;THIS IS THE TALLEY DRIVER VERSION
;DESIGNED TO RUN WITHOUT SOFTWARE
;BUFFER
LIST:	IN	2
	ANI	8
	JZ	LIST
LIN1:	IN	2
	ANI	40H
	JNZ	LIN1
	MOV	A,C
	CPI	20H
	JC	TOSM
	CPI	5EH
	JC	JUR
TOSM:	CPI	0DH
	JZ	INT
	MVI	A,20H
JUR:	OUT	3
	MVI	A,2
	CALL	ISSUE
INT1:	IN	2
	ANI	4
	JNZ	INT1
	RET
INT:	IN	2
	ANI	4
	JNZ	INT
	MVI	A,8
	CALL	ISSUE
	RET
ISSUE:	OUT	2
ISS1:	IN	2
	ANI	1
	JZ	ISS1
	SUB	A
	OUT	2
	RET
;
;

;
;
END
