	title	'FOXYCALC line editor,  version 1.0'
;
	page	58
;
;**************************************************************
		org	100h
start:		call	read$ln
		rst	7
;**************************************************************
;
	public	goto$xy, clr$scn, clr$lin, clr$eol
	public	read$ln, char$st, char$in, chr$out
	public	ln$buff, crt$col, crt$row
;
;
bdos		equ	0005h
;
cr		equ	0dh
bksp		equ	08h
dele		equ	07fh
prompt		equ	'|'
;
cmd$row		equ	22		;row 23
;
max$col		equ	76		;last colunm number
;
		cseg
;
read$ln:	jmp	read$line	;around local data area
;
;
;	user modification area, terminal dependent information
;
crt$xy		db	2,1bh,'Y',0,0,0,0,0	;cursor x/y leadin
;
era$scn		db	0,0,0,0,0,0,0,0		;clear screen string
;
era$lin		db	2,1bh,'l',0,0,0,0,0	;clear single line string
;
era$eol		db	0,0,0,0,0,0,0,0		;clear to end of line
;
row$off		db	' '		;offset to add to row number
;
col$off		db	' '		;offset to add to column number
;
;	end of terminal dependent area
;
;
read$line:	call	goto$cmd$ln	;position cursor at start of command ln
;
;	setup column counter
;
		xra	a
		sta	column		;position 1
;
;	erase command line, display char. counter and prompt
;
		call	clr$lin
		call	disp$prompt
;
		lxi	h,ln$buff	;address of line buffer
;
		push	h
		push	h
;
;	start of main loop.  collect and display chars
;
read$lp:	call	char$in		;get character
		ani	7fh		;strip parity bit
;
;	test for line terminator
;
		cpi	cr		;carrage return
		jz	line$end	;finish line if so
;
;	test for back space or delete keys
;
		cpi	bksp		;back space
		jz	back$sp		;backup one if so
;
		cpi	dele		;delete key
		jz	back$sp		;same as back space
;
;	test for delete entire line
;
		cpi	'X'-40h		;control-X
		jz	era$ln		;kill display line and buffer
;
;	test for re-display line command
;
		cpi	'R'-40h		;control-R
		jz	rept$ln		;erase and re-display command line
;
;	all special characters have been tested for
;	now allow only printable ascii characters (20h-7eh)
;
		cpi	' '		;must be .ge. than space
		jc	read$lp
;
		cpi	7fh		;and .lt. than delete
		jnc	read$lp
;
;	char is printable, send it to the display and
;	put it into the line buffer
;
		push	psw		;save char
		mov	e,a		;put char in <e> for output
		call	chr$out		;display it
		pop	psw
		pop	h		;restore line buff pointer
		inx	h		;next position
		mov	m,a		;store it
		push	h
		lxi	h,column	;point to char count
		inr	m		;now one more
		mov	a,m
		cpi	max$col		;test for max line (max$col chars)
		jz	line$end	;all done if at col 79
;
;	update display character counter
;
		call	disp$prompt
		jmp	read$lp		;end of main loop
;
;	finish up by putting a 00h at the end of the line,
;	and putting the char count in the first byte of the line buffer
;
line$end:	call	disp$prompt
		pop	h		;restore pointer into buffer
		inx	h		;end of line +1
		mvi	m,00h		;end of line flag
		pop	h		;reget pointer to start of line buffer
		lda	column		;character count
		mov	m,a
		ret
;
;
;	back space function, delete character to the left of
;	the cursor
;
back$sp:	lda	column		;test if at left most column
		ora	a
		jz	read$lp		;return if at column 00
;
		dcr	a		;column = column - 1
		sta	column
		pop	h		;line buffer pointer now -1
		dcx	h
		push	h		;save pointer
;
;	output (backspace, space, backspace)
;
		mvi	e,bksp
		call	chr$out
		mvi	e,' '
		call	chr$out
		mvi	e,bksp
		call	chr$out
;
;	update display char counter
;
		call	disp$prompt
		jmp	read$lp
;
;
;	erase entire display line and zero char counter
;
era$ln:		pop	h		;clear stack
		pop	h
		lda	column
		sta	old$col		;save column number
		jmp	read$ln		;start from beginning
;
;
;	re-display line, erase line and write a new copy
;
;	re-print buffer
;
rept$ln:	lda	old$col
		ora	a		;test for zero
		jz	read$lp		;bypass if zero
;
		call	clr$lin		;erase line
		lda	old$col		;get saved count
		sta	column		;restore column number
		mov	b,a		;counter
		lxi	h,ln$buff
;
rept$ln$lp:	inx	h
		mov	e,m		;output char in <e>
		push	b
		push	h		;save count and pointer
		call	chr$out
		pop	h
		pop	b
		dcr	b
		jnz	rept$ln$lp	;loop
;
		xra	a
		sta	old$col		;clear repeat flag/counter
		xthl			;replace line buffer pointer
		call	disp$prompt	;update display char count
		jmp	read$lp		;around again
;
;
;	position cursor at the display command line,
;
goto$cmd$ln:	lxi	h,(cmd$row shl 8) and 0ff00h	;row 23 column 1
		shld	crt$col
		jmp	goto$xy
;
;
;	display the char count and prompt
;
disp$prompt:	call	goto$cmd$ln	;position cursor at beginning of line
		lda	column		;get count
		push	psw		;save column count
		call	prn$dec		;output it
		mvi	e,prompt	;prompt character
		call	chr$out
		mvi	h,cmd$row	;row number
		pop	psw		;restore colunm count
		adi	3		;offset past prompt
		mov	l,a
		shld	crt$col		;update current cursor address
		jmp	goto$xy		;put cursor at proper place
;
;
;	clear terminal screen function
;	erases the screen and homes the cursor
;
clr$scn:	lxi	h,era$scn	;clear crt string
		jmp	crt$fnc
;
;	clear single line function
;	erases the line currently addressed by the cursor
;	psoitions to cursor to the beginning of the line
;
clr$lin:	lxi	h,era$lin	;terminal dependent function string
		jmp	crt$fnc		;output to terminal
;
;	clear to end of line
;	erases from the cursor to the end of the line
;	including the character under the cursor
;
clr$eol:	lxi	h,era$eol
;
;	sends terminal dependent function strings to the
;	terminal.  pointer to function string passed in <hl>
;
;	string structure:
;		byte one -- number of bytes in string
;		byte two..n -- actual string
;
crt$fnc:	mov	b,m		;get byte count
;
crt$fnc$lp:	inx	h
		dcr	b
		rm
		mov	e,m		;get byte
		push	b		;save registers
		push	h
		call	chr$out
		pop	h
		pop	b
		jmp	crt$fnc$lp	;loop
;
;
;	display two (2) decimal digits on the terminal
;		byte to be converted in <a>
;		range is 0 to 99
;
prn$dec:	mvi	e,00h
;
prn$dec$1:	sui	10		;subtract 10 until value is .lt. 10
		jc	prn$dec$2
		inr	e		;add 1 for each subtraction
		jmp	prn$dec$1
;
prn$dec$2:	push	psw		;save remainder
		call	dec$out		;print decimal digit
		pop	psw
		adi	10		;correct remainder
		mov	e,a		;output from <e>
		jmp	dec$out		;and finish
;
;
;	position cursor at row/column using terminal
;	dependent offsets.
;
;	row passed in <b>, column passed in <c>
;
goto$xy:	lhld	crt$col		;get new cursor position
		push	h		;save row/column
		lxi	h,crt$xy	;first function bytes
		call	crt$fnc
		pop	h
		lda	row$off		;get row offset value
		add	h
		push	h
		mov	e,a		;output from <e>
		call	chr$out
		pop	h
		lda	col$off		;and column offset value
		add	l
		mov	e,a
		jmp	chr$out
;
;
;	character output functions
;
;	print decimal digit
;
dec$out:	mvi	a,30h		;ascii numeric bias
		add	e		;make decimal
		mov	e,a
;
;	output character using BDOS function 6
;
;		character passed in <e>
;
chr$out:	mvi	c,06		;function number
		jmp	bdos		;do it
;
;
;	character input using BDOS function 6 (direct console i/o)
;
;		return with character in <a>
;
char$in:	mvi	e,0ffh		;char in flag
		mvi	c,06h		;function number
		call	bdos
		ora	a
		jz	char$in		;loop if no char
		ret			;return with char in <a>
;
;
;	character status check routine
;
;	return	<a> = 00, if NO character ready
;		<a> = non-zero if char ready
;
char$st:	mvi	e,0feh		;check console status flag
		mvi	c,06h		;function number
		jmp	bdos
;
		dseg
;
crt$col		dw	0000		;current row/column to be output
crt$row		equ	$-1
;
column		db	00
;
old$col		db	00
;
ln$buff		ds	max$col+1	;line buffer
