	title	'FOXYCALC memory module, version 1.0'
;
	page	58
;
;
	public	fst$exp, nxt$exp, add$exp, del$exp, fnd$exp
	public	get$val, put$val
;
	extrn	rd$para, rd$nx$pr, wr$para
	extrn	ex$para, vl$para
;
	extrn	eom$ptr, exm$end
	extrn	exp$mem,tmp$exp, val$mem, tmp$val, cwt$buf
	extrn	exp$ptr, exp$adr, val$ptr, val$adr, vtl$ptr
	extrn	exp$col, exp$row, val$col, val$row
;
;
cwt$siz		equ	256		;size of cell width table
;
eo$flag		equ	0ffh		;end of paragraph or end of file flag
eo$file		equ	0ffh		;end of file flag (in column byte)
rng$flg		equ	0ffh		;in range flag value
;
row$mask	equ	1000$0000b	;row range flag mask
col$mask	equ	0100$0000b	;column range flag mask
rng$mask	equ	0011$1111b	;range value mask
;
exp$const	equ	5		;number of header bytes in a exp$cell
esz$off		equ	4		;offset of size byte from row byte
rng$off		equ	3		;offset of range byte from row byte
;
val$const	equ	4		;number of header bytes in a valu$cell
vsz$off		equ	3		;offset of size byte from row byte
;
;
;
	cseg
;
;
; ***** get_first_expression_cell *****
;
;	returns a pointer in EXP$ADR to the first expression cell in the file.
;	inputs:	none
;	returns:	EXP$ADR = 0000h, if expression file is empty, or
;			the end of the expression file is reached.
;			EXP$ADR = pointer to the row byte of the first
;			expression cell.
;
fst$exp:	lda	ex$para		;check for first paragraph
		ora	a
		jz	fst$expr$1	;if not, then read first para.
					;from expression file
		xra	a
		sta	ex$para		;set para. to zero
		call	rd$para
		lxi	h,exp$mem+cwt$siz	;start of exp$mem buffer
		shld	exp$ptr		;local pointer to cells
		shld	exp$adr		;public pointer
		ret
;
fst$expr$1:	lxi	h,exp$mem+cwt$siz
;
;	test for no cells in memory, (empty buffer)
;
		mov	a,m		;get row/flag byte
		cpi	eo$flag		;flag for eop or eof
		jz	fst$expr$2
;
;	valid cell return address of row byte
;
		shld	exp$ptr
		shld	exp$adr
		ret
;
;	flag byte was 0ffh, so no cell in memory and no .exp file open
;
fst$expr$2:	shld	exp$ptr		;set local pointer to head
		lxi	h,0000h		;error return
		shld	exp$adr		;public pointer
		ret
;
;
;
; ***** get_next_expression_cell
;
;	returns a pointer to the next logical expression cell in
;	expression memory.
;
;	inputs:	none
;	returns:	EXP$ADR = 0000h, if end of expression file is reached
;			EXP$ADR = pointer to the row byte of the next expr cell
;
nxt$exp:	lhld	exp$ptr
		mov	a,m
;
;	test for end of para, or end of file flag
;
		cpi	eo$flag		;eop or eof flag
		jnz	next$expr$1
		inx	h		;pointer to column byte
;
;	test for eop or eof
;
		cpi	eo$file
;
;	if end of para, then read in next paragraph from file
;
		jz	next$expr$2
;
;	next paragraph
;
		call	rd$nx$pr
		lxi	h,exp$mem	;set pointer to head
		shld	exp$ptr		;and up date pointers
		shld	exp$adr		;return address
		ret
;
;	if end of file, then return error code
;
next$expr$2:	lxi	h,0000h		;error code, end of file
		shld	exp$adr		;public pointer
		ret
;
;	everything is good, return pointer to row byte of cell
;
next$expr$1:	call	step$expr	;step pointer to next cell
		lhld	exp$ptr		;local pointer
		shld	exp$adr		;public pointer
		ret
;
;
;
; ***** append_expression_cell *****
;
;	appends the expression cell in TMP$EXP to the end of the
;	expression file.
;
;	inputs:	A copy of the expression cell to be inserted in TMP$EXP
;
;	returns:	EXP$ADR = 0000h, if no directory space remains
;			on the disk
;			EXP$ADR = 0001h, if insufficient space remains
;			on the disk
;			EXP$ADR = A pointer th the end of the expression
;			file in EXP$MEM
;
add$exp:	lhld	exp$ptr		;test for end of file
		mov	a,m
		cpi	eo$flag
		jnz	add$exp$1	;not "end of" flag
		inx	h
		cpi	eo$file
		jz	add$exp$2	;found end of file
;
;	at end of paragraph but not end of file, so read next paragraph
;
		call	rd$nx$pr	;read next paragraph
		lxi	h,exp$mem	;pointer to head of buffer
		shld	exp$ptr
		jmp	add$exp		;loop till' end of file
;
add$exp$1:	call	step$expr	;step to next expression cell
		jmp	add$exp
;
;	we have found the end of the file, now copy the expression
;	cell in TMP$EXP to the end if there is enough room, else
;	change end of file to new paragraph number and write it
;	to the disk
;
add$exp$2:	inx	h		;point to one past end of cell
		push	h		;save pointer
;
;	check if cell will fit in buffer
;
		lxi	d,exm$end-1
		lxi	h,tmp$exp+esz$off	;get new cell size
		mov	a,m
		adi	exp$const	;size plus header bytes
		pop	h
		call	add$ahl
		call	cp$hl$de	;test if .lt. end of buffer
		jnc	add$exp$3	;is not bigger than buffer
		lhld	exp$ptr
		inx	h		;point to para number
		lda	ex$para		;get current paragraph number
		mov	m,a		;make this a paragraph
		call	wr$para
		lxi	h,ex$para
		inr	m
		lxi	h,exp$mem	;point to head of buffer
		shld	exp$ptr
;
add$exp$3:	lxi	d,tmp$exp	;source of the move
		lda	tmp$exp+esz$off
		adi	exp$const	;number of bytes to move
		mov	c,a
		mvi	b,00h
		lhld	exp$ptr		;dest. of move
		xchg
		call	mov$in$lp	;use common code
		xchg
		shld	exp$ptr
		mvi	m,eo$flag	;new end of file
		inx	h
		mvi	m,eo$file
;
;	write out end of file
;
		call	wr$para
		ret
;
;
; ***** find_expression_cell *****
;
;	Searches the expression file for exp$cell addressed
;	by <hl>, the range byte is included into the search.
;
;	inputs:	row and column address in <hl>
;	returns:	<hl> = 0000h, if the cell was not found
;			<hl> = 0001h, and EXPR$PTR = prototype cell address,
;			if the cell was found, but was within the range
;			of a prototype cell
;			<hl> and EXPR$PTR = A pointer to the requested cell
;
fnd$exp:	xra	a		;rewind the primary input file
		sta	ex$para
		sta	in$range
		lxi	h,exp$mem+cwt$siz
;
;	read the first or next paragraph off the disk
;
find$expr$6:	shld	exp$ptr
		call	rd$para
;
;	now build the range offsets and check the row bytes for equal
;	if .ne. then check the column for .eq. or for within a column range
;
find$expr$5:	call	make$rng	;build range bytes
		lhld	exp$ptr
		lda	exp$row		;row address
		cmp	m
;
;	if the row bytes match continue with the check of the column bytes
;
		jnz	find$expr$1	;trow <> mrow
;
;	rows bytes match
;
find$expr$4:	inx	h		;point to column byte
		lda	exp$col
		cmp	m
		dcx	h		;adjust pointer to row byte
;
;	test column bytes, if .eq. then done, else if .lt. then
;	goto next expr$cell
;
		jz	found$expr	;tcol = mcol
		jc	find$expr$2	;tcol < mcol
;
;	check to see if column is within the range limit
;
		mov	b,a
		mov	c,m		;get column byte
		lda	col$rng
		add	c		; range + column
		cmp	b
;
;	if not within range, then goto next cell
;
		jc	find$expr$2	; tcol > (mcol+rng)
		ori	rng$flg
		sta	in$range
;
;	found the cell save the pointer and return
;
found$expr:	shld	exp$ptr
		lda	in$range
		ora	a
		rz
		lxi	h,0001h		;found within range code
		ret
;
;	now test if the row is .lt., if so then check range,
;	if not then goto next cell
;
find$expr$1:	jc	find$expr$2	;trow < mrow
		mov	b,a
		mov	c,m		;get row byte
		lda	row$rng
		add	c		; range + row
		cmp	b
;
;	if not within range, then goto next cell
;
		jc	find$expr$2	;trow > (mrow+rng)
;
;	row is within the range, go back and check the column
;
		ori	rng$flg
		sta	in$range
		jmp	find$expr$4	;trow < (mrow+rng)
;
;	not at the right cell, step to the next one and check
;	for end of paragraph or end of file
;
find$expr$2:	call	step$expr
		xra	a
		sta	in$range	;clear range flag
		lhld	exp$ptr
		mov	a,m
		cpi	eo$flag		;"end of " flag
		jnz	find$expr$5	;not end so continue
		inx	h		;end flag found, check for para or file
		mov	a,m
		cpi	eo$file
		jz	find$expr$3	;end of file, return error code
;
;	read next paragraph
;
		call	rd$nx$pr
		lxi	h,exp$mem
		jmp	find$expr$6
;
;	end of file error, we could not find the cell in the file
;	so return the not found error code
;
find$expr$3:	lxi	h,0000h
		ret
;
;
;
; ***** get_value_cell *****
;
;	returns a pointer to the value cell addressed by <hl>
;	<h>=row address, <l>=column address.
;
;	inputs:	<hl> = address the desired value cell
;	returns:	VAL$ADR = 0000h, if the value cell was not found
;			VAL$ADR = pointer to row byte of the desired value cell
;
get$val:	shld	val$col
		lxi	h,val$mem	;start search at head of value memory
		shld	val$ptr		;local pointer
;
;	first, check if we are empty or at the end of the file
;
get$valu$4:	lhld	val$ptr
		mov	a,m		;get row byte
		cpi	eo$flag
		jnz	get$valu$1	;jump if not end
		inx	h		;pointer to col byte
;
;	end of memory, set local pointer to start and return error code
;
		cpi	eo$file
		jnz	mem$error	;panic stop
;
get$valu$2:	lxi	h,val$mem	;head of value cells
		shld	val$ptr	;local
		lxi	h,0000h		;error code, not found
		shld	val$adr		;public pointer
		ret
;
;	here we test the row and column address until we get a
;	match or until we reach the end of memory
;
get$valu$1:	lda	val$row		;compare address untill match
		cmp	m		;test row byte
		jnz	get$valu$3	;no match, move to next cell
		inx	h		;column byte
		lda	val$col
		cmp	m		;test column byte
		jnz	get$valu$3	;no match, move to next cell
;
;	we have a match, set pointer to row byte and return
;
		dcx	h		;point to row byte
		shld	val$ptr
		shld	val$adr		;public
		ret
;
get$valu$3:	call	step$valu	;move to next value cell
		jmp	get$valu$4	;loop unitl we return
;
;
; ***** put_value_cell *****
;
;	inserts the valu$cell in TMP$VAL into the value memory
;	at the address specified by the row and column bytes
;	of TMP$VAL.
;	inputs:	A copy of the valu$cell in TMP$VAL
;	returns:	VAL$ADR = 0000h, if the valu$cell was not
;			inserted due to insufficient memory.
;			VAL$ADR = A pointer to the next valu$cell
;			after the cell that was inserted.
;
put$val:	lxi	h,val$mem	;start at head of memory
		shld	val$ptr
;
;	first determine where the valu$cell should be inserted
;
put$valu$1:	lhld	val$ptr
		lda	tmp$val		;start with row byte
		cmp	m
;
;	if the row bytes are equal then check the column bytes
;
		jz	put$valu$2	; trow = mrow (copy)
;
;	if the row byte in tmp. is .lt. than mem. then insert
;	the cell in front of the cell pointed to by valu$ptr
;
		jc	put$valu$3	; trow < mrow (insert)
;
;	the row byte in tmp. is .gt. then mem. so step to
;	the next cell and start tests all over again
;
		call	step$valu
		jmp	put$valu$1
;
;	row bytes are equal, test column address to see if we
;	want to insert or copy over an existing cell
;
put$valu$2:	inx	h		;point to column byte
		lda	tmp$val+1
		cmp	m
;
;	the row bytes are equal, and if column bytes are also equal,
;	then we must copy over an existing cell
;
		jz	put$valu$4	;tcol = mcol (copy)
;
;	the row bytes are equal, but the tmp. column byte is .lt.
;	the mem. column byte, so we must insert a cell at valu$ptr
;
		jc	put$valu$3	;tcol < mcol (insert)
;
;	the row bytes are equal, but the tmp. column byte is .gt.
;	the mem. column byte, so step to the next cell and start
;	the tests all over again.
;
		call	step$valu
		jmp	put$valu$1
;
;	here we want to insert a cell, so move the cells between
;	valu$ptr and vtl$ptr out to make room for the new cell
;
put$valu$3:	lhld	val$ptr
		shld	tmp$ptr		;used in copy routine
;
;	get the size of the new cell and save it in offset
;
		lxi	h,tmp$val+vsz$off	;size byte
		mov	a,m
		adi	val$const	;header size
		sta	offset
;
;	now setup pointers so we can move the cells in valu$mem out
;	so we can insert the new cell
;
;	first check if adding in a new cell will overflow the
;	end of valu$mem
;
put$valu$9:	lhld	eom$ptr		;end of memory pointer
		xchg
		lhld	vtl$ptr
		shld	iii		;move routine source pointer
		lda	offset
		call	add$ahl		;add offset to tail pointer
		shld	jjj		;move routine dest. pointer
		call	cp$hl$de	;test if tail .gt. end of memory
		jc	put$valu$6	; yes, return error code, no memory
		shld	vtl$ptr		;save new tail pointer
		lda	offset
		lhld	val$ptr
		call	add$ahl
		shld	val$ptr		; and new cell pointer
		xchg			; save <hl>
		lhld	vtl$ptr
		xchg
		call	sub$hlde	;subtract valu$ptr from vtl$ptr
					; and get the size of the move
		shld	mov$siz		; counter for move routine
		call	mov$out		; make the necessary hole
;
;	valu$cell memory has been moved as necessary
;	now copy the new valu$cell into the hole in valu$mem
;
put$valu$7:	lxi	d,tmp$val	;source of the move
		lda	tmp$val+vsz$off
		adi	val$const	;number of bytes to move
		mov	c,a
		mvi	b,00h
		lhld	tmp$ptr		;dest. of move
		xchg
		call	mov$in$lp	;use common code
		lhld	val$ptr
		shld	val$adr		;return value
		ret
;
;	row bytes and column bytes are equal, so check size bytes
;	to determine if the cell are the same size, the new cell
;	is larger than the old cell, or the new cell is smaller
;	than the old cell
;
put$valu$4:	lhld	val$ptr
		shld	tmp$ptr		;save dest. of copy
		lxi	d,vsz$off
		dad	d
		lda	tmp$val+vsz$off
		cmp	m
;
;	if the size bytes are the same then just over-write
;	the old cell
;
		jz	put$valu$7	;tsiz = msiz
;
;	if the tmp. size byte is .lt. the mem. size byte
;	we must move cell in, new cell is smaller than the
;	old cell
;
		jc	put$valu$8	;tsiz < msiz
;
;	tmp. size byte is .gt. the mem. size byte, so we must
;	move all following cell out to make room for the new cell
;
		sub	m		;tsiz > msiz
		sta	offset		;size difference
		call	step$valu	;mov to next cell
;
;	treat the same as an insert
;
		jmp	put$valu$9	;use common code
;
;	the new cell is smaller than the old cell so move
;	all following cells in
;
put$valu$8:	mov	b,a		;tsiz < msiz
		mov	a,m		;get old cell size
		sub	b		;subtract new size from old size
		sta	offset
		call	step$valu
		lda	offset
		lhld	val$ptr
		shld	iii
		call	sub$ahl
		shld	jjj
		shld	val$ptr
		lda	offset
		lhld	vtl$ptr
		call	sub$ahl
		shld	vtl$ptr
		xchg
		lhld	val$ptr
		call	sub$hlde
		shld	mov$siz
		call	mov$in
		jmp	put$valu$7
;
;	error return
;
put$valu$6:	lxi	h,0000h
		shld	val$adr
		ret
;
;
; ***** make_range_bytes *****
;
;	builds the values for "row$rng" and "col$rng" from
;	the range byte in the expression cell
;
make$rng:	lhld	exp$ptr		;get pointer to cell
		lxi	d,rng$off	;offset from row byte to range byte
		dad	d
		lxi	d,0000h
		mov	a,m
		ani	row$mask	;is it a row range ?
		jz	mak$rng$1
		mov	a,m		;yes, so get range value
		ani	rng$mask	;strip row/column flags
		mov	d,a
		jmp	save$rng
;
mak$rng$1:	mov	a,m		;not row, try column
		ani	col$mask
		jz	save$rng	;not row or column, set both to zero
		mov	a,m
		ani	rng$mask	;strip flags
		mov	e,a
;
save$rng:	xchg
		shld	col$rng		;row or column range saved
		ret
;
;
; ***** step_to_next_expression_cell *****
;
;	moves the expression pointer to the row byte of the next expr$cell
;
step$expr:	lhld	exp$ptr		;get pointer
		lxi	d,esz$off	;offset to size byte in header
		dad	d
		mov	a,m		;get size byte
		inx	h		;point to cell string
		call	add$ahl
		shld	exp$ptr
		ret
;
;
; ***** step_to_next_value_cell *****
;
;	moves the value cell pointer to the row byte of the next valu$cell
;
step$valu:	lhld	val$ptr		;get pointer
		lxi	d,vsz$off	;offset to size byte in header
		dad	d
		mov	a,m		;get size byte
		inx	h		;point to cell string
		call	add$ahl
		shld	val$ptr
		ret
;
;
mem$error:	jmp	$
;
;
;
; ***** mov$out *****
;
;	moves memory from high address to low address
;
mov$out:	call	set$move	;setup
;
mov$out$lp:	mov	a,m
		stax	d
		dcx	h
		dcx	d
		dcx	b
		mov	a,b
		ora	c
		jnz	mov$out$lp
		ret
;
;
; ***** mov$in *****
;
;	moves memory from low address to high address
;
mov$in:		call	set$move	;setup for move routine
;
mov$in$lp:	mov	a,m
		stax	d
		inx	h
		inx	d
		dcx	b
		mov	a,b
		ora	c
		jnz	mov$in$lp
		ret
;
;	setup pointers and counter for move routines
;
set$move:	lhld	mov$siz		;move length
		mov	b,h
		mov	c,l
		inx	b		;+1
		lhld	jjj		;dest. pointer
		xchg
		lhld	iii		;source pointer
		ret
;
;
; ***** cp$hlde *****
;
;	compare <hl> to <de>
;	returns:	[z] if <hl> = <de>
;			[c] if <hl> > <de>
;
cp$hlde:	mov	a,e
		sub	l
		mov	a,d
		sbb	h
		ret
;
;
; ***** add$ahl *****
;
;	add <a> to <hl>, result in <hl>
;
add$ahl:	add	l
		mov	l,a
		rnc
		inr	h
		ret
;
;
; ***** sub$hlde *****
;
;	subtract <hl> from <de>, result in <hl>
;
sub$hlde:	mov	a,e
		sub	l
		mov	l,a
		mov	a,d
		sbb	h
		mov	h,a
		ret
;
;
; ***** sub$ahl *****
;
;	subtract <a> from <hl>, result in <hl>
;
sub$ahl:	cma
		inr	a
		add	l
		mov	l,a
		rc
		dcr	h
		ret
;
;
	dseg
;
in$range	db	00h		;found within a range flag
row$rng		db	00h		;value of row range (0...63)
col$rng		db	00h		;value of column range (0...63)
;
tmp$ptr		dw	0000h		;temporary pointer, used for moves
offset		db	00h		;difference in cell size
mov$siz		dw	0000h		;length of move
iii		dw	0000h		;source pointer
jjj		dw	0000h		;destination pointer
;
;
