	title	'CCS 2422 cold boot for cp/m 2.2'
	page	58
	maclib	z80
$*M
;
; this boot loader will load the cp/m system in from the system tracks
;	of an 8" disk.  it is independent of sector size or density.
;
;
	org	80h
;
msize	equ	64		;memory size in kilobytes
bias	equ	(msize-20)*1024
ccp	equ	2c00h+bias
bios	equ	ccp+1600h	;base of bios
;
spt	equ	44h
cunit	equ	4ah
idsv	equ	4eh
;
dcmd	equ	30h
dstat	equ	dcmd
dsctr	equ	dcmd+2
ddata	equ	dcmd+3
dctrl	equ	dcmd+4
;
bank	equ	40h
;
;
rstor	equ	0dh
rdsec	equ	88h
stepi	equ	5dh
;
;
start:	xra	a		;turn off the shadow rom
	out	bank
	lda	cunit		;get the select bits
	mov	b,a
	lxi	h,tbl		;address of 8" sectors per track
;
load2:	mov	c,m		;get the track 00 spt
	mov	a,b		;reget the selbits
	ani	40h		;see if double density
	jrz	load3		;jump if not
	dcx	h		; else, adjust pointer for dden spt
;
load3:	xra	b		;build track 00 selbits
	mov	b,a		;save in (b)
	lda	idsv+3		;get sector size
	add	l		;offset the pointer
	mov	l,a
	mov	a,m		;get the correct sectors per track
	sta	spt		;save it
	lxi	h,ccp-1		;get the cp/m load address
	lxi	d,(bios+800h)+2		;stop page address, start sector
	mov	a,b		;reget the selbits
	out	dctrl
	mvi	a,rstor		;home the disk
;
load0:	out	dcmd
;
load1:	in	dctrl		;wait til done
	rar
	jrnc	load1
	in	dstat		;get the status
	ani	98h		;mask for errors
	jrnz	start		;try again if errors
;
load4:	mov	a,e		;get the start sector
	out	dsctr
	in	ddata		;clear any bogus status bits
	mov	a,b		;get the select bits
	ori	80h		;set the auto-wait bit
	out	dctrl
	mvi	a,rdsec		;start the track read going
	out	dcmd
;
load5:	inx	h		;increment the pointer
	in	ddata		;get the data
	mov	m,a		;store it
	in	dctrl		;see if intrq released the wait
	rar			;check for intrq
	jrnc	load5		;jump if valid data
	dcx	h		;adjust the memory pointer
	in	dstat		;check the status
	ani	9ch		;mask for read errors
	jrnz	start		;try again if error
	mov	a,h		;see if all in
	cmp	d
	jnc	bios		;jump if so
	mov	a,e		;no, check for track overflow
	inr	e		;increment sector pointer
	cmp	c
	jrnz	load4		;jump if no overflow
	lda	spt		;else, go to next track
	mov	c,a		;set the correct spt
	lda	cunit
	mov	b,a		;reset the selbit
	out	dctrl
	mvi	a,stepi		;get a step in command
	mvi	e,01		;reset sector counter
	jr	load0		;go do the step in
;
tbl:	db	26,15,8,4	;8" sectors per track table
		end
