	title	'Imac -- main module, version 4.0.  27 aug 82'
;
;
	public	cnv$dec,dvalue,suppress
;
	extrn	stack,lcnt,errcnt
	extrn	init,setup,pcon,wobuff,perr,dhex,eor
	extrn	setsym,setlib,readlib,pagset,pagej,setinc
	extrn	inits,scan,putbuf,scanp,inisy,lookup,found
	extrn	enter,setty,getty,setval,getval,setprn
	extrn	getprn,setpar,getpar,setchr,getchr,pushm
	extrn	popm,plookup,pfound,entdef,entpar,rempar
	extrn	gettxa,lcomp,chash,initpar,bget,opand,mulf
	extrn	dive,toknum,settok,pbuff,setinc,pentry
	extrn	rd$inc
	extrn	macsp,mactyp,reppro,repbas,macnxt,nxtchr,macfol,maclev
	extrn	macflg,macif,incsp,emacstk,t11e2
	extrn	symtyp,symcol,symln,listcnt,lastadr,curadr,alplist
	extrn	endalp,idbp,idfoll,idlen,idbuff
	extrn	qbp,token,value,acclen,accum,evalue,sytop,acc$ptr
	extrn	symax,pass,fpc,aspc,sybas,syadr,sypar,deflev
	extrn	nextc,copytyp,libinp,symlst,maclst,macbeg
	extrn	titloc,qsymlst,liblst,lstflg,relflg,incinp
	extrn	t11e2,al$ptr
;
;
;	the macro assembler is organized as a sequence of modules
;	code:
;		main	main program, principal element processor
;		opmod	operand scanner, handles expressions
;		scmod	token scanner (idents, numbers, etc.)
;		symod	symbol table access module
;		bmod	fixed element table (macro, page, etc.) with
;			binary search subroutine
;		iomod	handles all operating system io ops
;
;	data:	macmod	macro processing stacks
;		commod	common data areas
;			128 byte area for stack (64 levels)
;
;	symbol:		remaining space (up to dos given by location 6)
;			is used for symbol table
;
;	each module accesses other modules as shown below:
;		main	opmod,scmod,symod,bmod,iomod,commod,macmod
;		opmod	      scmod,symod,bmod,iomod,commod
;		scmod		    symod,     iomod,commod
;		bmod				     commod
;		iomod				     commod,macmod,lastasm
;
;
;	common areas for the macro processor
;
maxexp		equ	15		;top element of parallel macro stacks
macsiz		equ	maxexp+1	;size of parallel macro stacks
dmacsiz		equ	macsiz*2	;double precision mac size
;
ptsize		equ	16		;parameter hash table size
tmain		equ	0		;"type" corresponding to current macro level (main)
tmac		equ	1		;processing a macro definition
tparm		equ	2		;processing macro parameter
tirpc		equ	3		;processing irpc statement
tirp		equ	5		;processing irp statement
trept		equ	6		;processing rept statement
;
;
;	the following variables are used during the post processing
;	symbol table dump, and overlay the macro table area
;
;
idmax		equ	15		;last idbuff position
;
;	the parallel stacks for macro processing are shown in the maccom module
;
;	common equates
;
;
pbmax		equ	132		;max print size
acmax		equ	64		;max accumulator length
srcstrt		equ	32		;start of source line in output
;
;	global equates
;
iden		equ	1		;identifier
numb		equ	2		;number
strng		equ	3		;string
specl		equ	4		;special character
parm		equ	5		;macro parameter (through scanp)
;
plabt		equ	0000$0001b	;program label
dlabt		equ	0000$0010b	;data label
equt		equ	0000$0100b	;equate
sett		equ	0000$0101b	;set
mact		equ	0000$0110b	;macro
;
extt		equ	0000$1000b	;external
reft		equ	0000$1011b	;refer
glbt		equ	0000$1100b	;global
;
cr		equ	0dh		;carriage return
lf		equ	0ah		;line feed
eof		equ	1ah		;end of file
tab		equ	09h		;tab character
nbmax		equ	24		;starting position of print line
;
fixd		equ	5		;# overhead bytes for simple symbols
;
rt		equ	25		;register type
pt		equ	rt+1		;pseudo operation
pendif		equ	5		;pseudo operator 'endif'
pendm		equ	6		;  "	    "	 'endm'
pif		equ	8		;  "	    "    'if'
pmacro		equ	9		;  "	    "    'macro'
pelse		equ	13		;  "	    "    'else'
pirp		equ	14		;  "	    "    'irp'
pirpc		equ	15		;  "	    "    'irpc'
prept		equ	16		;  "	    "    'rept'
;
;
obase		equ	pt+1
o1		equ	obase+1		;first operation code
o15		equ	obase+15	;last operation code
;
maxsycol	equ	80		;length of symbol table line
consiz		equ	8		;number of conditional stack elements
ifcon		equ	1		;currently processing 'if'
elcon		equ	2		;currently processing 'else'
;
;	jmp	main
;
;
;	main statement processing loop
;
main:	lxi	sp,stack
;
;	stack set for processing throughout assembly
;
		xra	a
		sta	pass		;set to pass 0 initially
		sta	deflev		;not in a macro definition
		call	init		;set up io, send signon message
		call	inisy		;initialize the symbol table
		lxi	h,0000h
		shld	lastmac		;list of defined macros = nil
;
restart:	;pass loop goes from 0 to 1
		call	initpar		;initialize parm hash entry to 00
		xra	a
		sta	macsp		;clear the macro stack pointer
		mvi	a,tmain
		sta	mactyp		;current level is main program
		lhld	symax		;current top of symbol table
		shld	maclev		;saved on first push operation
;
		call	inits		;initialize the scanner
		call	setup		;set up the input file
		lxi	h,0000
		shld	sylab		;no starting label set
		shld	gsymcnt		;generated symbol count 0001-9999
		lda	relflg		;rel-1 image?
		ora	a
		jz	setorg
		lxi	h,0100h		;offset by 100h
;
setorg:		shld	fpc
		shld	aspc
		shld	epc		;end pc
		xra	a
		sta	csp		;clear conditional stack pointer
;
scnext:		;scan the next input item
		call	scan
scn0:		lda	token
		cpi	numb		;skip leading numbers from line editors
		jz	scnext
		cpi	specl		;may be toggle for macro or literal name
		jnz	scn1
;
;	special character, check for $
;
		lda	accum
		cpi	'$'
		jnz	chend		;end of line if not $
;
;	$ found, no preceding label allowed
;
		call	setla
		jnz	sterr		;error if label
		lda	nextc		;must be +,-, or *
		mvi	b,00
		cpi	'-'		;turn off macros?
		jz	setmsw
		mvi	b,0000$0011b	;turn on macros?
		cpi	'+'
		jz	setmsw
		mvi	b,111b		;turn on partial macros?
		cpi	'*'
		jnz	sterr		;error otherwise
;
setmsw:		;set macro/print switch from <b>
		push	b
		call	scan		;clear +,-, or *
		pop	b		;recall parm value
		lda	nextc		;must be m or p
		lxi	h,maclst
		cpi	'M'
		jz	setsv
		lxi	h,lstflg
		cpi	'P'
		jnz	sterr		;must be m or p
;
setsv:		;set param value from reg <b>
		mov	m,b		;<hl> addresses parameter location
		call	scan		;clear the m or p
		jmp	poend		;to check end of line syntax
;
;
scn1:		;not number or special character, check for identifier
		cpi	iden
		jnz	sterr		;error if not
;
;	identifier found, may be label, opcode, or macro
;
		call	bget		;binary search fixed data
		jz	chkpt		;check for pseudo or real operator
;
;	binary search was unsuccessful, check for macro
;
		call	lookup
		call	found
		jnz	lfoun		;[nz] flag set if found
;
;	not found, enter it
;
		call	enter		;this must be pass 0
		lda	pass
		ora	a
		cnz	errp		;phase error if not
		jmp	setsy		;set sylab
;
;
;	item was found, check for macro
;
lfoun:		call	getty
		cpi	mact
		jnz	setsy
;
;	found a macro, may be redefinition in pass 0,1
;
		lxi	h,0000		;clear previous macro value before down search
		shld	prevmac		;no undefined macros yet
;
;	item is a macro, active?
;
		lda	pass
		ora	a
		jz	macact		;active if on pass 0
;
;	not on pass 0, active if getval <= syadr
;
mfoun:		call	getval		;value field to <hl>
		xchg
		lhld	syadr		;address of symbol to <hl>
		mov	a,l
		sub	e
		mov	a,h
		sbb	d
		jc	notdefd		;[CY] if not yet defined on pass 1
;
;	no carry, item is defined on pass 1, look for macro name
;	also enter on pass 0 with item found
;
macact:		;macro is active
;
;	check for "macro" following the name
;
		call	savacc		;accumulator saved at top of symbol table
		call	scanp
		call	chkmac		;check for macro
		jnz	macexp		;expand macro if not followed by macro
;
;	name is followed by "macro", check pass
;	line cannot be labelled
;
		lhld	sylab
		mov	a,h
		ora	l		;sylab=0000?
		cnz	errs		;syntax error if labelled
		lda	pass
		ora	a
		jnz	redef		;skip to redef if pass > 0
;
;	pass = 0, redefine by creating a new symbol
;
		call	resacc		;restore the accumulator from symtab
		call	chash		;restore the hash code for the accum
		call	enter		;setting syadr
		lhld	syadr
		shld	sylab		;setting label address
		jmp	smacro		;to process the macro body
;
;
notdefd:	;macro not yet defined in pass > 0, scan for another by same name
		lhld	syadr
		shld	prevmac		;to save the lowest in table
		call	lcomp		;to continue comparing
		call	found		;to see if it was found
		jz	macname		;skip if no more entries in table
;
;	another entry found, must be macro type
;
		call	getty
		cpi	mact
		jnz	macphase
;
;	not a phase error, so go around again
;
		jmp	mfoun
;
;
macname:	;no more entries in table which match, must be redefinition
		call	scanp
		call	chkmac		;macro?
		jnz	macphase
;
;	followed by the word macro on pass 1, redefine
;
redef:		lhld	prevmac
		xchg
		lhld	nextmac		;must be next in line
		call	comdh		;same?
		jnz	macphase	;phase error if not
;
;	redefinition allowed since prevmac = nextmac to define
;
		shld	sylab		;to set the label field
		jmp	smacro		;to process remainder
;
;
;	utility subroutines for macro call scanning
;	(used above)
;
savacc:		;save the accumulator in symbol table to allow lookahead scan
		lhld	sytop		;next to fill
		push	h		;save for later restore
		shld	sypar		;next to fill-1
		lxi	h,acclen	;save it at sypar
		mov	c,m		;length in <c> for count down to 0
		mov	b,c		;copy to <b> for later store
;
savac0:		inx	h		;next to get
		mov	a,m
		push	b
		push	h		;save counters and accum address
		call	setchr		;place char in symbol table and update pointers
		pop	h
		pop	b
		dcr	c
		jnz	savac0
		pop	h		;reclaim base of save area
		mov	m,b		;store the length
		shld	sytop		;reset the top of the table
		ret
;
;
resacc:		;restore accumulator from the top of the symbol table
		lhld	sytop		;length of accumulator saved above
		mov	c,m		;get length to <c>
		shld	sypar		;set up next to get - 1
		lxi	h,acclen
		mov	m,c		;length is set
;
resac0:		inx	h		;next accum position to fill
		push	b
		push	h		;counters and accum address saved
		call	getchr		;next character to acc
		pop	h
		pop	b
		mov	m,a		;next character placed into accum
		dcr	c		;count length down
		jnz	resac0
		ret			;with accumulator filled
;
;
chkmac:		;look for "macro" following the name
		lda	token
		cpi	parm
		rnz			;not an ident
		call	bget		;binary search
		rnz			;not found
		cpi	pt		;pseudo type?
		rnz
		mov	a,b		;pseudo op number
		cpi	pmacro		;'macro'?
		ret
;
;
macphase:	call	errp		;phase error in macro
		jmp	chend		;to process end of line
;
;
;	macro has been defined on this pass, expand it
;
macexp:		;enter here with first parameter already scanned
		lhld	syadr		;base of macro
		push	h		;save it temporarily
		call	filab		;set label on line, if present
		lhld	aspc		;print address if not listing macros
		lda	maclst
		ora	a
		cz	paddr		;address printed if no maclst
		pop	h		;recall macro base
		shld	syadr		;replaced
;
		call	getprn		;parameter count in a register
		sta	nparms		;save it for parameter scan
		lhld	symax		;current top of table
		push	h		;save it for stacking below
;
;	since initial parameter has been scanned, enter at macexi
;
		ora	a		;parm count = 0?
		jz	expclr		;and skip the loop entirely
		jmp	macexi		;to process the first parameter
;
;
;	(pardel is used below to detect end of parms)
;
pardel:		;return true if parameter delimiter found
		cpi	';'
		rz
		cpi	cr
		rz
;
pardl0:		;enter here to test real end of line
		cpi	lf
		rz
		cpi	eof
		rz
		cpi	'!'
		ret
;
;
macex0:		lda	nparms
		ora	a		;any parms left to scan?
		jz	expclr		;clear to end of line if not
;
;	more parms follow
;
		call	scanp		;scan a macro parameter
;
macexi:		lda	token
		cpi	specl		;look for delimiters
		jnz	expacc		;expand to accum if not a delimiter
		lda	accum
		call	pardel		;delimiter?
		jz	expnul		;expand to null if end of line
		cpi	'%'		;evaluate the parameter immediately?
		jnz	macex1
;
;	parameter was preceded by a percent, call expression handler
;
		call	exp16		;16 bit value to <hl>
		shld	dvalue		;temporary used to compute decimal equivalent
		mvi	a,0ffh		;set zero suppress on
		sta	suppress
;
;	check for following character (which is overwritten by convdec)
;
		lda	token		;scanned by exp16
		cpi	specl
		jnz	emacex
		lda	accum		;special character which follows expression
		push	psw		;save the character
		xra	a		;clear the accum length to start number at 0 position
		sta	acclen
		call	convdec		;convert to decimal in accumulator
		call	fillpar		;fill from accumulator
		pop	psw		;restore following character
		jmp	expacc0		;to check syntax
;
;
macex1:		;special char is not %
		cpi	','		;double commas
		jnz	expacc		;otherwise use accum value
;
;	comma encountered, fill with null
;
		call	zfillpar
		jmp	macex0		;assume comma already scanned
;
;
expacc:		;expand accumulator
		call	fillpar		;fill definition from accum
		call	scan		;comma?
		lda	token
		cpi	specl
		jnz	emacex		;error in scan if not specl
		lda	accum
;
expacc0:	call	pardel		;parameter delimiter?
		jz	expnul		;expand nulls if end of line
		cpi	','		;normal delimiter?
		jz	macex0
;
emacex:		;error in macro line
		call	errs		;'S' syntax error
;
expnul:		;fill in nulls
		lda	nparms
		ora	a
		jz	expclr
		call	zfillpar
		jmp	expnul
;
;
expclr:		;clear to end of line
		lhld	sypar
		inx	h		;beginning of text string in <hl>
		push	h		;save it for below
;
expcl0:		;scan to end of line
		lxi	h,nextc
		mov	a,m
		call	pardl0		;end of line?
		jz	expcl1		;to clear it
		call	scan		;to next token
		jmp	expcl0		;for another
;
;
expcl1:		xra	a
		mov	m,a		;nextc is cleared
		sta	nxtchr		;next character is cleared
		call	writep		;to clear the line
		lda	csp		;conditional stack pointer
		sta	macif		;save it for later restore
		call	pushm		;save parameters
		pop	h		;start of text
		shld	macnxt
		pop	h		;base of symbol table
		shld	maclev
		xra	a		;clear next character to read
		sta	nxtchr
		mvi	a,tmac		;this is a macro
		sta	mactyp
		jmp	scnext		;to start the macro expansion
;
;
writep:		;write the output buffer
		lda	macsp
		ora	a
		jz	writep0
;
;	in a macro, insert macro indicator
;
		lxi	h,pbuff+5
		mvi	m,'+'
;
writep0:	call	wobuff
		mvi	a,srcstrt
		sta	qbp		;start at beginning of line
		ret
;
;
clearmac:	;clear the macro stack to the topmost macro definition
		lda	macsp
		ora	a		;at zero?
		jz	errb		;jump to balance error and return
;
;	macro stack is not empty
;
		lda	mactyp
		cpi	tirpc
		rnc			;carry gen'ed if rept, irpc, or irp
		cpi	tmac
		rz			;return if tmac
		call	popm		;remove top element and try again
		jmp	clearmac
;
;
zfillpar:	;utility to fill a null parameter
		xra	a
		sta	acclen
;
fillpar:	;utility to fill a parameter and value
		call	entdef		;enter definition from accum
		call	getpar		;fill accum with next parameter
		call	entpar		;fill top area of symbol table with name
		lxi	h,nparms
		dcr	m		;count number of parms down by 1
		ret
;
;
setsy:		;label found - is it the only one?
		lhld	sylab
		mov	a,l
		ora	h
		cnz	errl		;label error if not
		lhld	syadr		;address of symbol
		shld	sylab		;mark as label found
;
;	label found, scan optional ':'
;
		call	scan
		lda	token
		cpi	specl
		jnz	scn0		;skip next scan if not special
		lda	accum
		cpi	':'
		jnz	scn0
		jmp	scnext		;to ignore ':'
;
;
;	binary search found symbol, check for pseudo or real op
;
chkpt:		cpi	pt		;pseudo opcode?
		jnz	chkot
;
;	pseudo opcode found, branch to cases
;
		mov	e,b		;<b> has particular operator number
		mvi	d,00		;double precision value to <de>
		dcx	d		;biased by +1
		lxi	h,pttab		;base of jump table
		dad	d
		dad	d
		mov	e,m
		inx	h
		mov	h,m
		mov	l,e
		pchl			;jump into table
;
;	pseudo opcode jump table
;
pttab		dw	sdb		;db
		dw	sds		;ds
		dw	sdw		;dw
		dw	send		;end
		dw	sendif		;endif
		dw	sendm		;endm
		dw	sequ		;equ
		dw	sif		;if
		dw	smacro		;macro
		dw	sorg		;org
		dw	sset		;set
		dw	stitle		;title
		dw	selse		;else
		dw	sirp		;irp 14
		dw	sirpc		;irpc 15
		dw	srept		;rept 16
		dw	saseg		;aseg 17
		dw	scseg		;cseg 18
		dw	sdseg		;dseg 19
		dw	sname		;name 20
		dw	spage		;page 21
		dw	sexitm		;exitm 22
		dw	sextrn		;extrn 23
		dw	slocal		;local 24
		dw	sinpage		;inpage 25
		dw	smaclib		;maclib 26
		dw	spublic		;public 27
		dw	sstkln		;stkln 28
;***************
		dw	sinclude	;include 29
;***************
;
;
sdb:		call	filab		;set label for this line to aspc
;
sdb0:		call	scan		;past db to next item
		lda	token		;look for long string
		cpi	strng
		jnz	sdbc		;skip if not string
		lda	acclen
		dcr	a		;length 1 string?
		jz	sdbc
;
;	length 0,2,... string
;
		mov	b,a
		inr	b
		inr	b		;becomes 1,3,... for 0,2,... lengths
		lxi	h,accum		;address characters in string
;
sdb1:		dcr	b		;count down to zero
		jz	sdb2		;scan delimiter at end of string
		push	b		;save count
		mov	b,m		;get character
		inx	h
		push	h		;save accum pointer
		call	filhb		;send to hex file
		pop	h
		pop	b
		jmp	sdb1
;
;
sdb2:		call	scan		;to the delimiter
		jmp	sdb3
;
;
;	not a long string
;
sdbc:		call	opand		;compute operand
		lhld	evalue		;value to <hl>
;
;	check for possible negative number (v error if not 8 bits)
;
		call	adj8
		mov	b,l		;get value to <b>
		call	filhb
;
sdb3:		;end of item - update aspc
		call	setas		;set aspc to fpc
		call	delim
		cpi	','
		jz	sdb0		;for another item
		jmp	chend		;check end of line syntax
;
;
sds:		call	filab		;handle label if it occurred
		call	padd		;print address
		call	exp16		;scan and get 16bit operand
;
;***************
;
		push	h
		mov 	b,h
		call	filhbq
		pop 	h
		push	h
		mov	b,l
		call	filhbq
		pop	h
;
;***************
;
		xchg			;to <de>
		lhld	aspc		;current pseudo pc
		dad	d		;+expression
		shld	aspc
		shld	fpc		;next to fill
		jmp	chend
;
;
sdw:		call	filab		;handle optional label
;
sdw0:		call	exp16		;get 16-bit operand
		push	h		;save a copy
		mov	b,l		;low byte first
		call	filhb		;send low byte
		pop	h		;reclaim a copy
		mov	b,h		;high byte next
		call	filhb		;send high byte
		call	setas		;set aspc=fpc
		call	delim		;check delimiter syntax
		cpi	','
		jz	sdw0		;get more data
		jmp	chend
;
;
send:		call	filab
		call	padd		;write last loc
		lda	pbuff
		cpi	' '
		jnz	chend
		call	exp16		;get expression if it's there
		lda	pbuff
		cpi	' '
		jnz	send0
		shld	epc		;expression found, store it for later
;---------------
		jmp	send01
;---------------
;
send0:		mvi	a,' '
		sta	pbuff		;clear error, if it occurred
;
		lhld	errcnt
		dcx	h
		shld	errcnt
;
;	may be a balance error in conditionals
;
send01:		lda	csp
		ora	a
		cnz	errb		;'B' error if unbalanced at end
		call	scan		;clear cr
		lda	token
		cpi	specl
		jnz	sterr
		lda	accum
		cpi	lf
		jnz	sterr
		jmp	endasm		;end of assembler
;
;
sendif:		call	filab		;set label if it occurs
		call	deccon		;decrement the conditional stack (possible error)
		jmp	poend
;
;
sendm:		;(enter here for both endm and exitm)
		push	b		;save endm/exitm flag
		call	filab		;in case of labelled endm/exitm
		call	clearmac	;clear to the topmost macro header
		lxi	h,pbuff+5
		mvi	m,'+'		;marked as macro in listing
		lda	mactyp		;macro with endm/exitm?
		cpi	tirpc
		jnc	sendm0		;carry gen'ed when rept,irp,irpc found
;
;	macro, clear it unconditionally
;
		pop	b		;unstack and forget it
		call	rempar		;to remove parameters
		jmp	endexp		;to end the expansion
;
;
sendm0:		;rept, irp, irpc
		lhld	maclev		;clear the active parameters and retry (maybe)
		push	h		;save maclev
		lhld	reppro		;base of text to repeat
		shld	maclev		;for rempar's use
		call	rempar		;upper active area cleared
		pop	h		;recall maclev
		shld	maclev		;restored.
		pop	psw		;endm/exitm flag in register <a>
		cpi	pendm		;endm?
		jnz	endexp		;end of expansion if exitm
;
;
exprept:	;expand the repeat loop (rept, irp, irpc) again
		lda	mactyp
		cpi	trept		;repeat <expression>?
		jnz	expirp
;
;	this is a repeat expression, more iterations?
;
		lhld	reppro		;base of repeat prologue
		mov	e,m		;low address
		inx	h
		mov	d,m		;<de> has base of prologue (16 bit expr. value)
		mov	a,e		;is it zero?
		ora	d
		jz	endexp		;skip to remove expansion
		dcx	d		;value=value-1
		mov	m,d		;back to symbol table
		dcx	h
		mov	m,e		;for the next iteration
		jmp	expnext		;to set up the expansion
;
;
;	enter here with irp or irpc, reppro addresses prologue which has
;	the next character address to scan in irp or irpc parameter.
;	enter with next position = cr if end of scan, 00 if null parm
;
expirp:		lhld	reppro		;base of prologue
		mov	e,m
		inx	h
		mov	d,m		;<de> = next position to scan
		ldax	d		;cr?
		cpi	cr
		jz	endexp		;terminate expansion if at cr
;
;	otherwise, another to fill - check for 00
;
		ora	a
		jz	irpzer		;fill null then stop execution
;
;	not null, test type of irp
;
		lda	mactyp
		cpi	tirpc
		jnz	nirp
		ldax	d		;get next character to acc
		inx	d		;to next character position
		mov	m,d		;store high order back
		dcx	h
		mov	m,e		;store low order next char address back
		lxi	h,acclen	;to fill accum with single character
		mvi	m,01		;length 1
		inx	h		;to beginning of accum
		mov	m,a		;store next character
		jmp	irpcf		;to fill parameter
;
;
irpzer:		;<de> addresses an empty parameter, set to cr for next loop stop
		mvi	a,cr
		stax	d		;cr set in macro body to stop on next iteration
		xra	a
		sta	acclen		;zero length accum
;
irpcf:		;fill definition from accumulator
		call	entdef		;definition filled
		jmp	irpid		;to fill parameter identifier
;
;
;	fill definition from next item in irp - scan from address
;	given by <de>
;
nirp:		lxi	h,idfoll	;save follow character
		mov	a,m
		push	psw
		mvi	m,00
		lxi	h,nextc		;save nextc
		mov	a,m
		push	psw
		mvi	m,00
;
;	nextc and idfoll are cleared for the parameter scan
;	reset macnxt to parameter (not in use right now)
;
		xchg			;next scan position to <hl>
		shld	macnxt
		mov	a,m
		sui	2ch
		jnz	s05c5
		inx	h
		push	h
		lxi	h,acclen
		mov	m,a
		call	entdef
		pop	h
		jmp	s05f0
;
;
s05c5:		push	h
		call	scanp
		pop	d
		call	s11e4
		jmp	nirp0
;
;	call	scanp		;accumulator filled, macnxt moved
;	lda	token		;is this a separator?
;	cpi	specl		;must be specl for ,
;	jnz	nirp0		;skip if not
;	lda	accum		;comma?
;	cpi	','
;	jnz	nirp0		;skip if not comma
;
;	argument null, pass 0 length parm
;
;	lxi	h,acclen
;	mvi	m,00
;	call	entdef		;enter definition into table
;	jmp	nirp1
;
nirp0:		;argument not null, set it up
		call	entdef		;fills the argument
		lhld	macnxt		;at end of macro body?
		mov	a,m
		ora	a
		jnz	nirp1		;continue if not zero
;
;	end of macro found, mark it with cr
;
		mvi	m,cr
		jmp	ipsep		;to fill the parameter name
;
;
nirp1:		;found non separator, must be comma
;
;	lhld	macnxt		;save the current position
		lhld	t11e2
		push	h		;to scan
		call	scan
		lda	accum
		cpi	','
		cnz	errs
		pop	h		;recall scanner position
;
;	shld	macnxt		;rescan beginning at following character
s05f0:		call	s11ee
		xra	a
		sta	idlen		;clear the idbuffer if activated by scan
;
ipsep:		xchg			;de holds macnxt
		lhld	reppro		;to place macnxt back into prologue
		mov	m,e
		inx	h
		mov	m,d		;saved in table, restore follow and nextc
		pop	psw
		sta	nextc
		pop	psw
		sta	idfoll
;
irpid:		;now fill the parameter
		lhld	reppro
		inx	h
		shld	sypar		;ready to fill the parameter name
		call	getpar		;loaded to the accumulator
		call	entpar		;into the symbol table
		jmp	expnext		;to expand the next repeat statement
;
;
endexp:		;terminate the macro and reclaim upper symbol table space
		call	writep		;write the endm or exitm message
		lhld	maclev		;symax at macro entry
		shld	symax		;restored to exclude macro
		call	popm		;recall previous macro level
		lda	macif		;reset conditional assembly stack
		sta	csp
		lda	nxtchr		;reset nextc
		sta	nextc
		ora	a
		cnz	putbuf		;replace the lookahead character
		jmp	scnext		;for the next input item
;
;
expnext:	;expand through the next iteration of the repeat
;
		mvi	a,srcstrt	;to kill current 'endm' line
		sta	qbp
;
;	now reset the macro scanner to the beginning of the repeat
;
		lhld	repbas
		shld	macnxt
		xra	a
		sta	nextc		;clear the lookahead character
		jmp	scnext		;for another iteration
;
;
prequ:		;utility used to print set or equ value
		push	psw		;reg <a> has '=' or '#'
		lhld	aspc		;hold temp aspc
		push	h		;in stack
		call	exp16		;get 16-bit operand
		shld	aspc		;value of expression
		call	paddr		;computed value
		pop	h		;recall real aspc
		shld	aspc		;restored
		pop	psw		;recall = or # flag
		lxi	h,pbuff+6	;line position to get char
		mov	m,a
		ret
;
;
sequ:		call	setla
		jz	sterr		;must be labeled
		mvi	a,'='		;use = to flag equ
		call	prequ		;to set value and print on line
		lhld	aspc
		push	h		;save it (again)
		lhld	evalue		;expr value
		shld	aspc
		call	filab		;set to label type and fill
		pop	h		;recover aspc
		shld	aspc
		jmp	chend
;
;
sif:		call	filab		;in case of label
		call	exp16		;get if expression
		lda	pbuff
		cpi	' '
		jnz	clrif		;skip if error
		mov	a,l		;get lsb
		rar
		mvi	a,ifcon		;scan started by if
		jnc	clrif		;clear to balancing endif when false
		call	inccon		;place into stack (possible overflow)
		jmp	chend		;check tail syntax
;
;
;	skip to eof or endif
;
smacro:		;macro definition encountered
		call	setla
		jnz	smac0		;must be a label
		call	errl		;label error
		jmp	chend		;jump to clear the line (endm gives error)
;
;
smac0:		;line was labelled, is this pass 0
		lda	pass
		ora	a
		jz	smac1
;
;	this is not pass 0, must be next in definition chain
;
		lhld	syadr
		xchg
		lhld	nextmac		;head of definition list
		call	comdh		;are they the same?
		jz	pdef
;
;	phase error, not next definition in line
;
		call	errp
		jmp	copmac		;to clear to the end of definition
;
;
pdef:		;same macro on subsequent pass
		call	getval		;pointer to next in line to define
		shld	nextmac		;we will encounter this one next
		jmp	copmac
;
;
smac1:		;this is pass 0, mark the name as a macro for subsequent processing
		mvi	a,mact
		call	setty
;
;
copmac:		;copy macro definition to symbol table if pass 0, fake it if > 0
		xra	a
		sta	npar		;number of parameters is zero
		lda	pass
		ora	a
		cz	setprn		;set number of parameters to zero
;
coppar:		;copy the parameters to symbol table
		call	scan
		lda	token
		cpi	iden
		jnz	coppar1		;clear the parameter line if no more idents
		lda	pass
		ora	a
		cz	setpar		;copy parameter to table if pass 0
		lxi	h,npar
		inr	m		;parm count incremented
		call	scan
		lda	token
		cpi	specl		;comma?
		jnz	coppar1		;copy the body of the macro if not
		lda	accum
		cpi	','
		jz	coppar		;go for another if id,
;
;	note that this allows id,id, ... ,id, as legal syntax
;
coppar1:	mvi	a,tmac		;type of macro to copy
		call	copybody	;body of macro copied, zflag if invalid
		jz	endasb		;end assembly with balance error
		lda	pass
		ora	a		;fill param count on 0
		lda	npar		;number of parameters
		cz	setprn		;set parameter count
		jmp	poend		;for end of line syntax
;
;
macent:		;return zflag if token is beginning of a macro
		cpi	pmacro
		rz
		cpi	prept
		rz
		cpi	pirp
		rz
		cpi	pirpc
		ret
;
;
copybody:	;copy the body of the macro to the symbol table, returns zflag
		;if the end of program encountered before balanced
		;register a contains the type of macro being copied
		sta	copytyp		;for later reference
;
clrpar:		;clear to the end of the line
		lda	token
		cpi	specl
		jnz	clrerrs		;syntax error
		lda	accum		;otherwise check character
		cpi	cr
		jz	copbod0
		cpi	'!'
		jz	copbod0
		cpi	eof
		rz			;[z]flag if balance error
;
clrerrs:	call	errs		;syntax error otherwise
		call	scan
		jmp	clrpar		;to clean it up
;
;
copbod0:	lhld	sypar		;next to fill - 1
		shld	macbeg		;mark beginning for ";;" backscan
;
;	turn on macro copy operation
;
		mvi	a,1
		sta	deflev		;scanner copies to symbol table til deflev=0
		call	scan		;clear the lf and dump buffer
;
;	scan for balancing endm
;
copelt:		;save symbol fill location in case token found
		lhld	sypar
		shld	prevmac
		call	scan		;for next token
		lda	token
		cpi	specl
		jnz	copb0
		lda	accum
		cpi	eof		;end of file?
		rz			;end with balance error
;
copb0:		cpi	iden		;may be endm
		jnz	copelt		;cannot be endm if not ident
		call	bget		;look for endm
		jnz	copelt		;skip if not found in tables
;
;	may be able to tokenize the item
;
		push	psw		;save the type
		lda	copytyp		;don't tokenize unless macro definition
		cpi	tmac
		jnz	coptok1		;skip unless macro def
		lda	pass
		ora	a
		jnz	coptok1		;skip if not pass 0
		lda	acclen
		dcr	a		;length 1 becomes 0 in acc
		jz	coptok1
		dcr	c		;c=1 if rz rc...jnz etc. which cannot tokenize
		jz	coptok1		;skip if one of the special cases above
;
;	ok to tokenize
;
		push	b		;save operator type for below
		lhld	prevmac		;to restore the symbol fill location
		shld	sypar		;restored to beginning position-1
		call	toknum		;token number is in register a
		call	setchr		;copied to the symbol table
		lda	nextc		;lookahead character
		ora	a		;zero?
		cnz	setchr		;load it also
		pop	b		;op type restored
;
coptok1:	pop	psw		;form restored
		cpi	pt		;pseudo type?
		jnz	copelt		;skip if not
		mov	a,b		;get operator number
		call	macent		;macro, rept, irp, or irpc?
		jnz	copb1		;skip if not
		lxi	h,deflev	;definition level
		inr	m		;incremented
		rz			;cannot nest too deeply
		jmp	copelt		;copy another element
;
;
copb1:		cpi	pendm		;end of macro?
		jnz	copelt		;skip if not
		lxi	h,deflev	;definition level
		dcr	m
		jnz	copelt		;skip if not at outer def level
		lda	copytyp		;what kind of macro is this?
		cpi	tmac		;'macro'?
		jnz	copb2		;skip linked list if not
		lxi	h,0000
		shld	sylab		;clear label indicator
;
;	if we are in a maclib, do not chain the macro
;
		lda	libinp		;should be active still
		ora	a
		jz	setlast
;
;	we are in a maclib, set value field to zero
;
		lxi	h,0000
		call	setval
		jmp	coplist
;
;
setlast:	;we are not in a maclib, so chain the macro
		;set last macro header
		lhld	lastmac
		call	setval		;place into value field
		lhld	syadr
		shld	lastmac		;lastmac now addresses this macro
;
coplist:	lda	pass
		ora	a		;is this pass 0?
		rnz			;return without filling 00 if pass > 0
;
;	set end of definition to 00
;
copb2:		lhld	sypar		;last filled character from body
		mov	a,m		;must terminate with cr
		cpi	cr
		cnz	errs
		lhld	sypar
		mvi	m,cr
		xra	a
		call	setchr		;endm <cr> 00 at end of macro
		xra	a
		inr	a		;return with non zero flag for ok indicator
		ret
;
;
sorg:		call	exp16
		lda	pbuff
		cpi	' '
		jnz	chend		;skip org if error
		lda	relflg		;rel 1 memory image?
		ora	a
		jz	sorg0		;skip if not
		lxi	d,100h		;offset by 100h
		dad	d		;to <hl>
;
sorg0:		shld	aspc		;change <pc>
		shld	fpc		;change next to fill
		call	filab		;in case of label
		call	padd
		jmp	chend
;
;
sset:		call	setla
		jz	sterr		;must be labelled
		call	getty
		ora	a		;may not have a type at this point
		jz	sset0		;skip label error if not assigned
		cpi	sett
		cnz	errl		;label error
;
sset0:		mvi	a,sett
		call	setty		;replace type with 'set'
		mvi	a,'#'		;# for set indicator
		call	prequ		;print as if equ (with #)
		call	setla		;re-address label
		lhld	evalue		;get the exp16 value (produced in prequ)
		call	setval
		lxi	h,0000
		shld	sylab		;prevent label processing
		jmp	chend
;
;
stitle:		call	filab		;handle optional label
		call	scan		;get the title
		lda	token
		cpi	strng
		jnz	sterr		;must be a string
		lda	deflev		;must be at outer level
		ora	a
		jnz	sterr
		lxi	h,acclen
		mov	c,m		;length of title
		xchg
		lhld	sytop		;next to fill
		lda	pass
		ora	a		;skip set if pass 1
		jnz	stitl2
		shld	titloc		;set title location
		dcx	h		;next to fill - 1
		shld	sypar		;next to fill in table
;
stitl0:		;get next title character
		mov	a,c
		ora	a
		jz	stitl1		;skip to end if copy complete
		inx	d
		ldax	d
		dcr	c		;next char in <a>, count decremented
		push	d
		push	b		;count and position saved
		call	setchr		;filled to symbol table
		pop	b
		pop	d
		jmp	stitl0		;for another character from accum
;
;
stitl1:		;end of copy, place 00 at end
		xra	a
		call	setchr
;
stitl2:		;end of title operation
		jmp	poend		;to scan for end of line
;
;
selse:		call	filab		;resolve label here in case error below
		call	deccon		;pop top conditional type
		cpi	ifcon		;must have beefran 'if'
		mvi	a,elcon		;mark as scan started by else
		jz	clrif		;if so, clear to the endif
;
;	out of sequence
;
		call	errb		;balance error
		jmp	poend		;end of command syntax
;
;
machead:	;return zero flag if current item is macro, irp, or irpc
		cpi	pmacro
		rz
		cpi	pirp
		rz
		cpi	pirpc
		rz
		cpi	prept
		ret
;
;
clrif:		;clear to balancing endif
		sta	ctype		;store type (ifcon,elcon) which started this
		xra	a
		sta	cnest		;nesting level is 0
		sta	mnest		;macro nesing level is 0 also
;
;	clear to end of current line
;
clrln:		lda	token
		cpi	specl		;end of line?
		jnz	clrln1
		lda	accum
		cpi	cr		;carriage return?
		jnz	clrln0
;
;	end of line by cr, scan lf to push line out
;
		call	scan
		jmp	clrlab		;clear label and test statement type
;
;
clrln0:		cpi	'!'		;multiple statements?
		jz	clrlab		;clear label and test
		cpi	eof
		jnz	clrln1		;jump if not end of file
		call	errb		;balance error - end of program encountered
		jmp	endasm		;end of current pass if so
;
;
clrln1:		call	scan		;searching for the end of the line
		jmp	clrln		;to continue scan for eol
;
;
clrlab:		;clear the label field
		call	scan
		lda	token
		cpi	numb		;skip editor numbers
		cz	scan		;scan again if number found
		lda	token
		cpi	iden		;identifier (label or pseudo op?)
		jnz	clrln		;skip to end of line if not
		call	bget		;[z] flag set if success
		jz	chkbal		;skip to chkbal if lookup ok
;
;	item not found, may be a label
;
		call	scan
		lda	token
		cpi	specl		;may be followed by ':' if so
		jnz	clrcol		;eol if not ':'
		lda	accum
		cpi	':'
		jnz	clrln
;
;	label encountered, scan to next item
;
		call	scan
;
clrcol:		lda	token
		cpi	iden
		jnz	clrln
;
;	another identifier found, is it a defined symbol?
;
		call	bget
		jnz	clrln		;eol if not defined assembler symbol
;
chkbal:		;current accumulator contents matched in tables, acc=sym#
		cpi	pt		;pseudo operator?
		jnz	clrln		;skip if not, otherwise op# is in <b>
		mov	a,b
		cpi	pif		;pseudo if?
		jnz	chkb0
;
;	if found, increment nesting level
;
		lxi	h,cnest
		inr	m
		cz	erro		;overflow if past 255
		jmp	clrln
;
;
chkb0:		cpi	pelse
		jnz	chkb1
;
;	else found, skip if nested else
;
		lda	cnest
		ora	a
		jnz	clrln
;
;	not nested, turn into true assembly, mark in stack
;
		lda	ctype
		cpi	elcon		;started by else?
		cz	errb		;balance error
		mvi	a,elcon
		call	inccon
		jmp	poend		;check command tail syntax
;
;
chkb1:		cpi	pendif
		jnz	chkb2
		lxi	h,cnest		;nesting level > 0?
		mov	a,m
		dcr	m		;cnest=cnest-1
		ora	a
		jnz	clrln		;clear to end of line
;
;	we are at the end of the scan, macro nest = 0?
;
		lda	mnest
		ora	a
		cnz	errb		;balance error
		jmp	poend
;
;
chkb2:		;check for macro entry
		call	machead
		jnz	chkb3		;skip if not macro, irp, irpc
		lxi	h,mnest		;header encountered
		inr	m		;mnest = mnest + 1
		cz	erro		;overflow if too many
		jmp	clrln		;clear the line and continue
;
;
chkb3:		;end of macro?
		cpi	pendm
		jnz	clrln
		lxi	h,mnest
		mov	a,m
		dcr	m		;mnest = mnest - 1
		ora	a		;at level 0?
		jnz	clrln
;
;	otherwise at level 0 already
;
		jmp	sendm		;to mark the end of the macro
;
;
inccon:		;increment the conditional stack, place acc on top
		mov	b,a		;save stack item
		lxi	h,csp		;stack pointer
		mov	a,m
		cpi	consiz		;at the top of the stack already?
		jnc	erro		;place overflow error in line, return
		inr	m		;csp=csp+1
		mov	e,a
		mvi	d,00		;<de>=index, compute cstack(csp)
		lxi	h,cstack
		dad	d
		mov	m,b		;stack value
		ret
;
;
deccon:		;decrement conditional stack
		lxi	h,csp		;stack pointer
		mov	a,m		;csp to accum
		ora	a		;any elements stacked?
		jz	errb		;return through errb with 'b' message
		dcr	m		;csp=csp-1
		mov	e,m		;double csp to <de>
		mvi	d,00
		lxi	h,cstack
		dad	d
		mov	a,m		;stacked value is returned in <a>
		ret
;
;
sirp:		;indefinite repeat
		mvi	a,tirp		;mark as irp for processing below
		jmp	sirpc0		;to complete the scan
;
;
sirpc:		;indefinite repeat character
		mvi	a,tirpc
;
sirpc0:		sta	copytyp		;holds tirp or tirpc
		call	filab		;to handle optional label
		call	scan		;get the identifier
		lda	token
		cpi	iden
		jnz	irperr		;statement error if not id
		lhld	sytop		;prologue address
		shld	sypro		;save it for move below
		dcx	h		;ready for next field fill
		shld	sypar
		lda	acclen
		cpi	16		;truncate?
		jc	notrunc
		mvi	a,16		;only 16 characters copied
;
notrunc:	adi	3		;past two byte next field, hc/len field
		call	setchr		;low byte filled with rel position of param
		xra	a
		call	setchr		;high byte filled with 00
		call	setpar		;parameter filled from accumulator
		call	scan
		lda	token
		cpi	specl		;must be ","
		jnz	irperr
		lda	accum
		cpi	','
		jnz	irperr
		call	scanp		;scan the parameter to accum
		lda	acclen		;may be "<>"
		ora	a
		jnz	sirc		;process if not 0 length
;
;	00 length, scan to cr
;
		call	scan
		jmp	sirzero		;to setup for null loop
;
;
sirc:		;item not length 0
		call	chkeol		;check for end of line character
		jz	sirzero
;
;	not zero, copy to prologue
;
		lxi	h,acclen
		mov	c,m		;length of accum in <c>
;
sircop:		inx	h
		mov	a,m		;next accum char
		push	b
		push	h
		call	setchr		;to prologue
		pop	h
		pop	b
		dcr	c		;count chars down
		jnz	sircop
		mvi	a,cr		;mark end of parm with cr
		call	setchr
		call	scan		;to get eol
;
sirzero:	;set the end of definition to 00
		xra	a
		call	setchr
		lhld	sytop
		shld	syadr		;mark beginning of text
		lda	copytyp		;recall tirp or tirpc
		jmp	movmac		;to copy the macro body
;
;
irperr:		call	errs		;syntax error on line
		lda	copytyp
		call	copybody	;clear the repeat
		jmp	poend		;to clear the endm
;
;
srept:		;repeat loop
		call	exp16		;16 bit expression computed
		push	h		;and saved in stack
		mov	a,l		;ready to store low byte
		lhld	sytop
		shld	sypro		;beginning of repeat list
		dcx	h		;sytop-1
		shld	sypar		;next to store-1
		call	setchr		;low value in prologue
		pop	psw		;high byte to <a>
		call	setchr		;high byte to prologue
		lhld	sytop		;base of the definition
		shld	syadr		;beginning of text
		mvi	a,trept		;mark as rept scan
;
movmac:		call	copybody	;copy the body of macro type given by reg <a>
		jz	endasb		;zero flag indicates terminal balance err
		call	writep		;force line output
		call	scan		;clear the carriage return (should leave line feed)
;
;	save the macro parameters
;
		lda	csp
		sta	macif		;conditional stack pointer
		lda	nextc
		cpi	lf		;ignore if line feed
		jnz	movsav
		xra	a		;clear the line feed
;
movsav:		sta	nxtchr		;nextc set to zero later
		call	pushm		;values are saved
		lhld	symax		;current symbol table top
		shld	maclev		;hold it here
;
;	move macro definition of type given by copytyp from sypro through
;	sypar to top of symbol table (there must be space available)
;
movb0:		;copy to top area until sypar < sypro
		lhld	sypar
		xchg
		lxi	h,sypro
		mov	a,e		;low order sypar
		sub	m		;-low order sypro
		inx	h		;to high order sypro
		mov	a,d		;high order sypar
		sbb	m		;-high order sypro
		xchg			;sypar back to <hl>
		jc	movb1		;carry if end of copy operation
;
;	more to move otherwise
;
		mov	a,m		;next to move
		dcx	h		;sypar=sypar-1
		shld	sypar		;back to memory
		lhld	symax		;next to fill+1
		dcx	h
		shld	symax
		mov	m,a		;byte is stored
		jmp	movb0		;for another byte
;
;
movb1:		;data has been moved to the top area of table
		inx	h		;<hl> addresses initial prologue
		shld	sytop		;next to fill in memory
;
;	now compute prologue and text addresses for current top area of table
;
		lhld	symax		;new top of table
		shld	reppro		;level at entry to this macro
;
;	push	h		;save it for address computations
;
		lda	copytyp		;add base address to next if irp or irpc
		cpi	trept
		jz	nobias
		mov	c,m		;low offset
		mvi	b,00		;<255, so high=00
		mov	e,l		;copy to de
		mov	d,h
		dad	b		;next absolute character position to <hl>
		xchg			;reppro to <hl>, char pos to <de>
		mov	m,e		;save low address
		inx	h
		mov	m,d		;save high address
		dcx	h		;back to reppro
;
nobias:		push	h		;save reppro for later
		lhld	syadr		;base of text area
		xchg
		lhld	sypro		;base of prologue
		mov	a,e		;compute difference to <de>
		sub	l
		mov	e,a
		mov	a,d
		sbb	h
		mov	d,a		;<de> is syadr-sypro=difference
		pop	h		;recall top area base for macro
		dad	d		;<hl> is text address
		shld	repbas		;repeat base
		lda	copytyp		;type of macro
		sta	mactyp		;for future reference
		jmp	exprept		;expand the repeat statement
;
;
saseg:		;absolute segment
		jmp	npoend
;
;
scseg:		;code segment
		jmp	npoend
;
;
sdseg:		;data segment
		jmp	npoend
;
;
sname:		;name of module
		jmp	npoend
;
;
spage:		;page
		call	filab
		call	scan		;next item may be page size
		call	chkeol
		jz	spage0		;00 means page eject
		call	opand		;get expr to <hl>
		lhld	evalue
		lda	pbuff		;error?
		cpi	' '
		jnz	chend		;skip page size if bad expr
		call	pagset		;from <hl> - sets page size
		jmp	chend
;
;
spage0:		;perform page eject
		call	writep		;writes current line
		lda	pass
		ora	a
		cnz	pagej		;page eject on pass > 0
		jmp	chend		;check end of line syntax
;
;
sexitm:		;kill current macro expansion
		jmp	sendm		;use identical code
;
;
sextrn:		;external symbols
		jmp	npoend
;
;
slocal:		;define local symbol
		lda	macsp
		ora	a
		jz	locerr		;must be in a macro
;
;	get first/next symbol to table
;
nxtloc:		call	scan
		lda	token
		cpi	iden		;must be an identifier
		jnz	locerr		;local error otherwise
		lhld	sytop		;copy to symbol table for now
		push	h
		dcx	h
		shld	sypar		;ready to copy accum temporarily
		call	setpar		;to top of symbol table
		xra	a
		sta	suppress	;no zero suppression
		inr	a		;<a>=1
		sta	acclen		;reserve 0,1
		lhld	gsymcnt		;next symbol number to generate
		inx	h
		shld	gsymcnt		;updated in memory
		shld	dvalue
		call	convdec		;convert to decimal in accum at 1
		lda	accum+1		;overflow?
		cpi	'0'
		cnz	erro		;o message if non zero
		lxi	h,'??'		;fill accum with leading ??
		shld	accum		;fills first two
		call	entdef		;enter accumulator as definition
		pop	h		;recall sytop
		shld	sytop		;restored
		dcx	h
		shld	sypar		;ready to copy parameter
		call	getpar		;copied back to accumulator
		call	entpar		;copied to parameter area
		call	scan		;delimiter?
		call	chkeol		;check end of line
		jz	chend		;end of line check
;
;	may be another local
;
		lda	token
		cpi	specl
		jnz	locerr
		lda	accum
		cpi	','		;separator?
		jz	nxtloc		;for another
;
locerr:		;error in local statement
		call	errs
		jmp	chend
;
;
sinpage:	;inpage
		jmp	npoend
;
;
smaclib:	;macro library command
		;read maclib only on the first pass
		call	filab		;in case labelled
		lhld	lastmac		;must be empty macro list
		mov	a,l
		ora	h
		jnz	maclerr
;
;	list is empty, are we already reading a .lib?
;
		lda	libinp
		ora	a
		jnz	maclerr
;
;	not in a .lib, get the macro name in pass 0
;
		call	scan
		lda	pass
		ora	a
		jnz	poend		;end of line syntax in pass 1
;
;	in pass 0, check for maclib
;
		lda	token
		cpi	iden
		jnz	maclerr
;
;	id found, clear to the end of line
;
		call	setlib		;lib file opened for input
		lda	liblst		;listing library?
		ora	a
		cnz	pagej		;to go to top of page
;
smacl0:		call	scan
		lda	token
		cpi	specl
		jnz	smacl0		;must be special character
		lda	accum		;carriage return?
		cpi	cr
		jz	smacl1
		cpi	eof
		jnz	smacl0
;
smacl1:		;end of current line (or input)
		call	writep		;write the line
		call	readlib		;start reading the input file
		jmp	scnext		;to scan the next line
;
;
maclerr:	;error in maclib command
		call	errs
		jmp	chend
;
;
spublic:	;public symbols definition
		jmp	npoend
;
;
sstkln:		;define stack size for the module
		jmp	npoend
;
;***************
;
sinclude:	;command to include a file
		call	filab		;is there a label?
		lda	incinp		;check for nested include's
		ora	a
		jnz	incerr
;
;	check if include statement valid
;
		call	scan
		lda	token
		cpi	iden
		jnz	incerr
;
;	id found, clear to end of line
;
		call	setinc		;include file opened
;
sincl0:		call	scan
		lda	token
		cpi	specl		;checks for special character
		jnz	sincl0
		lda	accum
		cpi	cr		; carriage return?
		jz	sincl1
		cpi	eof		; end of file?
		jnz	sincl0
;
sincl1:		;end of current line (or input)
		lxi	h,incinp
		mvi	m,0ffh
		call	rd$inc		;reinitialize buffer pointer
		jmp	chend
;
;
incerr:		;error in include command
		call	errs
		jmp	chend
;
;***************
;
npoend:		call	errn
;
poend:		;pseudo operator end - scan to next token
		call	scan
		jmp	chend
;
;
chkeol:		;check current token for end of line (zero flag if so)
		lda	token
		cpi	specl
		rnz
		lda	accum
		cpi	cr
		rz
		cpi	'!'
		rz
		cpi	';'
		ret
;
;
;	not a pseudo opcode, check for real opcode
;
chkot:		sui	o1		;base of opcodes
		cpi	o15		;past last opcode?
		jnc	sterr		;statement error if so
;
;	found opcode, compute index into table and jump to case
;
		mov	e,a
		mvi	d,00
		lxi	h,optab
		dad	d
		dad	d
		mov	e,m
		inx	h
		mov	h,m
		mov	l,e
		pchl			;jump to case
;
;
;	opcode categories
;
optab		dw	ssimp		;simple
		dw	slxi		;lxi
		dw	sdad		;dad
		dw	spush		;push/pop
		dw	sjmp		;jmp/call
		dw	smov		;mov
		dw	smvi		;mvi
		dw	sacci		;accum immediate
		dw	sldax		;ldax/stax
		dw	slhld		;lhld/shld/lda/sta
		dw	saccr		;accum-register
		dw	sinc		;inc/dcr
		dw	sinx		;inx/dcx
		dw	srst		;restart
		dw	sin		;in/out
;
;
ssimp:		;simple operation codes
		call	filhb		;send hex value to machine code file
		call	scan		;to next token
		jmp	incpc
;
;
slxi:		;lxi h,16b
		call	shdreg		;scan double precision register
		call	chcom		;check for comma following register
		call	setadr		;scan and emit double precision operand
		jmp	incpc
;
;
sdad:		;dad b
		call	shdreg		;scan and emit double precision register
		jmp	incpc
;
;
spush:		;push b pop d
		call	shreg		;scan single precision register to <a>
		cpi	0011$1000b	;may be <psw>
		jz	spu0
;
;	not <psw>, must be <b>,<d>, or <h>
;
		ani	0000$1000b	;low bit must be 0
		cnz	errr		;register error if not
;
spu0:		mov	a,c		;recall register and mask in case of error
		ani	0011$0000b
		ora	b		;mask in opcode for push or pop
		jmp	filinc		;fill hex value and increment pc
;
;
sjmp:		;jmp 16b/ call 16b
		call	filhb		;emit jmp or call opcode
		call	setadr		;emit 16bit operand
		jmp	incpc
;
;
smov:		;mov a,b
		call	shreg
		ora	b		;mask in opcode
		mov	b,a		;save in <b> temporarily
		call	chcom		;must be comma separator
		call	exp3		;value must be 0-7
		ora	b		;mask in opcode
		jmp	filinc
;
;
smvi:		;mvi a,8b
		call	shreg
		ora	b		;mask in opcode
		call	filhex		;emit opcode
		call	chcom		;scan comma
		call	setbyte		;emit 8-bit value
		jmp	incpc
;
;
sacci:		;adi 8b
		call	filhb		;emit immediate opcode
		call	setbyte		;emit 8-bit operand
		jmp	incpc
;
;
sldax:		;ldax b/stax d
		call	shreg
		ani	0010$1000b	;must be <b> or <d>
		cnz	errr		;register error if not
		mov	a,c		;recover register number
		ani	0001$0000b	;change to <b> or <d> if error
		ora	b		;mask in opcode
		jmp	filinc		;emit opcode
;
;
slhld:		;lhld 16b/ shld 16b/ lda 16b/ sta 16b
		call	filhb		;emit opcode
		call	setadr		;emit operand
		jmp	incpc
;
;
saccr:		;add b
		call	exp3		;right adjusted 3bit value for register
		ora	b		;mask in opcode
		jmp	filinc
;
;
sinc:		;inr b/dcr d
		call	shreg		;get register
		ora	b
		jmp	filinc
;
;
sinx:		;inx h/dcx b
		call	shreg
		ani	0000$1000b	;must be <b> <d> <m> or <sp>
		cnz	errr		;register error if not
		mov	a,c		;recover register
		ani	0011$0000b	;in case of error
		ora	b		;mask in opcode
		jmp	filinc
;
;
srst:		;restart 4
		call	shreg		;value is 0-7
		ora	b		;opcode masked
		jmp	filinc
;
;
sin:		;in 8b/out 8b
		call	filhb		;emit opcode
		call	setbyte		;emit 8-bit operand
		jmp	incpc
;
;
filinc:		;fill hex value from <a> before incrementing <pc>
		call	filhex
;
incpc:		;change assembler's pseudo program counter
		call	filab		;set any labels which occur on the line
		call	setas		;aspc=fpc
		jmp	chend		;end of line scan
;
;
;	decimal conversion subroutine (used to gen labels and immed values)
;	enter convdec below with 'dvalue' set to the 16 bit value to convert,
;	and 'suppress' set to true (i.e., non zero) if zero suppression is
;	to take place during the conversion.  the beginning position of
;	the number in the accumulator is determined by the entry value of
;	'acclen.'  upon exit, the accumulator contains the converted result
;	with acclen adjusted properly.
;
dtable		dw	10000	;high order decade for conversion
		dw	1000
		dw	100
		dw	10
		dw	1	;low order decade
;
;***************
;
;	this label is used when converting the program line numbers
;       and error count	to decimal form
;
cnv$dec:	xra	a
		inr	a
		sta	iflg
		jmp	cnvdec1
;
;
;	this label is used for all other decimal conversions
;
convdec:	xra	a
		sta	iflg
;
cnvdec1:	mvi	b,5		;number of digits to convert
		lxi	h,dtable	;conversion table
;
nxtdig:		;convert first/next digit in dvalue
		mov	e,m		;low order divisor
		inx	h
		mov	d,m		;high order divisor
		inx	h		;ready for next digit
		push	h		;save dtable address
		lhld	dvalue		;ready the dividend
		mvi	c,'0'		;count <c> up while dividing
;
dig0:		mov	a,l		;low order dividend
		sub	e		;low order divisor
		mov	l,a
		mov	a,h		;high order dividend
		sbb	d		;high order divisor
		mov	h,a		;<hl> = <hl> - decade
		jc	dig1		;carry gen'ed if too many subtracts
		inr	c		;otherwise count digit up by one
		jmp	dig0		;go for another count
;
;
dig1:		;counted down too many times
		dad	d		;add decade back
		shld	dvalue		;store current value
		lda	suppress	;zero suppression?
		ora	a
		jz	setdig		;skip tests if so
		mov	a,b		;are we on the last digit?
		dcr	a
		jz	setdig		;skip suppression if so
;
;	not ls digit
;
		mov	a,c
		cpi	'0'		;generated a zero?
		jz	nodig		;skip if so
		xra	a		;otherwise clear zero suppression
		sta	suppress
;
;***************
;
setdig:		mov	e,a		;save the a-reg
		lda	iflg		;was this a call from aio?
		ora	a
		mov	a,e
		jz	no$io		;if so, load into temp accum
;
		lxi	h,al$ptr	;place digit into temp accumulator
		mov	e,m		;since it has converted a line no.
		inr	m		;or error count
		mvi	d,0
		lxi	h,acc$ptr
		dad	d
		mov	m,c
		jmp	nodig
;
;
;	place digit into accumulator
;
no$io:		lxi	h,acclen
		mov	e,m
		inr	m		;acclen=acclen+1
		mvi	d,0		;double precision acclen in <de>
		lxi	h,accum		;ready to index
		dad	d
		mov	m,c		;digit stored
;
;***************
;
nodig:		pop	h		;recall dtable address
		dcr	b		;digit count decremented
		jnz	nxtdig		;go for another digit
		ret			;with accum filled
;
;
;	utility subroutines for operation codes
;
delim:		;check delimiter syntax for data statements
		lda	token
		cpi	specl
		cnz	errd
		lda	accum
		cpi	','
		rz
		cpi	';'
		rz
		cpi	cr
		cnz	errd
		ret
;
;
exp16:		;get 16bit value to <hl>
		push	b
		call	scan		;start scanning operand field
		call	opand
		lhld	evalue		;value to <hl>
		pop	b
		ret
;
;
exp8:		;get 8bit value to reg <a>
		call	exp16
;
adj8:		;enter here with item already scanned
		;check for high order 111's with sign bit on (neg number)
		mov	a,h		;get ms byte
		ora	a
		mov	a,l
		rz			;ok to return if all 0's
		inr	h		;255 becomes 0
		jnz	exp8e		;error in 8 bit value
;
;	high order byte is 1111$1111, sign bit on?
;
		ora	a
		rm			;return if minus set
;
exp8e:		;error in 8 bit value
		call	errv
		mov	l,a		;<a> and <l> both set to 0
		ret
;
;
exp3:		;get 3bit value to reg <a>
		call	exp8
		cpi	8
		cnc	errv		;value error if >=8
		ani	0000$0111b	;reduce if error occurs
		ret
;
;
shreg:		;get 3bit value and shift left by 3
		call	exp3
		ral
		ral
		ral
		ani	0011$1000b
		mov	c,a		;copy to <c>
		ret
;
;
shdreg:		;get double register to <a>
		call	shreg
		ani	0000$1000b	;check for <a>,<c>,<e,> or <l>
		cnz	errr		;register error
		mov	a,c		;recover register
		ani	0011$0000b	;fix it if error occurred
		ora	b		;mask opcode
		jmp	filhex		;emit it
;
;
setbyte:	;emit 16bit operand
		call	exp8
		jmp	filhex
;
;
setadr:		;emit 16bit operand
		call	exp16
		jmp	filadr
;
;
chcom:		;check for comma following expression
		push	psw
		push	b
		lda	token
		cpi	specl
		jnz	comer
;
;	special character, check for comma
;
		lda	accum
		cpi	','
		jz	comret		;return if comma found
;
comer:		;comma error
		mvi	a,'C'
		call	perr
;
comret:		pop	b
		pop	psw
		ret
;
;
chend:		;end of line check
		call	filab		;in case of a label
		lda	token
		cpi	specl
		jnz	sterr		;must be a special character
		lda	accum
		cpi	cr		;carriage return
		jnz	chen0
;
;	carriage return found, scan picks up lf and pushes line
;
		call	scan
		jmp	scnext
;
;
chen0:		;not cr, check for comment
		cpi	';'
		jnz	chen2
		call	filab		;in case labelled empty line
;
;	clear comment to end of line
;
chen1:		call	scan
		lda	token
		cpi	specl
		jnz	chen1
		lda	accum
		cpi	lf
		jz	scnext
;
chen11:		cpi	eof
		jz	endasm		;end of assembly if eof
		cpi	'!'
		jz	scnext		;logical end of line
		jmp	chen1		;none of the above
;
;
;	not cr or lf, may be logical end of line
;
chen2:		cpi	'!'
		jz	scnext
		cpi	eof
		jz	endasm
;
;	statement error in operand field
;
sterr:		call	errs		;'s'
		jmp	chen1		;to dump line
;
;
diff:		;compute <de>-<hl> to <hl>
		mov	a,e
		sub	l
		mov	l,a
		mov	a,d
		sbb	h
		mov	h,a
		ret
;
;
endasm:		;end of assembly for this pass
		lda	macsp
		ora	a		;level 0?
		jz	endas0		;skip if at 00
;
endasb:		;end with a balance error
		call	errb
;
endas0:		xra	a
		sta	deflev		;to ensure not copying to symbol tab
;
		lxi	h,pass
		mov	a,m
		inr	m		;pass number incremented
		ora	a
		jnz	prend		;process end of assembly
;
;	between passes - reverse the macros in the symbol table
;	the list is headed by lastmac (most recently defined macro)
;	and is chained through the value fields of each entry
;
		lxi	h,0ffffh	;end of list indicator (nil)
		shld	nextmac		;originally empty list
		inx	h
		shld	lcnt
		shld	errcnt
;
reverse:	lhld	lastmac		;topmost macro base
		mov	a,h
		ora	l
		jz	restart		;for the next pass
		shld	syadr		;reference base of this macro
		push	h		;save the base of this symbol
		call	getval		;pointer to previous macro in <hl>
		xthl			;saved it, base of symbol in <hl>
		push	h		;save base of symbol
		lhld	nextmac		;header of collected entries
		call	setval		;replaced in symbol table
		pop	h		;recall symbol base
		shld	nextmac		;for next time around
		pop	h		;recall pointer to previous macro
		shld	lastmac		;moving down the list to 0000
		jmp	reverse
;
;
;	at end, nextmac points up the table in order of definition
;
prend:		call	scan		;to clear last line feed
		call	padd		;write last address
		lxi	h,pbuff+5
;--------------
		mvi	m,9		;set to cr for end of message
;--------------
		lxi	h,pbuff+1
		call	pcon		;print last address
;
		lda	symlst		;listing symbols?
		ora	a
		jz	cspace		;skip dump if not
;
;	dump the symbol table at end of processing
;
		mvi	a,plabt		;dump program labels
		sta	symtyp
		call	setsym		;set up the .sym file
		call	dump
;
cspace:		;compute remaining space
		lhld	sytop
		xchg
		lhld	sybas
		call	diff		;difference to <hl>
		push	h		;sytop-sybas to stack
		lhld	symax
		xchg
		lhld	sybas
		call	diff		;symax-sybas to <hl>
		mov	e,h
		mvi	d,00		;divided by 256
		pop	h		;sytop-sybas to <hl>
		call	dive		;result to <de>
		xchg
		call	paddr		;print <hl> to pbuff
		lxi	h,pbuff+5	;message
		lxi	d,emsg		;end message
;
enda0:		ldax	d
		ora	a		;zero?
		jz	enda1
		mov	m,a
		inx	h
		inx	d
		jmp	enda0
;
;
emsg		db	'h Use factor',9,0
;
enda1:		lxi	h,pbuff+2	;beginning of ratio
		call	pcon
		lhld	epc
		shld	fpc		;end program counter
		jmp	eor
;
;
;	utility subroutines
;
comdh:		;compare <de> with <hl> for equality ([nz] flag if not equal)
		mov	a,d
		cmp	h
		rnz
		mov	a,e
		cmp	l
		ret
;
;
setas:		;aspc=fpc
		lhld	fpc
		shld	aspc
		ret
;
;
setla:		;syadr=sylab, followed by check for zero
		lhld	sylab
		shld	syadr
		call	found
		ret
;
;
filab:		;fill label value with current aspc, if label found
		call	setla
		rz			;return if no label detected
;
;	label found, must be defined on pass-1
;
		lxi	h,0000
		shld	sylab		;to mark next statement with no label
		lda	pass
		ora	a
		jnz	fil1
;
;	pass 0
;
		call	getty
		push	psw		;save a copy of type
		ani	111b		;check for undefined
		cnz	errl		;label error
		pop	psw		;restore type
		ori	plabt		;set to label type
		call	setty		;set type field
		lhld	aspc		;get current pc
		call	setval		;place into value field
		ret
;
;
fil1:		;check for defined value
		call	getty
		ani	0000$0111b
		cz	errp		;phase error
;
;	get value and compare with aspc
;
		call	getval		;to <hl>
		xchg
		lhld	aspc
		call	comdh
		cnz	errp		;phase error if not the same
		ret
;
;
filhex:		;write hex byte in register a to machine code file if pass-1
;---------------
		lxi	h,nbp
		inr	m
;---------------
		mov	b,a
;
filhb:		;fill hex buffer on pass 1 (print on pass 0 is possible)
		push	b		;save a copy of byte
		lda	pass
		ora	a		;on pass 0?
		mov	a,b		;ready for dhex
		cnz	dhex		;into hex file on pass - 1
;
;	may be completely empty line, so check address
;
filhb1:		lda	pbuff+1
		cpi	' '
		lhld	aspc
		cz	paddr		;print address field
;
		lda	nbp
		cpi	nbmax		;truncate code if too much on this line
		pop	b		;recall hex digit
		mov	a,b		;ready for whexb
;
;	room for digit on this line?
;
		cc	whexb		;write hex byte to print line
		lhld	fpc
		inx	h
		shld	fpc		;ready for next byte
		ret
;
;
filhbq:		push	b
		jmp	filhb1
;
;
filadr:		;emit double precision value from <hl>
		lda	nbp
		inr	a
		sta	nbp
		push	h		;save a copy
		mov	b,l
		call	filhb		;low byte emitted
		pop	h		;recover a copy of <hl>
		mov	b,h
		jmp	filhb		;emit high byte and return
;
;
;	utility functions for printing hex addresses and data
;
chex:		;convert to hex
		adi	'0'
		cpi	'0'+10
		rc
		adi	'A'-'0'-10
		ret
;
;
whexn:		;write hex nibble
		call	chex		;convert to ascii from hex
		lxi	h,nbp
		mov	e,m		;next position to print
		mvi	d,0		;double precision
		inr	m		;nbp=nbp+1
		lxi	h,pbuff
		dad	d
		mov	m,a		;store in print buffer
		ret
;
;
whexb:		;write hex byte to print buffer
		push	psw
		rar
		rar
		rar
		rar
		ani	0fh		;high order nibble normalize in <a>
		call	whexn		;write it
		pop	psw
		ani	0fh
		jmp	whexn		;write and return
;
;
padd:		lhld	aspc
;
paddr:		;print address field of print line from <hl>
		xchg
		lxi	h,nbp		;initialize next to fill
		push	h		;save a copy of nbp's address
		mvi	m,01
		mov	a,d		;print high byte
		push	d		;save a copy
		call	whexb
		pop	d
		mov	a,e
		call	whexb
		pop	h		;addressing nbp
		inr	m		;skip a space after address field
		ret
;
;
normchr:	;normalize character value to range 0-25 for alpha, 26=?, 27=@
		sui	'A'
		cpi	26		;a-z?
		mov	e,a		;save it in case we return
		rc			;carry gen'ed if 0-25
		adi	'A'		;restore it
		cpi	'?'
		mvi	e,26
		rz
		mvi	e,27
		ret
;
;
dump:		;dump symbol table, for symbols of type 'symtyp'
		xra	a
		sta	symcol		;clear the column count
		sta	nbp		;clear the real column count
		lhld	sybas
		shld	syadr		;start at beginning of symbol table
;
;	the alpha list is initialized to 28 nil headers
;
		lxi	h,alplist
		mvi	c,28*2		;clear the first 28 double precision elts
		xra	a
;
clrlst:		mov	m,a
		inx	h
		dcr	c		;28*2
		jnz	clrlst
;
;	alpha list is clear, now place symbols into alpha slots
;
gnsym:		;get next symbol, is syadr>sytop
		lhld	syadr
		xchg
		lhld	sytop
		mov	a,e
		sub	l
		mov	a,d
		sbb	h
		jnc	endtab		;end of tabulation into slots if so
;
;	not past end of table
;	check for item = title
;
		lhld	titloc		;location of title or 0000
		call	comdh		;syadr=titloc?
		dcx	h		;ready for title scan if so
		shld	sypar		;read sypar+1
		jz	pmacp0		;to scan to 00 at end of title
;
;	otherwise not a title, get type
;
		call	getty
		cpi	mact
		jnz	notmact		;macro, pass it by
		call	getprn		;parameter count
;
pmacp:		ora	a
		jz	pmacp0		;last parm?
		dcr	a		;parm count decremented
		push	psw
		call	getpar
		pop	psw
		jmp	pmacp		;to process another parm
;
;
pmacp0:		;look for end of string in macro or title
		call	getchr
		ora	a
		jnz	pmacp0		;continue search
;
		lhld	sypar		;addressing the 00 at end of macro
		inx	h
		jmp	setsyad
;
;
notmact:	;not a macro type
		lxi	h,symtyp
		cmp	m		;is this the one we're looking for?
		jnz	movnext		;clears this symbol if not proper type
;
;	ok to include this symbol in the current dump
;
		lhld	syadr
		shld	curadr		;for possible list insertion
		inx	h		;setup sypar to address symbol name
		shld	sypar		;ready for getpar
		call	getpar		;accumulator is filled with name
		lda	qsymlst		;listing ?? symbols?
		ora	a
		jnz	notqsym
		lda	acclen
		cpi	2
		jc	notqsym
;
;	check for ??
;
		lxi	h,accum
		mov	a,m
		cpi	'?'
		jnz	notqsym
		inx	h
		cmp	m
		jz	movnext		;?? in accum
;
notqsym:	lda	accum		;first character of name
		call	normchr		;normalized to 0-27
;
;	look at alpha list and place into proper order
;
		lxi	h,alplist
		mvi	d,00		;normalized char is in <e>
		dad	d
		dad	d		;header to proper list in <hl>
;
sort:		;compare accum with id at <hl>
		shld	lastadr		;last symbol (or header) address
		mov	e,m		;low order collision
		inx	h
		mov	d,m		;high order collision
		xchg
		shld	syadr		;next to examine
		mov	a,l		;at end of list?
		ora	h
		jz	ssort		;stop sort if so
;
;	not at end of list, <hl> and syadr address next element
;
		inx	h
		inx	h		;to type/length field
		mov	a,m		;get length-1
		ani	0fh
		inr	a
		mov	c,a		;<c> is length of symbol to compare
		lxi	d,acclen
		mov	b,m		;<b> is insert length
;
;	<b>=insert len, <c>=compare len, <de>=insert base, <hl>=compare base
;	should we insert the symbol here?
;
sort1:		inx	d		;first/next accum char address
		inx	h		;first/next compare char address
		ldax	d		;accum character to register <a>
		cmp	m		;accum char - compare char
		jc	ssort		;stop the sort if compare char >
		jnz	csort		;continue the sort if accum char <
;
;	characters are the same, move to next position
;
		dcr	b
		jz	ssort		;stop sort if run out of insert chars
		dcr	c
		jnz	sort1		;compare another pair if not done
;
;	out of compare characters, so continue the sort
;
csort:		lhld	syadr		;move past this symbol
		jmp	sort
;
;
ssort:		;we have found the proper position between lastadr and syadr
		lhld	syadr		;next in list
		xchg			;save it to store into collision field
		lhld	curadr		;current symbol (to insert)
		shld	syadr		;for movnext operation below
		mov	m,e		;fill low collision address
		inx	h
		mov	m,d		;fill high collision address
		dcx	h		;back to syadr
		xchg			;ready to set collision field at lastadr
		lhld	lastadr
		mov	m,e		;low order link
		inx	h
		mov	m,d		;high order link
;
;	element in proper position, or is being ignored on this dump
;
movnext:	lhld	syadr
		inx	h
		inx	h		;addressing type/len field
		mov	a,m
		ani	0fh
		adi	fixd+1-2	;length+1+fixed data size-inx*2
		mov	e,a		;to double precision
		mvi	d,00
		dad	d
;
setsyad:	;<hl> is new symbol address
		shld	syadr
		jmp	gnsym		;to get next symbol
;
;
endtab:		;end of symbol tabulation, alplist has order list of symbols
		lxi	h,alplist
		shld	lastadr		;holds address of headers as symbols are processed
		mvi	a,28
		sta	listcnt		;count of elements as processed
;
prsym:		;print the next symbol list
		lhld	lastadr		;last list header
		mov	e,m
		inx	h
		mov	d,m		;<de> is list of elements to process
		inx	h
		shld	lastadr		;for next time around
		xchg
		shld	syadr		;first to print
;
prsy0:		;print symbol at syadr
		lhld	syadr
		mov	a,l
		ora	h
		jz	prsy1		;skip to next header if nil
;
;	ok to print this symbol
;
		inx	h
		inx	h		;addressing type/len field
		mov	a,m
		ani	0fh		;to strip the len
		inr	a		;biased by -1
		sta	symln		;save it for later
		mov	b,a		;b is the length
		lhld	syadr
		inx	h
		inx	h		;<hl> is the type/len field
		shld	sypar		;next to get - 1
		lda	symcol		;where are we in the print line?
		ora	a
		jz	nopad
		mvi	a,tab
		call	setbuff		;tab to next symbol
		lxi	h,symcol
		mov	a,m		;adjust virtual position of line
		ani	1111$1000b
		adi	0000$1000b	;at next tab position
		mov	m,a
;
;	check for 16 char boundary alignment
;
		ani	0000$1111b	;00 if on boundary
		jz	nopad		;skip if so
		mvi	a,8		;add another 8 columns
		add	m
		mov	m,a
		mvi	a,tab
		call	setbuff		;tab to next column
;
nopad:		lda	symcol		;current virtual column
		add	b		;adds symbol length
		adi	5		;0000= part of symbol dump
		cpi	maxsycol	;past end of line?
		jc	synext
;
;	yes, dump the line
;
ldump:		lxi	h,nbp
		dcr	m		;nbp=nbp-1
		mov	e,m
		mvi	d,00
		dcx	d
		lxi	h,pbuff		;check for preceding tabs
		dad	d
		mov	a,m
		cpi	tab
		jz	ldump		;to remove another character
		lxi	h,nbp
		mov	a,m		;line size in <a>
		mvi	m,0		;cleared in memory
		sta	qbp		;end of line
		call	wobuff		;write buffer to lst file
		xra	a
		sta	symcol		;at beginning of line
;
synext:		;print the value field
		call	getval		;to <hl>
		push	h		;value saved
		mov	a,h
		call	whexb		;write low order position
		pop	h
		mov	a,l
		call	whexb		;write high order position
		mvi	a,' '
		call	setbuff		;0000(space)
		lxi	h,symcol
		mov	a,m
		adi	5		;for the 0000= part
		mov	m,a
;
;	symcol is set to the next position to fill
;
		lda	symln		;recall the length of the symbol
;
synxt0:		;has the symbol length gone to zero?
		ora	a
		jz	synxt1
		dcr	a		;no, so decrement and get another char
		push	psw
		call	getchr		;from sypar
		call	setbuff		;to pbuff
		lxi	h,symcol
		inr	m		;to next column
		pop	psw		;recall symbol length remaining
		jmp	synxt0
;
;
synxt1:		;end of symbol
		;move to next symbol in list
		lhld	syadr		;addressing collision field
		mov	e,m
		inx	h
		mov	d,m		;link is in <de>
		xchg
		shld	syadr
		jmp	prsy0
;
;
prsy1:		;end of current list, go to next in alphabet
		lxi	h,listcnt
		dcr	m
		jnz	prsym
;
;	end of symbol dump
;
		lda	nbp
		sta	qbp
		call	wobuff		;to clear the buffer
		ret
;
;
setbuff:	;utility to set the next buffer position in symbol dump
		lxi	h,nbp		;next to fill
		mov	e,m
		mvi	d,00
		inr	m		;nbp to <de>, nbp=nbp+1
		lxi	h,pbuff		;printer buffer
		dad	d		;next to fill
		mov	m,a		;stored from accum
		ret
;
;
errr:		;emit register error
		push	psw
		push	b
		mvi	a,'R'
		call	perr
		pop	b
		pop	psw
		ret
;
;
errv:		;emit value error
		push	psw
		push	h
		mvi	a,'V'
		call	perr
		pop	h
		pop	psw
		ret
;
;
errd:		push	psw
		mvi	a,'D'		;data error
		jmp	err
;
;
errp:		push	psw
		mvi	a,'P'
		jmp	err
;
;
errl:		push	psw
		mvi	a,'L'		;label error
		jmp	err
;
;
erro:		push	psw
		mvi	a,'O'		;overflow error
		jmp	err
;
;
errb:		push	psw
		mvi	a,'B'
		jmp	err
;
;
errs:		push	psw
		mvi	a,'S'
		jmp	err
;
;
errn:		push	psw
		mvi	a,'N'		;not implemented
;
err:		call	perr
		pop	psw
		ret
;
;
nparms		ds	1		;temp for counting parms in macro command
sylab		ds	2		;address of line label
sypro		ds	2		;prologue address during repeat scan
epc		ds	2		;end pc value
nbp		ds	1		;next byte position to write for machine code
ctype		ds	1		;type of pseudo op which starts false scan
cnest		ds	1		;conditional nesting level during if ... endif scan
mnest		ds	1		;macro nesting level during if ... endif scan
csp		ds	1		;conditional stack pointer
cstack		ds	consiz		;conditional stack
lastmac		ds	2		;address of previous macro definition
nextmac		ds	2		;address of next macro in line on subsequent passes
npar		ds	1		;number of parameters in macro definition
suppress	ds	1		;used in zero suppression in 'convdec'
dvalue		ds	2		;decimal conversion temporary
gsymcnt		ds	2		;generated symbol count
prevmac		ds	2		;used in call/def scanning, tokenize during mac load
;
;***************
;	local variables
iflg		ds	1
;***************
;
s11e4:		lhld	t11e2
		call	comdh
		rnz
		mvi	m,00h
		ret
;
;
s11ee:		shld	macnxt	
		mov	a,m
		cpi	0dh
		rnz
		mvi	m,00h
		ret
;
;
			end
