	title	'Imac -- token scanner, version 4.0.  27 aug 82'
;
;
	public	inits,scan,putbuf,scanp,gncz
;
;	entry points in i/o module
;
	extrn	wobuff,perr,gnc
	extrn	inisy,lookup,found,enter,setty,getty
	extrn	setval,getval,setprn,getprn,setpar
	extrn	getpar,setchr,getchr,pushm,popm,plookup
	extrn	pfound,entdef,entpar,rempar,gettxa,s20d8
	extrn	toknum,settok,pentry,pbuff
	extrn	macsp,mactyp,reppro,repbas,macnxt,nxtchr,macfol
	extrn	maclev,macflg,macif,emacstk,idbp,idfoll,idlen
	extrn	idbuff
	extrn	qbp,token,value,acclen,accum,evalue,sytop,symax
	extrn	pass,fpc,aspc,sybas,syadr,sypar,deflev,nextc
	extrn	copytyp,libinp,symlst,maclst,macbeg,titloc
;
;	entry points in symbol table module
;	(set chr is used to insert macro characters when deflev>0)
;
;	common areas for the macro processor
;
maxexp		equ	15		;top element of parallel macro stacks
macsiz		equ	maxexp+1	;size of parallel macro stacks
dmacsiz		equ	macsiz*2	;double precision mac size
;
ptsize		equ	16		;parameter hash table size
tmain		equ	0		;"type" corresponding to current macro level (main)
tmac		equ	1		;processing a macro definition
tparm		equ	2		;processing macro parameter
tirpc		equ	3		;processing irpc statement
tirp		equ	5		;processing irp statement
trept		equ	6		;processing rept statement
;
;
idmax		equ	15		;last position of id prescanner buffer
;
;	the parallel stacks for macro processing are shown in the maccom module
;
lastc		ds	1		;last character scanned
stype		ds	1		;radix indicator
;
tsypar		ds	2		;temp sypar for backup
tsyadr		ds	2		;temp syadr for local parm search
tpbp		ds	1		;temp pbp for backup
plevel		ds	1		;parameter bracket level for parm scan
rcount		ds	1		;recursion count in macro expansions
zcount		ds	1		;zero count, prevent infinite loop at end of bad macro
;
;	common equates
;
pbmax		equ	132		;max print size
srcstrt		equ	32		;start of source in output line
;
;
acmax		equ	64		;max accumulator length
;
;	global equates
;
iden		equ	1		;identifier
numb		equ	2		;number
strng		equ	3		;string
specl		equ	4		;special character
parm		equ	5		;scanning a macro parameter
comm		equ	6		;comment scan (used only locally)
;
plabt		equ	0000$0001b	;program label
dlabt		equ	0000$0010b	;data label
equt		equ	0000$0100b	;equate
sett		equ	0000$0101b	;set
mact		equ	0000$0110b	;macro
;
extt		equ	0000$1000b	;external
reft		equ	0000$1011b	;refer
glbt		equ	0000$1100b	;global
;
binv		equ	2
octv		equ	8
decv		equ	10
hexv		equ	16
cr		equ	0dh
lf		equ	0ah
eof		equ	1ah
tab		equ	09h		;tab character
;
;	utility subroutines
;
gnrc:		;get next real character from macro or input
		lda	macsp		;active macros?
		ora	a
		jz	gnc0
;
;	yes, read from topmost definition
;
		lhld	macnxt		;next to read
		mov	a,m
		ora	a		;end of parameter definition?
		jnz	gncp		;increment <hl> to next character and echo
;
;	character is zero, check for parameter complete
;
		lda	mactyp
		cpi	tparm
		jz	clrlevel	;to clear current level
		lxi	h,zcount	;have we returned too many zeroes?
		inr	m		;too many zeroes without moving scanner?
		mvi	a,0
		rnz			;continue til zcount goes to zero again
;
;	too many zeroes, print "b" error for invalid character
;
		call	errb
		call	wobuff		;write the endm (or whatever is causing the trouble)
;
;	this is (usually) a parameter, remove top element from stack
;
clrlevel:	call	popm		;not necessary to restore anything else
		lda	macfol		;id follow character
		ora	a		;is it zero?
		rnz			;return next character if not zero
		jmp	gnrc		;for another character
;
;
gncp:		inx	h		;to next character of macro
		shld	macnxt
;
;	jmp	gncz		;to set zcount
;
		jmp	s20d8
;
;
gnc0:		call	gnc
;
gncz:		;set zcount to <128 to prevent zero sequence detect
		sta	zcount		;use character value (<128)
		mov	b,a		;save character for string test
		lda	token
		cpi	strng
		mov	a,b		;back to accumulator
		rz			;don't perform case conversion in strings
;--------------
		lda	token
		cpi	comm		;check for comment
		mov	a,b
		rz
;--------------
;
;	check for lower case alpha
;
		cpi	'A' or 0110$0000b	;lower case a
		rc			;return if below lower a
		cpi	('Z' or 0110$0000b)+1	;lower case z + 1
		rnc			;no carry if greater than lower z
		ani	0101$1111b	;convert to upper case
		ret
;
;
putbuf:		;put character from register a into the printer buffer
		push	psw
		cpi	cr
		jz	pnc2
		cpi	lf		;if lf then dump current buffer
		jz	pnc2
;
;	not a cr or lf, place into buffer if there is enough room
;
		lda	qbp
		cpi	pbmax
		jnc	pnc2
;
;	enough room, place into buffer
;
		mov	e,a
		mvi	d,0		;double precision qbp in <de>
		inr	a
		sta	qbp		;incremented qbp in memory
		lxi	h,pbuff
		dad	d		;pbuff(qbp)
		pop	psw
		mov	m,a		;pbuff(qbp) = char
		ret
;
;
pnc2:		;char not placed into buffer
		pop	psw
		ret
;
;
calpha:		;is idfoll alphanumeric?
		lda	idfoll
		call	let0		;assuming <a>-register full
		rnz
		lda	idfoll
		call	num0
		ret
;
;
collect:	;collect identifier to idbuff, set idfoll to following char.
		xra	a
		sta	idlen		;clear the length
		sta	idbp		;clear next to get
		call	gnrc		;next character to a register
		sta	idfoll
		lda	token		;check for comment
		cpi	comm
		rz			;don't collect in comments
		lda	idfoll		;otherwise test it
		cpi	80h		;high order bit set
		jc	collt0		;skip if ordinary ascii char
;
;	high order bit set, fill token from tables
;
		call	settok		;<a>,<b> set to length, <hl>=.chars
		sta	idlen		;character length
		lxi	d,idbuff	;fill from idbuff
;
collt:		;collect token
		mov	a,m		;next character
		stax	d
		inx	h		;move pointers along
		inx	d
		dcr	b		;count=count-1
		jnz	collt
;
;	end of fill from token table - note that next item must not
;	be tokenized, further, if identifier found below, call to fill idfoll
;	will not produce a tokenized value (if things are working)
;
		jmp	collt1		;to fill idfoll and return
;
;
collt0:		call	let0		;letter?
		rz			;return with zero flag if not a letter
;
fillid:		call	calpha		;alphanumeric?
		jz	fillid1		;skip if not
		lxi	h,idlen		;check length of idbuff
		mov	a,m		;length to <a>
		cpi	idmax		;at end of buffer?
		jnc	fillid0		;skip to end if full
		inr	m		;idlen=idlen+1
		lxi	h,idbuff	;base of buffer
		mov	e,a		;next to fill to <de>
		mvi	d,0
		dad	d		;<hl> is psition to fill
		lda	idfoll
		mov	m,a		;character stored
;
collt1:		;enter here from tokenize above
		call	gnrc		;next character
		sta	idfoll		;following character held here
		jmp	fillid		;to check char
;
;
fillid0:	;overflow, mark as not an identifier
		xra	a
		ret
;
;
fillid1:	;id found, set non zero flag
		xra	a
		inr	a		;sets 1 in accum
		ret
;
;
parmlook:	;attempt lookup in symbol table through parm entry for current
		;id buffer.  save syadr and restore it if lookup unsuccesful
		lhld	syadr
		shld	tsyadr		;save syadr
		call	plookup		;set up syadr for the lookup
		call	pfound		;returns zero flag if not found
		rnz			;return with syadr set to parm, tsyadr has saved sy
;
;	item not found, restore syadr
;
		lhld	tsyadr
		shld	syadr
		ret
;
;
rrnc:		;read next character from macro, input, or prescanner buffer
		xra	a
		sta	rcount		;clear recursion count
;
rgnc:		;enter here on each recursive loop (without char returned)
		lxi	h,rcount	;how many times around?
		inr	m
		jnz	rgnc0		;allow 255 recursive loops without char returned
		call	erro		;user gets overflow error, clear the idbuff
		lxi	h,idlen		;zero the buffer length
		mvi	m,0
		shld	macnxt		;point to the 00 to clear macro parm
;
rgnc0:		lxi	h,idlen		;any characters being held?
		mov	a,m
		ora	a
		jz	rdch0		;check follow character for active
;
;	more characters in idbuffer
;
		dcr	m		;idlen=idlen-1
		lxi	h,idbp
		mov	e,m		;next to get
		inr	m		;idbp=idbp+1
		mvi	d,0		;double precision
		lxi	h,idbuff	;base of character buffer
		dad	d		;idbuff(idbp)
		mov	a,m
		jmp	putbuf		;to echo character to printfile
;
;
rdch0:		;idbuffer empty, are we in a macro?
		lda	macsp
		ora	a
		lda	idfoll		;follow character ready for later test
		jnz	rdch1		;skip if in a macro
;
;	not in a macro, but follow character active
;
		mov	b,a		;save it
		ora	a		;zero?
		jnz	rdch2		;send it back if non zero
		call	gnrc		;get a real character
		jmp	putbuf		;and put it in the buffer
;
;
rdch1:		;macro is active, is idfoll active?
		ora	a
		jz	coll0		;skip to collect id if not
;
;	check for up arrow, and prevent evaluation if found
;
		cpi	'^'
		jnz	chkamp		;skip to check ampersand otherwise
		call	collect		;collect next item, but don't look up
		mvi	b,'^'		;return overwritten ^
		jnz	rdch3		;we buffered something if non zero set
;
;	we have seen an ^, is it followed by &?
;
		lda	idfoll
		cpi	'&'
		jnz	rdch3		;skip to return ^ if not
;
;	it is followed by &, place & into idbuff and ignore it
;
		lxi	h,idlen
		inr	m		;idlen=1
		inx	h		;<hl> = .idbuff
		mov	m,a		;store the &
		jmp	rdch2		;clears idfoll and returns reg-<b>
;
;
chkamp:		cpi	'&'		;is it a concat?
		jz	coll1		;skip if not
;
;	not &, but may be &' (& which followed expansion)
;
		mov	b,a		;save it
		cpi	7fh		;filled at 'macsetup' below
		jz	coll2		;may be an expansion following
;
;	not & or &', return idfoll
;
rdch2:		xra	a
		sta	idfoll		;cleared in memory
;
rdch3:		mov	a,b
		jmp	putbuf		;print it and return it
;
;
coll0:		;id foll contains 00, id?
		call	collect
		jz	rgnc		;loop around to the top if id not found
		lda	idfoll		;forced expansion?
		cpi	'&'
		jz	qdum0		;may be if not in string or comment
		lda	token
		cpi	strng
		jz	rgnc		;skip substitution in string
;
;	not in string, or & followed, is this a dummy param?
;
qdum0:		call	parmlook
		jz	rgnc		;loop around to send chars back if not
;
;	parameter found, expand it
;
		jmp	macsetup
;
;
coll1:		;preceding &, expand?
		call	collect
		mvi	b,'&'		;char to return if not
		jz	rdch3		;return & if not an id
		call	parmlook
		mvi	b,'&'
		jz	rdch3		;return & if not
;
;	param found, expand it
;
		jmp	macsetup
;
;
coll2:		;preceding & caused expansion, optional expansion follows?
		call	collect
		jz	rgnc		;skip to beginning if not dummy parm
		call	parmlook
		jz	rgnc		;skip if not a dummy parm
;
;	macro parameter has been found, expand it
;
macsetup:	lxi	h,idfoll
		mov	a,m		;followed by &?
		cpi	'&'
		jnz	macset0
		mvi	a,7fh		;mark as &' for optional following dummy args
;
macset0:	mvi	m,0		;clear the idfoll character
		sta	macfol		;stacked for later use
		call	pushm		;parameters pushed
		lxi	h,mactyp
		mvi	m,tparm		;parameter macro
		lhld	symax
		shld	maclev		;save symbol table top
		call	gettxa		;base of text to scan
		shld	macnxt		;next to read
		xra	a
		sta	idlen		;clear character buffer
		lhld	tsyadr		;old syadr before parm lookup
		shld	syadr		;restored in case lower level depending upon it
;
;	the following call to collect moves ahead one token to prevent
;	infinite substitution of the same parameter
;
		call	collect
		jmp	rgnc		;for another character
;
;
inits:		;initialize the scanner
		call	zero
		sta	idlen
		sta	idfoll		;prescanner initialized
		sta	nextc		;clear next character
		sta	qbp
		mvi	a,lf		;set last char to lf
		sta	lastc
		call	wobuff		;clear buffer
		mvi	a,srcstrt	;start of print line
		sta	qbp
		ret
;
;
zero:		xra	a
		sta	acclen
		sta	stype
		ret
;
;
saver:		;store the next character into the accum and update acclen
		lxi	h,acclen
		mov	a,m
		cpi	acmax
		jc	sav1		;jump if not up to last position
		mvi	m,0
		call	erro
;
sav1:		mov	e,m		;<de> will hold index
		mvi	d,0
		inr	m		;acclen incremented
		inx	h		;address accumulator
		dad	d		;add index to accumulator
		lda	nextc		;get character
		mov	m,a		;into accumulator
		ret
;
;
tdoll:		;test for dollar sign, assuming <hl> address nextc
		mov	a,m
		cpi	'$'
;--------------
		jz	tdoll1
		cpi	'_'
		jz	tdoll1
;--------------
		rnz
;
tdoll1:		xra	a		;to get a zero
		mov	m,a		;clears nextc
		ret			;with zero flag set
;
;
numeric:	;check nextc for numeric, return zero flag if not numeric
		lda	nextc
;
num0:		;enter here from calpha to check accum
		sui	'0'
		cpi	10
;
;	carry reset if numeric
;
		ral
		ani	0000$0001b	;zero if not numeric
		ret
;
;
hex:		;return zero flag if nextc is not hexadecimal
		call	numeric
		rnz			;returns if 0-9
		lda	nextc
		sui	'A'
		cpi	6
;
;	carry set if out of range
;
		ral
		ani	0000$0001b
		ret
;
;
letter:		;return zero flag if nextc is not a letter
		lda	nextc
;
let0:		;enter here to check value of accum
		cpi	'?'
		jz	lett0
		cpi	'@'
		jz	lett0
		sui	'A'
		cpi	26
		ral
		ani	0000$0001b
		ret
;
;
lett0:		;? or @ found, return with letter = true
		ora	a
		ret
;
;
alnum:		;return zero flag if not alphanumeric
		call	letter
		rnz
		call	numeric
		ret
;
;
valid:		;check for valid character in accum
		cpi	' '		;space or larger?
		rnc			;ok if space or above
		cpi	tab		;ok if tab
		rz
		cpi	cr		;ok if cr
		rz
		cpi	lf		;ok if line feed
		rz
		cpi	eof		;end of file?
		rz
;
;	not a valid character, emit 'i' error
;
		jmp	erri		;return through error routine
;
;
gncn:		;get character and store to nextc
;
;	also copies characters to symbol table if deflev > 0
;
		call	rrnc
		call	valid		;valid character?
		sta	nextc
		lda	deflev		;macro definition level
		ora	a
		jz	gcopy		;skip copy if zero
		lda	copytyp		;what kind of definition?
		cpi	tmac
		jnz	copgnc		;copy in both passes if not macro
		lda	pass
		ora	a
		jnz	gcopy
;
;	macro in pass 0, or rept, irpc, or irp in any pass
;
copgnc:		lda	nextc
		call	setchr		;character copied to symbol table
;
gcopy:		lda	nextc
		ret
;
;
eolt:		;end of line test for comment scan
		cpi	cr
		rz
		cpi	eof
		rz
		cpi	'!'
		ret
;
;
scan:		;find next token in input stream
		call	zero
;
;	deblank
;
debl:		xra	a
		sta	token		;may have been set to "comm"
		lda	nextc
		cpi	tab		;tab character treated as blank outside string
		jz	deb0
		cpi	';'		;may be a comment
		jnz	debl0		;skip if not ";"
;
;	a ";" has been encountered, check for macro def with ";;"
;
		mvi	a,comm		;mark as comment for macro parameter scanner
		sta	token
		lda	deflev
		ora	a
		jz	deb1		;deblank normally if not
		lda	copytyp		;what kind of macro is this?
		cpi	tmac		;macro?
		jnz	copchr
;
;	copy macro characters only on pass 0
;
		lda	pass
		ora	a
		jnz	deb1		;skip operation if not pass 0
;
;	we are in a macro definition, in pass 0, is there a double ;?
;
copchr:		call	gncn
		cpi	';'		;note that both ;; will be in the table at this point
		jnz	debn		;normal end of comment scan if not ;;
;
;	we have encountered a double ;;, remove from the symbol table
;
		lhld	macbeg		;addr of sypar upon entry to def (do not pass)
		xchg			;to <de> for compare below
		lhld	sypar
		dcx	h
		dcx	h		;now addressing the character previous to the ;;
;
sback:		;scan backward for the first lf
		; or graphic character (or zero if no such characters)
		mov	a,e		;<de>=<hl>? if so, don't backup past beginning
		cmp	l
		jnz	notbeg
		mov	a,d
		cmp	h
		jz	sback0		;stop if <de>=<hl>
;
notbeg:		;not at the beginning of macro
		mov	a,m
		cpi	lf
		jnz	sbackc		;crlf is special case
		dcx	h		;backup over the lf and terminate backscan
		dcx	h		;backup over the crlf
		jmp	sback0		;<hl> address next to fill
;
;
sbackc:		cpi	' '+1		;graphic?
		jnc	sback0		;skip to end if graphic
		dcx	h		;otherwise go down one more character
		jmp	sback		;and scan one more
;
;
sback0:		;end of back scan, set sypar and sytop
		shld	sypar
		lda	deflev		;save the current definition level
		push	psw
		xra	a
		sta	deflev		;to turn off the copy operation
;
sback1:		call	gncn		;clear next character
		call	eolt		;test for end of line
		jnz	sback1		;loop til end of line
;
;	end of line encountered, set definition level and store char
;
		call	setchr		;last character is stored
		pop	psw		;definition level
		sta	deflev
		jmp	findl		;to process the end of line
;
;
debl0:		lda	nextc
		cpi	'*'		;processor tech comment
		jnz	deb2		;not *
		lda	lastc
		cpi	lf		;last line feed?
		jnz	deb2		;not lf*
;
;	comment found, remove it
;
deb1:		call	gncn
;
debn:		call	eolt		;cr, eof, or !
		jz	findl		;handle end of line
		jmp	deb1		;otherwise continue scan
;
;
deb2:		ori	' '		;may be zero
		cpi	' '
		jnz	findl
;
deb0:		call	gncn		;get next and store to nextc
		jmp	debl
;
;
;	line deblanked, find token type
;
findl:		;look for letter, decimal digit, or string quote
		xra	a		;reset token to zero if now "comm"
		sta	token
		call	letter
		jz	find0
		mvi	a,iden
		jmp	stoken
;
;
find0:		call	numeric
		jz	find1
		mvi	a,numb
		jmp	stoken
;
;
find1:		lda	nextc
		cpi	''''
		jnz	find2
		xra	a
		sta	nextc		;don't store the quote
		mvi	a,strng
		jmp	stoken
;
;
find2:		;assume it is a special character
		cpi	lf		;if lf then dump the buffer
		jnz	find3
;
;	lf found
;
		lda	macsp		;are we in a macro expansion?
		ora	a
		jz	write0		;skip "+" if not in macro
		mvi	a,'+'
		sta	pbuff+5		;marked as macro expansion
;
write0:		call	wobuff
;
write1:		;line has been written in pass 1
		lxi	h,pbuff		;clear error char on both passes
		mvi	m,' '
		mvi	a,srcstrt
		sta	qbp		;start new line
;
find3:		mvi	a,specl
;
stoken:		sta	token
;
;	loop while current item is accumulating
;
sctok:		lda	nextc
		sta	lastc		;save last character
		ora	a
		cnz	saver		;store character into accum if not zero
		call	gncn		;get next to nextc
		lda	token
		cpi	specl
		jnz	sct1		;skip if not a special character
;
;	if we are copying a macro, don't convert relationals
;
		lda	deflev
		ora	a
		rnz			;return with special character if deflev>0
		lda	accum		;check relationals
;
;	may be < (lt), <= (le), = (eq), >= (ge), or > (gt)
;
		cpi	'='
		jnz	bool0
;
;	= encountered, change to eq
;
		lxi	h,'EQ'
		jmp	boolc1
;
;
bool0:		;not =
		cpi	'<'
		jnz	bool1
;
;	< encountered, <=?
;
		lxi	h,'LT'
		lda	nextc
		cpi	'='
		jnz	boolc1
;
;	<= change to le
;
		lxi	h,'LE'
		jmp	boolc2
;
;
bool1:		cpi	'>'
		rnz			;return if not relational
		lxi	h,'GT'
		lda	nextc
		cpi	'='
		jnz	boolc1
;
;	this is >=
;
		lxi	h,'GE'
;
boolc2:		;relational set in <hl>, clear nextc
		xra	a
		sta	nextc
;
boolc1:		;relational set in <hl>, don't clear nextc
		shld	accum		;fill first two characters
		lxi	h,acclen
		inr	m		;acclen=2
		mvi	a,iden
		sta	token		;changed to identifier
		ret
;
;
sct1:		;not a special character
		lxi	h,nextc
		lda	token
;
		cpi	iden
		jnz	sct2
;
;	accumulating an identifier
;
		call	tdoll		;$?
		jz	sctok		;if so, skip it
		call	alnum		;alpha numeric?
		jnz	sctok		;accumulate another if alphanumeric
		ret			;with identifier set
;
;
sct2:		;not special or ident, check number
		cpi	numb
		jnz	sct3
;
;	accumulating a number, check for $
;
		call	tdoll
		jz	sctok		;skip if found
		call	hex		;hex character?
		jnz	sctok		;store it if found
;
;	end of number, look for radix indicator
;
		lda	nextc
		cpi	'O'		;octal indicator
		jz	noct
		cpi	'Q'		;octal indicator
		jnz	num2
;
noct:		;octal
		mvi	a,octv
		jmp	sstyp
;
;
num2:		cpi	'H'
		jnz	num3
		mvi	a,hexv
;
sstyp:		sta	stype
		xra	a
		sta	nextc		;clears the lookahead character
		jmp	ncon
;
;
;	radix must come from accum
;
num3:		lda	lastc
		cpi	'B'
		jnz	num4
		mvi	a,binv
		jmp	ssty1
;
;
num4:		cpi	'D'
		mvi	a,decv
		jnz	ssty2
;
ssty1:		lxi	h,acclen
		dcr	m		;acclen decremented to remove radix indicator
ssty2:		sta	stype
;
ncon:		;numeric conversion occurs here
		lxi	h,0
		shld	value		;value accumulates binary equivalent
		lxi	h,acclen
		mov	c,m		;<c>=acclen
		inx	h		;addresses accum
;
clop:		;next digit is processed here
		mov	a,m
		inx	h		;ready for next loop
		cpi	'A'
		jnc	clop1		;not hex a-f
		sui	'0'		;normalize
		jmp	clop2
;
;
clop1:		;hex a-f
		sui	'A'-10
;
clop2:		;check size against radix
		push	h		;save accum addr
		push	b		;save current position
		mov	c,a
		lxi	h,stype
		cmp	m
		cnc	errv		;value error if digit>=radix
		mvi	b,0		;double precision digit
		mov	a,m		;radix to accumulator
		lhld	value
		xchg			;value to <de> - accumulate result in <hl>
		lxi	h,0		;zero accumulator
;
clop3:		;loop until radix goes to zero
		ora	a
		jz	clop4
		rar			;test lsb
		jnc	ttwo		;skip summing operation if lsb=0
		dad	d		;add in value
;
ttwo:		;multiply value * 2 for shl operation
		xchg
		dad	h
		xchg
		jmp	clop3
;
;
clop4:		;end of number conversion
		dad	b		;digit added in
		shld	value
		pop	b
		pop	h
		dcr	c		;more digits?
		jnz	clop
		ret			;done with the number
;
;
sct3:		;must be a string
		lda	nextc
		cpi	cr		;end of line?
		jz	erro		;and return
		cpi	''''
		jnz	sctok
		call	gncn
		cpi	''''
		rnz			;return if single quote encountered
		jmp	sctok		;otherwise treat as one quote
;
;
;	subroutines for the macro parameter scanner
;
pdebc:		;parameter deblank character in nextc?
		lda	nextc
		ora	a		;zero is ignored
		rz
		cpi	' '		;blanks are ignored
		rz
		cpi	tab		;leading tabs are ignored
		ret			;deblank char if zero flag set
;
;
ptypc:		;parameter type character (leading char is end line or %)?
		lda	nextc
		cpi	','		;comma from next parameter?
		rz
		cpi	';'		;beginning of comment?
		rz
		cpi	'%'		;evaluated parameter?
		rz
;
peolc:		;enter here for end of line character test
		lda	nextc
		cpi	cr
		rz			;end of line by carriage return?
		cpi	eof		;end of physical input
		rz
		cpi	'!'
		ret
;
;
peopc:		;test for end of parameter character
		lda	nextc
		cpi	';'
		rz
		cpi	' '
		rz
		cpi	tab
		rz
		cpi	','
		ret
;
;
scanp:		;scan next macro parameter
		call	zero		;clear accumulator
		xra	a
		sta	token
		sta	plevel		;clear bracket level counter
;
pdeblank:	;deblank the beginning of the parameter
		call	pdebc		;deblank character?
		jnz	partype
		call	gncn		;get another for beginning of parm
		jmp	pdeblank
;
;
partype:	;determine the parameter type
		call	ptypc		;is this a null parm or %?
		jnz	scnloop		;skip to scan loop if not
		mvi	a,specl		;return with a special character if so
		sta	token
		jmp	savchar		;stores the character and returns
;
;
readloop:	;enter here from bottom of loop to get next character
		lda	nextc
		sta	lastc
		call	gncn		;another character to nextc
		lda	token		;stop if marked as special character
		cpi	specl
		rz
;
;	otherwise not a special character, check for end of line
;
scnloop:	call	peolc		;end of line character?
		jnz	noteol
;
;	parameter end of line encountered
;
		lda	token		;are we in the middle of a string?
		cpi	strng
		cz	errv		;value error if so
		lda	plevel		;are we in a bracketed expression
		ora	a
		cnz	errv		;value error if so
		jmp	retscanp
;
;
noteol:		;not the end of line, are we in a string?
		lda	token
		cpi	strng
		jnz	notstr
;
;	string is being processed
;
		lda	nextc
		cpi	''''		;end of string?
		jnz	savchar		;store it if not
;
;	unconditionally save this quote
;
		call	saver
		call	gncn		;it was a quote, followed by another?
		lda	nextc
		cpi	''''
		jz	readloop	;skip the second quote if it occurs
;
;	end of current string, clear token for remainder of scan
;
		xra	a
		sta	token
;
;	the current character has not yet been processed
;
		jmp	scnloop		;may be end of line, etc.
;
;
notstr:		;not currently scanning a string, are we starting one?
		lda	nextc
		cpi	''''
		jnz	notsstr
;
;	yes, a string is starting here
;
		mvi	a,strng
		sta	token		;to mark as string scan
		jmp	savchar		;to place in accumulator
;
;
notsstr:	;not the start of a string, escape character?
		cpi	'^'
		jnz	notesc
;
;	it is an escape character, read and store the next char
;
		call	gncn
		lda	nextc
		cpi	tab		;tab is allowed
		jz	savchar
		cpi	' '		;must be graphic then
		jnc	savchar
;
;	not a graphic character
;
		call	erri		;invalid character error
		jmp	retscanp
;
;
notesc:		;not an escape character, open bracket?
		cpi	'<'
		jnz	notlbrak
;
;	left bracket encountered, check level
;
		lxi	h,plevel
		mov	a,m		;current level to <a>
		inr	m		;plevel=plevel+1
		ora	a		;were we previously at level zero?
		jz	readloop	;skip the character if so
		jmp	savchar		;otherwise save the open bracket
;
;
notlbrak:	;not a left bracket, is it a closing bracket?
		cpi	'>'
		jnz	notrbrak
;
;	right bracket found, decrement plevel if possible
;
		lxi	h,plevel
		mov	a,m
		ora	a
		jz	savchar		;save if the bracket count is unbal to the right
		dcr	m		;plevel=plevel-1
		jz	readloop	;don't store the character if outer level
		jmp	savchar
;
;
notrbrak:	;not a right bracket, is plevel > 0?
		lda	plevel
		ora	a
		jnz	savchar		;if it is, don't look for delimiters
;
;	plevel is 0, so check for end of parameter
;
		call	peopc		;end of parameter character?
		jz	retscanp
;
;	not the end, so save the current character
;
savchar:	call	saver
		jmp	readloop	;for another characer
;
;
retscanp:	;return from scanp with token set to parm
		mvi	a,parm
		sta	token
		ret
;
;
;	end of scanner
;
;	error message routines
;
errv:		;'v' value error
		push	psw
		mvi	a,'V'
		jmp	err
;
;
erro:		;'o' overflow error
		push	psw
		mvi	a,'O'
		jmp	err
;
;
erri:		;'i' invalid character error
		push	psw
		mvi	a,'I'
		jmp	err
;
;
errb:		;'b' balance error for macros which don't terminate (00..00)
		push	psw
		mvi	a,'B'
		jmp	err
;
;
err:		;print error message
		push	b
		push	h
		call	perr
		pop	h
		pop	b
		pop	psw
		ret
;
;
		end
