	title	'CCS system generation routine version 1.0'
;
;	this routine will transfer the system tracks from one
; diskette to another, regardless of diskette size, density, or
; sector size.  if double density diskettes are used, a 4 mhz
; cpu is mandatory.  should the system tracks of the destination
; disk have less space than the source disk, a warning is issued
; to advise the operator that a potential data loss may happen.
;
;	operation of the routine is identical to the cp/m sysgen
; routine, as documented in the cp/m user's guide.  this includes
; using the residual memory image of a movcpm run.  the undocumented
; sysgen capability of reading in a new source file from disk is also
; supported.
;
;
bdosv	equ	5		;bdos vector address
stack	equ	80h		;top of stack location
;
dstat	equ	30h		;disk status port
dcmmd	equ	30h		;disk command port
dtrck	equ	31h		;disk track port
dsctr	equ	32h		;disk sector port
ddata	equ	33h		;disk data port
dflag	equ	34h		;disk flag port
dcntl	equ	34h		;disk control port
bctrl	equ	4		;board control port
sde	equ	43h		;save loc of side select
;
;
	org	100h		;origin of this program
;
;
ccsys:	lxi	sp,stack	;set the stack
	di
	in	bctrl		;save the entry status of the 1793
	ani	2
	mvi	a,20h		;assume mini for the moment
	jnz	ccsys1		;jump if it is a mini
	mvi	a,30h		;  else, set for 8"
;
ccsys1:	mov	b,a		;save for a moment
	in	bctrl		;now find the density
	ani	20h
	ral
	ora	b		;add it on to the partial selbits
	mov	b,a
	in	dcntl		;now see which drive was up
	rar
	ani	0fh
	ora	b		;add the drive select onto the selbits
	sta	selsv		;save for later restoral
	in	dtrck		;save the track register on entry
	sta	trksv
	lxi	h,buffer+1a00h	;set default buffer limit
	shld	lim
	lxi	h,logmsg	;log onto the system
	call	prmsg
;
sourc:	lxi	h,srmsg		;ask for source drive
	call	prtrd
	jz	dest0		;jump if source is in memory
	sta	drive		;put into error message
	sta	unit
	ani	5fh		;convert to upper case
	mov	b,a		;save response
	sui	'A'		;see if valid drive
	jc	sourc		;no, ask again
	cpi	4
	jnc	sourc		;no, ask again
	call	setdrv		;see what is out there
	lda	2		;see if enough memory exists
	sui	16h		; less cp/m space
	sbi	endmem/256	; less room for this program
	jc	noroom		;jump if not enough room
	lxi	h,smsg		;verify source
	call	prtrd
	jnz	rtcpm		;quit if not carriage return
	call	crlf
	lxi	h,100h		;set track 0, sector 1
	shld	track
	lxi	h,buffer	;set the dma address
	shld	dmaad
;
sourc2:	call	read		;read a sector
	ora	a		;check for errors
	jnz	error
	shld	dmaad		;update the dma address
	lda	sector		;go to next sector
	lxi	h,spt		;point to sector per track hold
	cmp	m		;see if last sector on this track
	jc	sourc5		;jump if not
	lda	track		;else, update track pointer
	inr	a
	cpi	2		;must always read two tracks
	jc	sourc3
	cpi	3		;never read more than three tracks
	jnc	dest		;jump if done
	mov	b,a		;save track count
	lda	diskno		;see if mini
	ani	10h
	jnz	dest		;done if 8" disk
	mov	a,b		;reget track count
;
sourc3:	sta	track		;finish the track update
	lda	idsv+3		;get sector size indicator
	xchg			;save pointer
	mov	b,a		;save size indicator
	lxi	h,sptbl-1	;8" sector count table address
	lda	diskno		;see if mini
	ani	10h
	jnz	sourc4		;jump if 8"
	lxi	h,msptbl-1	;mini sector per track table address
;
sourc4:	inx	h		;point to right entry
	dcr	b
	jp	sourc4
	lda	diskno		;see if dden
	ani	40h
	jz	sourc6		;jump if not
	dcx	h		;  else, adjust pointer
;
sourc6:	mov	a,m
	stax	d		;reset the sector per track count
	xra	a		;get a zero
;
sourc5:	inr	a		;increment sector count
	sta	sector
	jmp	sourc2		;go get next sector
;
;
dest:	lhld	dmaad		;save upper limit for check
	shld	lim
;
dest0:	lxi	h,dstmsg	;ask for dest drive
	call	prtrd
	jz	rtcpm		;done if carriage return
 	sta	drive		;put into error message
	sta	unit
	ani	5fh		;convert to upper case
	mov	b,a		;save response
	sui	'A'		;see if valid drive
	jc	dest0		;no, ask again
	cpi	4
	jnc	dest0		;no, ask again
	call	setdrv		;see what is out there
	lxi	h,dmsg		;verify destination
	call	prmsg
	lxi	h,comsg
	call	prtrd
	jnz	rtcpm		;quit if not carriage return
	call	crlf
	lxi	h,100h		;set track 0, sector 1
	shld	track
	lxi	h,buffer	;set the dma address
	shld	dmaad
;
dest2:	call	write		;write a sector
	ora	a		;check for errors
	jnz	error
	shld	dmaad		;update the dma address
	lda	sector		;go to next sector
	lxi	h,spt		;point to sector per track hold
	cmp	m		;see if last sector on this track
	jc	dest5		;jump if not
	lda	track		;else, update track pointer
	inr	a
	cpi	2		;must always write two tracks
 	jc	dest3
	cpi	3		;never write more than three tracks
	jnc	check		;jump if done
	mov	b,a		;save track count
	lda	diskno		;see if mini
	ani	10h
	jnz	check		;done if 8" disk
	mov	a,b		;reget track count
;
dest3:	sta	track		;finish the track update
	lda	idsv+3		;get sector size indicator
	xchg			;save pointer
	mov	b,a		;save size indicator
	lxi	h,sptbl-1	;8" sector count table address
	lda	diskno		;see if mini
	ani	10h
	jnz	dest4		;jump if 8"
	lxi	h,msptbl-1	;mini sector per track table address
;
dest4:	inx	h		;point to right entry
	dcr	b
	jp	dest4
	lda	diskno		;see if dden
	ani	40h
	jz	dest6		;jump if not
	dcx	h		; else, adjust pointer
;
dest6:	mov	a,m
	stax	d		;reset the sector per track count
	xra	a		;get a zero
;
dest5:	inr	a		;increment sector count
	sta	sector
	jmp	dest2		;go get next sector
;
;
check:	lhld	lim		;lwa of write buffer
	xchg
	lhld	dmaad		;lwa of source buffer
	mov	a,l		;check for lost data
	sub	e
	mov	a,h
	sbb	d
	jp	dest		;check is o.k.
	lxi	h,wrmsg		;warning message address
	call	prmsg
	jmp	dest
;
;
wrmsg	db	0dh,0ah,'***WARNING: Possible lost data***',0dh,0ah,0
;
lim	ds	2
;
error:	lxi	h,ermsg
	call	prmsg
	jmp	dest
;
;
ermsg	db	0dh,0ah,'Disk I/O error on '
;
drive	ds	1
	db	':',0dh,0ah,0
;
setdrv:	mov	b,a		;save the unit
	inr	b		;set up for loop control
	xra	a
	sta	lunit		;reset last unit
	stc
;
set1:	ral			;shift the select bit into position
	dcr	b
	jnz	set1
	ori	20h		;add on the motor on bit
	sta	diskno		;save in case of 5" drive
	mov	b,a
	out	dcntl		;select the drive
;
set3:	mvi	a,0bh		;get a restore command
	sta	cmdsv		;do it
	out	dcmmd
;
set4:	in	dflag		;wait for intrq
	rar
	jnc	set4
	in	dstat
	sta	cstat
	in	ddata		;clear junk out of register
	lxi	h,312h		;mini step rate, track 0 spt
	shld	spt		;save them
	in	bctrl		;see if mini is out there
	rar
	rnc			;return if so
	lxi	h,212h		;else, set 8" step rate, spt
	shld	spt
	mvi	a,10h		;and set the 8" select bit
	ora	b
	sta	diskno		;save the select bits
	out	dcntl		;set corrected selbits
	mvi	a,0d0h		;set side 0
	out	bctrl
	mvi	a,8
;
set2:	dcr	a
	jnz	set2
	in	dstat		;see if drive is ready
	ora	a
	rp
;
notrdy:	lxi	h,rdymsg
	call	prtrd		;tell it is not ready
	rz			;cr returned, try again
	jmp	rtcpm		;done if anything else
;
;
rdymsg	db	0dh,0ah,'drive NOT ready (type <CR> when ready).',0ah
	db	0
;
;
eoja:	lda	stprat		;get the step rate bits
	ora	c		;add on the command
	out	dcmmd		;do the command
	sta	cmdsv		;save for audit trail
;
eoj:	in	dflag		;disk flag port
	rar
 	jnc	eoj
	in	dstat		;get the disk status
	sta	cstat		;save it
	ret
;
;
read:	mvi	c,10		;number of retries
;
rdagn:	push	b
	call	seek
	jnz	read3
	out	dcmmd		;disk command port
;
read1:	in	ddata		;disk data port
	mov	m,a
	inx	h
	in	ddata		;disk data port
	mov	m,a
	inx	h
	in	ddata		;disk data port
	mov	m,a
	inx	h
	in	ddata		;disk data port
	mov	m,a
	inx	h
	dcr	b
	jnz	read1
	call	eoj
	ani	9ch
;
read3:	pop	b
	rz
	dcr	c
	jnz	rdagn
	mvi	a,1		;read error
	ret
;
;
write:	mvi	c,10		;number of retries
;
wragn:	push	b
	call	seek
 	jnz	wrt3
	adi	20h		;add write command
	sta	cmdsv
	out	dcmmd		;disk command port
;
wrt1:	mov	a,m
	out	ddata		;disk data port
	inx	h
	mov	a,m
	out	ddata		;disk data port
	inx	h
	mov	a,m
	out	ddata		;disk data port
	inx	h
	mov	a,m
	out	ddata		;disk data port
	inx	h
	dcr	b
	jnz	wrt1
	call	eoj
	ani	0fch
;
wrt3:	pop	b
	jz	verfy
	dcr	c
	jnz	wragn
	mvi	a,1		;write error
	ret
;
;
verfy:	mvi	c,10		;10 trys
;
verfy0:	push	b		;save the try counter
	call	rdwrt
	mvi	e,0		;start the checksum
	out	dcmmd		;disk command port
;
verfy1:	in	ddata		;disk data port
	xra	m
	ora	e
	mov	e,a
	inx	h
	in	ddata		;disk data port
	xra	m
	ora	e
	mov	e,a
	inx	h
	in	ddata		;disk data port
	xra	m
	ora	e
	mov	e,a
	inx	h
	in	ddata		;disk data port
	xra	m
	ora	e
	mov	e,a
	inx	h
	dcr	b
	jnz	verfy1
	call	eoj
	ani	9ch
	pop	b		;set stack straight
	ora	e		;add on the checksum
	rz
	dcr	c		;see if more trys left
	jnz	verfy0		;jump if so
	mvi	a,1		;verify error
	ret
;
;
seek:	lda	diskno
	mov	c,a		;save for later use
	lda	lunit		;see if same as last used drive
	cmp	c
	jz	seek1		;jump if so
;
idrd1:	mov	a,c		;reget the select byte
	out	dcntl		;output it
 	in	dstat		;insure a drive is there
	ani	80h
	rnz			;error if not
	lxi	h,idsv		;set up to read address
	mvi	b,3
	mov	a,c		;get the select bits
	ori	80h		;set the autowait bit
	out	dcntl		;select the drive
	mvi	a,0c4h		;read address command
	sta	cmdsv
	out	dcmmd		;start it going
;
idrd3:	in	ddata		;get the data
	mov	m,a		;store it
	inx	h
	in	ddata		;get the data
	mov	m,a		;store it
	inx	h
	dcr	b
	jnz	idrd3		;jump if more to go
	call	eoj
	ani	0fch		;mask the error bits
	jz	idrd4		;jump if no error
	mov	a,c		;else, see if dden tried yet
	ani	40h
	rnz			;take error if dden tried
	mvi	a,40h		;else, try dden
	ora	c
	mov	c,a
	sta	diskno		;save for later use
	jmp	idrd1
;
;
idrd4:	lda	idsv		;get the track number
	out	dtrck		;set the track register
	ora	a		;insure not on track 0
 	mov	a,c		;reget the select byte
	sta	lunit		;update last used unit
	jnz	seek1		;jump if okay
	push	b		;save the select bits
	mvi	c,58h		;build a step-in command
	call	eoja
	pop	b		;restore the select bits
	jmp	idrd1		;go reread the address
;
;
seek1:	out	dcntl		;disk control port
	lda	sector
	out	dsctr		;disk sector port
	in	dtrck		;disk track port
	mov	c,a		;save it
	lda	track		;get desired track
	cmp	c
	jz	rdwrt		;jump if no seek needed
	out	ddata		;set the seek track
	mvi	c,1ch		;build the seek command
	call	eoja
	ani	98h
	rnz			;error return
;
rdwrt:	lxi	h,10h		;build sector byte count
;	in	dtrck		;check for track 00
;	ora	a
;	jz	rdwrt0		;jump if so
	lda	idsv+3		;get sector size
;
rdwrt0:	dad	h		;double (h,l)
	dcr	a		;loop control
	jp	rdwrt0
	mov	b,l		;sector byte count to (b,c)
	lhld	dmaad
	in	dflag		;disk flag port
 	ani	20h
	mvi	a,4
	jz	rdwrt1
	xra	a
;
rdwrt1:	adi	88h
	mov	e,a
	lda	diskno
	ori	80h
	mov	d,a
;	in	dtrck		;see if track 0
;	ora	a
	mov	a,d
;	jnz	rdwrt2		;jump if not
;	ani	0bfh		; else, insure dden bit not set
;
rdwrt2:	out	dcntl		;disk control port
	xra	a		;clear the flags
	mov	a,e
	sta	cmdsv		;save the command
	ret
;
;
prtrd:	call	prmsg		;first, print the message
	mvi	c,1
	call	bdosv		;get a character
	push	psw		;save it
	call	crlf		;print a cr,lf
	pop	psw
	cpi	0dh		;see if done
	ret
;
;
noroom:	lxi	h,szmsg
	call	prmsg
;
rtcpm:	lda	selsv		;restore the selected drive
	out	dcntl
	lda	sde		;and the selected side
	out	bctrl
	lda	trksv		;restore the track register
	out	dtrck
	mvi	c,0dh
	call	bdosv
	ei
	call	0
	hlt			;error halt if return
;
;
crlf:	mvi	a,0dh
	call	pchar
	mvi	a,0ah
;
pchar:	push	h		;save registers
	push	d
	push	b
	mov	e,a
	mvi	d,0
	mvi	c,2		;bdos print char call
	call	bdosv
	pop	b
	pop	d
	pop	h
	ret
;
;
prmsg:	mov	a,m
	ora	a
	rz
	call	pchar
	inx	h
	jmp	prmsg
;
;
logmsg	db	0dh,0ah,'CCS sysgen program vers-1.0',0dh,0ah,0
szmsg	db	0dh,0ah,'Insufficient memory space - need 24k',0dh,0ah,0
srmsg	db	0dh,0ah,'Source drive: ',0
dstmsg	db	0dh,0ah,'Destination drive: ',0
smsg	db	'Source'
comsg	db	' on '
unit	ds	1
	db	':, then type return',0
dmsg	db	'Destination',0
;
sptbl	db	18,18,18,18
msptbl	db	18,18,18,18
;sptbl	db	26,15,8,4	;8" sectors per track
;msptbl	db	18,10,5,2	;5" sectors per track
;
track	ds	1
sector	ds	1
dmaad	ds	2		;direct memory address
diskno	ds	1		;disk number 0-15
lunit	ds	1		;last used drive
spt	ds	1		;sectors per track
stprat	ds	1		;step rate save area
cmdsv	ds	1		;command save area
cstat	ds	1		;current status save area
idsv	ds	6		;disk id save area
selsv	ds	1		;selbits save area
trksv	ds	1		;save area for track register
;
;
	org	900h		;buffer start point
;
buffer	ds	12544		;max size for dden
;
endmem	equ	$
;
;
		end
