	title	'C1-SYSGEN - SYStem GENeration Program.  01 jun 83'
;
;	system generation program, C1-board version
;
vers		equ	10	;x.x
;
;	Portions Copyright (C) Digital Research
;	1976, 1977, 1978, 1979.
;
;	Portions Copyright (C) 1983, V. Nadvornik
;
nsects		equ	40	;no. of sectors per track
ntrks		equ	2	;no. of operating system tracks
ndisks		equ	4	;number of disk drives
hardno		equ	'H'-'0'
;
secsiz		equ	128	;size of each sector
log2sec		equ	7	;log 2 secsiz
skew		equ	1	;sector skew factor
;
fcb		equ	005ch	;default fcb location
fcbcr		equ	fcb+32	;current record location
tpa		equ	0100h	;transient program area
loadp		equ	900h	;load point for system during load/store
bdos		equ	5h	;dos entry point
boot		equ	0	;jmp to 'boot' to reboot system
coni		equ	1	;console input function
cono		equ	2	;console output function
self		equ	14	;select disk
openf		equ	15	;disk open function
dreadf		equ	20	;disk read function
;
maxtry		equ	10	;maximum number of retries on each read/write
cr		equ	0dh	;carriage return
lf		equ	0ah	;line feed
stacksize	equ	16	;size of local stack
;
wboot		equ	1	;address of warm boot (other patch entry
				;points are computed relative to wboot)
seldsk		equ	24	;wboot+24 for disk select
settrk		equ	27	;wboot+27 for set track function
setsec		equ	30	;wboot+30 for set sector function
setdma		equ	33	;wboot+33 for set dma address
readf		equ	36	;wboot+36 for read function
writf		equ	39	;wboot+39 for write function
;
	org	tpa		;transient program area
;
	jmp	start
	db	'Copyright (C) 1978, Digital Research '
	db	' and V. Nadvornik.'
;
;	translate table - sector numbers are translated
;	here to decrease the sysgen time for missed sectors
;	when slow controllers are involved.  translation takes
;	place according to the "skew" factor set above.
;
ost	db	ntrks		;operating system tracks
spt	db	nsects		;sectors per track (can be patched)
;
tran	equ	$		;base of translate table
trelt	set	1		;first/next tran element
trbase	set	1		;base for wraparound
	rept	nsects		;;once for each sector on a track
	db	trelt		;;generate first/next sector
trelt	set	trelt+skew
	if	trelt gt nsects
trbase	set	trbase+1
trelt	set	trbase
	endif
	endm
;
;	now leave space for extensions to translate table
;
	if	nsects lt 64
	rept	64-nsects
	db	0
	endm
	endif
;
;	utility subroutines
;
multsec:	;multiply the sector number in a by the sector size
	mov	l,a
	mvi	h,0		;sector number in hl
	rept log2sec		;log 2 of sector size
	dad	h
	endm
	ret			;with hl = sector * sector size
;
getchar:	;read console character to register a
	mvi	c,coni
	call	bdos
;
;	convert to upper case before return
;
	cpi	'a'
	rc			;return if below lower case a
	cpi	'z' + 1
	rnc			;return if above lower case z
	ani	5fh
	ret
;
putchar:	;write character from a to console
	mov	e,a
	mvi	c,cono
	call	bdos
	ret
;
crlf:		;send carriage return, line feed
	mvi	a,cr
	call	putchar
	mvi	a,lf
	call	putchar
	ret
;
crmsg:		;print message addressed by <hl> til zero
		;with leading crlf
	push	h
	call	crlf
	pop	h		;drop thru to outmsg
;
outmsg:	mov	a,m
	ora	a
	rz
;
;	message not yet completed
;
	push	h
	call	putchar
	pop	h
	inx	h
	jmp	outmsg
;
sel:		;select disk given by register a
	mov	c,a
	lhld	wboot
	lxi	d,seldsk
	dad	d
	pchl
;
trk:		;set up track
	lhld	wboot		;address of boot entry
	lxi	d,settrk	;offset for settrk entry
	dad	d
	pchl			;gone to settrk
;
sec:		;set up sector number
	lhld	wboot
	lxi	d,setsec
	dad	d
	pchl
;
dma:		;set dma address to value of <bc>
	lhld	wboot
	lxi	d,setdma
	dad	d
	pchl
;
read:		;perform read operation
	lhld	wboot
	lxi	d,readf
	dad	d
	pchl
;
write:		;perform write operaton
	lhld	wboot
	lxi	d,writf
	dad	d
	pchl
;
dread:		;disk read function
	mvi	c,dreadf
	jmp	bdos
;
open:		;file open function
	mvi	c,openf
	jmp	bdos
;
getput:		;get or put cp/m (rw=0 for read, 1 for write)
		;disk is already selected
	lxi	h,loadp		;load point in ram for cp/m during sysgen
	shld	dmaddr
;
;	clear track to 00
;
	mvi	a,-1		;start with track equal -1
	sta	track
;
rwtrk:		;read or write next track
	lxi	h,track
	inr	m		;track = track + 1
	lda	ost		;number of operating system tracks
	cmp	m		;= track number ?
	jz	endrw		;end of read or write
;
;	otherwise not done, go to next track
;
	mov	c,m		;track number
	call	trk		;to set track
	mvi	a,-1		;counts 0, 1, 2, . . . 25
	sta	sector		;sector incremented before read or write
;
rwsec:		;read or write sector
	lda	spt		;sectors per track
	lxi	h,sector
	inr	m		;to next sector
	cmp	m		;a=26 and m=0 1 2...25 (usually)
	jz	endtrk
;
;	read or write sector to or from current dma addr
;
	lxi	h,sector
	mov	e,m		;sector number
	mvi	d,0		;to de
	lxi	h,tran
	mov	b,m		;tran(0) in b
	dad	d		;sector translated
	mov	c,m		;value to c ready for select
	push	b		;save tran(0),tran(sector)
	call	sec		;set up sector number
	pop	b		;recall tran(0),tran(sector)
	mov	a,c		;tran(sector)
	sub	b		;-tran(0)
	call	multsec		;*sector size
	xchg			;to de
	lhld	dmaddr		;base dma address for this track
	dad	d		;+(tran(sector)-tran(0))*secsiz
	mov	b,h
	mov	c,l		;to bc for sec call
	call	dma		;dma address set from <bc>
;
;	dma address set, clear retry count
;
	xra	a
	sta	retry		;set to zero retries
;
trysec:		;try to read or write current sector
	lda	retry
	cpi	maxtry		;too many retries?
	jc	tryok
;
;	past maxtries, message and ignore
;
	lxi	h,errmsg
	call	outmsg
	call	getchar
	cpi	cr
	jnz	reboot
;
;	typed a cr, ok to ignore
;
	call	crlf
	jmp	rwsec
;
tryok:		;ok to try read or write
	inr	a
	sta	retry		;retry=retry+1
	lda	rw		;read or write?
	ora	a
	jz	tryread
;
;	must be write
;
	call	write
	jmp	chkrw		;check for error returns
;
tryread:	call	read
;
chkrw:	ora	a
	jz	rwsec		;zero flag if r/w ok
;
;	error, retry operation
;
	jmp	trysec
;
;	end of track
;
endtrk:	lda	spt		;sectors per track
	call	multsec		;*secsiz
	xchg			;to de
	lhld	dmaddr		;base dma for this track
	dad	d		;+spt*secsiz
	shld	dmaddr		;ready for next track
	jmp	rwtrk		;for another track
;
endrw:		;end of read or write, return to caller
	ret
;
start:	lxi	sp,stack	;set local stack pointer
	lxi	h,signon
	call	outmsg
;
;	check for default file load instead of get
;
	lda	fcb+1		;blank if no file
	cpi	' '
	jz	getsys		;skip to get system message if blank
	lxi	d,fcb		;try to open it
	call	open
	inr	a		;255 becomes 00
	jnz	rdok		;ok to read if not 255
;
;	file not present, error and reboot
;
	lxi	h,nofile
	call	crmsg
	jmp	reboot
;
;	file present, read to load point
;
rdok:	xra	a
	sta	fcbcr		;current record = 0
;
;	pre-read area from tpa to loadp
;
	mvi	c,(loadp-tpa)/secsiz
;
;	pre-read file
;
prerd:	push	b		;save count
	lxi	d,fcb		;input file control count
	call	dread		;assume set to default buffer
	pop	b		;restore count
	ora	a
	jnz	badrd		;cannot encounter end-of file
	dcr	c		;count down
	jnz	prerd		;for another sector
;
;	sectors skipped at beginning of file
;
	lxi	h,loadp
;
rdinp:	push	h
	mov	b,h
	mov	c,l		;ready for dma
	call	dma		;dma address set
	lxi	d,fcb		;ready for read
	call	dread
	pop	h		;recall dma address
	ora	a		;00 if read ok
	jnz	putsys		;assume eof if not.
;
;	more to read, continue
;
	lxi	d,secsiz
	dad	d		;hl is new load address
	jmp	rdinp
;
badrd:		;eof encountered in input file
	lxi	h,badfile
	call	crmsg
	jmp	reboot
;
getsys:	lxi	h,askget	;get system?
	call	crmsg
	call	getchar
	cpi	cr
	jz	putsys		;skip if cr only
;
	sui	'0'		;normalize drive number
	cpi	ndisks		;valid drive?
	jc	getc		;skip to getc if so
	cpi	hardno		;check hard disk
	jz	getc
;
;	invalid drive number
;
	call	baddisk
	jmp	getsys		;to try again
;
getc:		;select disk given by register a
	adi	'0'
	sta	gdisk		;to set message
	sui	'0'
	call	sel		;to select the drive
;
;	getsys, set rw to read and get the system
;
	call	crlf
	lxi	h,getmsg
	call	outmsg
	call	getchar
	cpi	cr
	jnz	reboot
	call	crlf
;
	xra	a
	sta	rw
	call	getput
	lxi	h,done
	call	outmsg
;
;	put system
;
putsys:	lxi	h,askput
	call	crmsg
	call	getchar
	cpi	cr
	jz	reboot
	sui	'0'
	cpi	ndisks
	jc	putc
	cpi	hardno		;check hard disk
	jz	putc
;
;	invalid drive name
;
	call	baddisk
	jmp	putsys		;to try again
;
putc:		;set disk from register c
	adi	'0'
	sta	pdisk		;message set
	sui	'0'
	call	sel		;select dest drive
;
;	put system, set rw to write
;
	lxi	h,putmsg
	call	crmsg
	call	getchar
	cpi	cr
	jnz	reboot
	call	crlf
;
	lxi	h,rw
	mvi	m,1
	call	getput		;to put system back on diskette
	lxi	h,done
	call	outmsg
	jmp	putsys		;for another put operation
;
reboot:	mvi	a,0
	call	sel
	call	crlf
	jmp	boot
;
baddisk:	;bad disk name
	lxi	h,qdisk
	call	crmsg
	ret
;
;	data areas
;	messages
;
signon	db	'M-Labs C1 Sysgen vers. '
	db	vers/10+'0','.',vers mod 10+'0'
	db	0
askget	db	'Source drive name (or <return> to skip) ',0
getmsg	db	'Source on '
;
gdisk	db	'A:, then type <return> ',0	;filled in at get function
askput	db	'Destination drive name (or <return> to reboot) ',0
putmsg	db	'Destination on '
;
pdisk	db	'A:, then type <return> ',0	;filled in at put function
errmsg	db	'Permanent error, type <return> to ignore, <^C> to abort ',0
done	db	'Function complete',0
qdisk	db	'Invalid drive (use A, B, C or D)',0
nofile	db	'No source file on disk',0
badfile	db	'Source file incomplete',0
;
;	variables
;
cdisk	ds	1		;selected disk for current operation
track	ds	1		;current track
sector	ds	1		;current sector
rw	ds	1		;read if 0, write if 1
dmaddr	ds	2		;current dma address
retry	ds	1		;number of tries on this sector
	ds	stacksize*2
stack	equ	$
;
;
		end
