;
;	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;	*							*
;	*      INTEL 80186 internal register equate module	*
;	*			24 sep 83			*
;	*							*
;	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
int_ctl_regs	equ	0ff00h		;base of internal register block
;
extrn_io	equ	0000h		;base of external peripheral select lines
;
;	Base address of each peripheral select line
;
pcs0		equ	extrn_io	;select line 0 ...
pcs1		equ	pcs0 + 80h
pcs2		equ	pcs1 + 80h
pcs3		equ	pcs2 + 80h
pcs4		equ	pcs3 + 80h
pcs5		equ	pcs4 + 80h
psc6		equ	pcs5 + 80h	; ... select line 7
;
;	Control block relocation register offset
;
reloc_reg	equ	int_ctl_regs + 0feh	;control block relocation reg.
;
;	Internal memory and peripheral select register block
;
cs_sel_regs	equ	int_ctl_regs + 0a0h	;chip select registers
;
;	Memory and Peripheral select register offsets
;
umcs_reg	equ	cs_sel_regs + 00h	;upper memory select line
mmcs_reg	equ	cs_sel_regs + 06h	;middle memory select lines (4)
lmcs_reg	equ	cs_sel_regs + 02h	;lower memory select line
mpcs_reg	equ	cs_sel_regs + 08h	;memory/peripheral control reg.
pacs_reg	equ	cs_sel_regs + 04h	;peripheral select lines
;
;	Timer control register block
;
timr2		equ	int_ctl_regs + 60h	;timer 2 registers
timr1		equ	int_ctl_regs + 58h	;timer 1 registers
timr0		equ	int_ctl_regs + 50h	;timer 0 registers
;
;	Timer function register offsets
;
mode_reg	equ	06h		;mode/control register
max_cnt_b	equ	04h		;max count b register
max_cnt_a	equ	02h		;max count a register
cnt_reg		equ	00h		;count register
;
;	Interrupt controller register block
;
intr_ctl	equ	int_ctl_regs + 20h	;interrupt controller registers
;
;	Interrupt and internal control registers
;
ext_int3_ctl	equ	intr_ctl + 1eh		;external interrupt 3 control register
ext_int2_ctl	equ	intr_ctl + 1ch		;external interrupt 2 control register
ext_int1_ctl	equ	intr_ctl + 1ah		;external interrupt 1 control register
ext_int0_ctl	equ	intr_ctl + 18h		;external interrupt 0 control register
;
dma1_int_ctl	equ	intr_ctl + 16h		;dma 1 interrupt control register
dma0_int_ctl	equ	intr_ctl + 14h		;dma 0 interrupt control register
;
timr_int_ctl	equ	intr_ctl + 12h		;timer interrupt control register
;
int_stat_reg	equ	intr_ctl + 10h		;interrupt controller status register
int_req_reg	equ	intr_ctl + 0eh		;interrupt request register
in_srv_reg	equ	intr_ctl + 0ch		;interrupt in service register
pri_msk_reg	equ	intr_ctl + 0ah		;interrupt priority mask register
int_msk_reg	equ	intr_ctl + 08h		;interrupt mask register
pol_stat_reg	equ	intr_ctl + 06h		;poll status register
int_poll_reg	equ	intr_ctl + 04h		;interrupt poll register
int_eoi_reg	equ	intr_ctl + 02h		;end of interrupt register
;
;	In-service, Interrupt request, and Mask registers bit format
;
ext_int3_flg	equ	0000000010000000b
ext_int2_flg	equ	0000000001000000b
ext_int1_flg	equ	0000000000100000b
ext_int0_flg	equ	0000000000010000b
dma1_int_flg	equ	0000000000001000b
dma0_int_flg	equ	0000000000000100b
timr_int_flg	equ	0000000000000001b
non_spc_eoi	equ	1000000000000000b	;non-specific eoi command
;
;	Dma control register block
;
dma_ch1		equ	int_ctl_regs + 0d0h	;dma channel 1 registers
dma_ch0		equ	int_ctl_regs + 0c0h	;dma channel 0 registers
;
;	Dma 0 & 1 register offsets
;
cw_reg		equ	0ah		;control word register
tc_reg		equ	08h		;transfer count register
dst_seg		equ	06h		;destination pointer upper 4 bits
dst_reg		equ	04h		;destination pointer lower 16 bits
src_seg		equ	02h		;source pointer upper 4 bits
src_reg		equ	00h		;source pointer lower 16 bits
;
;	Base page reserved interrupt vector locations
;
		dseg	0000h
		org	0000h
;
div0_int_off	rw	1		;divide by zero interrupt
div0_int_seg	rw	1
;
ss_int_off	rw	1		;single step interrupt
ss_int_seg	rw	1
;
nmi_off		rw	1		;non-maskable interrupt
nmi_seg		rw	1
;
brk_int_off	rw	1		;soft breakpoint inst. interrupt
brk_int_seg	rw	1
;
ovf_int_off	rw	1		;overflow interrupt
ovf_int_seg	rw	1
;
bound_int_off	rw	1		;array bounds interrupt
bound_int_seg	rw	1
;
badop_int_off	rw	1		;invalid or non-existant op-code
badop_int_seg	rw	1
;
esc_int_off	rw	1		;escape instruction emulator interrupt
esc_int_seg	rw	1
;
timr0_int_off	rw	1		;timer 0 interrupt vector
timr0_int_seg	rw	1
;
		rs	4		;reserved
;
dma0_int_off	rw	1		;dma ch0 interrupt vector
dma0_int_seg	rw	1
;
dma1_int_off	rw	1		;dma ch1 interrupt vector
dma1_int_seg	rw	1
;
ext_int0_off	rw	1		;external interrupt 0 vector
ext_int0_seg	rw	1
;
ext_int1_off	rw	1		;external interrupt 1 vector
ext_int1_seg	rw	1
;
ext_int2_off	rw	1		;external interrupt 2 vector
ext_int2_seg	rw	1
;
ext_int3_off	rw	1		;external interrupt 3 vector
ext_int3_seg	rw	1
;
		rs	3*4		;reserved
;
timr1_int_off	rw	1		;timer ch1 interrupt vector
timr1_int_seg	rw	1
;
timr2_int_off	rw	1		;timer ch2 interrupt vector
timr2_int_seg	rw	1
;
		org	380h
;
bdos_int_off	rw	1		;CP/M-86 system call interrupt
bdos_int_seg	rw	1
;
;	end of iAPX-186 equate module
;
