;
;	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;	*							*
;	*	 Monitor equate and Data segment module		*
;	*			07 sep 83			*
;	*							*
;	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
mon_para	equ	0000h-(prom_size/16)	;base paragraph of monitor
;
regtablen	equ	14		;number of registers
segdif		equ	prom_size	;offset from base segment to
					;base of rom address
prompt		equ	'>'
can		equ	'X'-40h		;control X
esc_key		equ	1bh
;
;	Monitor equates
;
buflen		equ	80		;maximum length of line input buffer
bpmax		equ	16		;maximum number of breakpoints
bplen		equ	bpmax+bpmax	;length of breakpoint table
;
;
		dseg	0000h
		org	mon_ram		;monitor ram area base address
;
;	monitor ram area
;
ram_base	equ	$		;start of monitor ram block
brkcnt		rw	1		;number of breakpoints
tcount		rw	1		;number of steps to trace
;
;	Monitor CPU register save area
;
axsave		rw	1
bxsave		rw	1
cxsave		rw	1
dxsave		rw	1
;
spsave		rw	1
bpsave		rw	1
;
sisave		rw	1
disave		rw	1
;
dssave		rw	1
essave		rw	1
;
rstack		equ	offset $	;stack set here so registers
					; can be saved by pushing
sssave		rw	1
cssave		rw	1
;
ipsave		rw	1
fsave		rw	1
;
bptab		rb	bplen		;breakpoint table
linebuf 	rb	buflen+1	;line input buffer
;
		org	mon_ram+256
mon_stack	equ	offset $	;monitor stack location
;
end_mon_ram	equ	$		;end of ram variables
;
;	End of monitor equate and data segment module
;
