;	memory test program
;	july 15, 1977
;
strtad		equ	100h
bdos		equ	0005h
;
;
		org	strtad
;
;
start:		jmp	begin
;
stad		dw	0000		;start address
size		dw	0000		;size to be checked
incr		dw	0000		;test increment
;
badb		db	00		;bad byte
goodb		db	00		;pattern being tested
erloc		dw	0000		;address of bad byte
tloc		dw	0000		;walking bit pattern
record		dw	0000
bmpcnt		dw	0000
count		dw	0000
endad		dw	0000		;address of last loc+1
savad		dw	0000		;save initial startad
spsave		dw	0000		;save initial stack pointer
;
phase		db	00		;phase id
repflg		db	00		;repeat test flag
ntflag		db	00		;type flag
stack		equ	0c00h		;stack address
;
;
begin:		lxi	h,0000		;clear h&l
		dad	sp		;capture stack pointer
		shld	spsave		;save it for return
		lxi	sp,stack	;init sp
		call	logint		;initialize log area
		call	docrlf		;fresh line
		lxi	h,memtm0	;beginning message
		call	ttystr		;string to tty
		call	docrlf		;new line
		lxi	h,memtm1	;i/p address msg
		call	ttystr		;msg out
		lxi	h,stad+1	;strt address
		call	addrin		;get it
		lhld	stad		;get beginning address
		shld	savad		;save for repeat function
		call	docrlf		;new line
		lxi	h,memtm2	;'for' xxxx bytes
		call	ttystr		;put it out
		lxi	h,size+1	;length loc
		call	addrin		;get test length (in hex)
		lhld	size		;total test size
		xchg			;into d&e
		lhld	stad		;get beginning address
		dad	d		;beginning+size=end loc+1
		shld	endad		;save end loc
		call	docrlf
		lxi	h,memtm6	;msg address
		call	ttystr		;put it out
		lxi	h,incr+1	;get test size
		call	addrin		;*
;
askgn:		call	docrlf		;new line
		lxi	h,memtm5
		call	ttystr		;msg to tty
		call	ttyinb		;get reply
		cpi	59h		;y for yes?
		cz	styp		;set type all
		cpi	4eh		;n for no?
		cz	nstyp		;set no type all
;
flgstm:		call	docrlf		;new line
		lxi	h,repmsg	;continuous testing, y or n
		call	ttystr		;msg out
		call	ttyinb		;get response
		cpi	4eh		;n for no
		jz	norep		;leave flag zero for no
		cpi	59h		;y for yes?
		jnz	flgstm		;ask again if neither
		mvi	a,0ffh		;set a to ff
		sta	repflg		;set repeat flag
		jmp	flgst		;go...
;
;
norep:		xra	a		;clear a
		sta	repflg		;set no repeat
;
flgst:		call	docrlf		;new line
		lxi	h,phase		;init phase
		mvi	m,0		;*
		call	bmpph		;init phase
		xra	a		;start with 0
;
lp11:		call	setm		;set memory to value in acc
		call	cmpm		;compare memory with value in acc
		inr	a		;bmp to nxt code
		jnz	lp11		;jmp if not 0
;
;	end of phase 1
;
;	begin phase 2 - walk a 1 thru a field of 0's.
;
		lxi	b,0080h		;set up to walk a 1 thru 0's
		call	walk		;do it
;
;	end of phase 2
;
;	begin phase 3 - walk a 0 thru a field of 1's
;
		lxi	b,0ff7fh	;set up to walk a 0 thru 1's
		call	walk		;do it
;
;	end of memory check
;
		call	docrlf		;new line
		call	logout		;put out log info
		lhld	incr		;get increment
		xchg			;into d&e
		lhld	stad		;get current start address
		dad	d		;bump by incr
		shld	stad		;new start addr
		xchg			;into d&e
		lhld	endad		;get ending loc
		mov	a,h
		cmp	d		;see if we've passed endloc
		jc	tstnd		;yes if carry set
		jnz	flgst		;continue with test
		mov	a,l
		cmp	e		;= end loc?
		jnz	flgst		;continue test if no
;
tstnd:		lxi	h,memtm4	;end msg
		call	ttystr
		call	docrlf
		lda	repflg		;repeat?
		ora	a		;?
		jz	return		;return (no) if zero
		call	logint		;zero log table
		lhld	savad		;get beginning test address
		shld	stad		;restore stad
		call	docrlf		;new line
		lxi	h,restrt	;restart msg
		call	ttystr		;msg out
		jmp	flgst		;repeat...
;
;
return:		lhld	spsave		;get callers sp
		sphl			;set-up sp
		ret
;
;
setm:		call	setrg		;set up hl=a(mem), de=size
;
smlp1:		mov	m,a		;store a into mem
		inx	h		;bmp to nxt loc
		dcr	e		;dec lp ctl
		jnz	smlp1		;jmp if more
		dcr	d		;all done?
		jnz	smlp1		;jmp if no
		ret			;return if yes
;
;
cmpm:		call	setrg		;set up hl & de
;
cmlp1:		cmp	m		;is mem same as acc?
		jnz	cmper		;jmp if no
;
cmpok:		inx	h		;bmp to nxt loc
		dcr	e		;dec lp ctl
		jnz	cmlp1		;jmp if more
		dcr	d		;done?
		jnz	cmlp1		;jmp if no
		ret			;return if yes
;
;
cmper:		push	psw		;save psw
		lda	phase		;get phase no. in a
		cpi	1		;in 1st phase?
		jz	err		;jmp if yes
		lda	tloc		;at test loc?
		cmp	l		;*
		jnz	err		;jmp if no
		lda	tloc+1		;*
		cmp	h		;*
		jnz	err		;*
		pop	psw		;restore psw
		jmp	cmpok		;continue
;
;
err:		pop	psw		;restore acc
		push	psw		;put it back on stk
		sta	goodb		;store good byte
		mov	a,m		;get bad byte
		sta	badb		;store it
		lda	goodb		;get good byte
		mov	m,a		;fix-up bad byte
		shld	erloc		;store error location
		call	save		;save all on stack
		lda	phase		;get phase in acc
		out	0ffh		;write phase to lites
		lda	ntflag		;get no type flag
		ora	a		;no type?
		jnz	clog		;yes if not zero
		lda	chcnt		;current o/p count
		cpi	54		;max yet?
		jc	ttncr		;no if carry set
		call	docrlf		;next line please
;
ttncr:		call	sptty		;space carriage
		lxi	h,413dh		;a=
		call	hlctty		;a= to tty
		lhld	erloc		;get failing location
		call	hlbtty		;put it out
		call	sptty		;space carriage
		lxi	h,gbm		;good/bad message
		call	ttystr		;message out
		lhld	badb		;get g/b bytes
		call	hlbtty		;put them out
		lda	phase		;get current phase
		cpi	1		;first?
		jz	clog		;restart if yes
		call	sptty		;space carriage
		lxi	h,573dh		;w=	(walk location)
		call	hlctty		;w= to tty
		lhld	tloc		;get walk location
		call	hlbtty		;...to tty
;
clog:		call	log		;go log error
;
rstrt:		lda	phase		;put phase back in lites inverted
		out	0ffh		;*
		call	unsave		;restore all
		pop	psw		;restore acc
		jmp	cmpok		;continue
;
;
setrg:		push	psw		;save a
		call	inptst		;esc test
		jz	stcc
		cpi	escape
		jnz	stcc
		call	docrlf
		jmp	return
;
;
stcc:		cpi	0ah		;line feed says
		cz	logout		;print current log...
		cpi	54h		;'t' for type errors?
		cz	styp		;set type if yes
		cpi	4eh		;'n' for notype?
		cz	nstyp		;reset type if yes
		pop	psw		;restore a
		lhld	incr
		xchg			;de=loop size
		lhld	stad		;hl=a(loc to be tested)
		inr	e		;test e for 0
		dcr	e		;*
		rz			;return if de ok
		inr	d		;otherwise add 1 to d
		ret			;and return
;
;
bmpph:		call	docrlf		;new line on tty
		lxi	h,phasem	;phase message
		call	ttystr		;message to tty
		lxi	h,phase		;hl=a(phase)
		inr	m		;bmp phase by 1
		mov	a,m		;get phase in acc
		call	acbtty		;put out phase number
		cma			;set up for out
		out	0ffh		;write phase no to lites
		ret			;return
;
;
walk:		call	bmpph		;bmp to nxt phase
		lhld	stad		;init tloc
		shld	tloc		;*
		mov	a,b		;init mem to set value
		call	setm		;*
		jmp	walk1		;begin walk
;
;
wlp1:		mov	a,b		;get base pattern in a
		call	cmpm		;check all locations
		mov	a,c		;get walking bit in a
		rrc			;shift one step
		mov	c,a		;retprn it to c
		xra	b		;determine where bit is
		jm	wnew		;jmp if back to beginning
;
walk1:		lhld	tloc		;get a(tst loc) in hl
;
walk2:		mov	m,c		;put walking bit into tst loc
		jmp	wlp1		;go check memory for changes
;
;
wnew:		xchg			;get hi mem limit in de
		lhld	tloc		;get a(tst loc) in hl
		mov	m,b		;restore tst loc to normal
		inx	h		;bmp to nxt tst loc
		shld	tloc		;store new tst loc
		mov	a,e		;check for end
		cmp	l		;*
		jnz	walk2		;jmp if more
		mov	a,d		;*
		cmp	h		;done?
		jnz	walk2		;jmp if no
		ret			;return if yes
;
;
styp:		xra	a		;clear a for type flag
		sta	ntflag		;set to type all
		ret
;
;
nstyp:		mvi	a,0ffh		;set flag for
		sta	ntflag		;no type...
		ret
;
;
gbm		db	3,'gb='
phasem		db	6,'phase '
memtm0		db	23,'** memory diagnostic **'
memtm1		db	34,'beginning test location (in hex) : '
memtm2		db	34,'total test length in (hex) bytes : '
memtm4		db	13,'test finished'
memtm5		db	41,'record each error on console? (y or n) : '
memtm6		db	25,'test increment (in hex) : '
;
repmsg		db	23,'repeat test? (y or n) : '
restrt		db	10,'restarting'
;
;	subroutines for character & string i/o
;
;	save & unsave routines
;
save:		shld	temphl		;save h&l
		xthl			;get return, push h
		push	psw		;save psw
		push	b		;save b&c
		push	d		;save d&e
		push	h		;return back onto stack
		lhld	temphl		;restore original h&l
		ret
;
;
unsave:		pop	h		;restore return
		pop	d		;restore d&e
		pop	b		;restore b&c
		pop	psw		;restore psw
		xthl			;return onto stack, pop h
		ret
;
;
docrlf:		call	save		;save all
		lxi	h,crlf		;crlf string
		mvi	b,2		;2 count
		call	stctty		;string to tty
		xra	a		;clear ac
		sta	chcnt		;clear line character count
		call	unsave		;restore all
		ret
;
;
sptty:		push	psw		;save psw
		mvi	a,blank		;'space' into ac
		call	acctty		;character in ac to tty
		pop	psw		;restore psw
		ret
;
;
acctty:		push	b		;save
		mov	c,a		;save o/p character
;
gettbe:		push b ! push d ! push h
		mov	e,c
		mvi	c,2
		call	bdos
		pop h ! pop d ! pop b
;
		lda	chcnt		;get line character count
		adi	01		;plus 1
		sta	chcnt		;save
		mov	a,c		;data to ac again
		pop	b		;restore
		ret
;
;
ttystr:		push	b		;save b&c
		mov	b,m		;get msg count
		inx	h		;bump to msg proper
		call	stctty		;character string to tty
		pop	b		;restore b&c
		ret
;
;
inptst:		push b ! push d ! push h
		mvi	c,11
		call	bdos
		jz	done11
		mvi	c,1
		call	bdos
;
done11:		pop h ! pop d ! pop b
		ret
;
;
stctty:		call	save		;save all
;
stcout:		mov	a,m		;next character into ac
		call	acctty		;put it out
		inx	h		;next memory loc
		dcr	b		;count -1
		jnz	stcout		;output 'b' characters
		call	unsave		;restore all
		ret
;
;
acbtty:		push	psw		;save
		rrc			;swap
		rrc			;right and left
		rrc			;bits within
		rrc			;the byte.
		ani	00fh		;keep only right 4 bits
		call	hexex		;generate ascii from nibble
		pop	psw		;original byte again
		ani	00fh		;get second nibble
		call	hexex		;nibble into ascii
		ret
;
;
hexex:		cpi	10		;lower than 10?
		jm	con		;jump if yes
		adi	007h
;
con:		adi	030h		;ascii bias
		jmp	acctty		;put out this character
;
;
hlctty:		push	psw		;save
		mov	a,h		;get first character
		call	acctty		;put it out
		mov	a,l		;second character
		call	acctty		;put it out
		pop	psw		;restore
		ret
;
;
hlbtty:		push	psw		;save
		mov	a,h		;first byte
		call	acbtty		;put out 2 ascii characters
		mov	a,l		;second byte
		call	acbtty		;output 2 more
		pop	psw		;restore
		ret
;
;
ttyinb:		push b ! push d ! push h
		mvi	c,1
		call	bdos
		pop h ! pop d ! pop b
;
		sta	lstinp		;save as last i/p character
		ret
;
;
hexin:		call	ttyinb		;get a byte from tty
		call	tstesc		;escape test (get out?)
		call	map		;ascii chr to hex nibble
		rlc
		rlc
		rlc
		rlc
		ani	0f0h		;save top nibble
		mov	m,a		;save in memory
		call	ttyinb		;get another tty character
		call	tstesc		;escape test (get out?)
		call	map		;ascii character to hex nibble
		ani	00fh		;save right nibble
		ora	m		;combine with left nibble
		mov	m,a		;back into memory
		ret
;
;
map:		push	d		;save d
		mov	d,a		;save ac
		ani	040h		;numeric?
		mov	a,d		;restore ac
		jz	maprtn		;ok if numeric
		sui	001h		;-1
		adi	00ah		;map to a-f
;
maprtn:		pop	d		;restore d
		ret
;
;
tstesc:		cpi	escape		;input=escape
		jz	cyesc		;esc if zero
		cpi	altmod		;also ck tty alt mode
		rnz
;
cyesc:		call	docrlf		;new line
		jmp	start		;back to command i/p
;
;
addrin:		call	hexin		;get first hex address character
		dcx	h		;location for low byte
		call	hexin		;get second address character
		ret
;
;
crlf		db	00ah,00dh
;
blank		equ	020h
bell		equ	007h
escape		equ	01bh
altmod		equ	07dh
ttyctl		equ	0		;uart control port
ttydta		equ	1		;uart data port
tbe		equ	80h		;xmit buffer empty
rda		equ	40h		;character available
scd		equ	02h		;set carrier detect
dtr		equ	20h		;data terminal ready (low=true)
s10cps		equ	004h
s30cps		equ	00
host		equ	001h		;3p+s peripheral driver
;
chcnt		db	00
lstinp		db	00
temphl		dw	0000
;
;
logint:		;zero log table
		call	save		;save all
		lxi	h,logtbl	;get log table addr
		xra	a		;zero a
		mov	b,a		;count of 256
		mvi	c,4		;times 4 = 1024
;
logilp:		mov	m,a		;zero location
		inx	h		;next loc
		dcr	b		;count -1
		jnz	logilp		;loop thru table
		dcr	c		;major count -1
		jnz	logilp		;loop thru 1k
		call	unsave		;restore all
		ret
;
;
log:		;eight 1k by 1 chips per block
		call	save
		lhld	erloc		;get loc of bad byte
		call	logad
		lxi	h,logtbl	;address of table
		dad	d		;get row address
		xchg			;save in d&e
		lhld	badb		;get bad & good byte
		mov	a,h		;put good into a
		xra	l		;keep only different bits
		mvi	b,8		;# of row chips
		xchg			;get mem addr back
;
bitst:		ral			;get next bit in carry
		jnc	nxtb		;next bit if ok
		push	psw		;save ac & flags
		mov	d,m		;get hi count byte
		inx	h		;to next
		mov	e,m		;get low count byte
		inx	d		;bump count
		mov	a,d		;check
		ora	e		;for
		jnz	putc		;overflow
		dcx	d		;back to 65535 if overflow
;
putc:		mov	m,e		;count
		dcx	h		;back into
		mov	m,d		;memory
		pop	psw		;restore ac & flags
;
nxtb:		inx	h		;bump chip
		inx	h		;pointer
		dcr	b		;chip count -1
		jnz	bitst		;loop thru chips
		call	unsave		;restore all
		ret
;
;
logout:		;1k x 1 logout routine
		call	save		;save all
		lhld	stad		;get start address
		call	logad
		lxi	h,logtbl	;get logtbl address
		dad	d		;logtbl + test start address
		xchg			;save
		lhld	incr		;get test increment
		mov	a,h		;k part into a
		ani	0fch		;1k boundry
		rlc
		rlc
		mov	h,a		;save a
		ani	0f0h		;nothing less than 16
		mov	l,a		;into l
		mov	a,h		;restore a
		ani	0fh		;get overflow
		mov	h,a		;size now in h&l
		dad	d		;get end test location
		xchg			;beg in h&l, end in d&e
		call	docrlf		;new line
		call	docrlf		;"
;
ncc:		mvi	b,8		;8 chips
;
nc:		mov	a,m		;get hi count byte
		call	acbtty		;put it out
		inx	h		;bump to low byte
		mov	a,m		;get low count byte
		call	acbtty		;put it out
		call	sptty		;space
		inx	h		;to next hi count byte
		dcr	b		;check chips
		jnz	nc		;cont if not 8 yet
		call	docrlf		;new line
		call	docrlf		;"
		mov	a,l		;check for end location
		cmp	e		;*
		jnz	ncc		;not yet if not zero
		mov	a,h		;same on hi address byte
		cmp	d		;*
		jnz	ncc		;not yet if not zero
		call	docrlf		;new line
		call	docrlf		;"
		call	unsave		;restore all
		ret
;
;
logad:		lxi	d,0000		;clear d&e
		mov	a,h		;hi-addr into a
		ani	0fch		;zap non 1k boundries
		rlc			;times four
		rlc			;(row index)
		mov	d,a		;save a
		ani	0f0h		;nothing less than 16
		mov	e,a		;into e
		mov	a,d		;restore a
		ani	0fh		;get overflow
		mov	d,a		;d&e now contains size
		ret
;
		dw	0000		;catch assembler bug
;
logtbl		equ	$		;1k for error log table here
;
;
			end
