;
;**************************************************
;* 						  *
;*  USER-MODIFYABLE ROUTINES AND CONSTANTS FOR    *
;*  HARDWARE-DEPENDENT TERMINAL CHARACTERISTICS   *
;*  AND FUNCTIONS USED BY WORD-MASTER.            *
;*                       RELEASE 1.07   4/20/79   *
;**************************************************

; *** SUBROUTINE TO CLEAR SCREEN AND HOME CURSOR ***
;
; THIS VERSION WORKS FOR THE HAZELTINE 1500
;
	ORG	180H
OUTCHR	EQU	01EFH	;OUTPUT CHARACTER FOR RELEASE 1.07 
MEMORY	EQU	29B8H	;USER PATCH AREA FOR RELEASE 1.07 
CLRSCRN: NOP! NOP! NOP	;SPACE FOR LONGER PATCH /
	 NOP! NOP! NOP	; MAKE ADDRS MATCH OLD VERSION
    ;SEND TILDE, AND 1CH. THIS WORKS FOR HAZELTINE 1500
	MVI A,7EH	;(1) GET TILDE CHARACTER
	CALL OUTCHR	;SEND IT TO TERMINAL
	MVI A,1CH	;(2) GET CLEAR-SCREEN CODE
	JMP OUTCHR	;SEND IT TO TERMINAL AND EXIT
    ;NOP'S FOR COMPATIBILITY.
	NOP! NOP!
	NOP! NOP! NOP!
	NOP

;
; *** SUBROUTINE TO POSITION CURSOR AT      ***
; ***     LINE L (0=TOP), COLUMN H (0=LEFT) ***
;
;HAZELTINE 1500 VERSION:
; SENDS TILDE, 11H, X(H), Y(L)
;
 TCURSOR: MVI A,7EH! CALL OUTCHR	;SEND TILDE
	MVI A,11H! CALL OUTCHR	;SEND CURSOR ADDRESSING COMAND
	MOV A,H! CALL OUTCHR	;SEND COLUMN NUMBER.
	MOV A,L! JMP OUTCHR	;SEND LINE NUMBER AND EXIT.
	NOP! NOP! NOP		;FOR COMPATIBILITY.
	NOP! NOP		;...

	DB 0,0,0,0,0	;ADDITIONAL PATCH SPACE
	DB 0,0,0,0,0	;...

     
	;NOTE: BACKSPACE ROUTINE THAT WAS IN
	;PRIOR RELEASES IS NO LONGER NEEDED.

; **** MODIFYABLE CONSTANTS *****

 ;PBEGMEM POINTS TO BEGINNING OF MEMORY TO USE
 ;FOR EDIT BUFFER AND SCRATCHPAD. IF SPACE IS NEEDED
 ;FOR PATCHES, PUT THEM WHERE THIS POINTS AND
 ;INCREASE THIS POINTER. REMEMBER TO USE A LARGE
 ;ENOUGH "SAVE" COMMAND!

PBEGMEM: DW MEMORY

 ;SCREEN SIZE: TAKEN FROM THE FOLLOWING,
 ;EXCEPT SET AUTOMATICALLY TO MATCH HARDWARE
 ;VALUES WHEN IMSAI VIO VIDEO DISPLAY IS IN USE
 ;(DETECTED BY PRESENCE OF THE VIO ROM AT PROPER
 ;ADDRESS, AND CON: IOBYTE FIELD = 2 OR 3).

HITE:	DB 24	;MUST BE EXACT SCREEN HEIGHT IN LINES
WID:	DB 80	;MUST BE <= EXACT SCREEN WIDTH

 ;EREOL CONTAINS THE CHARACTER(S) TO ERASE SCREEN
 ;TO END-OF-LINE WITHOUT MOVING CURSOR, IF SUCH A
 ;CHARACTER IS AVAILABLE IN THE TERMINAL HARDWARE.
 ;IF 0, WILL BE SIMULATED BY SOFTWARE.
 ;AUTOMATICALLY SET TO CTL-U WHEN VIO IS IN USE.

EREOL:	DB 7EH	;(FIRST) CHARACTER, OR 0 IF NONE ** PATCHED FOR HAZELTINE **
	DB 0FH	;SECOND CHARACTER IF TERMINAL ** PATCHED FOR HAZELTINE **
		;...REQUIRES 2-CHARACTER
		;...SEQUENCE, ELSE A 0.

 ;NOVIO: IF NON-0, WILL NOT LOOK FOR IMSAI VIO.
 ;PATCH NON-0 IF VIO PROVIOSIONS INTERFERE WITH
 ;YOUR TERMINAL.

NOVIO:	DB 0FFH		;PATCHED FOR HAZELTINE 1500
	DB 0,0,0	;RESERVED FOR EXPANSION


;DELAYS EXECUTED AFTER VARIOUS TERMINAL FUNCTIONS,
;BEFORE NEXT CHARACTER IS SENT TO TERMINAL. THESE
;ALLOW TIME FOR TERMINAL TO RESPOND, AS REQUIRED
;BY SOME TERMINALS WHEN USED AT HIGH BAUD RATES.
;INCREASE IF YOU EXPERIENCE, FOR EXAMPLE, LOSS OF
;CHARACTERS AFTER CLEAR SCREEN.  EACH DELAY IS
;APPROX NUMBER OF MILLISECONDS ON 4MHZ PROCESSOR;
;DELAY IS TWICE AS LONG AS SHOWN FOR 2MHZ 8080.

DELCLR:	DB 25	;DELAY AFTER CLEAR SCREEN: 25+ MSEC.
DELCUS:	DB 10	;DELAY AFTER POSITION CURSOR: 10+MSEC.
DELERE:	DB 5	;DELAY AFTER ERASE TO EOL: 5+ MSEC.

	DB 0,0,0,0,0		;MORE 
	DB 0,0,0,0,0		;EXTRA
	DB 0,0,0,0,0		;PATCHING
	DB 0,0,0,0,0		;SPACE

	END
