; LAST UPDATED:		3 AUG 84
; REASON FOR UPDATE:	The boot ROM will boot from a hard disk drive,
;		        loading in the first 1024-byte sector.        rrs
;		
;
; PROGRAM NAME:		PROM1A2.ASM.
;
; PURPOSE:	2nd routine for Disk 1A boot rom:  Hard Disk initial program
;		loader (IPL), which consequently will load the remainder of
;		the operating system upon execution entry.
;
;	==========================	Copyright 1984, CompuPro Corporation,
;	||                 	||	A division of Godbout Electronics.
;	||  HARD DISK PROM	||	3506 Breakwater Court
;	||   POWER UP LOADER	||      Hayward, CA  94545
;	||			||
;	==========================
;
;	This product is a copyright program product of CompuPro and is
;	supplied for use with the CompuPro Disk controllers.
;
; Disk layout Definition.
;
;  Cylinder 0,  Head 0,  8 inch disk = 26 X 128 byte single density sectors.
;
;	The code is loaded starting XBOOT and may be
; any type of secondary loader or the runtime operating system itself.
;
;
; LIBRARY CONSTANTS:
	MACLIB	COMPUPRO	;Disk and Serial/Parallel interface constants
	MACLIB	ACTIVE		;Flags directing construction for the various
;
; EQUATED CONSTANTS:
;
ENTRY	EQU	100h			;Org address (= 0, for ROM)
HIRAM	EQU	8000h			;RAM offset of ROM so loader doesn't overlay 2nd page
RBOOT	EQU	ENTRY+200h+HIRAM	;end of PROM in RAM
XBOOT	EQU	100h			;Base Location of second phase loader in RAM
MAP	EQU	XBOOT+400h		;allocation map address for bad DISK3 sectors
;
FDPORT	EQU	0C0h	; FDC port
;	DISK3 equates follow:
D3PORT	EQU 	90h	; DISK3 IO port
D3NOP	EQU	0	; DISK3 no-op command
D3RDFL	EQU 	1	; DISK3 read flag
D3GLBAL	EQU	2	; DISK3 global command
D3SPEC	EQU	3	; DISK3 specify command
D3MAP	EQU	4	; DISK3 bad map command
D3HOME	EQU	5	; DISK3 home command
D3RWCMD	EQU	8	; DISK3 read/write command
;
;	ROM Bootstrap loader.

;
    ASEG
	ORG	ENTRY		;Base address of bootstrap PROM
	NOP! NOP! NOP! NOP	;8080 power up delay opcodes
INIT:	MVI	A,0FFh		;Turn on the disk motors, leave PROM active
	OUT	FDPORT+FDON
;
; Loop on total error to this point.
	LXI	B,4000h		;Init delay count
DELAY1	EQU $-ENTRY
	XTHL!	XTHL		;Harmless time consuming instructions
	DCX B!	MOV A,B! ORA C	;Bump count, test if done
	JNZ	DELAY1		;Loop until the time passes
; read ROM and write to RAM
ROMOVE:	LXI	H,RBOOT-HIRAM-ENTRY	;point to end of ROM
	LXI	D,RBOOT-ENTRY		;point to end of RAM
ROMOV1	EQU	$-ENTRY
	MOV	A,M		;read ROM byte
	STAX	D		;write to RAM
	DCX	D		;point to next byte
	DCX H!	MOV A,L! ORA H	;bump count (also pointer)
	JNZ ROMOV1		;loop if more bytes left to move
;
; load DISK3 IOPB address vector with first IOPB address
	LXI	D,5Dh		;DISK3 IOPB address vector
	MVI	A,low IOPB1	;LOB of first IOPB
	STAX	D		;write to vector
	INX	D		;point to next byte
	MVI	A,high IOPB1	;HOB of first IOPB
	STAX	D		;write to vector
	INX	D		;point to next byte
	MVI	A,0		;extended address offset
	STAX	D		;write to vector
	JMP	START		;jump to code located in high RAM
;
START	EQU	$+HIRAM-ENTRY
	MVI	A,0FEh		;disable ROM, enable RAM
	OUT	FDPORT+FDON
D3BOOT	EQU	$+HIRAM-ENTRY
	MVI	A,1		;DISK3 board reset byte
	OUT	D3PORT		;send it
	XRA	A		;ATTENTION byte
	OUT	D3PORT		;send it
	LXI	B,1400h		;init delay count (@123,000 cycles)
WAIT	EQU	$+HIRAM-ENTRY
	DCX B! MOV A,B! ORA C	;bump count
	JNZ 	WAIT		;wait more?
	LDA 	IOPB1S		;get STATUS
	ORA	A		;check if DISK3 present
	JM	DOHBT		;successful no-op, continue with hard boot
	JMP	START		;otherwise error, keep on looping
; execute DISK3 command subroutine
EXECUT	EQU	$+HIRAM-ENTRY
	XRA	A		;null byte
	OUT	D3PORT		;nudge DISK3
XX1	EQU	$+HIRAM-ENTRY
	LDAX	D		;get STATUS
	ORA	A		;check if busy
	JZ	XX1		;if so, try again
	RLC			;return if
	RM			;no error
	POP	B		;otherwise, fix stack
	JMP	START		;and keep on looping
;
DOHBT	EQU	$+HIRAM-ENTRY
	LXI 	D,IOPB2S	;point to global status byte
	CALL 	EXECUT		;do global command
;
	LXI	D,IOPB3S	;point to home status byte
	CALL	EXECUT		;do home head command
;
	LXI	D,IOPB4S	;point to read marker status byte
	LHLD	IOPB4+10	;point to data address for format check
	CALL	EXECUT		;do read command
;
	LXI	D,COMP		;point to 'COMPUPRO'
	MVI	B,4		;compare 4 characters
TEST	EQU	$+HIRAM-ENTRY
	LDAX	D		;'COMP' character in A
	CMP	M		;compare header character
	JNZ	START		;if not equal, then DISK3 not formatted
	INX	H		;point to next header byte
	INX	D		;point to next 'COMPUPRO' byte
	DCR 	B		;bump count
	JNZ	TEST		;more characters?
;
	LXI	D,IOPB5S	;point to specify status byte
	CALL	EXECUT		;do specify parameter command
;
	LXI	D,IOPB6S	;point to bad map status byte
	CALL	EXECUT		;do bad map command
;
	LXI	D,IOPB7S	;point to read sectors status byte
	LHLD	IOPB7+10	;point to data address for loader check
	CALL	EXECUT		;do read command
;
	MOV	A,M		;possible loader byte
	CPI	0E5h		;is loader there, or merely formatted?
	JZ	START		;no loader, keep on looping
;
; successful hard boot!
;
;************************************************
;*	EXIT ON SUCCESSFUL READ OPERATION	*
;************************************************
;
BOOTVEC	EQU	$+HIRAM-ENTRY
	IN	0C2h		;sense switch value
				;if bit 4 on then Interfacer 3/4
				;if bit 4 off then SS
	RRC!	RRC		;divide by 4
	ANI	1		;mask 4
	ORI	2		;add 2 for boot switch value
	MOV	C,A		;Boot switch value passed to loader
	JMP	XBOOT		;second phase loader
;	org	XBOOT		;Cold boot code starts in RAM here
	DB	'RR2'
;
	PAGE
;************************************************
;*	FIXED STORAGE FOR DISK PARAMETERS	*
;************************************************
;
COMP	EQU	$+HIRAM-ENTRY
	DB	'Comp'
;
IOPB1	EQU	$+HIRAM-ENTRY
	DB	D3NOP		;DISK3 present check
IOPB1S	EQU	$+HIRAM-ENTRY
	DB	0,0,0,0,0,0,0,0,0,0,0,0,low IOPB2,high IOPB2,0
IOPB2	EQU	$+HIRAM-ENTRY
	DB	D3GLBAL		;global information
IOPB2S	EQU	$+HIRAM-ENTRY
	DB	0,0,0,8,1,0,0,0,0,0,0,0,low IOPB3,high IOPB3,0
IOPB3	EQU	$+HIRAM-ENTRY
	DB	D3HOME		;home head
IOPB3S	EQU	$+HIRAM-ENTRY
	DB	0,0,0,0,0,0,0,0,0,0,0,0,low IOPB4,high IOPB4,0
IOPB4	EQU	$+HIRAM-ENTRY
	DB	D3RWCMD		;read marker into XBOOT
IOPB4S	EQU	$+HIRAM-ENTRY
	DB	0,0,D3RDFL,0,0,0,0,2,0,low XBOOT,high XBOOT
	DB	0,low IOPB5,high IOPB5,0
IOPB5	EQU	$+HIRAM-ENTRY
	DB	D3SPEC		;specify parameters
IOPB5S	EQU	$+HIRAM-ENTRY
 	DB	0,0,0,0,0,0,0,0,0,low XBOOT+10h,high XBOOT
	DB	0,low IOPB6,high IOPB6,0
IOPB6	EQU	$+HIRAM-ENTRY
	DB	D3MAP		;allocation map for bad sectors
IOPB6S	EQU	$+HIRAM-ENTRY
	DB	0,0,0,0,0,0,0,0,0,low MAP,high MAP
	DB	0,low IOPB7,high IOPB7,0
IOPB7	EQU	$+HIRAM-ENTRY
	DB	D3RWCMD		;read 9 1024-B sectors into XBOOT
IOPB7S	EQU	$+HIRAM-ENTRY
	DB	0,0,D3RDFL,0,0,0,0,9,0,low XBOOT,high XBOOT,0,50h,0,0
;
	END
