
;
;	THIS PROGRAM RELOCATES THE SATELLITE DEADSTART MODULE (DSTART.IMG)
;	INTO THE HIGHEST LOCATION IN RAM POSSIBLE.  IT THEN JUMPS TO THE
;	DEADSTART SEQUENCE IT JUST RELOCATED.  THIS ALLOWS THE USER TO USE
;	ANY HARDWARE THAT SUPPORTS PHANTOM ROM AS WELL AS HARDWARE WHERE
;	THE ROM IS UP HIGH IN MEMORY.
;
;	TO CREATE A .COM FILE THAT IS TO BE BURNT INTO ROM THE USER MUST
;	FIRST CREATE A DSTART.IMG FILE - SEE BUILD DOCUMENTATION
;
;	ASSEMBLE THIS AT THE LOCATION WHERE THE ROM IN THE SATELLITE IS TO GO
;
;	ENTER DDT BY TYPING:
;		DDT
;
;	READ THIS CODE IN AT 100
;		IDSLOAD.COM
;		R
;
;	READ THE DSTART.IMG FILE IN AT 200
;
;		IDSTART.IMG
;		R100			;OFFSET IT BY 100
;
;	EXIT TO ANOS WITH A CONTROL C OR A 
;
;		G0
;
;	CREATE A .ROM FILE THAT IS TO BE BURNT INTO ROM
;
;		.SAVE n DSTART.ROM
;
;	WHERE n IS THE NUMBER OF PAGES ROM TO BE BURNT
;
;	THE USER IS NOW PREPARED TO BURN HIMSELF A ROM
;


;
;	NOTE THAT SATCOLD WILL GO TO LOCATION 40H WHEN IT CALCULATES
;	THE AVAILABLE AMOUNT OF RAM.  THERFORE IF THE USER WISHES NOT
;	TO USE THIS ROUTINE BUT TO HAVE DIRECT JUMPS INTO THE ROM THEN
;	HE SHOULD BE SURE THAT THERE IS RAM DIRECTLY BELOW THE DSTART ROUTINE.
;


;
;	VARIABLE SECTION INITIALIZATION DONE IN INIT
;
;	THE USER IS RESPONSABLE FOR SETTING ROMSTRT TO WHERE 
;	THE ROM BEGINS IN HIS SATELLITE.
;

ROMSTRT EQU	0E000H		;WHERE ROM STARTS GOES HERE


STACK	EQU	15*1024			;SET STACK AT 15K
LENGTH	EQU	STACK+2			;TEMP FOR SIZE OF MAP
OFFSET	EQU	LENGTH+2		;OFFSET FOR EACH RELOCATABLE ADDRESS
OFFMAP	EQU	OFFSET+1		;OFFSET TEMP INTO MAP
BITSHIFTS	EQU	OFFMAP+2	;TEMP TO HOLD BITS TO SHIFT
BOOT	EQU	BITSHIFTS+1		;START OF DEADSTART IN RAM GOES HERE
DEST	EQU	BOOT+2		;ADDRESS OF NEXT DESTINATION GOES HERE
SOURCE	EQU	DEST+2			;ADDRESS OF NEXT SOURCE GOES HERE

SOURCE$LN	EQU	ROMSTRT+100H	;START OF IMG MODULE
MAPSTRT	EQU	SOURCE$LN+2		;START OF MAP

;
;	SET ORG TO WHERE YOUR ROM IS TO BE LOCATED
;

	ORG	ROMSTRT

;
;	DRIVER ROUTINE - CALCULATES SIZE OF RAM SPACE
;			 LOADS THE DEADSTART FILE INTO RAM AS
;			 HIGH AS POSSIBLE AS IT RELOCATES ALL ADDRESSES
;
;	EXIT -	JUMPS TO DEADSTART SEQUENCE
;

DRIVER:
	LXI	SP,STACK
	CALL	INIT		;INITIALIZE THE VARIABLES

DR1:	CALL	GETNEXT		;PUTS CODE FROM SOURCE INTO (A)
	CALL	PUTNEXT		;PUTS CODE IN A INTO RIGHT PLACE
	LHLD	LENGTH
	DCX	H		;LENGTH IS NOW ONE LESS
	SHLD	LENGTH
	MOV	A,H
	ORA	L
	JNZ	DR1		;LOOP IF ALL OF CODE IS NOT LOADED

	LHLD	BOOT		;START OF DEADSTART
	PCHL			;DEADSTART THE SATELLITE

;
;	GETNEXT -	GET THE NEXT BYTE FROM THE SOURCE
;
;	ENTRY -	SOURCE IS ADDRESS OF WHERE TO GET BYTE
;		OFFSET IS OFFSET IF THIS BYTE IS TO BE RELOCATABLE
;
;	EXIT -	(A) - BYTE TO GO TO RAM
;

GETNEXT:
	LHLD	SOURCE		;GET POINTER TO BYTE
	MOV	B,M
	INX	H		;SET TO NEXT BYTE
	SHLD	SOURCE		;SAVE FOR NEXT GETNEXT CALL
	PUSH	B		;SAVE BYTE
	CALL	CHKOFF		;IS IT RELOCATABLE
	POP	B		;GET BYTE BACK
	MVI	A,0		;NO OFFSET IF CARRY NOT SET
	JNC	GT1		;IF BYTE IS NOT TO BE RELOCATED
	LDA	OFFSET		;OFFSET
GT1:	ADD	B		;ADD IN BYTE
	RET

;
;	PUTNEXT - PUTS BYTE INTO RAM
;
;	ENTRY -	(A) BYTE TO PUT INTO RAM
;

PUTNEXT:
	LHLD	DEST		;GET DESTINATION
	MOV	M,A
	INX	H
	SHLD	DEST		;INC FOR NEXT BYTE
	RET

;
;	CHKOFF-	DOES THE CURRENT BYTE GET OFFSET
;
;	ENTRY -	OFFMAP - POINTER TO BYTE IN MAP WITH OFFSET BITS
;		BITSHIFTS - BITS TO SHIFT OFFMAP BYTE BY
;
;	EXIT -	(CARRY) - SET IF BYTE IS TO BE OFFSET
;

CHKOFF:
	LHLD	OFFMAP		;OFFSET MAP POINTER
	MOV	C,M
	LDA	BITSHIFTS	;BITS TO SHIFT
	MOV	B,A		;COUNT TO B

;
;	ADJUST BITSHIFTS FOR NEXT CALL TO CHKOFF
;

	CPI	8		;IS THIS THE LAST BIT IN THIS BYTE
	JNZ	CH1		;IF NOT LAST BIT

	XRA	A		;SET BITS TO SHIFT NEXT TIME TO 1 (INR BELOW)
	INX	H		;GO TO NEXT BYTE IN MAP
	SHLD	OFFMAP

CH1:	INR	A		;BITS TO SHIFT
	STA	BITSHIFTS	;SAVE

;
;	DO THE SHIFTS B STILL HOLDS COUNT FROM BITSHIFTS
;

	MOV	A,C		;BYTE FROM MAP TO A
CH2:	RRC
	DCR	B		;COUNT OF BITS TO SHIFT
	JNZ	CH2
	RET			;BIT WE WANT IS NOW IN CARRY

;
;	INIT -	INITIALIZE THE VARIABLES
;

INIT:
	LHLD	SOURCE$LN	;LENGTH OF MAP
	SHLD	LENGTH		;TEMP USED TO TELL HOW MUCH IS LEFT

	MVI	B,3		;DIVIDE BY 8 TO GET SIZE OF MAP
IN1:	ORA	A		;CLEAR THE CARRY
	MOV	A,H		;HIGH BYTE TO A
	RAR
	MOV	H,A		;SAVE SHIFTED RESULT
	MOV	A,L		;GET LOW BYTE
	RAR			;SHIFT CARRY FROM H INTO HIGH ORDER L
	MOV	L,A
	DCR	B		;DO IT 3 TIMES (/8)
	JNZ	IN1		;IF NOT DONE

	LXI	D,MAPSTRT	;START OF RELOCATION MAP
	XCHG
	SHLD	OFFMAP		;POINTER INTO MAP
	XCHG
	DAD	D
	SHLD	SOURCE		;START OF SOURCE
	MVI	A,1
	STA	BITSHIFTS	;SHIFT COUNT

	LXI	H,0H		;LAST POSSIBLE ADDRESS OF RAM+1
IN2:	DCX	H
	XRA	A		;SET A TO 0
	MOV	M,A		;TRY TO STORE AT THIS ADDRESS
	CMP	M		;DID WE STORE 0 CORRECTLY
	JNZ	IN2		;IF WE FAILED TO STORE A 0

	MVI	A,0FFH		;NOW TRY TO STORE AN 0FFH
	MOV	M,A
	CMP	M
	JNZ	IN2		;IF WE CAN'T STORE A 0 AT THIS LOCATION

	XCHG
	LHLD	SOURCE$LN	;SIZE OF CODE TO GO INTO RAM
	XCHG

	MOV	A,D		;SUBTRACT DE FROM HL
	CMA			;CONVERT TO NEGATIVE
	MOV	D,A
	MOV	A,E
	CMA
	MOV	E,A
	INX	D		;AND ADD 1 FOR 2'S COMPLEMENT

	DAD	D		;(HL)-(DE)=-(DE)+(HL)
				;OH FOR A HIGH LEVEL LANGUAGE THAT ALLOWS
				;DOUBLE SUBTRACTS
	INX	H
	MOV	A,H		;OFFSET TO A
	STA	OFFSET
	SHLD	DEST		;START OF WHERE CODE IS TO GO
	SHLD	BOOT		;START OF DEADSTART SEQUENCE
	RET

	END
