;
	title	'POEM.ASM for hytype i/f card, rev 2.0, 11 sep 81'
;
;MODIFIED FOR NETWORK OPERATION
;
;Wordstar interface for hytype i/f box
;
;
sdata	equ	21h		;serial data port
sstat	equ	sdata+2		;serial status port

lldata	equ	sdata		;poem low data port
hldata	equ	sdata		;poem high data port
lcntl	equ	sstat		;control/status port

txrdy	equ	0010$0100b	;DSR and transmitter buff empty bits
rxrdy	equ	0000$0001b	;receive char ready (not used)

check	equ	0000$0000b	;printer restore esc code
chstb	equ	0000$0001b	;char print esc code
cmstb	equ	0000$0010b	;carriage movement esc code
pfstb	equ	0000$0100b	;paper movement esc code

esc	equ	1bh		;escape char for esc seq

sign	equ	0000$0100b	;carr mov direction bit
half	equ	0000$1000b	; data 1/2 step bit
riblft	equ	0100$0000b	;ribbon color
select	equ	1000$0000b	;select printer bit (not used)

		org	3C20h	;wordstar offset for hytypes

oemini:	jmp	oini		;initialize the hytype
oemfin:	jmp	ofin		;close the hytype
oemver:	jmp	over		;vertical motion
oemhor:	jmp	ohor		;horizontal motion
oemsnd:	jmp	osnd		;print a character
oemrib:	jmp	orib		;ribbon command
	db	0,0,0		;reserved
oemlim:	dw	1023		;maximum move
oemwid:	dw	132*12		;maximum width
oempag:	dw	66*8		;page length
	dw	0,0		;reserved

;
ofin:	equ	$		;same as init

;
oini:		;do a restore and fall
		;through to set ribbon color
	call	restore
	xra	a
;
orib:		;<a>= 00 for normal color
		;<a>= 0ff for alternate color
	cma			;invert color so dummys driver will work
	ani	riblft		;mask for correct bit
	sta	ribcol		;save for later
	ret

;
osnd:		;send a character to the hytype
	push	psw		;char in <a>, so save
	mvi	a,chstb		;second char in esc seq flags
				;function :
				;	   00b = restore command
				;	   01b = print char (2 byte)
				;	   02b = move charrage (2 byte)
				;	   04b = move paper (2 byte)
	call	put$esc		;send escape sequence
	pop	psw		;restore character
	call	status		;send char
	lda	ribcol
	ori	select
	jmp	status		;send ribbon information

;
over:		;vertical motion command
		;at entry # 48ths to move is in <de>
		;<b> is 0ff to move up, 00 to move down
	mvi	a,pfstb
	mvi	c,00		;no "data 1/2 bit"
	jmp	move		;do it

;
ohor:		;horizontal motion command
		;at entry # 60ths to move is in <de>
		;<b> is 0ff to move right, 00 to move left
		;<c> is 0ff for 120ths motion, 00 for 60ths
	mvi	a,cmstb
;
move:		;sets up the operands for the various commands
	call	put$esc		;send command sequence
	mov	a,e		;low data
	call	status
	mvi	a,sign
	ana	b		;set direction
	ora	d		;and distance
	inr	c		;find out if <c> is 00
	dcr	c		;without changing <a>
	jz	col		;half?
	ori	half		;set half bit
;
col:	mov	b,a		;save
	lda	ribcol		;get ribbon color
	ora	b		;put it all together
	ori	select
	jmp	status

;
restore:	;send restore command
	mvi	a,check		;restore command
;
put$esc:	;send an escape char, and the command byte
	push	psw
	mvi	a,esc
	call	status
	pop	psw		;command is passed in <a>

;
status:		;check status of usart
	push	psw		;save char
st$lp:	in	lcntl		;status port
	ani	txrdy		;busy?
	cpi	txrdy
	jnz	st$lp		;return if not
	pop	psw		;get char
	out	lldata		;and send it
	ret

;
ribcol	db	00

		end
