/****************************************************************************

	Execute the iopb command function

	entry-	cdb= 	ptr to iopb structure
		bank=	memory bank address of the iopb structure
		flag= 	0: inhibit error display
			1: display error data
	exit -	FALSE= no error

*****************************************************************************
Known Bugs:





*****************************************************************************
Revision History:

	11-22-92   grh
	Update to current form.

	11-26-92   grh
	Add bank argument.

	12-1-92   grh
	Fix bug on error, iopb display has all 0xffs.





****************************************************************************/
#include mydefs.h
#include mylib.h
#include m5zf2.h

BYTE 
exe_iopb( cdb, bank, flag )
	struct iopb
		*cdb;	/* ptr to iopb structure */
	BYTE
		bank;
	int
		flag;	/* diagnostic flag */

{

   struct regs
	cpui;

/* Execute the IOPB */
   cpui.AF = ( MF_XIOB ) << 8;
   cpui.DE = bank;
   cpui.HL = cdb;
   farcall( (WORD) MR_FUN, bank, &cpui, &cpui );

/* Dump the results */
   if( flag && cdb -> pb_stat != 0 )   dmp_iopb( cdb, bank );

/* Return the status */
   return ( cdb -> pb_stat ) & 0x00ff;
   }
