/****************************************************************************

	return arguments in text function
Takes an argument pointing to pointer pointing to ASCIIZ text string 
containing hex arguments. It converts each argument to binary & places the
each resault in an array pointed to by 'args'. It converts up to 'n' 
arguments or less, whichever comes 1st. It returns the number of arguments
actually converted, and updates the pointer to the text character that is
not a hex character. This last item is why a pointer to a pointer is required.
 
	entry-	cptr= pointer to pointer to text
		n=	max number of arguments to get
		args=	array to place argument values
	exit -	(WORD)=	number of arguments actually received

*****************************************************************************
Known Bugs:




*****************************************************************************
Revision History:
	11-25-92   grh
	Add test for valid hex digit and <drive>:, (i.e. 'B:X').



****************************************************************************/
#include ctype.h
#include mydefs.h

WORD 
get_n_args( cptr, n, args )
	char
		**cptr;	/* pointer to pointer to text to xlate */
	WORD
		n,	/* Max argument count */
		args[];	/* array to place arguments */
{

   register WORD
	argn;		/* current argument count */
   char
	*cp;

/* Get up to n args */
   for( argn = 0, cp = *cptr; 
	 argn < n && (isxdigit( *cp )) &&  cp[ 1 ] != ':';
	 argn++ ) {
      args[ argn ] = atoh( cp );

/**** Remove white space between args */
      cp = NxtField( cp );
      }

/* Adjust caller's ptr */
   *cptr = cp;

/* Return argument count */
   return argn;
   }
