	TITLE	'CP/M Bootstrap Sector (ie. track 0, sector 1) - June 20, 1980'

;-----------------------------------------------------------------------
;
;
;	ALTOS COMPUTER SYSTEMS
;	2360 BERING DRIVE
;	SAN JOSE, CALIFORNIA 95131
;
;	(408) 946-6700
;
;
;	COPYRIGHT 1980, ALTOS COMPUTER SYSTEMS
;
;	THIS PROGRAM IS A COPYRIGHT PROGRAM PRODUCT OF
;	ALTOS COMPUTER SYSTEMS AND IS DISTRIBUTED TO THE
;	OWNERS OF ALTOS SUN SERIES 8000 COMPUTERS FOR
;	USE ON THOSE SYSTEMS ONLY. ANY OTHER USE OF THIS
;	SOFTWARE CONSTITUTES A BREACH OF THE COPYRIGHT
;	LICENSE TO THE PURCHASER.
;
;	VERSION DATE FEB 08, 1979
;
;	VERSION DATE JULY 16, 1979
;	Modification to provide optional DMA support for hardware.
;
;	VERSION DATE SEPTEMBER 7, 1979
;	ADD SUPPORT FOR CP/M VERSION 2.00
;
;	VERSION 2.20
;	DATE:	June 20, 1980
;	Add support for user selectable console baud rate
;	Revised for CP/M 2.20
;
;
;-----------------------------------------------------------------------
;
;	ASSEMBLER CONTROL STATEMENTS
;
;-----------------------------------------------------------------------
;

	MACLIB	Z80

TRUE	EQU	0FFFFH		;VALUE FOR TRUE
FALSE	EQU	NOT TRUE	;VALUE FOR FALSE

VERSION	EQU	22		;CP/M VERSION NUMBER

MSIZE	EQU	32		;MEMORY SIZE OF SYSTEM FOR ASSEMBLY
;				;..NOTE: MSIZE HAS MEANING ONLY IF THIS
;				;..      ASSEMBLLY SPECIFIES RELOC EQU FALSE

RELOC	EQU	TRUE		;SET TO FALSE FOR NORMAL ASSEMBLY
DMA	EQU	TRUE		;SET TO TRUE IF DMA GENERATION
HARDSK	EQU	TRUE		;SET TO TRUE FOR HARD DISK SYSTEM

	IF	DMA
REVLVL	EQU	0		;REVISION LEVEL FOR DMA SYSTEMS
	ELSE
REVLVL	EQU	1		;REVISION LEVEL FOR NON-DMA SYSTEMS
	ENDIF

	IF	HARDSK
OFFST	EQU	2800H		;CCP OFFSET FROM TOP OF MEMORY
	ENDIF
	IF	NOT HARDSK
OFFST	EQU	2000H		;OFFSET FOR FLOPPY SYSTEM
	ENDIF

	IF	RELOC
;				;When assembling for relocatable version,
;				;do one assembly with BIAS of 0000H
;				;do second assembly with BIAS of 0100H
BIAS	EQU	0000H		;VALUE FOR RELOCATABLE ASSEMBLY
	ENDIF
	IF	NOT RELOC
BIAS	EQU	(MSIZE*1024)-OFFST ;VALUE FOR ABSOLUTE ASSEMBLY
	ENDIF

CCP	EQU	000H+BIAS	;START OF CCP
BDOS	EQU	CCP+806H	;ENTRY TO DOS FOR CALLS
BIOS	EQU	CCP+1600H	;START OF BIOS

;
;-----------------------------------------------------------------------
;
;	ROUTINE TO LOAD AND RELOCATE CCP/BDOS/CBIOS
;
;-----------------------------------------------------------------------
;
	ORG	0000H		;ORIGIN FOR BOOTSTRAP
COLD:
	LXI	H,CCP		;BASE OF BDOS FOR LOAD
        SHLD    DMAAD		;SET AS DMA ADDRESS
	SPHL			;KEEP STACK OUT OF THE WAY
        MVI     D,51		;NUMBER OF SECTORS TO LOAD
        MVI     B,0FFH     	;STARTING TRACK-1
        MVI     A,26+2     	;SET TO LOAD FROM SECT 2
;
;-----------------------------------------------------------------------
;
;	UPDATE TRACK REGISTER IN 1771
;
;-----------------------------------------------------------------------
;
READS:  SUI     26
        MOV     C,A        	;SAVE SECTOR #
        OUT     6          	;SEND SECTOR # TO CONTROLLER
        INR     B          	;INCREMENT TRACK #
        MOV     A,B
        OUT     7          	;SEND TRACK # TO CONTROLLER
        MVI     A,01AH		;SEEK COMMAND
        OUT     4          	;SEEK TO TRACK
WAIT1:	JR	WAIT1		;WAIT FOR I/O TO COMPLETE

;
;-----------------------------------------------------------------------
;
;	SETUP TO READ FIRST SECTOR ON TRACK
;
;-----------------------------------------------------------------------
;
        XRA	A		;SET HEAD LOAD DELAY
        OUT     13
        MVI     A,8CH      	;READ COMMAND & HEAD LOAD
;
;-----------------------------------------------------------------------
;
;	ISSUE READ FOR EACH SECTOR
;
;-----------------------------------------------------------------------
;
READ1:  PUSH    B
	if	not dma
        MVI     C,7        	;SET INPUT PORT #
	LHLD	DMAAD
	endif
	if	dma
	CALL	SETDMA		;SET DMA FOR READ
	endif
        OUT     4          	;ISSUE READ COMMAND
WAIT2:	JR	WAIT2		;WAIT FOR I/O TO COMPLETE
ADSEC:	PUSH	D		;INCREMENT MEMORY ADDRESS
	LXI	D,128
	LHLD	DMAAD		;ADDRESS TO BE UPDATED
	DAD	D		;DO IT....
	SHLD	DMAAD		;SAVE UPDATED ADDRESS
	POP	D		;RESTORE REGISTER D
        POP     B
	IN	4		;READ DISK STATUS
	ANI	09FH		;REMOVE UNWANTED STATUS BITS
	JRNZ	COLD		;BAD STATUS, START OVER
        DCR     D          	;DCR SECTOR COUNT
	JRZ	GOCPM		;FINISHED LOAD, START CP/M
        INR     C          	;INCREMENT SECTOR COUNT
        MOV     A,C
        CPI     27         	;HAVE WE FINISHED THIS TRACK?
	JRNC	READS		;CONTINUE WITH NEXT TRACK
        OUT     6          	;SEND SECTOR # TO CONTROLLER
        MVI     A,088H		;
	JR	READ1		;CONTINUE ON WITH THIS TRACK

;
;-----------------------------------------------------------------------
;
;	FINISHED LOADING, SETUP PRINTER PORT THEN DENSITY
;
;-----------------------------------------------------------------------
;

GOCPM:

	LHLD	BAUD$RATE	;GET INFO FOR CONSOLE BAUD RATE
	MOV	A,L
	OUT	00CH
	MOV	A,H
	OUT	00CH

	JMP	BIOS		;GO START THE BALL ROLLING

;-----------------------------------------------------------------------
;
;	THE FOLLOWING TWO WORDS ARE RESERVED FOR USE BY SETUP.  IF YOU
;	MODIFY ANY CODE IN THIS MODULE, YOU SHOULD BE SURE THAT THE
;	"ORG" STATEMENT WHICH FOLLOWS DOES NOT CAUSE ANY CODE TO BE
;	OVERLAYED.
;
;-----------------------------------------------------------------------

	ORG	05AH
	DW	0
	DW	0

;
;-----------------------------------------------------------------------
;
;	INTERRUPT POINTER AND SERVICE ROUTINE
;
;-----------------------------------------------------------------------
;
;	ORG	005EH		;FLOPPY INTERRUPT VECTOR MUST BE AT 05EH
        DW      INY2A      	;POINTER FOR MODE 2 INTERR.
	if	not dma
        ORG     0066H      	;NON MASKABLE INTERRUPT (DRQ)
	DB	0EDH,0A2H	;FAKE INI INSTRUCTION
	DB	0EDH,045H	;FAKE RETN INSTRUCTION
	endif
;
;
;
INY2A:	POP	H		;ON INTERRUPT SKIP TWO BYTES
	INX	H
	INX	H
	PUSH	H
	EI			;RE-ENABLE SYSTEM
	DB	0EDH,04DH	;FAKE RETI INSTRUCTION
;
;-----------------------------------------------------------------------
;
;	DMA setup routine
;
;-----------------------------------------------------------------------
;
	if	dma
setdma:
	lxi	h,dmastr	;DMA setup string
	lxi	b,0900H		;port zero in C, count of 09 in B
	db	0EDH,0B3H	;fake OUTIR instruction
	ret			;
	endif
;
;-----------------------------------------------------------------------
;
;	DATA AREAS USED BY BOOT
;
;-----------------------------------------------------------------------
;
DMASTR:
	DB	07DH
DMAAD:	DS	2
	DW	080H-001H
	DB	0CFH,001H,0CFH,087H

	ORG	007BH
	DB	'C'		;ID FOR CP/M SYSTEM
	DB	VERSION,REVLVL

BAUD$RATE:
	DB	047H,00DH	;DEFAULT OF 9600 BAUD FOR CONSOLE
;				;THESE VALUES MAY BE CHANGED BY
;				;SETUP TO ALLOW OTHER BAUD RATES

        END
