;test routine for 9512
BDOS	EQU	5
PSTRING	EQU	9H   ;PRINTS STRING IN DE REGISTER
RCON	EQU	0AH  ;READS STRING INTO LOCATION IN DE REG.
COUT	EQU	2H   ;OUTPUTS SINGLE CHARACTER IN REG E TO TERMINAL
CIN	EQU	1    ;INPUTS CONSOLE CHARACTER TO REG A
CR	EQU	0AH
LF	EQU	0DH
DREG	EQU	58H
creg:	equ	59H
	
;
	ORG	100H
	lxi	d,cpymsg	;print copyright message
	mvi	c,pstring
   	call	bdos
;
        LXI	SP,STACK	;INITIALIZE STACK
;
START:	LXI	D,GREET   
	MVI    	C,PSTRING
	CALL	BDOS
;
	XRA 	A
	STA	COUNT	;INITIALIZE COUNTER
;
;write table1 to 9512
EXAM:	lxi	h,tbl1
	mvi	c,8
test1:	mov	a,m
	out	dreg
	inx	h
	dcr	c
	jnz	test1
	mvi	a,1
	out	creg
	nop	;put rst 7 here for operation with ndt
;compare 9512 answer with predicted answer
	mvi	c,4
	lxi	h,tbl1A
comp1:	in	dreg
	cmp	m
	jnz	error
	inx	h
	dcr	c
	jnz	comp1
	nop		;put rst 7 here for ddt
	in	creg	;check status
	lxi	d,okmsg
	mvi	c,pstring
	call	bdos
	nop		;put rst 7 here for ddt
	jmp	0
;
;IF ONE OFF THEN POP 2-- IF NO GO ONE MORE TEST SHOULD DO IT
;
error:	lxi	d,errmsg
	mvi	c,pstring
	call	bdos
	nop		;put rst 7 here for ddt
	LDA	COUNT
	INR	A
	STA	COUNT
	CPI	3  
	JZ	PERM
	CPI	2
	JZ	SECOND
	IN	DREG	;ADJUST 9512 STACK POINTER
	IN	DREG
SECOND:	LXI	D,ADJMSG
	MVI	C,PSTRING
	CALL	BDOS
	jmp	EXAM
;
PERM:	LXI	D,PERMSG
	MVI	C,PSTRING
	CALL	BDOS
EXIT:	JMP	0
;
COUNT:	DB	0
;
;MESSAGES
;
GREET: 	DB	CR,LF,'9512 TEST BEGUN',CR,LF,'$'
;
ERRMSG: 	DB	CR,LF,'ERROR ','$'
OKMSG:		DB	CR,LF,'OK ','$'
ADJMSG:		DB	CR,LF,'ADJUSTING 9512 STACK',CR,LF,'$'
PERMSG:		DB	CR,LF,'PERMANENT ERROR',CR,LF,'$'
cpymsg:		DB	CR,LF,'COPYRIGHT COMPUPRO 1983'
		DB	CR,LF,CR,LF,'$'
;
TBL1:	DB	00,00,80H,3FH,00,00,80H,3FH
TBL1A:	DB	40H,00,00,00
	DS	64	;32 LEVEL STACK
STACK:	
