;*						
;*
;*		INTERFACER 3 TEST PROGRAM
;*
;*
;    Thi progra wil initialize 265s for asynchronous
;operation at 9600 baud wit  dat bits on sto bit n 
;parity.  This program will echo all characters received on any
;user channel (from 0 to 31) and if any user sends a ^C, the 
;program will terminate and return back to CP/M. 
;*
;*
base    equ     10h
udata	equ	BASE+0h	;data port in and out
ustat	equ	BASE+1h	;status register port
mode	equ	BASE+2h	;mode register port
commr	equ	BASE+3h	;command register port
txreg	equ	BASE+4h	;tx int register
rxreg	equ	BASE+5h	;rx int register
user	equ	BASE+7h	;port to select user  
exit	equ	0	;CP/M reentry point
tbmt	equ	01h	;transmitter buffer empty
dav	equ	02h	;data available	
bdos	equ	5
cr	equ	0aH
lf 	equ	0dH
print	equ	9H
*
*
*
	org	100h
	lxi	d,cpymsg
	mvi	c,print
	call	bdos
Start	mvi	a,0ffh	;init user
Loop	inr	a	;next user
  	cpi	20H	;check for final uart
	jz	echo	;start echo routine
	out	user	;select uart
	mov	b,a	;save user in b
	call	init	;init the uart
	mov	a,b	;restore user
	jmp	loop	;next
Init  	mvi   	a,0CEh	;set up the 2651
	out	mode	;send to mode register 1
	mvi	a,7Eh	;9600 baud, internal clocks
	out	mode    ;SEND BYTE TO M.R. 2
	mvi	a,27h	;could be 07h (no 1420)
	out	commr
	ret
Echo	mvi	a,0FFh	;mask value
	out	txreg	;set tx int reg
	out	rxreg	;set rx int reg
Loop1	inr	a	;next user
	out	user	;select uart
	mov	b,a	;save user in b
	call	cstat 	;check for data
	cpi	0AAh	;data if aa
	cz	ok	;do echo loop
	mov	a,b	;restore user
	jmp	loop1	;next
Ok	call	inloop	;get data
	call	oloop	;output data
	ret
Cstat	in	ustat	;look for key entry
	ani	dav	;check status
	jz	nodat	;no data
	mvi	a,0AAh	;data char
	ret
Nodat	mvi	a,0	;no data char
	ret
Inloop	in	ustat   ;look for key entry 
	ani	dav	;check the status
	jz	inloop 	;wait for key entry
	in	udata  	;get key entry
	ani	7Fh	;mask parity off
	cpi	03h	;has a ^c been hit?
	jz	done	;return to CP/M
	mov	e,a	;save input in E reg.
	ret
Oloop	in	ustat	;check ready for output
	ani	tbmt	;check status
	jz	oloop	;wait for ready
	mov	a,e	;get data
	out	udata	;output character
	ret
cpymsg:	db	cr,lf,'COPYRIGHT COMPUPRO 1983'
	db	cr,lf,cr,lf,'$'
Done	jmp	exit	;return to cp/m
	end	   

