***	BIOS Equates
**
**	Copyright 1985 (C)  by
**		TriSoft
**		1825 East 38 1/2,  Suite #202
**		Austin,  Tx  78722
**
**
	.text
*
***	Equates for 68K BIOS ***
*
	.globl	serial
	.globl	packet
	.globl	pktst
	.globl	pkd0
	.globl	mreg1
	.globl	mreg2
	.globl	dtabxp
	.globl	dlstcc
*
serial:	.equ	$00000000	; serial number
packet:	.equ	$1ffc0	; packet base address
pktst:	.equ	$1ffc1		; packet status
pkd0:	.equ	$1ffc8		; packet D0.L base
mreg1:	.equ	$1f00		; mem lim reg #1
mreg2:	.equ	$1f00		; mem lim reg #2
*
dtabxp:	.equ	$00		; tab expansion CON: (0=>no)
dlstcc:	.equ	$00		; carriage cntl LST: (0=>no)
*
*
***	BSS section for disk check vectors and allocation buffers
***
***		[maintained in BIOSEQU for user modification]
*
*
	.bss
*
	.globl	csv0
	.globl	alv0
	.globl	csv1
	.globl	alv1
	.globl	csv2
	.globl	alv2
	.globl	csv3
	.globl	alv3
	.globl	csv4
	.globl	alv4
	.globl	csv5
	.globl	alv5
	.globl	csv6
	.globl	alv6
	.globl	csv7
	.globl	alv7
*
*****
*
csv0:	.ds.b	1024		* disk 0 check vector buffer (4k drm)
alv0:	.ds.b	1024		* disk 0 allocation buffer (8 Mbyte dsk)
*
csv1:	.ds.b	512		* disk 0 check vector buffer (2k drm)
alv1:	.ds.b	512		* disk 0 allocation buffer (4 Mbyte dsk)
*
csv2:	.ds.b	96		* disk 0 check vector buffer (384 drm)
alv2:	.ds.b	256		* disk 0 allocation buffer (2 Mbyte dsk)
*
csv3:	.ds.b	96		* disk 0 check vector buffer
alv3:	.ds.b	256		* disk 0 allocation buffer
*
csv4:	.ds.b	96		* disk 0 check vector buffer
alv4:	.ds.b	256		* disk 0 allocation buffer
*
csv5:	.ds.b	96		* disk 0 check vector buffer
alv5:	.ds.b	256		* disk 0 allocation buffer
*
csv6:	.ds.b	96		* disk 0 check vector buffer
alv6:	.ds.b	256		* disk 0 allocation buffer
*
csv7:	.ds.b	96		* disk 0 check vector buffer
alv7:	.ds.b	256		* disk 0 allocation buffer
*
*
*
	.end
