;----------------------------------------------------
;
; BYTESAVER EPROM PROGRAMMER CONTROL PROGRAM
;
; VERSION 0.2 - 10 SEP 77
;
; COPYRIGHT 1977
;
; JEFFREY W. SHOOK
; P. O. BOX 185
; ROCKY POINT, NEW YORK 11778
;
;-----------------------------------------------------

; SYMBOL DEFINITIONS

BDOS	EQU	5	; CP/M BDOS ENTRY POINT
RCON	EQU	1
WCONB	EQU	9
CR	EQU	0DH	; ASCII CARRIAGE RETURN
LF	EQU	0AH	; ASCII LINE FEED
STATL	EQU	0FFH	; IMSAI CONSOLE STATUS LED'S
BYTSAV	EQU	0E000H	; BYTESAVER START ADDRESS
NPASS	EQU	128	; NUMBER OF PROGRAMMING PASSES
			; THIS VALUE FOR BYTESAVER WITH
			; 1.0 MSEC. PROGRAM PULSE
BEGDAT	EQU	1000H	; START OF DATA FOR EPROMS

; MAIN PROGRAM CODE

	ORG	100H	; CP/M STARTS EXECUTION HERE

	LXI	H,0	; SAVE CP/M STACK
	DAD	SP
	SHLD	SPSAV
	LXI	SP,STACK

	MVI	A,0FFH	; CLEAR CONSOLE STATUS LED'S
	OUT	STATL
	CALL	PTITLE	; PRINT TITLE
	CALL	RANGE	; GET EPROM ADDRESS RANGE
	CALL	ERASED	; CHECK IF PROMS ERASED
PROG:	CALL	PROGRM	; BURN IN EPROMS
	CALL	COMPAR	; CHECK IF TRANSFER CORRECT
	ORA	A	; CHECK IF EPROMS CORRECT
	JNZ	GOCPM
	MVI	C,WCONB	; TRY PROGRAMMING AGAIN?
	LXI	D,MSG1
	CALL	BDOS
	JMP	NEXT1

MSG1:	DB	'TRY AGAIN ? ',CR,LF,'$'

NEXT1:	CALL	INCH
	CPI	'Y'
	JZ	PROG

GOCPM:	LHLD	SPSAV	; RETURN TO CP/M
	SPHL
	JMP	BDOS

; FUNCTION SUBROUTINES

PTITLE:	MVI	C,WCONB	; PRINT PROGRAM TITLE
	LXI	D,MSG2
	CALL	BDOS
	JMP	NEXT2

MSG2:	DB	CR,LF,CR,LF
	DB	'BYTMOV VERSION 0.2',CR,LF,'$'

NEXT2:	RET

RANGE:LXI	D,MSG3
	CALL	PRTMSG
	JMP	NEXT3

MSG3:	DB	CR,LF,'EPROM SOCKET POSITION (0 - 7)',CR,LF
	DB	'FIRST? ','$'

NEXT3:	CALL	INHEX
	JC	RANGE
	CPI	8
	JNC	RANGE
	MVI	L,0
	MOV	H,A
	DAD	H
	DAD	H
	LXI	D,BYTSAV
	DAD	D
	SHLD	BEGPRM

	LXI	D,MSG4
	CALL	PRTMSG
	JMP	NEXT4

MSG4:	DB	CR,LF,'LAST ? ','$'

NEXT4:	CALL	INHEX
	JC	RANGE
	CPI	8
	JNC	RANGE
	INR	A
	MOV	H,A
	MVI	L,0
	DAD	H
	DAD	H
	LXI	D,BYTSAV
	DAD	D
	SHLD	ENDPRM
	RET

ERASED:	LHLD	BEGPRM
ERASE1:	MOV	A,M
	CPI	0FFH
	JNZ	ERASE2
	INX	H
	LDA	ENDPRM+1
	CMP	H
	JNZ	ERASE1
	LXI	D,MSG5
	JMP	ERASE3

ERASE2:	LXI	D,MSG6
ERASE3:	CALL	PRTMSG
	RET

MSG5:	DB	CR,LF,CR,LF
	DB	'EPROMS ARE ERASED.',CR,LF,'$'
MSG6:	DB	CR,LF,CR,LF
	DB	'EPROMS NOT ERASED!',CR,LF,'$'


PROGRM:	LXI	D,MSG7
	CALL	PRTMSG
	CALL	INCH
	CPI	CR
	JNZ	PROGRM
	LXI	D,MSG8
	CALL	PRTMSG
	LXI	B,NPASS
	MOV	A,B
	CMA
	OUT	STATL
PROGR2:	PUSH	B
	LXI	D,BEGDAT
	LHLD	BEGPRM
PROGR3:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	LDA	ENDPRM+1
	CMP	H
	JNZ	PROGR3

	POP	B	; GET PASS COUNT
	DCX	B
	MOV	A,C	; DSIPLAY COUNT ON STATUS LIGHTS
	CMA
	OUT	STATL
	MOV	A,B	; CHECK FOR PASSES = 0
	ORA	C
	JNZ	PROGR2	; LOOP IF NOT LAST PASS
	LXI	D,MSG9
	CALL	PRTMSG
PROGR5:	CALL	INCH
	CPI	CR
	JNZ	PROGR5
	RET

MSG7:	DB	CR,LF
	DB	'TURN PROGRAM POWER ON',CR,LF
	DB	'TYPE CR TO CONTINUE ','$'
MSG8:	DB	CR,LF,CR,LF
	DB	'PROGRAMMING NOW IN PROGRESS',CR,LF
	DB	'PLEASE WAIT 2 MINUTES PER EPROM'
	DB	CR,LF,CR,LF,'$'
MSG9:	DB	'PROGRAMMING COMPLETE',CR,LF
	DB	'TURN PROGRAM POWER OFF',CR,LF
	DB	'TYPE CR TO CONTINUE',CR,LF,'$'

COMPAR:	LXI	D,BEGDAT
	LHLD	BEGPRM
COMPA1:	LDAX	D
	CMP	M
	JNZ	COMPA2
	INX	H
	INX	D
	LDA	ENDPRM+1
	CMP	H
	JNZ	COMPA1
	LXI	D,MSG10
	MVI	A,0FFH	; MARK CORRECT
	PUSH	PSW
	JMP	COMPA3

COMPA2	LXI	D,MSG11
	MVI	A,0	; MARK ERROR
	PUSH	PSW
COMPA3:	CALL	PRTMSG
	POP	PSW	; GET SUCCESS CODE
	RET

MSG10:	DB	'EPROMS CORRECTLY PROGRAMMED',CR,LF,'$'
MSG11:	DB	'EPROM COMPARE ERROR!',CR,LF,'$'


PRTMSG:	MVI	C,WCONB	; PRINT MESSAGE ON CONSOLE
	CALL	BDOS
	RET

INHEX:	CALL	INCH
	SBI	'0'
	JC	INHEX2
	CPI	10
	JC	INHEX1
	SBI	'@'-'9'
INHEX1:	CPI	16
	JNC	INHEX2
	ORA	A
	RET

INHEX2:	XRA	A
	STC
	RET

INCH:	PUSH B ! PUSH D ! PUSH H
	MVI	C,RCON
	CALL	BDOS
	POP H ! POP D ! POP B
	RET

; STORAGE ALLOCATIONS

BEGPRM:	DS	2	; EPROM START ADDRESS
ENDPRM:	DS	2	; EPROM END ADDRESS
SPSAV:	DS	2	; CP/M STACK POINTER
	DS	128	; PROGRAM STACK AREA
STACK:	DS	2

	END
