;---------------------------------------------------------
; PRINT BASIC-E SYMBOL TABLE
;
; SYMPRT-E.ASM  -  VERSION 0.1  -  5 NOV 77
;
; JEFFREY W. SHOOK, PO BOX 185, ROCKY POINT, NY 11778
;
;------------------------------------------------------

;    THIS PROGRAM PRINTS THE SYMBOL TABLE LEFT IN
; MEMORY BY THE BASIC-E COMPILER VERSION K2.0.
; EACH ENTRY IN THE TABLE IS FORMATTED AS FOLLOWS:
;
;	#   USE              BYTES
;
;	1)  LABEL LENGTH     1
;	2)  PARAMETER 1      2
;	3)  SYMBOL NAME      N
;	4)  ENTRY TYPE       1
;	5)  PARAMETER 2      2
;       6)  UNUSED           1


; EACH TABLE ENTRY IS PRINTED IN THE FOLLOWING FORMAT:

; TBLADR / NAMELEN / PARAM1 / ENTTYP / PARAM2 / SYMBOLNAM

;	TBLADR      = ADDRESS OF ENTRY IN MEMORY
;	NAMLEN      = NUMBER OF BYTES IN SYMBOL NAME
;	PARAM1      = POINTER TO RELATED ENTRY
;	ENTTYP      = TYPE OF ENTRY
;	PARAM2      = ?
;	SYMBOLNAM   = SYMBOL NAME

;    ENTRIES IN THE SYMBOL TABLE WHICH WERE
; MADE AUTOMATICALLY BY THE COMPILER ARE SHOWN AS AN
; OCTOTHORPE " # " FOLLOWED BY A 2 DIGIT HEXIDECIMAL
; NUMBER.
;    ENTRY TYPE CODES ARE AS FOLLOWS:
;
;	1) " H " = LINE NUMBER REFERENCE
;	2) " @ " = SYMBOL
;	3) " D " = ???


BDOS	EQU	5
WCON	EQU	2
WCONB	EQU	9
CR	EQU	0DH
LF	EQU	0AH
SYMTBL	EQU	3044H	; START ADDRESS OF SYMBOL TABLE

	ORG	100H

SYMPRT:
	LXI	H,0
	DAD	SP
	SHLD	SPSAV
	LXI	SP,STACK
	LXI	D,TITLM
	MVI	C,WCONB
	CALL	BDOS
	LXI	H,SYMTBL
SYMPR1:
	MVI	B,32
	CALL	OUTHHL	; PRINT ENTRY ADDRESS
	CALL	OUTS
	CALL	OUTHMI	; PRINT LABEL SIZE
	CALL	OUTS
	CALL	OUTMAIS	; PRINT FIRST PARAMETER
	PUSH	H
SYMPR9:
	MOV	A,M	; SKIP OVER LABEL
	ORA	A
	INX	H
	JP	SYMPR9
	SBI	40H	; PRINT ENTRY TYPE CODE
	CALL	OUTCH
	CALL	OUTS
	CALL	OUTMAIS	; PRINT SECOND PARAMETER
	CALL	OUTS
	CALL	OUTS
	POP	H
	MOV	A,M	; CHECK FOR GENERATED LABEL
	CPI	17H
	JZ	SYMPR8
SYMPR2:
	MOV	A,M	; PRINT LABEL
	ORA	A
	JM	SYMPR3
	INX	H
	CALL	OUTCH
	DCR	B
	JNZ	SYMPR2
	LHLD	SPSAV
	SPHL
	JMP	BDOS	; RETURN TO CP/M


SYMPR3:
	CALL	CRLF	; END LINE AND MOVE PTR TO NEXT ENTRY
	INX	H
	INX	H
	INX	H
	INX	H
	JMP	SYMPR1

SYMPR8:
	INX	H	; PRINT GENERATED LABEL
	MVI	A,'#'
	CALL	OUTCH
	CALL	OUTS
	CALL	OUTHMI
	JMP	SYMPR3


;++++++++++++++++++++++++++++++++++++++++++++++
;
; HEXIDECIMAL REGISTER OUTPUT
;
; HEXOUT.LIB  -  VERSION 0.2  -  12 SEP 77
;
;++++++++++++++++++++++++++++++++++++++++++++++

; FUNCTIONS AVAILABLE:
;
;	OUTHR	PRINT RIGHT HEX DIGIT FROM A
;	OUTHL	PRINT LEFT HEX DIGIT FROM A
;	OUT2H	PRINT 2 HEX DIGITS FROM A
;	OUTHM	PRINT M
;	OUTHMI	PRINT M ; HL <+ HL - 1
;	OUTHMD	PRINT M ; HL <- HL - 1
;	OUTH2M	PRINT M ; HL <- HL - 1
;		PRINT M ; HL <- HL - 1
;	OUTHHL	PRINT HL

OUTHHL:	MOV	A,H	; PRINT HL
	CALL	OUT2H
	MOV	A,L
	JMP	OUT2H

OUTH2M:	CALL	OUTHMD	; PRINT 2 BYTES POINTED BY HL
OUTHMD:	MOV	A,M
	DCX	H
	JMP	OUT2H

OUTHMI:	MOV	A,M
	INX	H
OUT2H:	PUSH	PSW
	CALL	OUTHL
	POP	PSW
	JMP	OUTHR

OUTHL:	RRC
	RRC
	RRC
	RRC
OUTHR:	ANI	0FH
	ADI	'0'
	CPI	'9'+1
	JC	OUTHR1
	ADI	'@'-'9'
OUTHR1:	JMP	OUTCH

CRLF:
	MVI	A,0DH
	CALL	OUTCH
	MVI	A,0AH
	CALL	OUTCH
	RET



OUTMAIS:
	PUSH	D
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	PUSH	H
	XCHG
	CALL	OUTHHL
	POP	H
	POP	D
	CALL	OUTS
	RET

OUTHMIS:
	CALL	OUTHMI
OUTS:
	MVI	A,' '
OUTCH:
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,WCON
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET

TITLM:	DB	CR,LF,'BASIC-E SYMBOL TABLE',CR,LF,CR,LF,'$'

SPSAV:	DS	2
	DS	128
STACK:

	END

