;************************************************************
;ORIGINAL BY RICH ROTH
;TERRAN SIECH ASSOCIATES
;(203) 438-3954
;5 NORTH SALEM RD.
;RIDGEFIELD
;CT.	06877
;
;NOTE: A.R.G. ADDED A COUPLE OF SUB-ROUTINES WHICH WERE
;EXTERNALS RESOLVED BY RICH'S LOADER.
;
;REMEMBER GOOD BITS BY ROTH.
;
;************************************************************
;
;	EXTENDED STATUS PROGRAM WITH DIRECTORY
;
; LINK:  XSTAT /I  SYSLIB(BINDB,BINH2)
;
; SCHEME: 1) EXPAND ALLOCATION VECTOR TO 1 BYTE PER BIT, IN 'ALCBF'
; EACH REPRESENTING A 1K CLUSTER OF 8 CONTINGIOUS SECTORS. 
; EACH WITH MSB SET INDICATES AN ALLOCATED, BUT UNCLAIMED
; SECTOR. 
; FOR EACH DIRECTORY ENTRY DO
;     FOR EACH CLUSTER DO
;	IF THAT CLUSTER IS ALLOCATED & FREE (=80H)
;		THEN CLAIM BY FILLING IN DIRECTORY ENTRY NUMBER ;
;
;	ELSE	IF CLUSTER ISN'T ALLOCATED (=0)
;		THEN ERROR('NOT ALLOCATED')
;
;	ELSE	IF CLUSTER IS CLAIMED(=1..64)
;		THEN ERROR('LINKED CLUSTER')
;
; ON ERRORS: USE 'PRTFIL' TO CONVERT FILE NUMBER(1..64)
;	TO NAME FROM DIRECTORY BUFFER
;
;
;NO EXTERNALS ALLOWED - A.R.G.
;	EXT	BINDB,BINH2	; DECIMAL, HEX PRINT
;
BDOS	EQU	5 
FCBRC	EQU	15	; FCB RECORD COUNT
CR	EQU	13
LF	EQU	10
DLR	EQU	'$'
;
;NOT RELOCATABLE, SO FIX LOAD
	ORG	100H
START:	LXI	H,0
	DAD	SP
	SHLD	SAVSP
;
	LXI	SP,STACK
;
;
	MVI	C,27
	CALL	BDOS	; GET DISK ALLOCATION VECTOR
	LXI	H,ALCBF
	MVI	E,32
;
ALP1:	MVI	D,8
	LDAX	B
;
ALP2:	PUSH	PSW	; DECOODE EACH BIT
	ANI	80H
	MOV	M,A
	INX	H
	POP	PSW
	RLC
	DCR	D
	JNZ	ALP2
;
	INX	B
	DCR	E
	JNZ	ALP1
;
;	COUNT SPACE LEFT
; SKIP 1ST 2 CLUSTERS (THEY ARE THE DIRECTORY PROPER)
;
	LXI	H,ALCBF+2
	LXI	B,240
ALP3:	MOV	A,M
	ORA	A
	JNZ	ALP4
	INR	B
ALP4:	INX	H
	DCR	C
	JNZ	ALP3
	MOV	C,B
	MVI	B,0
	LXI	H,SPCNT
	CALL	BINDB
	LXI	D,SPCNT
	CALL	PRTLIN
;
;
;	READ IN THE DIRECTORY
;
	LXI	D,DIRBF
	PUSH	D
	MVI	C,26
	CALL	BDOS	; SET DMA FOR DIR
	LXI	D,QUEFIL
	MVI	C,17
	CALL	BDOS	; FIRST FILE
	CPI	255
	JZ	FDNE	; NO FILES
;
RDDIR:	LXI	D,QUEFIL
	MVI	C,18
	CALL	BDOS	; NEXT FILE
	CPI	255
	JZ	RDDNE
	ANI	3
	CPI	3	; FILE # MOD 3 =3
	JNZ	RDDIR
	POP	D	; THEN INRECMENT DIR BUFF
	LXI	H,80H
	DAD	D
	XCHG
	PUSH	D
	MVI	C,26
	CALL	BDOS	; NEXT DIR BLOCK
	JMP	RDDIR
;
FDNE:	LXI	D,NOFIL
	MVI	C,9
	CALL	BDOS
GRTN:	LHLD	SAVSP
	SPHL
	RET
;
NOFIL:	DB	' NO FILES ON DISK',CR,LF,DLR
;
;
RDDNE:	POP	D
;
;	LOG AND REPORT ON EACH FILE
;
	LXI	H,DIRBF
	XRA	A
	STA	FILCNT
	STA	FDCNT
;
NXFIL:	SHLD	CRDIR		;  NEXT FILE  , SAVE CURR. DIR ENTRY
	LDA	FDCNT
	INR	A
	STA	FDCNT
	MOV	A,M
	CPI	0E5H	
	JZ	NXBK2		; DONE
	LDA	FILCNT
	INR	A
	STA	FILCNT
	MOV	A,M
;
	LXI	D,FCBRC
	DAD	D
	MOV	A,M	; CLUS. CNT:=INT((RECORD-1)/8)+1
	ORA	A
	JNZ	NXBK1	; CHECK FOR NULL FILES
	DCX	H
	DCX	H
	DCX	H
	MOV	A,M
	ORA	A	; IF FIRST EXTENT
	JNZ	NXB1A	; THEN PRINT 'NULL FILE'
	LDA	FDCNT
	CALL	PRTFIL
	LXI	D,NULFIL
	CALL	PRTLIN
NXB1A:	JMP	NXBK2
NXBK1:	DCR	A
	ANI	0F8H
	RRC
	RRC
	RRC
	INR	A
	MOV	C,A
;
NXBLK:	INX	H	; NEXT CLUSTER IN FILE
	PUSH	H
	MOV	E,M
	MOV	B,E
	MVI	D,0
	LXI	H,ALCBF
	DAD	D		; CHECK ALLOCATION
	MOV	A,M
	PUSH	H
;
	ORA	A
	JNZ	NXBKA
	LXI	D,NOTALC
	CALL	PRTBLK
	JMP	NXBKB
;
NXBKA:	ANI	7FH
	JZ	NXBKC
	LXI	D,BLKLNK	; LINKED CLUSTER
	CALL	PRTBLK
	POP	H
	MOV	A,M
	PUSH	H
	CALL	PRTFIL		; ORIG FILE
;
NXBKB:	LDA	FDCNT
	CALL	PRTFIL
	CALL	NEWLIN
;
NXBKC:
	LDA	FDCNT
	POP	H
	MOV	M,A		; ASSIGN CLUSTER TO FILE
;
	POP	H
	DCR	C
	JNZ	NXBLK
;			NEXT FILE
NXBK2:	LHLD	CRDIR
	LXI	D,32
	DAD	D
	LDA	FDCNT
	CPI	64
	JM	NXFIL
;
	LDA	FILCNT
	MOV	C,A
	MVI	B,0
	LXI	H,FILECNT
	CALL	BINDB
	LXI	D,FILECNT
	CALL	PRTLIN
	JMP	GRTN
;
PRTBLK:	PUSH 	PSW
	PUSH	B
	PUSH	D
	XCHG
	MOV	A,B
	CALL	BINH2
	POP	D
	MVI	C,9
	CALL	BDOS
	POP	B
	POP	PSW
	RET
;
;	A=DIR ENTRY OF FILE (TO GET NAME)
PRTFIL:	PUSH	B	; PRINT FILE NAME
	PUSH	D
	PUSH	PSW
	DCR	A
	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,DIRBF
	DAD	D
	INX	H
	MVI	C,11
PRTF1:	PUSH	H
	PUSH	B
	MOV	E,M
	MVI	C,2
	CALL	BDOS
	POP	B
	POP	H
	INX	H
	DCR	C
	JNZ	PRTF1
	LXI	D,SPCS
	MVI	C,9
	CALL	BDOS	; SKIP SOME SPACES
	POP	PSW
	POP	D
	POP	B
	RET
;
NEWLIN:
	LXI	D,CRLF
PRTLIN:	PUSH	B
	MVI	C,9
	CALL	BDOS
	POP	B
	RET
;
;
;
SPCNT:	DB	'   K  BYTES LEFT',CR,LF,CR,LF,DLR
NOTALC:	DB	'00H   NOT ALLOCATED ',DLR
BLKLNK:	DB	'00H   LINKED CLUSTER  ',DLR
SPCS:	DB	'     ',DLR
NULFIL:	DB	'   NULL FILE',CR,LF,DLR
FILECNT:DB	'      DIRECTORY ENTRIES '
CRLF:	DB	CR,LF,DLR

CRDIR:	DS	2
FDCNT:	DB	0
FILCNT:	DB	0
QUEFIL:	DB	'?????????????'
SAVSP:	DS	2
;
;
	RAM
;
ALCBF:	DS	256	; CLUSTER ALLOCATION VECTOR
DIRBF:	DS	2048	; DIRECTORY SPACE 64 RECORDS OF 32 BYTES EA.
;
	DS	256
STACK	EQU	$
;
;************************************************************
;FOLLOWING ARE AMATEUR SUBROUTINES TO
;PERFORM THE MISSING FUNCTIONS. N.B. ORIGINAL
;AUTHOR HAS NO RESPONIBILITY FOR THESE
;
;************************************************************
;LOOKS LIKE NEED A BINARY TO DECIMAL ROUTINE
;TO PUT ASCII DECIMALS INTO M[HL], +1, AND +2
;FROM THE VALUE PASSED IN C
;
BINDB:	MOV	A,C	;PASSED IN C
	MVI	M,30H	;FIX HUNDREDS TO ZERO
	JMP	H2
;
H1:	INR	M	;ADD 1 TO HUNDREDS
H2:	SUI	100
	JNC	H1	;NO UNDERFLOW
	ADI	100	;IF UNDERFLOW ADD LAST BACK
	INX	H	;GO TO TENS
	MVI	M,30H	;SET TO ZERO
	JMP	T2
;
T1:	INR	M
T2:	SUI	10
	JNC	T1
	ADI	10
	INX	H	;GO TO UNITS
	MVI	M,30H
	JMP	U2
;
U1:	INR	M
U2:	SUI	1
	JNC	U1
	ADI	1
	RET
;
;************************************************************
;LOOKS LIKE WE NEED A BINARY TO HEX ROUTINE TO
;PUT HEX CHARACTERS INTO M[HL] AND +1 EQUIVALENT
;TO VALUE PASSED IN A
;
;
BINH2:	PUSH	PSW	;SAVE BYTE
	RRC
	RRC
	RRC
	RRC		;GET MOST SIGNIFICANT NIBBLE
	ANI	0FH
	CALL	PUTHEX
;
	INX	H
	POP	PSW
	ANI	0FH
	CALL	PUTHEX
	RET
;
PUTHEX:	ADI	30H	;0-9
	CPI	3AH
	JC	PUT2
	ADI	7	;A-F
PUT2:	MOV	M,A
	RET
;
;	END	START
