;
; TITLE		HEADER FOR REL.UTL   MOVE UP AND RELOCATE
; FILENAME	RELHDR.ASM
; AUTHOR	Robert A. Van Valzah   7/23/78
; LAST REVISED	R. A. V.   11/25/79
; REASON	ADDED LENGTH BYTE
;
;
BDOS	EQU	5
;
;
	ORG	100H
ENTRY:
	lhld	len	;get length of code to relocate
	mov	b,h	;copy length to reg bc
	mov	c,l
	xra	a	;set carry if len is not a 256
	sub	l	;boundry
	LDA	BDOS+2	;GET CURRENT SID BASE PAGE
	SbB	h	;CALCULATE BASE OF REL AS SID BASE -
			;LENGTH OF REL
	MOV	H,A	;DESTINATION ADDRESS -> HL
	MVI	L,0
	PUSH	H	;SAVE DEST FOR ENTRY WHEN RELOC IS DONE
	LXI	D,CODE0	;POINTER TO CODE ORGED FOR 0
	PUSH	B	;SAVE LENGTH
	PUSH	H	;SAVE DEST
MOVE:
	LDAX	D	;GET A BYTE FROM CODE 1 IMAGE
	MOV	M,A	;MOVE TO DEST
	INX	D	;BUMP CODE 1 POINTER
	INX	H	;BUMP DEST POINTER
	DCX	B	;MOVED WHOLE THING YET?
	MOV	A,B
	ORA	C
	JNZ	MOVE
	POP	H	;GET DEST BACK
	POP	B	;GET LENGTH BACK
	push	d	;push reloc table address to stack
	MOV	D,H	;BIAS IN REG D
NEWBYT:
	XTHL		;GET RELOC TBL ADR
	MOV	E,M	;KEEP A REL BYTE IN REG E
	INX	H	;BUMP RELOC TBL POINTER
	XTHL		;PUT TBL PTR BACK
RELBYT:
	MOV	A,E	;GET RELOC BYTE
	RLC		;MOVE A BIT INTO CARY
	MOV	E,A	;SAVE THE REST OF THE RELOC BITS
	JNC	NOREL	;BIT WAS 0, DON'T RELOCATE THIS BYTE
	MOV	A,D	;GET BIAS TO ADD
	ADD	M	;ADD TO BYTE FROM DEST
	MOV	M,A
NOREL:
	INX	H	;BUMP DEST POINTER
	DCX	B	;DONE WITH ALL BYTES?
	MOV	A,B
	ORA	C
	JZ	MOVEDONE ;YUP - VECTOR TO REL BASE
	MOV	A,L	;NOPE - TEST IF AT 8 BYTE BOUNDRY
	ANI  0000$0111B	;IF SO, TIME FOR A NEW BYTE FROM TABLE
	JNZ	RELBYT	;NOT AT BOUNDRY
	JMP	NEWBYT	;AT A BOUNDRY
MOVEDONE:
	POP	B	;REMOVE RELOC TBL ADR FROM STACK
	ret		;vector to base of now relocated code
;
	org	(($-1) and 0fff8h) + 8
;
code0:			;address where code orged for zero goes
bias	equ	$	;bias used to read code orged for zero
;
	org	$+26h	;displacement to length word
len	ds	2
;
	END	ENTRY
