/*
	Tabify
	written by Leor Zolman

	command format:
		tabify filename new_filename

	This program takes a text file and converts sequences
	of spaces into tabs wherever possible.

	Revised 2/1/81 to process "scount" when encountering
	an opening '"'; Ward C.
*/

#include "bdscio.h"
	int scount, column, ifd, ofd, i, c;
	char ibuf[BUFSIZ], obuf[BUFSIZ];
main(argc,argv)
char **argv;
{
	if (argc != 3) {
		printf("usage: tabify oldfile newfile\n");
		exit();
	}
	ifd = fopen(argv[1],ibuf);
	ofd = fcreat(argv[2],obuf);
	if (ifd == ERROR || ofd == ERROR) {
		printf("Can't open file(s)\n");
		exit();
	}

	scount = column = 0;

	do {
		c = getc(ibuf);
		if (c == ERROR) {
			putc(CPMEOF,obuf);
			break;
		 }
		switch(c) {
		   case '\r':	putc1(c,obuf);
				scount = column = 0;
				break;
		   case '\n':	putc1(c,obuf);
				scount = 0;
				break;
		   case ' ':	column++;
				scount++;
				if (!(column%8)) {
				   if (scount > 1)
					putc1('\t',obuf);
				   else
					putc1(' ',obuf);
					scount = 0;
				 }
				break;
		   case '\t':	scount = 0;
				column += (8-column%8);
				putc1('\t',obuf);
				break;
		   case '"':	outspc('"');
				do {
				   c = getc(ibuf);
				   if (c == ERROR) {
				    printf("Quote error.\n");
				    exit();
				   }
				   putc1(c,obuf);
				} while (c != '"');
				do {
					c = getc(ibuf);
					putc1(c,obuf);
				} while (c != '\n');
				column = scount = 0;
				break;
		   case 0x1a:	putc(CPMEOF,obuf);
				break;
		   default:	outspc(c);
				column++;
		 }
	 } while (c != CPMEOF);

	fflush(obuf);
	fclose(ibuf);
	fclose(obuf);
}

outspc(c)	/* output any stored spaces */
char c;
{	for (i=0; i<scount; i++)
		putc1(' ',obuf);
	scount = 0;
	putc1(c,obuf);
}

putc1(c,buf)
char c;
{
	putchar(c);
	if (putc(c,buf) < 0) {
		printf("putc just retured an error!\n");
		exit();
	}
}

