;
;		    MLIST.ASM - V3.0
;		by Keith Petersen, W8SDZ
;		    (revised 5/20/80)
;
; This program lists any size ASCII file by name, reading
; up to 16k of the file into memory at one time, in order
; to minimize disk activity during printout.
;
; Allows listing of multiple files by using
; normal CP/M ambiguous file names (i.e.,
; MLIST *.ASM).  Before each file is printed,
; the FILENAME.TYPE is displayed.
;
; Use CTL-S to pause, CTL-C to abort.
; Other characters are ignored.
;
; NOTE: REQUIRES 'MAC' AND SEQIO.LIB TO ASSEMBLE
;
	ORG	100H
;
	MACLIB	SEQIO	;DEFINE MACRO LIBRARY
;
START:	JMP	START2	;JMP AROUND IDENT
	DB	'MLIST.COM ver 3.0 5/20/80 '
;
START2:	LXI	H,0
	DAD	SP	;GET OLD STACK
	SHLD	OLDSTK	;SAVE IT
	LXI	SP,STACK  ;SET NEW STACK
	LHLD	1	;POINT TO CP/M'S JMP TABLE
	LXI	D,3	;READY FOR ADD
	DAD	D	;POINT TO CONSOLE STATUS
	SHLD	CSTSC+1	;MODIFY CALL ADDRESS
	DAD	D	;POINT TO CONSOLE INPUT
	SHLD	CIC+1	;MODIFY CALL ADDRESS
	CALL	SIGNON	;PRINT SIGNON MSG
	DB	'MLIST ver 3.0',CR,LF
	DB	'CTL-S to pause, CTL-C to abort'
	DB	CR,LF,'$'
;
SIGNON:	POP	D	;GET MESSAGE POINTER
	MVI	C,PRINT
	CALL	BDOS	;PRINT IT
	LDA	FCB+1
	CPI	' '	;SEE IF FILENAME THERE
	JNZ	MORE
	CALL	MSGEXIT
	DB	'++NO FILE NAME SPECIFIED++',CR,LF,'$'
;
MORE:	CALL	MFNAME
	JC	EXIT
;MOVE FILENAME FROM FCB+1 TO FNAME
	LXI	H,FCB+1
	LXI	D,FNAME
	LXI	B,8
	CALL	MOVER
;MOVE FILETYPE FROM FCB+9 TO FNAME+9
	LXI	H,FCB+9
	LXI	D,FNAME+9
	LXI	B,3
	CALL	MOVER
	CALL	MORE2	;GO PRINT FILENAME.TYP
	DB	CR,LF,CR,LF,'--> FILE:  '
FNAME:	DB	'XXXXXXXX.XXX'
	DB	CR,LF,CR,LF,'$'
;
MORE2:	POP	D	;GET MSG ADRS
	MVI	C,PRINT	;PRINT IT
	CALL	BDOS
;
; DEFINE SOURCE FILE:
;
;	INFILE	= INPUT FILE MODE
;	DISK$IN = INTERNAL NAME
;	(NUL)	= DEFAULT DISK DRIVE
;	1	= FIRST DEFAULT NAME (TFCB)
;	(NUL)	=   "      "    TYPE
;	16384	= BUFFER SIZE
;	DSK$BUF	= DISK BUFFER AREA
;
	FILE	INFILE,DISK$IN,,1,,16384,DSK$BUF
;
;WRITE THE FILE TO CONSOLE
;
READLP:	GET	DISK$IN
	CPI	EOF	;END OF FILE?
	JZ	MORE	;YES, MORE FILES TO PRINT?
	CALL	TYPE	;SEND CHAR TO CONSOLE
	CALL	CSTS	;KEY PRESSED?
	ORA	A
	CNZ	CKKB	;CHECK WHAT KEY
	JMP	READLP
;
CKKB	CALL	CI	;SEE WHAT CHAR
	CPI	'S'-40H	;CTL-S?
	CZ	CI	;YES, GET VALUE
	CPI	'C'-40H	;ABORT?
	JZ	EXIT
	RET
;
CSTS	PUSH	B
	PUSH	D
	PUSH	H
CSTSC	CALL	$-$	;CHANGED BY INIT
	POP	H
	POP	D
	POP	B
	RET		;FROM "CSTS"
;
CI	PUSH	B
	PUSH	D
	PUSH	H
CIC	CALL	$-$	;CHANGED BY INIT
	POP	H
	POP	D
	POP	B
	RET		;FROM "CI"
;
;TYPE CHAR IN A
;
TYPE:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A	;GET CHARACTER
	MVI	C,WRCON
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
;EXIT WITH ERROR MESSAGE
;
MSGEXIT:
	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
	CALL	TYPE
	POP	D	;GET MSG
	MVI	C,PRINT	;PRINT IT
	CALL	BDOS
;
EXIT:	MVI	C,STDMA	;SET DMA ADR TO NORMAL
	LXI	D,80H
	CALL	BDOS
	LXI	D,DONEMS ;POINT TO DONE MSG
	MVI	C,PRINT
	CALL	BDOS	;PRINT IT
	LHLD	OLDSTK	;GET OLD STACK
	SPHL		;RESTORE IT
	RET		;RETURN TO CP/M
;
DONEMS:	DB	CR,LF,CR,LF,'DONE$'
;
;MULTI-FILE ACCESS SUBROUTINE.  ALLOWS PROCESSING
;OF MULTIPLE FILES (I.E. *.ASM) FROM DISK.  THIS
;ROUTINE BUILDS THE PROPER NAME IN THE FCB EACH
;TIME IT IS CALLED. CARRY IS SET IF NO MORE NAMES
;CAN BE FOUND. THE ROUTINE IS COMMENTED IN PSEUDO
;CODE, EACH PSEUDO CODE STATEMENT IS IN <<...>>
;
MFNAME:	;<<INIT DMA ADDR, FCB>>
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,STDMA
	LXI	D,80H
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	XRA	A
	STA	FCBEXT
	STA	FCBRNO
;<<IF FIRST TIME>>
	LDA	MFFLG1
	ORA	A
	JNZ	MFN01
;<<TURN OFF 1ST TIME SW>>
	MVI	A,1
	STA	MFFLG1
;<<SAVE THE REQUESTED NAME>>
;SAVE ORIG REQ
	LXI	H,FCB
	LXI	D,MFREQ
	LXI	B,12
	CALL	MOVER
	LDA	FCB
	STA	MFCUR	;SAVE DISK IN CURR FCB
;<<SRCHF REQ NAME>>
	LXI	H,MFREQ
	LXI	D,FCB
	LXI	B,12
	CALL	MOVER
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SRCHF
	LXI	D,FCB
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;<<ELSE>>
	JMP	MFN02
;
MFN01:	;<<SRCHF CURR NAME>>
	LXI	H,MFCUR
	LXI	D,FCB
	LXI	B,12
	CALL	MOVER
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SRCHF
	LXI	D,FCB
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;<<SRCHN REQ NAME>>
	LXI	H,MFREQ
	LXI	D,FCB
	LXI	B,12
	CALL	MOVER
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SRCHN
	LXI	D,FCB
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;<<ENDIF>>
MFN02:	;<<RETURN CARRY IF NOT FOUND>>
	INR	A
	STC
	RZ
;<<MOVE NAME FOUND TO CURR>>
	DCR	A
	ANI	3
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	ADI	81H
	MOV	L,A
	MVI	H,0
	PUSH	H	;SAVE NAME POINTER
	LXI	D,MFCUR+1
	LXI	B,11
	CALL	MOVER
;<<MOVE NAME FOUND TO FCB>>
	POP	H
	LXI	D,FCB+1
	LXI	B,11
	CALL	MOVER
;<<SETUP FCB>>
	XRA	A
	STA	FCBEXT
	STA	FCBRNO
;<<RETURN>>
	RET
;------------------------------------------------
;
;MOVE SUBROUTINE
;
MOVER	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVER
	RET
;
;MULTI-FILE ACCESS WORK AREA
;
MFFLG1	DB	0	;1ST TIME SW
MFREQ	DS	12	;REQ NAME
MFCUR	DS	12	;CURR NAME
;
	DS	60	;STACK AREA
STACK:	EQU	$
OLDSTK:	DS	2	;OLD STACK POINTER SAVED HERE
;
DSK$BUF:DS	16384	;16K BUFFER
;
;BDOS/CBIOS EQUATES
;
WRCON	EQU	2
PRINT	EQU	9
SRCHF	EQU	17
SRCHN	EQU	18
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
FCBEXT	EQU	FCB+12
FCBRNO	EQU	FCB+32
;
	END
