	TITLE	'CCS 2810 - 2710 -  2422 Deblocked BIOS (V5.1) for CP/M 2.2'
;
	MACLIB	Z80
;
;	Version 5 BIOS
; Modified for Z80 unique instructions 6 Mar 82
; Modified sector skewing algorithm  15 Feb 82
; Modified for better placement of time delays  14 Feb 82
;	Version 4 BIOS
;MODIFIED FOR HEAD LOAD DELAY 16 DEC 80
;MODIFIED FOR PROPER UNIT/STPRAT CORRELATION 9 DEC 80
;MODIFIED FOR SEEK ERROR TRAPPING 10 DEC 80
;MODIFIED FOR NOT READY TRAPPING 11 DEC 80
;MODIFIED FOR MINI/MAXI CONDITIONALS 11 DEC 80
;	Version 3 BIOS
;MODIFIED FOR UNALLOCATED WRITE CORRECTIONS 8 SEP 80
;MODIFIED FOR AUTO-BOOT OPERATION 7 SEP 80
;MODIFIED FOR COMPUTED SKEW FACTORS 7 SEP 80
;MODIFIED FOR WARM BOOTS FROM MINIS 14 AUG 80
;MODIFIED FOR PROPER DEFAULT DISK RESTORAL ON WARM BOOT 12 AUG 80
;MODIFIED FOR 2 MHZ 8080 OPERATION 12 AUG 80
;
;THIS BIOS IS SET UP FOR AUTO SELECT OF DISK CHAR
;
;"BIAS" IS ADDRESS OFFSET FROM 2C00H FOR MEMORY SYSTEMS
;THAN 20K (REFERRED TO AS "B" THROUGHOUT THE TEXT).
;
TRUE	EQU	0FFFFH
FALS	EQU	NOT TRUE
;
BVERS	EQU	51	;BIOS version number
VERS	EQU	22	;CP/M version number
MSIZE	EQU	64	;CP/M memory size kilobytes
BIAS	EQU	(MSIZE-20)*1024
CCP	EQU	2C00H+BIAS
CCPV	EQU	CCP		;CCP vector
BDOS	EQU	CCP+806H	;Base of BDOS
BIOS	EQU	CCP+1600H	;Base of BIOS
;
; Drive environment definition
;
NDISKS	EQU	4	;Number of drives suported
;
MAXI	EQU	TRUE	;8" Drive support
DS8	EQU	TRUE	;Double Sided 8" support
;
MINI	EQU	TRUE	;5.25" Drive support
DS5	EQU	FALS	;Double Sided 5.25" support
;
BOTH	EQU	MINI and MAXI
;
; If 5.25" drives are supported, the number of tracks must be
;	specified.  Valid options are 35, 40, or 80 tracks.
;	One and only one of the equates must be TRUE.
;
T35	EQU	FALS	;35 Track drives in use
T40	EQU	TRUE	;40 Track drives in use
T80	EQU	FALS	;80 Track drives in use
;
; Step rates may be tailored for individual drive requirements.
;	To do so, determine the proper track-to-track step rates
;	from the technical manual for the drive, and set STEP5
;	(for MINIs) and/or STEP8 (for MAXIs) to the value shown
;	in the following table:
;
;	Value		MINIs (5.25")	MAXIs (8")
;	  0		  6 ms		  3 ms
;	  1		 12 ms		  6 ms
;	  2		 20 ms		 10 ms
;	  3		 30 ms		 15 ms
;
STEP5	EQU	3	;MINI disk step rate
STEP8	EQU	1	;MAXI disk step rate
;
; 2422 Multimode Floppy Disk Controller Equates
;
DSTAT	EQU	30H	;Disk status port
;
TRK0	EQU	4
;
DCMD	EQU	DSTAT	;Disk command port
DTRK	EQU	DSTAT+1	;Disk track port
DSCTR	EQU	DSTAT+2	;Disk sector port
DDATA	EQU	DSTAT+3	;Disk data port
DSTAT1	EQU	DSTAT+4	;Disk flag port
;
AUTBOT	EQU	40H
HLMSK	EQU	20H
;
DCTRL1	EQU	DSTAT+4	;Disk control port
;
AWBIT	EQU	80H
DDENS	EQU	40H
MOTOR	EQU	20H
DRV8	EQU	10H
;
DCTRL2	EQU	4	;Disk control 2 port
;
SIDE0	EQU	40H	;Side 0 select bits
SIDE1	EQU	0	;Side 1 select bits
;
DSTAT2	EQU	DCTRL2
;
TWOSID	EQU	40h
MINI2	EQU	2
;
;1793 Type I Commands
;
RSTR	EQU	8	;Basis of restore command
SEEKV	EQU	1CH	;Basis of seek command
STEPI	EQU	58H	;Basis of step in command
TP1MSK	EQU	0FCH
;
;1793 Type II Commands
;
RDSEC	EQU	88H	;Basis of read sector command
WRSBIT	EQU	20H
RSMSK	EQU	9CH
;
;1793 Type III Commands
;
RDADD	EQU	0C4H	;Read address command
;
;The following time delay constants assume 40 "ticks" per
;	millisecond.  This is true for the time delay
;	subroutine when running at 4 mhz and no wait states.
;	For other system clock rates, the value of TICKPMS
;	(ticks per millisecond) should be adjusted accordingly.
;	For instance, TICKPMS should be 20 for 2 mhz (no waits)
;	operation.
;
TICKPMS	EQU	40
;
SETTL	EQU	8*TICKPMS
MHLWAIT	EQU	75*TICKPMS-SETTL	;Head load wait for 5" drives
HLWAIT	EQU	35*TICKPMS-SETTL	;Head load wait for 8" drives
MOWAIT	EQU	1000*TICKPMS-SETTL	;Motor on wait for MINIs
;
TRIES	EQU	10	;Number of attempts
;
; Deblock Parameters
;
WRALL	EQU	0
WRDIR	EQU	1
WRUAL	EQU	2
;
;	General System equates
;
CTRLC	EQU	3	;ASCII ETX
BELL	EQU	7	;ASCII bell chatacter
CR	EQU	0DH	;ASCII carriage return
LF	EQU	0AH	;ASCII line feed
;
WBOOTV	EQU	0
IOBYTE	EQU	3	;IOBYTE location
CDisk	EQU	4	;Current drive
BDOSV	EQU	5	;BDOS vector location
DISKNO	EQU	40H	;Active drive number
SIDE	EQU	DISKNO+1 ;Side select storage location
SECTOR	EQU	DISKNO+2
TRACK	EQU	DISKNO+3
SPT	EQU	DISKNO+4
STATUS	EQU	47H
CMND	EQU	STATUS+1
LUNIT	EQU	49H	;Last used drive
CUNIT	EQU	LUNIT+1	;Current drive
RWFLG	EQU	4BH	;Read/Write sector flag
HSTBUF	EQU	4CH	;Host buffer address
IDSV	EQU	4EH	;Sector ID storage location
TBUF	EQU	80H
;
	ORG	BIOS	;Origin of this program
;
; Jump Vectors for individual subroutines
;
	JMP	BOOT	;Cold start
WBOOTE:	JMP	IBOOT	;Warm start
	JMP	CONST	;Console status
	JMP	CONI	;Console character in
	JMP	CONOUT	;Console character out
	JMP	LIST	;List character out
	JMP	PUNCH	;Punch character out
	JMP	READER	;Reader character in
	JMP	HOME	;Home drive head
	JMP	SELDSK	;Select disk
	JMP	SETTRK	;Set track number
	JMP	SETSEC	;Set sector number
	JMP	SetDMA	;SET DMA address
	JMP	READ	;Read disk
	JMP	WRITE	;Write disk
	JMP	LISTST	;Return list status
	JMP	SECTRAN	;Sector translate
;
; Step rate storage
;
STP8:	DB	STEP8
STP5:	DB	STEP5
;
;Initial IOBYTE storage area
;
IIOBYT:	DW	IOBYT	;Initial IOBYTE, default drive
;
;Baud rate constants
;
BAUDC:	DW	12	;Console baud rate = 9,600
BAUD0:	DW	12	;Serial port 0 buad rate = 9,600
BAUD1:	DW	12	;Serial port 1 buad rate = 9,600
;
; Individual subroutines to perform each function
;
WBOOT0:	DCR	C	;Decrement retry counter
	JRNZ	WBOOT1	;Retry to read system again
	LXI	H,BOTMSG
	CALL	PRTRD	;Print boot error message
	CALL	PRTWA
WBOOT:	LXI	SP,TBUF	;Put stack at safe area
	MVI	C,TRIES	;Set number of retries
WBOOT1:	LXI	H,SIDE0 shl 8	;Set drive, side 0
	SHLD	DISKNO
	LXI	H,2
	SHLD	SECTOR	;Set sector 2, track 0
	PUSH	B
	MOV	C,H	;Select unit 0
	MOV	E,H	;Insure drive gets logged in
	CALL	SELDSK
	POP	B
	LXI	H,CCP
	SHLD	HSTBUF
	LDA	PRMTBL+1
	STA	CUNIT

	IF	MAXI
	MVI	B,26	;Hold SPT in (B)
	ENDIF

	IF	BOTH
	ANI	DRV8	;Isolate MINI/MAXI bit
	JRNZ	WBOOT3	;Jump if 8"
	ENDIF

	IF	MINI
	MVI	B,18	;Set MINI SPT
	ENDIF

WBOOT3:	PUSH	B
	CALL	DREAD	;Go read a sector
	POP	B
	ORA	A
	JRNZ	WBOOT0	;Bad read, try again
	SHLD	HSTBUF
	MOV	D,H	;Save page address
	LXI	H,SECTOR ;Point to sector hold
	MOV	A,M	;See if ready for next track
	SUB	B
	JRC	WBOOT4
	MOV	M,A	;Reset sector count
	INX	H	;Point to track
	INR	M	;Advance it
	DCX	H	;Point back to sector
	LDA	PRMTBL+1

	IF	BOTH
	MOV	E,A	;Save selbits
	ANI	DRV8	;See if MINI or MAXI
	JRNZ	WBOOT4	;Current value good for MAXI, jump
	MOV	A,E	;Get selbits
	ENDIF

	IF	MINI
	ANI	DDENS	;See if double density
	JRNZ	WBOOT4	;Current value OK if DDEN set
	LDA	PRMTBL+2	;Get sector size indicator
	DCR	A	;See which size
	JM	WBOOT4	;Jump if 128 byte sectors
	MVI	B,10	;SPT for 256 byte sectors
	JRZ	WBOOT4
	MVI	B,5	;SPT for 512 byte sectors
	ENDIF

WBOOT4:	INR	M
	LDA	PRMTBL+2	;See if enough loaded in
	ADD	D
	SUI	BIOS/256
	JRC	WBOOT3	;Jump if more needed
;
; End of load operation, set parameters and go to CP/M
;
BOOT0:	XRA	A
	LXI	H,PRMTBL+3
	MVI	B,3*(NDISKS-1)	;Zero out PRMTBL
WBOOT2:	MOV	M,A
	INX	H
	DJNZ	WBOOT2
	MVI	A,JMP	;Get a JMP opcode
	STA	WBOOTV	;Reset jump vectors
	STA	BDOSV
	LXI	H,WBOOTE
	SHLD	WBOOTV+1
	LXI	H,BDOS
	SHLD	BDOSV+1
	LXI	H,DBUF	;Set up buffer address
	SHLD	HSTBUF
	LXI	H,TBUF	;Default DMA address is 80H
	SHLD	DMAAD
	MOV	L,H	;Insure all zeroes
	SHLD	HSTACT	;Host not active
	LXI	H,STP8	;Point to 8" step rate hold

	IF	BOTH
	MOV	A,E	;Get selbits
	ANI	DRV8
	JRNZ	BOOT1	;Jump if MAXI
	ENDIF

	IF	MINI
	INX	H	;Point to 5" step rate
	ENDIF

BOOT1:	MOV	A,M	;Get step rate
	STA	PRMTBL	;Set step rate
	LDA	CDISK
	MOV	C,A	;Send to CCP
	JMP	CCPV	;Go to CPM
;
; Select disk given by register C
;
SELDSK:	MOV	A,C
	STA	SEKDSK
	LXI	H,0	;Error return code
	CPI	NDISKS	;Must be between 0 and NDISKS-1
	RNC		;No carry if greater than NDISKS
; Disk number is in proper range
; Compute proper disk parameter header address
	MOV	L,A	;L = disk number 0,1,2,...,NDISKS
	DAD	H	;*2
	DAD	H	;*4
	DAD	H	;*8
	DAD	H	;*16 (size of each header)
	MOV	A,E	;Get new unit indicator bit
	RAR		;Test new unit bit
	PUSH	PSW
	LXI	D,DPBASE
	DAD	D	;HL=.DPBASE(DISKNO*16)
	PUSH	H
	CALL	FDSBA
	STA	SEKSEL
	POP	H
	POP	PSW
	MOV	A,C	;Return DISKNO
	RC		;Return if not new unit
	PUSH	B
	PUSH	H	;Save (H,L)
	LHLD	LUNIT	;Save current disk assignments
	PUSH	H
	LHLD	DISKNO
	PUSH	H	;Save unit and side
	MOV	L,C	;Move unit over
	MVI	H,SIDE0	;Select side 0
	SHLD	DISKNO
	MVI	A,0FFH
	STA	CUNIT	;Force read address
	CALL	IDRD	;Find out what is out there
	JRNZ	SELERR
	MOV	B,A	;Get sector size
	INR	B	;Prepare for later loop control
	DCX	H	;Point to selbits
	MOV	C,M	;Get them
	LXI	D,4	;Address table entry offset

	IF	MINI
	LXI	H,MSELTBL-4 ;MINI table address
	ENDIF

	IF	BOTH
	MOV	A,C
	ANI	DRV8	;Test MINI/MAXI bit
	JRZ	SELDSK1	;Jump if MINI
	ENDIF

	IF	MAXI
	LXI	H,SELTBL-4 ;Set 8" table address
	ENDIF

	IF	DS8
	IN	DSTAT2	;Check for double sided disk
	ANI	TWOSID	;Isolate two-sided bit
	JRNZ	SELDSK1	;Jump if single-sided
	LXI	H,SELTBLA-4
	ENDIF

SELDSK1: MOV	A,C	;Check for double density
	STA	SEKSEL
	ANI	DDENS	;Isolate density bit
	JRZ	SELDSK2	;Jump if single density
	DAD	D	;Offset to double density entries
	DAD	D
	DAD	D
	DAD	D
SELDSK2: DAD	D	;Offset table address
	DJNZ	SELDSK2
	XCHG		;Save pointer
	CMP	A	;Show no error
SELERR:	POP	H	;Restore current drive
	SHLD	DISKNO
	POP	H
	SHLD	LUNIT
	LXI	H,0	;Set up for error return
	XTHL
	JRNZ	SELDSK3	;Jump if select error
	POP	B	;Get rid of error return code
	PUSH	H	;Get and save DP block pointer
	XCHG
	CALL	MOVIT2
	PUSH	H	;Save it
	LXI	H,8
	DAD	D	;Offset pointer
	XCHG
	POP	H	;Get table address
	CALL	MOVIT2
SELDSK3: POP	H
	POP	B
	MOV	A,C
	RET
;
; Home drive to track 00
;
HOME:	MVI	C,0
;
; Set track given by register (C)
;
SETTRK:	MOV	A,C
	STA	SEKTRK
	RET
;
; Set sector given by register (C)
;
SETSEC:	LDA	SPT	;Get side indicator
	ORA	A
	LXI	H,SEKSID	;Point to side select
	MOV	B,A
	MOV	A,C
	MVI	M,SIDE0
	JRZ	SETSEC1	;Brif side 0
	SUB	B
	MVI	M,SIDE1
SETSEC1: DCR	A
	STA	SEKSEC
	RET
;
; Translate sector given in (BC) using table in (DE)
;
SECTRAN: PUSH	D	;Save table address
	MOV	A,C	;Get desired sector
	STA	CPMSEC
	CALL	PHYSC0	;Get parameter table address
	DCR	A	;Make physical sector relative 0
	POP	H	;Reget table address

	IF	DS8 or DS5
	CMP	M	;See if side 1
	JRC	SECT1	;Jump if side 0
	MOV	B,M	;Get sectors per track for side 1 indicator
	SUB	B
	ENDIF

SECT1:	PUSH	B
	MOV	C,M	;Get sectors per track
	INX	H	;Point to skew factor
	MOV	H,M	;Get skew factor
	MOV	B,A	;Set up to build skew
	INR	B	;Return to relative 1 number
	XRA	A	;Start with (-skew factor)
	MOV	E,A	;Initialize repetition count
	SUB	H
SECT2:	ADD	H	;Build sector number in (a)
	CMP	C	;See if time for wrap around
	JRC	SECT3	;Brif not
	SUB	C	;Do wrap around
	JRNZ	SECT3	;See if repeat pattern starting
	INR	E	;Keep number of repeats in (E)
SECT3:	DJNZ	SECT2	;Keep going until desired sector is built
	ADD	E	;Add on number of repeats
	MOV	L,A	;Save physical sector in (L)
	INR	A	;Make relative 1
	MOV	E,A	;Save for unalloc write anticipation logic
	POP	B	;Get side select
	MOV	H,B	;Move over to (H) for expansion
	MOV	B,D	;Move secmsk loop control over
	XRA	A
	CALL	SECMSK	;Convert physical to logical sector
	ANA	C	;Strip out subsector
	ORA	L	;Add to skewed sector
	ADD	H	;Add side bias
	MOV	L,A
	MOV	A,H	;Save bias for side select logic
	STA	SPT
	MOV	H,B	;Move zero over
	INR	L	;Make relative 1
	RET
;
SECMS1:	STC
	ADC	A	;Build mask
	DAD	H	;Offset sector number
SECMSK:	DJNZ	SECMS1	;Do it again
	RET
;
; Set DMA address given by register (BC)
;
SETDMA:	MOV	H,B
	MOV	L,C
	SHLD	DMAAD	;Save address
	RET
;
; Deblock Routines
;
WRITE:	MOV	A,C	;Write type from CP/M
	STA	WRTYPE
	LXI	H,UNACNT ;See if any unallocated space available
	CPI	WRUAL	;See if unallocated
	JRNZ	CHKUNA	;Jump if not
;
; Unallocated write, Set parameters
;
	PUSH	H
	CALL	PHYSEC	;Convert to physical sector
	LXI	D,UNADSK ;Point to destination
	CALL	MOVIT	;Do move
	CALL	DPFND	;Get DP table address
	POP	H
	INX	D	;Offset to block mask
	INX	D
	INX	D
	LDAX	D	;Get block mask
	INR	A	;(A) = logical records per block
	MOV	M,A	;Save sector count
CHKUNA:	XRA	A
	PUSH	PSW	;Save write indicator
	CMP	M
	JRZ	ALLOC1	;Jump if not
	DCR	M	;Use some of it
	CALL	PHYSEC	;Set physical sector
	LXI	D,UNADSK
	CALL	COMP	;Compare units
	JRNZ	ALLOC
	CALL	DPFND
	LDA	CPMSEC	;Get last logical sector
	INR	A
	XCHG		;DP table address to (HL)
	CMP	M	;See if track overflow
	JRNC	NXTSC2	;Jump if so
	LXI	H,-11	;Same track, now see which side/sector
	DAD	D
	MOV	E,M	;Get address of skew table
	INX	H
	MOV	D,M
	MOV	C,A	;Set up to call SECTRAN
	MVI	B,0
	CALL	SECTRAN	;Translate sector
	MVI	L,SIDE0	;Side 0 select

	IF	DS8 or DS5
	ORA	A	;Test side indicator (still in (A))
	JRZ	NXTSC1	;Jump if side 0
	MVI	L,SIDE1	;Set side 1
	ENDIF

NXTSC1:	MOV	H,E	;Set sector
	JMP	NXTSC3
;
NXTSC2:	LXI	H,UNATRK ;Set for next track
	INR	M
	LXI	H,100H+SIDE0 ;Side 0 sector 1
NXTSC3:	SHLD	UNASID	;Set next side, sector
	XRA	A	;Get a zero
	JMP	ALLOC2	;Go back to mainstream
;
READ:	MVI	A,WRUAL	;Treat read as unallocated
	STA	WRTYPE
	ORA	A	;Set flag for read operation
	PUSH	PSW
ALLOC:	XRA	A	;Allocated write requires preread
	STA	UNACNT
ALLOC1:	INR	A
ALLOC2:	STA	RSFLAG
	XRA	A	;Get a zero
	STA	ERFLAG	;Reset error flag
	LXI	H,HSTACT ;See if host active
	ORA	M
	MVI	M,1	;Mark it active for next time
	JRZ	FILHST	;Fill host buffer if empty
	CALL	PHYSEC	;Set physical sector
	PUSH	D	;SAVE SECTOR SIZE IN (D)
	LXI	D,DISKNO
	CALL	COMP	;Compare units
	JRZ	MATCH
	POP	D
	LDA	HSTWRT	;See if buffer's been writen to
	ORA	A
	CNZ	DWRITE	;Purge buffer if needed
FILHST:	CALL	PHYSEC
	PUSH	D	;Save sector size
	LXI	D,DISKNO ;Point to destination
	CALL	MOVIT
	LDA	SEKSEL
	STA	CUNIT
	LDA	RSFLAG	;See if we need to read disk
	ORA	A
	CNZ	DREAD	;Fill it if needed
	XRA	A	;Reset pending write flag
	STA	HSTWRT
MATCH:	POP	B	;Get sector size
	CALL	SECMSK	;Build sector mask
	LHLD	DMAAD	;Get DMA address
	XCHG		;Address to (DE)
	LHLD	SEKSEC
	ANA	L	;Find relative sector
	LXI	H,DBUF-80H ;Build address for CP/M sector
	LXI	B,128	;CP/M record size
MATCH2:	DAD	B
	DCR	A
	JP	MATCH2
	POP	PSW	;See if read or write
	JRNZ	RWMOVE	;Pointers OK if read
	XCHG		;Swap buffer pointers
	INR	A	;Mark write operation
	STA	HSTWRT
RWMOVE:	CALL	MOVIT1
	LDA	WRTYPE	;Get write type
	DCR	A	;See if directory entry
	LDA	ERFLAG	;Get error flag
	RNZ		;Done if not directory entry
	ORA	A	;See if any errors
	RNZ		;RETURN IF SO
	STA	HSTWRT	;RESET HOST WRITTEN
	JMP	DWRITE	;Update directory
;
; Move 4 byte strings from sekdsk
;
MOVIT:	LXI	H,SEKDSK ;Point to source
	MVI	C,4	;Move 4 bytes
	DB	LDA	;Dummy to skip next two bytes
MOVIT2:	MVI	C,2	;Move 2 bytes
MOVIT1:	MOV	A,M	;Get next byte
	STAX	D	;Store it
	INX	H
	INX	D
	DCR	C
	JRNZ	MOVIT1
	RET
;
; Find address of disk parameter table
;
DPFND:	LDA	SEKDSK	;FIND ADDRESS OF DP TABLE
	MOV	B,A
	INR	B
	LXI	H,DPBASE-6 ;DEVELOP ADDRESS OF DPTABLE
	LXI	D,16
DPFND1:	DAD	D
	DJNZ	DPFND1
	MOV	E,M	;Pull up address
	INX	H
	MOV	D,M
	RET
;
; Logical to physical sector translation routine
;
PHYSEC:	LDA	SEKSEC	;Get logical sector
	MOV	C,A	;Save sector
PHYSC0:	CALL	FDSBA	;Get PRMTBL pointer
	INR	D
	MOV	B,D
	MOV	A,C	;Get sector
	RAL
PHYSC1:	ORA	A	;Reset carry bit
	RAR		;Convert to physical sector
	DJNZ	PHYSC1
	INR	A	;(A) now has physical sector
	STA	SEKHST	;Set sector
	RET
;
; Compare units
;
COMP:	LXI	H,SEKDSK
	MVI	B,4
COMP1:	LDAX	D
	SUB	M
	RNZ		;Done if no compare
	INX	H	;Point to next entry
	INX	D
	DJNZ	COMP1
	RET
;
;
;FOLLOWING ROUTINES DO THE PRIMITIVE DISK ACCESSES.
;	IN ALL CASES, ONE SECTOR OF DATA IS TRANSFERRED.
;	IF THE DISK HAS NOT BEEN PREVIOUSLY ACCESSED,
;	THESE ROUTINES WILL AUTOMATICALLY DETERMINE THE
;	DISK TYPE (8" OR 5"), SINGLE OR DOUBLE DENSITY,
;	AND SECTOR SIZE.
;
;	BEFORE THE DESIRED DATA IS TRANSFERRED, THE DESIRED
;	TRACK IS SEEKED OUT, THE DESIRED SECTOR AND SIDE IS
;	SET, THEN THE ACTUAL D