PAGE 62
;ACIBSC1K.ASM
;ALSPA COMPUTER INC.   Double Density Floppy and Corvus BIOS  CPM2.2
;			- Supports CONSTELLATION I
;*************************************************
;This BIOS source code is designed to be assembled with ASM.COM
;*************************************************
;EDIT HISTORY:
;02/04/82		    Blocking added to ACIBSC, unresolveds fixed.
;02/10/82 - 02/12/82	3.0 Testing: Fix SECTRAN, BOOT, SELDSK.
;02/12/82 - 02/17/82	    Track select bug fixed.
;02/18/82		    Clock Write routine updated.
;02/25/82 - 03/01/82	3.2 Hold off disk chg until R/W/HOME.
;03/03/82		3.3 Disk change (Dbl-Sd PIP[V]) problem fixed.
;03/10/82		    IBM format B: supported, printer assembly option.
;03/16/82		    SYSFMT generated from IOBYTE, IOBYTE=CPM standard.
;03/17/82 - 03/26/82	    Clock routines updated, I/O routines re-done.
;03/29/82		3.4 Single-Drive 'INSERT B:' msg removed.
;03/31/82 - 04/08/82	    Constellation I added.
;04/13/82 - 04/15/82 	    Corvus data rate increased, I/O re-organized.
;04/16/82 - 04/22/82	    Autostart Mode corrected, Ready message cleaned up.
;04/22/82 - 05/05/82	    Corvus 512 byte sector added, F-C select bug fixed.
;05/06/82 - 05/07/82	3.5 System speed optimized, User# saved in Wboot.
;05/11/82		3.6 20 MB Corvus Wboot problem fixed.
;05/20/82		    Select bug (save floppy trk# on Corv sel) fixed.
;05/21/82		3.7 Select g:+ bug (CDISC in Wboot wrong) fixed.
;07/15/82		3.8 Write to R/O Volume bug fixed.
;07/23/82		3.9 Select B:A:B: problem fixed. 
;08/17/82 -08/20/82	4.0 Motor on/off added.
;*************************************************
MO	EQU	08	;LAST EDIT DATE
DA	EQU	20
YR	EQU	82

REVNO	EQU	40	;REVISION #
SPREV	EQU	' '	;SPECIAL REV CHARACTER, =' ' IF NONE

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

;********************************************************************
;* USER-SELECTED ASSEMBLY-TIME OPTIONS				    *
;********************************************************************
CNSTLL	EQU	FALSE	;Set to true if BIOS is to be used on Constellation.
IBMB	EQU	FALSE	;Set to true if IBM disk compatibility is desired.
			;This will cause the system to use 'diskette' density
			;when reading Track 1 of disks B:,C:,... (i.e. not A:).
			;ALSPA disks always use double-density
			;on track 1 to hold the system, even if disk density
			;is single-d. Since the system on B: is not likely
			;to be read (except, maybe, by 'Disk Editor' utilities)
			;This should not affect normal operation. If an IBM-CPM
			;translation utility is used, this option MUST be
			;selected.
LL	EQU	3	;DEFAULT PRINTER OPTION:  (0,1,2,or 3)
			;0=Parallel printer interface
			;1=(console output)
			;2=Serial interface, ETX/ACK protocol
			;3=Serial interface, X-ON/X-OFF(or NO) protocol
DD	EQU	2	;# OF PHYSICAL FLOPPY DISK DRIVES: (1 or 2)
AA	EQU	1	;AUTOSWITCH OPTION: (0 OR 1)
			;0=Autoswitch enabled
			;1=Autoswitch disabled
			;The Autoswitch option runs the Modem and Console ports
			;in parallel, i.e. any character input from either
			;port is accepted as console input, and is echoed to
			;both Console and Modem output ports.
SS	EQU	1	;AUTOSTART OPTION: (0 OR 1)
			;0=Autostart on Cold/Warmboot
			;1=Autostart on Coldboot only
			;The Autostart option allows the user to insert a
			;command in the CCP to be executed upon either coldboot
			;or warmboot. If the option is disabled, the command in
			;the CCP buffer will be ignored on warmboot, but 
			;executed upon coldboot(power-on or reset). Autostart
			;will be disabled if Constellation is used.
;*******************************************************************

MSIZE	EQU	61	;CP/M VERSION MEMORY SIZE IN KB

;**********************************
;* BLOCKING/DEBLOCKING PARAMETERS *
;**********************************
WRALL	EQU	0	;WRITE TO ALLOCATED SECTOR	*BDOS
WRDIR	EQU	1	;WRITE TO DIRECTORY		*CONSTANTS
WRUAL	EQU	2	;WRITE TO UNALLOCATED SEC.	*
HSTSIZF	EQU	1024	;PHYSICAL SECTOR SIZE			*FLOPPY DISK
HSTSPTF	EQU	8	;HOST SECTORS PER TRACK			*CONSTANTS
HSTBLKF	EQU	HSTSIZF/128 ;CPM SECTORS/HOST SECTOR		*
HSTSHFF	EQU	3+1	;SECTOR SHIFT FACTOR=LOG2(HSTBLKF)+1	*
HSTSIZD	EQU	512	;PHYSICAL SECTOR SIZE		*HARD DISK
HSTSPTD	EQU	16	;HOST SECTORS/TRACK		*CONSTANTS
HSTBLKD	EQU	HSTSIZD/128 ;CPM SECTORS/HOST SECTOR	*
HSTSHFD	EQU	2+1	;SECTOR SHIFT FACTOR		*

;******************
;* CPM PARAMETERS *
;******************
DELTA	EQU	0000H	;OFFSET FROM STD CP/M SIZE
BIAS	EQU	(MSIZE-20)*1024-DELTA	;OFFSET FROM 20K CP/M
CCP	EQU	3400H+BIAS	;BASE OF CP/M
OFFSET	EQU	980H-CCP	;OFFSET USED WITH  DDT IN SYSTEM CONFIGURATION
BDOS	EQU	CCP+806H	;BASE OF BDOS
BIOS	EQU	CCP+1600H	;BASE OF BIOS
NSEC	EQU	(BIOS-CCP+80H-1)/80H	;# 128-BYTE SECTORS TO WBOOT

CR	EQU	0DH	;CHARACTER EQUATES
LF	EQU	0AH
BELL	EQU	07H
ESC	EQU	1BH

;*********************************************************
;* SYSTEM CONFIGURATION:				 *
;* Both IOBYTE and SYSFMT are initialized from 'IOBYTA': *
;*	IOBYTE=(IOBYTA AND IOBMSK)			 *
;*	SYSFMT=(IOBYTA AND SYSMSK) OR DFTSY		 *
;* This is done for continuity with earlier systems which*
;* used IOBYTE for all the system config functions.	 *
;*********************************************************
IOBYTE	EQU	0003H	;I/O BYTE: <llpprrcc>  (Reserved Memory location)
	;IOBYTE assignments: (Default = '*', optional defaults = '-')
	;------------------------------------------------
	;ll: prn protocol	    pp: punch device 
	;*00 PARALLEL	    TTY:    -00 PARALLEL PRN TTY:
	;-01 (CONSOLE OUT)  CRT:    -01 (not used)   PUN:
	;-10 ETX/ACK	    LPT:    *10 MODEM OUT    UP1:
	;-11 XON/XOFF(or NO)UL1:    -11 CLOCK WRITE  UP2:
	;   --------------------------------------
	;rr:  reader device	    cc: console device
	;-00  (not used)    TTY:    *00 CONSOLE	     TTY:
	; 01  (not used)    RDR:     01 CONSOLE      CRT:
	;*10  MODEM IN      UR1:    -10 MODEM I/O    BAT:
	; 11  CLOCK READ    UR2:     11 CLOCK R/W    UC1:
	;------------------------------------------------
	;SYSFMT Sytem format byte: <---s-a-d>
	;s: autostart mode  a: autoswitch mode    d: #drives
	; 0 on (cold/warm)   0 on(modem&console)   0 2-drives
	;*1 off	(cold)	    *1 off(console only)  *1 1-drive
	;------------------------------------------------
SYSMSK	EQU	05H		  ;(Mask for bits used in SYSFMT from IOBYTA)
IOBMSK	EQU (NOT SYSMSK) AND 0FFH ;(Mask for bits used in IOBYTE from IOBYTA)
DFTIO	EQU ((LL shl 6 or 28H) and iobmsk)			;Default IOBYTE
DFTSY	EQU (AA*4+(not (DD-1) and 1)+(SS*10H or cnstll and 10H));Default SYSFMT
DFLTIOB	EQU	DFTIO or (DFTSY	AND SYSMSK)			;Default IOBYTA
;********************************************************
CDISC	EQU	0004H	;CP/M Reserved memory location - current disk

;********************************************************
;AUTO-LOGIN: If Constellation is used, this inserts an
;	     automatic call to the HELLO program in the CCP.
;********************************************************
	IF	CNSTLL
	ORG	CCP+7
	DB	5,'HELLO',0
	ENDIF
COMLOC	EQU	004EH	;This location -> CORTAB after SETDMA call.

;******************
;* CORVUS EQUATES *
;******************
DATA	EQU	0D0H	;DISC I/O PORT #
STAT	EQU	0D2H	;DISC STATUS PORT
DRDY	EQU	1	;MASK FOR DRIVE READY BIT
DIFAC	EQU	2	;MASK FOR DRIVE ACTIVE BIT
RDCOM	EQU	32H	;READ COMMAND (512 BYTE SECTORS)
WRCOM	EQU	33H	;WRITE COMMAND
BDRIVE	EQU	1	;CORVUS DRIVE # TO BOOT FROM
CSEC	EQU	12	;STARTING DISK ADDRESS FOR CP/M BOOT (INCL BOOT)
DSEC	EQU	128	;STARTING 128-BYTE DISK ADDRESS FOR CP/M DIRECTORY,
MODO	EQU	83H	;OUTPUT MODE ;=12(RESERVED CORVUS)+72(OPERATING SYSTEM)
MODI	EQU	93H	;INPUT MODE  ;+44(SPARE). THIS NUMBER PACKS DISK MOST
STRB	EQU	0D2H	;STROBE PORT ;EFFICIENTLY, USING UP TO LAST SECTOR.
COMDD	EQU	0D3H	;
	if	CNSTLL
NPSUDO	EQU	4	;ALLOW 4 DRIVES FOR CONSTELLATION
	endif
	if	NOT CNSTLL
NPSUDO	EQU	1	;ALLOW ONE DRIVE FOR 5 MEG CORVUS
	endif
DF0	EQU	'A'+NPSUDO	;DRIVE DESIGNATION FOR FLOPPY # 0

;********************
;* SERIAL I/O PORTS *
;********************
MSTAT	EQU	5	;MODEM STATUS PORT
MDATA	EQU	4	;MODEM DATA PORT
CSTAT	EQU	3	;CONSOLE STATUS PORT
CDATA	EQU	2	;CONSOLE DATA PORT
LSTAT	EQU	1	;LIST STATUS PORT
LDATA	EQU	0	;LIST DATA PORT

SINGL	EQU	2	;LOGDEN VALUE FOR S/D DISK
RTCNT	EQU	10	;RETRY COUNT.

;*****************
;* DISK IO PORTS *
;*****************
DISK	EQU	0F8H	;DISK BASE ADDRESS.
DCOM	EQU	DISK	;DISK COMMAND PORT.
DSTAT	EQU	DISK	;DISK STATUS PORT.
TRACKF	EQU	DISK+1	;DISK TRACK PORT.
SECTP	EQU	DISK+2	;DISK SECTOR PORT.
DDATA	EQU	DISK+3	;DISK DATA PORT.
DSEL	EQU	DISK+5	;DENSITY SELECT
DCONT	EQU	DISK+4	;DISK CONTROL PORT.



;***********Z80 OPCODE EQUATES************
;For relative branches, use:
;	db	jxxx,LABEL-$-1	  ;forward reference
;	db	jxxx,LABEL-$+0FFH ;backward reference
;If label is out-of-range, ASM will flag an error.
JR	EQU	18H	;JR	XX
JRNZ	EQU	20H	;JR	NZ,XX
JRZ	EQU	28H	;JR	Z,XX
JRNC	EQU	30H	;JR	NC,XX
JRC	EQU	38H	;JR	C,XX
RRCB	EQU	08CBH	;RRC	B
LDIR	EQU	0B0EDH	;LDIR
SRLA	EQU	2FCBH	;SRL	A
SRLB	EQU	38CBH	;SRL	B
SRLC	EQU	39CBH	;SRL	C
SRLH	EQU	3CCBH	;SRL	H
RRD	EQU	1ACBH	;RR	D
RRE	EQU	1BCBH	;RR	E
RRL	EQU	1CCBH	;RR	L
DJNZ	EQU	10H	;DJNZ	XX
PUSHIX	EQU	0E5DDH	;PUSH	IX
LDIX	EQU	21DDH	;LD	IX,XXXX
POPIX	EQU	0E1DDH	;POP	IX
INI	EQU	0A2EDH	;INI
JPIX	EQU	0E9DDH	;JP	(IX)
OUTI	EQU	0A3EDH	;OUTI
OUTCA	EQU	79EDH	;OUT	(C),A
INAC	EQU	78EDH	;IN	A,(C)

	ORG	BIOS

			;CP/M INTERFACE JUMP TABLE
	JMP	CBOOT
WBOOTE:	JMP	WBOOT
	JMP	LCONST
	JMP	LCONIN
	JMP	LCONOUT
	JMP	LLIST
	JMP	LPUNCH
	JMP	LREADER
	JMP	HOME
	JMP	SELDSK
	JMP	SETTRK
	JMP	SETSEC
	JMP	SETDMA
	JMP	READ
	JMP	WRITE
	JMP	LLISTST	;LIST DEVICE STATUS REQUEST
	JMP	SECTRAN	;SECTOR TRANSLATION ROUTINE

DFLAGS:	DB	0,0,0,0	;DENSITY FLAGS	*********do not
	CALL	SELDF	;DENSITY SETTING ROUTINE*move or
	CALL	DUMMY	;FOR FCOPY PROGRAM	*change
DUMMY:	RET		;			*
IOBYTA:	DB	DFLTIOB	;DEFAULT I/O BYTE	*this must
SYSFMT:	DB	DFTSY AND IOBMSK ;		*follow the
	DB	'Reserve';for future use.	*17th JUMP
UARTT:	DB	0CEH	;USART MODE SELECT	*address
UARTP:	DB	0CEH	;CODES			*
UARTM:	DB	0CEH	;		*********


;*************************
;* DISC PARAMETER BLOCKS *
;*************************
;The single user system sets up one pseudo drive on a 5MB Corvus disk,
;and up to two standard 8 inch single/double density floppy disk drives.
;  NOTE:  The numbers shown in DPB0 (the Corvus parameter block)
;	  for the pseudo drive and its associated Allocation
;	  Buffer sizes are the result of choosing:
;		-44800 SECTORS/PSEUDO DRIVE (Fixed for 5MB Corvus).
;		-64 SECTORS/TRACK
;		-128 BYTES/SECTOR
;		-128 RESERVED SECTORS FOR CORVUS,OPERATING SYSTEM,SPARE
;		-256 DIRECTORY ENTRIES
;		-8*1024 BYTE BLOCKSIZE
;  NOTE:  The Corvus is organized as 
;		-512 BYTES/PHYSICAL SECTOR
;		-128 BYTES/LOGICAL SECTOR

DPBASE	EQU	$

DPE1:	DW	TRANS,0000	;FLOPPY DRIVE 1 (DF0)
	DW	0000,0000	;
	DW	DIRBUF,DPSDBK	;DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV1,ALV1	;CHECK, ALLOC MAP

DPE2:	DW	TRANS,0000	;FLOPPY DRIVE 2 (DF0 + 1)
	DW	0000,0000	;
	DW	DIRBUF,DPSDBK	;DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV2,ALV2	;CHECK, ALLOC MAP

;	SINGLE DENSITY SECTOR TRANSLATE VECTOR
TRANS:	DB	1,7,13,19	;SECTORS 1,2,3,4
	DB	25,5,11,17	;SECTORS 5,6,7,8
	DB	23,3,9,15	;SECTORS 9,10,11,12
	DB	21,2,8,14	;SECTORS 13,14,15,16
	DB	20,26,6,12	;SECTORS 17,18,19,20
	DB	18,24,4,10	;SECTORS 21,22,23,24
	DB	16,22		;SECTORS 25,26
;	DOUBLE DENSITY SECTOR TRANSLATE VECTOR
TRANSD	EQU	0		;NO TRANSLATION FOR DBL-D


DPDDBK:		;DOUBLE DENSITY PARAMETER BLOCK
	DW	64	;SECTORS PER TRACK - SPT
	DB	4	;BLOCK SHIFT FACTOR - BSH
	DB	15	;BLOCK MASK - BLM
	DB	0	;NULL MASK - EXM
	DW	300-1	;DISK SIZE IN BLOCKS - DSM
	DW	128-1	;DIRECTORY MAX ENTRIES - DLM
	DB	0C0H	;DIR. ALLOC. MASK - AL0
	DB	0	;DIR. ALLOC. MASK - AL1
	DW	128/4	;DIR. CHECK SIZE - CKS
	DW	2	;TRACK OFFSET - OFF
	DB	16	;BLOCKSIZE/128	****************
	DB	HSTBLKF-1;SECMASK	*BLOCKING PARMS*
	DB	HSTSHFF	;SECSHF		* DO NOT MOVE  *
	DB	64	;CPMSPT		****************

DPDDBK1:	;DOUBLE DENSITY PARAMETER BLOCK (2 side)
	DW	64	;SECTORS PER TRACK - SPT
	DB	5	;BLOCK SHIFT FACTOR - BSH
	DB	31	;BLOCK MASK - BLM
	DB	1	;NULL MASK - EXM
	DW	304-1	;DISK SIZE IN BLOCKS - DSM
	DW	128-1	;DIRECTORY MAX ENTRIES - DLM
	DB	80H	;DIR. ALLOC. MASK - AL0
	DB	0	;DIR. ALLOC. MASK - AL1
	DW	128/4	;DIR. CHECK SIZE - CKS
	DW	2	;TRACK OFFSET - OFF
	DB	32	;BLOCKSIZE/128	*BLOCKING PARMS***
	DB	HSTBLKF-1;SECMASK	* =HSTSIZF/128-1 *
	DB	HSTSHFF	;SECSHF		*=LG2(SCMSK+1)+1 *
	DB	64	;CPMSPT		*=HSTBLKF*HSTSPTF*

DPSDBK:	;DISK PARAMETER BLOCK, SINGLE DENSITY
	DW	26	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;NULL MASK
	DW	242	;DISK SIZE-1
	DW	63	;DIRECTORY MAX
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;CHECK SIZE
	DW	2	;TRACK OFFSET
	DB	8	;BLOCKSIZE/128	****************
	DB	0	;SECMASK	*BLOCKING PARMS*
	DB	0+1	;SECSHF		* DO NOT MOVE  *
	DB	26	;CPMSPT		****************


	DB	MO,DA,YR;***THIS MUST PRECEDE CBOOT***
;***********************
;*  COLD BOOT STARTUP  *
;***********************
CBOOT:	JMP	BOOT

;***********************
;*  WARM BOOT STARTUP  *
;***********************
	DB	0DDH	;This must precede WBOOT.
WBOOT:	LXI	SP,80H	;SET STACK
	LDA	SEKDSK	;SAVE DISK#
	PUSH	PSW
	XRA	A	;CLEAR BLOCKING FLAGS
	STA	HSTACT
	STA	UNACNT
	STA	HSTWRT
	STA	SEKDSK	;DISK=A:
	LXI	H,0	;CLEAR DENSITY FLAGS
	SHLD	DFLAGS
	SHLD	DFLAGS+2
	MOV	C,A	;INIT PARMS FOR CORVUS DRIVE A:
	CALL	SELCORV
;	LXI	H,CCP-80H;SAVE TOP 80H OF TPA IN HSTBUF
;	PUSH	H	;		PUSH TPA ADDR
;	LXI	D,HSTBUF
;	PUSH	D	;		PUSH HSTBUF ADDR
;	LXI	B,80H
;	PUSH	B	;		PUSH COUNT
;	DW	LDIR
WBO1:
	MVI	A,0FFH	;  GET INVALID COMMAND
	CALL	OUTACV	;
	MVI	B,0	;  SET FOR LONG DELAY
	CALL	DELAY	;
	CALL	DELAY	;  (necessary for 20MB Corvus)
	IN	STAT	;  GET STATUS BYTE
	ANI	DIFAC	;  LOOK AT DRIVE ACTIVE BIT
	DB	JRNZ,WBO1-$+0FFH	;  LOOP UNTIL NOT ACTIVE
	CALL	WAITI	;  WAIT FOR ERROR CODE
	CPI	8FH	;  CHECK RETURN CODE
	DB	JRNZ,WBO1-$+0FFH	;  IF NOT RIGHT, TRY AGAIN
	LDA	VOLTAB+5; CDRIVE = PHYSICAL DRIVE # (1-4)
	STA	CDRIVE	;
	LDA	VOLTAB+4; B= # 128-BYTE SECTORS TO WBOOT
	MOV	B,A	;
	LXI	H,VOLTAB+6; HL -> 128-BYTE DISC ADDRESS
	CALL	CORVBLK	; CONVERT (CDE (=M(HL),B) TO BLOCK ADDRESS,COUNT
	LXI	H,CCP-80H;GET RAM START ADDRESS OF LOAD
BT1:	MVI	A,RDCOM	;  GET READ COMMAND
	CALL	WAITO	;  SEND IT TO CONTROLLER
	MOV	A,C	;  GET EXTENDED DISK ADDR
	ANI	0FH
	PUSH	B
	PUSH	D
	CALL	SET0
	CALL	RDC1	;  READ IN ONE SECTOR
	POP	D
	POP	B
	ORA	A	;  TEST FOR ERROR
	DB	JRNZ,BERR-$-1	;  IF ERROR, ISSUE MESSAGE
	INX	D	;  INCREMENT DISK ADDRESS
	DCR	B	;  COUNT DOWN BLOCKS
	DB	JRNZ,BT1-$+0FFH	;  LOOP UNTIL DONE
;	POP	B	;RE-LOAD TOP 80H BYTES OF TPA
;	POP	H
;	POP	D
;	DW	LDIR
	LDA	SYSFMT	;IF (AUTOSTART OFF)
	ANI	10H
	DB	JRZ,BT2-$-1
	XRA	A	;  DISABLE CCP COMMAND
	STA	CCP+7	;
BT2:	POP	PSW	;RESTORE DISK#
	STA	SEKDSK	;

GOCPM:	IN	DSTAT	;CLEAR DISK STATUS INTERRUPT (IF SET)
	MVI	A,0C3H	;GET JUMP INSTRUCTION
	STA	0	;SETUP FOR WARM BOOT
	LXI	H,WBOOTE ;WARM BOOT ENTRY
	SHLD	1	;SET ADDRESS
	STA	5	;SETUP BDOS ENTRY JUMP
	LXI	H,BDOS
	SHLD	6
	LXI	B,80H	;DEFAULT DMA ADDRESS
	CALL	SETDMA
	LXI	H,0	;SET DFLAGS=0
	SHLD	DFLAGS	;
	SHLD	DFLAGS+2;
	LDA	SEKDSK	;GET CURRENT DRIVE #
	MOV	C,A
	LDA	CDISC	;GET USER#
	ANI	0F0H
	ORA	C
	MOV	C,A	;SAVE FOR CCP FUNCTION
GOC1:	JMP	CCP	;ENTER CP/M

BERR:	LXI	H,BEMSG	;POINT TO ERROR MESSAGE
	CALL	PMSG	;ISSUE ERROR MESSAGE
	HLT		;HALT SYSTEM

;*************************************************
;*  --GENERAL DISK ROUTINES - CORVUS & FLOPPY--  *
;*************************************************

;***************
;*  HOME DISK  *
;***************
HOME:
	LDA	HSTWRT	;IF WRITE PENDING, FLUSH BUFFER
	ORA	A
	CNZ	WRITEHST
	CALL	CHKSD	;CHECK FOR CORRECT DISK AND SELECT IT
	LDA	SEKDSK	;HOME SEKDSK
	CPI	NPSUDO
	JNC	HOMEF
	JMP	HOMEC

;*****************
;*  SELECT DISK  *
;*****************
SELDSK:
	MOV	A,C	;GET CP/M DRIVE #
	LXI	H,SEKDSK;SAME AS LAST DISK REQUESTED?
	CMP	M	;
	JZ	BLDPTR	;YES, SO JUST GET POINTER AND RETURN
	LDA	DMAX	;NO, SO SEE IF # IS TOO BIG
	CMP	C	;
	LXI	H,0	;(SET HL=0 IN CASE OF ERROR)
	RC		;ERROR RETURN
	PUSH	B	;  IF WRITE PENDING, FLUSH BUFFER
	LDA	HSTWRT	;
	ORA	A	;
	CNZ	WRITEHST;
	POP	B	;
	MOV	A,C	;
	CPI	NPSUDO	;
	DB	JRC,SELD2-$-1	;IF (FLOPPY) THEN DO
	STA	SEKDSK	;  SET NEW DISK
	CALL	BLDPTR	;  GENERATE DPBH PTR
	CALL	DENSITY	;  SET FLOPPY DENSITY/BLOCKING PARMS
	RET		;  ENDIF
SELD2:	CALL	CORVMT	;ELSE DO
	JZ	SELCERR	;  IF (VOLUME NOT MOUNTED) THEN REPORT ERROR
	MOV	A,C	;  ELSE SET CORVUS BLOCKING PARMS
	STA	SEKDSK	;  END ELSE
	JMP	SELCO1

;***************
;*  SET TRACK  *
;***************
SETTRK:
	MOV	L,C	;SAVE TRACK #
	MOV	H,B
	SHLD	SEKTRK
	RET

;**************
;* SET SECTOR *
;**************
SETSEC:
	MOV	A,C	;SAVE CP/M SECTOR #
	STA	SEKSEC
	RET

;*******************
;* SET DMA ADDRESS *
;*******************
SETDMA:
	if	CNSTLL
	LXI	H,CORTAB;SET COMLOC->CORTAB (FOR 'HELLO' PROGRAM)
	SHLD	COMLOC	;('Utility program Link')
	endif
	MOV	L,C	;SAVE DMA ADDRESS
	MOV	H,B
	SHLD	DMAADD
	RET

;******************************
;* SECTOR TRANSLATION ROUTINE *
;******************************
SECTRAN:
	MOV	A,E	;TEST IF TABLE TRANSLATION IS REQUESTED
	ORA	D	;
	DB	JRNZ,SECTR1-$-1	;YES, SO DO IT
	MOV	L,C	;NO, LET HL=BC+1
	MOV	H,B	;
	INX	H	;
	RET		;
SECTR1:	XCHG		;GET TABLE ADDRESS IN (H,L)
	DAD	B	;INDEX INTO TABLE
	MOV	L,M	;GET BYTE IN (H,L)
	MVI	H,0	;
	RET		;

;*****************
;*  READ SECTOR  *
;*****************
READ:			;read the selected CP/M sector
	CALL	CHKSD	;SELECT SEKDSK, SET PARMS
	XRA	A
	STA	UNACNT
	MVI	A,1
	STA	READOP		;read operation
	STA	RSFLAG		;must read data
	MVI	A,WRUAL
	STA	WRTYPE		;treat as unalloc
	JMP	RWOPER		;to perform the read

;******************
;*  WRITE SECTOR  *
;******************
WRITE:			;write the selected CP/M sector
	XRA	A
	STA	READOP		;not a read operation
	MOV	A,C		;write type in c
	STA	WRTYPE
	CALL	CHKSD		;SELECT SEKDSK, SET PARMS
	LDA	LOGDEN		;IF (SD), NEVER RD BEFORE WR
	CPI	SINGL
	DB	JRZ,NOOVF-$-1
	LDA	WRTYPE
	CPI	WRUAL		;write unallocated?
	DB	JRNZ,CHKUNA-$-1	;check for unalloc
				;write to unallocated, set parameters
	LDA	CPMSPB		;next unalloc recs
	STA	UNACNT
	LXI	H,SEKDSK		;Unadsk = Sekdsk
	LXI	D,UNADSK		;Unasec = Seksec
	LXI	B,5			;Unatrk = Sektrk
	DW	LDIR
CHKUNA:			;check for write to unallocated sector
	LDA	UNACNT		;any unalloc remain?
	ORA	A
	DB	JRZ,ALLOC-$-1	;skip if not
			;more unallocated records remain
	DCR	A		;unacnt = unacnt-1
	STA	UNACNT
	LDA	SEKDSK		;same disk?
	LXI	H,UNADSK
	CMP	M		;sekdsk = unadsk?
	DB	JRNZ,ALLOC-$-1	;skip if not
			;disks are the same
	LXI	H,UNATRK
	CALL	SEKTRKCMP	;sektrk = unatrk?
	DB	JRNZ,ALLOC-$-1	;skip if not
			;tracks are the same
	LDA	SEKSEC		;same sector?
	LXI	H,UNASEC
	CMP	M		;seksec = unasec?
	DB	JRNZ,ALLOC-$-1	;skip if not
			;match, move to next sector for future ref
	INR	M		;unasec = unasec+1
	LDA	CPMSPT		;end of track?
	CMP	M		;count CP/M sectors
	DB	JRNC,NOOVF-$-1	;skip if no overflow
			;overflow to next track
	MVI	M,1		;unasec = 1
	LHLD	UNATRK
	INX	H
	SHLD	UNATRK		;unatrk = unatrk+1
NOOVF:			;match found, mark as unnecessary read
	XRA	A
	STA	RSFLAG		;rsflag = 0
	DB	JR,RWOPER-$-1	;to perform the write

ALLOC:			;not an unallocated record, requires pre-read
	XRA	A
	STA	UNACNT		;unacnt = 0
	INR	A
	STA	RSFLAG		;rsflag = 1
;*******Common code for READ and WRITE follows********
RWOPER:		;enter here to perform the read/write
	LDA	SECSHF	;COMPUTE HOST SECTOR
	MOV	B,A
	LDA	SEKSEC	;HOSTSECTOR=((SEEKSECTOR)-1 SHR SEKSHF)+1
	DCR	A
	DB	JR,RWOPR2-$-1
RWOPR1: DW	SRLA		;SRL A
RWOPR2: DB	DJNZ,RWOPR1-$+0FFH
	INR	A
	STA	SEKHST		;host sector to seek
			;active host sector?
	LXI	H,HSTACT	;host active flag
	MOV	A,M
	MVI	M,1		;always becomes 1
	ORA	A		;was it already?
	DB	JRZ,FILHST-$-1	;fill host if not
			;host buffer active, same as seek buffer?
	LDA	SEKDSK
	LXI	H,HSTDSK
	CMP	M		;sekdsk = hstdsk?
	DB	JRNZ,NOMATCH-$-1
	LXI	H,HSTTRK
	CALL	SEKTRKCMP	;sektrk = hsttrk?
	DB	JRNZ,NOMATCH-$-1
	LDA	SEKHST
	LXI	H,HSTSEC	;sekhst = hstsec?
	CMP	M
	DB	JRZ,MATCH-$-1		;skip if match
NOMATCH:		;not correct sector
	LDA	HSTWRT		;host written?
	ORA	A
	CNZ	WRITEHST	;clear host buff
	STA	ERFLAG		;REPORT ANY ERRORS
FILHST:			;may have to fill the host buffer
	LXI	H,SEKDSK		;Hstdsk = Sekdsk
	LXI	D,HSTDSK		;Hstsec = Sekhst
	LXI	B,5			;Hsttrk = Sektrk
	DW	LDIR
	LDA	RSFLAG		;need to read?
	ORA	A
	CNZ	READHST		;yes, if 1
	LXI	H,ERFLAG	;REPORT ANY ERRORS
	ORA	M		;
	MOV	M,A		;
	XRA	A
	STA	HSTWRT		;no pending write
MATCH:			;copy data to or from buffer
	LDA	SEKSEC	;HL=((SEKSEC-1) AND SECMSK) SHL 7
	DCR	A
	LXI	H,SECMSK
	ANA	M
	RAR
	MOV	H,A
	MVI	A,0
	RAR
	MOV	L,A
	LXI	D,HSTBUF
	DAD	D		;hl = host address
	XCHG			;now in DE
	LHLD	DMAADD		;get/put CP/M data
	XCHG			;
	LXI	B,128		;length of move
	LDA	READOP		;which way?
	ORA	A
	DB	JRNZ,RWMOVE-$-1	;skip if read
			;write operation, mark and switch direction
	MVI	A,1
	STA	HSTWRT		;hstwrt = 1
	XCHG			;source/dest swap
RWMOVE:	DW	LDIR	;BC initially 128, HL is source, DE is dest
			;data has been moved to/from host buffer
	LDA	WRTYPE		;write type
	CPI	WRDIR		;to directory?
	LDA	ERFLAG		;IF NOT THEN EXIT WITH FLAG
	RNZ			;
			;clear host buffer for directory write
	ORA	A		;errors?
	CZ	WRITEHST	;IF NOT, WRITE BUFFER
	RET

;*****************************************
;* Utility subroutine for 16-bit compare *
;*****************************************
SEKTRKCMP:	;HL = .unatrk or .hsttrk, compare with sektrk
	XCHG
	LXI	H,SEKTRK
	LDAX	D		;low byte compare
	CMP	M		;same?
	RNZ			;return if not
			;low bytes equal, test high 1s
	INX	D
	INX	H
	LDAX	D
	CMP	M	;sets flags
	RET

;****************************************************************
;*  READ THE SECTOR AT HSTSEC, HSTTRK, HSTDSK, USE HOSTBUFFER.  *
;****************************************************************
READHST:
	LDA	HSTDSK	;CHECK FOR HOST DISK SELECTED
	CALL	CHKDSK
	LDA	HSTDSK
	CPI	NPSUDO
	JC	READC
	JMP	READF

;****************************************************************
; WRITE THE SECTOR AT HSTSEC, HSTTRK, HSTDSK, USE HOST BUFFER.  *
;****************************************************************
WRITEHST:
	LDA	HSTDSK	;CHECK FOR HOST DISK SELECTED
	CALL	CHKDSK
	LDA	HSTDSK
	CPI	NPSUDO
	JC	WRITEC
	JMP	WRITEF


;*********************************************************
;CHKSD:  CHECK THAT CURRENT DRIVE = SELECTED DRIVE &
;CHKDSK: CHECK THAT CURRENT DRIVE = DRIVE (ACC) &
;			CHANGE IT IF NECESSARY
;*********************************************************
CHKSD:	LDA	SEKDSK	;C=SEKDSK
CHKDSK:	MOV	C,A
	LDA	CURDSK	;A=CURRENT DISK
	CMP	C	;IF (A=C) THEN RETURN /*NO CHANGE*/
	RZ		;ELSE DO /*CHANGE*/
	LDA	CURDSK	;  IF (CURDSK=FLOPPY) THEN DO
	SUI	NPSUDO	;
	DB	JRC,CHKDS1-$-1
	MOV	E,A	;
	MVI	D,0	;    HL => TRACKTABLE(LASTDRIVE)
	LXI	H,TRTAB	;
	DAD	D	;
	IN	TRACKF	;    A = 1793 TRACK REGISTER (ADJUSTED)
	CALL	INTRK	;    M(HL) = A
	MOV	M,A	;    ENDIF
CHKDS1:	MOV	A,C	;  IF (NEWDSK=CORVUS) THEN SELECT CORVUS
	SUI	NPSUDO	;  ELSE DO
	JC	SELCORV	;
	MOV	E,A	;    HL => TRACKTABLE(NEWDRIVE)
	MVI	D,0	;
	LXI	H,TRTAB	;
	DAD	D	;
	MOV	A,M	;
	CALL	OUTRK	;    1793 TRACK REG = TRKTBL(NWDR) (ADJUSTED)
	OUT	TRACKF	;	/*NOTE: PRESERVE HL FOR SELDF*/
	JMP	SELDF	;    SELECT FLOPPY; ENDIF


;**********************************************
;BUILD POINTER IN HL, ->DPBHeader for drive (C)
;**********************************************
BLDPTR:	MOV	A,C	;
	SUI	NPSUDO	;IF (FLOPPY DRIVE)THEN DO
	DB	JRC,CORVMT-$-1
	MVI	H,0	;
	MOV	L,A	;
	DAD	H	;  HL=16*(C-DF0)+DPBASE
	DAD	H	;
	DAD	H	;
	DAD	H	;
	LXI	D,DPBASE;
	DAD	D	;
	RET		;

CORVMT:	MOV	L,C	;ELSE TEST IF CORVUS DRIVE #(C) IS MOUNTED:
	MVI	H,0	;  RETURN NZ,HL->DPBH,DE=VOL# IF SO,
	DAD	H	;      OR Z,HL=0 IF NOT
	DAD	H	;HL=C*24
	DAD	H
	MOV	D,H
	MOV	E,L
	DAD	D
	DAD	D
	LXI	D,VOL1	;POINT TO BASE OF VOLUME TABLE
	DAD	D	;SELECT THE RIGHT ONE
	MOV	E,M	;GET DE=VOLUME #
	INX	H
	MOV	D,M
	PUSH	D
	LXI	D,7	;INCR PTR TO ->PARMHDR
	DAD	D
	POP	D
	MOV	A,D	;IF VOL#=0 THEN HL=0 (NOT MOUNTED)
	ORA	E
	RNZ
	LXI	H,0
	RET


;*************************
;*  --CORVUS ROUTINES--  *
;*************************

;*****************
;*  HOME CORVUS  *
;*****************
HOMEC:	LXI	B,0	;GET TRACK 0
	JMP	SETTRK

;***********************
;* SELECT CORVUS DRIVE *
;***********************
SELCORV:
	LXI	H,CURDSK;
	MOV	M,C	;UPDATE DRIVE#
SELCO1:	CALL	CORVMT	;GET PTR->DPBH(VOL(C))
	PUSH	H	;SAVE IT
	XCHG		;SAVE VOL#
	SHLD	VOLNUM
	LXI	H,-8	;HL->VOLUME TABLE
	DAD	D
	SHLD	VPTR	;SAVE IT
	INX	H
	INX	H
	MOV	A,M	;SAVE ACTUAL CORVUS DRIVE #
	STA	CDRIVE
	INX	H	;HL->ADDRESS OFFSET
	SHLD	ADDOF
	LXI	D,15
	DAD	D	;POINT TO ADDRESS OF DISC BLOCK
	MOV	E,M	;GET ADDRESS IN FROM TABLE INTO (D,E)
	INX	H
	MOV	D,M
	XCHG		;(HL) -> PARMBLOCK
	MOV	A,M	;SET CPMSPT = # SECTORS/TRACK
	STA	CPMSPT
	INX	H	;LET B=BSH
	INX	H
	MOV	B,M
	MVI	A,1	;CPMSPB=2**BSH
SELCO2:	ADD	A
	DB	DJNZ,SELCO2-$+0FFH
	STA	CPMSPB
	LXI	H,HSTSHFD*100H+HSTBLKD-1
	SHLD	SECMSK
	POP	H	;RESTORE PARMPTR
	XRA	A	;RETURN ERRORCODE=0
	STA	LOGDEN	;SET LOGDEN=0
	RET

SELCERR: LXI	H,MTMSG
	CALL	PMSG
	LXI	H,0	;RETURN HL=0 FOR NO SELECT
	RET

;*****************
;*  READ CORVUS  *
;*****************
READC:	MVI	A,RDCOM	;GET READ COMMAND
	CALL	SETUP	;COMPUTE DISC ADDRESS AND ISSUE COMMANDS
	LXI	H,HSTBUF;GET DMA ADDRESS
RDC1:	CALL	TURN	;WAIT FOR ACCEPTANCE OF COMMAND
	JNZ	ERRCD	;IF ERROR
	MVI	B,HSTSIZD MOD 100H	;GET SECTOR SIZE
	MVI	D,HSTSIZD/100H
	MVI	A,MODI
	OUT	COMDD
	MVI	C,DATA
RLP:	IN	STAT	;GET DRIVE STATUS
	ANI	DRDY	;LOOK AT READY BIT
			;LOOP UNTIL BYTE IS AVAILABLE
	DB	JRZ,RLP-$+0FFH
RLP1:	MVI	A,9
	OUT	COMDD
	DW	INI
	MVI	A,8
	OUT	COMDD
	DB	JRNZ,RLP1-$+0FFH
	DCR	D
	JM	RTN	;(IN CASE HSTSIZ<100H)
	DB	JRNZ,RLP1-$+0FFH
RTN:	XRA	A	;CLEAR ERROR INDICATOR
	RET

;******************
;*  WRITE CORVUS  *
;******************
WRITEC:	LXI	H,ROMSG	;IF (MSB VOLUME# =1) PRINT ERRMSG, DONT WRITE
	LDA	VOLNUM+1
	RAL
	DB	JRC,ERRCD1-$-1
	MVI	A,WRCOM	;GET WRITE COMMAND
	CALL	SETUP	;COMPUTE ADDRESS AND ISSUE COMMANDS
	MVI	B,HSTSIZD MOD 100H	;GET SECTOR SIZE
	MVI	D,HSTSIZD/100H
	LXI	H,HSTBUF;GET DMA ADDRESS
	MVI	A,MODO
	OUT	COMDD
	MVI	C,DATA
WLP:	IN	STAT	;GET DRIVE STATUS
	ANI	DRDY	;LOOK AT READY BIT
			;LOOP UNTIL BYTE IS AVAILABLE
	DB	JRZ,WLP-$+0FFH
WLP1:	DW	OUTI
	MVI	A,9
	OUT	COMDD
	MVI	A,8
	OUT	COMDD
	DB	JRNZ,WLP1-$+0FFH
	DCR	D
	JM	WLP2	;(IN CASE HSTSIZD < 100H)
	DB	JRNZ,WLP1-$+0FFH
WLP2:	CALL	TURN	;WAIT FOR BUSS TURN AROUND AND READ ERROR #
	DB	JRNZ,ERRCD-$-1
	XRA	A	;IF OK, CLEAR FLAG & RETURN
	STA	HSTWRT
	RET

ERRCD:	PUSH	B	;IF ERROR, ISSUE ERROR MESSAGE
	LXI	H,CERMSG
	CALL	PMSG
	POP	PSW	;GET ERROR # BACK IN ACC
	CALL	PRTHEX	;PRINT IT OUT IN HEX
	LXI	H,CERMSG1
	DB	JR,ERRCD2-$-1
ERRCD1:	XRA	A	;CLEAR PENDING WRITE FOR R/O VOLUMES
	STA	HSTWRT	;  (We can't ever write it anyways)
ERRCD2:	CALL	PMSG	;PRINT REMAINDER OF MESSAGE
	MVI	A,1	;SET ERROR INDICATOR
	RET


TURN:	IN	STAT	;READ STATUS BYTE
	ANI	DIFAC	;LOOK AT DRIVE ACTIVE BIT
	DB	JRNZ,TURN-$+0FFH
	CALL	DELAY1	;WAIT FOR OVER 20USEC
	CALL	WAITI	;READ ERROR BYTE
	MOV	B,A	;SAVE IT
	ANI	80H	;LOOK AT FATAL ERROR BIT
	RET

DELAY1:	MVI	B,6	;DELAY MORE THAN 20USEC
DELAY:	DB	DJNZ,DELAY-$+0FFH
	RET

WAITI:	IN	STAT	;GET STATUS BYTE
	ANI	DRDY	;LOOK AT READY BIT
	DB	JRZ,WAITI-$+0FFH
	CALL	INACV	;GET DATA FROM CONTROLLER
	RET

WAITO:	PUSH	PSW	;SAVE COMMAND
	IN	STAT	;READ STATUS BYTE
	ANI	DRDY	;LOOK AT READY BIT
	DB	JRZ,WAITO+1-$+0FFH
	POP	PSW	;GET COMMAND
	CALL	OUTACV	;SEND IT TO CONTROLLER
	RET
;
;--- COMPUTE CORVUS DISC ADDRESS AND SEND TO CONTROLLER ---
;
SETUP:	CALL	WAITO	;ISSUE DISC R/W  COMMAND
	LHLD	HSTTRK	;GET TRACK # FROM BUFFER
	XCHG		;PUT IN (D,E)
	LXI	H,0	;CLEAR CONVERSION BUFFER
	MVI	A,HSTSPTD ;GET # SECTORS/TRACK  (ASSUMED <255)
	MVI	B,8	;SET TO MULTIPLY 8 BITS
;          MULTIPLY :(H,L)=TRACK*(HOSTSECTORS/TRACK)
MULT:	DAD	H	;SHIFT BUFFER OVER 1 POSITION
	RAL		;TEST NEXT BIT OF (#SECTORS/TRACK)
	DB	JRNC,ML1-$-1	;IF NOT A 1, DON'T ADD IN
	DAD	D	;IF A 1, ADD IN  TRACk #
ML1:	DCR	B	;COUNT DOWN # BITS
	DB	JRNZ,MULT-$+0FFH	;LOOP UNTIL DONE
	XCHG
	LDA	HSTSEC
	DCR	A
	MOV	L,A
	MVI	H,0
	DAD	D	;HL=SECTOR-1+TRACK*(#SECTORS/TRACK)
	PUSH	H
	LHLD	ADDOF	;CDE=DISK ADDRESS OFFSET (IN HOSTSECTOR COUNT)
	CALL	CORVBLK
	POP	H	;ADD IN RELATIVE ADDRESS =HL
	DAD	D
	XCHG
	MOV	A,C	;A=UPPER BYTE ADDRESS
	ACI	0
SET0:	RLC		;SHIFT OVER 4 PLACES
	RLC
	RLC
	RLC
	MOV	C,A	;SAVE IT
	LDA	CDRIVE	;GET CORVUS DRIVE # (1-4)
	ADD	C	;MERGE IN EXTENDED DISC ADDRESS BITS
;
;	   WE NOW HAVE  DE=LOWER TWO BYTES OF DISC ADDRESS
;	                ACC=EXTENDED DISC ADDRESS+DRIVE #
;
SET1:	CALL	WAITO	;SEND DRIVE # TO CONTROLLER
	MOV	A,E
	CALL	WAITO	;SEND LOWER DISC ADDRESS TO CONTROLLER
	MOV	A,D
	JMP	WAITO

;****************************************************
;* CONVERT 128-BYTE DISK ADDR AT (HL) TO HOST ADDR, *
;* CONVERT 128-BYTE SECTOR CT IN B TO HSTSEC CT     *
;****************************************************
CORVBLK:LDA	SECMSK	;B=(B+CPMSECTORS/HOSTSECTOR-1)
	ADD	B
	MOV	B,A
	MOV	E,M	;CDE=M(HL)
	INX	H
	MOV	D,M
	INX	H
	MOV	C,M
	LDA	SECSHF		;CDE=CDE SHR (SECSHF)
	DB	JR,CORVB2-$-1	;B=B SHR (SECSHF)
CORVB1:	DW	SRLB
	DW	SRLC
	DW	RRD
	DW	RRE
CORVB2:	DCR	A
	DB	JRNZ,CORVB1-$+0FFH
	RET

;**********************************************
;* CONSTELLATION    DRIVE LINKAGE JUMP TABLE  *
;*		    Used by Corvus utilities  *	
;**********************************************
DRVTAB:	JMP	INACV	;WRITE BYTE TO CONTROLLER
	JMP	OUTACV	;READ BYTE FROM CONTROLLER
	JMP	CRDY	;GET DRIVE READY STATUS
;	JMP	CBDIR	;GET DRIVE BUS DIRECTION
CBDIR:	IN	STAT
	CMA
	ANI	DIFAC	;LOOK AT BUS DIRECTION BIT ONLY
	RET

CRDY:	IN	STAT
	CMA
	ANI	DRDY	;LOOK AT DRIVE READY BIT ONLY
	RET

OUTACV:	PUSH	PSW
	MVI	A,MODO	;EXCHANGE MODES
	OUT	COMDD
	POP	PSW
	OUT	DATA
	MVI	A,09H
	OUT	COMDD
	DCR	A
	OUT	COMDD
	RET

INACV:	MVI	A,MODI	;EXHANGE MODES
	OUT	COMDD
	MVI	A,09H
	OUT	COMDD
	IN	DATA
	MOV	C,A
	MVI	A,08H
	OUT	COMDD
	MOV	A,C
	RET

;*****************************
;  --FLOPPY DISK ROUTINES--  *
;*****************************

;*****************
;*  HOME FLOPPY  *
;*****************
HOMEF:	CALL	MTRON	;TURN MOTOR ON
	MVI	A,2
	OUT	DSEL	;SINGLE DENSITY
	LXI	B,0
	CALL	SETTRK
	XRA	A
	CALL	OUTRK
	OUT	DDATA	;TRACK # 0
	MVI	A,1CH	;3MS SEEK /HEADLOAD & VERIFY
	CALL	DCOMM
	IN	DSTAT	;READ STATUS
	ANI	91H
	DB	JRZ,HOME1-$-1	;OK IF ZERO.
	MVI	A,9	;6MS RESTORE W/BEGIN HEAD LOAD
	CALL	DCOMM	;
	IN	DSTAT
	ANI	91H
	JNZ	SEEKT0	;IF NOT OK, SEEK TRACK 0
HOME1:	JMP	MTROFF

;*******************
;*  SELECT FLOPPY  *
;*******************
SELDF:
	MOV	A,C
	SUI	NPSUDO-1; /*A=FLOPPYDRIVE#(0 OR 1)+1*/
	DB	JRC,SLFERR-$-1	;  IF (C) THEN SELECT ERROR
	XRI	3	;  CHANGE DRIVE
	OUT	DCONT	;
	MOV	A,M	;  IF (TRACK=0FFH) SET SIDE 0
	INR	A	;
	DB	JRNZ,SELDF2-$-1
	MVI	A,8	;
	OUT	DCONT	;
SELDF2:	CALL	MTRON	;WAIT FOR DRIVE READY
	MOV	A,C	;CLEAR NEWDISK REQUEST
	STA	CURDSK	;
	CALL	BLDPTR	;BUILD POINTER TO PARM. HDR.
	CALL	DENSITY	;SET DENSITY PARMS FOR FLOPPY DISK (C).
	CALL	MTROFF	;
	XRA	A	;
	RET		;END SELDF1.

SLFERR:	LXI	H,SLFMSG;PRINT ERR MESSAGE
	CALL	PMSG
	JMP	WBOOT	;WARMBOOT

;***********************************************
;DENSITY: SET DRIVE PARMS FOR FLOPPY DRIVE # (C)
;	C:	FLOPPY DRIVE # (DF0 - DF0+3)
;	HL:	-> DISK PARAMETER HEADER (IN DPBASE:)
;	KILLS:	A,BC,DE,FLAGS
;DETERMINE DENSITY OF NEW DISK, SELECT TRANSLATE TABLE
;AND DISK PARM BLOCK, IN DPBASE
;***********************************************
DENSITY:
	PUSH 	H	;SAVE DISKPARM HEADER PTR
	LXI	H,DFLAGS;HL -> DENSITY FLAGS
	MVI	B,0	;
	MOV	A,C	;(ADJUST C FOR FLOPPY=0-3)
	SUI	NPSUDO	;
	MOV	C,A
	DAD	B	;
	MOV	A,M	;
	ORA	A	;GET DENSITY FLAG(C)
	JM	LOGED	;SKIP IF LOGGED IN BEFORE
	PUSH	H	;  SAVE DENSITYFLAGPTR
	CALL	CHKSD	;  CHECK THAT SEKDSK=CURDSK, SELECT IT IF NOT
	LDA	SEKSEC	;  SAVE SECTOR
	PUSH	PSW	;
	LHLD	DMAADD	;  SAVE DMAADD
	PUSH	H	;
	CALL	HOMEF	;  DENSITYFLAG=F(TRACK0,SECTOR1,BYTE7FH)
	MVI	C,1	;
	CALL	SETSEC	;
	LXI	B,DIRBUF;
	CALL	SETDMA	;
	CALL	READ	;
	POP	H	;  RESTORE DMADD
	SHLD	DMAADD	;
	POP	PSW	;  RESTORE SECTOR
	STA	SEKSEC	;
	POP	H	;  RESTORE DENSITYFLAGPTR
	LDA	DIRBUF+07FH;(DENSITYFLAG BYTE)
	CPI	0DDH	;CODE3
	DB	JRZ,LOGDD-$-1
	CPI	0D0H	;CODE4
	DB	JRZ,LOGD0-$-1

LOG00:	MVI	A,82H	;LOGGED DISK IS SINGLE DENSITY
	LXI	B,TRANS	;
	LXI	D,DPSDBK;
	DB	JR,LOGDRV-$-1

LOGED:	CPI	081H	;TEST PREVIOUSLY LOGGED DRIVE PARM
	DB	JRZ,LOGDD-$-1	;AND BRANCH APPROPRIATELY
	CPI	085H	;
	DB	JRNZ,LOG00-$+0FFH

LOGD0:	MVI	A,85H	;LOGGED DISK IS DBL SIDE, DBL DENSITY
	LXI	B,TRANSD;
	LXI	D,DPDDBK1;
	DB	JR,LOGDRV-$-1

LOGDD:	MVI	A,81H	;LOGGED DISK IS SNGL SIDE, DBL DENSITY
	LXI	B,TRANSD;
	LXI	D,DPDDBK;

LOGDRV:	MOV	M,A	;SAVE DISKTYPE IN DENSITY FLAGS
	ANI	3	;STRIP OFF LOGGED IN BIT
	STA	LOGDEN	;SAVE DENSITY OF LOGGED IN DRIVE
	OUT	DSEL	;SET IT
	POP	H	;GET DISKPARMHDR PTR
	PUSH 	H	;SAVE IT FOR RETURN
	MOV	M,C	;SET UP TRANSLATE TABLE PTR IN BLOCK
	INX	H	;
	MOV	M,B	;
	LXI	B,9	;SET UP DISK PARM PTR IN BLOCK
	DAD	B	;
	MOV	M,E	;
	INX	H	;
	MOV	M,D	;
	LXI	H,15	;LET HL->BLOCKING PARMS	(SET BLKG PRMS FOR DISK)
	DAD	D	;
	LXI	D,CPMSPB;LET DE->LOGGEDDRIVE BLOCKINGPARM AREA
	LXI	B,4	;LET BC=#ITEMS TO MOVE
	DW	LDIR	;	(MOVE (HL)=>(DE),BC ITEMS)
	POP	H	;RETURN DISKPARMHDR POINTER
	RET		;


;****************************************************************
;SEEK: MOVE THE HEAD TO THE TRACK IN REGISTER A (= 0-153).
;SEEKT0: MOVE HEAD TO TRACK 0
;****************************************************************
SEEKT0:	XRA	A	;SEEK TRACK 0
SEEK:	CALL	MTRON	;TURN MOTORS ON
	PUSH	B	;SAVE B&C.
	MOV 	B,A	;SAVE DESTINATION TRACK.
	XRA	A	;
	STA	SECNT	;CLEAR SEEK ERROR CTR
	MOV	A,B	;
	ORA	A	;  IF (TK 0) THEN
	MVI	A,2	;	SET UP FOR SINGLE DENS
	DB	JRZ,SEEK1-$-1
	MVI	A,1	;  IF (TK 1) THEN
	CMP	B	;	SET UP FOR DOUBLE DENSITY
	if	ibmb
	DB	JRNZ,SEEK0-$-1	;	(IF A: OR NOT IBM FORMAT SELECTED)
	LDA	CURDSK	;
	ORA	A	;
	MVI	A,1	;
	endif
	DB	JRZ,SEEK1-$-1
SEEK0:	LDA	LOGDEN	;ELSE GET DENSITY OF LOGGED DRIVE.
SEEK1:	OUT	DSEL	;SET DENSITY IN 1793
	MVI	A,RTCNT	;GET RETRY COUNT.
SRETRY:	STA	SERCNT	;STORE IN ERROR COUNTER.
	IN	TRACKF	;READ PRESENT TRACK NO.
	CALL	INTRK	;ADJUST IF 2SIDE
	MOV	C,A	;SAVE IN C. (CURR TK)
	CMP	B	;SAME AS SEEK TRACK NO.? (A IS CURR TK)
	MOV	A,B	;RESTORE A FROM B. (MAKE A DESIRED TK)
	DB	JRZ,THERE-$-1	;IF (THERE) THEN EXIT
	MVI	A,0D0H	;TERMINATE COMMAND AND/OR BUSY
	OUT	DCOM	;
	XTHL		;WASTE
	XTHL		;TIME
	MOV	A,B	;GET TRACK
	CALL	OUTRK	;ADJUST FOR 2-SIDE
	OUT	DDATA	;OUTPUT (SEEK TRACK #)
	MVI	A,1CH	;3MS SEEK W/ HEAD LOAD & VERIFY
	CALL	DCOMM	;
	IN	DSTAT	;READ STATUS.
	ANI	91H	;LOOK AT BITS.
	DB	JRZ,THERE-$-1	;OK IF ZERO.
	MOV	B,A	;SAVE STATUS IN B
	LDA	SECNT	;
	INR	A	;
	STA	SECNT	;ADD 1 TO SEEK ERR CTR
	LDA	SERCNT	;GET ERROR COUNT.
	DCR	A	;DECREMENT COUNT.
	DB	JRNZ,SRETRY-$+0FFH	;RETRY SEK.
	MOV	D,B	;RESTORE STATUS TO D REG
	POP	B	;RESTORE B&C.
	LXI	H,SKMSG	;PRINT "SEEK ".
	JMP	ERMSG	;DO COMMON ERR MESSAGES.

THERE:	POP	B
	JMP	MTROFF	;TURN MOTORS OFF

DCOMM:	OUT DCOM
	EI
	HLT		;INTERUPT CAUSES RETURN
	RET		;WHEN COMMAND COMPLETE

;*****************
;*  READ FLOPPY  *
;*****************
READF:	CALL	MTRON
	CALL	CHKTRK	;CHECK FOR CORRECT CURRENT TRACK, & MOVE
	MVI	A,RTCNT	;GET RETRY COUNT.
RRETRY:	STA	ERCNT	;STORE IN ERROR CTR.
	LXI	H,HSTBUF;GET STARTING ADR.
	MVI	A,0D0H	;CAUSE INTERRUPT.
	OUT	DCOM
	XTHL		;SOME DELAY.
	XTHL
	XTHL
	XTHL
	LDA	HSTSEC	;GET SECTOR NUMBER.
	OUT	SECTP	;SET SECTOR INTO 1793.
	IN	DSTAT	;READ STATUS.
	ANI	20H	;LOOK AT HLD BIT.
	MVI	A,8CH	;READ WITH HEAD LOAD DELAY
	DB	JRZ,READ3-$-1	;HEAD NOT LOADED.
	MVI	A,88H	;CODE FOR READ W/O HD LD DELAY
READ3:	MVI	C,DDATA	;SEND COMMAND TO 1793
	DW	PUSHIX
	CALL	RLOOP
	DW	POPIX
	IN	DSTAT	;DONE: READ DISK STATUS.
	ANI	9DH	;LOOK AT ERROR BITS.
	JZ	MTROFF	;IF NO ERROR THEN RETURN
	CALL	ERCHK	;CHECK FOR SEEK ERROR.
	LXI	H,RECNT	;GET RD ERR COUNT ADDR.
	INR	M		;ONE MORE ERROR.
	LDA	ERCNT	;GET ERROR COUNT.
	DCR	A		;DECREMENT COUNT.
	DB	JRNZ,RRETRY-$+0FFH	;TRY TO READ AGAIN.
	LXI	H,RDMSG	;PRINT "READ ".
ERMSG:	CALL	PMSG	;PRINT ORIGIN MESSAGE.
ERMSG1:
	MOV	A,D	;GET ERROR BITS.
	RAL		;IF BIT 7 HIGH,
	LXI	H,NRMSG	;"NOT READY".
	DB	JRC,ERMSG2-$-1
	MOV	A,D	;GET ERROR BITS.
	ANI	10H	;IF BIT 4 IS HIGH,
	LXI	H,RNMSG	;PRINT "RECORD NOT FOUND"
	CNZ	PMSG
	MOV	A,D	;GET ERROR BITS.
	ANI	8H	;IF BIT 3 IS HIGH,
	LXI	H,CRCMSG	;PRINT "CRC ERROR".
	CNZ	PMSG
	MOV	A,D	;GET ERROR BITS.
	ANI	4H	;IF BIT 2 IS HIGH,
	LXI	H,LDMSG	;PRINT "LOST DATA".
	CNZ	PMSG
	MOV	A,D	;GET ERROR BITS.
	RAR		;IF BIT 1 IS HIGH,
	LXI	H,BSYMSG;PRINT "BUSY".
ERMSG2:	CC	PMSG
PERMSG:	LXI	H,ERRMSG	;PRINT "ERROR."
	CALL	PMSG
	CALL	MTROFF	;TURN MOTORS OFF
	MVI	A,1	;SET FOR PERM ERR MSG.
	ORA	A		;SET FLAGS.
	RET

RLOOP:	DW	LDIX,RL1
	OUT	DCOM	;
	EI		;
RL1:	HLT		;
	DW	INI
	EI		;
	DW	JPIX

; ERCHK - CHECK FOR RECORD NOT FOUND ERROR.
ERCHK:	MOV	D,A	;SAVE ERROR BITS IN D.
	ANI	10H	;IF RECORD NOT FOUND,
	CNZ	CHKSK	;DO A CHECK ON SEEK.
	MOV	A,D	;RESTORE BITS
	ORA	A	;SET FLAGS,
	RET		;AND RETURN.

;CHECK FOR SEEK TO CORRECT TRACK,
;AND CHANGE IF NECESSARY.
CHKSK:	PUSH	H	;
	MVI	A,0C4H	;COMMAND TO READ ADDRESS
	MVI	C,DDATA	;
	LXI	H,DIRBUF
	DW	PUSHIX
	CALL	RLOOP	;
	DW	POPIX
	LDA	DIRBUF	;
	MOV	B,A	;
	POP	H	;DMAADD: TRK,SIDE,SECTOR,SECL,CRC,CRC
CHKS3:	IN	DSTAT	;READ DISK STATUS.
	ORA	A	;SET FLAGS.
	DB	JRZ,CHKS4-$-1	;READ ADR OK IF 0.
	CALL	HOMEF	;OTHERWISE, HOME FIRST.
	DB	JR,CHKTRK-$-1
CHKS4:
	MOV	A,B	;UPDATE TRACK REGISTER.
	CALL	OUTRK	;ADJUST IF 2SIDE
	OUT	TRACKF	;
;*********************************************
;CHKTRK: IF CURRENT TRACK <> HOST TRACK, GO TO HOST TRK
;*********************************************
CHKTRK:	IN	TRACKF
	CALL	INTRK
	LXI	H,HSTTRK
	CMP	M
	RZ		;TRACKS ARE THE SAME, RETURN
	MOV	A,M	;TRACKS NOT SAME, CORRECT
	JMP	SEEK	;

;******************
;*  WRITE FLOPPY  *
;******************
WRITEF:	CALL	MTRON	;TURN MOTORS ON
	CALL	CHKTRK	;GO TO CORRECT TRACK
	MVI	A,RTCNT	;GET RETRY COUNT.
WRETRY:	STA	ERCNT	;STORE IN ERROR COUNTER.
	LXI	H,HSTBUF ;GET STARTING ADR.
	MVI  	A,0D0H	;STATUS INTERUPT FOR 1793.
	OUT	DCOM	;COMMAND 1793.
	XTHL
	XTHL
	XTHL
	XTHL
	LDA	HSTSEC	;GET SECTOR NUMBER.
	OUT	SECTP	;SET THE SECTOR INTO 1793.
	IN	DSTAT	;GET 1793 STATUS.
	ANI	20H	;CHECK FOR HEAD LOAD.
	MVI	A,0ACH	;SET UP 1793 FOR WRITE.
	DB	JRZ,WRITE2-$-1	;HEAD IS NOT LOADED.
	MVI	A,0A8H	;CODE FOR WRITE W/O HD LD.
WRITE2:	LXI	B,DDATA	;(B=0,C=DDATA)
	DW	PUSHIX
	DW	LDIX,WL1
	CALL	WLOOP		;
	DW	POPIX
	IN	DSTAT	;DONE: READ DISK STATUS.
	ANI	0FDH	;LOOK AT THESE BITS.
	STA	HSTWRT	;CLEAR PENDINGWRITEFLAG IF NO ERROR
	JZ	MTROFF	;RETURN IF NO ERROR.
	CALL	ERCHK	;CHECK/CORRECT SEEK ERR.
	LXI	H,WECNT	;GET ADR OF WRITE ERR CTR.
	INR	M	;ONE MORE WRITE ERROR.
	LDA	ERCNT	;GET ERROR COUNT.
	DCR	A	;DECREMENT COUNT.
	DB	JRNZ,WRETRY-$+0FFH	;TRY TO WRITE AGAIN.
	LXI	H,WTMSG	;PRINT "WRITE ".
	CALL	PMSG
	MOV	A,D	;GET ERROR BITS.
	ANI	40H	;LOOK AT BIT 6.
	LXI	H,WPMSG	;PRINT "PROTECT ".
	CNZ	PMSG
	MOV	A,D	;GET ERROR BITS.
	ANI	20H	;LOOK AT BIT 5.
	LXI	H,WFMSG	;PRINT "FAULT ".
	CNZ	PMSG
	JMP	ERMSG1	;DO COMMON MESSAGES.

WLOOP:	OUT	DCOM
	EI
WL1:	HLT
	DW	OUTI
	EI
	DW	JPIX


;****************************************
;* ADJUST PHYSICAL TRACK# IF LOGICAL>76 *
;****************************************
INTRK:	;TRACK # IN A INCREASED BY 77 IF SIDEFLG NON-ZERO
	PUSH	PSW	;
	LDA	SIDEFLG
	ORA	A
	DB	JRZ,INTRK1-$-1	;JUMP IF < TRACK 77
	POP	PSW	;
	ADI	77
	RET
INTRK1:	POP	PSW	;
	RET

OUTRK:	;TRACK # IN A REDUCED BY 77 IF >76 AND SET SIDEFLG NON-ZERO
	PUSH	PSW
	CPI	77
	DB	JRC,OUTRK1-$-1
	MVI	A,4
	STA	SIDEFLG
	OUT	DCONT
	POP	PSW	;
	SUI	77
	ANI	7FH
	RET
OUTRK1:	MVI	A,8
	OUT	DCONT
	XRA	A
	STA	SIDEFLG
	POP	PSW	;
	ANI	7FH
	RET


;****************************************
; DRIVE MOTOR CONTROL    ON/OFF
;****************************************
MTRON:	PUSH	PSW
	CALL	MTRON0
	POP	PSW
	RET

MTRON0:	MVI	A,8	;TURN DRIVE MOTOR ON
	OUT	DSEL
	MVI	A,0D0H	;1793 FORCE INTERRUPT COMMAND
	OUT	DCOM
	IN	DSTAT	;IF (READY) THEN RETURN
	RAL
	RNC
MTRON1:	IN	DSTAT	;ELSE DO
	RAL		;  REPEAT
	DB	JRC,MTRON1-$+0FFH;    UNTIL (READY)
	PUSH	H	;  /*Check spindle speed*/
	PUSH	B
	LXI	B,-19700;  REPEAT
SPIN:	LXI	H,0	;    HL=0
SPIN1:	IN	DSTAT	;    REPEAT
	ANI	2
	DB	JRZ,SPIN1-$+0FFH;     UNTIL (INDEX PULSE)
SPIN2:	IN	DSTAT	;    REPEAT
	ANI	2
	DB	JRNZ,SPIN2-$+0FFH; UNTIL (NO INDEX PULSE)
SPIN3:  INX	H	;    REPEAT
	IN	DSTAT	;      HL++
	ANI	2
	JZ	SPIN3	;      UNTIL (INDEX PULSE)
	DAD	B	;    UNTIL (HL<19700)
	JC	SPIN
	POP	B
	POP	H
	RET

MTROFF:
	PUSH	PSW	;TURN DRIVE MOTOR OFF
	MVI	A,4	;(DRIVE STOPS ~20 SECS AFTER COMMAND)
	OUT	DSEL
	POP	PSW
	RET


;**********************************************
;*             I/O ROUTINES                   *
;**********************************************

;******** PRINT ACC IN HEX ********
PRTHEX:	PUSH	PSW	;SAVE BYTE
	RRC		;SHIFT UPPER NYBBLE DOWN 4 BITS
	RRC		;
	RRC		;
	RRC		;
	CALL	PRTHX1	;OUTPUT UPPER NYBBLE IN HEX
	POP	PSW	;RESTORE BYTE
PRTHX1:	PUSH	PSW	;
	ANI	0FH	;MASK OUT UPPER NYBBLE
	ADI	90H	;
	DAA		;
	ACI	40H	;
	DAA		;
	CALL	CONOUTA	;
	POP	PSW	;
	RET		;

CONOUTA:	;print acc
	PUSH	B
	ANI	7FH
	MOV	C,A
	CALL	LCONOUT
	POP	B
	RET

PCRLF:	LXI	H,CRLF	;PRINT CRLF
PMSG:	MOV	A,M	;GET MESSAGE BYTE
	CALL	CONOUTA	;PRINT IT
	ORA	M	;GET BYTE AGAIN, SET FLAGS
	RM		;IF MSB SET, RETURN
	INX	H	;
	JMP	PMSG	;

;**************************************************
;*		I/O DEVICE DRIVERS		  *
;* See IOBYTE description at beginning of listing *
;**************************************************

LCONST:	PUSH	D	;LOGICAL CONSOLE INPUT DEVICE STATUS
	CALL	DISPATCH0
	DW	CONST	;00=Console
	DW	CONST	;01=Console
	DW	MODST	;10=Modem
	DW	NULLRDY	;11=Clock (Always ready)

LCONIN:	PUSH	D	;LOGICAL CONSOLE INPUT DEVICE
	CALL	DISPATCH0
	DW	CONIN	;00=Console
	DW	CONIN	;01=Console
	DW	MODEMIN	;10=Modem
	DW	RCLOCK	;11=Clock

LCONOUT:PUSH	D	;LOGICAL CONSOLE OUTPUT DEVICE
	CALL	DISPATCH0
	DW	CONOUT	;00=Console
	DW	CONOUT	;01=Console
	DW	MODEMO	;10=Modem
	DW	WCLOCK	;11=Clock

LREADER:PUSH	D	;LOGICAL READER DEVICE
	MVI	E,2
	CALL	DISPATCH
	DW	NULLIN	;00= not used
	DW	NULLIN	;01= not used
	DW	MODEMIN	;10=Modem
	DW	RCLOCK	;11=Clock

LPUNCH:	PUSH	D	;LOGICAL PUNCH DEVICE
	MVI	E,4
	CALL	DISPATCH
	DW	PLLPRN	;00=Parallel printer
	DW	NULLOUT	;01= not used
	DW	MODEMO	;10=Modem
	DW	WCLOCK	;11=Clock

LLISTST:		;LOGICAL LIST DEVICE STATUS
NULLRDY:XRA	A	;RETURN STATUS (0 IF READY, NON-0 IF NOT)
	RET

LLIST:	PUSH	D	;LOGICAL LIST DEVICE
	MVI	E,6
	CALL	DISPATCH
	DW	PLLPRN	;00=Parallel printer
	DW	CONOUT	;01=Console output
	DW	ETXACK	;10=Serial, ETX/ACK protocol
	DW	XONXOFF	;11=Serial, XON/XOFF protocol


DISPATCH0:
	MVI	E,8
DISPATCH:
	LDA	IOBYTE	;Get byte from IOBYTE
DISP1:	RRC		;ROTATE BITS OF INTEREST INTO LSB.
	DCR	E
	DB	JRNZ,DISP1-$+0FFH
	ANI	3	;Mask for desired bits
	XTHL		;Push HL, Pop (Table Address)
	MOV	E,A
	MVI	D,0	;HL -> Table Item
	DAD	D
	DAD	D
	MOV	E,M	;HL = Table Item
	INX	H
	MOV	D,M
	XCHG
	POP	D	;Restore caller's HL,DE, Push Table Item
	XTHL
	XCHG
	RET		;GO TO TABLE ITEM


CONST:	IN	CSTAT	;IF(CONSOLE RDY) THEN RETURN (NZ)
	ANI	2
	DB	JRNZ,CONST1-$-1
	LDA	SYSFMT	;IF (NO AUTOSWITCH) THEN RETURN (Z)
	ANI	4
	XRI	4
	RZ
MODST:	IN	MSTAT	;RETURN (MODEM STATUS)
	ANI	2
	RZ
CONST1:	ORI	0FFH
	RET

CONINA:	LDA	SYSFMT	;IF (AUTOSWITCH)...
	ANI	4
	DB	JRNZ,CONIN-$-1
	CALL	MODST	; ..AND (MDM CHAR RDY) THEN READ MDM CHAR,RETURN
	DB	JRNZ,MODEMIN-$-1
CONIN:	IN	CSTAT	;(***ENTRY POINT***)
	ANI	2	;IF (CON CHAR NOT RDY) GOTO CONINA
	DB	JRZ,CONINA-$+0FFH
	IN	CDATA	;ELSE READ CON CHAR
	ANI	7FH
	RET

MODEMIN:IN	MSTAT
	ANI	02H
	DB	JRZ,MODEMIN-$+0FFH
	IN	MDATA
	RET

CONOUT:	IN	CSTAT	;OUTPUT (C) TO CONSOLE
	RAR
	DB	JRNC,CONOUT-$+0FFH
	MOV	A,C
	OUT	CDATA
	LDA	SYSFMT	;IF (AUTOSWITCH) AND (MODEM CTS ACTIVE) THEN
	ANI	4
	RNZ
	IN	MSTAT	;  (CTS)
	RAL
	RC
MODEMO:	IN	MSTAT	;OUTPUT TO MODEM
	RAR
	DB	JRNC,MODEMO-$+0FFH
	MOV	A,C
	OUT	MDATA
	RET


XONXOFF:	;START OF X-ON X-OFF
	IN	LDATA
	ANI	1FH	;MASK MSB'S
	CPI	13H	;CHECK FOR X-OFF
	DB	JRNZ,XONX2-$-1	;IF NOT THEN OUTPUT CHAR
XONX1:			;IF SENT THEN WAIT FOR X-ON
	IN	LDATA
	ANI	1FH	;MASK MSB'S
	CPI	11H	;X-ON CHAR ?
	DB	JRNZ,XONX1-$+0FFH	;IF NOT GOBACK
XONX2:	IN	LSTAT
	ANI	81H	;SEND CHAR
	CPI	81H
	DB	JRNZ,XONX2-$+0FFH
	MOV	A,C
	OUT	LDATA
	RET

PLLPRN:			;PARALLEL PORT DRIVER
	MVI	A,81H
	OUT	0D3H		;8255 CONTROL PORT
PLLP1:	IN	0D2H		;8255 STATUS PORT
	ANI	4
	DB	JRNZ,PLLP1-$+0FFH		;LOOP UNTIL NOT BUSY
	MOV	A,C
	OUT	0D1H		;OUTPUT DATA TO PORT B
	MVI	A,0BH
	OUT	0D3H		;STROBE
	DCR	A
	OUT	0D3H
	RET

ETXACK:	IN	LSTAT
	RAR
	DB	JRNC,ETXACK-$+0FFH
	MOV	A,C
	OUT	LDATA
	LDA	PCOUNT
	DCR	A
	STA	PCOUNT
	RP
	MVI	A,80H
	STA	PCOUNT
	MVI	C,3
	CALL	ETXACK
ACKCHK: IN	LSTAT
	ANI	2
	DB	JRZ,ACKCHK-$+0FFH
	IN	LDATA
	ANI	7FH
	CPI	6
	DB	JRNZ,ACKCHK-$+0FFH
	RET

NULLIN:	MVI	A,1AH	;NULL INPUT DEVICE - RETURN CONTROL-Z
NULLOUT:RET		;NULL OUTPUT DEVICE

;*****************************************************************
;CLOCK READ/WRITE ROUTINES
;*****************************************************************
RCLOCK:	PUSH	B
	LDA	PASSADD		
	DCR	A	;DECREMENT PASS COUNTER(RANGE:15H-0-0FDH)
	STA	PASSADD
	CPI	0DH	;CHECK TO SEE IF AT BEGINNING
	JM	RCLOC1	
	MVI	A,' '	;IF NOT, RET WITH A SPACE
	POP	B
	RET

RCLOC1:	ORA	A	;CHECK TO SEE IF ALL PASSES	
	JP	RCLOC2	;   COMPLETED
	POP	B
	CPI	0FEH
	MVI	A,' '	;(RETURN {'.',' ',CR} AFTER STRING)
	RZ		;  (2ND CHAR AFTER)
	MVI	A,'.'
	RNC		;  (1ST CHAR AFTER)
	MVI	A,15H
	STA	PASSADD
	MVI	A,0DH	;  (3RD CHAR AFTER)
	RET


RCLOC2:	MVI	A,40H		
	OUT	0CCH	;TURN ON CLOCK
	MVI	B,60H
RCLOC3:	DCR	B	;WAIT
	JNZ	RCLOC3
	LDA	PASSADD
			;CONVERT PTR=(12-0) TO (10,9,8,7,12,11,6-0)
	CPI	7	;THIS MAKES DATA ORDER=MMDDYYwHHMMSS
	DB	JRC,RCLOC4-$-1	;MUCH MORE CONVEVIENT TO USE
	SUI	2	;
	CPI	7	;
	DB	JRNC,RCLOC4-$-1
	ADI	6	;
RCLOC4:	ORI	0C0H	;CONVERT TO CLOCK CHIP I/O PORT#
	MOV	C,A	;SET UP OUTPUT ADDRESS
	MVI	A,50H
	DW	OUTCA	;TOGGLE CLOCK	
	DW	INAC
	CALL	SWAP	;FLIP THE BITS
	ADI	30H
	PUSH	PSW
	XRA	A
	OUT	0C0H	;RESET CLOCK
	POP	PSW
	POP	B	;RETURN WITH DATA IN ACC.
	RET


WCLOCK:	MOV	A,C	;IF (CHAR < '0') THEN RETURN
	ANI	07FH
	SUI	'0'
	RC	
	CPI	9+1+1	;IF (CHAR < '9'+1) THEN DO
	DB	JRNC,WCLK2-$-1	; (NOTE: '9'+1=':', NEEDED FOR 24 HR MODE SET)
	CALL	SWAP
	MOV	B,A
	LDA	CLKDIR	;IF ('DIRECTOR' < 'A') THEN RETURN
	CPI	'A'-40H	
	RC
	CPI	'M'+1-40H;IF ('DIRECTOR' > 'M') THEN RETURN
	RNC
	DCR	A
	CPI	6
	DB	JRNC,WCLOC0-$-1
	ADI	2
	CPI	6
	DB	JRC,WCLOC0-$-1
	SUI	6
WCLOC0:	INR	A
	MOV	C,A		
	MVI	A,40H
	OUT	0C0H	;ISSUE HOLD COMMAND
	MVI	A,0BFH+14;PORT BASE ADDRESS 
	SUB	C	;ADD ADDRESS TO BASE PORT
	MOV	C,A	;('A'=13, 'M'=1)
	MVI	A,60H
TIML1:	DCR	A
	JNZ	TIML1	;200US MIN TIME FROM HOLD
	MVI	A,40H	;SET UP ADDRESS
	ADD	B	;DATA WORD IN B
	DW	OUTCA	;OUT (C),A
	XTHL
	XTHL		;DELAY
	ORI	20H	;TURN ON WRITE
	DW	OUTCA
	XTHL
	XTHL		;DELAY
	ANI	4FH	;TURN OFF WRITE
	DW	OUTCA
	XRA	A
	OUT	0C0H	;TURN OFF CLOCK
	LDA	CLKDIR
	INR	A
	STA	CLKDIR	;RESET DIRECTOR
	RET

WCLK2:	CPI	'A'-'0'
	RC		;RETURN IF < ASCII "A"
	CPI	'M'-'0'+1
	RNC		;RETURN IF > ASCII "M"
	ANI	0FH	;STRIP OFF ASCII
	STA	CLKDIR	;STORE DIRECTOR
	RET

SWAP:	MOV	B,A
	XRA	A	;SWAP BITS 0-4,1-3
	DW	RRCB
	RAL
	DW	RRCB
	RAL
	DW	RRCB
	RAL
	DW	RRCB
	RAL
	RET

;*************************************************************
;	End of I/O routines
;*************************************************************

;
;-------- MESSAGES -----------
;

BEMSG:	DB	CR,LF,07,'Boot Error'
CRLF:	DB	CR,LF+80H
CERMSG:	DB	CR,LF,07,'Corvus Error #',' '+80H
CERMSG1: DB	'H',CR,LF+80H
NRMSG:	DB	'READ','Y'+80H
RNMSG:	DB	'ID NOT FOUN','D'+80H
CRCMSG:	DB	'CR','C'+80H
LDMSG:	DB	'LOST DAT','A'+80H
BSYMSG:	DB	'BUS','Y'+80H
WPMSG:	DB	'PROTEC','T'+80H
WFMSG:	DB	'FAUL','T'+80H

SLFMSG:	DB	'FLOPPY SELECT'
ERRMSG:	DB	' ERRO','R'+80H
RDMSG:	DB	CR,LF,'READ',' '+80H
WTMSG:	DB	CR,LF,'WRITE',' '+80H
SKMSG:	DB	CR,LF,'SEEK',' '+80H

ROMSG:	DB	CR,LF,'ERROR: Volume is READ-ONL','Y'+80H
MTMSG:	DB	CR,LF,'ERROR: Volume is not mounte','d'+80H


;ERROR COUNTS.  THESE LOCATIONS KEEP TRACK OF THE
;NUMBER OF ERRORS THAT OCCUR DURING READ, WRITE,
;OR SEEK OPERATIONS.  THEY ARE INITIALIZED ONLY
;WHEN A COLD-START IS PERFORMED BY THE BOOOTSTRAP.
;
RECNT:	DB	0	;READ ERROR COUNT.
WECNT:	DB	0	;WRITE ERROR COUNT.
SECNT:	DB	0	;SEEK ERROR COUNT.
ERFLAG:	DB	0	;CPM BLOCKING ERROR FLAG

;******************BIOS VARIABLES******************
SIDEFLG: DB	0	;HEAD 2 SELECT FLAG (0=SIDE 1, NZ=SIDE 2)
TRTAB:	DB	0FFH,0FFH,0FFH,0FFH ;TRACK TABLE: PRESENT HEAD POSITION
				;FOR FOUR DRIVES.
PASSADD:DB	15H	;PASS COUNT & CLOCK REG PTR
CLKDIR:	DB	00H	;CLOCK DIGIT 'DIRECTOR'

ERCNT:	DB	0	;ERROR COUNT FOR RETRIES.
SERCNT:	DB	0	;SEEK RETRY COUNTER.

CURDSK:	DB	0	;CURRENTLY SELECTED DISK

SEKDSK:	DB	0	;CURRENTLY REQUESTED DISK.	*******
SEKTRK:	DW	0000H	;CURRENTLY REQUESTED TRACK.	*DO NOT
SEKSEC:	DB	1	;CURRENTLY REQUESTED SECTOR.	*RE-ARRANGE
SEKHST:	DB	1	;CURRENTLY REQUESTED HOSTSECTOR.*******

HSTDSK:	DB	0FFH	;HOSTBUFFER DISK.		*******
HSTTRK:	DW	0FFFFH	;HOSTBUFFER TRACK.		*DO NOT
	DB	0FFH	;not used, reserved		*RE-ARRANGE
HSTSEC:	DB	0FFH	;HOSTBUFFER SECTOR.		*******

UNADSK:	DB	0	;LAST UNALLOCATED DISK.		*******
UNATRK:	DW	0000H	;LAST UNALLOCATED TRACK.	*DO NOT
UNASEC:	DB	0	;LAST UNALLOCATED SECTOR.	*RE-ARRANGE
	DB	0	;not used, reserved		*******

CPMSPB:	DB	8	;BLOCKSIZE/128	    *******BLOCKING PARMS********
SECMSK:	DB	0	;HSTSIZF/128-1	    **    DON'T RE-ARRANGE     **
SECSHF:	DB	0+1	;LOG2(HSTSIZF/128)+1 **PARMS ARE FOR LOGGED DISK**
CPMSPT:	DB	26	;TRACKSIZE/128	    *****************************
LOGDEN:	DB	2	;DENSITY OF LOGGED FLOPPY (2=SGL,1=DBL,0=none)

HSTACT:	DB	0	;HOST BUFFER ACTIVE FLAG
HSTWRT:	DB	0	;HOST BUFFER WRITE FLAG

UNACNT:	DB	0	;UNALLOCATED RECORD COUNT

RSFLAG:	DB	0	;READ SECTOR FLAG
READOP:	DB	0	;READ OPERATION FLAG
WRTYPE:	DB	0	;WRITE OPERATION TYPE

DMAX:	DB	1	;MAX DRIVE # (1=B:,2=C:)
DMAADD:	DW	0080H	;CURRENT READ/WRITE ADDRESS.
PCOUNT:	DB	128	;COUNTER FOR ETX/ACK:


;****************************************************************
;* CORVUS & CONSTELLATION TABLES:				*
;****************************************************************
ADDOF:	DW	VOL1+3	;BUFFER FOR POINTER TO ADDRESS OFFSET
CDRIVE:	DB	1	;BUFFER FOR CORVUS DISC #
VOLNUM:	DW	1	;VOLUME NUMBER CURRENTLY IN USE

CORTAB:	DB	'CORTAB';IDENTIFIER (DO NOT CHANGE)
	DB	0	;BIOS VERSION #
	DW	VOLTAB	;POINTER TO VOLUME TABLES
	DW	DRVTAB	;POINTER TO DISK LINK TABLE
VPTR:	DW	0	;POINTER TO CURRENT VOLUME TABLE (0=FLOPPY)
	DW	0	;POINTER TO FLOPPY INIT ROUTINE (0=IGNORE)


;  --- CORVUS VOLUME TABLES ---
;  THIS AREA IS A 'CORVUS USER AREA' TO SPECIFY THE LOCATIONS
;  OF VOLUMES (AND THEIR SIZES) ON THE CORVUS DRIVE.  THE FORMAT
;  IS FIXED, AND IS ASSUMED BY VARIOUS CORVUS UTILITIES THAT
;  MOUNT AND DISMOUNT VOLUMES, AS WELL AS UTILITIES SUCH AS
;  THE 'MIRROR' PROGRAM, THAT MUST BE ABLE TO DETERMINE WHERE
;  A SPECIFIC VOLUME IS ON THE CORVUS DRIVE.

VOLTAB:	DW	0	;USER# (0=SYSTEM MANAGER),PATCHED BY 'HELLO' PGM.
	DB	0	; STARTING PSEUDO DRIVE #
	DB	NPSUDO	; # PSEUDO DRIVES ALLOWED
	DB	NSEC	;LENGTH OF WARMBOOT CODE (WARMBOOT MUST READ FROM HERE)
	DB	BDRIVE	;CORVUS DRIVE # (1-4)
	DW	CSEC	;24 BIT ADDRESS OF STARTING DISK ADDRESS OF CODE TO
	DB	0	;	BE READ BACK IN IN WARMBOOT.
	DW	DPB0	;POINTER TO START OF TABLE AREA
	DW	ENDBUF	;POINTER TO END OF BUFFER+1
	DW	DIRBUF	;POINTER TO DIRECTORY BUFFER
			;  TFREE, BFREE ARE CHANGED TO ALLOCATE, DE-ALLOCATE
			;  SPACE WHEN VOLUMES ARE MOUNTED AND DISMOUNTED BY
			;  UTILITY PROGRAMS.
	DW	TFREE	;START OF SPACE AVAIL. FOR TABLES
	DW	BFREE	;TOP OF USED BUFFER SPACE
	DB	0,0,0	; RESERVED FOR FUTURE USE

;******START OF  VOLUME DESCRIPTION  TABLES******
;		(24 BYTES/VOLUME)


;***SYSTEM VOLUME***
VOL1:	DW	1	;VOLUME# (SET TO 0 TO DISMOUNT)
			;THE 15TH BIT CAN BE SET TO
			;1 TO MAKE THE VOLUME READ ONLY.
	DB	1	;ACTUAL CORVUS DRIVE # (1-4)
	DW	DSEC	;LOWER 16 BITS OF 24 BIT DISK ADDR FOR START OF VOL.
	DB	0	;UPPER 8 BITS OF ADDRESS
	DB	0,0	;RESERVED FOR FUTURE USE
	DW	0,0		;CP/M PARAMETER HEADER
	DW	0,0		;
	DW	DIRBUF,DPB0	;
	DW	CSV0,ALV0	;CHECK VECTOR, ALLOCATION MAP

;***USER VOLUMES***
	DS	(NPSUDO-1)*24	;ROOM FOR OTHER VOLUMES. NOTE: IF MORE THAN
				;ONE VOLUME IS TO BE INSTALLED ON A NON-
				;CONSTELLATION SYSTEM, THEY MUST BE EXPLICITLY
				;DEFINED HERE, USING THE FORMAT OF VOL.1.

;***TABLE BUFFERS***
	if	CNSTLL	;INIT FOR CONSTELLATION HOME VOLUME
DPB0:	DW	64	;SECTORS/TRACK FOR VOLUME - SPT
	DB	3	;BLOCK SHIFT FACTOR - BSH
	DB	7	;BLOCK MASK - BLM
	DB	0	;EXTENT MASK - EXM
	DW	100-1	;DISK SIZE (IN BLOCKS) - DSM
	DW	64-1	;# DIRECTORY ENTRYS - DLM
	DB	0C0H	;ALLOC0 (DIRECTORY BLKS) - AL0
	DB	0	; - AL1
	DW	0	;DIR CHECK SIZE - CKS
	DW	0	;# OF RESERVED TRACKS - OFF
	endif
	if	not CNSTLL	;INIT FOR 5 MEG CORVUS
DPB0:	DW	64	;SECTORS/TRACK FOR VOLUME - SPT
	DB	6	;BLOCK SHIFT FACTOR - BSH
	DB	63	;BLOCK MASK - BLM
	DB	3	;EXTENT MASK - EXM
	DW	700-1	;DISK SIZE (IN BLOCKS) - DSM
	DW	256-1	;# DIRECTORY ENTRYS - DLM
	DB	80H	;ALLOC0 (DIRECTORY BLKS) - AL0
	DB	0	; - AL1
	DW	0	;DIR CHECK SIZE - CKS
	DW	0	;# OF RESERVED TRACKS - OFF
	endif

;****************************************************************
TFREE:	;START OF 'FREE BUFFER'					*
	;ALLOW SPACE FOR 2 DPBH (15 BYTES) + 3 ALLOC VECT.(99)  *
	;THE COLD-BOOT ROUTINE HERE WILL BE OVER-WRITTEN.	*
SFREE	EQU	2*15+3*99	;FREE SPACE REQUIRED		*
;****************************************************************
CSV0:	DS	0	;SAVE NO SPACE FOR DISK CHECK VECTOR
ALV0:			;ALLOCATION VECTOR OVERWRITES BOOT

BOOT:	LXI	H,WBOOT	;RE-DIRECT CBOOT TO WBOOT
	SHLD	CBOOT+1
	LXI	SP,80H	;SETUP TEMP. STACK
	MVI	A,0A6H	;INIT 8251 I/O PORTS
	CALL	INITSIO
	MVI	A,40H
	CALL	INITSIO
	LDA	UARTT
	OUT	CSTAT
	LDA	UARTP
	OUT	LSTAT
	LDA	UARTM
	OUT	MSTAT
	MVI	A,27H
	CALL	INITSIO
	LDA	IOBYTA	;INITIALIZE IOBYTE & SYSFMT
	MOV	B,A
	ANI	IOBMSK
	STA	IOBYTE
	LXI	H,SYSFMT
	MOV	A,B
	ANI	SYSMSK
	ORA	M
	MOV	M,A
	LXI	H,BMSG	;PRINT BOOT UP MESSAGE
	CALL	PMSG	;
	MOV	A,B	;SET DMAX = MAX DRIVE #
	ANI	1
	CMA
	ADI	2+NPSUDO
	STA	DMAX
	MOV	A,B
	ANI	1	;DRIVE OPTIONS:
	LXI	H,V2D	; 2DRIVE
	JZ	BOOT2
	LXI	H,V1D	; 1DRIVE
BOOT2:	CALL	PMSG
	MOV	A,B	;PRINTER OPTIONS:
	ANI	0C0H
	LXI	H,VPLL	; PARALLEL
	JZ	BOOT6
	CPI	80H
	LXI	H,VEA	; ETX-ACK
	JZ	BOOT6
	LXI	H,VXO	; XON/XOFF OR NO
	CALL	PMSG
	LXI	H,PROTCL;'PRINTER PROTOCOL'
BOOT6:	CALL	PMSG
	MOV	A,B	;IF AUTOSWITCH ON, PRINT IT
	ANI	4
	LXI	H,VAUTO
	CZ	PMSG
	XRA	A	;SET CURRENT DISC = A:, USER 0
	STA	SEKDSK
	STA	CDISC
	MOV	C,A	;
	CALL	SELCORV	;SELECT IT ALSO ( INITIALIZE BUFFERS)
	CALL	MTROFF	;TURN FLOPPY MOTORS OFF
	JMP	GOCPM

INITSIO:
	OUT	CSTAT
	OUT	LSTAT
	OUT	MSTAT
	RET

BMSG:	DB	CR,LF,LF,'ALSPA COMPUTER, INC. '
	DB	MSIZE/10+'0',MSIZE MOD 10 + '0','K CP/M'
	DB	'  1K Sectors  v'
	DB	REVNO/10+'0', '.', REVNO MOD 10 +'0'
	if	ibmb
	DB	'I'
	endif
	DB	SPREV	;SPECIAL REV CHARACTER
;	DB	BELL,ESC,'G6unreleased',ESC,'G0';Development message (Tv 925)
	DB	CR,LF,'Corvus drive A'
	if	NOT ((NPSUDO-2) SHR 15)*TRUE	;(IF NPSUDO>1)
	DB	'-',DF0-1
	endif
	DB	':, Floppy driv','e'+80H
V2D:	DB	's ',DF0,'-',DF0+1,':,',' '+80H	;DRIVE OPTIONS
V1D:	DB	' ',DF0,':,',' '+80H		;
VPLL:	DB	'PARALLEL printe','r'+80H	;PRINTER OPTIONS
VXO:	DB	'XON/XOFF(or NO',')'+80H	;
VEA:	DB	'ETX/ACK'			;
PROTCL:	DB	' printer protoco','l'+80H	;
VAUTO:	DB	', Autoswitc','h'+80H		;AUTOSWITCH
;**********************************************************************
	IF	NOT ((SFREE-($-TFREE)) SHR 15)*TRUE	;IF NOT ENOUGH*
	DS	(SFREE-($-TFREE))			;SPACE USED,  *
	ENDIF						;RESERVE IT.  *
BFREE:	;END OF 'FREE BUFFER'					      *
;**********************************************************************
ENDBUF:


;****************************************************************
;	THE REMAINDER OF THE CBIOS IS RESERVED UNINITIALIZED	*
;	DATA AREA, AND DOES NOT NEED TO BE A PART OF THE	*
;	SYSTEM MEMORY IMAGE.					*
;****************************************************************
DIRBUF:	DS	128	;DIRECTORY ACCESS BUFFER
HSTBUF:	DS	HSTSIZF	;HOST BUFFER AREA

ALV1:	DS	39	;DRIVE 1 ALLOC. MAP (FLOPPY B:)
CSV1:	DS	128/4	;CHECKSUM ARRAY
ALV2:	DS	39	;DRIVE 2 ALLOC. MAP (FLOPPY C:)
CSV2:	DS	128/4	;CHECKSUM ARRAY

ACIPG	EQU	(DIRBUF+7FH-CCP)/80H+1	;# SECTORS TO SAVE ON CORVUS BY ACIPG
ACICDOS	EQU	(DIRBUF+OFFSET+0FFH)/100H ; In CP/M, 'A> SAVE xx ACICDOS.COM'
	END
