PAGE 62
;CORVUS LOADER PROGRAM
;
;This program is 1 sector(128 bytes) long (maximum) and
;must be stored on disk in sector 12.
;**********************************************************
;ALTERABLE PARAMETERS: These parameters MUST be checked whenever
;			the system is altered.
MSIZE	EQU	61	;CP/M MEMORY SIZE IN KB
NSEC	EQU	72	;NUMBER OF SECTORS TO LOAD


;************CORVUS EQUATES*****************
DATA	EQU	0D0H	; DATA I/O PORT
STAT	EQU	0D2H	; STATUS INPUT PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
RDCOM	EQU	12H	; READ COMMAND (VERS. 1 CCODE)
SSIZE	EQU	128	; SECTOR SIZE (IN BYTES)
MODO	EQU	83H	; OUTPUT MODE FOR 8255
MODI	EQU	93H	; INPUT MODE FOR 8255
STRB	EQU	0D2H
COMDD	EQU	0D3H
BDRIVE	EQU	1	; DRIVE # TO BOOT FROM
BSEC	EQU	12	; DISC ADDRESS TO BOOT FROM (RESERVE A FEW SEC.)
CSEC	EQU	BSEC+1	; STARTING SECTOR FOR CP/M ON DISC

;****************CP/M EQUATES*********************
DELTA	EQU	0000H	; OFFSET FROM STD CP/M SIZE
BIAS	EQU	(MSIZE-20)*1024-DELTA
CCP	EQU	3400H+BIAS	; CP/M LOAD ADDRESS (CP/M 2.0)
BIOS	EQU	CCP+1600H	; BASE OF BIOS (CP/M 2.0)
BOOT	EQU	BIOS	; ENTRY POINT AFTER BOOT

;**********Z80 OPCODE EQUATES**********
JR	EQU	18H	;JR	XX
JRNZ	EQU	20H	;JR	NZ,XX
JRZ	EQU	28H	;JR	Z,XX
JRNC	EQU	30H	;JR	NC,XX
JRC	EQU	38H	;JR	C,XX
DJNZ	EQU	10H	;DJNZ	XX
LWB	EQU	0FFH	;LOW BYTE OF WORD
;***************************************

CBOOT	EQU	00H	; ORIGIN OF BOOT PROGRAM 
	ORG	CBOOT

	MVI	A,01H		;REMOVE ROM
	OUT	07H
START:	LXI	SP,0FFH		;PUT STACK IN A SAFE PLACE
LDCPM:	LXI	H,CCP		;HL=(LOAD RAM ADDRESS)
	LXI	D,CSEC		;DE=(STARTING DISC ADDRESS)
	MVI	C,NSEC		;DO C=(# SECTORS TO LOAD) TO 1
READ:	MVI	A,RDCOM		;    SEND (READ COMMAND) TO CORVUS
	CALL	WAITO
	MVI	A,BDRIVE	;    SEND (DRIVE #) TO CORVUS
	CALL	WAITO
	MOV	A,E		;    SEND (LOW BYTE OF DISC ADDRESS) TO CORVUS
	CALL	WAITO
	MOV	A,D		;    SEND (UPPER BYTE DISC ADDRESS) TO CORVUS
	CALL	WAITO
TURN:	IN	STAT		;    LOOP UNTIL (DRIVE ACTIVE BIT)=TRUE
	ANI	DIFAC
	DB JRNZ,(TURN-$-1) AND LWB
	MVI	B,11		;    DELAY 20+ uSEC
DELAY:	DB DJNZ,(DELAY-$-1) AND LWB
	CALL	WAITI		;    ACC=(STATUS CODE)
	RAL			;    IF(FATAL ERROR BIT)=TRUE THEN RESTART
	DB JRC,(START-$-1) AND LWB
	MVI	B,SSIZE		;    DO B=(CORVUS SECTOR SIZE) TO 1
RLP:	CALL	WAITI		;        M(HL++)=BYTE FROM CORVUS
	MOV	M,A
	INX	H		;        END DO
	DB DJNZ,(RLP-$-1) AND LWB
	INX	D		;    INCREMENT SECTOR COUNT
	DCR	C		;    END DO
	DB JRNZ,(READ-$-1) AND LWB
	JMP	BOOT		;GOTO CPM

WAITO:	PUSH	PSW
	POP	PSW		;DELAY 5+ uSEC
	PUSH	PSW
WAITO1:	IN	STAT		;WAIT UNTIL (READY BIT)=TRUE
	RAR
	DB JRNC,(WAITO1-$-1) AND LWB
	MVI	A,MODO		;SETUP OUTPUT MODE
	OUT	COMDD
	POP	PSW
	OUT	DATA		;OUTPUT DATA
	MVI	A,09H
	OUT	COMDD		;STROBE IT
	DCR	A
	OUT	COMDD
	RET

WAITI:	IN	STAT		;WAIT UNTIL READYBIT=TRUE
	RAR
	DB JRNC,(WAITI-$-1) AND LWB
	MVI	A,MODI		;SETUP INPUT MODE
	OUT	COMDD
	MVI	A,09H
	OUT	COMDD
	IN	DATA
	PUSH	PSW
	MVI	A,08H
	OUT	COMDD
	POP	PSW
	RET

	END
