PAGE 62
;ALSPA COMPUTER,INC.
;	Corvus Put/Get Routine
;**************************************************************
;EDIT HISTORY
;03/22/82 - 03/23/82	All I/O except abort through BDOS (SUBMIT-compatible)
;			All ^C functions also done by 'X' (except abort)
;**************************************************************
; This program performs three tasks:
;    1. PUT:  transfer a block of code from memory to disk.
;    2. GET:  transfer a block of code from disk to memory.
;    3. FILL: fill a contiguous section of the disk with a
;	      specified byte.
;
; Comments on program inputs:
;	1.  The drive #, disk address, and # of sectors ara all in
;	    decimal.  The program is set up for 128 byte sectors.
;	    The disk address is a number from  0  to  MAXSC-1.  The
;	    program is set up to calculate MAXSC either from defaults
;	    for the Rev A drive or by reading in the status string
;	    from the Rev B drive.  For reference, note that:
;		MAXSC-1 =	75743   (Rev A Drive)
;				84879   (Rev B 10MB Drive)
;			       153839	(Rev B 20MB Drive)
;				44879	(Rev B  5MB Drive)
;	2.  The starting RAM address is in Hex.
;	3.  A control-C or 'X' input in response to the Put/Get/Fill query
;	    will cause a return to CP/M (without re-booting).
;	4.  A Control-C or 'X' input in response to other querys will cause
;	    a branch to the Put/Get/Fill qeury.
;	5.  An invalid input will either be ignored, cause a repeat
;	    of the question, or result in an error message.
;	6.  The fill command is capable of filling the entire disk
;	    with a specified byte.  However, this would take nearly
;	    an hour to do so.  It is mainly useful for filling
;	    smaller sections of the disk (such as filling the CP/M
;	    directory areas with  0E5H  ).
;	7.  After each sector is read or written, the console status
;	    is checked.  If a control-C has been issued, the disk 
;	    operation will be aborted.  If some other character has
;	    been hit, a message will be displayed indicating that 
;	    a disk operation is still in progress ( this is useful
;	    on long   Put   or   Fill   operations to show that
;	    something is really happening).
;
;NOTE:  This program is an updated version of PUTGET Version 1.0.
;	Modifications from the older version include:
;
;	1.  Addition of the   Fill  command.
;	2.  Changing the Read/Write  commands to the new
;	    variable sector size command format introduced
;	    with "The MIRROR".
;	3.  Downwards compatibility with the original 128 Byte/Sec
;	    controller code by reading the controller code version #
;	    and patching the Read/Write commands appropriately.
;	4.  Changing the calculation of the disk size to use the
;	    status command of the Rev B Controller. (5/11/81)



; ---- CP/M EQUATES -----
BDOS	EQU	05	; BDOS ENTRY POINT
CR	EQU	0DH	; CARRIAGE RETURN
LF	EQU	0AH	; LINE FEED

; ---- CORVUS DISC EQUATES ----
DATA	EQU	0D0H	; DATA I/O PORT
STAT	EQU	0D2H	; STATUS INPUT PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
MODO	EQU	83H	;OUTPUT MODE FOR 8255
MODI	EQU	93H	;INPUT MODE FOR 8255
STRB	EQU	0D2H	;
COMDD	EQU	0D3H

; --- DO NOT CHANGE RDCOM OR WRCOM WITHOUT ALSO CHANGING THE TEST
;     AT THE END OF THE INIT ROUTINE. ---
RDCOM	EQU	12H	; READ COMMAND (MIRROR COMPATIBLE)
WRCOM	EQU	13H	; WRITE COMMAND (MIRROR COMPATIBLE)
VERCOM	EQU	0	; COMMAND TO READ VERSION #
			;  AND # DRIVES (REV A)
NSTAT	EQU	10H	; REV B STATUS COMMAND
SSIZE	EQU	128	; SECTOR SIZE ( IN BYTES)
MAXDRV	EQU	4	; MAX # OF DRIVES

	ORG 100H	; STANDARD CP/M TPA ORIGIN

START:	LXI	H,0
	DAD	SP	; GET STACK POINTER IN (H,L)
	SHLD	SBUF	; SAVE IT
SIGNON:	LXI	SP,STACK;SETUP LOCAL STACK
	LXI	D,SMSG	;POINT TO MESSAGE
	CALL	PTMSG	; PRINT SIGN ON MESSAGE
PGQ:	LXI	D,PGMSG
	CALL	PTMSG	; ASK IF PUT OR GET
P1:	CALL	CIN	; GET CONSOLE CHAR.
	CPI	'X'	; IF 'X' THEN EXIT
	JZ	CEXIT
	CPI	'C'-40H	; IS IT A CONTROL-C ?
	JNZ	PGQ1	; NO, SO CONTINUE
CEXIT:	LHLD	SBUF	; GET OLD STACK POINTER
	SPHL
	RET		; RE-ENTER CP/M

PGQ1:	CPI	'G'	; IS IT A GET COMMAND?
	MVI	B,RDCOM	; GET READ COMMAND
	JZ	PGQ2
	CPI	'P'	; IS IT A PUT COMMAND?
	MVI	B,WRCOM	; GET WRITE COMMAND
	JZ	PGQ2
	CPI	'F'	; IS IT A FILL COMMAND?
	JNZ	P1	; IF INVALID, GET ANOTHER CHAR.
PGQ2:	STA	COMD	; SAVE COMMAND FOR REF.
	MOV	A,B	; GET READ/ WRITE DISC COMMAND
	STA	RWCOM	; SAVE IT

; --- GET DRIVE # ----
;
GTDRV:	LXI	D,DMSG
	CALL	PTMSG	; ASK FOR DRIVE #
GT1:	CALL	CIN
	CPI	'X'	; IF 'X' THEN RESTART
	JZ	PGQ
	CPI	'C'-40H	; IS IT A CONTROL-C
	JZ	PGQ	; YES, SO RESTART
	SUI	'0'	; REMOVE ASCII BIAS
	JC	GT1	; IF INVALID, GET ANOTHER CHAR
	JZ	GT1
	CPI	MAXDRV+1; TEST IF DRIVE # TOO LARGE
	JNC	GT1
	STA	DRIVE	; SAVE DRIVE #
	CALL	COUT	; ECHO CHARACTER
	CALL	INIT	; INIT CONTROLLER AND FIND DRIVE TYPE

; --- SETUP MAXIMUM 128 BYTE DISC ADDRESS ---
;
SETMAX:	CPI	8FH		; TEST RETURN CODE
	CZ	BSTAT1		; IF REV B DRIVE
	CNZ	REVAFIX		; IF REV A DRIVE

; --- COMPUTE OUTER SEEK ADDRESS ---
;
	LHLD	STATBF+37	; GET LOWER PART OF MAX BLOCK ADD
	LDA	STATBF+39	;  AND GET ITS UPPER BYTE
	DAD	H		; MULTIPLY BY 4 ( FOR 128 BYTE SEC)
	ADC	A
	DAD	H
	ADC	A
	SHLD	MAXSC		; SAVE MAX # OF 128 BYTE SECTORS
	STA	MAXSC+2

	LDA	COMD	; GET PUT, GET, FILL COMMAND
	CPI	'F'	; WAS IT A FILL COMMAND?
	JNZ	GTAD	; NO, SO ASSUME PUT OR GET

; --- GET FILL BYTE ---
;
GTFIL:	LXI	D,FMSG	; ASK FOR FILL BYTE
	CALL	PTMSG
	CALL	INHEX
	JC	GTFIL
	XRA	A
	CMP	H	; IS UPPER BYTE 0?
	JNZ	GTFIL	; NO, TRY AGAIN
	MOV	A,L	; GET BYTE
	STA	FILLB	; SAVE IT
	JMP	GTDAD

; --- GET DMA START ADDRESS ---
;
GTAD:	LXI	D,AMSG	; ASK FOR MEMORY ADDRESS
	CALL	PTMSG
	CALL	INHEX
	JC	GTAD	; IF ERROR, ASK AGAIN
	SHLD	RADD	; SAVE ADDRESS

; --- GET STARTING DISC ADDRESS (DECIMAL) ---
;
GTDAD:	LXI	D,DDMSG
	CALL	PTMSG	; ASK FOR DISC ADDRESS
	CALL	INDEC
	JC	GTDAD	; IF INVALID, ASK AGAIN
	LXI	H,CONV	; POINT TO CONVERSION BUFFER
	LXI	D,DADD	; POINT TO BUFFER FOR DISC ADDRESS
	CALL	COPY3	; COPY TO BUFFER

; --- GET # OF SECTORS ----
;
GTNS:	LXI	D,BMSG	; ASK FOR # OF SECTORS
	CALL	PTMSG
	CALL	INDEC
	JC	GTNS	; IF INVALID, ASK AGAIN
	LXI	H,CONV	; POINT TO CONVERSION BUFFER
	LXI	D,NBLKS	; POINT TO BUFFER FOR # OF SECTORS
	CALL	COPY3	; COPY TO BUFFER
	LXI	H,NBLKS+2	; POINT TO THIRD BYTE OF # SECTORS
	XRA	A	; CLEAR A
	ORA	M
	DCX	H
	ORA	M
	DCX	H
	ORA	M
	JZ	GTNS	; IF # SECTORS =0
	LXI	H,NBLKS
	LXI	D,DADD
	CALL	ADDM	; ADD # SEC AND DISC ADDRESS
	LXI	D,MAXSC
	LXI	H,ABUF	; SUBTRACT RESULT FROM MAX DISC ADD.+1
	CALL	SUBM
	JC	ROLD	; IF, TOO BIG
	LDA	COMD	; GET PUT, GET, FILL COMMAND
	CPI	'F'	; IS IT A FILL COMMAND?
	JZ	OK	; YES, SO TESTS ARE DONE
	LDA	NBLKS+2	; GET UPPER BYTE OF SECTOR COUNT
	ORA	A
	JNZ	ROLL	; IF FAR TOO BIG, ISSUE ERROR MESSAGE
	LXI	B,-1	; SETUP TO TEST IF MEMORY ROLLOVER
	LHLD	RADD	; GET RAM ADD
	LXI	D,SSIZE
GTN1:	DAD	D	; LOOP TO FIND # SECTORS THAT COULD FIT
	INX	B	; INC SECTOR COUNTER
	JNC	GTN1
	MOV	A,H
	ORA	L
	JNZ	GTN2	; IF NOT EXACTLY ZERO
	INX	B	; IF EXTRA SECTOR JUST FITS
GTN2:	LHLD	NBLKS	; COMPUTE #FIT-#SEC
	MOV	A,C
	SUB	L
	MOV	A,B
	SBB	H
	JNC	OK	; OK SO CONTINUE
ROLL:	LXI	D,RLMSG	; ERROR IF ROLL OVER TOP OF MEMORY
	CALL	PTMSG
	JMP	GTNS
ROLD:	LXI	D,RDMSG	; IF POSSIBLE ROLL OVER DISC TOP
	CALL	PTMSG
	JMP	GTNS

; -- INPUTS ARE NOW ASSUMED TO BE VALID, SO SETUP TO DO OPERATION
;
;--  MERGE UPPER DISC ADDRESS NIBBLE WITH DRIVE #

OK:	LDA	DADD+2
	ANI	0FH
	RLC
	RLC
	RLC
	RLC
	LXI	H,DRIVE
	ORA	M
	MOV	M,A

; --- DO BLOCK OPERATION ---
;
BLOCK:	LXI	D,MSG1	;PRINT DISK OP MESSAGE
	CALL	PTMSG
BLK0:	LHLD	RADD	; GET RAM ADDRESS
	CALL	RWSEC	; READ OR WRITE ONE SECTOR
	SHLD	RADD
	CALL	CONST	; WAS A KEY HIT?
	ORA	A
	JNZ	BLK3	; YES, SO ISSUE MESSAGE OR ABORT

BLK1:	LHLD	NBLKS
	DCX	H
	SHLD	NBLKS
	MOV	A,H
	ORA	L
	JNZ	BLK2	; NOT DONE YET, SO CONTINUE
	LXI	H,NBLKS+2	; POINT TO UPPER BYTE OF SECTOR COUNT
	ORA	M	; TEST IF ZERO
	JZ	PGQ	; DONE, SO RETURN TO FIRST QUESTION
	DCR	M	; DECREMENT COUNT AND CONTINUE
BLK2:	LHLD	DADD	; GET DISC ADDRESS
	LXI	D,1
	DAD	D
	SHLD	DADD	; UPDATE IT
	JNC	BLK0	; DO ANOTHER SECTOR
	LDA	DRIVE
	ADI	10H	; IF CARRY, INCREMENT ADDRESS NIBBLE
	STA	DRIVE
	JMP	BLK0

BLK3:	CALL	CONIN	; GET INPUT CHAR.
	ANI	5FH	; MASK TO UPPER CASE
	CPI	'C'-40H	; IS IT A CONTROL-C?
	LXI	D,MSG3	; POINT TO MESSAGE
	JNZ	BLK4
	LXI	D,MSG2	; POINT TO MESSAGE
BLK4:	PUSH	PSW	; SAVE FLAGS
	CALL	PTMSG	; PRINT MESSAGE
	POP	PSW	; RESTORE FLAGS
	JNZ	BLK1		; RETURN IF NOT CONTROL-C
	JMP	PGQ	; RESTART MENU SELECTION

RWSEC:	LDA	RWCOM	; GET COMMAND
	CALL	WAITO	; WAIT AND SEND IT
	LDA	DRIVE	; GET DRIVE #
	CALL	WAITO
	LDA	DADD	; GET LOW BYTE OF DISC ADDRESS
	CALL	WAITO
	LDA	DADD+1	; GET UPPER BYTE OF DISC ADDRESS
	CALL	WAITO
	LDA	COMD	; GET COMMAND
	CPI	'F'	; WAS IT A FILL COMMAND?
	JZ	FILL	; YES, SO FILL A SECTOR
	CPI	'P'	; WAS IT A PUT COMMAND?
	JZ	WRIT	; YES, SO WRITE A SECTOR
RWSC1:	CALL	WERR	; NO, SO ASSUME READ AND GET ERROR CODE
RSEC:	MVI	B,SSIZE
RLP:	IN	STAT	; READ STATUS PORT
	ANI	DRDY	; LOOK AT READY LINE
	JZ	RLP
	CALL	INAC
	MOV	M,A	; SAVE IT IN MEMORY
	INX	H
	DCR	B	; DECREMENT BYTE COUNT
	JNZ	RLP	; LOOP UNTIL DONE
	RET

FILL:	MVI	B,SSIZE
	LDA	FILLB	; GET FILL BYTE
	MOV	C,A	; INTO (C)
FLP:	IN	STAT	; READ STATUS PORT
	ANI	DRDY
	JZ	FLP
	MOV	A,C	; GET FILL BYTE
	CALL	OUTAC
	DCR	B
	JNZ	FLP	; LOOP UNTIL DONE
	JMP	WERR

WRIT:	MVI	B,SSIZE
WLP:	IN	STAT	; READ STATUS PORT
	ANI	DRDY
	JZ	WLP
	MOV	A,M	; GET BYTE FROM MEMORY
	CALL	OUTAC
	INX	H
	DCR	B
	JNZ	WLP	; LOOP UNTIL DONE
WERR:	CALL	TURN	; TURN AROUND BUSS 
	CALL	WAITI	; WAIT FOR ERROR BYTE
	MOV	B,A	; SAVE BYTE
	ANI	80H	; LOOK FOR FATAL ERRORS
	RZ		; OK, SO RETURN
	PUSH	B	; SAVE ERROR
	LXI	D,ERMSG	; ERROR, SO ISSUE MESSAGE
	CALL	PTMSG
	POP	PSW	; GET ERROR BYTE BACK IN ACC
	CALL	HEXOT	; OUTPUT IN HEX
	LXI	D,ERMSG1
	CALL	PTMSG
	JMP 	SIGNON	; RESTART PROGRAM

TURN:	IN	STAT
	ANI	DIFAC	; LOOK AT BUSS ACTIVE BIT
	JNZ	TURN
	MVI	B,6	; GOOD AT 4MHZ ALSO
DELAY:	DCR	B
	JNZ	DELAY
	RET

WAITI:	IN	STAT	; READ STATUS PORT
	ANI	DRDY	; LOOK AT READY LINE
	JZ	WAITI
	CALL	INAC
	RET

WAITO:	PUSH	PSW	; SAVE COMMAND
	IN	STAT	; READ STATUS PORT
	ANI	DRDY	; LOOK AT READY LINE
	JZ	WAITO+1
	POP	PSW
	CALL	OUTAC
	RET

;-- INITIALIZE CONTROLLER ----
;
INIT:	MVI	A,0FFH	; GET AN INVALID COMMAND
	CALL	OUTAC
	MVI	B,150	; SET FOR LONG DELAY
	CALL	DELAY
	IN	STAT
	ANI	DIFAC	; LOOK AT DRIVE ACTIVE BIT
	JNZ	INIT	; LOOP UNTIL NOT ACTIVE
	CALL	WAITI	; GET ERROR CODE
	CPI	8FH	; CHECK RETURN CODE
	JNZ	INIT	; IF NOT RIGHT, TRY AGAIN

; --- TEST DRIVE TYPE AND REV A CODE VERSION # ---
;
VCHK:	MVI	A,VERCOM ; GET A ZERO 
	CALL	WAITO	; SEND IT
	CALL	TURN	; WAIT FOR ACCEPTANCE
	CALL	WAITI	; GET ANSWER
	STA	SRTN
	MOV	B,A	; SAVE IT
	ANI	0F0H	; MASK OUT DRIVE # AND TEST VERSION #
	MOV	A,B	; GET CODE BACK
	RNZ		; NOT VERS. 0   SO RETURN
	LDA	RWCOM	; GET READ/ WRITE COMMAND
	ANI	0FH	; MASK TO REV 0 CONTROLLER CODE VERSION
	STA	RWCOM	; RESAVE IT
	MOV	A,B	; GET CODE BACK
	RET

; --- SET REV A EQUIV. STATUS INFORMATION ---
;
REVAFIX: LDA	SRTN	; GET RETURN CODE
	CPI	8FH	; REV B DRIVE ?
	RZ		; YES, SO EXIT
	PUSH	PSW
	LXI	H,REVADTA ; POINT TO REV A DATA
	LXI	D,STATBF+33 ; SET DESTINATION
	MVI	C,7	; LENGTH OF TABLE TO MOVE
	CALL	COPY	; DO IT
	POP	PSW	; RESTORE RTN CODE
	RET


; --- READ REV B STATUS STRING ---
;
BSTAT1:	MVI	A,NSTAT		; GET STATUS COMMAND
	CALL	WAITO
	LDA	DRIVE
	CALL	WAITO
	LXI	H,STATBF	; SET BUFFER ADDRESS
	CALL	RWSC1		; USE R/W ROUTINE TO GET DATA
	LXI	H,STATBF+33	; POINT TO #SECTORS/TRACK
	XRA	A
	CMP	M		; IS VALUE 0 (BUG IN EARLY ROM)
	RNZ			; NO, SO RETURN
	MVI	M,20		; YES, SO FIX IT
	RET


; --- COPY ROUTINE ---
;
COPY3:	MVI	C,3
COPY:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	COPY
	RET

; --- MULTI BYTE ADDITION ---
;  (H,L) AND (D,E) POINT TO ADDENDS
;  RESULT IS PUT IN CONVERSION BUFFER: ABUF
;
ADDM:	PUSH	H
	PUSH	D
	PUSH	B
	LXI	B,ABUF	; DESTINATION ADDRESS
	PUSH	B
	MVI	C,3	; ARITHMETIC PRECISION
	XRA	A	; CLEAR FLAGS
AD1:	LDAX	D
	ADC	M
	XTHL
	MOV	M,A	; SAVE RESULT IN BUFFER
	INX	H
	XTHL
	INX	H
	INX	D
	DCR	C
	JNZ	AD1	; LOOP UNTIL DONE
	POP	B
	POP	B
	POP	D
	POP	H
	RET

; --- MULTI BYTE SUBTRACTION ---
;  (D,E) POINTS TO THE MINUEND
;  (H,L) POINTS TO THE SUBTRAHEND
;  [D,E]-[H,L]
;  RESULT IS PUT IN CONVERSION BUFFER: ABUF
;
SUBM:	PUSH	H
	PUSH	D
	PUSH	B
	LXI	B,ABUF	; DESTINATION ADDRESS
	PUSH	B
	MVI	C,3	; ARITHMETIC PRECISION
	XRA	A	; CLEAR FLAGS
SD1:	LDAX	D
	SBB	M
	XTHL
	MOV	M,A	; SAVE RESULT IN BUFFER
	INX	H
	XTHL
	INX	H
	INX	D
	DCR	C
	JNZ	SD1	; LOOP UNTIL DONE
	POP	B
	POP	B
	POP	D
	POP	H
	RET

CIN:	PUSH	H	; BUFFERED CONSOLE INPUT
	PUSH	D
	PUSH	B
	LXI	D,RBUF
	MVI	C,10
	CALL	BDOS
	LXI	H,RBUFD	;INIT RDBUFFPTR -> RBUFFDATA
	SHLD	RBUFP
	POP	B
	POP	D
	POP	H
NXCIN:	PUSH	H	;GET NEXT CHARACTER FROM INPUT LINE
	PUSH	D
	LHLD	RBUFP
	XCHG
	LXI	H,RBUFN
NXCIN1:	DCR	M	;DECR CHAR CT
	JM	NXCIN3	;IF END, EXIT
	LDAX	D	;PURGE ANY ' '
	INX	D
	CPI	' '
	JZ	NXCIN1
	JMP	NXCIN2

NXCIN3:	MVI	M,0	;END OF LINE, KEEP COUNT=0
	MVI	A,CR	;	CHAR=CR
NXCIN2:	XCHG
	SHLD	RBUFP
	POP	D
	POP	H
	MOV	C,A	; SAVE FOR ECHO
	CPI	60H	; IS IT LOWER CASE?
	RC		; NO, SO RETURN
	ANI	5FH	; YES, SO CONVERT TO UPPER CASE
	RET

CONST:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,11	;GET CONSOLE STATUS
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET

CONIN:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,1	;GET CONSOLE CHAR
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET

COUT:	PUSH	PSW	; SAVE ACC
	PUSH	H	; BUFFERED CONSOLE OUTPUT
	PUSH	D
	PUSH	B
	MOV	E,A
	MVI	C,2
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	POP	PSW
	RET

; --- MESSAGE PRINT ROUTINE---
;
PTMSG:	MVI	C,9	; CP/M WRITE LIST COMMAND
	CALL	BDOS
	RET

; --- OUTPUT BYTE IN ACC IN HEX ---
;
HEXOT:	PUSH	PSW	; SAVE BYTE
	RRC		; SHIFT UPPER NIBBLE DOWN
	RRC
	RRC
	RRC
	CALL	HEXB	; OUTPUT UPPER NIBBLE IN HEX
	POP	PSW	; GET BYTE BACK
HEXB:	ANI	0FH	; MASK OFF UPPER NIBBLE
	ADI	'0'	; ADD ASCII BIAS
	CPI	'9'+1	; TEST IF NUMERIC
	JC	PRT	; YES, SO DO IT
	ADI	7	; NO, SO ADD BIAS FOR A-F
PRT:	MOV	C,A	; SETUP FOR OUTPUT
	JMP	COUT	; OUTPUT HEX NIBBLE

;  --- HEX INPUT ROUTINE ----
;
INHEX:	LXI	H,0	; CLEAR CONVERSION REGISTER
	CALL	CIN
	JMP	H2

H1:	CALL	NXCIN	; GET CHAR.
H2:	CPI	'C'-40H
	JZ	RT1
	CPI	'X'
	JZ	RT1
	CPI	'H'
	JZ	H3
	CPI	CR	; IS IT A CR
	JNZ	HEX2
H3:	ORA	A	; CLEAR FLAGS
	RET
HEX2:	SUI	'0'	; REMOVE ASCII BIAS
	RC
	CPI	'G'-'0'
	CMC
	RC
	CPI	10
	JC	HEX1
	SUI	7	; ADJUST FOR A-F CHARACTERS
	CPI	10
	RC
HEX1:	DAD	H	; SHIFT 16 BIT REGISTER OVER 4 PLACES
	DAD	H
	DAD	H
	DAD	H
	ADD	L	; ADD IN NEW NIBBLE
	MOV	L,A
	JMP	H1
RT1:	POP	PSW	; CLEAR RETURN ADDRESS FROM STACK
	JMP	PGQ	; RETURN TO INITIAL QUERY

;--- 3 BYTE DECIMAL INPUT ROUTINE ---
;   THE BINARY RESULT IS SAVED IN THE CONVERSION BUFFER: CONV
;
INDEC:	LXI	H,CONV
	CALL	ZERO3	; CLEAR BUFFER
	CALL	CIN
	JMP	IN2

IN1:	CALL	NXCIN	; GET CHAR.
IN2:	CPI	'C'-40H
	JZ	RT1
	CPI	'X'
	JZ	RT1
	CPI	CR	; IS IT A CR?
	JNZ	DEC2
	LXI	D,CONV
	LXI	H,MAXSC
	CALL	SUBM	; TEST IF # IS TOO BIG
	CMC
	RNC
BIG:	LXI	D,BGMSG
	CALL	PTMSG	; ISSUE ERROR MESSAGE
	STC
	RET
DEC2:	SUI	'0'	; REMOVE ASCII BIAS
	RC
	CPI	10
	CMC
	RC
DEC1:	STA	CONVX	; SAVE CHAR
	LXI	H,CONV
	LXI	D,CONV
	CALL	ADDM	; DOUBLE BUFFER VALUE
	LXI	H,ABUF
	LXI	D,ABUF
	PUSH	D
	CALL	ADDM	; DOUBLE IT AGAIN
	LXI	D,CONV
	CALL	ADDM	; NOW 5X STARTING VALUE
	POP	D
	CALL	ADDM	; NOW 10X STARTING VALUE
	LXI	D,CONVX
	CALL	ADDM	; ADD IN NEW UNITS DIGIT VALUE
	JC	BIG	; IF CARRY OUT OF THIRD BYTE
	LXI	D,CONV
	CALL	COPY3	; COPY TOTAL BACK TO CONV
	JMP	IN1	; LOOP FOR MORE

ZERO3:	MVI	C,3
ZERO:	MVI	M,0
	INX	H
	DCR	C
	JNZ	ZERO
	RET

OUTAC:	DB	08H	;EX AF,AF'
	MVI	A,MODO	;EXCHANGE MODES
	OUT	COMDD
	DB	08H	;EX AF,AF'
	OUT	DATA
	MVI	A,09H
	OUT	COMDD	;STROBE
	DCR	A
	OUT	COMDD	;STROBE OFF
	RET
INAC:	MVI	A,MODI
	OUT	COMDD
	MVI	A,09H
	OUT	COMDD	;STROBE
	IN	DATA
	PUSH	PSW
	MVI	A,08H
	OUT	COMDD
	POP	PSW
	RET

SMSG:	DB CR,LF,'ALSPA COMPUTER, INC.  Corvus Put/Get Routine v1.4$'
PGMSG:	DB CR,LF,'  Put, Get, or Fill (P/G/F) ? $'
DMSG:	DB CR,LF,'              Drive # (1-4) ? $'
AMSG:	DB CR,LF,'   Starting Hex RAM address ? $'
FMSG:	DB CR,LF,' Hex byte to fill disk with ? $'
DDMSG:	DB CR,LF,'      Starting disk address ? $'
BMSG:	DB CR,LF,'          Number of sectors ? $'
MSG1:	DB CR,LF,' Disk operation in progress... $'
MSG3:	DB CR,LF,' Disk operation in progress, use Control-C to abort: $'
MSG2:	DB CR,LF,' -- Disk operation Aborted --',CR,LF,'$'
BGMSG:	DB CR,LF,07,' -- Number is too big -- ',CR,LF,'$'
RLMSG:	DB CR,LF,07,' -- This would roll over the top of memory --',CR,LF,'$'
RDMSG:	DB CR,LF,07,' -- This would exceed disk size --',CR,LF,'$'
ERMSG:	DB CR,LF,07,' ** Corvus R/W ERROR # $'
ERMSG1:	DB 'H **',CR,LF,'$'
;
; --- FAKE COPY OF DATA FOR REV A STATUS STRING ---
;
REVADTA: DB	18	; # SECTORS/TRACK
	DB	3	; # HEADS
	DW	350	; # OF CYLINDERS
	DW	18936	; # OF 512 BYTE SECTORS
	DB	0
;
; ---- BUFFERS AND DATA ----
;
MAXSC:	DS	3	; BUFFER FOR MAXIMUM DISC ADDRESS
CONVX:	DB	0	; BUFFER FOR INDEC ROUTINE
	DB	0
	DB	0

RBUFP:	DW	RBUFD	;READ BUFFER POINTER
RBUF:	DB	10	;BUFFER SIZE(SEE BDOS CALL 10 IN CPM INTERFACE GUIDE)
RBUFN:	DB	0	;#CHARACTERS ACTUALLY READ
RBUFD:	DS	10	;INPUT BUFFER
 
SBUF:	DS	2	; OLD STACK POINTER
RWCOM:	DS	1	; R/W COMMAND
COMD:	DS	1	; FUNCTION COMMAND (G, P, OR F)
DRIVE:	DS	1	; DRIVE # AND UPPER DISC ADDRESS NIBBLE
RADD:	DS	2	; RAM ADDRESS FOR DMA
DADD:	DS	3	; DISC ADDRESS
NBLKS:	DS	3	; # DISC SECTORS TO R/W
CONV:	DS	3	; CONVERSION BUFFER FOR INDEC
ABUF:	DS	3	; BUFFER FOR ADDM AND SUBM
FILLB:	DS	1	; FILL BYTE
SRTN:	DS	1	; BUFFER FOR RETURN CODE
STATBF:	DS	130	; BUFFER FOR STATUS STRING
	DS	80	; STACK SPACE
STACK:	NOP

	END
