;	binary search module, fixed tables
;
	title	'macro source, fixed tables and search primitives'
;
	org	2100h
;
	jmp	endmod		;to next module
	jmp	bsear
	jmp	bget
	jmp	toknum		;get token number to register <a>
	jmp	settok		;get token length to <b>, addr to <hl>
;
;
commod	equ	2f80h		;common data module
;
;	common equates
pbmax	equ	120		;max print size
pbuff	equ	commod+0ch	;print buffer
pbp	equ	pbuff+pbmax	;print buffer pointer
;
token	equ	pbp+1		;current token uder scan
value	equ	token+1		;value of number in binary
acclen	equ	value+2		;accumulator length
acmax	equ	64		;max accumulator length
accum	equ	acclen+1
;
evalue	equ	accum+acmax	;value from expression analysis
;
sytop	equ	evalue+2	;current symbol top
symax	equ	sytop+2		;max address+1
;
pass	equ	symax+2		;current pass number
fpc	equ	pass+1		;fill address for next hex byte
aspc	equ	fpc+2		;assembler's pseudo pc
;
;	global equates
;
iden	equ	1		;identifier
numb	equ	2		;number
strng	equ	3		;string
specl	equ	4		;special character
;
plabt	equ	0000$0001b	;program label
dlabt	equ	0000$0010b	;data label
equt	equ	0000$0100b	;equate
sett	equ	0000$0101b	;set
mact	equ	0000$0110b	;macro
;
extt	equ	0000$1000b	;external
reft	equ	0000$1011b	;refer
glbt	equ	0000$1100b	;global
;
;
cr	equ	0dh		;carriage return
;
;
;	table definitions
;
;	types
;
xbase	equ	0		;start of operators
;
;	o1 through o15 denote operations
;
rt	equ	25
pt	equ	rt+1		;rt is register type, pt is pseudo operation
obase	equ	pt+1
o1	equ	obase+1		;simple
o2	equ	obase+2		;lxi
o3	equ	obase+3		;dad
o4	equ	obase+4		;push/pop
o5	equ	obase+5		;jmp/call
o6	equ	obase+6		;mov
o7	equ	obase+7		;mvi
o8	equ	obase+8		;acc immediate
o9	equ	obase+9		;ldax/stax
o10	equ	obase+10	;lhld/shld/lda/sta
o11	equ	obase+11	;accum register
o12	equ	obase+12	;inc/dec
o13	equ	obase+13	;inx/dcx
o14	equ	obase+14	;rst
o15	equ	obase+15	;in/out
;
;	x1 through x25 denote operators
;
x1	equ	xbase		;*
x2	equ	xbase+1		;/
x3	equ	xbase+2		;mod
x4	equ	xbase+3		;shl
x5	equ	xbase+4		;shr
x6	equ	xbase+5		;+
x7	equ	xbase+6		;-
x8	equ	xbase+7		;unary -
x17	equ	xbase+8		;eq
x18	equ	xbase+9		;lt
x19	equ	xbase+10	;le
x20	equ	xbase+11	;gt
x21	equ	xbase+12	;ge
x22	equ	xbase+13	;ne
x9	equ	xbase+14	;not
x10	equ	xbase+15	;and
x11	equ	xbase+16	;or
x12	equ	xbase+17	;xor
x23	equ	xbase+18	;high
x24	equ	xbase+19	;low
x13	equ	xbase+20	;(
x14	equ	xbase+21	;)
x15	equ	xbase+22	;,
x16	equ	xbase+23	;cr
x25	equ	xbase+24	;nul
;
;
;	local variables
;
tloc:	ds	1		;token location during search operation
;
;
;	reserved word tables
;
;	base address vector for characters
;
cinx:	dw	char1		;length 1 base
	dw	char2		;length 2 base
	dw	char3		;length 3 base
	dw	char4		;length 4 base
	dw	char5		;length 5 base
	dw	char6		;length 6 base
	dw	char7		;length 7 base
;
cmax	equ	($-cinx)/2-1	;largest string to match
;
tvinx:		;table of type,value pairs for each reserved symbol
	dw	tv1
	dw	tv2
	dw	tv3
	dw	tv4
	dw	tv5
	dw	tv6
;
;	character vectors for 1,2,3,4,5, and 6 character names
;
char1:	db	cr,'()*'
	db	'+'
	db	',-/A'
	db	'BCDE'
	db	'HLM'
;
char2:	db	'DBDIDSDW'
	db	'EIEQGEGT'
	db	'IFINLELT'
	db	'NEORSP'
;
char3:	db	'ACIADCADDADI'
	db	'ANAANDANICMA'
	db	'CMCCMPCPIDAA'
	db	'DADDCRDCXEND'
	db	'EQUHLTINRINXIRP'
	db	'JMPLDALOWLXIMOD'
	db	'MOVMVINOPNOTNUL'
	db	'ORAORGORIOUT'
	db	'POPPSWRALRAR'
	db	'RETRLCRRCRST'
	db	'SBBSBISETSHL'
	db	'SHRSTASTCSUB'
	db	'SUIXORXRAXRI'
;
char4:	db	'ASEGCALLCSEGDSEG'
	db	'ELSEENDMHIGHIRPC'
	db	'LDAXLHLD'
	db	'NAMEPAGEPCHLPUSH'
	db	'REPTSHLDSPHLSTAX'
	db	'XCHGXTHL'
;
char5:	db	'ENDIFEXITMEXTRN'
	db	'LOCALMACROSTKLNTITLE'
;
char6:	db	'INPAGEMACLIBPUBLIC'
;
char7:		;end of character vectors
;
;	equates for vector lengths
;
clen1	equ	(char2-char1)
clen2	equ	(char3-char2)/2
clen3	equ	(char4-char3)/3
clen4	equ	(char5-char4)/4
clen5	equ	(char6-char5)/5
clen6	equ	(char7-char6)/6
;
clen:		;length vector gives the number of items in each table
	db	clen1
	db	clen2
	db	clen3
	db	clen4
	db	clen5
	db	clen6
;
tv1:		;type,value pairs for char1 vector
	db	x16,10,		x13,20		;cr (
	db	x14,30,		x1,80		;) *
	db	x6,70				;+
	db	x15,10,		x7,70		;, -
	db	x2,80,		rt,7		;/ a
	db	rt,0,		rt,1		;b c
	db	rt,2,		rt,3		;d e
	db	rt,4,		rt,5		;h l
	db	rt,6				;m
;
tv2:		;type,value pairs for char2 vector
	db	pt,1,		o1,0f3h		;db di
	db	pt,2,		pt,3		;ds dw
	db	o1,0fbh,	x17,65		;ei eq
	db	x21,65,		x20,65		;ge gt
	db	pt,8,		o15,0dbh	;if in
	db	x19,65,		x18,65		;le lt
	db	x22,65,		x11,40		;ne or
	db	rt,6				;sp
;
;
tv3:		;type,value pairs for char3 vector
	db	o8,0ceh,	o11,88h		;aci adc
	db	o11,80h,	o8,0c6h		;add adi
	db	o11,0a0h,	x10,50		;ana and
	db	o8,0e6h,	o1,2fh		;ani cma
	db	o1,3fh,		o11,0b8h	;cmc cmp
	db	o8,0feh,	o1,27h		;cpi daa
	db	o3,09h,		o12,05h		;dad dcr
	db	o13,0bh,	pt,4		;dcx end
	db	pt,7,		o1,76h		;equ hlt
	db	o12,04h,	o13,03h		;inr inx
	db	pt,14,		o5,0c3h		;irp jmp
	db	o10,3ah,	x24,30		;lda low
	db	o2,01h,		x3,80		;lxi mod
	db	o6,40h,		o7,06h		;mov mvi
	db	o1,00h,		x9,60		;nop not
	db	x25,0				;nul
	db	o11,0b0h,	pt,10		;ora org
	db	o8,0f6h,	o15,0d3h	;ori out
	db	o4,0c1h,	rt,6		;pop psw
	db	o1,17h,		o1,1fh		;ral rar
	db	o1,0c9h,	o1,07h		;ret rlc
	db	o1,0fh,		o14,0c7h	;rrc rst
	db	o11,098h,	o8,0deh		;sbb sbi
	db	pt,11,		x4,80		;set shl
	db	x5,80,		o10,32h		;sta stc
	db	o1,37h,		o11,90h		;stc sub
	db	o8,0d6h,	x12,40		;sui xor
	db	o11,0a8h,	o8,0eeh		;xra xri
;
;
tv4:		;type,value pairs for char4 vector
	db	pt,13,		o5,0cdh		;aseg call
	db	pt,18,		pt,19		;cseg dseg
	db	pt,13,		pt,6		;else endm
	db	x23,30,		pt,15		;high irpc
	db	o9,0ah,		o10,2ah		;ldax lhld
	db	pt,20,		pt,21		;name page
	db	o1,0e9h,	o4,0c5h		;pchl push
	db	pt,16,		o10,22h		;rept shld
	db	o1,0f9h,	o9,02h		;sphl stax
	db	o1,0ebh,	o1,0e3h		;xchg xthl
;
tv5:		;type,value pairs for char5 vector
	db	pt,5,		pt,22		;endif exitm
	db	pt,23,		pt,24		;extrn local
	db	pt,9,		pt,28		;macro stkln
	db	pt,12				;title
;
tv6:		;type, value pairs for char6 vector
	db	pt,25,		pt,26		;inpage maclib
	db	pt,27				;public
;
;
suftab:		;table of suffixes for j c and r operations
	db	'NZZ NCC POPEP M '
;
;
bsear:		;binary search mnemonic table
;	input: ur = upper bound of table (i.e., table length-1)
;		sr = size of each table element
;		<hl> address base of table to search
;	output: zero flag indicates match was found, in which case
;		the accumulator contains an index to the element
;		not zero flag indicates no match found in table
;
ur	equ	b		;upper bound register
lr	equ	c		;lower bound register
sr	equ	d		;size register
mr	equ	e		;middle pointer register
sp1	equ	b		;size prime, used in computing middle positon
sp1p	equ	c		;another copy of size prime
kr	equ	h		;k
;
	mvi	mr,255		;mark m <> old m
	inr	ur		;u=u+1
	mvi	lr,0		;l = 0
;
;	compute m' = (u+l)/2
;
next:	xra	a
	mov	a,ur		;[cy]=0, <a>=u
	add	lr		;(u+l)
	rar			;(u+l)/2
	cmp	mr		;same as last time through?
	jz	nmatch		;jump if = to no match
;
;	more elements to scan
	mov	mr,a		;new middle value
	push	h		;save a copy of the base address
	push	d		;save s,m
	push	b		;save u,l
	push	h		;save another copy of the base address
	mov	sp1,sr		;s' = s
	mov	sp1p,sp1	;s'' = s'
	mvi	sr,0		;for double add operation below (double m)
;
	lxi	kr,0		;k=0
sumk:	dad	d		;k = k + m
	dcr	sp1		;s' = s' - 1
	jnz	sumk		;decrement if sp1 <> 0
;
;	k is now relative byte position
;
	pop	d		;table base address
	dad	d		;<hl> contains absolute address of byte to compare
	lxi	d,accum		;<de> address characters to compare
;
comk:		;compare next character
	ldax	d		;accum character to reg <a>
	cmp	m		;same as table entry?
	inx	d
	inx	h		;to next positions
	jnz	ncom		;jump if not the same
	dcr	sp1p		;more characters?
	jnz	comk
;
;	complete match at m
;
	pop	b
	pop	d		;m restored
	pop	h
	mov	a,mr		;value of m copied in <a>
	ret			;with zero flag set
;
ncom:		;no match, determine if less or greater
	pop	b		;u,l
	pop	d		;s,m
	pop	h		;table address
	jc	ncoml
;	accum is higher
	mov	lr,mr		;l = m
	jmp	next
;
ncoml:		;accumulator is low
	mov	ur,mr		;u = m
	jmp	next
;
nmatch:		;no match
	xra	a
	inr	a		;sets not zero flag
	ret
;
prefix:		;j c or r prefix?
	lda	accum
	lxi	b,(0c2h shl 8) or o5	;jnz opcode to <b>, type to <c>
	cpi	'J'
	rz			;return with zero flag set if j
	mvi	b,0c4h		;cnz opcode to <b>, type is in <c>
	cpi	'C'
	rz
	lxi	b,(0c0h shl 8) or o1	;rnz opcode
	cpi	'R'
	ret
;
suffix:		;j r or c recognized, look for suffix
	lda	acclen
	cpi	4		;check length
	jnc	nsuff		;carry if 0,1,2,3 in length
	cpi	3
	jz	suf0		;assume 1 or 2 if no branch
	cpi	2
	jnz	nsuff		;returns if 0 or 1
	lxi	h,accum+2
	mvi	m,' '		;blank-out for match attempt
;
suf0:		;search 'til end of table
	lxi	b,8		;<b>=0, <c>=8 counts table down to zero or match
	lxi	d,suftab
;
nexts:		;look at next suffix
	lxi	h,accum+1	;suffix position
	ldax	d		;character to accum
	cmp	m
	inx	d		;ready for next character
	jnz	next0		;jmp if no match
	ldax	d		;get next character
	inx	h		;ready for compare with accum
	cmp	m		;same?
	rz			;return with zero flag set, <b> is sufix
next0:	inx	d		;move to next character
	inr	b		;count suffix up
	dcr	c		;count table length down
	jnz	nexts
;
;	end of table, mark with non zero flag
;
	inr	c
	ret
;
nsuff:		;not proper suffix - set non zero flag
	xra	a
	inr	a
	ret
;
bget:		;perform binary search, and extract type and val fields for
;	the item.  zero flag indicates match was found, with type
;	in the accumulator, and val in register b.  the search is based
;	upon the length of the accumulator
;
;	register c contains a 00 if the item can be tokenized (i.e., it
;	appears in the fixed tables, and 01 if the item cannot be changed
;	to a token (e.g., jnc cnc)
;
	lda	acclen		;item length
	mov	c,a		;save a copy
	dcr	a		;acclen-1
	mov	e,a
	mvi	d,0		;double acclen-1 to <de>
	push	d		;save a copy for later
	cpi	cmax		;too long?
	jnc	nget		;not in range if carry
	lxi	h,clen		;length vector
	dad	d
	mov	ur,m		;fill upper bound from memory
	lxi	h,cinx
	dad	d
	dad	d		;base address to <hl>
	mov	d,m
	inx	h
	mov	h,m
	mov	l,d		;now in <hl>
	mov	sr,c		;fill the size register
	call	bsear		;perform the binary search
	jnz	scase		;zero if found
	sta	tloc		;in case the item is involved in toknum call
	pop	d		;restore index
	lxi	h,tvinx
	dad	d
	dad	d		;addressing proper tv element
	mov	e,m
	inx	h
	mov	d,m
;	<de> is base address of type/value vector, add displacement
	mov	l,a
	mvi	h,0
	dad	h		;doubled
	dad	d		;indexed
	xra	a		;clear zero flg for bget return - also
	mov	c,a		;clear <c> to indicate that the item is in tables
	mov	a,m		;type to acc
	inx	h
	mov	b,m		;value to <b>
	ret		;type in acc, value in <b>, zero flag set
;
scase:		;name not too long, but not found in tables, may be j c or r
	pop	d		;restore index
	call	prefix
	rnz			;not found as prefix j c or r if not zero flag
	push	b		;save value and type
	call	suffix		;zero if suffix matched
	mov	a,b		;ready for mask if zero flag
	pop	b		;recall value and type
	rnz			;return if not zero flag set
;
;	mask in the proper bits and return
;
	ora	a		;clear carry
	ral
	ral
	ral
	ora	b		;value set to jnz ...
	mov	b,a		;replace
	mov	a,c		;return with type in register <a>
	cmp	a		;clear the zero flag
	mvi	c,1		;mark as not in fixed tables
	ret
;
nget:		;can't find the entry, return with zero flag reset
	pop	d		;get the element back
	xra	a		;clear
	inr	a		;zero flag reset
	ret
;
toknum:		;compute the token number for the last item scanned
		;length must be greater than 1, result has high order bit set
	lxi	h,acclen	;2,3,...,cmax
	mov	c,m		;copy to <c>
	dcr	c		;1,2,...,cmax-1
	lxi	h,clen+1	;start counting at length 2
	xra	a		;clear the count
;
addl:		;add length for each item before current length
	dcr	c		;0,1,...,cmax-2
	jz	addl0		;reg <a> = 0 for length 2
	add	m		;otherwise add length of previous item
	inx	h		;to next item to add
	jmp	addl		;for another count
;
addl0:		;count of items in reg-a, add offset
	lxi	h,tloc		;computed during binary search
	add	m		;result in reg-<a>
	ori	80h		;to set high order bit
	ret
;
settok:		;<a> register contains a token number with high order bit set,
		;leave token length (>1) in register <b>, <hl> addressing string
	ani	7fh		;reduce to actual index
	lxi	h,toktab	;token table
	mov	e,a		;low order index
	mvi	d,0		;high order zero
	dad	d
	dad	d		;<hl> addresses index elt
;
;	high order 4 bits gives item length, low order 12 is char2 index
;
	mov	e,m		;low order index
	inx	h		;to high order byte
	mov	a,m		;ready to extract bits
	rar
	rar
	rar
	rar
	ani	0fh		;4 bit length in <a>
	mov	b,a		;saved in <b>
	mov	a,m		;another copy
	ani	0fh		;extract high order 4 bits of index
	mov	d,a		;<de> is index to char2
	lxi	h,char2
	dad	d		;<hl> addresses string for this token
	mov	a,b		;return with length in <a> and <b>
	ret
;
;	the following macros generate the token table
;
gen	macro	len
;;
;;	generate the toktab entries for the length len > 1
;;
	rept	clen&len	;;one for each entry in the table
	dw	(len shl 12) or nxtoken	;;len in high 4 bits, index in low 12
;;
nxtoken	set	nxtoken+len	;;indexed to next position
	endm			;;end of rept loop
	endm			;;end of macro
;
nxtoken	set	0		;start with zero index
nxtlen	set	2		;length to start with
;
toktab:		;generate the token table
	rept	cmax-1		;repeat for each length 2,...,cmax
	gen	%nxtlen		;generate the next length
nxtlen	set	nxtlen+1	;move to the next length
	endm
;
;
endmod	equ	($ and 0ff00h) + 100h		;next module address
	end
