;	operand scan module
;
	title	'macro source, operand scan module'
;
	org	1200h
;
;	externals
scmod	equ	1600h		;scanner module
symod	equ	1c00h		;symbol table module
bmod	equ	2100h		;binary search module
iomod	equ	2580h		;i/o module
commod	equ	2f80h		;common data
;
;
perr	equ	iomod+18h
scan	equ	scmod+6h	;scanner entry point
scanp	equ	scmod+0ch	;parameter scanner (used in nul)
cr	equ	0dh		;carriage return
;
lookup	equ	symod+6h	;lookup
found	equ	lookup+3	;found symbol if zero flag not set
enter	equ	found+3		;enter symbol
setty	equ	enter+3		;set type field
getty	equ	setty+3		;set type field
setval	equ	getty+3		;set value field
getval	equ	setval+3	;get value field
;
bsear	equ	bmod+3		;binary search routine
bget	equ	bsear+3		;get values with search
;
;	common equates
;
pbmax	equ	120		;max print size
pbuff	equ	commod+0ch	;print buffer
pbp	equ	pbuff+pbmax	;print buffer pointer
;
token	equ	pbp+1		;current token uder scan
value	equ	token+1		;value of number in binary
acclen	equ	value+2		;accumulator length
acmax	equ	64		;max accumulator length
accum	equ	acclen+1
;
evalue	equ	accum+acmax	;value from expression analysis
;
sytop	equ	evalue+2	;current symbol top
symax	equ	sytop+2		;max address+1
;
pass	equ	symax+2		;current pass number
fpc	equ	pass+1		;fill address for next hex byte
aspc	equ	fpc+2		;assembler's pseudo pc
;
;	global equates
;
iden	equ	1		;identifier
numb	equ	2		;number
strng	equ	3		;string
specl	equ	4		;special character
;
plabt	equ	0000$0001b	;program label
dlabt	equ	0000$0010b	;data label
equt	equ	0000$0100b	;equate
sett	equ	0000$0101b	;set
mact	equ	0000$0110b	;macro
;
extt	equ	0000$1000b	;external
reft	equ	0000$1011b	;refer
glbt	equ	0000$1100b	;global
;
;
;	table definitions
;
xbase	equ	0		;start of operators
oper	equ	24		;last operator
rt	equ	25
pt	equ	rt+1		;rt is register type, pt is pseudo operation
obase	equ	pt+1
;
plus	equ	5
minus	equ	6
notf	equ	0eh		;not
highf	equ	12h		;high
lowf	equ	13h		;low
lpar	equ	14h
rpar	equ	15h
nulf	equ	18h
osmax	equ	10
vsmax	equ	8*2
;
;
;	beginning of module
;
	jmp	endmod		;past this module
	jmp	opand		;scan operand field
	jmp	mulf		;multiply function
	jmp	dive		;divide function
;
unary:	ds	1		;true if next operator is unary
operv:	ds	osmax		;operator stack
hierv:	ds	osmax		;operator priority
vstack:	ds	vsmax		;value stack
osp:	ds	1		;operator stack pointer
vsp:	ds	1		;value stack pointer
;
;
stkv:		;place current <hl> value at top of vstack
	xchg		;hold value in <de>
	lxi	h,vsp
	mov	a,m
	cpi	vsmax
	jc	stkv0
	call	errex		;overflow in expression
	mvi	m,0		;vsp=0
;
stkv0:	mov	a,m		;get vsp
	inr	m		;vsp=vsp+1
	inr	m		;vsp=vsp+2
	mov	c,a		;save vsp
	mvi	b,00		;double vsp
	lxi	h,vstack
	dad	b
	mov	m,e		;low byte
	inx	h
	mov	m,d		;high byte
	ret
;
stko:		;stack operator (reg-<a>) and priority (reg-<b>)
	push	psw		;save it
	lxi	h,osp
	mov	a,m
	cpi	osmax
	jc	stko1
	mvi	m,00
	call	errex		;operator stack overflow
;
stko1:	mov	e,m		;get osp
	mvi	d,00
	inr	m		;osp=osp+1
	pop	psw		;recall operator
	lxi	h,operv
	dad	d		;operv(osp)
	mov	m,a		;operv(osp)=operator
	lxi	h,hierv
	dad	d
	mov	m,b		;hierv(osp)=priority
	ret
;
lodv1:		;load top element from vstack to <hl>
	lxi	h,vsp
	mov	a,m
	ora	a
	jnz	lodok
	call	errex		;underflow
	lxi	h,0000
	ret
;
lodok:	dcr	m
	dcr	m		;vsp=vsp-2
	mov	c,m		;low byte
	mvi	b,00
	lxi	h,vstack
	dad	b		;vstack(vsp)
	mov	c,m		;get low byte
	inx	h
	mov	h,m
	mov	l,c
	ret
;
lodv2:		;load top two elements <de> holds top, <hl> holds top-1
	call	lodv1
	xchg
	call	lodv1
	ret
;
apply:		;apply operator in reg-<a> to top of stack
	mov	l,a
	mvi	h,00
	dad	h		;operator number*2
	lxi	d,optab
	dad	d		;indexed optab
	mov	e,m		;low address
	inx	h
	mov	h,m		;high address
	mov	l,e
	pchl			;set pc and go to subroutine
;
optab:	dw	mulop
	dw	divop
	dw	modop
	dw	shlop
	dw	shrop
	dw	addop
	dw	subop
	dw	negop
	dw	eqop
	dw	ltop
	dw	leop
	dw	gtop
	dw	geop
	dw	neop
	dw	notop
	dw	andop
	dw	orop
	dw	xorop
	dw	hiop
	dw	loop
	dw	errex		;(
;
;	specific handlers follow
;
shft:		;set up operands for shift l and r
	call	lodv2
	mov	a,d		;ensure 0-15
	ora	a
	jnz	sherr
	mov	a,e
	cpi	17
	rc			;return if 0-16 shift
;
sherr:	call	errex
	mvi	a,16
	ret
;
negf:		;compute 0-<hl> to <hl>
	xra	a
	sub	l
	mov	l,a
	mvi	a,00
	sbb	h
	mov	h,a
	ret
;
divf:	call	lodv2
;
dive:		;(external entry from main program)
	xchg			;swap <de> with <hl> for divide function
;
;	compute x/y where x is in <de> and y is in <hl>
;	the value of x/y appears in <de> and x mod y is in <hl>
;
	shld	dtemp		;save x in temporary
	lxi	h,bnum		;store bit count
	mvi	m,11h
	lxi	b,0000		;intialize result
	push	b
	xra	a		;clear flags
dloop:
	mov	a,e		;get low y byte
	ral
	mov	e,a
	mov	a,d
	ral
	mov	d,a
	dcr	m		;decrement bit count
	pop	h		;restore temp result
	rz			;zero bit count means all done
	mvi	a,00		;add in carry
	aci	00		;carry
	dad	h		;shift temp result left one bit
	mov	b,h		;copy <h> and <l> to <a> and <c>
	add	l
	lhld	dtemp		;get address of x
	sub	l		;subtract from temporary result
	mov	c,a
	mov	a,b
	sbb	h
	mov	b,a
	push	b		;save temp result in stack
	jnc	dskip		;no borrow from subtract
	dad	b		;add x back in
	xthl			;replace temp result on stack
;
dskip:	lxi	h,bnum		;restore <hl>
	cmc
	jmp	dloop		;repeat loop steps
;
dtemp:	ds	2
bnum:	ds	1
;
;
mulf:		;multiply <de> by <hl> and replace <hl> with result
	mov	b,h
	mov	c,l		;copy of 1st value to <bc> for shift and add
	lxi	h,0000		;<hl> is the accumulator
;
mul0:	xra	a
	mov	a,b		;carry is cleared
	rar
	mov	b,a
	mov	a,c
	rar
	mov	c,a
	jc	mul1		;skip this add if lsb is zero
	ora	b
	rz			;return with <hl>
	jmp	mul2		;skip add
;
mul1:	dad	d		;add current value of <d>
;
mul2:	xchg			;ready for *2
	dad	h
	xchg
	jmp	mul0
;
mulop:		;multiply <de> by <hl>
	call	lodv2
	call	mulf
	jmp	endop
;
divop:		;divide <hl> by <de>
	call	divf
	xchg			;result to <hl>
	jmp	endop
;
modop:	call	divf
	jmp	endop
;
shlop:	call	shft		;check values
shl0:	ora	a		;done?
	jz	endop
	dad	h		;<hl>=<hl>*2
	dcr	a
	jmp	shl0
;
shrop:	call	shft
shr0:	ora	a		;done?
	jz	endop
	push	psw		;save current count
	xra	a
	mov	a,h
	rar
	mov	h,a
	mov	a,l
	rar
	mov	l,a
	pop	psw
	dcr	a
	jmp	shr0
;
addop:	call	lodv2
;
add0:	dad	d
	jmp	endop
;
;
subop:	call	lodv2
	xchg			;treat as <hl>+(-<de>)
	call	negf		;0-<hl>
	jmp	add0
;
;
negop:	call	lodv1
;
neg0:	call	negf		;compute 0-<hl>
	jmp	endop
;
;
eqf:		;return zero flag set if <hl>=<de>
	mov	a,d
	cmp	h
	rnz
	mov	a,e
	cmp	l
	ret
;
eqop:	call	lodv2
	call	eqf
	jnz	logf
	jmp	logt
;
;
ltop:	call	lodv2
;
ltop0:
	mov	a,l
	sub	e
	mov	a,h
	sbb	d
	jc	logt
	jmp	logf
;
;
leop:	call	lodv2
;
leop0:
	call	eqf
	jz	logt
	jmp	ltop0
;
;
gtop:	call	lodv2
	xchg
	jmp	ltop0
;
geop:	call	lodv2
	xchg
	jmp	leop0
;
;
neop:	call	lodv2
	call	eqf
	jnz	logt
	jmp	logf
;
;
logt:		;logical true
	lxi	h,0ffffh
	jmp	endop
;
;
logf:		;logical false
	lxi	h,0000h
	jmp	endop
;
;
notop:	call	lodv1
	inx	h		;65536-<hl> = 65535-(<hl>+1)
	jmp	neg0
;
;
andop:	call	lodv2
	mov	a,d
	ana	h
	mov	h,a
	mov	a,e
	ana	l
	mov	l,a
	jmp	endop
;
;
orop:	call	lodv2
	mov	a,d
	ora	h
	mov	h,a
	mov	a,e
	ora	l
	mov	l,a
	jmp	endop
;
;
xorop:	call	lodv2
	mov	a,d
	xra	h
	mov	h,a
	mov	a,e
	xra	l
	mov	l,a
	jmp	endop
;
;
hiop:	call	lodv1
	mov	l,h
	jmp	fill0
;
;
loop:	call	lodv1
;
fill0:	mvi	h,0000
;
endop:	jmp	stkv
;
;
endform:	;returns zero flag if symbol is cr, ;, or ,
	lda	token
	cpi	specl
	rnz			;not end if not special
;
	lda	accum
	cpi	cr
	rz
	cpi	';'
	rz
	cpi	'!'
	ret
;
endexp:		;same as endform, but checks for ,
	call	endform
	rz			;return if form found char
	cpi	','		;ok even if endform stopped on non specl
	ret
;
opand:		;scan the operand field of an instruction
		;(not a db with first token string > 2 or 0)
	xra	a
	sta	osp		;zero operator stack pointer
	sta	vsp
	dcr	a		;255
	sta	unary
	lxi	h,0000
	shld	evalue
;
op0:		;arrive here with next item already scanned
	call	endexp		;done?
	jnz	op1
;
;	empty the operator stack
;
empop:	lxi	h,osp
	mov	a,m		;get the osp and check for empty
	ora	a
	jz	chkval		;jump if empty
	dcr	m		;pop element
	mov	e,a		;copy for double add
	dcr	e
	mvi	d,00
	lxi	h,operv
	dad	d		;indexed - operv(osp)
	mov	a,m		;get operator
	call	apply		;apply operator
	jmp	empop
;
;
chkval:
	lda	vsp		;must have one element it the stack
	cpi	2
	cnz	errex
	lda	pbuff
	cpi	' '
	rnz			;evalue remains at zero
	lhld	vstack		;get double byte in stack
	shld	evalue
	ret
;
op1:		;more to scan
	lda	pbuff
	cpi	' '
	jnz	getop
	lda	token
	cpi	strng		;is this a string?
	jnz	op3
;
;	string - convert to double precision
;
	lda	acclen
	ora	a
	cz	errex		;error if length=0
	cpi	3
	cnc	errex		;error if length>2
	mvi	d,00
	lxi	h,accum
	mov	e,m		;lsbyte
	inx	h
	dcr	a		;<a> has the length
	jz	op2		;one or two bytes
	mov	d,m		;fill high order
op2:	xchg			;value to <hl>
	jmp	stnum		;store to stack
;
op3:		;not a string, check for number
	cpi	numb
	jnz	op4
	lhld	value		;numeric value
	jmp	stnum
;
op4:		;not string or number, must be id or specl
	call	bget		;binary search, get attributes
	jnz	op6		;match?
;
;	yes, may be operator
;
	cpi	oper+1
	jnc	op5
;
;	operator encountered ms nibble of <b> is priority number ls nibble
;	acc has the operator number, <b> has priority
;
	cpi	nulf		;is the form nul xxxx?
	jnz	notnul
	call	scanp		;what follows?
	call	endform
	jz	eolnul		;end of line encountered
	lda	token
	cpi	strng		;null string?
	jnz	clrfnul		;clear, return false
	lda	acclen		;is this a null string?
	ora	a
	jnz	clrfnul		;false returned
	call	scan		;followed by end of line?
	call	endexp
	jz	eolnul
;
;	non null encountered, clear to end of line
;
clrfnul:
	call	scanp
	call	endform
	jnz	clrfnul
	lxi	h,0000		;set to false
	jmp	stnul
;
eolnul:		;found end of line - store true
	lxi	h,0ffffh
;
stnul:		;store true/false value from <hl>
	call	stsub
	jmp	op0
;
;
notnul:	cpi	lpar		;(?
	mov	c,a		;save copy of operator number
	lda	unary
	jnz	oper1		;jump if not a (
;
;	( encountered, unary must be true
;
	ora	a
	cz	errex
	mvi	a,0ffh
	sta	unary		;unary is set true
	mov	a,c		;recover operator
	jmp	oper4		;calls stko and sets unary to true
;
;
oper1:		;not a left paren
	ora	a
	jnz	oper6		;must be unary since unary is set
;
;	unary not set, must be binary operator
;
oper2:		;compare hierarchy of tos
	push	b		;save priority and operator number
	lda	osp
	ora	a
	jz	oper3		;no more operators in stack
	mov	e,a		;osp to <e>
	dcr	e		;osp-1
	mvi	d,00
	lxi	h,hierv
	dad	d		;<hl> addresses top of operator stack
	mov	a,m		;priority of top operator
	cmp	b		;current greater?
	jc	oper3		;jump if so
;
;	apply top operator to value stack
;
	lxi	h,osp
	mov	m,e		;osp=osp-1
	lxi	h,operv
	dad	d
	mov	a,m		;operator number to acc
	call	apply
	pop	b		;restore operator number and priority
	jmp	oper2		;for another test
;
oper3:		;arrive here when operator is stacked
		;check for right paren balance
	pop	b		;operator number in <c>, priority in <b>
	mov	a,c
	cpi	rpar
	jnz	oper4		;jump if not a right paren
;
;	right paren found, stack must contain left paren to delete
;
	lxi	h,osp
	mov	a,m
	ora	a		;zero?
	jz	lperr		;paren error if so
	dcr	a		;osp-1
	mov	m,a		;stored to memory
	mov	e,a
	mvi	d,00
	lxi	h,operv
	dad	d
	mov	a,m		;top operator in reg-<a>
	cpi	lpar
	jz	nlerr		;jmp if no error - parens balance
;
lperr:	call	errex
;
;
nlerr:		;error reporting complete
	xra	a
	jmp	oper5		;to clear unary flag
;
oper4:		;ordinary operator
	call	stko
	mvi	a,0ffh		;to set unary flag
;
oper5:	sta	unary
	jmp	getop		;for another element
;
oper6:		;unary set, must be + - high low or not
	mov	a,c		;recall operator
	cpi	plus
	jz	getop		;ignore unary plus
	cpi	minus
	jnz	chknot
	inr	a		;change to unary minus
	mov	c,a
	jmp	oper2
chknot:		;unary not symbol?
	cpi	notf
	jz	oper2
	cpi	highf
	jz	oper2
	cpi	lowf
	cnz	errex
	jmp	oper2
;
;
op5:		;element found in table, not an operator
	cpi	pt		;pseudo operator?
	cz	errex		;error if so
	mov	l,b		;get low value to <l>
	mvi	h,00		;zero high order byte
	jmp	stnum		;store it
;
op6:		;not found in table scan, $?
	lda	token
	cpi	specl
	jnz	op7
	lda	accum
	cpi	'$'
	jz	curpc		;use current pc
	call	errex
	lxi	h,0000
	jmp	stnum
;
curpc:	lhld	aspc		;get current pc
	jmp	stnum
;
op7:		;not $, look it up
	call	lookup
	call	found
	jnz	fident
;
;	not found in symbol table, enter if pass 1
;
	mvi	a,'P'
	call	perr
	call	enter		;enter symbol with zero type field
	jmp	fide0
;
fident:	call	getty		;type to <hl>
	ani	0000$0111b
	mvi	a,'U'
	cz	perr
;
fide0:
	call	getval		;value to <hl>
;
stnum:		;store <hl> to value stack
	call	stsub		;check for unary and store value
;
getop:	call	scan		;for next item
	jmp	op0
;
stsub:		;store value, check for unary
	lda	unary
	ora	a		;unary operation set
	cz	errex		;operand encountered with unary off
	xra	a
	sta	unary		;set to off
	jmp	stkv		;stack the value, and return
;
errex:		;put 'e' error in output buffer
	push	h
	mvi	a,'E'
	call	perr
	pop	h
	ret
;
endmod	equ	($ and 0ff80h) + 80h		;next half page
	end
