	TITLE	'D.D. MDS DISKETTE FORMAT PROGRAM 1/21/79'
;	FORMAT DISKETTE ON MDS SYSTEM
;	COPYRIGHT (C) 1976, 1977, 1978, 1979
;	DIGITAL RESEARCH
;	BOX 579, PACIFIC GROVE
;	CALIFORNIA, 93950
nsects	equ	52

dbb	macro	v1,v2
	db	v1,v2
	endm
SKEWER	MACRO	SKEW
TRELT	SET	1
TRBASE	SET	1
	REPT	nsects	; SECTORS / TURN
	dbb	%trelt, 0e5h
TRELT	SET	TRELT+SKEW
	IF	TRELT GT nsects
TRBASE	SET	TRBASE+1
TRELT	SET	TRBASE
	ENDIF
	ENDM
	ENDM
;
	ORG	100H
	JMP	START
	DB	' COPYRIGHT (C) 1979 DIGITAL RESEARCH '
BASE	EQU	78H
RTYPE	EQU	BASE+1
RBYTE	EQU	BASE+3
ILOW	EQU	BASE+1
IHIGH	EQU	BASE+2
DSTAT	EQU	BASE
RESET	EQU	BASE+7
;
CR	EQU	13
LF	EQU	10
CTLC	EQU	03H	;CONTROL C
;
;	BDOS CONSTANTS
BOOT	EQU	0000H
BDOS	EQU	0005H
RCHARF	EQU	1	;READ CHARACTER
PBUFF	EQU	9
;
START:	LXI	SP,STACK
;	SIGN-ON MESSAGE
	LXI	D,SIGNON
	CALL	PRINT
RESTART:
	LXI	D,RETMSG
	CALL	PRINT
	CALL	READC
	CPI	CTLC	;CONTROL C?
	JZ	BOOT	;RESTART CP/M
	CPI	CR	;CARRIAGE RETURN
	JNZ	RESTART
;	CARRIAGE RETURN ENCOUNTERED
	OUT	RESET	;RESET DISK SYSTEM
	lxi	d, recalibrate
	call	exec$iopb
;
;	first, format first two tracks with alternating sectors
	LXI	H, IOPBA
	MVI	M, 0
	LXI	D, IOPB
	CALL	exec$iopb
	INR	M	; TO TRACK 1
	CALL	exec$iopb
;	FORMAT DIRECTORY TRACK WITH SLOW SKEW
	LXI	D, IOPB2
	CALL	EXEC$IOPB
; finally, format rest of disk with FAST SKEW sectors...
	LXI	H,IOPBa1	;NEXT TRACK
	MVI	M,3	; set it
	mvi	b, 74	; 74 tracks left
	LXI	D, IOPb1
FLOOP:
	CALL	exec$iopb
;	IO COMPLETE, GO TO NEXT
	INR	M	;NEXT TRACK
	DCR	B
	JNZ	FLOOP
	JMP	RESTART
exec$iopb:
	MOV	A,E	; GET LOW BYTE ADDR
	OUT	ILOW
	MOV	A,D	; GET HIGH BYTE ADDRESS
	OUT	IHIGH
WAIT:	IN	DSTAT
	ANI	4
	JZ	WAIT
;
	IN	RTYPE
	IN	RBYTE	;CLEAR IT
	RET
;

recalibrate:
	db	0
	db	0001$0011b	; recalibrate command
	db	0
	db	0
	db	0
	dw	0

IOPB:	DB	40H	; RANDOM MODE
	DB	0001$0010B	; FORMAT TRACK ON DRIVE 1
	DB	52
IOPBA:	DB	0		;NEXT TRACK
	DB	1	;SECTOR ADDRESS
	DW	BUFF	;BUFFER ADDRESS
BUFF:			; RANDOM SEQUENCE BUFFER
	SKEWER	26
IOPB2:
	DB 40H, 12H, 52, 2, 1
	DW	BUFFY

BUFFY:
	SKEWER	9

iopb1:
	db	40h,0001$0010b,nsects
iopba1:
	db	0
	db	1
	dw	buff1
buff1:
	skewer	13

SIGNON:	DB	CR,LF
	db	'Double Density Diskette Formatter Version 2.1'
	db	0dh,0ah,'Skew-6/4                  (CTL-C to Abort)$'
RETMSG:	DB	CR,LF
	DB	'DISK TO FORMAT IN B, TYPE RETURN$'
;
PRINT:	MVI	C,PBUFF
	CALL	BDOS
	RET
;
READC:	MVI	C,RCHARF
	CALL	BDOS
	RET
;
	DS	16
STACK:
	END
