

;REF NO. AB27
;PROGRAM TITLE REAL TIME EXECUTIVE
;
;
;
;			REAL TIME EXECUTIVE
;
;
;	THE REAL TIME EXECUTIVE IS DESIGNED TO PERFORM THE NECESSARY
; SCHEDULING AND TASK INITIALIZATION AND TERMINATION THAT CAN BE
; FOUND IN REAL-TIME ENVIRONMENTS.  IT IS NOT DESIGNED TO HANDLE
; A TIME SLICE ENVIRONMENT (I.E. TIMESHARING NETWORK).
;
;	THE EXECUTIVE SHOULD BE USED AS A CONTROL PROGRAM FOR THE
; VARIOUS APPLICATION TASKS A USER MIGHT WISH TO RUN.  IT WILL SCHEDULE
; TASKS ON A LIFO QUEUE FOR EXECUTION OR ON A TIME STACK FOR EXECUTION
; AT A LATER TIME.  THE CLOCK IS CURRENTLY SET UP ON AN 8-BIT WRAP-
; AROUND WITH THE CLOCK INTERRUPT FORCING AN RST 7.  A SMALLER TIME
; BASE CAN BE USED BY SCHEDULING A ROUTINE THAT RESETS THE CLOCK, THEN
; RESCHEDULES ITSELF.  A LARGER TIME BASE WOULD REQUIRE CHANGING THE
; CLOCK AND PERIODIC REQUEST ROUTINES TO HANDLE MORE CLOCK CELLS.
;
;	THE EXECUTIVE HAS 6 ROUTINES OR PARTS, 8 EQUATES, AND 5 OPTIONAL
; MACROS.  THE EQUATES DEFINE THE STORAGE AREAS USEY THE SYSTEM, THE
; ROUTINES HANDLE THE VARIOUS FUNCTIONS, AND THE MACROS PROVIDE A MEDIUM
; FOR USER CALLS TO THE SYSTEM.  DEFINITIONS ARE PROVIDED IN TABLE #1.
;
;	PLEASE NOTE THAT ALL THE STACKS AND QUEUES IN THE
; SYSTEM GROW DOWNWARD IN MEMORY TO BE CONSISTENT FIT ILTEL.  THE
; TIME STACK REQUIRES 3 BYTES PER ENTRY AND HAS A CELL OR ALL BINARY ONES
; AT THE TOP TO PREVENT IT FROM RUN-AWAY IN CASE IT IS EMPTY.  THE DISPATCH
; QUEUE REQUIRES 2 BYTES PER ENTRY, IS LIFO IN DESIGN, AND HAS NO PROVI-
; SIONS FOR ANOTHER PRIORITY SCHEME.  THIS IMPLIES THAT ONCE STARTED A
; ROUTINE OR TASK RUNS UNTIL COMPLETION ESCEPT FOR INTERRUPT PROCESSING.
;
;
;
;
;
;
;			TABLE #1
; 
; NAME		TYPE	FUNCTION
; 
; BRAM		EQU	DEFINES THE BASE OF RAM MEMORY
; NRAMS		EQU	DEFINES THE NUMBER OF 256 BYTE RAM BLOCKS
; QTSTK		EQU	DEFINES THE LOCATION OF THE TIME STACK
; QSYS		EQU	DEFINES THE LOCATION OF THE SYSTEM STACK
; QQUEP		EQU	DEFINES THE LOCATION OF THE DISPATCH QUEUE
; QCLOK         EQU     DEFINES THE CLOCK CELL
; QQUE          EQU     HOLDS THE CURRENT QUEUE POINTER (2 CELLS)
; QSTAK		EQU	HOLDS THE CURRENT TIME STACK POINTER (2 CELLS)
; INITR		MACRO	CALLS QINIT WITH THE ROUTINE ADDRESS AS PARAMETER
; TERM		MACRO	CALLS QDSPC (TERMINATES A ROUINE)
; INRET		MACRO	INTERRUPT RETURN WITH PSW RESTORE
; PEREQ	MACRO	CALLS QPERQ TO SCHEDULE A TASK FOR TIMED ENTRY
;			PARAMETERS: ADDRESS, TIME
; PERDY		MACRO	CALLS QPERQ TO SCHEDULE A TASK FOR DELAYED ENTRY
;			PARAMETERS: ADDRESS, DELAY
; QCLKI		ROUTINE	UPDATES THE CLOCK CELL AND CHECKS THE TOP OF THE
;			TIME STACK FOR TIMED ENTRIES
; QPERQ		ROUTINE	SCHEDULES A TASK TO BE ACTIVATED AT A LATER TIME,
;			DOESN'T ALLOW A TASK TO BE SCHEDULED TWICE FOR
;			THE SAME ACTIVATION TIME, MAINTAINS THE TIME STACK
;			IN INCREASING TIME ORDER.  ADDRESS IN D,E; TIME IN A
; QINIT		ROUTINE	ADDS A ROUTINE TO THE DISPATCH QUEUE.  ADDRESS IN
;			D,E.
; QDSPC		ROUTINE TERMINATES A ROUTINE BY EXITING TO THE NEXT ROUTINE
;			ON THE DISPATCH QUEUE.
; QWAIT	ROUTINE IDLES WHEN THE SYSTEM IS NOT BULD ALWAYS BE
;			LAST ON THE DISPATCH QUEUE, IT RESCHEDULES ITSELF.
; QINTP		ROUTINE	INITIALIZES THE PROCESSOR BY CLEARING RAM, SETTING
;			UP POINTERS, AND SCHEDULING THE SYSTEM WAIT AND MAIN
;			USER ROUTINES.
;
;
; PLEASE NOTE THAT THE EQUATES CAN BE CHANGED TO FIT A DIFFERENT MEMORY
; CONFIGURATION AND THAT THE MAIN USER ROUTINE IS CURRENTLY LABELED ACQRE.
;
;
;
;
;
;THE FOLLOWING MACROS ARE REQUIRED BY THE EXECUTIVE
;
INITR	MACRO	ADDR
	LXI	D,ADDR
	CALL	QINIT
	ENDM
TERM	MACRO
	JMP	QDSPC
	ENDM
;
;THESE MACROS ARE REQUIRED BY THE APPLICATIONS PROGRAM
;
INRET	MACRO
	POP	PSW
	EI
	RET
	ENDM
PEREQ	MACRO	ADDR,TIME
	LXI	D,ADDR
	MVI	A,TIME
	CALL	QPERQ
	ENDM
PERDY	MACRO	ADDR,DELAY
	LXI	D,ADDR
	LDA	QCLOK
	ADI	DELAY
	CALL	QPERQ
	ENDM
;
;THE FOLLOWING EQUATES ARE REQUIRED BY THE EXECUTIVE
;
BRAM	EQU	04000Q
NRAMS	EQU	02
QTSTK	EQU	BRAM+0300Q
QSYS	EQU	BRAM+0400Q
QQUEP	EQU	BRAM+0200Q
QCLOK	EQU	BRAM
QQUE	EQU	QCLOK+1
QSTAK	EQU	QQUE+2
;
;THE FIRST 64D CELLS ARE THE INTERCTORS
;
	DI		;PWER
	JMP	QINTP	;UP
;
;THIS IS THE CLOCK INTERRUPT ROUTINE.
;IT UPDATES THE CLOCK IN 116 CYCLES, TO ACTIVATE
;A TASK REQUIRES 237 CYCLES + INIT TIME.
;
	ORG	70Q	;RESTART 7
QCLKI:	PUSH	PSW	;SAVE
	PUSH	H	;REGS
	LXI	H,QCLOK	;INCREMENT
	INR	M	;CLOCK
	MOV	A,M	;CHECK
	LHLD	QSTAK	;TOP OF
	CMP	M	;STACK
	JC	QCLEX	;NONE READY
	PUSH	D
;
QCLP:	INX	H	;POP
	MOV	E,M	;ROUTINE
	INX	H	;AND
	MOV	D,M	;ADD
	INX	H	;TO
	PUSH	H	;DISPATCH
	CALL	QINIT	;QUEUE
	POP	H	;
	CMP	M	;ANY MORE
	JNC	QCLP	;YES
	POP	D
	SHLD	QSTAK
QCLEX:
	POP	H	;RESTORE
	INRET		;REGS & EXIT
;
;THIS IS THE PERIODIC REQUEST ROUTINE.  IT MANIPULATES THE
;STACK AND THEREFORE MASKS OFF INTERUPTS. PARAMETERS ARE
;ROUTINE ADDRESS IN D,E AND TIME IN A. THE BEST CASE EXECUTION
;IS 117 CYCLES, TO UNSTACK AND INSERT ONCE IS 329 CYCLES.
;ALL REGS ARE DESTROYED.
;
QPERQ:	MVI	B,0	;GET TIME
	DI		;STACK POINTER
	LHLD	QSTAK	;CHECK TOP
QCOMP:	CMP	M	;OF STACK
	JC	QASTK	;LOWER
	JZ	QADEQ	;EQUAL
	MOV	C,A	;HIGHER THAN
	MOV	A,F
	PUSH	PSW	;STACK
	INX	H	;REMOVE IT
	MOV	A,M	;AND
	PUSH	PSW	;SAVE IT
	INX	H
	MOV	A,M	;ADJUST
	PUSH	PSW	;POINTER	
	INX	H	;AND
	MOV	A,C	;TRY
	INR	B	;AGAIN
	JMP	QCOMP
QADEQ:	INX	H	;TIME
	MOV	A,E	;EQUAL	
	CMP	M	;CHECK ADDRESS
	JNZ	QRELD	;NOT EQUAL
	INX	H	;CHECK REST
	MOV	A,D	;OF
	CMP	M	;ADDRESS
	JZ	QEQAD	;EQUAL
	DCX	H	;NOT EQUAL
QRELD:	DCX	H	;RESTORE POINTER
	MOV	A,M	;TIME, AND
	JMP	QASTK	;ADD TO STACK
QEQAD:	DCX	H	;RESTORE
	DCX	H	;POINTER
	JMP	QSTKP	;POP STACK
QASTK:	DCX	H	;ADD REQUEST
	MOV	M,D	;TO TOP
	DCX	H	;OF TIME
	MOV	M,E	;STACK
	DCX	H	;ADJUST
	MOV	M,A	;POINTER
QSTKP:  DCR	B	;ANYTHING TO
	JM	QPREX	;RESTORE
	POP	PSW	;YES
	DCX	H	;RESTORE
	MOV	M,A	;REQUEST
	POP	PSW	;TO
	DCX	H	;TIME
	MOV	M,A	;STACK
	POP	PSW
	DCX	H	;THEN
	MOV	M,A	;TRY
	JMP	QSTKP	;AGAIN
QPREX:	SHLD	QSTAK	;SAVE
	EI		;POINTER
	RET		;AND EXIT
;
;INITIALIZER ROUTINE, ADDRESS IS PASSED IN D,E.
;DESTROYS H,L.  EXECUTION 74 CYCLES.
;
QINIT:	DI		;ADD
	LHLD	QQUE	;PROGRAM
	DCX	H	;TO
	MOV	M,D	;DISPATCH
QUEUE
	MOV	M,E	;
	SHLD	QQUE
	EI
	RET
;
;DISPATCHER ROUTINE, ENTRANCE UPON TASK TERMINATION.
;LIFO PRIORITY WITH EXIT TO NEXT TASK. (73 CYCLES).
;
QDSPC:	DI		;GET
	LHLD	QQUE	;NEXT
	MOV	E,M	;TASK
	INX	H	;PROM
	MOV	D,M	;QUEUE
	INX	H	;ALTER
	SHLD	QQUE	;POINTER
	XCHG		;AND
	EI		;EXIT TO
	PCHL		;NEW TASK
;
;SYSTEM WAIT ROUTINE, ALWAYS LAST ON THE QUEUE.
;IT WAITS UNTIL SOMETHING HAPPENS.
;
QWAIT:	INITR	QWAIT	;RE-INIT
	HLT		;WAIT
	TERM
;
;PROCESSOR INITIALIZATION ROUTINE
;
QINTP:	LXI	H,BRAM	;CLEAR
	XRA	A	;RAM
	LXI	B,(NRAMS SHL 8)+0FFH	;FROM BRAM
QCLRL:	MOV	M,A	;FOR
	INX	H	;256*NRAMS
	DCX	B	;BYTES
	CMP	B
	JNZ	QCLRL
	LXI	H,QTSTK	;FIX
	MVI	M,0FFH	;TIME
	SHLD	QSTAK	;STACK
	LXI	H,QQUEP	;DISPATCH
	SHLD	QQUE	;QUEUE
	LXI	SP,QSYS	;FINISH
	INITR	QWAIT	;INIT
;
;BEGINNING OF APPLICATION ROUINES
;
ACQRE:	END
