+ARCHIVE+ c2dbase.c     7415  7/31/1984 17:07:32
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>              /* standard header file */
#include <c2dbase.h>		/* c_to_dbase header file */

CHAR *version = "1.10";		/* version of application program */

/**

	main:

	This is the start of the application program to demonstrate
	interfacing to dBASE using the functions provided in the library.

*/

main(argc,argv)
SINT argc;
CHAR *argv[]; 
{
MASTER p;       /* pointer to master control structure */

	/* 
	  Print copyright message on the console 
	*/ 
	copyright(); 
	pause();

	/*
	   Get run-time memory space for p. 
	   Notice that this is the only function that is called
	   with &p.
	*/
	dalloc(&p);

	/* 
          Process user options
	*/
	options(p,argc,argv);

	/*
	  Open dbase data and index files 
	*/
	if(dopen(p) == FALSE)   	/* open the file(s) */ 
	   {
	   derror(p);
	   return;
	   }

	/*
	  Process user commands
	*/
	do dmenu(p);
	   while(docommand(p));

	/* 
          Tell user what's going on
	*/ 
	cls();
	tos();
	newline(10,stdout);
	printf("\n\t\tClosing files, please wait....");

	/*
	   Close dBASE data and index files
	   and free up allocated memory
	*/
	if(dclose(p))
	    dfree(p);

	/*
	  Exit to the operating system
	*/
	newline(10,stdout);
	return;
}               /* end  main */

/* print copyright message */
VOID copyright()
{
  fprintf(stderr,
"\n\tC to dBASE Interface Sample Application %s\n",version);
  fprintf(stderr,
"\tCopyright (C) 1983,84 Computer Innovations Inc, ALL RIGHTS RESERVED\n");
}

/* parse command line options */
VOID options(p,argc,argv)
MASTER  p; 
SINT  argc;
CHAR *argv[];
{ 
UCHAR tmp[BLOCK]; 

	cls();  /* clear the screen */
	tos();  /* position cursor to upper left hand corner of screen */

	/* no index file selected yet */
	p->m_ndx_here = FALSE; 
	/*
	  The code within the if(argc < 2) is here to make it
	  easy for someone to use this program the first time.
	  It could be deleted later on.
	*/
	if(argc < 2)	/* no file name given */
		{
again:		printf("\nEnter the name of your data base file.");
		printf("\nEnter DEMO to see the demo version > ");
		if((fgets(tmp,BLOCK,stdin)==NULL) || (tmp[0] ==  '\n')) 
		  goto again; 
		tmp[strlen(tmp)-1] = EOS; 
		upper(tmp);
		if(strcmp(tmp,"DEMO") == 0)
		  {
		  strcpy(p->m_dbf_name,"DEMO.DBF");
		  strcpy(p->m_ndx_name,"DEMO.NDX");
		  p->m_ndx_here = TRUE;
		  goto ready;
		  }
		strcpy(p->m_dbf_name,tmp);
		printf("\nEnter the name of your index file (if any) > ");
		if((fgets(tmp,BLOCK,stdin)==NULL) || (tmp[0] == '\n')) 
		   goto add_ext; 
		tmp[strlen(tmp)-1] = EOS; 
		upper(tmp);
	        strcpy(p->m_ndx_name,tmp);
		p->m_ndx_here = TRUE;
		goto add_ext;
		}

	/*
	  Prepare filenames by adding default extensions if necessary.
	*/
	strcpy(p->m_dbf_name,argv[1]);	/* data base file */

	if(argc > 2)
	  {
	  p->m_ndx_here = TRUE;		/* index file here */
	  strcpy(p->m_ndx_name,argv[2]);
	  }
add_ext:
	if(index(p->m_dbf_name,'.') == NULL)
		strcat(p->m_dbf_name,".DBF");

	if(p->m_ndx_here && (index(p->m_ndx_name,'.') == NULL))
		strcat(p->m_ndx_name,".NDX");

	upper(p->m_dbf_name); 	/* capitalize file names */ 
	upper(p->m_ndx_name); 	/* (this is optional)    */ 

ready:
	/* 
	  Select number of bytes reserved memory before
	  refusing allocation of memory. It is normally
	  not necessary to adjust this value, but it
	  should be useful for management of memory if
	  you are processing more than one dBASE 
	  file in your program.
	*/
	p->m_mincore = CORE_MIN;
	
}       			/* end options */

/**
	dmenu:

	This function prints out a menu for the user
	to select commands from. This is meant to work
	with docommand(), which calls the appropriate
	function as selected by the user.

	Returns: Nothing 

*/
VOID dmenu(p)
MASTER p;
{
/* data for the menu */
#define MENU 16
static struct { UCHAR id, *message; } mdata[] = { 
	'A',"APPEND new records at the end of the data base",
	'S',"SHOW records on the screen",
	'C',"Show Memory CACHE statistics on the screen", 
	'D',"DELETE records by record number",
	'E',"EDIT records by record number",
	'P',"PRINT records on the printer in 80 column format", 
	'W',"PRINT records on the printer in 128 column format (WIDE)", 
	'F',"Print records to DISK FILE in 80 column format", 
	'G',"Print records to DISK FILE in 128 column format (WIDE)", 
	'L',"LOCATE a record in the database by INDEX key", 
	'I',"Display records in the INDEX key order", 
	'M',"Show the STRUCTURE of the data base on the SCREEN", 
	'N',"Print the STRUCTURE of the data base on the PRINTER", 
	'K',"Show the KEYS of the INDEX file", 
	'X',"Examine individual NODES in the INDEX file", 
	'Q',"End the application program. QUIT", 
} ;	 
SINT i;

	/* clear screen and position cursor to top of screen */ 
	cls();
	tos();

	/* print copyright message */ 
	copyright(); 

	/* print out file name(s) */ 
	printf("\n\tData file name: %s",p->m_dbf_name);
	if(p->m_ndx_here)
	   printf("\tIndex file name: %s",p->m_ndx_name);

	/* print out the menu */ 
	printf("\n\n"); 
	for(i = 0; i < MENU; i++)
	   printf("\t%c\t%s\n",mdata[i].id,mdata[i].message);
	newline(2,stdout); 
	return;
}


/**
	docommand:

	This function controls which subroutine gets called
	depending on what the user types in at the keyboard.

	This function uses direct character console input.

	Returns: 
		FALSE if the user wants to QUIT 
		TRUE  if the user wants to continue 

*/

BOOL docommand(p)
MASTER p;
{
repeat:	
	printf("\rPlease select an option from the menu > "); 

	/* conin() is a macro defined in c2dbase.h */
	switch(toupper(conin()))
		{
		default: goto repeat;	/* ignore invalid values */

		case 'Q':       	/* quit, return to operating system */ 
		case ESC: 
			return FALSE; 

		case 'A':		/* append records to the data base */
			rappend(p);
			break;

		case 'C':		/* print memory cache statistics */ 
			pcache(p,stdout); 
			break; 

		case 'S': 		/* display records on console */
			rdisplay(p);
			pause();
			break;

		case 'D':		/* ERASE (delete) a record */
			rdelete(p);
			pause();
			break;

		case 'E': 		/* update records in data file */
			redit(p);
			break;

		case 'P':       		/* print records to printer */
			rprint(p,NARROW);       /* in 80 columns */ 
			break;

		case 'W':       		/* print record to printer */ 
			rprint(p,WIDE); 	/* in 128 columns */
			break;

		case 'F':			/* file records */ 
			filerecs(p,NARROW);     /* in 80 columns */ 
			break;

		case 'G':			/* file records  */ 
			filerecs(p,WIDE);       /* in 128 columns */ 
			break;

		case 'L':		/* locate a record by index */
			klocate(p);
			pause();
			break;

		case 'I':		/* display records in index order */
			kdisplay(p);
			pause();
			break;

		case 'M': 		/* directory structure(s) to screen */
			dscrhdr(p);
			pause();
			break;

		case 'N':		/* print directory structure(s) */
			dprthdr(p);
			break;

		case 'K':		/* show the index keys on the screen */
			kshow(p);
			break;

		case 'X':
			nexam(p);	/* examine a particular node */
			break;

		}
	
	return TRUE;
}
+ARCHIVE+ c2dbase.h     9206 10/15/1984 10:34:40
/*
	           C to dBASE II INTERFACE PROGRAM
    Copyright (c) 1983,84 Computer Innovations, Inc. All Rights Reserved. 

*/

#define TRUE 	  1	/* to provide boolean processing */
#define FALSE 	  0
#define DOS	  TRUE	/* for MS/PC-DOS systems */

#ifndef NULL
#define NULL 	  0
#endif

#ifndef EOS
#define EOS '\0'
#endif

/*
	C2DBASE.H - header file for the c_to_dbase system
*/

/* contrived data types */ 
#define UCHAR   unsigned char       /*  8 bits unsigned */ 
#define SCHAR   char		    /*  8 bits signed   */ 
#define CHAR	char		    /* 8 bits, doesn't matter */
#define SSHORT	short               /* 16 bits signed   */ 
#define USHORT  unsigned short      /* 16 bits unsigned */ 
#define SINT	int		    /* signed int */
#define UINT	unsigned int	    /* unsigned int */
#define SLONG   long                /* 32 bits signed   */ 
#define ULONG   unsigned long       /* 32 bits unsigned */ 
#define DOUBLE  double		    /* 64 bits floating point */ 
#define VOID	int		    /* doesn't return anything */ 
#define BOOL	int		    /* returns TRUE/FALSE */
#define NODE	struct dnode	    /* basic node structure */
#define KEY	struct bucket       /* basic key structure */ 
#define UKEY	union  ukey	    /* pointer union for keys */
#define RECNO   USHORT		    /* for record numbers */

/* 
	maximum number of fields per record, set by dBASE 
*/ 
#define MAX_FIELDS	32      /* don't change this parameter */

/*
	You will probably want to increase the next two defines if
	you want to process larger data files with indices
*/

/* name of the printer file */
#define PRTFILE	"PRN:"

/* maximum number of keys per node */
#define MAXKEYS	 255

/* maximum number of nodes per index file */
#ifdef	_C86_BIG 
#define MAXMN	 100           /* you need about 1K byte for each node */ 
#else 
#define MAXMN	 50 
#endif 

/* define minimum number of nodes in memory cache */
#define MINMN	3 

/* default maximum number of nodes in memory cache */
#define DEFMN	10 

/* default minimum number of bytes that coreleft() must return to call 
   calloc() */ 
#define CORE_MIN	3000

/* Define the stack level for processing of index file trees. 
   This should be enough for 64k keys. 
*/ 
#define STACKDEPTH 	9	/* actually 8 is enough, but be safe */ 

/* error code returns */
#define SUCCESS   	0	/* file is found and read correctly */
#define NO_FILE   	1	/* file not found and opened */
#define NOT_DBASE 	2	/* file opened was not dbase file */
#define FIELD_ERROR 	3	/* error reading a field */
#define NO_PRINT	4	/* printer not opened */
#define NDXERROR	5	/* index file error */
#define NO_CREATE	6	/* couldn't create dbase file */
#define FILE_EXISTS	7	/* file already exists */ 
#define NOARG 		10	/* no command line argument supplied */

#define EFFLUSH		20	/* fflush error */ 
#define EFWRITE		21    	/* fwrite error */ 
#define ERDNODE		22	/* error in reading node */ 
#define EFSEEK	     	23	/* error in fseek */ 
#define EDREAD	     	24	/* error in dread() */ 
#define EWR_NODE     	25	/* error in wr_node() */ 
#define EPOS_NODE    	26	/* error in pos_node() */ 
#define ERD_NODE     	27	/* error in rd_node() */ 
#define EDCLOSE		28	/* error closing data or index file(s) */
#define EDALLOC		29	/* error in dalloc() */
#define EDBOTTOM     	30	/* error in dbottom() */



/* special characters */
#define ESC 		0x1b	/* escape character     */
#define CTRLC 		0x03	/* control C character  */

/* for printing of records */
#define NARROW 		79	/* for 80 column output  */
#define WIDE 		127	/* for 128 column output */

/* dBASE data types */
#define CHARACTER 	'C'	/* dBASE character information */
#define LOGICAL 	'L'	/* dBASE logical information   */
#define NUMERIC 	'N'	/* dBASE numeric information   */

#ifdef	DOS
#define FNAMELEN	100	/* leave enough room for path in DOS 2.0 */ 
#else
#define FNAMELEN	15
#endif

#define	BLOCK 		255	/* temporary strings */ 

#define DBFHDRLEN	(521L)	/* data file header size */ 

#define NDXHDROFF 	(512L)	/* offset for index file header */ 
#define NODESIZE	(512L)  /* size of a node in bytes */

typedef struct master *MASTER;

/*
	struct bucket:

	This structure holds the actual key contents. These include
	a pointer to the lower level, a record number and the actual
	key that is being indexed on.

	The names of the elements of this structure begin with key_

*/

struct bucket {
		USHORT	 key_pll; 	/* pointer to lower level      */
		RECNO	 key_rno;	/* record number               */
		union ukey { 
			UCHAR  *ckey;
			DOUBLE *fkey;
			} key_val;
		} ;

/*
	struct dnode:

	This structure holds: 

	dn_nnode: the number of the node put here (zero if empty) 
	dn_dirty: TRUE if the node is dn_dirty 
	dn_nkeys: number of keys in this node 
	dn_leaf: pointer table for leaves	 
	 
	The names of the elements of this structure begin with dn_

*/

struct dnode {
	struct bucket **dn_leaf;	 /* pointer table for leaves */ 
	ULONG	 dn_used;		 /* for least recently dn_used  */ 
	USHORT   dn_nnode;		 /* number of node put here */ 
	UCHAR	 dn_dirty;		 /* is the node dn_dirty ? */ 
	UCHAR	 dn_nkeys;		 /* number of keys in this node */
} ;

/*
	struct dndx:
	
	This structure holds the index file header record information.
	This gives information about the nodes in the file and how
	they are to be interpreted.

	The names of the elements of this structure begin with ndx_

*/

struct dndx {
	RECNO	ndx_root, 	/* node number of root node      */
		ndx_next;	/* node number of next free node */
	SSHORT	ndx_nblocks,	/* # of blocks in memory         */ 
		ndx_ncnt;	/* # of nodes in the index file  */ 
	UCHAR	ndx_lkey, 	/* length of key                 */
		ndx_lkp, 	/* length of key + ptr (key+2)   */
		ndx_kmax, 	/* max. no. keys per node        */
		ndx_flag, 	/* 0 if character key            */ 
		ndx_fwidth,	/* field width		         */ 
		ndx_fprec,  	/* number of decimals	         */ 
		ndx_kexpr[256];	/* key expression in ASCII       */
	KEY 	*ndx_kcurr;	/* pointer to current key   */
	} ;

/*
	struct field_descr:

	This structure is dn_used to hold a single field in a record.
	It has places to store name, type, width, precision and the
	actual field contents, which may be character, numeric, or
	logical data. A union is provided so that any of the above 
	types can be placed in the same memory location even though
	they vary in size. In the following code:

	fld_u.string signifies a character string such as "this"
	fld_u.numeric signifies a floating point number such as 99.88
	fld_u.logical signifies a single character (logical) such as 'T'

	The names of the elements of this structure begin with fld_
*/

struct field_descr {
	union {
		DOUBLE numeric;		/* numeric data */
		UCHAR  string[BLOCK];	/* char string */
		UCHAR  logical;		/* logical data */
		} fld_u;
	UCHAR fld_type,			/* C N or L */
	      fld_width,    		/* field size binary */
	      fld_prec,     		/* number of decimals binary */
	      fld_name[11];     	/* Zero filled, ASCII */
	} ;
/*

	struct master:

	This structure is dn_used to hold the names of and the pointers to
	the data base file and the index file associated with it (if any),
	as well as the header record for the data base file. It also is
	dn_used to hold pointers to the other structures needed for indexed
	and sequential file processing. This is the master control 
	structure.

	This structure is needed for all processing.

	The names of the elements of this structure begin with m or m_

*/

struct master {
	struct 	dnode *mno[MAXMN];
	struct 	dndx *mndx;
	struct 	field_descr mfd[MAX_FIELDS];     /* field descriptors */
	FILE 	*m_ndx_ptr;	    	/* pointer to index file           */
   	FILE 	*m_dbf_ptr;	    	/* file pointer for i/o operations */
   	RECNO 	m_nrecs; 	    	/* number of records in the file   */
	USHORT	m_rsize; 		/* size of records 		   */
	USHORT 	m_mincore;		/* minimum amount of coreleft() 
  					 needed before calling calloc() */ 
	SSHORT	m_maxnodes;		/* # of memory buffers to use for nodes */
	UCHAR 	m_month,	 	/* date of last update             */
	     	m_day,
	        m_year,
	        m_nflds,	 	/* number of fields present        */
	      	m_deleted,	 	/* '*' if record deleted, else ' ' */
	      	m_error,     		/* error code */
	      	m_ndx_here,		/* TRUE if ndx is present          */
                m_dbf_name[FNAMELEN], 	/* name of dBASE data file  	   */
	     	m_ndx_name[FNAMELEN]; 	/* name of dBASE index file        */
        	} ;

/* 
	direct console io: bdos(1) will read single characters from the 
		console. If you want to use multiple character function keys 
		for commands, you should write a filter function to return 
		the proper single character for this program. Instead of
		using macros for conin and conout, just write functions 
		that do the proper checking. 

	These calls are the same for CPM-86 as for MS-DOS. 

*/ 
#define conin() (bdos(1)&0xff)  /* direct console input  */ 
#define conout(c) bdos(2,c);    /* direct console output */

+ARCHIVE+ char_up.c     2102  8/02/1984 10:56:10
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/**
	char_up:

	This function handles updating of character fields.

	Returns: 
		TRUE if a change was made to the field	
		FALSE if no change was made 

*/

BOOL char_up(p,fldno)
MASTER p;
USHORT fldno;
{
UCHAR tmp[BLOCK]; 

	/* show the user the field name and it's current contents */
	conout('\r');
	era_eol();
	printf("%-10s :",p->mfd[fldno].fld_name);
	printf("%-*s:",p->mfd[fldno].fld_width,
		p->mfd[fldno].fld_u.string);
	cur_bck(p->mfd[fldno].fld_width+1);

	/* get user response (if any) */
	if(fgets(tmp,BLOCK,stdin) == 0 || tmp[0] == '\n')
		return FALSE;

	/*
	  Get rid of '\n' character at the end of the string.
	  EOS is the end of string marker
	*/
	if(tmp[strlen(tmp)-1] == '\n') 
	   tmp[strlen(tmp)-1] = EOS; 

	/*
	  Put into memory record in the proper format.
	  sprintf is a standard C86 library routine. It's function
	  is the same as fprintf except the output is put into a string
	  instead of being written to a file. In this way, in-memory
	  formatting can occur easily. The format control string is as
	  follows:

	  % signifies a substitution is to occur
	  - means the item is to be left justified
	  * means that the field width is to come from the next argument
	  s means that the argument is the address of a string of characters
	
	*/
	/* limit the maximum length */
	truncate(tmp,p->mfd[fldno].fld_width);	

	/* do the in-memory format conversion */
	sprintf(p->mfd[fldno].fld_u.string,	/* where to put result   */
		"%-*s",				/* format control string */
		p->mfd[fldno].fld_width,	/* field width           */
		tmp);				/* string to print       */

	/* update the screen with the new field contents */
	cur_up(1);
	era_eol(); 	 
	printf("%-10s :",p->mfd[fldno].fld_name);
	printf("%-*s:\n",p->mfd[fldno].fld_width,
		p->mfd[fldno].fld_u.string);

	/* return TRUE if field has been changed */
	return TRUE;

}
+ARCHIVE+ dalloc.c      1458 10/12/1984 17:43:34

/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern UCHAR *calloc(); /* allocate memory and clear */

/**
	dalloc:

	This function provides run-time memory allocation
	for the master control structure.
	Some memory allocation is still needed for the
	key structure of the index file. See rd_khdr for that.

	Returns:
		TRUE if the requested memory was allocated
		FALSE if not
*/

BOOL dalloc(p) 
MASTER *p;	/* notice one more level of indirection */
{

	/*
	   Make sure this function is called with the 
	   ADDRESS of the master pointer i.e. dalloc(&p);
	   This is to provide enough space for the dBASE
	   structure. Use dfree(p) when you are finished
	   with the run-time storage area provided.
	   Calloc allocates the required space and then
	   sets it to zero.
	*/

	/* get space for master control structure */
	if((*p = (MASTER)calloc(1, sizeof(struct master)))==NULL) 
		return FALSE;
	 
	/* get space for index record structure */
	if(((*p)->mndx = (struct dndx *)calloc(1, sizeof(struct dndx)))==NULL)
	        {
		(*p)->m_error = EDALLOC;
		return FALSE;
	        }     

	/* set default coreleft() buffer */
        (*p)->m_mincore = CORE_MIN;

	return TRUE;
}               	/* end dalloc */ 


+ARCHIVE+ dbf2sdf.c     1745  8/09/1984 13:06:22
 /*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

main(argc,argv)
SINT argc;
UCHAR **argv;
{

  fprintf(stderr,"DBF2SDF 1.10\n");
  fprintf(stderr,
   "Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED\n");


  if(argc < 3)
    dpanic("usage :- dbf2sdf dbffile sdffile [delimiter]");

  if(argc > 3)
    tosdf(argv[1],argv[2],*argv[3]);
  else
    tosdf(argv[1],argv[2],0);

}

VOID tosdf(fdbf,fsdf,delimiter)
UCHAR *fdbf,*fsdf,delimiter;
{
MASTER p;
SINT i;
UCHAR outfile[BLOCK];
FILE *output;

extern UCHAR *index(),*upper();
extern FILE *fopen();

	  if(delimiter && isalnum(delimiter))
	        dpanic("cannot use delimiter: %c\n",delimiter);

	  if(dalloc(&p) == FALSE)
	       	dpanic("not enough memory to process");

	  strcpy(p->m_dbf_name,upper(fdbf));
	  if(!index(p->m_dbf_name,'.'))
			strcat(p->m_dbf_name,".DBF");
	  p->m_ndx_here = FALSE;
	  if(dopen(p) == FALSE)
	 	{
	 	dfree(p);
	 	dpanic("could not open data file: %s",p->m_dbf_name);
	 	}

	  strcpy(outfile,upper(fsdf));

	  if(!(index(outfile,'.')))
	 	strcat(outfile,".TXT");

	  if(!(output = fopen(outfile,"w")))
	 	dpanic("could not create SDF file");

	  for(i = 1; i < (p->m_nrecs+1); i++)
	 	{
	 	if(sdf_out(p,i,output,delimiter) == FALSE)
	 		dpanic("error writing output file");
	 	}

	  if(fclose(output) != 0)
	 	dpanic("error closing SDF file");

	  if(dclose(p) == FALSE)
	 	dpanic("error closing DBF file");

	  printf("%u records written to standard data format\n",p->m_nrecs);
}
+ARCHIVE+ dbfmake.c     1223  8/02/1984 10:58:14
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/* 
	dbfmake: create a dbase data file.

	Action: 

	1. create DBF file	 
	2. get fields from the user (console) 
	3. write header out 
	4. close DBF file 

	returns TRUE if successful, FALSE otherwise 

*/ 

dbfmake(p) 
MASTER p; 
{
extern FILE *fopen();

   /* check to see if it already exists */ 
   if(p->m_dbf_ptr=fopen(p->m_dbf_name,"r")){
	fclose(p->m_dbf_ptr);
	p->m_error = FILE_EXISTS;
	return FALSE;
   }

   /* try to open it for write */ 
   if(!(p->m_dbf_ptr=fopen(p->m_dbf_name,"wrb"))){ 
	p->m_error = NO_CREATE; 
	return FALSE; 
   } 

   get_date(p);         /* get date from user */ 

	fprintf(stderr,
		"\nEnter field descriptions: ");

   for(p->m_nrecs = p->m_nflds = p->m_rsize = 0;
			(p->m_nflds < MAX_FIELDS) && (def_fld(p));
				p->m_rsize += p->mfd[p->m_nflds++].fld_width)
						;
       
   if(!wdbfhdr(p))
		dpanic("couldn't write dbf header");

   if(dclose(p) == FALSE)
		dpanic("coudn't close DBF file");
 
   p->m_error = SUCCESS; 
   return TRUE; 
}



+ARCHIVE+ dbottom.c      916  8/02/1984 10:59:24
/*
                              C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SLONG fseek();        /* seek to byte offset in file */
extern BOOL dpos();	     /* position to record offset in dbf file */

/**
	dbottom:

	Position at the end of the last record.

	Returns:
		TRUE if successful
		FALSE if not
*/
BOOL dbottom(p)
MASTER p;		/* pointer to master control structure */
{

	if(p->m_nrecs) 
	  {
	  if(dpos(p,p->m_nrecs) == FALSE) 
		goto retf; 
	  if(fseek(p->m_dbf_ptr,(SLONG)p->m_rsize,1) == (-1L))
		goto retf;
	  } 
	else 
	  { 
	  if(fseek(p->m_dbf_ptr,DBFHDRLEN,0) != DBFHDRLEN)
		goto retf; 
	  } 
	return TRUE;
retf:
	p->m_error = EDBOTTOM;
	return FALSE;

}               	/* end dbottom */ 

+ARCHIVE+ dbtofp.c      1148  8/02/1984 10:59:32
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	dbtofp: convert dbase floating point
			key to floating point for C

	Returns: nothing.
	
	Sets *fval to the appropriate floating point value

*/

VOID dbtofp(fval,str)
DOUBLE *fval;   	/* pointer to floating point value */
UCHAR *str;             /* pointer to data area containing dBASE */
			/* floating point number */
{
SSHORT exponent, i; 
DOUBLE mantissa;

	exponent = (*str&0x7f) - 0x40;  /* the exponent is biased by 40h */ 
	mantissa = 0.0;
	for(i = 1; i < 6; i++)  /* calculate mantissa */ 
	   {
	   UCHAR d1, d2;
	   d1 = (*(str+i) >> 4) & 0x0f; 
	   d2 = *(str+i) & 0x0f; 
	   mantissa = (mantissa * 100) + (DOUBLE) (d1*10) + (DOUBLE)(d2); 
	   }

	for(; exponent < 9; exponent++) mantissa /= 10.0;
	for(; exponent > 9; exponent--) mantissa *= 10.0;

	*fval = (*str&0x80) ? (DOUBLE) -mantissa : (DOUBLE) mantissa;

	return; 
}       		/* end dbtofp */

+ARCHIVE+ dclose.c      1928  8/02/1984 10:59:44
/*
                            C to dBASE INTERFACE
      Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	dclose(p)

	This function closes the file opened by the function
	dopen. Any outstanding write data is automatically
	written to disk before the file is closed. 
	Operating system directory information is updated.

	Returns: 
		TRUE if file(s) closed successfully 
		FALSE if an error occurred 

*/

BOOL dclose(p)	/* close the dBASE files */
MASTER p;	/* pointer to the master control structure */
{
SINT code1, code2; 

#ifdef DOS      /* dBASE expects a CTRLZ to be at EOF, dos 2.xx does 
		   not automatically supply one on close */ 

extern SSHORT _systype;    /* this is defined in $main for C86 */ 
	  		   /* _systype==1 for DOS, 0 for CPM86 */

extern SLONG fseek();   /* seek to byte offset in file */ 
extern SLONG ftell();   /* tell current file position */ 

	/* flush any outstanding keys, if necessary */ 
	if(p->m_ndx_here && p->m_ndx_ptr)
	   { 
	   SINT i; 
	   for(i = 0; i < p->mndx->ndx_nblocks; i++)
             { 
	     if(nflush(p,p->mno[i]) == FALSE) 
	        dpanic("error flushing node: %d",i); 
	     } 
  	   /* write key file header */ 
	   if(wr_khdr(p) == FALSE)
	      dpanic("error writing key file header"); 
	   } 

	if(_systype==1)	/*  DOS 2.xx fix */
		{
		if(dbottom(p))
		  { 
		     do fputc(26,p->m_dbf_ptr); 
			while(ftell(p->m_dbf_ptr)&0x3ff); 
		  } 
		} 
#endif
	
	/* 
	   Use this function with dopen(p). This closes the
	   files opened by dopen. 
	*/


	code1 = fclose(p->m_dbf_ptr);

	code2 = 0; 
	if(p->m_ndx_here) 
		code2 = fclose(p->m_ndx_ptr);

  if(code1 == 0 && code2 == 0) return TRUE;

  p->m_error = EDCLOSE;
  return FALSE;

}			/* end dclose */

+ARCHIVE+ dcreate.c     1082  8/02/1984 11:00:04
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

/*
	create a dbase II data file
*/

#include <stdio.h>
#include <c2dbase.h>

main(argc,argv)
SINT argc;
CHAR **argv;
{

  fprintf(stderr,"DCREATE 1.10\n");
  fprintf(stderr,
    "Copyright (C) 1984 Computer Innovations Inc, ALL RIGHTS RESERVED\n");


  if(argc<2)
	dpanic("usage: dcreate file[.dbf]");
  do_create(*++argv);
}


/* create a dBASE .DBF file */ 
do_create(dbffile)
UCHAR  *dbffile;
{ 
MASTER p;

  if(dalloc(&p) == FALSE)		/* get memory for header */
   	dpanic("couldn't get memory for allocation"); 	 

  strcpy(p->m_dbf_name,dbffile); 	/* add .dbf to file name */
  if(!index(p->m_dbf_name,'.')) 
	strcat(p->m_dbf_name,".dbf"); 

  p->m_ndx_here = FALSE; 	  	/* no index file present */

  if(dbfmake(p)) 			/* create .DBF file */
	fprintf(stderr,"File created: %s\n",p->m_dbf_name);
  else
   derror(p);				/* report the error */

  dfree(p); 				/* free up memory for header */
} 

+ARCHIVE+ ddisk128.c     912  8/02/1984 11:00:30
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SSHORT doutput();	 /* output a record to a file */ 

/**

	ddisk128:

	This function calls doutput with the proper parameters to
	accomplish writing a record to a disk file in 128 column format.
	Don't forget to open the file in ASCII WRITE mode first and
	include the pointer to that file as the third argument to this
	function. 

	Returns: The number of lines output

*/

SSHORT ddisk128(p,recno,o)
MASTER p;       	/* pointer to the master structure */
RECNO recno;           /* the record number to write */
FILE *o;        	/* stream pointer for file to write to */
{

	if(o == NULL) return 0; 
	return doutput(p,recno,o,WIDE);
}

+ARCHIVE+ ddisk80.c      831  8/02/1984 11:00:44
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SSHORT doutput(); /* output a record to a file */ 

/**

	ddisk80:

	This function calls doutput with the proper parameters to
	accomplish writing a record to a disk file in 80 column format.
	Don't forget to open the file in ASCII WRITE mode first and
	include the pointer to that file as the third argument to this
	function. 

	Returns: The number of lines output

*/
SSHORT ddisk80(p,recno,o)
MASTER p;
RECNO recno;   /* record number to write */
FILE *o;	/* pointer to file successfully opened for ASCII WRITE */
{

	if(o) return doutput(p,recno,o,NARROW);
	return 0; 
}
+ARCHIVE+ def_fld.c     2472  8/02/1984 11:01:00
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED

*/
#include <stdio.h>
#include <c2dbase.h>

/*

	def_fld: get a field definition from the user	
	return: 
		FALSE if user is done 
		TRUE if user wants to continue 
*/
def_fld(p) 
MASTER p; 
{ 
UCHAR fname[BLOCK],		/* field name */ 
		ftype,          	/* field type */ 
		fwidth, 		/* field width */ 
		fprec;  		/* # decimals */ 
UCHAR buffer[BLOCK];    	/* console response storage */ 
UCHAR *cp;      		/* for traversing string    */ 
SINT numcvt;               	/* # of args converted by sscanf */ 
UCHAR fnumber;                  /* field number */ 

   fnumber = p->m_nflds;  			/* get field number */ 
   printf("%03u: ",fnumber+1);    		/* display field no */ 

   if(fgets(buffer,BLOCK,stdin)==0 || buffer[0]=='\n') 
	return FALSE; 

   for(cp=buffer;*cp;cp++){ 
	if(isalnum(*cp)) 
		*cp=toupper(*cp);       	/* uppercase */ 
	else 
		*cp=' ';			/* rid of nonalphanumerics */ 
   } 

   for(cp=buffer;*cp && isspace(*cp);cp++)
		;       			/* skip leading whitespace */ 

   if(sscanf(cp,"%s",fname)<1)goto inputerr;  	/* get field name */ 

   cp += strlen(fname);				/* skip over name */ 

   while(*cp && isspace(*cp))
	cp++;   				/* skip whitespace */ 

   switch(ftype = *cp++){           		/* which type ? */ 
	default: goto inputerr; 
	case LOGICAL: 
		fwidth=1;       		/* field width */ 
		fprec=0;			/* no. of decimals */ 
		break;  			/* are zero for logical */ 

	case NUMERIC:
	case CHARACTER: 
		numcvt=sscanf(cp,"%d %d",&fwidth,&fprec); 
		if(numcvt<1)
			goto inputerr; 
		if(numcvt<2)
			fprec=(ftype==NUMERIC?2:0);			 
		break;
   } 

   /* copy over results */ 
   strncpy(p->mfd[fnumber].fld_name,fname,11);       /* field name */ 
   p->mfd[fnumber].fld_type=ftype;           	/* field type */ 
   p->mfd[fnumber].fld_width=fwidth;         	/* field width */ 
   p->mfd[fnumber].fld_prec=fprec;           	/* # decimals */ 
   return TRUE; 

inputerr:       /* tell user how to do it */ 
	printf("\nInput error:"); 
	printf("\nEnter:  Fieldname Type [Width] [Decimals]"); 
	printf("\nHere are some examples:\n\n"); 
	printf("\nNAME C 20"); 
	printf("\nAMOUNT N 9 3"); 
	printf("\nTAX N 7"); 
	printf("\nREADY L"); 
	printf("\n\nThe default decimals for numerics is 2.\n"); 
	return def_fld(p);     /* try again */ 
} 






+ARCHIVE+ del_rec.c     1034  8/02/1984 11:01:12
/*
                           C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

extern BOOL dget_rec();	        /* read record n */
extern BOOL dput_rec();		     /* write record n to disk */
extern SSHORT dscreen();        /* display record on screen */ 

/**

	del_rec: mark a record for delete

*/

BOOL del_rec(p,recno)
MASTER p;
RECNO recno;
{

	/* position file pointer and read the record from disk */ 
	if(dget_rec(p,recno) == FALSE)
		return  FALSE;

	printf("\nThis is the record to delete:\n");
	dscreen(p,recno);                   /* show it to the user */ 

	printf("\nDo you want to delete this (y/n) ? ");
	if(toupper(conin()) != 'Y') return TRUE;     /* get permission */ 

	p->m_deleted = '*';       		/* mark for delete */ 
	if(dput_rec(p,recno) == FALSE)
		return FALSE; 

	printf("\nRecord number %u deleted\n",recno);   /* tell user */ 
	return TRUE;         				/* that's all */ 
}

+ARCHIVE+ derror.c       958  8/09/1984 13:29:00
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

#define NERRORS  32

static char *errors[NERRORS] = {
"\0",
"File not opened",
"Not a dBASE II file",
"Error reading field",
"Printer not opened",
"Index file",
"File creation",
"File already exists",
"\0",
"\0",
"Illegal command line",
"\0",
"\0",
"\0",
"\0",
"\0",
"\0",
"\0",
"\0",
"\0",
"Flush",
"Write",
"Node read",
"Seek",
"Record read",
"Node write",
"Node position",
"Node read",
"Close",
"Alloc",
"Seek",
"\0"
} ;


derror(p)
MASTER  p;
{

	  fprintf(stderr,"\nC to dBASE interface error\n\n");

	  if((p->m_error > NERRORS) || (*errors[p->m_error] == NULL))
		  fprintf(stderr,"\n\t\tUnknown error message: %d\n",p->m_error);
	  else
		  fprintf(stderr,"\n\t\t%s error\n",errors[p->m_error]);

     pause();
}




+ARCHIVE+ dflush.c       701 10/15/1984 11:19:26
#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	dflush:  Force written data to disk

	Returns: 
		TRUE if all went well
		FALSE if not 

	Usage: call this function when you wish to force 
	   all outstanding data to disk. This should help 
	   preserve data base integrity in case of operator
	   abort and/or system failure.
*/
BOOL dflush(p)
MASTER p; 	/* pointer to the master control structure */
{
int ret;

  if(p->m_dbf_ptr)
    {
    ret = fflush(p->m_dbf_ptr);
    if(p->m_ndx_here && p->m_ndx_ptr)
      {
      ret |= fflush(p->m_ndx_ptr);
      }
  }
  else ret=-1;
  return ret ? FALSE : TRUE;
}

+ARCHIVE+ dfree.c       1079  8/02/1984 11:01:18
/*
                           C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h> 
#include <c2dbase.h> 

extern VOID rel_node();		/* free individual nodes */ 

/**
	dfree: Releases all run-time memory space
               associated with the master control structure. 

	This includes memory allocated by dalloc() as well 
	as memory allocated by rd_khdr() when reading in the 
	index file header. 

	Returns: Nothing.

*/
VOID dfree(p)
MASTER p;       /* pointer to master structure */ 
{	

	/*
	   Frees up allocated space so that it can be dn_used
	   in a subsequent memory allocation call.
	*/

	/* handle index file keys first */ 
	if(p->m_ndx_here) 
	   { 
	   SSHORT nn; 
	   for(nn = 0; nn < p->mndx->ndx_nblocks; nn++)
		rel_node(p,p->mno[nn]); 
		if(p->mndx->ndx_kcurr) kfree(p,p->mndx->ndx_kcurr);
	   }


	if(p->mndx) free(p->mndx);   /* free index file pointer */ 
	free(p);        	   /* free master file pointer */ 

}               	/* end dfree */ 

+ARCHIVE+ dget_rec.c     457  8/02/1984 11:01:32
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

extern  BOOL dpos();
extern  BOOL dread();

/*
	dget_rec: read a record from the data file
*/
BOOL  dget_rec(p,r)
MASTER p;               /* pointer to master structure */
RECNO r;               /*  record no. (1 through n) */
{

   return dpos(p,r) && dread(p);
}
+ARCHIVE+ dinit.c       1204  8/02/1984 11:01:42
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	dinit:

	This function is dn_used to initialize a records contents to zeros.
	This is dn_used for adding records onto the end of a file. It 
	creates a NULL record to be filled by the user.

	Returns: 
		TRUE if successfull
		FALSE otherwise
*/

BOOL dinit(p)
MASTER p; 	/* pointer to master control structure */
{
SSHORT i;

	/* 
	   set the deleted / not deleted character to not deleted.
	*/
	
	p->m_deleted = ' ';	

	/* 
	   set each field in memory to zeroes.
	*/
	
	for(i = 0; i < p->m_nflds; i++)
	   switch(p->mfd[i].fld_type)
		{
		default: return FALSE;

		case CHARACTER: 	/* char string */ 
			setmem(p->mfd[i].fld_u.string,
				p->mfd[i].fld_width,EOS);
			break;

		case NUMERIC:   	/* floating point */ 
			p->mfd[i].fld_u.numeric = 0.0;
			break;

		case LOGICAL:   	/* boolean */ 
			p->mfd[i].fld_u.logical = 'F';
			break;
		}
	return TRUE;    	/* that's all */ 
}       			/* end dinit */ 

+ARCHIVE+ disp_key.c    1606  8/02/1984 11:01:56
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern SSHORT get_node();	/* get node from cache */ 
extern BOOL dpos();     	/* position to record */ 
extern BOOL dread();    	/* read record */ 
extern SSHORT dscreen();	/* display record on screen */ 

/**

	disp_key:  display records on index key 
		
	work routine for kdisplay , dn_used recursively

	Returns: Nothing.

*/
VOID disp_key(p,rtno)
MASTER p; 		/* pointer to master control structure */
RECNO rtno;		/* the root node */
{
UINT lf;		/* leaf index */ 
NODE *np;       	/* node pointer */ 

	if(rtno == 0) return;	/* exit condition, just in case */

	/*
	  Note: dBASE node numbers go from 1 to n but the array
	  goes from 0 to n-1.
	*/

	np = p->mno[get_node(p,rtno)]; 
	for(lf = 0; lf <= np->dn_nkeys; lf++)
	  {	
	  KEY *kp;	/* key pointer */
	  /* 
	     if it's the extra key and it's pointer to lower level 
	     is zero, forget it 
	  */ 
	  if(lf == np->dn_nkeys && np->dn_leaf[lf]->key_pll == 0) 
	    break; 

	  kp = np->dn_leaf[lf];
	  if(kp->key_pll != 0) /* display a node */ 
	    {
	    disp_key(p,kp->key_pll);
	    np = p->mno[get_node(p,rtno)]; 
	    continue;		
	    } 
	  if(kp->key_rno == 0)			/* check record number     */ 
		continue; 
	  if(dpos(p,kp->key_rno) == FALSE)    	/* position file pointer   */ 
		break; 
	  if(dread(p) == FALSE) 	  	/* read the record */ 
		break; 
	  dscreen(p,kp->key_rno);     		/* display record */ 
	  }

}

+ARCHIVE+ dnullndx.c    1291  8/02/1984 11:02:06
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h> 
#include <c2dbase.h> 

/* 
	dnullndx: 

	create null index file 
*/ 
BOOL dnullndx(p,fieldname) 
MASTER p; 
UCHAR *fieldname; 
{ 
SSHORT fldno;

  /* open data file */ 
  p->m_ndx_here = FALSE; 
  if(dopen(p) == FALSE) return FALSE; 

  /* verify fieldname */ 
  if(isfldn(p,fieldname,&fldno) == FALSE)
	goto retfalse;

  /* make sure it's not logical */ 
  if(p->mfd[fldno].fld_type == LOGICAL) 
	goto retfalse;

  /* open new index file */ 
  p->m_ndx_ptr = fopen(p->m_ndx_name,"wrb"); 
  if(!p->m_ndx_ptr)  
	goto retfalse;
  p->m_ndx_here = TRUE; 

  fputc(0,p->m_ndx_ptr); fputc(0,p->m_ndx_ptr); 
  p->mndx->ndx_root = 1; 
  p->mndx->ndx_next = 1; 
  p->mndx->ndx_lkey = p->mfd[fldno].fld_width+2; 
  p->mndx->ndx_lkp = p->mndx->ndx_lkey+2; 
  p->mndx->ndx_kmax = (NODESIZE) / p->mndx->ndx_lkp;
  p->mndx->ndx_flag = (p->mfd[fldno].fld_type != CHARACTER);  
  p->mndx->ndx_fwidth = p->mfd[fldno].fld_width; 
  p->mndx->ndx_fprec = p->mfd[fldno].fld_prec; 
  strcpy(p->mndx->ndx_kexpr,fieldname); 
  if(nextend(p) && dclose(p)) 
        return TRUE; 

  dclose(p); 
retfalse:
  return FALSE;
} 

+ARCHIVE+ do_gnext.c    1909 10/15/1984 10:35:16
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern SINT keycmp();
extern SINT get_node();
extern NODE *st_pop();
extern VOID keycpy();
extern VOID st_push();


/*
 	do_gnext: search in this node for the next key in the index file

	returns:  Record number if found or Zero if unsuccessfull
	
*/
RECNO do_gnext(p,root)
MASTER p;
USHORT  root;
{
RECNO recno;
SINT  ky; 	/* key offset in node */
SINT  pky;	/* parent node index  */
SINT  st;	/* status */
SINT  here;	/* where the next key is */
NODE *npar;	/* ptr to parent node */
NODE *np; 	/* ptr to this node */
NODE *saven;	/* ptr to saved node */


   /* look for the current one */
   np = p->mno[get_node(p,root)];
   for(ky = 0; ky < np->dn_nkeys; ky++)
     {
     st = keycmp(p,&np->dn_leaf[ky]->key_val,&p->mndx->ndx_kcurr->key_val);
     if(st > 0) 
	break;
     if(st == 0 && np->dn_leaf[ky]->key_rno == p->mndx->ndx_kcurr->key_rno)
	break;
     }
   here = ky+1;

   if(np->dn_leaf[ky]->key_pll == 0)
     {
     if(here >= np->dn_nkeys)
	{
	if((npar = st_pop()) == NULL) return 0;
	for(pky = 0; pky < npar->dn_nkeys; pky++)
	   {
	   if(keycmp(p,&npar->dn_leaf[pky]->key_val,
		       &np->dn_leaf[ky]->key_val) > 0)
		break;
	   }
	if(npar->dn_leaf[pky]->key_pll != np->dn_nnode)
	  {
	  np = p->mno[get_node(p,npar->dn_leaf[pky]->key_pll)];
	  here = 0;
 	  }
	}
     }
   else					/* look in lower level */
     {
     if((saven = new_node(p)) == NULL) 
	return 0;
     nodecpy(p,saven,np);
     st_push(saven);
     recno = do_gnext(p,np->dn_leaf[ky]->key_pll);
     if(st_empty() ==  FALSE) st_pop();
     rel_node(p,saven);
     return recno;
     }

   keycpy(p,p->mndx->ndx_kcurr,np->dn_leaf[here]);
   return p->mndx->ndx_kcurr->key_rno;
}



+ARCHIVE+ do_more.c      786  8/02/1984 11:02:16
/*
                             C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/**
	do_more:

	This function is dn_used when screenful of data has been put out.
	This allows the user to view the records before they roll off
	the screen. The user can strike [RETURN] to continue or [ESC]
	to not view the rest of the records.

	Returns: 
		TRUE  if the user wants to continue 
	 	FALSE if the user wants to quit  

*/

BOOL do_more()
{
SINT ch;
static UCHAR *choice =  
	"\r\nPress [ENTER] to continue or [ESCAPE] to quit...."; 

	outstr(choice);
	while((ch = conin()) != ESC && ch !=  '\r') ;
	conout('\r');
	era_eol();
	return(ch == '\r' ? TRUE : FALSE);
}

+ARCHIVE+ doindex.c     1240  8/02/1984 11:10:12
/*
                              C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/* 
	doindex: 

	generate an new index from the data file. 
	assumes that both data and index files have been opened. 

*/ 
BOOL doindex(p,fieldname)
MASTER p; 
UCHAR *fieldname;
{ 
RECNO  i; 
USHORT fldno;
SINT  fieldlen;
UCHAR  str[BLOCK]; 

  /* verify fieldname */ 
  if(isfldn(p,fieldname,&fldno) == FALSE)
	goto badndx; 

  /* make sure it's not logical */ 
  if(p->mfd[fldno].fld_type == LOGICAL) 
	goto badndx; 

  /* index all the records in ascending order */
  fieldlen = p->mndx->ndx_lkey;
  for(i = 1; i < p->m_nrecs+1; i++) 
     { 
     if(dget_rec(p,i) == FALSE)
			goto badndx;
     if(p->mndx->ndx_flag) 
		  { 
	     sprintf(str,"%*.*lf",p->mndx->ndx_fwidth+p->mndx->ndx_fprec, 
			     p->mndx->ndx_fprec,p->mfd[fldno].fld_u.numeric); 
		  } 
     else 
        { 
		  str[fieldlen] = EOS;
        sprintf(str,"%-*.*s",fieldlen,fieldlen,p->mfd[fldno].fld_u.string);
		  } 
     if(kadd(p,i,str) == FALSE) 
			goto badndx; 
     } 
   return TRUE; 

badndx: 
  derror(p);
  return FALSE; 
} 
+ARCHIVE+ dopen.c       5574  8/02/1984 11:10:22
/*
                            C to dBASE INTERFACE
      Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL rd_khdr();	/* read index file header */
extern UCHAR *upper();  /* translate string to upper case */

/**
	dopen:

	1. Attempt to open the file named by p->m_dbf_name
	2. Attempt to read in the header record for the
	   dBASE II sequential file (of type .DBF) and initialize
	   the pertinent cells in the struct master *p pointer.
	3. If p->m_ndx_here has a non-zero value:
	   a. Attempt to open the file named by p->m_ndx_name
	   b. Attempt to read in the header record for the
		dBASE II index file (of type .NDX) and initialize
		the appropriate cells in the header structure.
	   c. Attempt to read in the index file keys and 
		allocate memory necessary to store those keys. 
		This is the responsibility of rd_khdr(). 

	If all of the above are accomplished as expected, dopen 
	returns TRUE. 

	If any of the above fail, the appropriate error code 
	is set for p->m_error, the files are closed and 
	dopen returns FALSE. 
	Notes: 
		Before dopen is called, memory for the master 
		structure and the index master should be allocated 
		via dalloc(&p). If this is not done, your 
		data will not be processed correctly. 

		Also note that the filename fields p->m_ndx_name and 
		p->m_dbf_name must be initialized to some file names 
		allowed by your operating system. 

		If you are not using Computer Innovations C86 Compiler 
		you should make sure that your open logic is the same 
		before proceeding. Make sure that the data and index 
		files are opened in BINARY mode. BINARY mode means that 
		no special CRLF or CTRLZ processing is to be done, 
		so data is processed "as is". 

		Files should be opened in a READ/WRITE BINARY UPDATE mode. 

*/
BOOL dopen(p) 
MASTER p;  /* pointer to the master control structure */
{
SSHORT	i;
UCHAR	tmp;

	/* open the file for READ/WRITE BINARY */ 
	p->m_dbf_ptr = fopen(p->m_dbf_name,"rwb");

	/* 
	  Check if the open operation was successful.
	  A successful open operation returns a non-zero
	  value.
	 */
	if(p->m_dbf_ptr == NULL) 	/* file did not exist */
		{ 
		p->m_error = NO_FILE;	/* file not opened */
		return FALSE;
		}
	
	/* 
	   Check if the file is a dBASE file. A dBASE .DBF  file
	   will have a byte with the value 2 as its first byte.
	*/
	if((fread(&tmp,1,1,p->m_dbf_ptr) == NULL) || (tmp != 2))
		{
		p->m_error = NOT_DBASE;	/* not a dBASE file */
		fclose(p->m_dbf_ptr);		/* close file */
		return FALSE;
		}	

	/* 
	   Read number of records in this data base. This is one
	   2 byte binary field.
	*/
	if(fread(&p->m_nrecs,2,1,p->m_dbf_ptr) == NULL)
		{
		p->m_error = FIELD_ERROR;	/* incorrect format */
		fclose(p->m_dbf_ptr);
		return FALSE;
		}

	/* 
	   Read month, day, year. Each is a one byte binary field. 
	*/
	if((fread(&p->m_month,1,1,p->m_dbf_ptr) == NULL) ||  /* get month */
		(fread(&p->m_day,1,1,p->m_dbf_ptr) == NULL) || /* get day */
		(fread(&p->m_year,1,1,p->m_dbf_ptr) == NULL))  /* get year */
			{
			p->m_error = FIELD_ERROR;
			fclose(p->m_dbf_ptr);
			return FALSE;
			}

	/* 
	   Get the size of records. This is a two-byte binary field.
	*/
	if(fread(&p->m_rsize,2,1,p->m_dbf_ptr) == NULL)
		{
		p->m_error = FIELD_ERROR;
		fclose(p->m_dbf_ptr);
		return FALSE;
		}
	
	/* 
	   Get the actual field descriptors.
	   This is a 32 * 16 byte array.
	*/
	for(i = 0; i < MAX_FIELDS; i++)
		{	
		/* 
		  get the 10 character field name 
		*/
		if(fread(&p->mfd[i].fld_name,1,10,p->m_dbf_ptr) != 10) 
			break;
		
		/* 
		   check for carriage return that marks end of field
		   descriptors
		*/
		if(*(p->mfd[i].fld_name) == '\r') break;

	        /*  
		   translate the field name to uppercase 
		*/ 
		upper(p->mfd[i].fld_name); 

		/* 
		  the next character must be a 0 
		*/
		if((fread(&tmp,1,1,p->m_dbf_ptr) == NULL) || (tmp != 0)) 
			break;

		/* 
		   get the field type either 
			'C' 	character information
			'N' 	numeric information
			'L' 	logical information
		*/
		if(fread(&p->mfd[i].fld_type,1,1,p->m_dbf_ptr) == NULL) 
			break;

		/* 
		   get the field size (0-255)
		*/
		if(fread(&p->mfd[i].fld_width,1,1,p->m_dbf_ptr) == NULL) 
			break;

		/* 
		   skip two bytes dn_used by dBASE 
		*/
		if((fread(&tmp,1,1,p->m_dbf_ptr) == NULL) ||
			(fread(&tmp,1,1,p->m_dbf_ptr) == NULL)) 
				break;

		/* 
		   get the number of decimals beyond decimal point
		*/
		if(fread(&p->mfd[i].fld_prec,1,1,p->m_dbf_ptr) == NULL) 
			break;
		}

	/* 
	   Set the number of fields that have been read.
	*/
	p->m_nflds = (i > MAX_FIELDS) ? MAX_FIELDS : i;


	/* Check to see if user has index file */
	if(p->m_ndx_here == FALSE) goto finished;

	/* OK now for the index file */
	p->m_ndx_ptr = fopen(p->m_ndx_name,"rwb");
	if(!p->m_ndx_ptr)
	   {
	   p->m_ndx_here = FALSE;
	   goto nondx;  	/* couldn't open index file */ 
	   }
	p->m_ndx_here = TRUE;
	
	/* read in the index file header   */
	if(rd_khdr(p) == FALSE) goto ndxerror;

finished:
	p->m_error = SUCCESS;	/* set the error code to good */
	return TRUE;    

ndxerror:              /* have an error reading index file */
	fclose(p->m_ndx_ptr); 
nondx: 
	p->m_error = NDXERROR;
	fclose(p->m_dbf_ptr);
	return FALSE;
}               	/* end dopen */

+ARCHIVE+ doutput.c     2347  8/02/1984 11:10:30
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	doutput:

	Print the record recno to the output file pointed to by recno
	in maxcol format (each line may be up to maxcol in length)
	returns the number of newline characters output so that
	only a pageful can be displayed on the screen at a time.

	This is the function that does the work for the other
	record display functions.

	Returns: The number of lines output

*/
#define COLSTRT 9	/* for tabbing over after a newline */
SINT doutput(p,recno,o,maxcol)
MASTER p; 
RECNO recno;		/* the record number */
FILE *o;		/* the output file pointer */
SINT maxcol;		/* the maximum number of columns of output */
{
SINT i, column, lines;

	/* number of lines emitted */
	lines = 0;

	/* 
	   print the record number and the deleted / not deleted character 
	*/
	fprintf(o,"%05d %c ",recno,p->m_deleted);	

	column = COLSTRT;	/* set column position */

	/* 
	   print out the individual field contents 
	*/
	for(i = 0; i < p->m_nflds; i++)
	   switch(p->mfd[i].fld_type)
		{
		default: goto done_output;

		case CHARACTER:			/* character string */
			/* check wraparound */
			if(column+p->mfd[i].fld_width+1 > maxcol)
			   {
			   fprintf(o,"\n        ");
			   column = COLSTRT; 
			   lines++;
			   }
			fprintf(o,"%-*s ",p->mfd[i].fld_width,
				p->mfd[i].fld_u.string); 
			column += (p->mfd[i].fld_width+1);
			break;

		case NUMERIC:			/* floating point */
			/* check wraparound */
			if(column+p->mfd[i].fld_width+1 > maxcol)
			   {
			   fprintf(o,"\n        ");
			   column=COLSTRT; lines++;
			   }
			fprintf(o,"%*.*lf ",p->mfd[i].fld_width,
				p->mfd[i].fld_prec, 
				p->mfd[i].fld_u.numeric);
			column += (p->mfd[i].fld_width+1);
			break;

		case LOGICAL:				/* logical */	
			/* check wraparound */
			if(column+4 > maxcol)
			   {
			   fprintf(o,"\n        ");
			   column = COLSTRT; 
			   lines++;
			   }
			fprintf(o,".%c. ",p->mfd[i].fld_u.logical);
			column += 4;
			break;
		}

done_output:
	fprintf(o,"\n");	/* 1 newline at end of record */ 
	return (lines+1);
}               		/* end doutput */ 

+ARCHIVE+ dpack.c       3366  9/07/1984 12:19:08
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

#define version "1.10"

main(argc,argv)
int argc;
char *argv[];
{
UCHAR infile[256],outfile[256];
extern UCHAR *upper();

  banner();	/* print copyright message */

  if(argc<3)	/* check correct argument count */
	dpanic("usage:- dpack inputfile[.dbf] outputfile[.dbf]");

  strcpy(infile,upper(argv[1]));	/* fix input file name */
  if(!(index(infile,'.')))strcat(infile,".DBF");

  strcpy(outfile,upper(argv[2]));	/* fix output file name */
  if(!(index(outfile,'.')))strcat(outfile,".DBF");

  dpack(infile,outfile);		/* copy all undeleted records */

  return;
}

banner() 		/* print copyright message to screen */
{
   fprintf(stderr,"DPACK %s\n",version);
   fprintf(stderr,
	"Copyright (C) 1984, Computer Innovations Inc, ALL RIGHTS RESERVED\n");
}

/*
	dpack: copy over all undeleted records
*/
dpack(infile,outfile)
UCHAR *infile,*outfile;
{
MASTER p1,p2;
RECNO recno;

   /* open input file */
   if(dalloc(&p1)==FALSE)
	dpanic("not enough core for file one"); 
   strcpy(p1->m_dbf_name,infile);
   p1->m_ndx_here = FALSE;
   if(!dopen(p1)) 
	dpanic("error opening input file %s",p1->m_dbf_name);

   /* open output file */
   if(dalloc(&p2)==FALSE)dpanic("not enough core for file two");
   strcpy(p2->m_dbf_name,outfile);
   p2->m_ndx_here = FALSE;
   if(!(p2->m_dbf_ptr=fopen(p2->m_dbf_name,"wrb")))
	dpanic("error opening output file %s",p2->m_dbf_name);

   /* initialize output file header */
   p2->m_nrecs = 0;
   p2->m_rsize = p1->m_rsize;
   p2->m_mincore = p1->m_mincore;
   p2->m_month = p1->m_month;
   p2->m_day = p1->m_day;
   p2->m_year = p1->m_year;
   p2->m_error = p1->m_error;
   p2->m_nflds = p1->m_nflds;
   wdbfhdr(p2);		/* write output file header */

   /* copy over all undeleted records */   
   for(recno=1;recno<=p1->m_nrecs;recno++){
      if(!dget_rec(p1,recno))dpanic("couldn't read record %u\n",recno);
      if(p1->m_deleted=='*')continue;
      copyrec(p1,p2);
      if(!dbottom(p2))dpanic("couldn't add another record\n");
      if(!dput_rec(p2,++p2->m_nrecs))
	dpanic("couldn't write record %u\n",p2->m_nrecs);
   }
   wdbfhdr(p2);	/* write new data file header */
   fprintf(stderr,
	"DPACK: %u of %u records written to file: %s\n",
	p2->m_nrecs,p1->m_nrecs,p2->m_dbf_name);

   dclose(p1);	/* close both files */
   dclose(p2);
 
   dfree(p1);	/* free up space */
   dfree(p2);

   return;
}


/*
	copyrec: copy record contents from p1 to p2 (in memory)
*/
copyrec(p1,p2)
MASTER p1,p2;
{
SINT i;

    /* copy all fields */
    for(i=0;i<p1->m_nflds;i++){
	p2->mfd[i].fld_type = p1->mfd[i].fld_type;
	p2->mfd[i].fld_width = p1->mfd[i].fld_width;
	p2->mfd[i].fld_prec = p1->mfd[i].fld_prec;
	strcpy(p2->mfd[i].fld_name,p1->mfd[i].fld_name);
	switch(p1->mfd[i].fld_type){
		default: 
		   dpanic("invalid field in source file");
		   break;
		case CHARACTER:
		   strcpy(p2->mfd[i].fld_u.string,p1->mfd[i].fld_u.string);
		   break;			
		case NUMERIC:
		   p2->mfd[i].fld_u.numeric = p1->mfd[i].fld_u.numeric;
		   break;
		case LOGICAL:
		   p2->mfd[i].fld_u.logical = p1->mfd[i].fld_u.logical;
		   break;
	}
    }
}

+ARCHIVE+ dpanic.c       563  8/09/1984 13:28:46
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/*

	dpanic: print a message and abort

	This is implementation dependent. If you are not using Computer
	Innovations C86, you may have to code something different.

*/

VOID  dpanic(string,arg1)
UCHAR *string,arg1;
{
  int write();

  fprintf(stderr,"\nC to dBASE ERROR:\n");
  _fmtout(&write,fileno(stderr),string,&arg1);
  fprintf(stderr,"\n");
  exit(0x7fff);
}
+ARCHIVE+ dpos.c        1816  8/02/1984 11:10:46

/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SLONG fseek();	/* must declare to return SLONG */ 

/**
	dpos:

	This function positions the READ/WRITE file pointer
	to the beginning of the record addressed by recno.

	Returns:
		TRUE if all the seek was successful
		FALSE if not
*/
BOOL dpos(p,recno) 
MASTER p; 	/* pointer to the master control structure          */
RECNO recno; 	/* the record number to select 		            */
{
SLONG position;		/* where to seek */ 
#define BEGIN 0L	/* for fseek relative to beginning of file */


	/* 
	  Check to see if file will be accessed correctly.

	  Seeking on a unopened file or beyond end of file
	  is not advised. This is not done in the code presented 
	  here. 

	  Note: If you are running under the CPM-86 operating 
		system, you should not seek relative to end of 
		file. The end of a CPM-86 file may not correspond 
		to what you think of as end of file. Writing 
		data after seeking to end of file may result in 
		"holes" in your file. This could create havoc 
		with your dBASE II files. It is suggested that 
		you seek relative to either current position or 
		beginning of file. 
	*/
	if((p->m_error != SUCCESS) || (recno == 0) || (recno > p->m_nrecs)) 
		return FALSE;

	/*  Position to the proper record. */ 
	position = ((SLONG)p->m_rsize * (SLONG)(recno-1)) + (SLONG)DBFHDRLEN;
	if(fseek(p->m_dbf_ptr,position,BEGIN)!=position)	
	   { 
	   fseek(p->m_dbf_ptr,DBFHDRLEN,BEGIN);	/* reset to first record */ 
	   return FALSE;
	   }
	return TRUE; 	/* all set */ 
}               		/* end dpos */ 

+ARCHIVE+ dprt128.c      746  8/02/1984 11:11:50
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SSHORT doutput();  /* output a record */ 
extern FILE *fopen();   /* open a file */ 

/**

	dprt128:

	This function calls doutput with the proper parameters to
	accomplish writing a record to the printer in 128 column format.

	Returns: The number of lines output

*/
SSHORT dprt128(p,recno)
MASTER	p;
RECNO	recno;
{
FILE	*printer;
SSHORT	code; 

	if(!(printer=fopen(PRTFILE,"w")))
           return FALSE; 
	code = doutput(p,recno,printer,WIDE); 
	fclose(printer); 
	return code; 
}

+ARCHIVE+ dprt80.c       746  8/02/1984 11:11:58
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SSHORT doutput(); /* output a record */ 
extern FILE *fopen();    /* open a file */ 

/**

	dprt80:

	This function calls doutput with the proper parameters to
	accomplish writing a record to the printer in 80 column format.

	Returns: The number of lines output

*/
SSHORT dprt80(p,recno)
MASTER  p; 
RECNO	recno;
{
FILE	*printer;
SSHORT	code; 

	if(!(printer=fopen(PRTFILE,"w")))
           return FALSE; 
	code = doutput(p,recno,printer,NARROW);
	fclose(printer); 
	return code; 
}

+ARCHIVE+ dprthdr.c      947  8/02/1984 11:12:16
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL hdrout();   /* output data and index file headers */ 
extern FILE *fopen();   /* open a file */ 

/**
	dprthdr:

	This function calls hdrout specifying the printer as output.
	This will display the directory structure of the file on the
	printer. See hdrout for details.

	Returns: TRUE if successful 
		 FALSE if an error occurs 

*/
BOOL dprthdr(p)
MASTER p;		/* pointer to master control structure */
{
FILE *printer;
SSHORT code; 

	if(!(printer=fopen(PRTFILE,"w")))
	  return FALSE;
	cls(); tos(); 
	newline(10,stdout); 
	printf("\nPrinting header, please wait..."); 
	code = hdrout(p,printer); 
	fclose(printer); 
	newline(10,stdout); 
	pause(); 
	return code;
}       	 
+ARCHIVE+ dput_rec.c     495  8/02/1984 11:12:32
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern  BOOL dpos();
extern  BOOL dwrite();

/*
	dput_rec: write a record to the data file
*/
BOOL  dput_rec(p,r)
MASTER p;               /* pointer to master structure */
RECNO r;               /*  record no. (1 through n) */
{

   if(dpos(p,r))
     {
     dwrite(p);
     return TRUE;
     }
   return FALSE;
}
+ARCHIVE+ dread.c       1716 10/15/1984 09:25:32
#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	dread:  Read a record from the data file into memory. 

	Returns: 
		TRUE if the record was read 
		FALSE if not 

	Note: 
		dposition should be called prior to calling this 
		function so that the read/write pointer will be 
		positioned at the beginning of the record to read. 
		 
		dopen must be called prior to calling this function 
		so that the file will be opened. 

*/
BOOL dread(p)
MASTER p; 	/* pointer to the master control structure */
{
SSHORT i;
UCHAR tmp[BLOCK];
UCHAR *cp;

	/* 
	   get the deleted / not deleted character 
	*/
	if((p->m_deleted=fgetc(p->m_dbf_ptr))==EOF)
		goto read_err; 

	/* 
	   read each field from disk to memory 
	*/
	for(i = 0; i < p->m_nflds; i++)
	   switch(p->mfd[i].fld_type)
	        {
		default: goto read_err; 

		case CHARACTER:         	/* character string */ 
		    if(fread(p->mfd[i].fld_u.string,
			p->mfd[i].fld_width,1,p->m_dbf_ptr) < 1)
				goto read_err;
		    break;

		case NUMERIC:   		/* floating point */ 
		    if(fread(tmp,p->mfd[i].fld_width,1,
			p->m_dbf_ptr) < 1)
				goto read_err; 
		    tmp[p->mfd[i].fld_width]=EOS;
		    if(sscanf(tmp,"%lf",
			&p->mfd[i].fld_u.numeric) != 1)
				{
                                for(cp=tmp;*cp;cp++)
				   if(*cp!=' ')goto read_err; 
				p->mfd[i].fld_u.numeric = 0.0;
				}
		    break;

		case LOGICAL:   			/* boolean */ 
		    if((p->mfd[i].fld_u.logical=fgetc(p->m_dbf_ptr))==EOF)
				goto read_err; 
		    break;
		}
	return TRUE; 

read_err: 
	p->m_error = EDREAD; 
	return FALSE; 
}       		/* end dread */ 




+ARCHIVE+ dreclaim.c    3595  9/07/1984 12:15:04
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

#define version "1.10"
SSHORT verbose=0;

main(argc,argv)
int argc;
char **argv;
{
UCHAR infile[256],outfile[256];
extern UCHAR *upper();

  banner();

  if(argc > 1){		/* check for -v flag */
    if(!strcmp(upper(argv[1]),"-V")){
	verbose=1;
	++argv;
	--argc;
    }
  }

  if(argc<3)		/* see if correct usage */
	dpanic("usage:- DRECLAIM [-v] inputfile[.dbf] outputfile[.dbf]");

  strcpy(infile,upper(argv[1]));	/* fix input file name */
  if(!(index(infile,'.')))strcat(infile,".DBF");

  strcpy(outfile,upper(argv[2]));	/* fix output file name */
  if(!(index(outfile,'.')))strcat(outfile,".DBF");

  dreclaim(infile,outfile);		/* reclaim deleted records */
}

banner()		/* print copyright message */
{
fprintf(stderr,"DRECLAIM %s\n",version);
fprintf(stderr,
"Copyright (C) 1984, Computer Innovations Inc, ALL RIGHTS RESERVED\n");
}

/*
	dreclaim: copy over all records from infile to
		outfile; reclaiming deleted records
*/
dreclaim(infile,outfile)
UCHAR *infile,*outfile;
{
MASTER p1,p2;
RECNO recno;

   /* open input file */
   if(dalloc(&p1)==FALSE)
	dpanic("not enough core for file one"); 
   strcpy(p1->m_dbf_name,infile);
   p1->m_ndx_here = FALSE;
   if(!dopen(p1)) 
	dpanic("error opening input file %s",p1->m_dbf_name);

   /* open output file */
   if(dalloc(&p2)==FALSE)
	dpanic("not enough core for file two");
   strcpy(p2->m_dbf_name,outfile);
   p2->m_ndx_here = FALSE;
   if(!(p2->m_dbf_ptr=fopen(p2->m_dbf_name,"wrb")))
	dpanic("error opening output file %s",p2->m_dbf_name);

   /* initialize output file header */
   p2->m_nrecs = 0;
   p2->m_rsize = p1->m_rsize;
   p2->m_mincore = p1->m_mincore;
   p2->m_month = p1->m_month;
   p2->m_day = p1->m_day;
   p2->m_year = p1->m_year;
   p2->m_error = p1->m_error;
   p2->m_nflds = p1->m_nflds;
   wdbfhdr(p2);
   
   if(verbose)
	fprintf(stderr,"\nProcessing record:\n");

   /* copy over all records, deleted and undeleted */
   for(recno=1;recno<=p1->m_nrecs;recno++){
      if(!dget_rec(p1,recno))dpanic("couldn't read record %u\n",recno);
      copyrec(p1,p2);
      p2->m_deleted = ' ';	/* undelete it */
      if(!dbottom(p2))dpanic("couldn't add another record\n");
      if(!dput_rec(p2,++p2->m_nrecs))
	dpanic("couldn't write record %u\n",p2->m_nrecs);
      if(verbose)
	fprintf(stderr,"\r[%02u]",p2->m_nrecs);
   }
   wdbfhdr(p2);	/* write data file header */

   fprintf(stderr,
	"\nDRECLAIM: %d records written to output file\n",p2->m_nrecs);

   dclose(p1);	/* close input and output files */
   dclose(p2);
   dfree(p1);	/* free memory space */
   dfree(p2);
   return;	/* all over */
}


/*
	copyrec: copy record contents from p1 to p2 (in memory)
*/
copyrec(p1,p2)
MASTER p1,p2;
{
SINT i;

    for(i=0;i<p1->m_nflds;i++){
	p2->mfd[i].fld_type = p1->mfd[i].fld_type;
	p2->mfd[i].fld_width = p1->mfd[i].fld_width;
	p2->mfd[i].fld_prec = p1->mfd[i].fld_prec;
	strcpy(p2->mfd[i].fld_name,p1->mfd[i].fld_name);
	switch(p1->mfd[i].fld_type){
		default: 
		   dpanic("invalid field in source file");
		   break;
		case CHARACTER:
		   strcpy(p2->mfd[i].fld_u.string,
			  p1->mfd[i].fld_u.string);
		   break;			
		case NUMERIC:
		   p2->mfd[i].fld_u.numeric = p1->mfd[i].fld_u.numeric;
		   break;
		case LOGICAL:
		   p2->mfd[i].fld_u.logical = p1->mfd[i].fld_u.logical;
		   break;
	}
    }
}

+ARCHIVE+ dscreen.c      600  8/02/1984 11:12:54
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SINT doutput();   /* output a record */ 

/**

	dscreen:

	This function calls doutput with the proper parameters to
	accomplish writing a record to the screen in 80 column format.

	Returns: The number of lines output

*/
SINT dscreen(p,recno)
MASTER p; 
RECNO recno;		/* the number of the record */
{

	return doutput(p,recno,stdout,NARROW);
}

+ARCHIVE+ dscrhdr.c      748  8/02/1984 11:13:08
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/



#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL hdrout();	/* output the header records */ 
extern VOID cls();      /* clear the screen */ 
extern VOID tos();      /* position to top of screen */ 

/**
	dscrhdr:

	This function calls hdrout specifying the screen as output.
	This will display the directory structure of the file on the
	screen. See hdrout for details.

	Returns: TRUE if successful
		 FALSE if not 
*/
BOOL dscrhdr(p)
MASTER p;		/* pointer to the master control structure */
{
	cls(); tos();
	return hdrout(p,stdout);
}
+ARCHIVE+ dwrite.c      2077 10/15/1984 11:20:10
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	dwrite: write a single record to the dBASE data file. 

	Returns: Nothing. 
	 
	NOTE: The program will abort if a write error occurs. 
                                                                       
		dposition MUST be called prior to calling this function 
	    	so that the read/write pointer will be positioned at	       
		the beginning of the proper record. 

		dopen must be called prior to calling this function 
		so that the file will be opened. If you get a  
		WRITE error, it's probably because you didn't  
		open the file correctly. 

*/
VOID dwrite(p)	/* write a record to the file */
MASTER p; 	/* pointer to the master control structure */
{
SSHORT  i;
UCHAR   tmp[BLOCK];

	/* 
	   write the deleted / not deleted character 
	*/

	if(fputc(p->m_deleted,p->m_dbf_ptr)==EOF)
		goto write_error;

	/* 
	   write each field from memory to disk
	*/

	for(i = 0; i < p->m_nflds; i++)
	   switch(p->mfd[i].fld_type)
		{
		default: goto done_write;

		case CHARACTER: 		/* character string */ 
			sprintf(tmp,"%*s",p->mfd[i].fld_width,
				p->mfd[i].fld_u.string); 
			/* limit the length */
			truncate(tmp,p->mfd[i].fld_width);   
			/* write out the string */ 
			if(!fwrite(tmp,strlen(tmp),1,p->m_dbf_ptr)) 
			   goto write_error;
			break;

		case NUMERIC:           	/* floating point */ 
			sprintf(tmp,"%*.*lf",
				p->mfd[i].fld_width,p->mfd[i].fld_prec, 
				p->mfd[i].fld_u.numeric);
			truncate(tmp,p->mfd[i].fld_width);

			if(!fwrite(tmp,strlen(tmp),1,p->m_dbf_ptr)) 
			   goto write_error;
			break;

		case LOGICAL:   		/* boolean */
			if(fputc(p->mfd[i].fld_u.logical,p->m_dbf_ptr)==EOF)
			   goto write_error;
			break;
		}

done_write:
	return;

write_error:
	dpanic("Write Error has occured\n");
}               	/* end dwrite */ 

+ARCHIVE+ fet_node.c     787  8/09/1984 12:26:26
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL pos_node(); /* position to a node in index file */ 
extern BOOL rd_node();  /* read in the node from index file */ 

/** 
	fet_node: read node nn from disk into ln 

	return TRUE if sucessful	 
	return FALSE if error 

*/ 

BOOL fet_node(p,ln,nn) 
MASTER p;       	/* pointer to master structure */ 
NODE *ln;		/* pointer to node to fetch into */ 
RECNO nn;       	/* number of node to read */ 
{ 

   ln->dn_nnode = nn; 
   if(pos_node(p,nn) && rd_node(p,ln)){
	ln->dn_dirty = 0; 
	return TRUE;
   }
   return FALSE;
} 


+ARCHIVE+ filerecs.c    2282  8/09/1984 12:26:42
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern UCHAR *calloc();
extern FILE *fopen();
extern VOID cls();
extern VOID tos();
extern VOID newline();
extern BOOL gbounds();

/**
	filerecs:

	This function is provided to direct display of records to a file.
	This is NOT a way of writing records to a dBASE file, but rather
	is a way of printing the records to a file that can be edited with
	a standard text editor. This function does a PRINT to DISK FILE
	in the same format as it would be sent to the printer.

	Returns: Nothing. 

*/
VOID filerecs(p,no_cols)
MASTER p;	/* pointer to the master control structure */
SSHORT no_cols;	/* number of columns of output     */
{
RECNO 	begin,		/* beginning, ending, and current record no. */ 
	end, 
	rec; 
UCHAR  *tmp;		/* a place to store the file name */
FILE   *outptr;         /* output file pointer */ 

	cls();
	tos();

	/* get run-time space for filename */
	tmp = calloc(BLOCK,1);

	/* get the file name */
	printf("\n\nName of output file > ");
	if(fgets(tmp,BLOCK,stdin) == 0 || *tmp == '\n')
	   {
	   free(tmp);
	   return;
	   }

	*(tmp+strlen(tmp)-1)=EOS;	/* chop off newline character */ 

	/* open the file for ASCII write */
	if((outptr=fopen(tmp,"w")) == 0)
	   {
	   printf("\nFile %s not opened\n",tmp);
	   return;
	   }

	/*
	   Get beginning and end record numbers and write records.
	   This code is intentionally the same as for the function
	   rprint except that the output is directed to the file.
	*/
	if(gbounds(p,&begin,&end))
	   {
	   cls(); tos(); 
	   newline(10,stdout);
	   printf("\n\t\tPrinting records to file %s, please wait...",tmp); 
	   newline(2,outptr);
	   for(rec = begin; rec <= end; rec++)
		{
		if(!dpos(p,rec)) break;    /* position file ptr */ 
		if(!dread(p)) break;    	/* read record from disk */ 
		if(no_cols == WIDE)     	/* write to disk file */ 
			ddisk128(p,rec,outptr);	
		else
			ddisk80(p,rec,outptr);	
		}
	   newline(2,stdout); 
	   }

	fclose(outptr);		/* close output file */ 
	free(tmp);      	/* release memory */ 
	return;          
}       			/* end filerecs */ 
+ARCHIVE+ find_fk.c     1213  8/09/1984 12:27:00
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern  SINT get_node();	/* get node from cache */ 

/**
	find_fk:

	work routine for locate on index, does the actual search

	Returns: the record number associated with the key (if found)
		 0 if not found.

*/
RECNO find_fk(p,no,val)
MASTER p;		/* pointer to master structure */
RECNO no;		/* root number 		  */
DOUBLE val;		/* the value to look for  */
{
NODE *np;		/* node pointer */
SINT  ky;		/* key offset   */

	if(no == 0) return 0; 

 	np = p->mno[get_node(p,no)]; 
	for(ky = 0; ky < np->dn_nkeys; ky++) 
	   {
	   if(*(np->dn_leaf[ky]->key_val.fkey) == val) 
			{
		   keycpy(p,p->mndx->ndx_kcurr,np->dn_leaf[ky]);
			return np->dn_leaf[ky]->key_rno;       /* got it */ 
			}
	   if(*(np->dn_leaf[ky]->key_val.fkey) > val) 
		break;          		/* it's not here */ 
	   } 

	if(np->dn_leaf[ky]->key_pll)   /*  look in lower level */ 
	  {
	  return find_fk(p,np->dn_leaf[ky]->key_pll,val); 
	  }

	return 0;
}				/* end find_fk */ 


+ARCHIVE+ find_sk.c     1240  8/09/1984 12:27:14
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SSHORT get_node();	/* get a node from the cache */ 

/**
	find_sk:

	work routine for klocate, does the actual search

	Returns: the record number associated with the key, if found, 
		 0 if not found. 

*/
RECNO find_sk(p,no,str)
MASTER p;	        /* pointer to master structure */
RECNO no;		/* root number 		  */
UCHAR *str;		/* the string to look for */
{
UINT  ky;     /*  key index   */ 
NODE    *np;	/* node pointer */ 

	if(no==0) return 0; 
	np = p->mno[get_node(p,no)]; 
	for(ky = 0; ky < np->dn_nkeys; ky++) 
	  { 
	  SSHORT  stat; 
	  if((stat = strncmp(np->dn_leaf[ky]->key_val.ckey,str,
		strlen(str)))==0)
	     {
	     /* set current key to this one */
	     keycpy(p,p->mndx->ndx_kcurr,np->dn_leaf[ky]);
	     return np->dn_leaf[ky]->key_rno; 
	     }
	  if(stat > 0)
		break; 
	  } 

	if(np->dn_leaf[ky]->key_pll)	/* look in lower level node */ 
	   {
	   return find_sk(p,np->dn_leaf[ky]->key_pll,str); 
	   }
	return 0;
}				/* end find_sk */ 

+ARCHIVE+ fptodb.c      1028  8/09/1984 12:27:24
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	fptodb:

	create dbase floating point key string from floating point value.

	Returns: Nothing.
*/
VOID fptodb(val,str)
DOUBLE val;
UCHAR  *str;
{
UCHAR *tmp, buf[BLOCK];
SSHORT pos, dot; 

	/* check zero */ 
	if(val == 0) 
	  {
	  setmem(str,strlen(str),0);
	  return;
	  }

	tmp = buf; 
	sprintf(buf,"%lf",val);
	pos = 2;
	dot = 0; 
	while(*tmp == '0') tmp++;
	while(*tmp)
	   { 
	   if(*tmp == '.') { dot = pos-3; tmp++; continue; }
	   if((*tmp == '-') || (!isdigit(*tmp))) { tmp++; continue; } 
	   if(pos%2)
	     *(str+(pos/2)) += ((*tmp - '0')&0x0f); 
	   else 
	     *(str+(pos/2)) += ((*tmp - '0') << 4);
	   pos++, tmp++; 
	   } 

	*str = 0x40 + dot;
	if(val < 0)
	   *str |= (unsigned char) 0x80;
	return; 
}               	/* end fptodb */

+ARCHIVE+ gbounds.c     2240  8/09/1984 12:27:36
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern VOID cls(); 
extern VOID tos(); 

/**
	gbounds:

	This function gets the beginning and ending record numbers
	for a display/print/file operation. The user is prompted
	for these numbers and they are checked for validity. If
	a record is selected that is out of range, the user is given
	the range and asked again. Note that the parameters 'beg' and
	'end' are assumed to be pointers and as such the function
	should be called with the addresses of the variables to set.

	Returns: TRUE if successful 
		 FALSE otherwise 

*/
BOOL gbounds(p,beg,end)
MASTER p; 
RECNO *beg, *end;		/* note the pointers */
{
UCHAR tmp[BLOCK];		/* place to put a string */

	cls();
	tos();

	/* see if there are any records in the data base */ 
	if(p->m_nrecs == 0) 
	  { 
	  printf("\n\nThere are no records in the data base\n"); 
	  pause(); 
	  return FALSE; 
	  } 

	/* tell user what's available */
	printf("\n\nRecord range is from 1 to %u",p->m_nrecs);

	/* get beginning record number */
	fputs("\n\nPlease Enter Beginning Record Number > ",stdout);
	
	/* get string from user */
	if(fgets(tmp,BLOCK,stdin) == 0 || *tmp == '\n') return FALSE;
	
	/* convert the string to it's decimal value */
	if(sscanf(tmp,"%d",beg) == 0 || *beg == 0)
		return(gbounds(p,beg,end));
	
	/* get ending record number */
	fputs("\nPlease Enter Ending Record Number > ",stdout);

	/* get string from user */
	if(fgets(tmp,BLOCK,stdin) == 0) return FALSE; 

	/* if user types [RETURN] then have end = beg */ 
	if(*tmp == '\n') 
	  { 
	  *end = *beg; 
	  goto validate; 
	  } 

	/* convert ascii string to integer using sscanf */
	if(sscanf(tmp,"%d",end) == 0) 
	      return(gbounds(beg,end,p));

	/* check if valid responses have been given */
	if(*beg > *end)
	   {
	   printf("\n%u is greater than %u\n",*beg, *end);
	   return(gbounds(beg,end,p));
	   }
validate: 
	/* check validity of selection */
	if((*end > p->m_nrecs) || (*beg > p->m_nrecs))
		return(gbounds(beg,end,p));

	/* ok now, return */
	return TRUE;	
}

+ARCHIVE+ get_date.c     759  8/09/1984 12:28:00
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

/*
	get_date: 
	get date from user into p->m_month,p->m_day,p->m_year 
	returns: nothing 
*/ 
get_date(p) 
MASTER p; 
{ 
UCHAR buffer[BLOCK],*cp;
SINT mm,dd,yy; 

   printf("\nEnter mm dd yy: "); 

   if((fgets(buffer,BLOCK,stdin)==0) || buffer[0]=='\n'){ 
	p->m_month = p->m_day = p->m_year =  0; 
   } 

   for(cp=buffer;*cp;cp++) 
	if(*cp==':' || *cp=='/' || *cp=='-')    
		*cp=' '; 

   if(sscanf(buffer,"%d %d %d",&mm,&dd,&yy)<3) 
	return; 

   p->m_month = mm; 
   p->m_day = dd; 
   p->m_year = (yy>1900)?yy-1900:yy; 
   return; 
} 












+ARCHIVE+ get_next.c     577  8/09/1984 13:29:28
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID  st_init();
extern RECNO gt_first();
extern RECNO do_gnext();

/*

  	get_next:  return the record number of  the next key associated
				  with the index file.

	Returns: The record number or 0 if an empty index

*/
RECNO get_next(p)
MASTER  p;
{
	
     if(p->mndx->ndx_kcurr->key_rno == 0)
  	   return gt_first(p);
     st_init();
     return do_gnext(p,p->mndx->ndx_root);
}

+ARCHIVE+ get_node.c    1947  8/09/1984 12:28:08
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL fet_node(); /* fetch a node from disk */ 
extern BOOL nflush();   /* flush a node to disk if dirty */ 

/**
	get_node:

	find node r.
	if necessary, flush a node, read in from disk, etc.

	return index in p->mno[] if success 
	abort if no success.

	there should be no reason not to abort if an error occurs

	WARNING: do not call this function with a ZERO  
		 or with a node number that does not 
		 exist in the index file. 

*/
SSHORT get_node(p,r)
MASTER p;       	/* pointer to master struct */ 
RECNO r;       	/* node number to look for */ 
{ 
SSHORT i; 
SSHORT min;

  /* node numbers are 1 through n */ 
  if(r==0) goto error; 

  /* see if it's already here  */ 
  for(i = 0; i < p->mndx->ndx_nblocks; i++)
   { 
   if(p->mno[i]->dn_nnode==r)
		{ 
		p->mno[i]->dn_used++;	/* say we referenced it */   
		return i; 
		} 
   } 

  /* see if there is a free block available */ 
  for(i = 0; i < p->mndx->ndx_nblocks; i++)
    { 
    if(p->mno[i]->dn_nnode==0)    	/* it's free */ 
		{ 
		if(fet_node(p,p->mno[i],r) == FALSE) 
	   	goto error; 
      p->mno[i]->dn_used++;     	/* say we've used it */ 
		return i;               	/* and return it     */   
      } 
    } 

  /* take the least dn_used block first */ 
  for(min = 0,i = 1; i < p->mndx->ndx_nblocks; i++) 
    if(p->mno[i]->dn_used < p->mno[min]->dn_used) min = i;

  /* flush it out */ 
  if(nflush(p,p->mno[min]) == FALSE) goto error; 

  /* say we've used it and return it */ 
  p->mno[min]->dn_used = 1;   
  if(fet_node(p,p->mno[min],r) == FALSE) goto error;
  return min; 

error: 
  dpanic("get_node: couldn't find node: %u, p->m_error=%u ",r,p->m_error); 
} 


+ARCHIVE+ getrecno.c    1612  8/09/1984 12:29:10
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern  VOID cls(); 
extern  VOID tos(); 

/**
	getrecno:

	This function asks the user for a record number to update.
	If the user responds by striking the [RETURN] key only, it
	is assumed that no update is requested. Otherwise, the
	record number requested is checked to see if it is in the
	range of records. If it is out of range, than the user is
	asked again.

	Returns: 
		TRUE if a number was read from the console 
		FALSE if not 

*/
BOOL getrecno(p,rec)
MASTER p; 
RECNO *rec;		/* pointer to the record number needed */
{
UCHAR tmp[BLOCK];	/* a string to hold responses */

	cls(); 
	tos(); 

	/* check if there are any */ 
	if(p->m_nrecs == 0) 
	  { 
	  printf("\n\nThe data base is empty\n"); 
	  return FALSE; 
	  } 

	/* prompt user for a record number */
	printf("\n\nRecords are in the range 1 to %u",p->m_nrecs);

	printf("\n\nPlease Enter Record Number > ");
	
	/* get the answer string */
	if(!fgets(tmp,BLOCK,stdin)) return FALSE;
	
	/*
	   If the user types only a [RETURN] then it signifies
	   that the user doesn't want to do any more records.
	*/
	  
	if(*tmp == '\n') return FALSE;

	/* convert string to a number pointed to by 'rec' */
	if(sscanf(tmp,"%d",rec) == 0) 
		return(getrecno(p,rec));

	/* check if the answer is a valid one */
	if((*rec > p->m_nrecs) || (*rec == 0))
		return(getrecno(p,rec));

	/* all done, input successful */
	return TRUE;
}

+ARCHIVE+ gt_first.c     667  8/09/1984 13:29:44
#include <stdio.h>
#include <c2dbase.h>

extern SINT get_node();
extern VOID keycpy();

/*

	gt_first: return the record number of the first key in the
		   index and set the current key field in the index
		   structure to point to it.

	Returns:  0 if it's an empty index.

*/

RECNO gt_first(p)
MASTER p;
{
NODE  *np;

   for(np = p->mno[get_node(p,p->mndx->ndx_root)];
	  np->dn_leaf[0]->key_pll && np->dn_nkeys;
	    np = p->mno[get_node(p,np->dn_leaf[0]->key_pll)])
	  		;
   
	if(np->dn_nkeys)
	  {
	  keycpy(p,p->mndx->ndx_kcurr,np->dn_leaf[0]);
	  return np->dn_leaf[0]->key_rno;
	  }

   return 0;		/* empty index */
}


+ARCHIVE+ hdrout.c      3465  8/09/1984 12:29:18
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern VOID cls();      	/* clear screen */
extern VOID tos();      	/* top of screen */
extern VOID pause();    	/* wait for key */
extern UINT coreleft();       /* check data space */

/**

	hdrout:

	This function will print the directory structure of the file
	to the file pointed to by o. The file is assumed to be already
	opened for WRITE in ASCII mode. 'stdout' comes normally this way,
	and the global file pointer 'stdprn' has been set up this way
	in this program. 

	Returns: TRUE if called with valid file pointer
		 FALSE  if not
*/

BOOL hdrout(p,o)
MASTER p;	/* pointer to master control structure */
FILE *o;	/* output file pointer 	          */
{
static UCHAR *nltabtab = "\n                ";
static UCHAR *nltab = "\n        ";
SSHORT i;

	if(!o) return FALSE;

	/* write out the structure to the output file pointer */
	
	fprintf(o,"%sSTRUCTURE OF THE DATA BASE\n",nltabtab);
	fprintf(o,"%sDATA FILE NAME    : %s",nltab,p->m_dbf_name);
	fprintf(o,"%sNUMBER OF RECORDS : %u",nltab,p->m_nrecs);
	fprintf(o,"%sLAST UPDATE       : %02u/%02u/%02u",nltab, 
		p->m_month,p->m_day,p->m_year);
	fprintf(o,"%sRECORD SIZE       : %u",nltab,p->m_rsize);

	fprintf(o,"%sFIELD DESCRIPTORS :\n%s",nltab,nltab);

	/* print heading */
	fprintf(o,
	   "NUMBER        NAME         TYPE      SIZE      DECIMALS\n\n");

	/* print fields */
	for(i=0; i<p->m_nflds; i++)
		{
		if(p->mfd[i].fld_width == 0) continue;
		fprintf(o,"%s  %02d     %-10s         %c        %3u",
			nltab, 
			i+1, 		/* record number */
			p->mfd[i].fld_name, 	/* field name */
			p->mfd[i].fld_type, 	/* field type */
			p->mfd[i].fld_width);	/* field size */
		if(p->mfd[i].fld_type == NUMERIC) 
			fprintf(o,"        %3u",	/* no. decimals */
				p->mfd[i].fld_prec);
		}

	/* finished if no index file */
	if(p->m_ndx_here == FALSE) return TRUE;

	/* put out index header */
	if(o==stdout){ 
		pause(); 
		cls(); 
		tos(); 
        } 

	fprintf(o,
	"\n%sSTRUCTURE OF THE INDEX FILE:\n",nltabtab);
	fprintf(o,
	"%sname of the index file      : %s",nltab,p->m_ndx_name);
	fprintf(o,
	"%snode number of root node    : %04u",nltab,p->mndx->ndx_root);
	fprintf(o,
	"%snode number of next node    : %04u",nltab,p->mndx->ndx_next);
	fprintf(o,
	"%slength of key               : %04u",nltab,p->mndx->ndx_lkey);
	fprintf(o,
	"%slength of key + ptr [key+2] : %04u",nltab,p->mndx->ndx_lkp);
	fprintf(o,
	"%smax. num. keys per node     : %04u",nltab,p->mndx->ndx_kmax);
	fprintf(o,
	"%stype of key                 : %s", 
	nltab,p->mndx->ndx_flag ? "NUMERIC" : "CHARACTER"); 
	fprintf(o,
	"%skey expression (ASCII)      : %s\n",nltab,p->mndx->ndx_kexpr);

	if(p->mndx->ndx_flag)        
	   { 
	   fprintf(o,"%sfield width                 : %u",
			nltab,p->mndx->ndx_fwidth); 
	   fprintf(o,"%sno. of decimals             : %u",
 			nltab,p->mndx->ndx_fprec); 
           } 


	fprintf(o,"%sno. of node blocks in memory: %04u", 
				nltab,p->mndx->ndx_nblocks+1); 
	fprintf(o,"%sno. of nodes in index file  : %04u",
				nltab,p->mndx->ndx_ncnt); 
	fprintf(o,"%scoreleft in bytes           : %04u\n",
				nltab,coreleft());
	return TRUE;
}       		/* end hdrout */ 

+ARCHIVE+ icreate.c     1009  7/12/1984 21:54:52
#include <stdio.h>
#include <c2dbase.h>

#define version "1.02x" 

main(argc,argv)
SSHORT argc;
UCHAR **argv;
{


  fprintf(stderr, 
    "icreate %s\n",version); 
  fprintf(stderr,
    "Copyright (C) 1984, Computer Innovations Inc. ALL RIGHTS RESERVED\n");

  if(argc<4) 
     abort("usage:- icreate datafile ndxfile fieldname");
  icreate(argv[1],argv[2],argv[3]); 
}


/* 
  generate a null index file for the data file
*/ 
VOID icreate(dbffile,ndxfile,fieldname) 
UCHAR *dbffile,*ndxfile,*fieldname; 
{ 
MASTER  p; 

	dalloc(&p); 

	strcpy(p->m_dbf_name,dbffile);	 
	if(!index(p->m_dbf_name,'.')) 
	  strcat(p->m_dbf_name,".DBF"); 
	upper(p->m_dbf_name); 

	strcpy(p->m_ndx_name,ndxfile); 
	if(!index(p->m_ndx_name,'.')) 
	  strcat(p->m_ndx_name,".NDX"); 
	upper(p->m_ndx_name); 
	upper(fieldname); 

	if(dnullndx(p,fieldname) == FALSE) 
	  abort("could not create null index %s to %s on %s", 
		p->m_dbf_name,p->m_ndx_name,fieldname); 

	dfree(p); 
} 


+ARCHIVE+ ins_ikey.c    3375  8/09/1984 13:06:34
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>   /* c_to_dbase header file */

extern NODE *new_node();       /* allocate new node */ 
extern NODE *st_pop();         /* pop node pointer */ 
extern VOID set_key();         /* set key value */ 
extern SSHORT get_node();      /* get node from cache */ 
extern BOOL nrefresh();        /* refresh node in cache */ 
extern BOOL spl_node();        /* split up a node */ 
extern VOID rel_node();        /* release memory (free) for a node */
extern VOID nodecpy();          /* copy a node */ 
extern BOOL st_push();          /* push a node pointer on stack */ 
extern VOID st_init();          /* initialize stack for recursion */ 
extern BOOL shift_up();          /* shift keys up one in a node */ 
extern BOOL st_empty();          /* is the stack empty ? */
extern BOOL nfull();             /* is the node full ? */
extern SSHORT keycmp();          /* compare two keys */

/**
   ins_ikey: insert a key into the node list (if possible)

   Returns:

         +1 if all went well
          0 if an error occurred
         -1 if a node was split and reinsert should be tried.

*/

SINT ins_ikey(p,rtnum,kp)
MASTER p;            /* the master struct ptr */
RECNO rtnum;         /* the root number */
KEY *kp;             /* pointer to the key to insert */
{
NODE *lno;	     /* local node pointer */
UINT ky;             /* key index */ 

   if(rtnum == 0) return 0;         	  /* invalid root number */

   lno = p->mno[get_node(p,rtnum)];      /* get node from cache */
   for(ky = 0; ky < lno->dn_nkeys; ky++) /*  where do we put it ? */
     {
     if(keycmp(p,&lno->dn_leaf[ky]->key_val,&kp->key_val) >= 0)
        break;
     }

   if(lno->dn_leaf[ky]->key_pll != 0)       /* recurse */
      {
      NODE *saven; /* save a copy of the node and go down another level */
      SINT success;
      if((saven = new_node(p)) == NULL)     /* get space for node */
         return 0;
      nodecpy(p,saven,lno);
      st_push(saven);
      success = ins_ikey(p,lno->dn_leaf[ky]->key_pll,kp);
      rel_node(p,saven);
      return success;
      }

   if(nfull(p,lno) == TRUE)      /* is there enough room ? */
	return spl_node(p,lno) ? -1 : 0;

   /* insert key in this node and update parent node if necessary */
   if(shift_up(p,lno,ky))      /* make room for one more */
      {
      NODE *pno;
      UKEY *look;
      SINT  in;
      set_key(p,lno,ky,0,kp->key_rno,&kp->key_val); 
      if((st_empty() == FALSE) && ((ky+1) == lno->dn_nkeys))      
         {
         if((pno = st_pop()) == NULL) return 0; /* update parent node */
		   if(ky) look = &lno->dn_leaf[ky-1]->key_val;
			else look = &lno->dn_leaf[0]->key_val;
         for(in = 0; in < pno->dn_nkeys; ++in) 
           { 
           if(keycmp(p,&pno->dn_leaf[in]->key_val,look) == 0)
             {
             set_key(p,pno,in,pno->dn_leaf[in]->key_pll,
                  lno->dn_leaf[ky]->key_rno,&lno->dn_leaf[ky]->key_val); 
             if(nrefresh(p,pno) == FALSE) return 0;
             break;
             }
           } 
         }
      return nrefresh(p,lno);
      }
   return 0;	
}                /* end ins_ikey */ 

+ARCHIVE+ isfldn.c       686  8/09/1984 13:07:00
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h> 
#include <c2dbase.h> 

/* 
	verify that fieldname is valid 
	and set *fldno. 

	data file must already be open 
*/ 
BOOL isfldn(p,fieldname,fldno) 
MASTER p; 
UCHAR *fieldname; 
SSHORT *fldno;		/* pointer to field number */ 
{ 
SSHORT i; 

    /* find field name in array of fields */ 
    for(i = 0; i < p->m_nflds; i++) 
       {                                                       
       if(!strcmp(p->mfd[i].fld_name,fieldname)) 
	   { 
	   *fldno = i; 
	   return TRUE; 
	   } 
       } 
    return FALSE; 
} 

+ARCHIVE+ kadd.c        1087  8/09/1984 13:07:06
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SINT ins_ikey(); /* insert index key */ 
extern VOID st_init();  /* initialize stack */ 

/**
	kadd: 	      Add a key to the index file
		      It is assumed that the record has already
		      been read.

	Returns:
		TRUE if successful
		FALSE otherwise
*/
BOOL kadd(p,recno,str)
MASTER p;         		/* pointer to master structure */
RECNO recno;   	        /* the record to add	       */
UCHAR *str;             	/* address of key string */
{
KEY  ky;
DOUBLE  fvalue;
SINT result;

	if(p->mndx->ndx_flag) 
	  { 
	  sscanf(str,"%lf",&fvalue); 
	  ky.key_val.fkey = &fvalue;
	  } 
	else 
	  { 
	  ky.key_val.ckey = str;
	  }
   ky.key_rno = recno;
 	ky.key_pll = 0;


	/* insert the key in the index file */
	do st_init();
		while((result = ins_ikey(p,p->mndx->ndx_root,&ky)) == -1);
 
  return result == 1;
}


+ARCHIVE+ kalloc.c       838  8/09/1984 13:07:16
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern UINT coreleft(); 
extern UCHAR *calloc(); 

/* 
	kalloc: allocate memory for a leaf and a key 

*/ 
KEY *kalloc(p)
MASTER  p;
{ 
KEY *k; 

  if(coreleft() < p->m_mincore) 
	goto retnull; 

  if((k=(KEY *)calloc(1,sizeof(KEY))) == NULL) 
	goto retnull; 

  if(p->mndx->ndx_flag)      	/* floating point key */ 
    { 
    if((k->key_val.fkey = (DOUBLE *)calloc(1,sizeof(DOUBLE))) == NULL) 
	goto too_bad; 
    } 
  else          		/* character key */ 
    { 
    if((k->key_val.ckey = (UCHAR *)calloc(1,p->mndx->ndx_lkey+1)) == NULL) 
	goto too_bad; 
    } 
    return k; 

too_bad: 
    free(k); 

retnull: 
    return NULL;
} 

+ARCHIVE+ kdisplay.c     747  8/09/1984 13:07:22
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID cls();      	/* clear screen */ 
extern VOID tos();              /* position to 1,1 */ 
extern VOID disp_key();         /* display keys */ 

/**

	kdisplay:

	Display the data base records one at a time in the order indicated
	by the index.

*/
VOID kdisplay(p)
MASTER p;
{
	/* check to see if index file was read correctly */
	if(p->m_ndx_here == FALSE || p->mndx->ndx_root == 0)
	   {
	   p->m_error = NDXERROR;
	   derror(p);
	   return;
	   }

	cls();
	tos();

	/* display records in order */
	disp_key(p,p->mndx->ndx_root);

	return;
}
+ARCHIVE+ keycmp.c       589  8/09/1984 13:07:30
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>


/**

	keycmp: compare two keys

	returns:
	
	-1 if key1 < key2
	 0 if key1 == key2
	+1 if key1 > key2

*/
SSHORT keycmp(p,k1,k2)
MASTER p;
UKEY *k1;
UKEY *k2;
{

    if(p->mndx->ndx_flag) 
      {
      if(*(k1->fkey) > *(k2->fkey)) return +1; 
      if(*(k1->fkey) == *(k2->fkey)) return 0; 
      return -1; 
      } 
    else 
      { 
      return strcmp(k1->ckey,k2->ckey);
      } 
}


+ARCHIVE+ keycpy.c       939  8/09/1984 13:08:22
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

/* 
	keycpy: copy data from key srce to key dest 

	note: does not perform checks to see if the destination 
	      key has enough room. 

	returns: nothing 
*/ 

VOID keycpy(p,dest,srce)
MASTER p;	/* master control structure */ 
KEY *dest;     /* destination key */ 
KEY *srce;     /* source key */ 
{

   if(p->mndx->ndx_flag)
     { 
     *(dest->key_val.fkey) = *(srce->key_val.fkey);
	  } 
   else
	  { 
	  movmem(srce->key_val.ckey,dest->key_val.ckey,p->mndx->ndx_lkey+1);
	  } 
    dest->key_pll = srce->key_pll; 
    dest->key_rno = srce->key_rno; 
}

/*

   If your compiler does not have movmem() define it as follows:


	movmem(srce,dest,cnt) 
   char *srce,*dest; int cnt;
   {
		  while(--cnt) *dest++ = *srce++;
   }

*/

+ARCHIVE+ kfree.c        492  8/09/1984 13:08:30
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

/* 
 	kfree: free up the key and the leaf 
	returns:  Nothing. 
*/ 
VOID kfree(p,k)
MASTER  p; 
KEY *k;
{ 

   if(!k)return; 
   if(p->mndx->ndx_flag) 
     { 
     if(k->key_val.fkey) free(k->key_val.fkey); 
     } 
   else 
     { 
     if(k->key_val.ckey) free(k->key_val.ckey); 
     } 
   free(k); 
} 

+ARCHIVE+ klocate.c     2006  8/09/1984 13:08:44
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c to dbase header file */

extern RECNO find_fk();	/* find numeric key */
extern RECNO find_sk();	/* find character key */
extern RECNO get_next();	/* get next record number */
extern VOID cls();      	/* clear screen */
extern VOID tos();      	/* position to 1,1 */
extern VOID newline();  	/* output n newlines */
extern BOOL dget_rec();		/* read record n */
extern SINT dscreen();	/* write data record to screen */


/**

	klocate:                         

	Search for a given record field in the index and display
	the record.

	Returns:

	TRUE if the record was located and displayed
	FALSE otherwise
*/
BOOL klocate(p)
MASTER p;
{
RECNO recno;   	/* record number */
UCHAR tmp[BLOCK];       /* string temp  */
extern CHAR *fgets();


	/* check to see if index file was read correctly */
	if(p->m_ndx_here == FALSE || p->mndx->ndx_root == 0)
	  {
	  p->m_error = NDXERROR;
	  derror(p);
	  return FALSE;
	  }

	cls();
	tos();

	/* find out what the user wants */
	printf("\n\nThe field is: %s\nWhat would you like to search for ? ",
		p->mndx->ndx_kexpr);

	if((!fgets(tmp,BLOCK,stdin)) || (tmp[0]=='\n'))
	   return FALSE;
	tmp[strlen(tmp)-1] = EOS;	/* remove ending newline */

	/* look for it in the key list */ 
	if(p->mndx->ndx_flag)	  /* floating point key */ 
	  { 
	  DOUBLE val; 
	  sscanf(tmp,"%lf",&val); 
	  recno = find_fk(p,p->mndx->ndx_root,val); 
	  } 
	else   		  	  /* character key */ 
	  recno = find_sk(p,p->mndx->ndx_root,tmp); 

	newline(2,stdout);
	if(!recno)
	   { 
	   printf("\n\t\t%s not found.\n",tmp); 
	   return FALSE; 
	   } 

	do {
		if((dget_rec(p,recno)==0) || (dscreen(p,recno)<1))
			return FALSE;
	} while(do_more() && (recno = get_next(p)));

   return recno > 0;
}				/* end klocate */

+ARCHIVE+ kremove.c      816  8/09/1984 13:08:52
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL rem_ikey(); /* remove index key */ 
extern VOID st_init();	/* initialize stack */

/**
	kremove: Remove index key from list of keys

	Returns: TRUE if key removed, FALSE otherwise

*/
BOOL kremove(p,recno)
MASTER  p;              /* master struct pointer */
RECNO	recno;          /* record number: 1 through n */
{

	if(p->m_ndx_here == FALSE) /* check if index file opened */
	  {
	  p->m_error = NDXERROR;
	  derror(p);
	  return FALSE;
	  }
	st_init();
	return rem_ikey(p,p->mndx->ndx_root,recno);    /* remove key */

}       			/* end kremove */ 


+ARCHIVE+ kshow.c        845  8/09/1984 13:09:00
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>	
#include <c2dbase.h>

extern VOID cls();      	/* clear screen */
extern VOID tos();      	/* top of screen */
extern BOOL do_more();  	/* more ?  */
extern VOID scr_node(); 	/* display node on screen */

/**

	kshow:

	Show the actual keys of the index file on the screen.

*/
VOID kshow(p)
MASTER p;		/* pointer to the master control structure */
{
UINT no;		/* number of node to display */ 

	/* check to see if this is good data */
	if(p->m_ndx_here == FALSE)
	  {
     p->m_error = NDXERROR;
	  derror(p);
	  return;
	  }

	for(no = 1; no <= p->mndx->ndx_ncnt; no++)
	   {
	   cls(); tos(); 
	   scr_node(p,no); 
	   if(do_more() == FALSE) break; 
	   }
	return;
}
+ARCHIVE+ log_up.c      1305  8/09/1984 13:09:10
 /*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/**	
	log_up:

	This function handles updating of logical fields.

	Returns: TRUE if field was updated, FALSE otherwise

*/
BOOL log_up(p,fldno)
MASTER p;
USHORT fldno;	/* the field number to update */
{
static UCHAR *yes = "YyTt";		/* valid TRUE entries  */ 
static UCHAR *no  = "NnFf";      	/* valid FALSE entries */ 
UCHAR tmp[BLOCK]; 
UCHAR *cp; 

	/* display current field contents */
	conout('\r');
	era_eol();
	printf("%-10s :%c:",p->mfd[fldno].fld_name,
		p->mfd[fldno].fld_u.logical);
	cur_bck(2);

	if(fgets(tmp,BLOCK,stdin) == 0 || tmp[0] == '\n')
	   return FALSE; 

	for(cp = tmp; *cp; cp++) 
	  {
	  if(index(yes,*cp)) 
	     {
	     p->mfd[fldno].fld_u.logical = 'T';      /* logical TRUE */ 
	     goto redisplay; 
	     }
	  if(index(no,*cp))
	    {
	    p->mfd[fldno].fld_u.logical = 'F'; 	/* logical FALSE */ 
	    goto redisplay; 
 	    }
	  }
          return FALSE; 

redisplay: 
	/* display new field contents */
	cur_up(1); 
	conout('\r');
	era_eol();
	printf("%-10s :%c:\n",p->mfd[fldno].fld_name,
		p->mfd[fldno].fld_u.logical);
	return TRUE; 
}

+ARCHIVE+ nalloc.c       739  8/09/1984 13:09:18
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern UINT coreleft();       /* data space available */
extern UCHAR *calloc(); 	/* allocate memory */

/*
	nalloc: allocate memory for struct dnode 
		the node pointer table

	returns: pointer to struct dnode
		 or 0 if no memory
*/

NODE *nalloc(p)
MASTER  p;
{ 
NODE *ln; 

   if(coreleft() < p->m_mincore) return  FALSE;
   if((ln = (NODE *)calloc(1,sizeof(NODE))) == NULL)  
	return FALSE; 

   if((ln->dn_leaf =  
       (KEY **)calloc(p->mndx->ndx_kmax+1,sizeof( KEY * ))) == NULL) 
	{	 
	free(ln); 
	return FALSE; 
	} 
   return ln; 
} 
+ARCHIVE+ ndxmake.c     1547  8/09/1984 13:09:28
 /*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

#define version "1.02x" 

main(argc,argv)
SSHORT argc;
UCHAR *argv[];
{

  fprintf(stderr,"NDXMAKE 1.10\n");
  fprintf(stderr,
    "Copyright (C) 1984, Computer Innovations Inc, ALL RIGHTS RESERVED\n");

  if(argc<4) 
     dpanic("usage:- ndxmake datafile ndxfile fieldname");

  icreate(argv[1],argv[2],argv[3]);
  do_dindex(argv[1],argv[2],argv[3]); 
}


/* 

  generate an index file for the data file

*/ 
VOID do_dindex(dbffile,ndxfile,fieldname) 
UCHAR *dbffile,*ndxfile,*fieldname; 
{ 
MASTER  p; 

	dalloc(&p); 	  		 /* get memory for header */

	strcpy(p->m_dbf_name,dbffile);	 /* fix up filenames */
	if(!index(p->m_dbf_name,'.')) 
	  strcat(p->m_dbf_name,".DBF"); 
	upper(p->m_dbf_name); 

	strcpy(p->m_ndx_name,ndxfile); 
	if(!index(p->m_ndx_name,'.')) 
	  strcat(p->m_ndx_name,".NDX"); 
	upper(p->m_ndx_name); 
	upper(fieldname); 

	fprintf(stderr,"\nIndexing from %s to %s on field %s\n", 
		p->m_dbf_name,p->m_ndx_name,fieldname); 

	p->m_ndx_here = TRUE; 
	p->m_mincore = CORE_MIN; 
	p->m_maxnodes = MAXMN;

	if(dopen(p) == FALSE) 				/* open file */
	   dpanic("could not open the index file"); 

	if(doindex(p,fieldname,TRUE) == FALSE)	       /* generate index */
	   dpanic("could not generate an index"); 

	fprintf(stderr,"%u Records Indexed\n",p->m_nrecs);

	dclose(p); 
	dfree(p); 
} 
+ARCHIVE+ new_node.c    1049  8/09/1984 13:09:36
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern NODE *nalloc(); 		/* allocate key pointer table */
extern KEY *kalloc();   	/* allocate key space */ 
extern VOID kfree();    	/* free key space */
extern VOID nfree();    	/* free node space */

/*
	new_node: allocate memory for a new node 
	 
	returns: 

	a pointer to a memory space for the node if successful 
	0 if there was not enough memory	 

*/

NODE *new_node(p)
MASTER p;
{
NODE *ln;       		/* local node pointer */ 
SSHORT lf;      		/* key index */

   /* allocate a node */
   if((ln=nalloc(p)) == NULL)
	goto bad;

   /* allocate the keys */
   for(lf = 0; lf <= p->mndx->ndx_kmax; lf++)
      { 
      if((ln->dn_leaf[lf]=kalloc(p)) == NULL)
	{ 
      	while(--lf >= 0) kfree(p,ln->dn_leaf[lf]); 
	nfree(p,ln);
	goto bad;
	} 
      } 
   if(ln) 
      return ln;
bad:
   return NULL;
}               /* end new_node */ 

+ARCHIVE+ newline.c      492  8/09/1984 13:09:56
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/** 
	newline: put out n newlines to an output file 

	Returns:  nothing.
*/ 
VOID newline(n,output) 
SSHORT  n;              /* number of newlines needed */ 
FILE *output;           /* output file pointer */ 
{ 

	while(n-- > 0) fputc('\n',output); 
} 

+ARCHIVE+ nexam.c        883  8/09/1984 13:10:02
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID cls(); 
extern VOID tos(); 
extern VOID scr_node(); 
extern BOOL do_more(); 

/** 
	nexam: examine a node 

	allows user at the console to look at individual nodes
	in the index file

	returns: nothing.
*/ 
VOID nexam(p) 
MASTER  p; 
{ 
UCHAR buffer[BLOCK]; 
SSHORT no; 

	if(!p->m_ndx_here) return; 

     do { 
again: 
	cls(); 
	tos(); 
	newline(10,stdout); 
	printf("\nValid node numbers are 1 through %d", 
		p->mndx->ndx_ncnt); 
	printf("\nWhat node would you like ? "); 
	if(!fgets(buffer,BLOCK,stdin) || buffer[0]=='\n')	 
		return; 
	no=atoi(buffer); 
	if(no<1 || no>p->mndx->ndx_ncnt) goto again; 
	cls(); 
	tos(); 
	scr_node(p,no); 
	} while(do_more()); 
} 

+ARCHIVE+ nextend.c      763  8/09/1984 13:10:10
/*

                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

extern BOOL pos_node();		/* position to node */

/*
	nextend: extend the index file by one node

	return TRUE if it could be done 
	       FALSE otherwise 
*/
BOOL nextend(p)
MASTER p;
{

  if(pos_node(p,p->mndx->ndx_next))     /* get there */ 
    { 
	 SSHORT i;
    for(i = (SSHORT)NODESIZE;i > 0; i--)
	   fputc(0,p->m_ndx_ptr);
	 if(fflush(p->m_ndx_ptr) == 0)
	   {
      p->mndx->ndx_next++;             /* increment counters */ 
      p->mndx->ndx_ncnt++; 
      return TRUE; 
      }
    } 
  printf("nextend failed"); pause();
  return FALSE;   
}
+ARCHIVE+ nflush.c       777  8/09/1984 13:10:20
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern BOOL pos_node(); 	/* position index file ptr */ 
extern BOOL wr_node();  	/* write out the node */ 

/*
	nflush: flush node ln to disk if necessary 

	assumes that file is opened correctly.

	returns: TRUE if the node was written to disk 
		      or no write was necessary 
		 FALSE if an error occurred 

*/ 

BOOL nflush(p,ln) 
MASTER p;       	/* pointer to master structure */ 
NODE *ln;		/* pointer to node */ 
{ 
 
  if(!ln) return FALSE; 
  if(ln->dn_nnode && ln->dn_dirty) 
      { 
      return pos_node(p,ln->dn_nnode) && wr_node(p,ln);    
      } 
  return TRUE; 
} 

+ARCHIVE+ nfree.c        462  8/09/1984 13:10:48
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

/* 
	nfree: free the leaf pointer table and the node ptr itself 

	returns: nothing. 
*/ 
VOID nfree(p,np)
MASTER p;               /* master structure pointer */
NODE *np;		/* pointer to leaf pointer table */
{ 

  if(np && np->dn_leaf){ 
	free(np->dn_leaf); 
	free(np); 
  } 
} 

+ARCHIVE+ nfull.c        390  8/09/1984 13:11:02
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>


/*
	nfull: is this node full ?

	Returns: TRUE if full, FALSE if there is room in the node 
			for another key 
*/

BOOL nfull(p,np)
MASTER p;
NODE *np;
{

   return (np->dn_nkeys >= (p->mndx->ndx_kmax-1));
}
+ARCHIVE+ nodecpy.c      916  8/09/1984 13:11:12
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID keycpy();		/* copy key */ 

/* 
	nodecpy: copy data from node srce to node dest 

	note: does not perform checks to see if the destination 
	      node has enough room. 

	returns: nothing 
*/ 

VOID nodecpy(p,dest,srce)
MASTER p;	/* master control structure */ 
NODE *dest;     /* destination node */ 
NODE *srce;     /* source node */ 
{
SINT lf;

	if(srce == dest) return;

   for(lf = 0; lf < srce->dn_nkeys; lf++) 
	   {
   	keycpy(p,dest->dn_leaf[lf],srce->dn_leaf[lf]); 
		}

   dest->dn_nnode = srce->dn_nnode; 
   dest->dn_dirty = srce->dn_dirty; 
   dest->dn_used  = srce->dn_used; 
   dest->dn_nkeys = srce->dn_nkeys;
   dest->dn_leaf[lf]->key_pll = srce->dn_leaf[lf]->key_pll;
}

+ARCHIVE+ nrefresh.c     705  8/09/1984 13:11:24
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h> 
#include <c2dbase.h> 

extern  SSHORT get_node();	/* get node from cache */ 
extern  VOID nodecpy();		/* copy node */ 

/*  
	nrefresh: update node in the cache

	action:
	 	mark node as dn_dirty
		update node in the cache

	returns: TRUE/FALSE 
*/ 

BOOL nrefresh(p,np) 
MASTER p;       /* pointer to master structure */ 
NODE *np;       /* pointer to node to update */ 
{ 
SSHORT nn; 

   if(!np) return FALSE; 
   nn = get_node(p,np->dn_nnode); 
   nodecpy(p,p->mno[nn],np); 
   p->mno[nn]->dn_dirty = TRUE; 
   return TRUE; 
} 



+ARCHIVE+ num_up.c      1802  8/09/1984 13:12:04
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID truncate();         /* abbreviate string */ 

/**	
	num_up:

	This function handles updating of numeric fields.
	returns: TRUE if the field was changed
		 FALSE if it was not changed
*/
BOOL num_up(p,fldno)
MASTER p;
USHORT fldno;	/* field number to update */
{
UCHAR tmp[BLOCK];		/* for user response */
DOUBLE fltval;			/* floating point value */

	/*
	  Put the current field to the screen.
	*/
	conout('\r');
	era_eol();
	printf("%-10s :",p->mfd[fldno].fld_name);
	printf("%*.*lf:",
		p->mfd[fldno].fld_width,  /* first '*' is field width */
		p->mfd[fldno].fld_prec,	  /* next '*' is precision    */
		p->mfd[fldno].fld_u.numeric);  /* then the number     */

	cur_bck(p->mfd[fldno].fld_width+1);

	/*
           Get and evaluate user response
	*/
	if(fgets(tmp,BLOCK,stdin) == 0 || tmp[0] == '\n')
	   return FALSE;

	truncate(tmp,p->mfd[fldno].fld_width);

	/*
	  sscanf is a C86 library routine that converts it's  arguments
	  under control of a format control string. It is similar to
	  fscanf except that it reads it's input from a string address
	  rather than an input file.
	*/
	if(sscanf(tmp,"%lf",&fltval) == 0)
	    return FALSE;

	/*
	   Save the floating point value
	*/
	p->mfd[fldno].fld_u.numeric = fltval;
	cur_up(1);
	era_eol(); 
	printf("%-10s :",p->mfd[fldno].fld_name);
	printf("%*.*lf:\n",
		p->mfd[fldno].fld_width,  /* first '*' is field width */
		p->mfd[fldno].fld_prec,	  /* next '*' is precision    */
		p->mfd[fldno].fld_u.numeric);  /* then the argument   */

	/* finished , field was updated */
	return TRUE;
}
+ARCHIVE+ pause.c        500  8/09/1984 13:12:12
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

/**
	pause:

	Waits for the user to strike a key before returning.

	Control-C will abort as per the operating system.

	Returns: Nothing. 

*/
VOID pause()
{
static UCHAR *message = "\r\nPress any key to continue....."; 

	outstr(message);
	conin();	/* get a character */
	conout('\r');
	era_eol(); 
	return;    
}	
+ARCHIVE+ pcache.c      1608  8/09/1984 13:12:24
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID cls(); 
extern VOID tos(); 
extern VOID newline(); 
extern VOID pause(); 

/*
	pcache: print memory cache statistics
	to output file o
*/
VOID pcache(p,o)
MASTER p;
FILE *o;
{
extern UINT coreleft();
static UCHAR *tab = "        ";
SSHORT  i,j;

	/* check to see if index file present */
	if(p->m_ndx_here == FALSE || o == NULL)
		return;

	if(o == stdout)
	  {
	  cls();
	  tos();
	  }
	else
	  newline(2,o);

	/* print out statistics */
	fprintf(o,"%sNodes in use in the cache:\n\n",tab);
	for(i = j = 0; i < p->mndx->ndx_nblocks; i++) 
	   { 
	   if(p->mno[i]->dn_nnode == 0) continue; 
	   fprintf(o, 
	   "%s%3d:  node no: %3u  no. keys: %3u  dirty: %c dn_used: %8D\n", 
		tab, 
		i,p->mno[i]->dn_nnode,p->mno[i]->dn_nkeys,
		p->mno[i]->dn_dirty ? 'Y' : 'N',
		p->mno[i]->dn_used); 

	   j++; 
	   } 

	if(o == stdout) pause();
	newline(2,o);
	fprintf(o,
		"%sNumber of nodes in index file  : %5u\n",
		tab,p->mndx->ndx_ncnt+1);
	fprintf(o,
		"%sNumber of used nodes in cache  : %5u\n",tab,j);
	fprintf(o, 
		"%sNumber of free nodes in cache  : %5u\n",
		tab,p->mndx->ndx_nblocks+1-j);
	fprintf(o,
		"%sTotal number of nodes in cache : %5u\n",
		tab,p->mndx->ndx_nblocks+1);
	fprintf(o,
		"%sCoreleft in bytes              : %5u\n",
		tab,coreleft());
	fprintf(o, 
		"%sNumber of reserved bytes       : %5u\n",
		tab,p->m_mincore); 
	if(o == stdout) pause();
}

+ARCHIVE+ pos_node.c     610  8/09/1984 13:12:34
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SLONG fseek();	/* seek to byte offset */

/** 
	pos_node: position ndx file pointer to node nn 
	return TRUE/FALSE 
*/ 

BOOL pos_node(p,nn) 
MASTER p; 
RECNO nn;        	/* node to position to: (numbered 1 to n) */ 
{ 

   if(fseek(p->m_ndx_ptr,NODESIZE * (SLONG)nn,0)==(NODESIZE * (SLONG)nn))
	return TRUE; 
   p->m_error = EPOS_NODE;
   return FALSE; 
} 


+ARCHIVE+ rappend.c     1668 10/15/1984 11:32:02
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID cls();      	/* clear screen */
extern VOID tos();      	/* position cursor to 1,1 */
extern VOID dinit();    	/* initialize data record in memory */
extern VOID dwrite();   	/* write data record */
extern VOID rfill();    	/* fill record fields */
extern BOOL dbottom();  	/* position to end of data file */
extern BOOL do_more();  	/* more ?  */
extern SLONG  fseek();  	/* seek to byte offset */

/**
	rappend:

	This function is provided to add a record onto the end of a
	data base. Then for each field available the user is given the
	opportunity to change the field contents. When all fields
	have been covered, the record is written to the dBASE file.

	Returns: Nothing.

*/
VOID rappend(p)
MASTER p;	/*  pointer to the master control structure */
{
	
   do   {
	dinit(p);       		/* initialize a new record */ 
	cls();
	tos(); 
	printf("\n\t\t\tRECORD NUMBER %u\n",p->m_nrecs+1);
	rfill(p,0);     		/* get data from terminal */ 
	if(!dbottom(p)) return;		/* position at end of file */ 
	dwrite(p);      		/* write the record */ 
	if(dflush(p)==FALSE)		/* force data to disk */
		dpanic("couldn't flush output file");
	p->m_nrecs++;			/* one more record */ 

	/* write out the number of records */ 
	if(fseek(p->m_dbf_ptr,1L,0) != (-1L))
	   {
	   fwrite(&p->m_nrecs,2,1,p->m_dbf_ptr);
	   fflush(p->m_dbf_ptr);
	   }
	dbottom(p);		/* reset to bottom of data base */ 
	}  while (do_more());
}       		/* end rappend */ 

+ARCHIVE+ rd_khdr.c     4354  8/29/1984 15:06:34
/*

 		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern UINT coreleft();       /* get free data space */
extern SLONG fseek();           /* seek to byte offset */
extern NODE *new_node();        /* allocate memory for node */
extern UCHAR *upper();          /* translate string to upper case */

/**

	rd_khdr:

	Read in the index file header.
	Allocate space for some keys.
	Calculate the number of nodes.

	Assumes that the file is opened successfully.

	Returns: TRUE if header file read correctly
		 FALSE if not
*/
BOOL rd_khdr(p)
MASTER p;
{
SSHORT nn;
SSHORT dummy;
UINT reserve; 

	/* seek to beginning of file */
	if(fseek(p->m_ndx_ptr,0L,0)!=0L) 
		return FALSE;

	/* read 2 reserved bytes */
	if(!fread(&dummy,2,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read number of root node */
	if(!fread(&p->mndx->ndx_root,2,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read number of next node */
	if(!fread(&p->mndx->ndx_next,2,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read length of key */
	if(!fread(&p->mndx->ndx_lkey,1,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read length of key + pointer (key + 2) */
	if(!fread(&p->mndx->ndx_lkp,1,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read maximum number of keys per node */
	if(!fread(&p->mndx->ndx_kmax,1,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read flag, 0 if character, non-0 otherwise */
	if(!fread(&p->mndx->ndx_flag,1,1,p->m_ndx_ptr)) 
		return FALSE;

	/* read key expression in ASCII, terminated by 0 */
	if(!fread(p->mndx->ndx_kexpr,1,100,p->m_ndx_ptr)) 
		return FALSE;

	/* translate the key expression to uppercase */
	upper(p->mndx->ndx_kexpr);

	/* is this indexed on negative key */ 
	if(p->mndx->ndx_kexpr[0] == '-') 
	  dpanic("Cannot process reverse index file"); 

	/* bytes 110 thru 511 (decimal) are garbage   */

	/* if the key is non-character figure out the width and prec */ 
	if(p->mndx->ndx_flag) 
	   { 
	   SSHORT x; 
	   p->mndx->ndx_fwidth = 8;  /* these are arbitrary defaults */ 
	   p->mndx->ndx_fprec = 2; 

	   for(x = 0; x < p->m_nflds; x++) 
	      if(strcmp(p->mfd[x].fld_name,p->mndx->ndx_kexpr) == 0) 
		{ 
		p->mndx->ndx_fwidth = p->mfd[x].fld_width; 
		p->mndx->ndx_fprec  = p->mfd[x].fld_prec; 
		break; 
		} 
	   } 

	/* 
		get memory to be used to hold key for locate/next logic.
		initialize it's record number field to zero.
	*/
   p->mndx->ndx_kcurr = kalloc(p);
   p->mndx->ndx_kcurr->key_rno = 0;

	/* 
	   make sure p->m_maxnodes is in proper range.

	   This is the number of memory buffers we will
	   attempt to allocate memory for. If there is
	   not enough, we will allocate as much as possible.
	   Make sure you set p->m_mincore with the number of
	   bytes you would like reserved for other memory
	   allocation.
	
	   The number of nodes is adjusted as follows:

	   if maxnodes is zero, it is set to the default. 
	   if maxnodes is greater than the maximum, it is set
		the maximum - 1. 
	   if maxnodes is less than the minimum, it is set to the minimum 

	*/ 
	if(p->m_maxnodes == 0) 
		p->m_maxnodes = DEFMN;    /* default */ 
	else if(p->m_maxnodes < MINMN) 
		p->m_maxnodes = MINMN;    /* minimum */ 
	else if(p->m_maxnodes >= MAXMN) 
		p->m_maxnodes = MAXMN-1;  /* maximum */ 

	/* 
	   calculate number of bytes to reserve for 
	   recursive stack operations for searching 
	   and modification of index keys: 
	*/ 

	reserve = p->mndx->ndx_lkey + sizeof(KEY) + sizeof(KEY *);
	reserve *= p->mndx->ndx_kmax;
	reserve += sizeof(NODE);
	reserve *= (STACKDEPTH+2);    /* enough to recurse plus split root */ 
	reserve += p->m_mincore;        /* amount user asked us to save */ 

	/* allocate some space for nodes in memory */ 
	for(nn = 0; nn < p->m_maxnodes; nn++)
	  {
	  if(coreleft() < reserve) break; 
	  if((p->mno[nn] = (NODE *)new_node(p)) == NULL) break;
     	  p->mno[nn]->dn_used = 
		p->mno[nn]->dn_nnode = 
		p->mno[nn]->dn_dirty = 0;
    	  }
	p->mndx->ndx_nblocks=nn-1; 
        p->mndx->ndx_ncnt = p->mndx->ndx_next; 
	if(p->mndx->ndx_ncnt)p->mndx->ndx_ncnt--;
	return TRUE;
}               		/* end rd_khdr */ 


+ARCHIVE+ rd_node.c     2044  8/09/1984 13:14:18
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern VOID dbtofp();	/* convert dBASE floating point key to 
			   floating point for C */ 

/** 

	rd_node: read node from disk into ln 

	assumes that ndx file pointer is positioned correctly 

	return TRUE/FALSE 
*/ 

BOOL rd_node(p,ln)
MASTER p;               /* pointer to struct master */
NODE *ln;               /* pointer to node to read into */ 
{ 
SSHORT lf;      	/* leaf index */

   /* read the number of keys in this node */
   if(!fread(&ln->dn_nkeys,1,1,p->m_ndx_ptr)) 
		goto badnode; 

   /* initialize in case of null node */
	ln->dn_leaf[0]->key_pll = 0;

   /* read the individual keys and pointers */
   for(lf = 0; lf < ln->dn_nkeys; lf++)	
		{
		KEY *kp;
		kp = ln->dn_leaf[lf];
		if(!fread(&kp->key_pll,2,1,p->m_ndx_ptr)) /* ptr to lower level */
			goto noread; 
		if(!fread(&kp->key_rno,2,1,p->m_ndx_ptr)) /* record number */  
			goto noread; 
		if(p->mndx->ndx_flag)	/* numeric key */ 
		  { 
	  		UCHAR str[BLOCK]; 
	  		setmem(str,BLOCK,0); 
	  		if(!fread(str,1,p->mndx->ndx_lkey-2,p->m_ndx_ptr)) 
				goto noread; 
	  		dbtofp(kp->key_val.fkey,str); 
	 	  } 
		else            	/* character key */ 
	  	  { 
	 	  setmem(kp->key_val.ckey,p->mndx->ndx_lkey,EOS); 
	     if(!fread(kp->key_val.ckey,1,p->mndx->ndx_lkey-2,p->m_ndx_ptr)) 
				goto noread; 
	     kp->key_val.ckey[p->mndx->ndx_lkey-1] = EOS; 
	     } 
	  }

	/* see if this is a null node */
   if((ln->dn_nkeys == 0) ||
	   (ln->dn_leaf[0]->key_pll != 0))
	    	{
			if(fread(&ln->dn_leaf[lf]->key_pll,2,1,p->m_ndx_ptr) != 1)
				goto badnode;
	   	}
	else
		   {
			ln->dn_leaf[lf]->key_pll = 0;
			}

noread:
	if(lf == ln->dn_nkeys)
		return  TRUE;

badnode:
	p->m_error = ERD_NODE;
	return  FALSE;	
}       				/* end rd_node */ 

+ARCHIVE+ rdelete.c      638  8/09/1984 13:14:24
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/


#include <stdio.h>
#include <c2dbase.h>

extern VOID cls();      	/* clear screen */ 
extern VOID tos();      	/* position cursor to 1,1 */ 
extern BOOL getrecno();       /* get record number */ 
extern VOID del_rec();  	/* delete record */ 

/**

	rdelete: call del_rec to mark a record for delete
*/
BOOL rdelete(p)
MASTER p;    
{
RECNO recno;

	cls();
	tos();
	if(getrecno(p,&recno) == 0) return FALSE;
	del_rec(p,recno);
	return TRUE;
}               		/* end rdelete */ 

+ARCHIVE+ rdisplay.c    1448  8/09/1984 13:14:36
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern BOOL gbounds(); 
extern BOOL dpos(); 
extern BOOL dread(); 
extern SSHORT dscreen(); 
extern BOOL do_more(); 

/**
	rdisplay:

	This function prints records on the screen as instructed
	by the user. After a page has been filled do_more() is
	called allowing the user to either continue viewing records
	by striking [RETURN] or return to the main menu by striking
	[ESC].

	Returns: Nothing. 

*/

VOID rdisplay(p)
MASTER p;		/* pointer to the main control structure */
{
#define PAGE 20		/* less than the number of lines on most screens */
RECNO	begin,          /* record number to begin with */ 
	end,    	/* record number to end with */ 
	rec,    	/* record number counter */ 
	linecount;      /* display line counter */ 

	if(gbounds(p,&begin,&end))	/* get record number range */ 
	   {
	   newline(1,stdout);
	   linecount = 1;
	   for(rec = begin; rec <= end; rec++)  /* get requested records */ 
		{
		if(dget_rec(p,rec) == FALSE) break;
		linecount += dscreen(p,rec);    /* display record on screen */ 
		if(linecount >= PAGE)   	/* see if pageful output */ 
		   {
		   linecount = 0;
		   if(!do_more()) break;	/* give user chance to quit */ 
		   }
		}
	   }
	return; 		/* that's all */ 
}       			/* end rdisplay */ 

+ARCHIVE+ reclist.c     1458  8/09/1984 13:30:04
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

/*

	reclist.c :- list all records in data file to stdout

*/
main(argc,argv)
SINT argc; 
CHAR *argv[];
{
extern char *index();
MASTER p;

   fprintf(stderr,"RECLIST 1.10\n");
   fprintf(stderr,
"Copyright (C) 1984 Computer Innovations Inc. ALL RIGHTS RESERVED\n");
   pause();

   if(argc < 2)
	dpanic("usage :- reclist datafile");

   if(dalloc(&p) == FALSE)		/* get memory for structure */
	dpanic("not enough core for memory structure");

   strcpy(p->m_dbf_name,argv[1]);	/* put on .DBF extension   */
   if(!index(p->m_dbf_name,'.'))
	strcat(p->m_dbf_name,".dbf");

   p->m_ndx_here = FALSE;		/* no index file  */
   if(dopen(p) == FALSE)		/* open data file */
     dpanic("could not open data file: %s",p->m_dbf_name);

   do_rlist(p);				/* list the records to stdout */

   dclose(p);				/* close the data file */
   dfree(p);				/* free up allocated memory */
}


/*

   do_rlist: list out records from the data file

*/
VOID do_rlist(p)
MASTER p;
{
RECNO start, end, recno;

  if(gbounds(p,&start,&end))	/* get record range to list */
     {
     for(recno = start; recno <= end; recno++)
	{
	if(dget_rec(p,recno))   /* read the record from the data base */
	   dscreen(p,recno);	/* display on screen		      */
	}
     }
}


+ARCHIVE+ recprint.c    1607  8/09/1984 13:15:24
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

/*

	recprint.c :- print all records in data file to the printer

*/
main(argc,argv)
SINT argc; 
CHAR *argv[];
{
extern char *index();
MASTER p;

   fprintf(stderr,"RECPRINT 1.10\n");
   fprintf(stderr,
   "Copyright (C) 1984 Computer Innovations Inc,  ALL RIGHTS RESERVED\n");
   pause();

   if(argc < 2)
       dpanic("usage :- recprint datafile");

   if(dalloc(&p) == FALSE)		/* get memory for structure */
       dpanic("not enough core for memory structure");

   strcpy(p->m_dbf_name,argv[1]);	/* put on .DBF extension   */
   if(!index(p->m_dbf_name,'.'))
	strcat(p->m_dbf_name,".dbf");

   p->m_ndx_here = FALSE;		/* no index file  */
   if(dopen(p) == FALSE)		/* open data file */
     dpanic("could not open data file: %s",p->m_dbf_name);

   do_rprint(p);			/* print the records */

   dclose(p);				/* close the data file */
   dfree(p);				/* free up allocated memory */
}


/*

   do_rprint: print out records from the data file

*/
VOID do_rprint(p)
MASTER p;
{
RECNO start, end, recno;

  if(gbounds(p,&start,&end))	/* get record range to print */
     {
     fprintf(stderr,"Printing records %u through %u\n",start,end);
     for(recno = start; recno <= end; recno++)
	{
	if(dget_rec(p,recno))   /* read the record from the data base */
	   dprt80(p,recno);	/* print in 80 columns */
	}
     fprintf(stderr,"Records %u through %u printed\n",start,end);
     }
}


+ARCHIVE+ redit.c       1080  8/09/1984 13:14:44
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern BOOL getrecno(); 	/* get record number from console */
extern BOOL rupdate();          /* update a record */
extern VOID pause();    	/* wait for key to be hit */
extern VOID cls();              /* clear screen */
extern VOID tos();      	/* top of screen */

/**
	redit:    edit record in the data file

	This function controls update of sequential data
	records by calling getrecno to ask the user for a
	record number and calling rupdate to update
	the record that the user asked for.

	Returns: Nothing. 

*/

VOID redit(p)
MASTER p;		/* pointer to the master control structure */
{
RECNO recno;   	/* record number */

	cls();
	tos();
	/* getrecno returns FALSE when the user is done */
	while(getrecno(p,&recno))
	   { 
	   if(rupdate(p,recno) == FALSE) 
		goto ouch; 
	   } 
	return;
ouch: 
	printf("\nupdate of record number %u failed\n",recno); 
	pause(); 
}


+ARCHIVE+ rel_node.c     783  8/09/1984 13:14:54
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>
#include <c2dbase.h>

extern VOID kfree();            /* free a key */ 
extern VOID nfree();    	/* free a node */ 

/*
	rel_node: release memory for an entire node

	See new_node for details. This routine is 
	designed to work with new_node(). 

	returns: Nothing 

*/

VOID rel_node(p,np)
MASTER p;       	/* master struct pointer */
NODE *np;               /* pointer to the node   */
{
SSHORT lf;      			 /* key index */

   if(!np) return; 
   for(lf = 0; lf <= p->mndx->ndx_kmax; lf++) /* free the keys */ 
      { 
      kfree(p,np->dn_leaf[lf]); 
      } 
   nfree(p,np); 			 /* free the node */ 
}



+ARCHIVE+ rem_ikey.c    3325  8/09/1984 13:15:04
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern NODE *new_node();	/* allocate new node */
extern NODE *st_pop();     	/* pop node pointer off stack */
extern SSHORT get_node();       /* get node from cache */
extern VOID nodecpy();  	/* copy node */
extern VOID rel_node(); 	/* free node */
extern BOOL st_push();     	/* push node pointer on stack */
extern BOOL shift_dn(); 	/* shift keys in node down by one */
extern BOOL st_empty(); 	/* is the stack empty ? */
extern BOOL nrefresh(); 	/* refresh node in cache */

/**
	rem_ikey:
		remove key(s) associated with record recno 
		from the index 

	Returns: 
		TRUE if successful 
		FALSE otherwise 

*/
BOOL rem_ikey(p,rtnum,recno)
MASTER p;    	/* master structure pointer  */
RECNO rtnum;   /* node number of root node  */
RECNO recno;   /* record number to look for */
{
NODE *lnp;              /* local node pointer */
NODE *pnp;              /* parent node pointer */
SSHORT lf;
BOOL removed;

	removed = FALSE;
	if(rtnum == 0) return FALSE; 

	pnp = lnp = NULL; 
	if((lnp = new_node(p)) == FALSE) return FALSE; 
        nodecpy(p,lnp,p->mno[get_node(p,rtnum)]); 
	 
	/* check each of the keys in the node */ 
	for(lf = 0; lf <= lnp->dn_nkeys; lf++)
	   {
	   SSHORT k;
	   /* if this key points to a lower level node, look in there */ 
	   if(lnp->dn_leaf[lf]->key_pll != 0)
	     {
	     st_push(lnp); 
	     if(rem_ikey(p,lnp->dn_leaf[lf]->key_pll,recno)) 
	        goto good_news;         /* found it */ 
	     if(st_empty() == FALSE) st_pop();	/* pop the stack */ 
	     }
	   /* if this is the extra node, quit */ 
	   if(lf == lnp->dn_nkeys)
		break; 
	   /* if there is no match keep looking */ 
	   if(lnp->dn_leaf[lf]->key_rno != recno)
		continue; 

	   /* move all the keys down one by re-assigning pointers */
	   if(shift_dn(p,lnp,lf) == FALSE)
		goto bad_news; 

	   removed = TRUE; 

	   /* if stack is empty, then we are at root */ 
	   if(st_empty())
		goto good_news;

	   /* check for a key in the parent node */
	   if((pnp = st_pop()) == NULL)  
		goto bad_news; 

	   for(k = 0; k < pnp->dn_nkeys; k++) 
	      { 
	      if(pnp->dn_leaf[k]->key_rno == recno) 
		 { 
		 if(p->mndx->ndx_flag)
		    {
		    *(pnp->dn_leaf[k]->key_val.fkey) = 
			*(lnp->dn_leaf[lf-1]->key_val.fkey);
		    }
		 else
		    {
		    strcpy(pnp->dn_leaf[k]->key_val.ckey,
			lnp->dn_leaf[lf-1]->key_val.ckey); 
		    }
		 pnp->dn_leaf[k]->key_rno = lnp->dn_leaf[lf-1]->key_rno;
	         pnp->dn_leaf[k]->key_pll = lnp->dn_leaf[lf-1]->key_pll; 
		 pnp->dn_dirty = TRUE;
		 if(nrefresh(p,pnp) == FALSE) 
			goto bad_news; 
		 goto good_news; 
		 } 
	       } 
	   if(removed) goto good_news; 
	   } 

	if(!removed)
        	goto bad_news;
good_news:
	if(lnp && lnp->dn_dirty)  /* restore node if necessary */ 
	   { 
	   if(nrefresh(p,lnp) == FALSE) 
		goto bad_news; 
	   } 
	if(lnp) rel_node(p,lnp); 
	return TRUE;

bad_news: 
	/* if we get here, we haven't found it */ 
	if(lnp) rel_node(p,lnp);	/* release node */ 
	return FALSE; 

}       			/* end rem_ikey */ 


+ARCHIVE+ rfill.c       2042  8/09/1984 13:15:14
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern BOOL num_up();        /* update numeric field */
extern BOOL char_up();       /* update character field */
extern BOOL log_up();        /* update logical field */

/**
	rfill: fill up a record, dn_used by append and
		     update_record to get data from the terminal
		     to modify the contents of a record.

	Note: if rec is non-zero, then the record is being updated.

	Returns: TRUE if record fill was successful
		 FALSE if not

*/
BOOL rfill(p,rec)
MASTER p;
RECNO rec;             /* record number (or zero if it's a new record) */
{
USHORT field;

	/*
	  Update the record one field at a time. If the user strikes
	  only a [RETURN] when given the chance to update, then no
	  changes are made to the particular field. When all fields
	  have been processed, the record is written to the dbf file.
	*/

	for(field = 0; field < p->m_nflds; field++)
	   {
	   switch(p->mfd[field].fld_type)
	      {
	      default: goto nogood;

	      case CHARACTER:
	      	if(char_up(p,field) && p->m_ndx_here &&
		    strcmp(p->mfd[field].fld_name,p->mndx->ndx_kexpr) == 0)
		    {
		    if(rec) 
		      { 
		      if(kremove(p,rec) == FALSE) 
			goto nogood; 
		      } 
		    if(kadd(p,rec ? rec : p->m_nrecs+1, 
		       p->mfd[field].fld_u.string) ==  FALSE) 
			goto nogood; 
		    }
		break;

	      case NUMERIC: 	
		if(num_up(p,field) && p->m_ndx_here &&
		   strcmp(p->mfd[field].fld_name,p->mndx->ndx_kexpr) == 0)
		  {
		  UCHAR tmp[BLOCK]; 
		  sprintf(tmp,"%lf",p->mfd[field].fld_u.numeric);
		  if(rec) kremove(p,rec); 
		    { 
		    if(kremove(p,rec) == FALSE) 
			goto nogood; 
		    } 
		  if(kadd(p,rec ? rec : p->m_nrecs+1,tmp) == FALSE) 
			goto nogood; 
		  }
		break;

	     case LOGICAL: 	
		log_up(p,field);
		break;
	     }
	   }

 	return TRUE;
nogood: 
	return FALSE; 
} 
+ARCHIVE+ rprint.c      1125  8/09/1984 13:29:12
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern RECNO gbounds();
extern VOID cls();
extern VOID tos();
extern VOID newline();
extern BOOL dget_rec();
extern SSHORT dprt80();
extern SSHORT dprt128();

/**
	rprint:

	This function writes the records to the printer (PRN: device)
	in either 80 or 128 column format by calling dprt80 or dprt128.

	Returns: Nothing. 

*/

VOID rprint(p,width)
MASTER p;		/* pointer to the master control structure */
SSHORT width;		/* number of columns to put out */
{
RECNO begin, end, rec;

	if(gbounds(p,&begin,&end))	/* get record range */ 
      	   {
	   cls(); tos(); 
	   newline(10,stdout); 
	   printf("\n\t\tPrinting, please wait..."); 
	   for(rec = begin; rec <= end; rec++)  /* print records */ 
	      {
			if(dget_rec(p,rec) == FALSE) break;
	      if(width == WIDE) dprt128(p,rec);
	      else dprt80(p,rec);     	/* WIDE: see c2dbase.h */
	      }
	   newline(2,stdout); 
	   }
	return;
}         		/* end rprint */ 
+ARCHIVE+ rupdate.c     1052 10/15/1984 11:30:56
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern VOID cls(); 
extern VOID tos(); 
extern VOID rfill(); 

extern BOOL dget_rec(); 
extern BOOL dput_rec(); 

/**
	rupdate:

	This function handles update of a given record. The user is shown
	the record. Then for each field available the user is given the
	opportunity to change the field contents. If the user strikes
	only [RETURN], the field is left unchanged. When all fields
	have been covered, the record is written to the dBASE file.

	Returns: TRUE if record successfully updated 
		 FALSE if a problem occurred 
*/
BOOL rupdate(p,rec) 
MASTER p;
RECNO rec;	/*  the record number to update */
{

  cls();  tos(); 
  printf("\n\t\t\tRECORD NUMBER %u\n",rec);

  if(dget_rec(p,rec)) 
    { 
    rfill(p,rec);
    if(dput_rec(p,rec))
	{
	/* flush outstanding data to disk */
	if(dflush(p)) 
	   return TRUE;
	}
    } 
  return FALSE; 
} 

+ARCHIVE+ scr_node.c    1099  8/09/1984 13:15:44
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>
#include <c2dbase.h>

extern SSHORT get_node();	/* get node from cache */

/**
	scr_node: display a node on the screen

	returns: nothing 
*/
VOID scr_node(p,no)
MASTER  p;      	/* master structure pointer */ 
SSHORT  no;     	/* number of node to display */ 
{
SSHORT i; 
SSHORT nn; 

	printf("\n\nNode number: %u\n",no);
	nn = get_node(p,no); 

	printf("\nkey no.     pll    recno     key\n\n");
	for(i = 0; i < p->mno[nn]->dn_nkeys; i++)
	  {
	  KEY *kp;
	  kp = p->mno[nn]->dn_leaf[i];
	  if(kp->key_rno == 0) 
		continue;    /* record number must be non-zero */ 
	  printf("\n  %3u:     %02u     %02u      ",i,
		kp->key_pll,kp->key_rno); 

	  if(p->mndx->ndx_flag)      	/* numeric key */ 
		printf("%*.*lf",p->mndx->ndx_fwidth,
			p->mndx->ndx_fprec,*(kp->key_val.fkey)); 
	  else          		/* character key */ 
		printf("%s",kp->key_val.ckey);
  	  } 
	printf("\npll = %d\n",p->mno[nn]->dn_leaf[i]->key_pll);
}

+ARCHIVE+ sdf_out.c     1254  8/09/1984 13:28:54
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/


#include <stdio.h>
#include <c2dbase.h>

BOOL dget_rec();					/*	read a record into memory */

/*
		sdf_out:

		read the record given by recno and print it out in standard
	   data format.
*/

BOOL sdf_out(p,recno,o,delimiter)
MASTER  p;
RECNO recno;
FILE *o;
UCHAR  delimiter;
{
SINT i;

	/*
		Read the record into memory
	*/

	if(dget_rec(p,recno) == FALSE)
		return FALSE;

	/*
	   print out the individual field contents 
	*/
	for(i = 0; i < p->m_nflds; i++)
	   {
	   switch(p->mfd[i].fld_type)
	  	{
	  	default: return FALSE;

	  	case CHARACTER:			/* character string */
	  		fprintf(o,"%-*.*s",
	  			p->mfd[i].fld_width,p->mfd[i].fld_width,
	  			p->mfd[i].fld_u.string); 
	  		break;

	  	case NUMERIC:			/* floating point */
	  		fprintf(o,"%*.*lf",
	  			p->mfd[i].fld_width,p->mfd[i].fld_prec, 
	  			p->mfd[i].fld_u.numeric);
	  		break;
	  
		case LOGICAL:				/* logical */	
			fprintf(o,"%c",p->mfd[i].fld_u.logical);
			break;
		}
	if(delimiter)
		fputc(delimiter,o);
	}
	fputc('\n',o);
	return TRUE;
}               		/* end doutput */ 


+ARCHIVE+ set_key.c     1135  8/09/1984 13:15:54
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	set_key:

		Fill in the appropriate data for pll,key_rno,key fields
	  	for a key_val. 

	Returns: Nothing.
*/
VOID set_key(p,np,ins,xpll,xrno,uptr)
MASTER  p;
NODE  *np;      	/* node pointer */ 
UINT	ins;    	/* leaf to insert at */
USHORT	xpll;           /* pointer to lower level value */
RECNO	xrno;           /* record number value */
UKEY	*uptr;		/* pointer to key union */
{

	/* assign pointer to lower level, record number, key string */ 
	np->dn_leaf[ins]->key_pll = xpll;
	np->dn_leaf[ins]->key_rno = xrno;
	np->dn_dirty = TRUE;
	if(p->mndx->ndx_flag)
	  { 
     *(np->dn_leaf[ins]->key_val.fkey) = *(uptr->fkey); 
	  } 
	else
	  { 
 	  strncpy(np->dn_leaf[ins]->key_val.ckey,uptr->ckey, 
				p->mndx->ndx_lkey); 
	  np->dn_leaf[ins]->key_val.ckey[p->mndx->ndx_lkey] = EOS; 
	  } 

}       			/* end set_key */ 
                                               
+ARCHIVE+ set_nmax.c    1343  8/09/1984 13:16:02
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>

/*
	set_nmax: 

	Set the number of nodes that will be kept in memory
	for the index file of p. If there is not enough memory
	for this many nodes, rd_khdr() will allocate memory for
	as many as is possible, until coreleft() < p->m_mincore.

	Having 10 to 20 nodes in memory seems to work well
	for most index files.

	This facility is provided so that you may conserve memory
	for operations other than for this index file.

	If you need processing speed, you can set p->m_maxnodes up as
	high as MAXMN. This may be advantageous for some processing
	operations, but for others you may as well keep it low.

	MUST be dn_used prior to dopen(). If this number is changed after
	opening the index file, results may be hazardous.


	Example usage:

	dalloc(&p);
	set_nmax(p,10);
	strcpy(p->m_dbf_name,"DEMO.DBF"); 
	strcpy(p->m_ndx_name,"DEMO.NDX"); 
	p->m_ndx_here = TRUE;	 
	if(dopen(p)==FALSE) dpanic("sorry charlie"); 
	process..... 

	Returns: Nothing. 

*/

VOID set_nmax(p,nbuffers)
MASTER p;       		/* master struct pointer */
SSHORT nbuffers;         	/* number of buffers to alloc */
{

	p->m_maxnodes = nbuffers;
}
+ARCHIVE+ shift_dn.c    1439  8/09/1984 13:16:12
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/** 
	shift_dn:  
		Move all the pointers in the node down by one 
		to remove the key at 'rem'.
		Decrement the number of keys in the node by one. 

	Returns: 
		TRUE if there is room 
		FALSE otherwise 

*/ 

BOOL shift_dn(p,np,rem) 
MASTER   p;               /* pointer to master struct 		 */ 
NODE   *np;		  /* pointer to the node to adjust 	 */ 
USHORT rem;		  /* where the new item will be removed  */	 
{ 
UINT  lf;		  /* leaf index */ 
KEY *save;		  /* temporary key pointer */ 

	/* the idea here is to: 

	  1. save pointer to key to remove
	  2. move all the key pointers above 'rem' 
	     down by one
	  3. use saved pointer for the old key 

	*/ 

	/* are there any keys in the node */ 
	if(np->dn_nkeys == 0) return FALSE; 

	/* save pointer of key to remove */
	save = np->dn_leaf[rem];

	/* shift keys down by one */ 
	for(lf = rem; lf < p->mndx->ndx_kmax-1; lf++)
	  {
	  np->dn_leaf[lf] = np->dn_leaf[lf+1];
	  }

	/* restore saved pointer */	 
	np->dn_leaf[p->mndx->ndx_kmax-1] = save; 

	np->dn_nkeys--;    	/* now we have one less */ 
	np->dn_dirty = TRUE;       /* need to mark as changed */ 
	return TRUE; 
}       		/* end shift_dn */ 


+ARCHIVE+ shift_up.c    1226  8/09/1984 13:16:22
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern VOID  keycpy();	/* copy a key's contents */
extern BOOL nfull();		/* is this node full ? */

/** 
	shift_up:  
		Move all the pointers in the node up by one 
		to make room for a new key to be inserted. 
		Increment the number of keys in the node by one. 

	Returns: 
		TRUE if there is room 
		FALSE otherwise 

*/ 

BOOL shift_up(p,np,ins) 
MASTER   p;               /* pointer to master struct 		 */ 
NODE   *np;		  /* pointer to the node to adjust 	 */ 
USHORT ins;		  /* where the new item will be inserted */	 
{ 
SSHORT i; 
KEY *save;

	/* is there enough room ? */
   if(nfull(p,np) == TRUE)	return FALSE; 

	np->dn_nkeys++;
	/* save new one, move them all up, insert new one */
 	save = np->dn_leaf[i = np->dn_nkeys];
  	for(; i > ins; i--)
  	   {
     	np->dn_leaf[i] = np->dn_leaf[i-1];
     	}
  	np->dn_leaf[ins] = save;
	np->dn_dirty = TRUE;       /* need to mark as changed */ 
	return TRUE; 
}       		/* end shift_up */ 


+ARCHIVE+ spl_node.c    4326  8/09/1984 13:28:38
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>         /* standard header file */
#include <c2dbase.h>	      /* c_to_dbase header file */

extern NODE *st_pop();     /* pop node pointer off stack */
extern NODE *new_node();	/* allocate memory for new node */
extern SSHORT get_node();	/* get node from cache */
extern BOOL shift_up(); 	/* move keys in node up by one */
extern BOOL nextend();  	/* extend index file for one more node */
extern BOOL nrefresh(); 	/* refresh node in cache */
extern VOID rel_node();    /* free memory for node */
extern VOID set_key();		/* set key */ 
extern BOOL st_empty();		/* is the stack empty ? */
extern BOOL nfull();		   /* is the node full ? */

/**
	spl_node:
		split up the node into two nodes, establish a new 
		link to the place where they were split up.


	Returns:
		TRUE if all went well
		FALSE if the node could not be split

	Notes:
		Modifying this code may be hazardous to your data 
		base's health. Take a good look at it before you 
		decide to rework it. 

*/

BOOL spl_node(p,nspl)
MASTER p;       		/* pointer to master struct    */ 
NODE *nspl;         	/* pointer to node to split up */ 
{
NODE 	*npar;			/* parent node pointer */ 
NODE 	*nnew;   		/* new node pointer */ 
NODE  *saven;			/* save node pointer */
KEY	*kp;				/* pointer to key */
UINT	i;				/* loop index */
SINT extra;
SINT stop;
SINT stat;

		if(nspl->dn_nnode != p->mndx->ndx_root)
			{
    	   if((st_empty() == TRUE) || ((npar = st_pop()) == NULL))
				return  FALSE;

		   if(nfull(p,npar) == TRUE)			  /* have to split parent first */
	   	  { 
			  if((saven = new_node(p)) == NULL)	
					return FALSE;
			  nodecpy(p,saven,nspl);
			  stat = spl_node(p,npar);
			  rel_node(p,saven);
			  return (stat && spl_node(p,nspl));
	   	  } 
			}

      /* get memory for new node */
      if((nnew = new_node(p)) == NULL)	return  FALSE;

		/* determine how many keys to copy */
		extra = nspl->dn_leaf[nspl->dn_nkeys]->key_pll;
		if(nspl->dn_nnode == p->mndx->ndx_root)
			{
			if(extra && nspl->dn_nkeys)
				stop = nspl->dn_nkeys - 1;
			else
				stop = nspl->dn_nkeys;
			}
		else
			stop = nspl->dn_nkeys / 2;

		/* copy the first part of the keys over to the new node */
		for(i = 0; i < stop; i++) 
			{
			keycpy(p,nnew->dn_leaf[i],nspl->dn_leaf[i]); 
			}

		nnew->dn_nkeys = stop;
		nnew->dn_leaf[stop]->key_pll = 0;
		nnew->dn_nnode = p->mndx->ndx_next;				

		/*
		   copy the rest of the keys to the beginning of the
			original node 
	   */
		for(i = stop; i < nspl->dn_nkeys; i++)
			{
			keycpy(p,nspl->dn_leaf[i-stop],nspl->dn_leaf[i]);
			}
		nspl->dn_nkeys -= stop;

 	   if(nextend(p) == FALSE)	
			{
			rel_node(p,nnew);
			return FALSE;
			}

	   if(nspl->dn_nnode == p->mndx->ndx_root)	/* it's THE root */
			{
			if(nspl->dn_leaf[nspl->dn_nkeys]->key_pll == 0)
				{
				nspl->dn_leaf[nspl->dn_nkeys]->key_pll = nnew->dn_nnode;
				}
			else
				{
				if(shift_up(p,nspl,0) == FALSE) 
				  {
				  rel_node(p,nnew);
				  return FALSE;
				  }
				set_key(p,nspl,0,nnew->dn_nnode,
							nnew->dn_leaf[nnew->dn_nkeys-1]->key_rno,
							&nnew->dn_leaf[nnew->dn_nkeys-1]->key_val);
				}
		   stat = nrefresh(p,nspl) && nrefresh(p,nnew);
			rel_node(p,nnew);
			return stat;
			}

		nspl->dn_leaf[nspl->dn_nkeys]->key_pll = extra;
		
 		/* establish a pointer to the new node in the parent node */
   	kp = nnew->dn_leaf[nnew->dn_nkeys ? (nnew->dn_nkeys-1) : 0];
   	for(i = 0; i < npar->dn_nkeys; i++)
	  		{
	  		if(keycmp(p,&npar->dn_leaf[i]->key_val,&kp->key_val) >= 0)
				break;
	  		}
		if((i == npar->dn_nkeys) && 
			(i!=0) && 
			(npar->dn_leaf[i]->key_pll == 0))
	 	 	{
	 	 	npar->dn_leaf[i]->key_pll = nnew->dn_nnode;
	 	 	}
		else
			{
			if(shift_up(p,npar,i) == FALSE)
	  			{
	  			rel_node(p,nnew);
				return FALSE;
				}
			set_key(p,npar,i,nnew->dn_nnode,kp->key_rno,&kp->key_val);
			}
		if(nrefresh(p,npar) == FALSE)
			{
			rel_node(p,nnew);
			return FALSE;
			}

  		stat = nrefresh(p,nspl) && nrefresh(p,nnew);
   	rel_node(p,nnew);
		return  stat;

}				 /* end spl_node */ 




+ARCHIVE+ stackop.c     1307  8/09/1984 13:16:36
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/


#include <stdio.h> 
#include <c2dbase.h>

/*
	stack operations:

	The stack is dn_used for recursive descent into the binary
	tree structure. It is needed to provide the parent node
	number in case the parent node needs to be split up.

*/
static struct {
	NODE *store[STACKDEPTH]; 
	SSHORT top;
	} stack;

/**
	st_init: set the stack elements to NULL
*/
VOID st_init() 
{
SSHORT i; 
	for(i = STACKDEPTH-1; i >= 0; i--)
		stack.store[i] = NULL; 
	stack.top = 0;
}

/**
	st_push: push a node address on the stack 

	returns TRUE if stack has room 
	returns FALSE if not 
*/
BOOL st_push(ln) 
NODE *ln;	/* pointer to node to keep */ 
{

	if(st_full()) return FALSE; 

	stack.store[stack.top++] = ln; 
	return TRUE;	 
}

/**
	st_pop: pop the stack and return the value 

	returns: the pointer if okay 
		 or NULL if the stack is empty 
*/ 
NODE *st_pop()
{ 

	if(st_empty()) return NULL;
	return stack.store[--stack.top];
} 

/* 
	st_empty: is the stack empty ? 
*/ 
BOOL st_empty() 
{ 

	return stack.top == 0; 
} 


/* 
	st_full: is the stack full ? 
*/ 
BOOL st_full() 
{ 

	return stack.top+1 >= STACKDEPTH;
} 
+ARCHIVE+ sto_node.c     727  8/09/1984 13:17:20
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern BOOL pos_node();         /* position to node in index file */ 
extern BOOL wr_node();  	/* write node to index file */ 

/** 
	sto_node:

		write np to the disk. 

	return  TRUE   if successful
		FALSE  if error 
*/ 

BOOL sto_node(p,np) 
MASTER p;               	/* master structure pointer */ 
NODE *np;			/* pointer to node */ 
{ 

  if(pos_node(p,np->dn_nnode) && wr_node(p,np)){ 
	np->dn_dirty = FALSE;
	np->dn_nnode = 0; 
	return TRUE; 
  } 
  return FALSE; 
} 


+ARCHIVE+ strncpy.c      574  8/09/1984 13:17:26
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/


#include <stdio.h>
#include <c2dbase.h>

/**
	strncpy:

	Since there has been some confusion as to definitions
	of strncpy, we have included the correct version here
	this version does not always append a NULL

	returns: a pointer to the destination string 

**/
UCHAR *strncpy(to,from,n)
UCHAR *to,*from;
UINT n;
{
  UCHAR *cp;

  for(cp = to;n && (*cp++ = *from++); --n);
  while(n--) *cp++ = 0;
  return to;
}

+ARCHIVE+ terminal.c    2177  8/09/1984 13:27:20
/*
	            C to dBASE II INTERFACE PROGRAM
     Copyright (c) 1983,84 Computer Innovations Inc. All Rights Reserved.
*/


#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/*

	TERMINAL.C - terminal dependent routines

	These routines have been written assuming
	that your terminal has ANSI compatible escape
	sequences. If this is not the case, you will
	have to find out your escape sequences, insert
	them into the code here, and re-compile.

	These codes were selected because they are supposed
	to be standard. If you have an IBM-PC or XT, you
	will not have to modify this code. 

	Note that you have to define ANSI.SYS in order for this
	stuff to work as follows:

	In CONFIG.SYS you must have the following statement.

	DEVICE=ANSI.SYS

	See the DOS Manual about this if necessary.
*/

/**
	cur_up: Move the cursor up by n rows
	Returns: Nothing.
*/
VOID cur_up(n)
SSHORT n;
{
UCHAR tmp[10];
	sprintf(tmp,"\033[%dA",n);
	outstr(tmp);
	return; 
}

/**
	cur_dn: Move the cursor down by n rows
	Returns: Nothing.
*/
VOID cur_dn(n)
SSHORT n;
{
UCHAR tmp[10];
	sprintf(tmp,"\033[%dB",n);
	outstr(tmp);
	return; 
}

/** 
	cur_bck: move the cursor left by n columns
	Returns: Nothing.
*/	
VOID cur_bck(n)
SSHORT n;
{
UCHAR tmp[10]; 
	sprintf(tmp,"\033[%dD",n);
	outstr(tmp);
	return; 
}

/**
	cur_fwd: move the cursor right by n columns
	Returns: Nothing.
*/
VOID cur_fwd(n)
SSHORT n;
{
UCHAR tmp[10]; 
	sprintf(tmp,"\033[%dC",n);
	outstr(tmp);
	return; 
}

/**
	cls: Clear the screen.
	Returns: Nothing.
*/
VOID cls()
{
	outstr("\033[2J");
	return; 
}

/**
	era_eol: erase from current cursor position to end of line

	Returns: Nothing. 
*/
VOID era_eol()
{
	outstr("\033[K");
	return;
}

/**
	tos: position cursor to upper left-hand corner of
		       screen.
	Returns: Nothing.
*/
VOID tos()
{
	outstr("\033[1;1H");
	return; 
}

/**
	outstr: put a string out to the console using
			direct console i/o.

	Returns: Nothing. 
*/
VOID outstr(s)
UCHAR *s;
{
	while(*s)
	   bdos(6,*s++);
}

+ARCHIVE+ truncate.c     580  8/09/1984 13:27:42
/*

		  	C to dBASE INTERFACE 
	    Copyright (C) 1983,84 Computer Innovations Inc
			ALL RIGHTS RESERVED

*/



#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	truncate:
	
	This function limits the length of a string as specified
	by maxchars. This is provided so that fields are not
	overrun on write.

	Returns: Nothing.
*/
VOID truncate(s,maxchars)
UCHAR *s;		/* the string to truncate */ 
SSHORT maxchars;	/* the maximum length 	  */
{
	if(strlen(s) > maxchars) 
		s[maxchars]=EOS; 
}

+ARCHIVE+ upper.c        447  8/09/1984 13:27:54
/*

                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

/**
	upper:  Translate the string to uppercase

	Returns: A pointer to the string 
*/	
UCHAR *upper(s)
UCHAR *s;
{
UCHAR *cp;

	for(cp = s; *cp; cp++)
	    *cp = toupper(*cp);
	return s;
} 

+ARCHIVE+ wdbfhdr.c     2373  8/09/1984 13:28:04
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>
#include <c2dbase.h>


/* write DBF file header */
/* assumes that file is opened and data is in p */
/* returns TRUE if write successful, FALSE otherwise */
wdbfhdr(p)
MASTER p;
{
extern SLONG fseek();
SINT i;
UCHAR tmp;

	/*
	  First, seek to the beginning of the file
	*/
	if(fseek(p->m_dbf_ptr,0L,0)<0L)
		return FALSE;

	/*
	  A dBASE II file must have a 2 as it's first byte
	*/
	tmp = 2;  
	if(fwrite(&tmp,1,1,p->m_dbf_ptr)<1)
		return  FALSE;
	
	/* 
	  Write the number of records in this data base. 
	  This is one 2 byte binary field. 
	*/ 
	if(fwrite(&p->m_nrecs,2,1,p->m_dbf_ptr)<1)
		return FALSE;

	/*  
	  Write month, day, year. Each is a one byte binary field. 
	*/ 
	if((fwrite(&p->m_month,1,1,p->m_dbf_ptr)<1) || 
	   (fwrite(&p->m_day,1,1,p->m_dbf_ptr)<1) || 
	   (fwrite(&p->m_year,1,1,p->m_dbf_ptr)<1)) 
		return FALSE; 

	/* 
	   Write the size of records. This is a two-byte binary field.
	*/
	if(fwrite(&p->m_rsize,2,1,p->m_dbf_ptr)<1)
		return FALSE; 
	
	/* 
	   Write the actual field descriptors.
	   This is a 32 * 16 byte array.
	*/
	for(i = 0; i < p->m_nflds; i++){ 
		/* 
		  put the 10 character field name 
		*/
		if(fwrite(&p->mfd[i].fld_name,1,10,p->m_dbf_ptr) != 10) 
			break;
		
		/* 
		  the next character must be a 0 
		*/
		tmp = 0; 
		if(fwrite(&tmp,1,1,p->m_dbf_ptr)<1)
			return  FALSE; 

		/* 
		   put the field type
		*/
		if(fwrite(&p->mfd[i].fld_type,1,1,p->m_dbf_ptr)<1)
			return FALSE; 

		/* 
		   put the field size (0-255)
		*/
		if(fwrite(&p->mfd[i].fld_width,1,1,p->m_dbf_ptr)<1)
			return  FALSE; 

		/* 
		   put two bytes dn_used by dBASE 
		*/
		if((fwrite(&tmp,1,1,p->m_dbf_ptr)<1) || 
		   (fwrite(&tmp,1,1,p->m_dbf_ptr)<1))
			return  FALSE; 

		/* 
		   put the number of decimals beyond decimal point
		*/
		if(fwrite(&p->mfd[i].fld_prec,1,1,p->m_dbf_ptr)<1)
			return FALSE; 
	}

	/*  
	  Write the carriage return that marks the end of 
	  the field names. 
	*/ 
	if(p->m_nflds<MAX_FIELDS){ 
	  if(fputc('\r',p->m_dbf_ptr)!='\r')
		return FALSE; 
	} 

	while(ftell(p->m_dbf_ptr) < DBFHDRLEN) 
		fputc(0,p->m_dbf_ptr); 

	return TRUE; 
} 



+ARCHIVE+ wr_khdr.c     1463  8/09/1984 13:28:18
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern SLONG fseek();	/* seek to byte offset in file */ 
extern SLONG ftell();

/**

	wr_khdr:   	Write the index file header to disk.
		  	Assumes that the file is opened correctly.

	Returns:	TRUE if all written well 
		 	FALSE if write error occurred 
*/
BOOL wr_khdr(p)
MASTER p;
{

	/* skip 2 reserved bytes */
	if(fseek(p->m_ndx_ptr,2L,0) == -1L)  
		return FALSE;

	/* # of root node */
	if(!fwrite(&p->mndx->ndx_root,2,1,p->m_ndx_ptr))  
		return FALSE; 

	/* # of next node */
	if(!fwrite(&p->mndx->ndx_next,2,1,p->m_ndx_ptr))  
	  	return FALSE; 

	/* length of key */
	if(!fwrite(&p->mndx->ndx_lkey,1,1,p->m_ndx_ptr))  
		return FALSE; 

	/* length of key + 2 */
	if(!fwrite(&p->mndx->ndx_lkp,1,1,p->m_ndx_ptr))  
		return FALSE; 

	/* max keys / node */ 
	if(!fwrite(&p->mndx->ndx_kmax,1,1,p->m_ndx_ptr)) 
		return FALSE; 

	/* character key flag */
	if(!fwrite(&p->mndx->ndx_flag,1,1,p->m_ndx_ptr))  
		return FALSE; 

	/* key expr */ 
	if(!fwrite(&p->mndx->ndx_kexpr,1,p->mndx->ndx_lkey,p->m_ndx_ptr)) 
		return FALSE; 

   while(ftell(p->m_ndx_ptr) < NDXHDROFF)
		fputc(0,p->m_ndx_ptr); 

	return (fflush(p->m_ndx_ptr)==0);

}       			/* end wr_khdr */

+ARCHIVE+ wr_node.c     1888  8/09/1984 13:28:26
/*
                            C to dBASE INTERFACE
     Copyright (C) 1983,84 Computer Innovations Inc. ALL RIGHTS RESERVED
*/

#include <stdio.h>      /* standard header file */
#include <c2dbase.h>	/* c_to_dbase header file */

extern VOID fptodb();	/* C floating point to dBASE floating point */

/** 

	wr_node: write np to the index file 

	assumes that ndx file pointer has been positioned correctly 

	returns: TRUE/FALSE
*/ 

BOOL wr_node(p,np)
MASTER p;               	/* pointer to master structure */
NODE *np;			/* node pointer */ 
{ 
SSHORT	lf;			/* leaf index */ 

   /* write the number of keys in this node */
   if(!fwrite(&np->dn_nkeys,1,1,p->m_ndx_ptr))
		return FALSE;

   /* write the individual keys and pointers */
   for(lf = 0; lf < np->dn_nkeys; lf++)	
	{
	KEY *kp;	/* key pointer */
	kp = np->dn_leaf[lf]; 
	if(!fwrite(&kp->key_pll,2,1,p->m_ndx_ptr)) 
		goto nowrite;   /* word - pointer to lower level */ 

	if(!fwrite(&kp->key_rno,2,1,p->m_ndx_ptr)) 
		goto nowrite;   /* record number */ 

	if(p->mndx->ndx_flag)	/* float key */ 
	  { 
	  UCHAR str[BLOCK];
	  setmem(str,BLOCK,0); 
    	  fptodb(*(kp->key_val.fkey),str); 
	  if(fwrite(str,1,p->mndx->ndx_lkey-2,p->m_ndx_ptr) != 
		p->mndx->ndx_lkey-2) 
	     		goto nowrite; 
	  } 
	else                    /* char key */ 
	  { 
	  if(fwrite(kp->key_val.ckey, 
	     1,p->mndx->ndx_lkey-2,p->m_ndx_ptr) != p->mndx->ndx_lkey-2) 
		goto nowrite; 
	  } 
	}

   /* write extra two bytes if necessary */ 
   if(np->dn_leaf[0]->key_pll != 0) 
		{ 
		if(fwrite(&np->dn_leaf[np->dn_nkeys]->key_pll,2,1,p->m_ndx_ptr) != 1) 
	  	goto nowrite; 
		} 

   if(fflush(p->m_ndx_ptr) == 0)  
		return TRUE;	/* all okay */ 

nowrite:               		/* write failure */ 
     p->m_error = EWR_NODE; 
     return FALSE; 
}       			/* end wr_node */


DERROR  C             k		  DFLUSH  C             mZO	  DFREE   C             )X	8  DGET_RECC             0X	  DINIT   C             5X	  DISP_KEYC             <X	G  DNULLNDXC             CX	  DO_GNEXTC             hTO	v  